/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.alchemist.utils;

import chemaxon.alchemist.utils.AlchemistWaitPanel;
import chemaxon.alchemist.utils.MoleculeTableCellRenderer;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;

public abstract class AbstractAlchemistMoleculeView
extends JPanel {
    private static final long serialVersionUID = 149611228245166836L;
    protected static final String TABLE_PANEL = "tablePanel";
    protected static final String WAIT_PANEL = "waitPanel";
    protected int rowNum;
    protected int colNum;
    protected JTable view = null;
    protected TableModel dataModel = null;
    protected JPanel holderPanel = null;
    protected AlchemistWaitPanel waitPanel = null;
    protected CardLayout layout = new CardLayout();
    private boolean isMoleculeLabelVisible = true;
    private boolean waitMode = false;
    private Dimension minimumSize = null;
    private MoleculeTableCellRenderer renderer = null;

    public AbstractAlchemistMoleculeView(int rowNum, int colNum) {
        this(rowNum, colNum, true);
    }

    public AbstractAlchemistMoleculeView(int rowNum, int colNum, boolean isMoleculeLabelVisible) {
        this.rowNum = rowNum;
        this.colNum = colNum;
        this.isMoleculeLabelVisible = isMoleculeLabelVisible;
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.renderer = new MoleculeTableCellRenderer();
        this.setOpaque(false);
        this.add((Component)this.getHolderPanel(), "Center");
        this.minimumSize = this.getMinimumSize();
    }

    protected JPanel getHolderPanel() {
        if (this.holderPanel == null) {
            this.holderPanel = new JPanel();
            this.holderPanel.setOpaque(false);
            this.holderPanel.setLayout(this.layout);
            this.holderPanel.add((Component)this.getView(), TABLE_PANEL);
            this.holderPanel.add((Component)this.getWaitPanel(), WAIT_PANEL);
            this.layout.show(this.holderPanel, TABLE_PANEL);
        }
        return this.holderPanel;
    }

    protected AlchemistWaitPanel getWaitPanel() {
        if (this.waitPanel == null) {
            this.waitPanel = new AlchemistWaitPanel();
            this.waitPanel.setBackground(Color.WHITE);
            this.waitPanel.setName(WAIT_PANEL);
        }
        return this.waitPanel;
    }

    protected JTable getView() {
        if (this.view == null) {
            this.view = new JTable();
            this.dataModel = new DefaultTableModel(this.rowNum, this.colNum);
            this.view.setModel(this.dataModel);
            this.view.setDefaultRenderer(Object.class, this.renderer);
            this.view.setDefaultEditor(Object.class, null);
            this.view.setRowHeight(this.view.getPreferredSize().height / this.rowNum);
            this.view.setSelectionMode(0);
            this.view.setCellSelectionEnabled(true);
            this.view.setName(TABLE_PANEL);
            if (this.isMoleculeLabelVisible) {
                this.view.putClientProperty("MoleculeTableCellRenderer_isLabelVisible", Boolean.TRUE);
            }
            this.view.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent e) {
                    AbstractAlchemistMoleculeView.this.view.setRowHeight(AbstractAlchemistMoleculeView.this.view.getSize().height / AbstractAlchemistMoleculeView.this.rowNum >= 1 ? AbstractAlchemistMoleculeView.this.view.getSize().height / AbstractAlchemistMoleculeView.this.rowNum : 1);
                    if (AbstractAlchemistMoleculeView.this.minimumSize != null) {
                        AbstractAlchemistMoleculeView.this.view.setMinimumSize(AbstractAlchemistMoleculeView.this.minimumSize);
                    }
                }
            });
        }
        return this.view;
    }

    public void clear() {
        this.dataModel = new DefaultTableModel(this.rowNum, this.colNum);
        this.view.setModel(this.dataModel);
    }

    public boolean isMoleculeLabelVisible() {
        return this.isMoleculeLabelVisible;
    }

    public void setMoleculeLabelVisible(boolean isMoleculeLabelVisible) {
        this.isMoleculeLabelVisible = isMoleculeLabelVisible;
        this.view.putClientProperty("MoleculeTableCellRenderer_isLabelVisible", isMoleculeLabelVisible);
    }

    public int getDispOpts() {
        return this.renderer.getDispOpts();
    }

    public void setDispOpts(int dispOpts) {
        this.renderer.setDispOpts(dispOpts);
    }

    @Override
    public void setMinimumSize(Dimension minimumSize) {
        super.setMinimumSize(minimumSize);
        this.minimumSize = this.getMinimumSize();
    }

    public int getRowCount() {
        return this.rowNum;
    }

    public int getColCount() {
        return this.colNum;
    }

    public boolean isWaitMode() {
        return this.waitMode;
    }

    public void setWaitMode(boolean waitMode) {
        this.waitMode = waitMode;
        if (waitMode) {
            this.layout.show(this.getHolderPanel(), WAIT_PANEL);
        } else {
            this.layout.show(this.getHolderPanel(), TABLE_PANEL);
        }
    }
}

