/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.alchemist.utils;

import chemaxon.alchemist.utils.AlchemistErrorDialog;
import java.lang.reflect.Method;

public class AlchemistBrowserLauncher {
    private static final String ERROR_MESSAGE = "Can not launch browser application";

    public static void launchBrowser(String urlToOpen) {
        String operatingSystem = System.getProperty("os.name");
        try {
            if (operatingSystem.startsWith("Windows")) {
                Runtime.getRuntime().exec("rundll32 url.dll,FileProtocolHandler " + urlToOpen);
                return;
            }
            if (operatingSystem.startsWith("Mac OS")) {
                Class<?> macUtils = Class.forName("com.apple.mrj.MRJFileUtils");
                Class[] myClassArray = new Class[]{String.class};
                Object[] myURLObjectArray = new Object[]{urlToOpen};
                Method launchBrowser = macUtils.getDeclaredMethod("openURL", myClassArray);
                launchBrowser.invoke(null, myURLObjectArray);
                return;
            }
            String[] browsers = new String[]{"firefox", "chromium-browser", "opera", "konqueror", "mozilla", "netscape"};
            String browser = null;
            for (int i = 0; i < browsers.length && browser == null; ++i) {
                if (Runtime.getRuntime().exec(new String[]{"which", browsers[i]}).waitFor() != 0) continue;
                browser = browsers[i];
            }
            if (browser != null) {
                Runtime.getRuntime().exec(new String[]{browser, urlToOpen});
            }
        }
        catch (Exception e) {
            AlchemistErrorDialog.showError(ERROR_MESSAGE, e);
        }
    }
}

