/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.alchemist.utils;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;

public class AlchemistContainer
extends Container {
    private static final long serialVersionUID = -5364026612008584491L;
    private final JSplitPane northSplitter = new JSplitPane(0);
    private final JSplitPane eastSplitter = new JSplitPane(1);
    private final JSplitPane westSplitter = new JSplitPane(1);
    private final JSplitPane southSplitter = new JSplitPane(0);
    private final Map<String, Container> parentMap = new HashMap<String, Container>();
    private final int dividerSize = this.northSplitter.getDividerSize();

    public AlchemistContainer() {
        this.reset();
    }

    private void reset() {
        this.setLayout(new BorderLayout());
        JPanel northPanel = new JPanel(new BorderLayout());
        JPanel southPanel = new JPanel(new BorderLayout());
        JPanel eastPanel = new JPanel(new BorderLayout());
        JPanel westPanel = new JPanel(new BorderLayout());
        JPanel centerPanel = new JPanel(new BorderLayout());
        northPanel.setBorder(null);
        southPanel.setBorder(null);
        eastPanel.setBorder(null);
        westPanel.setBorder(null);
        centerPanel.setBorder(null);
        this.parentMap.put("North", northPanel);
        this.parentMap.put("South", southPanel);
        this.parentMap.put("East", eastPanel);
        this.parentMap.put("West", westPanel);
        this.parentMap.put("Center", centerPanel);
        this.northSplitter.setDividerSize(0);
        this.eastSplitter.setDividerSize(0);
        this.westSplitter.setDividerSize(0);
        this.southSplitter.setDividerSize(0);
        this.northSplitter.setResizeWeight(0.0);
        this.eastSplitter.setResizeWeight(1.0);
        this.westSplitter.setResizeWeight(0.0);
        this.southSplitter.setResizeWeight(1.0);
        this.northSplitter.setBorder(null);
        this.eastSplitter.setBorder(null);
        this.southSplitter.setBorder(null);
        this.westSplitter.setBorder(null);
        this.northSplitter.setTopComponent(northPanel);
        this.northSplitter.setBottomComponent(this.southSplitter);
        this.southSplitter.setTopComponent(this.westSplitter);
        this.southSplitter.setBottomComponent(southPanel);
        this.westSplitter.setLeftComponent(westPanel);
        this.westSplitter.setRightComponent(this.eastSplitter);
        this.eastSplitter.setLeftComponent(centerPanel);
        this.eastSplitter.setRightComponent(eastPanel);
        super.add((Component)this.northSplitter, "Center");
        this.validate();
    }

    @Override
    public Component add(Component comp) {
        this.add(comp, "Center");
        return comp;
    }

    @Override
    public Component add(Component comp, int index) {
        this.add(comp, "Center", index);
        return comp;
    }

    @Override
    public void add(Component comp, Object constraints) {
        this.add(comp, constraints, -1);
    }

    @Override
    public void add(Component comp, Object constraints, int index) {
        this.add(null, comp, constraints, index);
    }

    public void add(String name, Component comp, Object constraints, int index) {
        Container parent = this.parentMap.get(constraints.toString());
        if (parent != null) {
            String newName;
            String string = newName = name == null ? comp.getName() : name;
            if (parent instanceof JTabbedPane) {
                ((JTabbedPane)parent).insertTab(newName == null ? "Page " + ((JTabbedPane)parent).getTabCount() : newName, null, comp, null, index < 0 ? ((JTabbedPane)parent).getTabCount() : index);
            } else if (parent instanceof JPanel) {
                if (parent.getComponentCount() < 1) {
                    if (newName != null) {
                        comp.setName(newName);
                    }
                    parent.add(comp, "Center");
                } else {
                    JTabbedPane tab = new JTabbedPane();
                    Component[] comps = parent.getComponents();
                    for (int i = 0; i < comps.length; ++i) {
                        String title = comps[i].getName();
                        tab.addTab(title == null ? "Page " + tab.getTabCount() : title, comps[i]);
                    }
                    tab.insertTab(newName == null ? "Page " + tab.getTabCount() : newName, null, comp, null, index < 0 ? tab.getTabCount() : index);
                    this.parentMap.put(constraints.toString(), tab);
                    super.remove(parent);
                    if ("Center".equals(constraints)) {
                        this.eastSplitter.setLeftComponent(this.parentMap.get("Center"));
                    } else if ("North".equals(constraints)) {
                        this.northSplitter.setTopComponent(this.parentMap.get("North"));
                        this.northSplitter.setDividerLocation(-1);
                    } else if ("South".equals(constraints)) {
                        this.southSplitter.setBottomComponent(this.parentMap.get("South"));
                        this.southSplitter.setDividerLocation(-1);
                    } else if ("East".equals(constraints)) {
                        this.eastSplitter.setRightComponent(this.parentMap.get("East"));
                        this.eastSplitter.setDividerLocation(-1);
                    } else if ("West".equals(constraints)) {
                        this.westSplitter.setLeftComponent(this.parentMap.get("West"));
                        this.westSplitter.setDividerLocation(-1);
                    } else {
                        throw new IllegalArgumentException("Only BorderLayout.CENTER, BorderLayout.NORTH, BorderLayout.SOUTH, BorderLayout.EAST or BorderLayout.WEST can be accepted as a constraint.");
                    }
                }
            }
        }
        this.validate();
        this.repaint();
    }

    @Override
    public Component add(String name, Component comp) {
        return this.add(name, comp, "Center");
    }

    public Component add(String name, Component comp, Object constraints) {
        this.add(name, comp, constraints, -1);
        return comp;
    }

    @Override
    public void remove(Component comp) {
        Container north = this.parentMap.get("North");
        Container south = this.parentMap.get("South");
        Container east = this.parentMap.get("East");
        Container west = this.parentMap.get("West");
        Container center = this.parentMap.get("Center");
        if (north != null && north.isAncestorOf(comp)) {
            north.remove(comp);
            if (north instanceof JTabbedPane && ((JTabbedPane)north).getTabCount() < 1) {
                this.parentMap.put("North", new JPanel());
                this.northSplitter.setTopComponent(this.parentMap.get("North"));
                this.northSplitter.setDividerLocation(-1);
            }
        }
        if (south != null && south.isAncestorOf(comp)) {
            south.remove(comp);
            if (south instanceof JTabbedPane && ((JTabbedPane)south).getTabCount() < 1) {
                this.parentMap.put("South", new JPanel());
                this.southSplitter.setBottomComponent(this.parentMap.get("South"));
                this.southSplitter.setDividerLocation(-1);
            }
        }
        if (east != null && east.isAncestorOf(comp)) {
            east.remove(comp);
            if (east instanceof JTabbedPane && ((JTabbedPane)east).getTabCount() < 1) {
                this.parentMap.put("East", new JPanel());
                this.eastSplitter.setRightComponent(this.parentMap.get("East"));
                this.eastSplitter.setDividerLocation(-1);
            }
        }
        if (west != null && west.isAncestorOf(comp)) {
            west.remove(comp);
            if (west instanceof JTabbedPane && ((JTabbedPane)west).getTabCount() < 1) {
                this.parentMap.put("West", new JPanel());
                this.westSplitter.setLeftComponent(this.parentMap.get("West"));
                this.westSplitter.setDividerLocation(-1);
            }
        }
        if (center != null && center.isAncestorOf(comp)) {
            center.remove(comp);
            if (center instanceof JTabbedPane && ((JTabbedPane)center).getTabCount() < 1) {
                this.parentMap.put("Center", new JPanel());
                this.eastSplitter.setLeftComponent(this.parentMap.get("Center"));
            }
        }
    }

    @Override
    public void remove(int index) {
        Container center = this.parentMap.get("Center");
        if (center instanceof JTabbedPane) {
            ((JTabbedPane)center).remove(index);
        }
    }

    @Override
    public void removeAll() {
        this.reset();
    }

    public void setNorthResizable(boolean value) {
        this.northSplitter.setDividerSize(value ? this.dividerSize : 0);
    }

    public boolean isNorthResizable() {
        return this.northSplitter.getDividerSize() > 0;
    }

    public void setSouthResizable(boolean value) {
        this.southSplitter.setDividerSize(value ? this.dividerSize : 0);
    }

    public boolean isSouthResizable() {
        return this.southSplitter.getDividerSize() > 0;
    }

    public void setEastResizable(boolean value) {
        this.eastSplitter.setDividerSize(value ? this.dividerSize : 0);
    }

    public boolean isEastResizable() {
        return this.eastSplitter.getDividerSize() > 0;
    }

    public void setWestResizable(boolean value) {
        this.westSplitter.setDividerSize(value ? this.dividerSize : 0);
    }

    public boolean isWestResizable() {
        return this.westSplitter.getDividerSize() > 0;
    }
}

