/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.alchemist.utils;

import chemaxon.alchemist.utils.AlchemistFileChooserForMarvin;
import chemaxon.marvin.common.swing.modules.MolFileFilter;
import java.io.File;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileSystemView;

public class AlchemistFileChooserForJChem
extends AlchemistFileChooserForMarvin {
    private static final String PROPERTY_VALUE_MRV = "mrv";
    private static final String PROPERTY_VALUE_RDF = "rdf";
    private static final long serialVersionUID = 6072442218773486214L;
    private static FileFilter reactionFilter = new FileFilter(){
        private String desc = "All reaction files";
        private String[] exts = new String[]{".mrv", ".csrdf", ".rdf", ".csrxn", ".rxn", ".rd", ".cml", ".cdx", ".smi", ".cxsmi", ".smiles", ".cxsmiles", ".cxsma", ".cxsmarts", ".sma", ".smarts"};

        @Override
        public boolean accept(File f) {
            if (f != null) {
                if (f.isDirectory()) {
                    return true;
                }
                String s = f.getName().toLowerCase();
                for (int i = 0; i < this.exts.length; ++i) {
                    String ext = this.exts[i];
                    if (!s.endsWith(ext) && !"*".equals(ext)) continue;
                    return true;
                }
            }
            return false;
        }

        @Override
        public String getDescription() {
            return this.desc;
        }
    };

    public AlchemistFileChooserForJChem() {
    }

    public AlchemistFileChooserForJChem(boolean setMViewAccessory) {
        super(setMViewAccessory);
    }

    public AlchemistFileChooserForJChem(File currentDirectory, FileSystemView fsv) {
        super(currentDirectory, fsv);
    }

    public AlchemistFileChooserForJChem(File currentDirectory) {
        super(currentDirectory);
    }

    public AlchemistFileChooserForJChem(FileSystemView fsv) {
        super(fsv);
    }

    public AlchemistFileChooserForJChem(String currentDirectoryPath, FileSystemView fsv) {
        super(currentDirectoryPath, fsv);
    }

    public AlchemistFileChooserForJChem(String currentDirectoryPath) {
        super(currentDirectoryPath);
    }

    public void addReactionOpenFileFilters() {
        this.setAcceptAllFileFilterUsed(true);
        this.addFileFilters(AlchemistFileChooserForJChem.getReactionOpenFileFilters());
    }

    public void addReactionSaveFileFilters() {
        this.setAcceptAllFileFilterUsed(false);
        this.addFileFilters(AlchemistFileChooserForJChem.getReactionSaveFileFilters());
    }

    public void addReactionLibraryOpenFileFilters() {
        this.setAcceptAllFileFilterUsed(true);
        FileFilter[] filters = new FileFilter[]{new MolFileFilter(PROPERTY_VALUE_RDF), new MolFileFilter(PROPERTY_VALUE_MRV)};
        this.addFileFilters(filters);
    }

    public void addReactionLibrarySaveFileFilters() {
        this.setAcceptAllFileFilterUsed(false);
        FileFilter[] filters = new FileFilter[]{new MolFileFilter(PROPERTY_VALUE_RDF), new MolFileFilter(PROPERTY_VALUE_MRV)};
        this.addFileFilters(filters);
    }

    public void addMetabolizerSaveFileFilters() {
        this.setAcceptAllFileFilterUsed(false);
        FileFilter[] filters = new FileFilter[]{new MolFileFilter(PROPERTY_VALUE_RDF), new MolFileFilter(PROPERTY_VALUE_MRV), new MolFileFilter("smiles")};
        this.addFileFilters(filters);
    }

    public static FileFilter[] getReactionOpenFileFilters() {
        FileFilter[] filters = new FileFilter[]{new MolFileFilter(PROPERTY_VALUE_MRV), new MolFileFilter("csrdf"), new MolFileFilter("csrxn"){

            @Override
            public String getDescription() {
                return "ChemAxon Compressed Rxnfile (*.csrxn)";
            }
        }, new MolFileFilter("cxsmarts"), new MolFileFilter("cxsmiles"), new MolFileFilter("cml"), new MolFileFilter("cdx"), new MolFileFilter("rxn"), new MolFileFilter("rxn:V3"), new MolFileFilter(PROPERTY_VALUE_RDF), new MolFileFilter("smarts"), new MolFileFilter("smiles"), reactionFilter};
        return filters;
    }

    public static FileFilter[] getReactionSaveFileFilters() {
        FileFilter[] filters = new FileFilter[]{new MolFileFilter(PROPERTY_VALUE_MRV), new MolFileFilter("csrdf"), new MolFileFilter("csrxn"){

            @Override
            public String getDescription() {
                return "ChemAxon Compressed Rxnfile (*.csrxn)";
            }
        }, new MolFileFilter("cxsmarts"), new MolFileFilter("cxsmiles"), new MolFileFilter("rxn"), new MolFileFilter("rxn:V3"), new MolFileFilter(PROPERTY_VALUE_RDF), new MolFileFilter("cml"), new MolFileFilter("cdx"), new MolFileFilter("smarts"), new MolFileFilter("smiles")};
        return filters;
    }
}

