/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.alchemist.utils;

import chemaxon.alchemist.utils.AlchemistFileChooser;
import chemaxon.alchemist.utils.AlchemistMViewAccessory;
import chemaxon.marvin.common.swing.modules.MolFileFilter;
import chemaxon.struc.Molecule;
import java.awt.Component;
import java.awt.HeadlessException;
import java.io.File;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileSystemView;

public class AlchemistFileChooserForMarvin
extends AlchemistFileChooser {
    private static final long serialVersionUID = -3098002768590321227L;
    protected AlchemistMViewAccessory accessory;

    public AlchemistFileChooserForMarvin() {
    }

    public AlchemistFileChooserForMarvin(boolean setMViewAccessory) {
        this.accessory = new AlchemistMViewAccessory(this);
        if (setMViewAccessory) {
            this.setAccessory(this.accessory);
        }
    }

    public AlchemistFileChooserForMarvin(File currentDirectory, FileSystemView fsv) {
        super(currentDirectory, fsv);
    }

    public AlchemistFileChooserForMarvin(File currentDirectory) {
        super(currentDirectory);
    }

    public AlchemistFileChooserForMarvin(FileSystemView fsv) {
        super(fsv);
    }

    public AlchemistFileChooserForMarvin(String currentDirectoryPath, FileSystemView fsv) {
        super(currentDirectoryPath, fsv);
    }

    public AlchemistFileChooserForMarvin(String currentDirectoryPath) {
        super(currentDirectoryPath);
    }

    public void addDefaultOpenFileFilters() {
        this.setAcceptAllFileFilterUsed(true);
        this.addFileFilters(AlchemistFileChooserForMarvin.getDefaultOpenFileFilters());
    }

    @Override
    public boolean clearChoosableFileFilters() {
        boolean succ = true;
        FileFilter[] filters = this.getChoosableFileFilters();
        for (int i = 0; i < filters.length; ++i) {
            succ = succ && this.removeChoosableFileFilter(filters[i]);
        }
        return succ;
    }

    public void addDefaultSaveFileFilters() {
        this.setAcceptAllFileFilterUsed(false);
        this.addFileFilters(AlchemistFileChooserForMarvin.getDefaultSaveFileFilters());
    }

    @Override
    public void addFileFilters(FileFilter[] filterArray) {
        for (int i = 0; i < filterArray.length; ++i) {
            this.addChoosableFileFilter(filterArray[i]);
        }
    }

    @Override
    public boolean hasFileFilter(FileFilter filter) {
        FileFilter[] filters = this.getChoosableFileFilters();
        for (int i = 0; i < filters.length; ++i) {
            if (!filters[i].equals(filter)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void clear() {
        if (this.accessory != null) {
            this.accessory.clear();
        }
    }

    public Molecule getAccessoryMolecule() {
        if (this.accessory != null) {
            return this.accessory.getCurrentMolecule();
        }
        return null;
    }

    public static FileFilter[] getDefaultSaveFileFilters() {
        FileFilter[] filters = new FileFilter[]{new MolFileFilter("mrv"), new MolFileFilter("csrdf"), new MolFileFilter("cssdf"){

            @Override
            public String getDescription() {
                return "ChemAxon Compressed SDfile (*.csdf)";
            }
        }, new MolFileFilter("csmol"){

            @Override
            public String getDescription() {
                return "ChemAxon Compressed Molfile (*.csmol)";
            }
        }, new MolFileFilter("csrxn"){

            @Override
            public String getDescription() {
                return "ChemAxon Compressed Rxnfile (*.csrxn)";
            }
        }, new MolFileFilter("smiles"), new MolFileFilter("cxsmiles"), new MolFileFilter("cxsmarts"), new MolFileFilter("cml"), new MolFileFilter("cdx"), new MolFileFilter("mol"), new MolFileFilter("mol2"), new MolFileFilter("mol:V3"), new MolFileFilter("rxn"), new MolFileFilter("rxn:V3"), new MolFileFilter("pdb"), new MolFileFilter("pov"), new MolFileFilter("sdf"), new MolFileFilter("rdf"), new MolFileFilter("smarts"), new MolFileFilter("abbrevgroup"), new MolFileFilter("sybyl"), new MolFileFilter("xyz"), new MolFileFilter("cube"), new MolFileFilter("inchi"), new MolFileFilter("name"), new MolFileFilter("mrv")};
        return filters;
    }

    public static FileFilter[] getDefaultOpenFileFilters() {
        FileFilter[] filters = new FileFilter[]{new MolFileFilter("mrv"), new MolFileFilter("csrdf"), new MolFileFilter("cssdf"){

            @Override
            public String getDescription() {
                return "ChemAxon Compressed SDfile (*.csdf)";
            }
        }, new MolFileFilter("csmol"){

            @Override
            public String getDescription() {
                return "ChemAxon Compressed Molfile (*.csmol)";
            }
        }, new MolFileFilter("csrxn"){

            @Override
            public String getDescription() {
                return "ChemAxon Compressed Rxnfile (*.csrxn)";
            }
        }, new MolFileFilter("cxsmiles"), new MolFileFilter("cxsmarts"), new MolFileFilter("cml"), new MolFileFilter("gzip"), new MolFileFilter("mol"), new MolFileFilter("mol2"), new MolFileFilter("mol:V3"), new MolFileFilter("rxn"), new MolFileFilter("rxn:V3"), new MolFileFilter("pdb"), new MolFileFilter("pov"), new MolFileFilter("sdf"), new MolFileFilter("rdf"), new MolFileFilter("name"), new MolFileFilter("vmn"), new MolFileFilter("smiles"), new MolFileFilter("smarts"), new MolFileFilter("abbrevgroup"), new MolFileFilter("sybyl"), new MolFileFilter("xyz"), new MolFileFilter("cube"), new MolFileFilter("inchi"), new MolFileFilter("ALL_STRUCTURE_FILES")};
        return filters;
    }

    @Override
    public File getSelectedFile() {
        File file = super.getSelectedFile();
        if (this.getDialogType() == 1 && super.getSelectedFile() != null) {
            String fileName = super.getSelectedFile().getAbsolutePath();
            FileFilter filter = this.getFileFilter();
            if (filter instanceof MolFileFilter) {
                MolFileFilter mfilter = (MolFileFilter)filter;
                String ext = mfilter.getExtension();
                if (fileName.lastIndexOf("." + ext) == -1) {
                    file = new File(fileName + "." + ext);
                }
            }
        }
        return file;
    }

    @Override
    public int showDialog(Component parent, String approveButtonText) throws HeadlessException {
        if (this.accessory != null) {
            this.accessory.forceMoleculeReload();
        }
        return super.showDialog(parent, approveButtonText);
    }
}

