/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.alchemist.utils;

import chemaxon.alchemist.utils.AlchemistFileChooser;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.SwingPropertyChangeSupport;

public class AlchemistFileTextBox
extends JPanel {
    public static final int OPEN_FILE_MODE = 0;
    public static final int SAVE_FILE_MODE = 1;
    private static final long serialVersionUID = 8770285887133439479L;
    private JTextField pathText = null;
    private JButton clearButton = null;
    private JButton browseButton = null;
    private final AlchemistFileChooser fileChooser;
    private final SwingPropertyChangeSupport notifier;
    private final boolean editEnabled;
    private final String label;
    private final String PROPERTY_KEY_FILE_PATH;
    private int mode = 0;

    public AlchemistFileTextBox(int mode, AlchemistFileChooser fileChooser, SwingPropertyChangeSupport notifier, String caption, boolean isEditEnabled, String propertyKey) {
        this.mode = mode;
        this.fileChooser = fileChooser;
        this.notifier = notifier;
        this.label = caption;
        this.editEnabled = isEditEnabled;
        this.PROPERTY_KEY_FILE_PATH = propertyKey;
        this.initialize();
    }

    public AlchemistFileTextBox(AlchemistFileChooser fileChooser, SwingPropertyChangeSupport notifier, String caption, boolean isEditEnabled, String propertyKey) {
        this.mode = 0;
        this.fileChooser = fileChooser;
        this.notifier = notifier;
        this.label = caption;
        this.editEnabled = isEditEnabled;
        this.PROPERTY_KEY_FILE_PATH = propertyKey;
        this.initialize();
    }

    private void initialize() {
        CellConstraints cc = new CellConstraints();
        JLabel infoLabel = new JLabel();
        infoLabel.setText(this.label);
        this.setLayout((LayoutManager)new FormLayout("pref, 2dlu, fill:min:grow, 2dlu, min, 2dlu, min, 2dlu, min", "min"));
        this.add((Component)infoLabel, cc.xy(1, 1));
        this.add((Component)this.getPathText(), cc.xy(3, 1));
        this.add((Component)this.getClearButton(), cc.xy(5, 1));
        this.add((Component)this.getBrowseButton(), cc.xy(7, 1));
        this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
    }

    private JTextField getPathText() {
        if (this.pathText == null) {
            this.pathText = new JTextField();
            this.pathText.setEditable(this.editEnabled);
            this.pathText.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void changedUpdate(DocumentEvent e) {
                    AlchemistFileTextBox.this.handleTextChange();
                }

                @Override
                public void insertUpdate(DocumentEvent e) {
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                }
            });
        }
        return this.pathText;
    }

    private JButton getClearButton() {
        if (this.clearButton == null) {
            this.clearButton = new JButton();
            this.clearButton.setIcon(new ImageIcon(this.getClass().getResource("/chemaxon/alchemist/images/clear.gif")));
            this.clearButton.setEnabled(false);
            this.clearButton.setVisible(!this.editEnabled);
            this.clearButton.setPreferredSize(new Dimension(23, 23));
            this.clearButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    AlchemistFileTextBox.this.pathText.setText("");
                    AlchemistFileTextBox.this.handleTextChange();
                }
            });
        }
        return this.clearButton;
    }

    private JButton getBrowseButton() {
        if (this.browseButton == null) {
            this.browseButton = new JButton();
            this.browseButton.setText("Browse...");
            this.browseButton.setVisible(true);
            this.browseButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (AlchemistFileTextBox.this.fileChooser != null && (AlchemistFileTextBox.this.mode != 1 ? AlchemistFileTextBox.this.fileChooser.showOpenDialog(null) : AlchemistFileTextBox.this.fileChooser.showSaveDialog(null)) == 0) {
                        AlchemistFileTextBox.this.pathText.setText(AlchemistFileTextBox.this.fileChooser.getSelectedFile().getAbsolutePath());
                        AlchemistFileTextBox.this.fileChooser.clear();
                        AlchemistFileTextBox.this.handleTextChange();
                    }
                }
            });
        }
        return this.browseButton;
    }

    public String getFilePath() {
        return this.pathText.getText();
    }

    public void setFilePath(String path) {
        this.pathText.setText(path);
        this.handleTextChange();
    }

    private void handleTextChange() {
        this.clearButton.setEnabled(!this.pathText.getText().equalsIgnoreCase(""));
        this.notifier.firePropertyChange(this.PROPERTY_KEY_FILE_PATH, null, this.pathText.getText());
    }

    public void setClearButtonVisible(boolean isVisible) {
        this.clearButton.setVisible(isVisible);
    }

    public boolean isClearButtonVisible() {
        return this.clearButton.isVisible();
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.clearButton.setEnabled(enabled && !this.pathText.getText().equalsIgnoreCase(""));
        this.browseButton.setEnabled(enabled);
    }

    public void reset() {
        this.pathText.setText("");
        this.handleTextChange();
    }

    public int getMode() {
        return this.mode;
    }

    public void setMode(int mode) {
        this.mode = mode;
    }
}

