/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.alchemist.utils;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;

public class AlchemistGraphicsUtilities {
    public static final Color ALCHEMIST_TOOLTIP_BGR = new Color(255, 250, 180);
    public static final Color ALCHEMIST_ORANGE = new Color(253, 182, 64);
    public static final Color ALCHEMIST_GRAY = new Color(192, 192, 192);
    public static final Color ALCHEMIST_SIDEBAR_BGR_GRADIENT1 = new Color(36, 130, 156);
    public static final Color ALCHEMIST_SIDEBAR_BGR_GRADIENT2 = new Color(60, 146, 169);
    private static final float[] DASH1 = new float[]{5.0f};
    private static final float[] DOT1 = new float[]{1.0f};
    public static final BasicStroke DASHED_STROKE = new BasicStroke(1.0f, 0, 0, 5.0f, DASH1, 0.0f);
    public static final BasicStroke DOTTED_STROKE = new BasicStroke(1.0f, 0, 0, 1.0f, DOT1, 0.0f);
    public static final BasicStroke NORMAL_STROKE = new BasicStroke();

    public static BufferedImage createDisabledImage(Component component) {
        BufferedImage image = new BufferedImage(Math.max(1, component.getWidth()), Math.max(1, component.getHeight()), 5);
        component.paint(image.getGraphics());
        Graphics g2 = image.getGraphics();
        g2.setColor(new Color(255, 255, 255, 150));
        g2.fillRect(0, 0, image.getWidth(), image.getHeight());
        g2.dispose();
        return image;
    }

    public static Color greyscale(Color color) {
        int r = color.getRed();
        int g = color.getGreen();
        int b = color.getBlue();
        int c = (r + g + b) / 3;
        return new Color(c, c, c);
    }

    public static void renderMessageOnComponent(Graphics g, String message, Color color, int componentWidth, int componentHeight) {
        Graphics2D g2 = (Graphics2D)g.create();
        g2.setColor(color);
        String[] text = message.split("\n");
        float height = g2.getFontMetrics(g2.getFont()).getLineMetrics(message, g2).getHeight() + 5.0f;
        float top = ((float)componentHeight - (float)text.length * height) / 2.0f + 2.0f * height / 3.0f;
        for (int i = 0; i < text.length; ++i) {
            float left = (componentWidth - g2.getFontMetrics(g2.getFont()).stringWidth(text[i])) / 2;
            g2.drawString(text[i], left, top + (float)i * height);
        }
        g2.dispose();
    }
}

