/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.alchemist.utils;

import chemaxon.alchemist.configbuilder.standardizer.StandardizerConfigBuilderAlchemist;
import chemaxon.alchemist.configbuilder.structurechecker.StructureCheckerConfigBuilderAlchemist;
import chemaxon.alchemist.markushview.MarkushViewAlchemist;
import chemaxon.alchemist.metabolizer.MetabolizerAlchemist;
import chemaxon.alchemist.moleculeeditor.MoleculeFileEditorAlchemist;
import chemaxon.alchemist.reactor.ReactorAlchemist;
import chemaxon.alchemist.reactor.reactioneditor.ReactionEditorAlchemist;
import chemaxon.alchemist.standardizer.StandardizerAlchemist;
import chemaxon.alchemist.structurechecker.StructureCheckerAlchemist;
import chemaxon.alchemist.toxicity.ToxicityViewerAlchemist;
import chemaxon.alchemist.utils.AlchemistLaunchable;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.lang.reflect.Constructor;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.UIManager;

public class AlchemistLauncher
extends JFrame {
    private static final long serialVersionUID = 3343421093394560591L;
    private static final String TITLE = "ChemAxon Alchemist - Launcher";
    private static LaunchableListItem[] launchables = null;
    private JPanel jPanel = null;
    private JScrollPane jScrollPane = null;
    private JList lstLaunchables = null;
    private JPanel pnlMenu = null;
    private JButton buttLaunch = null;
    private JButton buttCancel = null;

    public AlchemistLauncher() {
        this.initialize();
    }

    private void loadLauncherProperties() {
        for (int i = 0; i < launchables.length; ++i) {
            ((DefaultListModel)this.lstLaunchables.getModel()).add(i, launchables[i]);
        }
        if (this.lstLaunchables.getModel().getSize() > 0) {
            this.lstLaunchables.setSelectedIndex(0);
        } else {
            this.buttLaunch.setEnabled(false);
        }
    }

    private void initialize() {
        this.setSize(new Dimension(413, 275));
        this.setContentPane(this.getJPanel());
        this.setLocationRelativeTo(null);
        this.setDefaultCloseOperation(3);
        this.setTitle(TITLE);
        this.loadLauncherProperties();
    }

    private JPanel getJPanel() {
        if (this.jPanel == null) {
            this.jPanel = new JPanel();
            this.jPanel.setLayout(new BorderLayout());
            this.jPanel.add((Component)this.getJScrollPane(), "Center");
            this.jPanel.add((Component)this.getPnlMenu(), "South");
        }
        return this.jPanel;
    }

    private JScrollPane getJScrollPane() {
        if (this.jScrollPane == null) {
            this.jScrollPane = new JScrollPane();
            this.jScrollPane.setViewportView(this.getJList());
            this.jScrollPane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10), BorderFactory.createLineBorder(Color.GRAY)));
        }
        return this.jScrollPane;
    }

    private JList getJList() {
        if (this.lstLaunchables == null) {
            this.lstLaunchables = new JList();
            this.lstLaunchables.setModel(new DefaultListModel());
            this.lstLaunchables.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.lstLaunchables.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getButton() == 1 && e.getClickCount() == 2) {
                        AlchemistLauncher.this.launch(AlchemistLauncher.this.lstLaunchables.getSelectedIndex());
                    }
                }
            });
            this.lstLaunchables.addKeyListener(new KeyAdapter(){

                @Override
                public void keyTyped(KeyEvent e) {
                    if (e.getKeyChar() == '\n') {
                        AlchemistLauncher.this.launch(AlchemistLauncher.this.lstLaunchables.getSelectedIndex());
                    }
                }
            });
            this.lstLaunchables.setCellRenderer(new LaunchableRenderer());
        }
        return this.lstLaunchables;
    }

    private JPanel getPnlMenu() {
        if (this.pnlMenu == null) {
            GridLayout gridLayout = new GridLayout();
            gridLayout.setRows(1);
            gridLayout.setVgap(0);
            gridLayout.setHgap(10);
            gridLayout.setColumns(2);
            this.pnlMenu = new JPanel();
            this.pnlMenu.setBorder(BorderFactory.createEmptyBorder(5, 15, 5, 15));
            this.pnlMenu.setLayout(gridLayout);
            this.pnlMenu.add((Component)this.getButtLaunch(), null);
            this.pnlMenu.add((Component)this.getButtCancel(), null);
        }
        return this.pnlMenu;
    }

    private JButton getButtLaunch() {
        if (this.buttLaunch == null) {
            this.buttLaunch = new JButton();
            this.buttLaunch.setText("Launch");
            this.buttLaunch.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AlchemistLauncher.this.launch(AlchemistLauncher.this.lstLaunchables.getSelectedIndex());
                }
            });
        }
        return this.buttLaunch;
    }

    private JButton getButtCancel() {
        if (this.buttCancel == null) {
            this.buttCancel = new JButton();
            this.buttCancel.setText("Close");
            this.buttCancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Runtime.getRuntime().exit(0);
                }
            });
        }
        return this.buttCancel;
    }

    private static void createInstance() {
        AlchemistLauncher launcher = new AlchemistLauncher();
        launcher.setVisible(true);
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            // empty catch block
        }
        launchables = new LaunchableListItem[]{new LaunchableListItem(StandardizerConfigBuilderAlchemist.class, "Manage Configurations for Standardizer", "/chemaxon/alchemist/images/standardizer.png", "standardizerconfigbuilder"), new LaunchableListItem(StructureCheckerConfigBuilderAlchemist.class, "Manage Configurations for Structure Checker", "/chemaxon/alchemist/images/structurechecker.png", "structurecheckerconfigbuilder"), new LaunchableListItem(StandardizerAlchemist.class, "Standardizer", "/chemaxon/alchemist/images/standardizer.png", "standardizer"), new LaunchableListItem(StructureCheckerAlchemist.class, "Structure Checker", "/chemaxon/alchemist/images/structurechecker.png", "structurechecker"), new LaunchableListItem(ReactorAlchemist.class, "Reactor", "/chemaxon/alchemist/images/reactor.png", "reactor"), new LaunchableListItem(ReactionEditorAlchemist.class, "Reaction Library Editor", "/chemaxon/alchemist/images/reactor.png", "reactioneditor"), new LaunchableListItem(MetabolizerAlchemist.class, "Metabolizer", "/chemaxon/alchemist/images/metabolizer.png", "metabolizer"), new LaunchableListItem(MarkushViewAlchemist.class, "Markush Viewer", "/chemaxon/alchemist/images/markushviewer32.png", "markushview"), new LaunchableListItem(MoleculeFileEditorAlchemist.class, "Molecule file editor", "NOICON", "moleculeeditor"), new LaunchableListItem(ToxicityViewerAlchemist.class, "Toxicity viewer", "NOICON", "toxicityviewer")};
        if (args.length > 0) {
            for (int i = 0; i < launchables.length; ++i) {
                if (!args[0].equalsIgnoreCase(launchables[i].getCommandLineParam())) continue;
                launchables[i].createAndRun();
                return;
            }
        }
        AlchemistLauncher.createInstance();
    }

    private void launch(int Index2) {
        if (Index2 >= 0 && Index2 < launchables.length) {
            this.setVisible(false);
            launchables[Index2].createAndRun();
        }
    }

    private static class LaunchableListItem {
        private final String displayName;
        private final Icon icon;
        private final String commandLineParam;
        private final Class<?> itemClass;

        public LaunchableListItem(Class<?> itemClass, String displayName, String imagePath, String commandLineParam) {
            this.itemClass = itemClass;
            this.displayName = displayName;
            URL url = this.getClass().getResource(imagePath);
            this.icon = url != null ? new ImageIcon(url) : new ImageIcon(new BufferedImage(32, 32, 6));
            this.commandLineParam = commandLineParam;
        }

        public String getCommandLineParam() {
            return this.commandLineParam;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public Icon getIcon() {
            return this.icon;
        }

        public Class<?> getItemClass() {
            return this.itemClass;
        }

        public void createAndRun() {
            Thread launchThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    Constructor<?>[] constructors = LaunchableListItem.this.itemClass.getConstructors();
                    for (int i = 0; i < constructors.length; ++i) {
                        if (constructors[i].getParameterTypes().length != 0) continue;
                        try {
                            AlchemistLaunchable launchable = (AlchemistLaunchable)constructors[i].newInstance(null);
                            launchable.launch();
                            continue;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
            });
            launchThread.start();
        }
    }

    private static class LaunchableRenderer
    extends DefaultListCellRenderer {
        private static final long serialVersionUID = -1192886586283538573L;

        private LaunchableRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value instanceof LaunchableListItem) {
                label.setIcon(((LaunchableListItem)value).getIcon());
                label.setText(((LaunchableListItem)value).getDisplayName());
            }
            return label;
        }
    }
}

