/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.alchemist.utils;

import chemaxon.alchemist.utils.AlchemistGraphicsUtilities;
import chemaxon.alchemist.utils.AlchemistMoleculePainter;
import chemaxon.struc.Molecule;
import java.awt.BasicStroke;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Polygon;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class AlchemistLinearMoleculeView
extends JPanel {
    private static final String NORMAL_PANEL = "normalPanel";
    private static final String WAIT_PANEL = "waitPanel";
    private static final String DISABLED_PANEL = "disabledPanel";
    private static final long serialVersionUID = -341731579595741305L;
    public static final int VERTICAL = 0;
    public static final int HORIZONTAL = 1;
    private int orientation = 0;
    private List<Molecule> moleculeList = null;
    private JScrollPane scroll = null;
    private JPanel itemHolder = null;
    private boolean showArrows = false;
    private boolean smoothScroll = true;
    private BufferedImage disabledImage = null;
    String[] reactionNamesArray = null;
    Map<String, String> reactionNames = null;
    private boolean isWaiting = false;
    private boolean isAdjusting = false;
    private JPanel waitPanel = null;
    private JPanel disabledPanel = null;
    private JLabel waitLabel = null;
    private boolean selectable = false;
    private int[] selectionIndexes = new int[0];
    private Set<ListSelectionListener> listSelectionListeners = null;
    private int dispOpts = -2;
    private int dispOptsExt = -1;

    public AlchemistLinearMoleculeView(int orientation) {
        this(new ArrayList<Molecule>(), orientation);
    }

    AlchemistLinearMoleculeView(List<Molecule> molecules, int orientation) {
        this(molecules, orientation, null, null);
    }

    AlchemistLinearMoleculeView(List<Molecule> molecules, int orientation, Map<String, String> reactionNamesMap, String[] reactionNamesArray) {
        this.moleculeList = molecules;
        this.orientation = orientation;
        this.reactionNames = reactionNamesMap;
        this.reactionNamesArray = reactionNamesArray;
        this.listSelectionListeners = new HashSet<ListSelectionListener>();
        this.initialize();
    }

    AlchemistLinearMoleculeView(List<Molecule> molecules, int orientation, Map<String, String> reactionNamesMap, String[] reactionNamesArray, int dispOpts, int dispOptsExt) {
        this(molecules, orientation, reactionNamesMap, reactionNamesArray);
        this.dispOpts = dispOpts;
        this.dispOptsExt = dispOptsExt;
    }

    private void initialize() {
        CardLayout cl = new CardLayout();
        this.setLayout(cl);
        this.add((Component)this.getScroll(), NORMAL_PANEL);
        this.add((Component)this.getWaitPanel(), WAIT_PANEL);
        this.add((Component)this.getDisabledPanel(), DISABLED_PANEL);
        this.initComponents();
    }

    private JPanel getWaitPanel() {
        if (this.waitPanel == null) {
            this.waitPanel = new JPanel();
            this.waitPanel.setLayout(new GridLayout());
            this.waitPanel.add((Component)this.getWaitLabel(), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        }
        return this.waitPanel;
    }

    private JLabel getWaitLabel() {
        if (this.waitLabel == null) {
            this.waitLabel = new JLabel("Loading...", 0);
            this.waitLabel.setOpaque(false);
        }
        return this.waitLabel;
    }

    private JPanel getDisabledPanel() {
        if (this.disabledPanel == null) {
            this.disabledPanel = new JPanel(){
                private static final long serialVersionUID = -7273575509832909063L;

                @Override
                protected void paintComponent(Graphics g) {
                    super.paintComponent(g);
                    if (AlchemistLinearMoleculeView.this.disabledImage != null) {
                        Graphics g2 = g.create();
                        g2.drawImage(AlchemistLinearMoleculeView.this.disabledImage, 0, 0, null);
                        g2.dispose();
                    }
                }
            };
        }
        return this.disabledPanel;
    }

    public List<Molecule> getMoleculeList() {
        return this.moleculeList == null ? Collections.EMPTY_LIST : this.moleculeList;
    }

    public void setWaiting(boolean value) {
        this.isWaiting = value;
        CardLayout cl = (CardLayout)this.getLayout();
        cl.show(this, this.isWaiting ? WAIT_PANEL : NORMAL_PANEL);
    }

    public boolean isWaiting() {
        return this.isWaiting;
    }

    public void setWaitText(String text) {
        this.getWaitLabel().setText(text);
    }

    public String getWaitText() {
        return this.getWaitLabel().getText();
    }

    public void setMoleculeList(List<Molecule> moleculeList) {
        this.setMoleculeList(moleculeList, null, null);
    }

    public void setMoleculeList(List<Molecule> moleculeList, Map<String, String> reactionNamesMap, String[] reactionNamesArray) {
        this.reactionNames = reactionNamesMap;
        this.moleculeList = moleculeList;
        this.reactionNamesArray = reactionNamesArray;
        this.selectionIndexes = new int[0];
        this.fireSelectionValueChanged(-1, -1, this.isAdjusting);
        this.initComponents();
    }

    public String[] getReactionNames() {
        return this.reactionNames.keySet().toArray(new String[this.reactionNames.size()]);
    }

    private JScrollPane getScroll() {
        if (this.scroll == null) {
            this.scroll = new JScrollPane();
            this.scroll.setBorder(null);
            this.scroll.setOpaque(false);
            this.scroll.setHorizontalScrollBarPolicy(this.orientation == 1 ? 30 : 31);
            this.scroll.setVerticalScrollBarPolicy(this.orientation == 0 ? 20 : 21);
            this.scroll.setViewportView(this.getItemHolder());
            this.scroll.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent e) {
                    AlchemistLinearMoleculeView.this.scroll.getVerticalScrollBar().setUnitIncrement(!AlchemistLinearMoleculeView.this.smoothScroll ? (AlchemistLinearMoleculeView.this.orientation == 1 ? AlchemistLinearMoleculeView.this.getWidth() : AlchemistLinearMoleculeView.this.getHeight()) : 10);
                    AlchemistLinearMoleculeView.this.scroll.getHorizontalScrollBar().setUnitIncrement(!AlchemistLinearMoleculeView.this.smoothScroll ? (AlchemistLinearMoleculeView.this.orientation == 1 ? AlchemistLinearMoleculeView.this.getWidth() : AlchemistLinearMoleculeView.this.getHeight()) : 10);
                }
            });
        }
        return this.scroll;
    }

    public void setUnitIncrement(int unitIncrement) {
        this.getScroll().getVerticalScrollBar().setUnitIncrement(unitIncrement);
        this.getScroll().getHorizontalScrollBar().setUnitIncrement(unitIncrement);
    }

    public int getUnitIncrement() {
        return this.orientation == 1 ? this.getScroll().getHorizontalScrollBar().getUnitIncrement() : this.getScroll().getVerticalScrollBar().getUnitIncrement();
    }

    public void setBlockIncrement(int blockIncrement) {
        this.getScroll().getVerticalScrollBar().setBlockIncrement(blockIncrement);
        this.getScroll().getHorizontalScrollBar().setBlockIncrement(blockIncrement);
    }

    public int getBlockIncrement() {
        return this.orientation == 1 ? this.getScroll().getHorizontalScrollBar().getBlockIncrement() : this.getScroll().getVerticalScrollBar().getBlockIncrement();
    }

    private JPanel getItemHolder() {
        if (this.itemHolder == null) {
            this.itemHolder = new JPanel();
            if (this.orientation == 1) {
                this.itemHolder.setLayout(new FlowLayout(0, 1, 1));
            } else {
                this.itemHolder.setLayout(new BoxLayout(this.itemHolder, 1));
            }
        }
        return this.itemHolder;
    }

    private void initComponents() {
        int pref;
        this.itemHolder.removeAll();
        if (this.moleculeList != null) {
            for (int i = 0; i < this.moleculeList.size(); ++i) {
                final int index = i;
                Molecule mol = this.moleculeList.get(i);
                MoleculeViewPanel panel = new MoleculeViewPanel(i);
                if (this.showArrows && this.orientation == 1 && i != 0) {
                    JPanel pnl = new JPanel(){
                        private static final long serialVersionUID = 5579023196979479628L;

                        private int yCor(int len, double dir) {
                            return (int)((double)len * Math.cos(dir));
                        }

                        private int xCor(int len, double dir) {
                            return (int)((double)len * Math.sin(dir));
                        }

                        private void drawArrow(Graphics2D g2d, int xCenter, int yCenter, int x, int y, float stroke) {
                            double aDir = Math.atan2(xCenter - x, yCenter - y);
                            g2d.drawLine(x, y, xCenter, yCenter);
                            g2d.setStroke(new BasicStroke(1.0f));
                            Polygon tmpPoly = new Polygon();
                            int i1 = 4 + (int)(stroke * 2.0f);
                            int i2 = 4 + (int)stroke;
                            tmpPoly.addPoint(x, y);
                            tmpPoly.addPoint(x + this.xCor(i1, aDir + 0.5), y + this.yCor(i1, aDir + 0.5));
                            tmpPoly.addPoint(x + this.xCor(i2, aDir), y + this.yCor(i2, aDir));
                            tmpPoly.addPoint(x + this.xCor(i1, aDir - 0.5), y + this.yCor(i1, aDir - 0.5));
                            tmpPoly.addPoint(x, y);
                            g2d.drawPolygon(tmpPoly);
                            g2d.fillPolygon(tmpPoly);
                            if (AlchemistLinearMoleculeView.this.reactionNamesArray != null && index > 0) {
                                int width = SwingUtilities.computeStringWidth(this.getFontMetrics(this.getFont()), AlchemistLinearMoleculeView.this.reactionNamesArray[index - 1]);
                                int left = (this.getWidth() - width) / 2;
                                g2d.drawString(AlchemistLinearMoleculeView.this.reactionNamesArray[index - 1], left, y - 10);
                            }
                        }

                        @Override
                        public void paint(Graphics g) {
                            super.paint(g);
                            Graphics2D g2 = (Graphics2D)g;
                            Dimension dim = this.getSize();
                            this.drawArrow(g2, 10, dim.height / 2, dim.width - 10, dim.height / 2, 1.5f);
                        }
                    };
                    pnl.setOpaque(false);
                    Dimension dim = this.orientation == 1 ? this.getHorizontalDimension(mol.isReaction()) : this.getVerticalDimension();
                    dim.width /= 2;
                    if (this.reactionNamesArray != null && i > 0) {
                        int prefWidth = SwingUtilities.computeStringWidth(pnl.getFontMetrics(pnl.getFont()), this.reactionNamesArray[i - 1]);
                        if (dim.width < prefWidth) {
                            dim.width = prefWidth;
                        }
                        pnl.setToolTipText(this.reactionNames.get(this.reactionNamesArray[i - 1]));
                    }
                    pnl.setPreferredSize(dim);
                    this.itemHolder.add(pnl);
                }
                panel.setPreferredSize(this.orientation == 1 ? this.getHorizontalDimension(mol.isReaction()) : this.getVerticalDimension());
                this.itemHolder.add(panel);
            }
        }
        if (this.orientation == 0 && (pref = this.itemHolder.getVisibleRect().height - this.itemHolder.getComponentCount() * this.getVerticalDimension().height) > 0) {
            this.itemHolder.add(new Box.Filler(new Dimension(0, 0), new Dimension(0, pref), new Dimension(0, pref)));
        }
        this.updateUI();
    }

    private Dimension getHorizontalDimension(boolean isReaction) {
        Dimension hdim = new Dimension();
        int base = isReaction ? this.itemHolder.getVisibleRect().height * 2 : this.itemHolder.getVisibleRect().height;
        int diff = this.orientation == 1 ? ((FlowLayout)this.itemHolder.getLayout()).getVgap() * 2 : 0;
        hdim.width = base - diff;
        hdim.height = isReaction ? base / 2 - diff : hdim.width;
        return hdim;
    }

    private Dimension getVerticalDimension() {
        int w;
        int h = w = this.itemHolder.getVisibleRect().width;
        if (this.itemHolder.getVisibleRect().height < w) {
            h = this.itemHolder.getVisibleRect().height;
        }
        return new Dimension(w, h);
    }

    public void redoLayout() {
        this.initComponents();
    }

    @Override
    public void setBackground(Color bg) {
        this.getItemHolder().setBackground(bg);
        this.getWaitPanel().setBackground(bg);
    }

    @Override
    public Color getBackground() {
        return this.getItemHolder().getBackground();
    }

    public void setShowArrows(boolean value) {
        this.showArrows = value;
    }

    public boolean isShowArrows() {
        return this.showArrows;
    }

    public boolean isSelectable() {
        return this.selectable;
    }

    public void setSelectable(boolean selectable) {
        this.selectable = selectable;
    }

    public void addListSelectionListener(ListSelectionListener listener) {
        this.listSelectionListeners.add(listener);
    }

    public ListSelectionListener[] getListSelectionListeners() {
        return this.listSelectionListeners.toArray(new ListSelectionListener[this.listSelectionListeners.size()]);
    }

    public void removeListSelectionListener(ListSelectionListener listener) {
        this.listSelectionListeners.remove(listener);
    }

    protected void fireSelectionValueChanged(int firstIndex, int lastIndex, boolean isAdjusting) {
        ListSelectionEvent event = new ListSelectionEvent(this, firstIndex, lastIndex, isAdjusting);
        for (ListSelectionListener listener : this.listSelectionListeners) {
            listener.valueChanged(event);
        }
    }

    public void clearSelection() {
        this.selectionIndexes = new int[0];
        this.fireSelectionValueChanged(-1, -1, this.isAdjusting);
        this.repaint();
    }

    public int[] getSelectedIndexes() {
        return this.selectionIndexes;
    }

    public Molecule[] getSelectedValues() {
        Molecule[] selectedMolecules = new Molecule[this.selectionIndexes.length];
        for (int i = 0; i < this.selectionIndexes.length; ++i) {
            selectedMolecules[i] = this.moleculeList.get(this.selectionIndexes[i]);
        }
        return selectedMolecules;
    }

    public boolean isSelectedIndex(int index) {
        boolean selected = false;
        for (int i = 0; i < this.selectionIndexes.length && !selected; ++i) {
            selected = this.selectionIndexes[i] == index;
        }
        return selected;
    }

    public boolean isSelectionEmpty() {
        return this.selectionIndexes.length == 0;
    }

    public void setSelectedIndex(int index) {
        this.selectionIndexes = index > -1 ? new int[]{index} : new int[0];
        this.fireSelectionValueChanged(index, index, this.isAdjusting);
        this.repaint();
    }

    public void setSelectedIndexes(int[] indexes) {
        int min = this.getMoleculeList().size();
        int max = -1;
        this.selectionIndexes = new int[indexes.length];
        for (int i = 0; i < indexes.length; ++i) {
            if (indexes[i] < min) {
                min = indexes[i];
            }
            if (indexes[i] > max) {
                max = indexes[i];
            }
            this.selectionIndexes[i] = indexes[i];
        }
        this.fireSelectionValueChanged(max == -1 ? -1 : min, max, this.isAdjusting);
        this.repaint();
    }

    public void selectAll() {
        this.selectionIndexes = new int[this.getMoleculeList().size()];
        for (int i = 0; i < this.selectionIndexes.length; ++i) {
            this.selectionIndexes[i] = i;
        }
        this.fireSelectionValueChanged(0, this.selectionIndexes.length - 1, this.isAdjusting);
        this.repaint();
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        CardLayout cl = (CardLayout)this.getLayout();
        this.refreshDisabledPanel();
        cl.show(this, enabled ? (this.isWaiting ? WAIT_PANEL : NORMAL_PANEL) : DISABLED_PANEL);
    }

    private void refreshDisabledPanel() {
        if (this.isDisplayable()) {
            this.disabledImage = AlchemistGraphicsUtilities.createDisabledImage(this);
        }
    }

    public void setAdjusting(boolean adjusting) {
        this.isAdjusting = adjusting;
    }

    public boolean isAdjusting() {
        return this.isAdjusting;
    }

    public void setSmoothScroll(boolean smoothScroll) {
        this.smoothScroll = smoothScroll;
        this.scroll.getVerticalScrollBar().setUnitIncrement(!smoothScroll ? (this.orientation == 1 ? this.getHeight() : this.getWidth()) : 10);
        this.scroll.getHorizontalScrollBar().setUnitIncrement(!smoothScroll ? (this.orientation == 1 ? this.getHeight() : this.getWidth()) : 10);
    }

    public boolean isSmoothScroll() {
        return this.smoothScroll;
    }

    public int getDispOpts() {
        return this.dispOpts;
    }

    public int getDispOptsExt() {
        return this.dispOptsExt;
    }

    public void setDispOpts(int opt) {
        this.dispOpts = opt;
    }

    public void setDispOptsExt(int opt) {
        this.dispOptsExt = opt;
    }

    static /* synthetic */ int[] access$102(AlchemistLinearMoleculeView x0, int[] x1) {
        x0.selectionIndexes = x1;
        return x1;
    }

    private class MoleculeViewPanel
    extends JPanel {
        private static final long serialVersionUID = -310731578141317141L;
        private final int index;

        MoleculeViewPanel(int index) {
            this.index = index;
            this.setBackground(AlchemistLinearMoleculeView.this.getItemHolder().getBackground());
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (AlchemistLinearMoleculeView.this.isSelectable()) {
                        int start = -1;
                        int end = -1;
                        if (e.isShiftDown()) {
                            start = AlchemistLinearMoleculeView.this.selectionIndexes.length > 0 ? AlchemistLinearMoleculeView.this.selectionIndexes[0] : MoleculeViewPanel.this.index;
                            end = MoleculeViewPanel.this.index;
                            if (end < start) {
                                int tmp = start;
                                start = end;
                                end = tmp;
                            }
                            if (start == -1 || end == -1) {
                                AlchemistLinearMoleculeView.access$102(AlchemistLinearMoleculeView.this, new int[0]);
                            } else {
                                AlchemistLinearMoleculeView.access$102(AlchemistLinearMoleculeView.this, new int[end - start + 1]);
                                for (int i = 0; i < AlchemistLinearMoleculeView.this.selectionIndexes.length; ++i) {
                                    ((AlchemistLinearMoleculeView)AlchemistLinearMoleculeView.this).selectionIndexes[i] = i + start;
                                }
                            }
                        } else if (e.isControlDown()) {
                            end = start = MoleculeViewPanel.this.index;
                            int remove = -1;
                            for (int i = 0; i < AlchemistLinearMoleculeView.this.selectionIndexes.length && remove == -1; ++i) {
                                if (AlchemistLinearMoleculeView.this.selectionIndexes[i] != MoleculeViewPanel.this.index) continue;
                                remove = i;
                            }
                            if (remove == -1) {
                                int[] tmp = new int[AlchemistLinearMoleculeView.this.selectionIndexes.length + 1];
                                for (int i = 0; i < AlchemistLinearMoleculeView.this.selectionIndexes.length; ++i) {
                                    tmp[i] = AlchemistLinearMoleculeView.this.selectionIndexes[i];
                                }
                                tmp[tmp.length - 1] = MoleculeViewPanel.this.index;
                                Arrays.sort(tmp);
                                AlchemistLinearMoleculeView.access$102(AlchemistLinearMoleculeView.this, tmp);
                            } else {
                                int[] tmp = new int[AlchemistLinearMoleculeView.this.selectionIndexes.length - 1];
                                int count = 0;
                                for (int i = 0; i < AlchemistLinearMoleculeView.this.selectionIndexes.length; ++i) {
                                    if (i == remove) continue;
                                    tmp[count++] = AlchemistLinearMoleculeView.this.selectionIndexes[i];
                                }
                                AlchemistLinearMoleculeView.access$102(AlchemistLinearMoleculeView.this, tmp);
                            }
                        } else {
                            end = start = MoleculeViewPanel.this.index;
                            AlchemistLinearMoleculeView.access$102(AlchemistLinearMoleculeView.this, new int[]{start});
                        }
                        AlchemistLinearMoleculeView.this.fireSelectionValueChanged(start, end, AlchemistLinearMoleculeView.this.isAdjusting);
                        AlchemistLinearMoleculeView.this.repaint();
                    }
                }
            });
        }

        @Override
        public void paint(Graphics g) {
            Dimension dim;
            super.paint(g);
            Molecule mol = (Molecule)AlchemistLinearMoleculeView.this.moleculeList.get(this.index);
            Dimension dimension = dim = AlchemistLinearMoleculeView.this.orientation == 1 ? AlchemistLinearMoleculeView.this.getHorizontalDimension(mol.isReaction()) : AlchemistLinearMoleculeView.this.getVerticalDimension();
            if (AlchemistLinearMoleculeView.this.dispOpts != -2) {
                if (AlchemistLinearMoleculeView.this.dispOptsExt != -1) {
                    AlchemistMoleculePainter.drawMolecule(mol, g, dim, AlchemistLinearMoleculeView.this.dispOpts, AlchemistLinearMoleculeView.this.dispOptsExt);
                } else {
                    AlchemistMoleculePainter.drawMolecule(mol, g, dim, AlchemistLinearMoleculeView.this.dispOpts);
                }
            } else {
                AlchemistMoleculePainter.drawMolecule(mol, g, dim);
            }
            if (AlchemistLinearMoleculeView.this.isSelectedIndex(this.index)) {
                int leftBegin = 0;
                int leftEnd = 20;
                int rightEnd = this.getWidth() - 20;
                int rightBegin = this.getWidth();
                int topBegin = 0;
                int topEnd = 20;
                int bottomBegin = this.getHeight();
                int bottomEnd = this.getHeight() - 20;
                Graphics2D g2 = (Graphics2D)g.create();
                g2.setColor(Color.BLUE);
                g2.fillRect(leftBegin, topBegin, leftEnd, topBegin + 2);
                g2.fillRect(leftBegin, topBegin, leftBegin + 2, topEnd);
                g2.fillRect(leftBegin, bottomEnd, leftBegin + 2, bottomBegin);
                g2.fillRect(leftBegin, bottomBegin - 2, leftEnd, bottomBegin);
                g2.fillRect(rightEnd, topBegin, rightBegin, topBegin + 2);
                g2.fillRect(rightBegin - 2, topBegin, rightBegin, topEnd);
                g2.fillRect(rightEnd, bottomBegin - 2, rightBegin, bottomBegin);
                g2.fillRect(rightBegin - 2, bottomEnd, rightBegin, bottomBegin);
                g2.dispose();
            }
        }
    }
}

