/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.alchemist.utils;

import chemaxon.alchemist.utils.AlchemistErrorDialog;
import chemaxon.alchemist.utils.AlchemistWaitPanel;
import chemaxon.alchemist.utils.SimpleAlchemistMoleculeView;
import chemaxon.formats.MolImporter;
import chemaxon.struc.MDocument;
import chemaxon.struc.Molecule;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public class AlchemistMViewAccessory
extends JPanel
implements PropertyChangeListener {
    private static final int AUTO_CHANGE_DISABLED = 0;
    private static final int AUTO_CHANGE_BACKWARD = -1;
    private static final int AUTO_CHANGE_FORWARD = 1;
    private static final int STATUS_HIDDEN = -1;
    private static final int STATUS_SHOWING = 0;
    private static final int STATUS_LOADING = 1;
    private static final int STATUS_ERROR = 2;
    private static final int STATUS_NOSELECTION = 3;
    private static final long serialVersionUID = -5123713451624419144L;
    private JCheckBox chkPreview = null;
    private JPanel mainPanel = null;
    private SimpleAlchemistMoleculeView view = null;
    private Thread thread;
    private MolImporter molImporter = null;
    private boolean forceStop = false;
    private AlchemistWaitPanel containerPanel = null;
    private JPanel controlPanel = null;
    private JLabel prevLabel = null;
    private JLabel nextLabel = null;
    private JLabel firstLabel = null;
    private JLabel lastLabel = null;
    private JLabel countLabel = null;
    private int molPos;
    private int maxMolecules = 0;
    private int prereadLimit = 0;
    private boolean limitReached = false;
    private int status = 3;
    private int autoChangeMode;
    private boolean notClick;
    private int delayCount;
    private static final int MOLECULE_AUTO_CHANGE_STARTDELAY = 600;
    private static final int MOLECULE_AUTO_CHANGE_DELAY_MOD = 400;
    private int cantShowLeft = 0;
    private final Rectangle errorRect = new Rectangle(0, 0, 0, 0);
    private static final String CAN_NOT_SHOW = "Can not show";
    private File lastProcessedFile = null;
    private File selectedFile = null;
    private Molecule currentMolecule = null;
    private final Timer autoChangeTimer = new Timer(600, new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            AlchemistMViewAccessory.this.autoChangeTimer.stop();
            AlchemistMViewAccessory.this.notClick = true;
            AlchemistMViewAccessory.this.delayCount++;
            int i = AlchemistMViewAccessory.this.delayCount * 50 > 400 ? 200 : 600 - AlchemistMViewAccessory.this.delayCount * 50;
            AlchemistMViewAccessory.this.autoChangeTimer.setInitialDelay(i);
            if (AlchemistMViewAccessory.this.autoChangeMode != 0) {
                if (AlchemistMViewAccessory.this.autoChangeMode == 1) {
                    AlchemistMViewAccessory.this.nextMolecule();
                }
                if (AlchemistMViewAccessory.this.autoChangeMode == -1) {
                    AlchemistMViewAccessory.this.prevMolecule();
                }
                AlchemistMViewAccessory.this.autoChangeTimer.restart();
            } else {
                AlchemistMViewAccessory.this.delayCount = 0;
            }
        }
    });

    public AlchemistMViewAccessory(JFileChooser chooser) {
        this(chooser, 100);
    }

    public AlchemistMViewAccessory(JFileChooser chooser, int prereadLimit) {
        this.prereadLimit = prereadLimit;
        chooser.addPropertyChangeListener(this);
        this.initialize();
    }

    private void initialize() {
        this.view = new SimpleAlchemistMoleculeView(1, 1, false);
        this.setLayout(new BoxLayout(this, 1));
        this.setSize(new Dimension(120, 160));
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.setMaximumSize(new Dimension(110, 130));
        this.setMinimumSize(new Dimension(110, 130));
        this.setPreferredSize(new Dimension(120, 160));
        this.add((Component)this.getMainPanel(), null);
        this.setStatus(3);
    }

    private void setStatus(int status) {
        this.status = status;
        switch (status) {
            case 1: {
                this.view.setVisible(false);
                this.getControlPanel().setVisible(false);
                this.getContainerPanel().start();
                this.getContainerPanel().setWheelVisible(true);
                break;
            }
            case 0: {
                this.view.setVisible(true);
                this.getControlPanel().setVisible(true);
                break;
            }
            default: {
                this.view.setVisible(false);
                this.getControlPanel().setVisible(false);
                this.getContainerPanel().stop();
                this.getContainerPanel().setWheelVisible(false);
            }
        }
        this.getContainerPanel().repaint();
    }

    private JCheckBox getChkPreview() {
        if (this.chkPreview == null) {
            this.chkPreview = new JCheckBox();
            this.chkPreview.setText("Show preview");
            this.chkPreview.setMinimumSize(new Dimension(100, 20));
            this.chkPreview.setPreferredSize(new Dimension(100, 20));
            this.chkPreview.setSelected(true);
            this.chkPreview.setMaximumSize(new Dimension(120, 20));
            this.chkPreview.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (!AlchemistMViewAccessory.this.chkPreview.isSelected()) {
                        AlchemistMViewAccessory.this.setStatus(-1);
                    } else if (AlchemistMViewAccessory.this.selectedFile != null) {
                        AlchemistMViewAccessory.this.processFile(AlchemistMViewAccessory.this.selectedFile);
                    } else {
                        AlchemistMViewAccessory.this.setStatus(3);
                    }
                }
            });
        }
        return this.chkPreview;
    }

    private JPanel getMainPanel() {
        if (this.mainPanel == null) {
            this.mainPanel = new JPanel();
            this.mainPanel.setLayout(new BorderLayout());
            this.mainPanel.setMaximumSize(new Dimension(110, 150));
            this.mainPanel.setMinimumSize(new Dimension(110, 150));
            this.mainPanel.setPreferredSize(new Dimension(110, 150));
            this.mainPanel.add((Component)this.getChkPreview(), "South");
            this.mainPanel.setAlignmentY(1.0f);
            this.mainPanel.setAlignmentX(1.0f);
            this.mainPanel.add((Component)this.getContainerPanel(), "Center");
        }
        return this.mainPanel;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String propertyName = evt.getPropertyName();
        if (propertyName.equals("SelectedFileChangedProperty")) {
            File selection = (File)evt.getNewValue();
            if (selection != null && selection.isFile()) {
                this.selectedFile = selection;
                if (this.status != -1) {
                    this.processFile(selection);
                }
            } else {
                this.selectedFile = null;
                if (this.thread != null && this.thread.isAlive()) {
                    try {
                        this.forceStop = true;
                        this.thread.join();
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                }
                if (this.status != -1) {
                    this.setStatus(3);
                }
            }
        }
    }

    public Molecule getCurrentMolecule() {
        return this.currentMolecule;
    }

    private void updateMolecule() {
        block6: {
            this.currentMolecule = null;
            try {
                if (this.molImporter == null) break block6;
                this.molImporter.seekRecord(this.molPos, null);
                MDocument doc = this.molImporter.nextDoc();
                if (doc != null) {
                    try {
                        this.currentMolecule = doc.getPrimaryMolecule().cloneMoleculeWithDocument();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.view.setMolecule(0, 0, doc.getPrimaryMolecule());
                } else {
                    this.maxMolecules = this.molPos--;
                    this.limitReached = false;
                }
                this.getPrevLabel().setEnabled(this.molPos != 0);
                this.getNextLabel().setEnabled(doc != null && this.limitReached || this.molPos != this.maxMolecules - 1);
                this.getFirstLabel().setEnabled(this.getPrevLabel().isEnabled());
                this.getLastLabel().setEnabled(!this.limitReached && this.getNextLabel().isEnabled());
                this.getCountLabel().setText(this.molPos + 1 + "/" + (this.limitReached ? "*" : Integer.valueOf(this.maxMolecules)));
            }
            catch (IOException e) {
                this.error();
            }
        }
    }

    private void processFile(final File file) {
        if (!file.equals(this.lastProcessedFile)) {
            this.lastProcessedFile = file;
            this.molPos = -1;
            if (this.thread != null && this.thread.isAlive()) {
                this.forceStop = true;
                try {
                    this.thread.join();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this.view.setVisible(false);
            this.view.clear();
            this.currentMolecule = null;
            this.setStatus(1);
            this.getControlPanel().setVisible(false);
            this.thread = new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    if (file != null && AlchemistMViewAccessory.this.chkPreview.isSelected()) {
                        try {
                            if (AlchemistMViewAccessory.this.molImporter != null) {
                                try {
                                    AlchemistMViewAccessory.this.molImporter.close();
                                }
                                catch (Exception e) {
                                    // empty catch block
                                }
                            }
                            AlchemistMViewAccessory.this.molImporter = new MolImporter(file.getAbsolutePath());
                            AlchemistMViewAccessory.this.maxMolecules = 0;
                            while (!AlchemistMViewAccessory.this.forceStop && AlchemistMViewAccessory.this.molImporter.skipRecord() && AlchemistMViewAccessory.this.maxMolecules < AlchemistMViewAccessory.this.prereadLimit) {
                                AlchemistMViewAccessory.this.maxMolecules++;
                            }
                            AlchemistMViewAccessory.this.limitReached = AlchemistMViewAccessory.this.maxMolecules >= AlchemistMViewAccessory.this.prereadLimit;
                            if (!AlchemistMViewAccessory.this.forceStop) {
                                if (AlchemistMViewAccessory.this.maxMolecules > 0) {
                                    AlchemistMViewAccessory.this.molPos = 0;
                                    AlchemistMViewAccessory.this.updateMolecule();
                                    AlchemistMViewAccessory.this.setStatus(0);
                                } else {
                                    AlchemistMViewAccessory.this.error();
                                }
                            } else {
                                AlchemistMViewAccessory.this.maxMolecules = 0;
                                AlchemistMViewAccessory.this.lastProcessedFile = null;
                                AlchemistMViewAccessory.this.setStatus(3);
                            }
                        }
                        catch (IOException e) {
                            AlchemistMViewAccessory.this.error();
                        }
                        catch (NullPointerException e) {
                            AlchemistMViewAccessory.this.error();
                        }
                        finally {
                            AlchemistMViewAccessory.this.forceStop = false;
                        }
                    }
                }
            });
            this.thread.setPriority(4);
            this.thread.start();
        } else {
            this.setStatus(0);
        }
    }

    private AlchemistWaitPanel getContainerPanel() {
        if (this.containerPanel == null) {
            this.containerPanel = new AlchemistWaitPanel(false, false){
                private static final long serialVersionUID = 1338628507533366979L;

                @Override
                protected void paintComponent(Graphics g) {
                    super.paintComponent(g);
                    if (AlchemistMViewAccessory.this.status == 2) {
                        Graphics2D gX = (Graphics2D)g.create();
                        gX.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                        gX.setColor(Color.LIGHT_GRAY);
                        for (int i = -1; i <= 1; i += 2) {
                            Graphics2D gLine = (Graphics2D)gX.create();
                            gLine.translate(((AlchemistMViewAccessory)AlchemistMViewAccessory.this).errorRect.x + ((AlchemistMViewAccessory)AlchemistMViewAccessory.this).errorRect.width / 2, ((AlchemistMViewAccessory)AlchemistMViewAccessory.this).errorRect.y + ((AlchemistMViewAccessory)AlchemistMViewAccessory.this).errorRect.height / 2);
                            gLine.rotate((double)i * 0.785);
                            gLine.fillRoundRect(-((AlchemistMViewAccessory)AlchemistMViewAccessory.this).errorRect.width / 2, -((AlchemistMViewAccessory)AlchemistMViewAccessory.this).errorRect.height / 2, ((AlchemistMViewAccessory)AlchemistMViewAccessory.this).errorRect.width, ((AlchemistMViewAccessory)AlchemistMViewAccessory.this).errorRect.height, ((AlchemistMViewAccessory)AlchemistMViewAccessory.this).errorRect.width, ((AlchemistMViewAccessory)AlchemistMViewAccessory.this).errorRect.width);
                            gLine.dispose();
                        }
                        Graphics2D gText = (Graphics2D)gX.create();
                        gText.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
                        gText.setColor(Color.LIGHT_GRAY);
                        gText.translate(AlchemistMViewAccessory.this.cantShowLeft, this.getHeight() - 10);
                        gText.setFont(gText.getFont().deriveFont(1));
                        gText.drawString(AlchemistMViewAccessory.CAN_NOT_SHOW, 0, 0);
                        gText.dispose();
                        gX.dispose();
                    }
                }
            };
            this.containerPanel.setLayout(new BorderLayout());
            this.containerPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.gray, 1), BorderFactory.createEmptyBorder(2, 2, 2, 2)));
            this.containerPanel.setBackground(Color.WHITE);
            this.containerPanel.setPreferredSize(new Dimension(106, 126));
            this.containerPanel.add((Component)this.view, "Center");
            this.containerPanel.add((Component)this.getControlPanel(), "South");
            this.containerPanel.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent e) {
                    ((AlchemistMViewAccessory)AlchemistMViewAccessory.this).errorRect.width = AlchemistMViewAccessory.this.getWidth() / 10;
                    ((AlchemistMViewAccessory)AlchemistMViewAccessory.this).errorRect.y = 6;
                    ((AlchemistMViewAccessory)AlchemistMViewAccessory.this).errorRect.height = Math.min(AlchemistMViewAccessory.this.getWidth(), AlchemistMViewAccessory.this.getHeight()) - 20;
                    ((AlchemistMViewAccessory)AlchemistMViewAccessory.this).errorRect.x = (AlchemistMViewAccessory.this.getWidth() - ((AlchemistMViewAccessory)AlchemistMViewAccessory.this).errorRect.width - 10) / 2;
                    AlchemistMViewAccessory.this.cantShowLeft = (AlchemistMViewAccessory.this.getWidth() - SwingUtilities.computeStringWidth(AlchemistMViewAccessory.this.getFontMetrics(AlchemistMViewAccessory.this.getFont()), AlchemistMViewAccessory.CAN_NOT_SHOW) - 10) / 2;
                }

                @Override
                public void componentShown(ComponentEvent e) {
                    this.componentResized(e);
                }
            });
        }
        return this.containerPanel;
    }

    private JPanel getControlPanel() {
        if (this.controlPanel == null) {
            this.controlPanel = new JPanel();
            this.controlPanel.setLayout(new BoxLayout(this.controlPanel, 0));
            this.controlPanel.setOpaque(false);
            this.controlPanel.setVisible(false);
            this.controlPanel.add(Box.createHorizontalGlue());
            this.controlPanel.add(this.getFirstLabel());
            this.controlPanel.add(this.getPrevLabel());
            this.controlPanel.add(this.getCountLabel());
            this.controlPanel.add(this.getNextLabel());
            this.controlPanel.add(this.getLastLabel());
            this.controlPanel.add(Box.createHorizontalGlue());
        }
        return this.controlPanel;
    }

    private JLabel getFirstLabel() {
        if (this.firstLabel == null) {
            this.firstLabel = new JLabel();
            this.firstLabel.setIcon(new ImageIcon(this.getClass().getResource("/chemaxon/alchemist/images/first.gif")));
            this.firstLabel.setDisabledIcon(new ImageIcon(this.getClass().getResource("/chemaxon/alchemist/images/first_disabled.gif")));
            this.firstLabel.setOpaque(false);
            this.firstLabel.setAlignmentX(0.5f);
            this.firstLabel.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (AlchemistMViewAccessory.this.firstLabel.isEnabled()) {
                        AlchemistMViewAccessory.this.molPos = 0;
                        AlchemistMViewAccessory.this.updateMolecule();
                    }
                }
            });
        }
        return this.firstLabel;
    }

    private JLabel getPrevLabel() {
        if (this.prevLabel == null) {
            this.prevLabel = new JLabel();
            this.prevLabel.setIcon(new ImageIcon(this.getClass().getResource("/chemaxon/alchemist/images/prev.gif")));
            this.prevLabel.setDisabledIcon(new ImageIcon(this.getClass().getResource("/chemaxon/alchemist/images/prev_disabled.gif")));
            this.prevLabel.setOpaque(false);
            this.prevLabel.setAlignmentX(0.5f);
            this.prevLabel.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    AlchemistMViewAccessory.this.autoChangeMode = -1;
                    AlchemistMViewAccessory.this.autoChangeTimer.start();
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    AlchemistMViewAccessory.this.autoChangeMode = 0;
                    AlchemistMViewAccessory.this.autoChangeTimer.stop();
                    AlchemistMViewAccessory.this.delayCount = 0;
                }

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (!AlchemistMViewAccessory.this.notClick) {
                        AlchemistMViewAccessory.this.prevMolecule();
                    }
                    AlchemistMViewAccessory.this.notClick = false;
                }
            });
        }
        return this.prevLabel;
    }

    private JLabel getNextLabel() {
        if (this.nextLabel == null) {
            this.nextLabel = new JLabel();
            this.nextLabel.setIcon(new ImageIcon(this.getClass().getResource("/chemaxon/alchemist/images/next.gif")));
            this.nextLabel.setDisabledIcon(new ImageIcon(this.getClass().getResource("/chemaxon/alchemist/images/next_disabled.gif")));
            this.nextLabel.setOpaque(false);
            this.nextLabel.setAlignmentX(0.5f);
            this.nextLabel.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    AlchemistMViewAccessory.this.autoChangeMode = 1;
                    AlchemistMViewAccessory.this.autoChangeTimer.start();
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    AlchemistMViewAccessory.this.autoChangeMode = 0;
                    AlchemistMViewAccessory.this.autoChangeTimer.stop();
                    AlchemistMViewAccessory.this.delayCount = 0;
                }

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (!AlchemistMViewAccessory.this.notClick) {
                        AlchemistMViewAccessory.this.nextMolecule();
                    }
                    AlchemistMViewAccessory.this.notClick = false;
                }
            });
        }
        return this.nextLabel;
    }

    private void nextMolecule() {
        if (this.getNextLabel().isEnabled()) {
            ++this.molPos;
            this.updateMolecule();
        }
    }

    private void prevMolecule() {
        if (this.getPrevLabel().isEnabled()) {
            --this.molPos;
            this.updateMolecule();
        }
    }

    private JLabel getLastLabel() {
        if (this.lastLabel == null) {
            this.lastLabel = new JLabel();
            this.lastLabel.setIcon(new ImageIcon(this.getClass().getResource("/chemaxon/alchemist/images/last.gif")));
            this.lastLabel.setDisabledIcon(new ImageIcon(this.getClass().getResource("/chemaxon/alchemist/images/last_disabled.gif")));
            this.lastLabel.setOpaque(false);
            this.lastLabel.setAlignmentX(0.5f);
            this.lastLabel.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (AlchemistMViewAccessory.this.lastLabel.isEnabled()) {
                        AlchemistMViewAccessory.this.molPos = AlchemistMViewAccessory.this.maxMolecules - 1;
                        AlchemistMViewAccessory.this.updateMolecule();
                    }
                }
            });
        }
        return this.lastLabel;
    }

    private JLabel getCountLabel() {
        if (this.countLabel == null) {
            this.countLabel = new JLabel("0/0");
            this.countLabel.setBorder(BorderFactory.createEmptyBorder(0, 3, 0, 3));
        }
        return this.countLabel;
    }

    public void clear() {
        this.currentMolecule = null;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                AlchemistMViewAccessory.this.view.clear();
                AlchemistMViewAccessory.this.setStatus(3);
                AlchemistMViewAccessory.this.close();
            }
        });
    }

    public void close() {
        try {
            if (this.molImporter != null) {
                this.molImporter.close();
            }
        }
        catch (IOException e) {
            AlchemistErrorDialog.showError(e);
        }
    }

    private void error() {
        this.lastProcessedFile = null;
        this.setStatus(2);
        this.close();
    }

    public void forceMoleculeReload() {
        if (this.lastProcessedFile != null) {
            File f = this.lastProcessedFile;
            this.lastProcessedFile = null;
            this.processFile(f);
        }
    }
}

