/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.alchemist.utils;

import chemaxon.alchemist.utils.AbstractAlchemistMoleculeView;
import chemaxon.alchemist.utils.AlchemistErrorDialog;
import chemaxon.alchemist.utils.AlchemistGraphicsUtilities;
import chemaxon.formats.MolImporter;
import chemaxon.marvin.io.SeekableInputStream;
import chemaxon.struc.MDocument;
import chemaxon.struc.Molecule;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.Executors;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;

public class AlchemistMoleculeView
extends AbstractAlchemistMoleculeView {
    private static final long serialVersionUID = -7071325616152351849L;
    public static final String PROPERTY_KEY_SELECTED_MOLECULE_CHANGED = "SelectedMoleculeChanged";
    public static final String PROPERTY_KEY_LOADING_STATE_CHANGED = "LoadingStateChanged";
    protected static final int DEFAULT_MAX_ROWNUM = 15;
    protected static final int DEFAULT_MAX_COLNUM = 15;
    protected int currentRowNum;
    protected int maxMolecules;
    protected JScrollBar scrollBar = null;
    private JPanel topPanel = null;
    private JLabel rowLabel = null;
    protected JComboBox rowComboBox = null;
    private JLabel columnLabel = null;
    protected JComboBox columnComboBox = null;
    protected int maxRowNum = 15;
    protected int maxColNum = 15;
    protected boolean isToolbarVisible;
    protected int percent = 0;
    protected MolImporter importer;
    protected InputStream inputStream;
    protected boolean loading;
    private boolean isChangingGrid = false;
    private boolean cancelBackgroundLoaderThread = false;
    private JTextArea adjustPosition = null;
    private Popup tooltip = null;
    private Point mousePosition = new Point(0, 0);
    private final Runnable backgroundLoader = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Runnable runnable = AlchemistMoleculeView.this.backgroundLoader;
            synchronized (runnable) {
                AlchemistMoleculeView.this.loading = true;
                try {
                    if (AlchemistMoleculeView.this.importer != null) {
                        AlchemistMoleculeView.this.percent = 0;
                        while (AlchemistMoleculeView.this.importer.skipRecord() && !AlchemistMoleculeView.this.cancelBackgroundLoaderThread) {
                            if (AlchemistMoleculeView.this.importer.getFile() == null) continue;
                            AlchemistMoleculeView.this.percent = (int)((float)AlchemistMoleculeView.this.importer.tell() / (float)AlchemistMoleculeView.this.importer.getFile().length() * 100.0f);
                        }
                    }
                }
                catch (Exception e) {
                    AlchemistMoleculeView.this.importer = null;
                }
                AlchemistMoleculeView.this.loading = false;
                AlchemistMoleculeView.this.setWaitMode(false);
                AlchemistMoleculeView.this.maxMolecules = AlchemistMoleculeView.this.importer == null ? 0 : AlchemistMoleculeView.this.importer.getRecordCountMax();
                AlchemistMoleculeView.this.currentRowNum = 0;
                AlchemistMoleculeView.this.resetScrollBar();
                AlchemistMoleculeView.this.firePropertyChange(AlchemistMoleculeView.PROPERTY_KEY_LOADING_STATE_CHANGED, true, false);
            }
        }
    };

    public AlchemistMoleculeView(int defaultRowNum, int defaultColNum, boolean isToolbarVisible) {
        this(defaultRowNum, defaultColNum, 15, 15, isToolbarVisible);
    }

    public AlchemistMoleculeView(int defaultRowNum, int defaultColNum, int maxRowNum, int maxColNum, boolean isToolbarVisible) {
        super(defaultRowNum, defaultColNum);
        this.rowNum = maxRowNum < defaultRowNum ? maxRowNum : defaultRowNum;
        this.colNum = maxColNum < defaultColNum ? maxColNum : defaultColNum;
        this.maxColNum = maxColNum;
        this.maxRowNum = maxRowNum;
        this.isToolbarVisible = isToolbarVisible;
        this.initialize();
    }

    public void importMolecules(String path) {
        if (path != null && !path.equalsIgnoreCase("")) {
            File file = new File(path);
            SeekableInputStream inputStream = null;
            try {
                inputStream = new SeekableInputStream(file);
            }
            catch (FileNotFoundException exception) {
                AlchemistErrorDialog.showError("Could not find input file!", (Exception)exception);
                return;
            }
            this.importMolecules(inputStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importMolecules(InputStream inputStream) {
        Runnable runnable = this.backgroundLoader;
        synchronized (runnable) {
            this.clear();
            this.inputStream = inputStream;
            try {
                this.importer = new MolImporter(inputStream);
                this.setWaitMode(true);
                this.firePropertyChange(PROPERTY_KEY_LOADING_STATE_CHANGED, false, true);
                Executors.newSingleThreadExecutor().execute(this.backgroundLoader);
            }
            catch (IOException e) {
                AlchemistErrorDialog.showError("Can not read input stream.", (Exception)e);
                this.importer = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopLoading() {
        this.cancelBackgroundLoaderThread = true;
        Runnable runnable = this.backgroundLoader;
        synchronized (runnable) {
            this.cancelBackgroundLoaderThread = false;
        }
    }

    protected void resetScrollBar() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                AlchemistMoleculeView.this.getScrollBar().setValueIsAdjusting(true);
                AlchemistMoleculeView.this.getScrollBar().setValues(0, AlchemistMoleculeView.this.rowNum, 0, AlchemistMoleculeView.this.maxMolecules % AlchemistMoleculeView.this.colNum == 0 ? AlchemistMoleculeView.this.maxMolecules / AlchemistMoleculeView.this.colNum : AlchemistMoleculeView.this.maxMolecules / AlchemistMoleculeView.this.colNum + 1);
                AlchemistMoleculeView.this.getScrollBar().setBlockIncrement(AlchemistMoleculeView.this.rowNum);
                AlchemistMoleculeView.this.getScrollBar().setValueIsAdjusting(false);
            }
        });
    }

    public boolean isLoading() {
        return this.loading;
    }

    @Override
    protected JTable getView() {
        if (this.view == null) {
            this.view = super.getView();
            this.view.addMouseWheelListener(new MouseWheelListener(){

                @Override
                public void mouseWheelMoved(MouseWheelEvent e) {
                    if (e.getWheelRotation() > 0) {
                        AlchemistMoleculeView.this.increaseView(AlchemistMoleculeView.this.rowNum);
                    } else if (e.getWheelRotation() < 0) {
                        AlchemistMoleculeView.this.decreaseView(AlchemistMoleculeView.this.rowNum);
                    }
                }
            });
            this.view.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    if (AlchemistMoleculeView.this.view.getSelectedRow() != -1 && AlchemistMoleculeView.this.view.getSelectedColumn() != -1) {
                        if (AlchemistMoleculeView.this.view.getSelectedRow() == 0 && AlchemistMoleculeView.this.rowNum == 1) {
                            if (e.getKeyCode() == 38 || e.getKeyCode() == 33) {
                                AlchemistMoleculeView.this.decreaseView(1);
                            } else if (e.getKeyCode() == 40 || e.getKeyCode() == 34) {
                                AlchemistMoleculeView.this.increaseView(1);
                            } else if (e.getKeyCode() == 36) {
                                AlchemistMoleculeView.this.getScrollBar().setValueIsAdjusting(true);
                                AlchemistMoleculeView.this.getScrollBar().setValue(AlchemistMoleculeView.this.getScrollBar().getMinimum());
                                AlchemistMoleculeView.this.getScrollBar().setValueIsAdjusting(false);
                                e.consume();
                            } else if (e.getKeyCode() == 35) {
                                AlchemistMoleculeView.this.getScrollBar().setValueIsAdjusting(true);
                                AlchemistMoleculeView.this.getScrollBar().setValue(AlchemistMoleculeView.this.getScrollBar().getMaximum());
                                AlchemistMoleculeView.this.getScrollBar().setValueIsAdjusting(false);
                                e.consume();
                            }
                        } else if (AlchemistMoleculeView.this.view.getSelectedRow() == 0 && AlchemistMoleculeView.this.rowNum > 1 && e.getKeyCode() == 38) {
                            AlchemistMoleculeView.this.decreaseView(1);
                        } else if (AlchemistMoleculeView.this.view.getSelectedRow() == AlchemistMoleculeView.this.rowNum - 1 && AlchemistMoleculeView.this.rowNum > 1 && e.getKeyCode() == 40) {
                            AlchemistMoleculeView.this.increaseView(1);
                        } else if (e.getKeyCode() == 33) {
                            AlchemistMoleculeView.this.decreaseView(AlchemistMoleculeView.this.rowNum);
                        } else if (e.getKeyCode() == 34) {
                            AlchemistMoleculeView.this.increaseView(AlchemistMoleculeView.this.rowNum);
                        } else if (e.getKeyCode() == 36) {
                            AlchemistMoleculeView.this.getScrollBar().setValueIsAdjusting(true);
                            AlchemistMoleculeView.this.getScrollBar().setValue(AlchemistMoleculeView.this.getScrollBar().getMinimum());
                            AlchemistMoleculeView.this.getScrollBar().setValueIsAdjusting(false);
                            e.consume();
                        } else if (e.getKeyCode() == 35) {
                            AlchemistMoleculeView.this.getScrollBar().setValueIsAdjusting(true);
                            AlchemistMoleculeView.this.getScrollBar().setValue(AlchemistMoleculeView.this.getScrollBar().getMaximum());
                            AlchemistMoleculeView.this.getScrollBar().setValueIsAdjusting(false);
                            e.consume();
                        }
                    }
                }
            });
        }
        return this.view;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refreshView() {
        Runnable runnable = this.backgroundLoader;
        synchronized (runnable) {
            this.view.putClientProperty("MoleculeTableCellRenderer_CurrentRowNum", this.currentRowNum);
            this.view.putClientProperty("MoleculeTableCellRenderer_MoleculeCount", this.maxMolecules);
            for (int offset = 0; offset < this.rowNum * this.colNum; ++offset) {
                int moleculeIndex = this.currentRowNum * this.colNum + offset;
                int rowIndex = offset / this.colNum;
                int columnIndex = offset % this.colNum;
                if (moleculeIndex < this.maxMolecules && this.importer != null) {
                    try {
                        this.importer.seekRecord(moleculeIndex, null);
                        MDocument document = this.importer.nextDoc();
                        if (document == null) continue;
                        this.dataModel.setValueAt(document.getPrimaryMolecule(), rowIndex, columnIndex);
                        continue;
                    }
                    catch (Exception e) {
                        AlchemistErrorDialog.showError(e);
                        this.dataModel.setValueAt(null, rowIndex, columnIndex);
                        return;
                    }
                }
                this.dataModel.setValueAt(null, rowIndex, columnIndex);
            }
        }
    }

    private void initialize() {
        this.add((Component)this.getScrollBar(), "East");
        if (this.isToolbarVisible) {
            this.add((Component)this.getTopPanel(), "North");
            this.getTopPanel().setOpaque(false);
        }
        this.createAdjustPosition();
    }

    protected JScrollBar getScrollBar() {
        if (this.scrollBar == null) {
            this.scrollBar = new JScrollBar(1, 0, 0, 0, 0);
            this.scrollBar.addAdjustmentListener(new AdjustmentListener(){

                @Override
                public void adjustmentValueChanged(AdjustmentEvent e) {
                    AlchemistMoleculeView.this.currentRowNum = AlchemistMoleculeView.this.scrollBar.getValue();
                    if (!AlchemistMoleculeView.this.scrollBar.getValueIsAdjusting()) {
                        AlchemistMoleculeView.this.refreshView();
                        if (AlchemistMoleculeView.this.tooltip != null) {
                            AlchemistMoleculeView.this.tooltip.hide();
                            AlchemistMoleculeView.this.tooltip = null;
                        }
                        AlchemistMoleculeView.this.firePropertyChange(AlchemistMoleculeView.PROPERTY_KEY_SELECTED_MOLECULE_CHANGED, null, AlchemistMoleculeView.this.getSelectedMolecule());
                    } else {
                        AlchemistMoleculeView.this.adjustPosition.setText(AlchemistMoleculeView.this.currentRowNum * AlchemistMoleculeView.this.colNum + 1 + "/" + AlchemistMoleculeView.this.maxMolecules);
                        if (AlchemistMoleculeView.this.tooltip == null) {
                            Point cords = new Point(AlchemistMoleculeView.this.mousePosition);
                            SwingUtilities.convertPointToScreen(cords, AlchemistMoleculeView.this.scrollBar);
                            try {
                                AlchemistMoleculeView.this.tooltip = PopupFactory.getSharedInstance().getPopup(AlchemistMoleculeView.this.scrollBar, AlchemistMoleculeView.this.adjustPosition, cords.x, cords.y);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        if (!AlchemistMoleculeView.this.isChangingGrid && AlchemistMoleculeView.this.tooltip != null) {
                            AlchemistMoleculeView.this.tooltip.show();
                        }
                    }
                }
            });
            this.scrollBar.addMouseMotionListener(new MouseMotionListener(){

                @Override
                public void mouseMoved(MouseEvent e) {
                    AlchemistMoleculeView.this.mousePosition = e.getPoint();
                }

                @Override
                public void mouseDragged(MouseEvent e) {
                    AlchemistMoleculeView.this.mousePosition = e.getPoint();
                }
            });
        }
        return this.scrollBar;
    }

    protected JPanel getTopPanel() {
        if (this.topPanel == null) {
            this.columnLabel = new JLabel();
            this.columnLabel.setText("Number of Columns");
            this.columnLabel.setBorder(BorderFactory.createEmptyBorder(0, 30, 0, 3));
            this.rowLabel = new JLabel();
            this.rowLabel.setText("Number of Rows");
            this.rowLabel.setBorder(BorderFactory.createEmptyBorder(0, 3, 0, 3));
            this.topPanel = new JPanel();
            this.topPanel.setLayout(new BoxLayout(this.getTopPanel(), 0));
            this.topPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.topPanel.add((Component)this.rowLabel, null);
            this.topPanel.add((Component)this.getRowComboBox(), null);
            this.topPanel.add((Component)this.columnLabel, null);
            this.topPanel.add((Component)this.getColumnComboBox(), null);
        }
        return this.topPanel;
    }

    private JComboBox getRowComboBox() {
        if (this.rowComboBox == null) {
            this.rowComboBox = new JComboBox();
            for (int i = 0; i < this.maxColNum; ++i) {
                this.rowComboBox.addItem(String.valueOf(i + 1));
            }
            this.rowComboBox.setSelectedIndex(this.rowNum - 1);
            this.rowComboBox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() == 1) {
                        AlchemistMoleculeView.this.refreshGridLayout();
                    }
                }
            });
        }
        return this.rowComboBox;
    }

    protected void refreshGridLayout() {
        this.rowNum = this.getRowComboBox().getSelectedIndex() + 1;
        this.colNum = this.getColumnComboBox().getSelectedIndex() + 1;
        this.dataModel = new DefaultTableModel(this.rowNum, this.colNum);
        this.view.setModel(this.dataModel);
        this.view.setRowHeight(this.view.getSize().height / this.rowNum > 1 ? this.view.getSize().height / this.rowNum : 100);
        this.isChangingGrid = true;
        this.getScrollBar().setValueIsAdjusting(true);
        this.getScrollBar().setMaximum(this.maxMolecules % this.colNum == 0 ? this.maxMolecules / this.colNum : this.maxMolecules / this.colNum + 1);
        this.getScrollBar().setMinimum(0);
        this.getScrollBar().setVisibleAmount(this.rowNum);
        this.getScrollBar().setBlockIncrement(this.rowNum);
        this.getScrollBar().setValue(this.getScrollBar().getValue() > this.getScrollBar().getMaximum() ? this.getScrollBar().getMaximum() : this.getScrollBar().getValue());
        this.getScrollBar().setValueIsAdjusting(false);
        this.isChangingGrid = false;
    }

    private JComboBox getColumnComboBox() {
        if (this.columnComboBox == null) {
            this.columnComboBox = new JComboBox();
            for (int i = 0; i < this.maxColNum; ++i) {
                this.columnComboBox.addItem(String.valueOf(i + 1));
            }
            this.columnComboBox.setSelectedIndex(this.colNum - 1);
            this.columnComboBox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() == 1) {
                        AlchemistMoleculeView.this.refreshGridLayout();
                    }
                }
            });
        }
        return this.columnComboBox;
    }

    private void createAdjustPosition() {
        this.adjustPosition = new JTextArea();
        this.adjustPosition.setEditable(false);
        this.adjustPosition.setBackground(AlchemistGraphicsUtilities.ALCHEMIST_TOOLTIP_BGR);
        this.adjustPosition.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.BLACK), BorderFactory.createEmptyBorder(3, 3, 3, 3)));
    }

    protected void increaseView(int rowNum) {
        this.getScrollBar().setValue(this.getScrollBar().getValue() + rowNum > this.getScrollBar().getMaximum() ? this.getScrollBar().getMaximum() : this.getScrollBar().getValue() + rowNum);
    }

    protected void decreaseView(int rowNum) {
        this.getScrollBar().setValue(this.getScrollBar().getValue() - rowNum < this.getScrollBar().getMinimum() ? this.getScrollBar().getMinimum() : this.getScrollBar().getValue() - rowNum);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Runnable runnable = this.backgroundLoader;
        synchronized (runnable) {
            try {
                if (this.importer != null) {
                    this.importer.close();
                }
                this.importer = null;
                if (this.inputStream != null) {
                    this.inputStream.close();
                }
                this.inputStream = null;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void setColCount(int colNum) {
        this.colNum = this.maxColNum < colNum ? this.maxColNum : colNum;
        this.getColumnComboBox().setSelectedIndex(this.colNum - 1);
        this.refreshGridLayout();
    }

    public void setRowCount(int rowNum) {
        this.rowNum = this.maxRowNum < rowNum ? this.maxRowNum : rowNum;
        this.getRowComboBox().setSelectedIndex(this.rowNum - 1);
        this.refreshGridLayout();
    }

    public int getMaxColCount() {
        return this.maxColNum;
    }

    public int getMaxRowCount() {
        return this.maxRowNum;
    }

    @Override
    public int getRowCount() {
        return this.rowNum;
    }

    @Override
    public int getColCount() {
        return this.colNum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        Runnable runnable = this.backgroundLoader;
        synchronized (runnable) {
            this.stopLoading();
            this.getScrollBar().setValueIsAdjusting(true);
            this.getScrollBar().setValues(0, 0, 0, 0);
            this.getScrollBar().setValueIsAdjusting(false);
            super.clear();
            this.close();
        }
    }

    public int getProgressPercentage() {
        return this.percent;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.view.setEnabled(enabled);
        this.getRowComboBox().setEnabled(enabled);
        this.getColumnComboBox().setEnabled(enabled);
        this.getScrollBar().setEnabled(enabled);
    }

    public void addListSelectionListerer(ListSelectionListener listener) {
        this.getView().getSelectionModel().addListSelectionListener(listener);
    }

    public void removeListSelectionListener(ListSelectionListener listener) {
        this.getView().getSelectionModel().removeListSelectionListener(listener);
    }

    public Molecule getSelectedMolecule() {
        if (this.rowNum == 1 && this.colNum == 1) {
            return this.dataModel.getValueAt(0, 0) instanceof Molecule ? (Molecule)this.dataModel.getValueAt(0, 0) : null;
        }
        int rowIndex = this.getView().getSelectedRow();
        int columnIndex = this.getView().getSelectedColumn();
        return rowIndex > -1 && columnIndex > -1 && this.dataModel.getValueAt(rowIndex, columnIndex) instanceof Molecule ? (Molecule)this.dataModel.getValueAt(rowIndex, columnIndex) : null;
    }
}

