/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.alchemist.utils;

public class AlchemistProgressMonitor {
    long taskLength;
    long taskValue;
    boolean done;
    boolean canceled;
    String message;

    public AlchemistProgressMonitor() {
        this.taskValue = 0L;
        this.taskLength = 0L;
    }

    public AlchemistProgressMonitor(long taskLength) {
        this.taskLength = taskLength;
        this.taskValue = 0L;
    }

    public long getTaskLength() {
        return this.taskLength;
    }

    public void setTaskLength(long taskLength) {
        this.taskLength = taskLength;
    }

    public long getTaskValue() {
        return this.taskValue;
    }

    public void setTaskValue(long taskValue) {
        this.taskValue = taskValue;
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public void setCanceled(boolean canceled) {
        this.canceled = canceled;
    }

    public boolean isDone() {
        return this.done;
    }

    public void setDone(boolean done) {
        this.done = done;
    }

    public void reset() {
        this.taskValue = 0L;
        this.canceled = false;
        this.done = false;
    }

    public int getProgressPercent() {
        if (this.taskLength > 0L) {
            return (int)(this.taskValue * 100L / this.taskLength);
        }
        return 0;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getMessage() {
        return this.message;
    }

    public void close() {
        this.setTaskValue(this.getTaskLength());
        this.setDone(true);
    }

    public void init(int maxValue) {
        this.reset();
        this.setTaskValue(0L);
        this.setTaskLength(maxValue);
    }

    public void set(int value) {
        this.setTaskValue(value);
    }
}

