/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.alchemist.utils;

import java.beans.ExceptionListener;
import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.util.HashMap;
import java.util.Map;

public class AlchemistState {
    private Map<String, Object> properties = new HashMap<String, Object>();
    private Map<String, Object> persistentProperties = new HashMap<String, Object>();
    private final StateExceptionListener dummyExceptionListener = new StateExceptionListener();

    public void loadProperties(String path) throws FileNotFoundException {
        this.loadProperties(new File(path));
    }

    public void loadProperties(File file) throws FileNotFoundException {
        XMLDecoder xmlReader = new XMLDecoder(new FileInputStream(file), this, this.dummyExceptionListener);
        this.properties = (HashMap)xmlReader.readObject();
        this.persistentProperties = new HashMap<String, Object>(this.properties);
        xmlReader.close();
    }

    public void saveProperties(String path) throws FileNotFoundException {
        this.saveProperties(new File(path));
    }

    public void saveProperties(File file) throws FileNotFoundException {
        if (file.getParentFile() != null) {
            file.getParentFile().mkdirs();
        }
        XMLEncoder xmlWriter = new XMLEncoder(new FileOutputStream(file));
        xmlWriter.setExceptionListener(this.dummyExceptionListener);
        xmlWriter.writeObject(this.persistentProperties);
        xmlWriter.close();
    }

    public Object getProperty(String key) {
        return this.properties.get(key);
    }

    public void setProperty(String key, Object value) {
        this.properties.put(key, value);
    }

    public void setPersistentProperty(String key, Object value) {
        this.properties.put(key, value);
        this.persistentProperties.put(key, value);
    }

    public void removeProperty(String key) {
        this.properties.remove(key);
        this.persistentProperties.remove(key);
    }

    private static class StateExceptionListener
    implements ExceptionListener {
        private StateExceptionListener() {
        }

        @Override
        public void exceptionThrown(Exception e) {
        }
    }
}

