/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.alchemist.utils;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class AlchemistTableSizeConfigurerComponent
extends JPanel {
    private static final long serialVersionUID = 9173737079514680200L;
    private static final int DEFAULT_INITIAL_COL_NUM = 1;
    private static final int DEFAULT_INITAL_ROW_NUM = 1;
    private static final int DEFAULT_MAX_COL_NUM = 10;
    private static final int DEFAULT_MAX_ROW_NUM = 10;
    private final int maxRows;
    private final int maxCols;
    private int currentRows;
    private int currentCols;
    private JPanel viewPanel = null;
    private JSlider rowSlider = null;
    private JSlider colSlider = null;
    private JLabel sizeLabel = null;
    private JLabel applyLabel = null;
    private ActionListener listener = null;

    public AlchemistTableSizeConfigurerComponent(ActionListener listener) {
        this(listener, 10, 10);
    }

    public AlchemistTableSizeConfigurerComponent(ActionListener listener, int maxRows, int maxCols) {
        this(listener, 1, 1, maxRows, maxCols);
    }

    public AlchemistTableSizeConfigurerComponent(ActionListener listener, int initialRows, int initialCols, int maxRows, int maxCols) {
        this.listener = listener;
        this.maxRows = maxRows;
        this.maxCols = maxCols;
        this.currentRows = initialRows;
        this.currentCols = initialCols;
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints c1 = new GridBagConstraints();
        c1.fill = 1;
        c1.weightx = 1.0;
        c1.weighty = 1.0;
        c1.gridx = 0;
        c1.gridy = 0;
        GridBagConstraints c2 = new GridBagConstraints();
        c2.fill = 3;
        c2.gridx = 1;
        c2.gridy = 0;
        GridBagConstraints c3 = new GridBagConstraints();
        c3.fill = 2;
        c3.gridx = 0;
        c3.gridy = 1;
        GridBagConstraints c4 = new GridBagConstraints();
        c4.fill = 1;
        c4.gridx = 1;
        c4.gridy = 1;
        GridBagConstraints c5 = new GridBagConstraints();
        c5.gridx = 0;
        c5.gridy = 2;
        c5.gridwidth = 2;
        this.add((Component)this.getViewPanel(), c1);
        this.add((Component)this.getRowSlider(), c2);
        this.add((Component)this.getColSlider(), c3);
        this.add((Component)this.getSizeLabel(), c4);
        this.add((Component)this.getApplyLabel(), c5);
        this.setPreferredSize(new Dimension(150, 150));
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
    }

    private JPanel getViewPanel() {
        if (this.viewPanel == null) {
            this.viewPanel = new JPanel(){
                private static final long serialVersionUID = 7850325790926997064L;

                @Override
                protected void paintComponent(Graphics g) {
                    super.paintComponent(g);
                    Graphics2D g2 = (Graphics2D)g.create();
                    int width = (AlchemistTableSizeConfigurerComponent.this.viewPanel.getWidth() - 10) / AlchemistTableSizeConfigurerComponent.this.currentCols;
                    int height = (AlchemistTableSizeConfigurerComponent.this.viewPanel.getHeight() - 10) / AlchemistTableSizeConfigurerComponent.this.currentRows;
                    for (int i = 0; i < AlchemistTableSizeConfigurerComponent.this.currentCols; ++i) {
                        for (int j = 0; j < AlchemistTableSizeConfigurerComponent.this.currentRows; ++j) {
                            g2.setColor(Color.WHITE);
                            g2.fillRect(i * width + 5, j * height + 5, width - 2, height - 2);
                            g2.setColor(Color.DARK_GRAY);
                            g2.drawRect(i * width + 5, j * height + 5, width - 2, height - 2);
                        }
                    }
                    g2.dispose();
                }
            };
        }
        return this.viewPanel;
    }

    private JSlider getRowSlider() {
        if (this.rowSlider == null) {
            this.rowSlider = new JSlider(1, 1, this.maxRows, this.currentRows);
            this.rowSlider.setMajorTickSpacing(5);
            this.rowSlider.setMinorTickSpacing(1);
            this.rowSlider.setFocusable(false);
            this.rowSlider.setInverted(true);
            this.rowSlider.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    AlchemistTableSizeConfigurerComponent.this.refreshSize();
                }
            });
        }
        return this.rowSlider;
    }

    private JSlider getColSlider() {
        if (this.colSlider == null) {
            this.colSlider = new JSlider(0, 1, this.maxCols, this.currentCols);
            this.colSlider.setMajorTickSpacing(5);
            this.colSlider.setMinorTickSpacing(1);
            this.colSlider.setFocusable(false);
            this.colSlider.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    AlchemistTableSizeConfigurerComponent.this.refreshSize();
                }
            });
        }
        return this.colSlider;
    }

    private JLabel getSizeLabel() {
        if (this.sizeLabel == null) {
            this.sizeLabel = new JLabel(this.currentRows + "x" + this.currentCols);
        }
        return this.sizeLabel;
    }

    private JLabel getApplyLabel() {
        if (this.applyLabel == null) {
            this.applyLabel = new JLabel("<Click here to Apply>");
            this.applyLabel.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    AlchemistTableSizeConfigurerComponent.this.listener.actionPerformed(new ActionEvent(AlchemistTableSizeConfigurerComponent.this, 0, "apply"));
                }
            });
        }
        return this.applyLabel;
    }

    private void refreshSize() {
        this.currentCols = this.getColSlider().getValue();
        this.currentRows = this.getRowSlider().getValue();
        this.getSizeLabel().setText(this.currentRows + "x" + this.currentCols);
        this.getViewPanel().repaint();
    }

    public void setCurrentColCount(int cols) {
        this.getColSlider().setValue(cols);
    }

    public void setCurrentRowCount(int rows) {
        this.getRowSlider().setValue(rows);
    }

    public int getCurrentColCount() {
        return this.getColSlider().getValue();
    }

    public int getCurrentRowCount() {
        return this.getRowSlider().getValue();
    }
}

