/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.alchemist.utils;

import chemaxon.alchemist.utils.AlchemistProgressMonitor;
import chemaxon.formats.MolFormatException;
import chemaxon.formats.MolImporter;
import chemaxon.struc.Molecule;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class MetabolizerIndexGenerator {
    private static final String INVALID_FILE = "Not a valid Metabolizer data file";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean rebuildIndexFile(String inputFilePath, String outputFilePath, AlchemistProgressMonitor progressMonitor) throws MolFormatException {
        if (progressMonitor != null) {
            progressMonitor.setTaskLength(new File(inputFilePath).length());
            progressMonitor.setCanceled(false);
            progressMonitor.setDone(false);
        }
        MolImporter importer = null;
        BufferedWriter exporter = null;
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        try {
            importer = new MolImporter(inputFilePath);
            int molCount = 0;
            while (importer.skipRecord()) {
                ++molCount;
            }
            importer.seekRecord(molCount - 1, null);
            String lastLevelParent = importer.read().getProperty("METABOLIZER_PARENTSYNTHESISCODE");
            importer.seekRecord(0, null);
            Molecule mol = importer.read();
            int count = -1;
            ArrayList<Integer> seeks = new ArrayList<Integer>();
            ArrayList<String> items = new ArrayList<String>();
            String lastRemovedParentId = null;
            int level = 0;
            int lastLevel = 0;
            int lastRemovedParentLevel = -1;
            boolean lastLevelToMap = false;
            boolean noMapInsert = false;
            while (mol != null) {
                Integer pLevel;
                ++count;
                if (progressMonitor != null) {
                    progressMonitor.setTaskValue(importer.tell());
                }
                String id = mol.getProperty("Synthesis Code");
                String parent = mol.getProperty("METABOLIZER_PARENTSYNTHESISCODE");
                if (parent != null && parent.equalsIgnoreCase("")) {
                    parent = null;
                }
                if (parent != null && parent.equalsIgnoreCase("null")) {
                    parent = null;
                }
                if (id == null || map.containsKey(id)) {
                    if (progressMonitor != null) {
                        progressMonitor.setCanceled(true);
                    }
                    throw new MolFormatException(INVALID_FILE);
                }
                if (!lastLevelToMap && id.equals(lastLevelParent)) {
                    lastLevelToMap = true;
                }
                if ((level = parent == null ? 0 : ((pLevel = (Integer)map.get(parent)) == null ? lastRemovedParentLevel + 1 : pLevel + 1)) != lastLevel) {
                    if (!noMapInsert) {
                        map.put(id, level);
                    }
                    if (lastLevelToMap && !noMapInsert) {
                        seeks.add(count);
                        noMapInsert = true;
                    } else {
                        seeks.add(count);
                    }
                } else if (!noMapInsert) {
                    map.put(id, level);
                }
                lastLevel = level;
                if (parent != null) {
                    if (map.containsKey(parent)) {
                        lastRemovedParentLevel = (Integer)map.get(parent);
                        map.remove(parent);
                        items.add(parent + "\t" + (count + 1));
                        lastRemovedParentId = parent;
                    } else if (!parent.equals(lastRemovedParentId)) {
                        if (progressMonitor != null) {
                            progressMonitor.setCanceled(true);
                        }
                        throw new MolFormatException(INVALID_FILE);
                    }
                }
                mol = importer.read();
            }
            Iterator<Object> iter = map.values().iterator();
            while (iter.hasNext()) {
                int lvl;
                for (int i = lvl = ((Integer)iter.next()).intValue(); i < seeks.size(); ++i) {
                    seeks.set(i, (Integer)seeks.get(i) - 1);
                }
            }
            exporter = new BufferedWriter(new FileWriter(outputFilePath));
            iter = seeks.iterator();
            while (iter.hasNext()) {
                int element = (Integer)iter.next();
                exporter.write(element + "\n");
            }
            exporter.write("\n");
            for (String element : items) {
                exporter.write(element + "\n");
            }
        }
        catch (MolFormatException e) {
            if (progressMonitor != null) {
                progressMonitor.setCanceled(true);
            }
            throw e;
        }
        catch (IOException e) {
            if (progressMonitor != null) {
                progressMonitor.setCanceled(true);
            }
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (importer != null) {
                    importer.close();
                }
            }
            catch (Exception ex) {}
            try {
                if (exporter != null) {
                    exporter.close();
                }
            }
            catch (Exception ex) {}
        }
        if (progressMonitor != null) {
            progressMonitor.setDone(true);
        }
        return true;
    }

    public static void main(String[] args) {
        try {
            MetabolizerIndexGenerator.rebuildIndexFile(args[0], args[1], null);
        }
        catch (MolFormatException e) {
            e.printStackTrace();
        }
    }
}

