/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.alchemist.utils;

import chemaxon.alchemist.utils.AlchemistMoleculePainter;
import chemaxon.struc.Molecule;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;

public class MoleculeTableCellRenderer
extends JComponent
implements TableCellRenderer {
    private static final long serialVersionUID = -6909830842650161321L;
    private Molecule molecule;
    private final JPanel panel = new JPanel();
    private final JLabel label;
    private Boolean useCustomLabel;
    private Map<Integer, String> customLabels;
    private int dispOpts = AlchemistMoleculePainter.DEFAULT_DISPLAY_OPTIONS;
    public static final String PROPERTY_KEY_IS_LABEL_VISIBLE = "MoleculeTableCellRenderer_isLabelVisible";
    public static final String PROPERTY_KEY_CURRENT_ROW_NUM = "MoleculeTableCellRenderer_CurrentRowNum";
    public static final String PROPERTY_KEY_MOLECULE_COUNT = "MoleculeTableCellRenderer_MoleculeCount";
    public static final String PROPERTY_KEY_USE_CUSTOM_LABEL = "MoleculeTableCellRenderer_IsCustomLabelVisible";
    public static final String PROPERTY_KEY_CUSTOM_LABELS = "MoleculeTableCellRenderer_CustomLabels";

    public MoleculeTableCellRenderer() {
        this.panel.setOpaque(false);
        this.panel.setLayout(new BoxLayout(this.panel, 1));
        this.label = new JLabel();
        this.label.setAlignmentX(0.5f);
        this.panel.add(this.label);
        this.panel.add(this);
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.molecule != null) {
            AlchemistMoleculePainter.drawMolecule(0, 0, this.molecule, g, this.getSize(), this.dispOpts);
        }
    }

    public int getDispOpts() {
        return this.dispOpts;
    }

    public void setDispOpts(int dispOpts) {
        this.dispOpts = dispOpts;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (isSelected) {
            this.panel.setBorder(BorderFactory.createLineBorder(Color.BLUE));
        } else {
            this.panel.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        }
        this.molecule = (Molecule)value;
        Boolean isLabelVisible = (Boolean)table.getClientProperty(PROPERTY_KEY_IS_LABEL_VISIBLE);
        if (isLabelVisible != null && isLabelVisible.booleanValue()) {
            if (this.molecule != null) {
                this.useCustomLabel = (Boolean)table.getClientProperty(PROPERTY_KEY_USE_CUSTOM_LABEL);
                if (this.useCustomLabel != null && this.useCustomLabel.booleanValue()) {
                    this.customLabels = (Map)table.getClientProperty(PROPERTY_KEY_CUSTOM_LABELS);
                    if (this.customLabels != null) {
                        String text = this.customLabels.get(row * table.getColumnCount() + column);
                        this.label.setText(text == null ? "" : text);
                    } else {
                        this.label.setText("");
                    }
                } else {
                    Integer currentRowNum = (Integer)table.getClientProperty(PROPERTY_KEY_CURRENT_ROW_NUM);
                    Integer moleculeCount = (Integer)table.getClientProperty(PROPERTY_KEY_MOLECULE_COUNT);
                    String labelData = null;
                    if (currentRowNum != null) {
                        labelData = String.valueOf(currentRowNum * table.getColumnCount() + row * table.getColumnCount() + column + 1);
                    }
                    this.label.setText(labelData == null ? "" : "[ " + labelData + (moleculeCount == null ? "" : "/" + moleculeCount) + " ]");
                }
            } else {
                this.label.setText("");
            }
        } else {
            this.label.setText("");
        }
        return this.panel;
    }
}

