/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.alchemist.utils.moleculetree;

import chemaxon.alchemist.metabolizer.moleculetree.AlchemistMoleculeTreeCellRenderer;
import chemaxon.alchemist.utils.AlchemistErrorDialog;
import chemaxon.alchemist.utils.AlchemistGraphicsUtilities;
import chemaxon.alchemist.utils.AlchemistMoleculePainter;
import chemaxon.alchemist.utils.AlchemistProgressMonitor;
import chemaxon.alchemist.utils.moleculetree.AlchemistTreeNode;
import chemaxon.alchemist.utils.moleculetree.IterableTreeModel;
import chemaxon.alchemist.utils.moleculetree.MoleculeTreeExporter;
import chemaxon.alchemist.utils.moleculetree.TreeDataProvider;
import chemaxon.struc.Molecule;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.border.EmptyBorder;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class AlchemistMoleculeTree
extends JTree {
    private static final long serialVersionUID = -811818159941834677L;
    public static final String PROPERTY_KEY_NODE_LOADING = "nodeLoading";
    public static final String PROPERTY_KEY_SHOW_NODE_STATUSBAR = "statusbarVisible";
    public static final String PROPERTY_KEY_SHOW_NODE_BORDER = "nodeBorderVisible";
    public static final String PROPERTY_KEY_SHOW_MOLECULE = "moleculeVisible";
    public static final String PROPERTY_KEY_DETAILS_ENABLED = "detailsEnabled";
    public static final String PROPERTY_KEY_MAGNIFIER_ENABLED = "magnifierEnabled";
    public static final String PROPERTY_KEY_ZOOM_FACTOR = "zoomFactor";
    public static final String PROPERTY_KEY_SHOW_STEP_LINES = "stepLinesVisible";
    public static final String PROPERTY_KEY_SHOW_NODE_LINES = "nodeLinesVisible";
    public static final String PROPERTY_KEY_SHOW_NODE_CAPTION = "nodeCaptionVisible";
    public static final String PROPERTY_KEY_SELECTED_REACTION_NODE = "selectedReactionNode";
    public static final String PROPERTY_KEY_BRACKET_ON_FOCUS = "bracketOnFocus";
    public static final int ZONE_CIRCLE_RADIUS = 10;
    public static final int DEFAULT_ROW_WIDTH = 100;
    public static final int DEFAULT_ROW_HEIGHT = 24;
    public static final int TREE_CHILD_INDENT = 100;
    public static final float MINIMUM_ZOOM_FACTOR = 0.1f;
    public static final float MAXIMUM_ZOOM_FACTOR = 2.0f;
    public static final String ROOT_UNIQUE_ID = "GLOBAL_ROOT";
    private static final int TREE_NODE_WIDTH_INC = 13;
    protected final Map<AlchemistTreeNode, Rectangle> visibleNodesMap = new HashMap<AlchemistTreeNode, Rectangle>();
    protected final Map<String, String> zoneLabelsMap = new HashMap<String, String>();
    protected final Map<Rectangle, AlchemistTreeNode> zonesMap = new HashMap<Rectangle, AlchemistTreeNode>();
    protected final Map<String, AlchemistTreeNode> nodeMap = new HashMap<String, AlchemistTreeNode>();
    protected final Map<String, String> detailedPropertiesMap = new HashMap<String, String>();
    private final Map<Class<? extends MoleculeTreeExporter>, MoleculeTreeExporter> exportersMap = new HashMap<Class<? extends MoleculeTreeExporter>, MoleculeTreeExporter>();
    private JPopupMenu popupMenu = null;
    private JMenu exportersMenu = null;
    protected AlchemistTreeNode selectedReactionNode = null;
    protected boolean loadingNodes = false;
    protected boolean expandingNewNode = false;
    protected AlchemistTreeNode popupNode = null;
    protected Point dragStartPoint = null;
    protected Point mousePosition = new Point(0, 0);
    protected Point lastZonePopup = null;
    protected Point lastMagnifierPopup = null;
    protected Point lastLabelPopup = null;
    protected AlchemistTreeNode loadingNodeRoot = null;
    private boolean clickedOnTreeHandler = false;
    protected boolean expandLock = false;
    private String zonePopupText = null;
    private BufferedImage popupLabelImage = null;
    private final AlchemistProgressMonitor innerProgressMonitor = new AlchemistProgressMonitor();
    private TreeDataProvider<AlchemistTreeNode> dataProvider;
    protected final Timer nodeLoadTimer = new Timer(100, new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            AlchemistMoleculeTree.this.nodeLoadTimer.stop();
            if (AlchemistMoleculeTree.this.innerProgressMonitor.isDone() || AlchemistMoleculeTree.this.innerProgressMonitor.isCanceled()) {
                if (AlchemistMoleculeTree.this.loadingNodeRoot != null) {
                    AlchemistMoleculeTree.this.loadingNodeRoot.setLoadPercentage(AlchemistMoleculeTree.this.innerProgressMonitor.getProgressPercent());
                    ((DefaultTreeModel)AlchemistMoleculeTree.this.getModel()).nodeChanged(AlchemistMoleculeTree.this.loadingNodeRoot);
                }
                AlchemistMoleculeTree.this.nodeLoadTimer.restart();
            }
        }
    });

    public AlchemistMoleculeTree() {
        this(new IterableTreeModel(new AlchemistTreeNode(ROOT_UNIQUE_ID)));
    }

    protected AlchemistMoleculeTree(IterableTreeModel newModel) {
        super(newModel);
        BasicTreeUI treeUI = (BasicTreeUI)this.getUI();
        treeUI.setLeftChildIndent((int)(100.0f * this.getZoomFactor()));
        this.setBackground(Color.WHITE);
        this.putClientProperty("JTree.lineStyle", "None");
        this.setBorder(BorderFactory.createEmptyBorder(0, 0, 220, 220));
        this.setCellRenderer(new AlchemistMoleculeTreeCellRenderer());
        this.setRootVisible(false);
        this.setRowHeight(0);
        this.setShowsRootHandles(true);
        this.setDoubleBuffered(true);
        this.setZoomFactor(1.0f);
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                if (AlchemistMoleculeTree.this.dragStartPoint != null) {
                    AlchemistMoleculeTree.this.mousePosition = e.getPoint();
                    AlchemistMoleculeTree.this.repaint();
                }
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                AlchemistMoleculeTree.this.mousePosition = e.getPoint();
                TreePath path = AlchemistMoleculeTree.this.getPathForLocation(e.getX(), e.getY());
                if (AlchemistMoleculeTree.this.isMagnifierEnabled() || AlchemistMoleculeTree.this.isDetailsEnabled()) {
                    if (path != null) {
                        AlchemistTreeNode node = (AlchemistTreeNode)path.getLastPathComponent();
                        Rectangle r = AlchemistMoleculeTree.this.visibleNodesMap.get(node);
                        if (r != null) {
                            Point p = new Point(r.x + r.width, r.y + (int)(24.0f * AlchemistMoleculeTree.this.getZoomFactor() + 11.0f));
                            if (AlchemistMoleculeTree.this.lastMagnifierPopup == null || AlchemistMoleculeTree.this.lastMagnifierPopup.x != p.x || AlchemistMoleculeTree.this.lastMagnifierPopup.y != p.y) {
                                AlchemistMoleculeTree.this.hideMagnifierPopup();
                                AlchemistMoleculeTree.this.showMagnifierPopup(node, p);
                            }
                        }
                    } else {
                        Rectangle[] rcoords = AlchemistMoleculeTree.this.zonesMap.keySet().toArray(new Rectangle[0]);
                        for (int i = 0; i < rcoords.length; ++i) {
                            Rectangle rrect = rcoords[i];
                            if (!rrect.contains(e.getX(), e.getY())) continue;
                            Point p = new Point(rrect.x + rrect.width, rrect.y + rrect.height);
                            if (AlchemistMoleculeTree.this.lastZonePopup == null || AlchemistMoleculeTree.this.lastZonePopup.x != p.x || AlchemistMoleculeTree.this.lastZonePopup.y != p.y) {
                                AlchemistTreeNode node = AlchemistMoleculeTree.this.zonesMap.get(rrect);
                                String[] zoneNames = AlchemistMoleculeTree.this.getNodeIDsFromRoot(node);
                                String zoneName = "Unknown";
                                if (zoneNames != null && zoneNames.length > 0) {
                                    zoneName = AlchemistMoleculeTree.this.zoneLabelsMap.containsKey(zoneNames[zoneNames.length - 1]) ? AlchemistMoleculeTree.this.zoneLabelsMap.get(zoneNames[zoneNames.length - 1]) : zoneNames[zoneNames.length - 1];
                                }
                                AlchemistMoleculeTree.this.hideZoneLabel();
                                AlchemistMoleculeTree.this.showZoneLabel(zoneName, p);
                            }
                            return;
                        }
                        AlchemistMoleculeTree.this.hideMagnifierPopup();
                        AlchemistMoleculeTree.this.hideZoneLabel();
                    }
                }
                if (path != null) {
                    AlchemistMoleculeTree.this.handleLabelUpdate(path);
                } else {
                    AlchemistMoleculeTree.this.hideMoleculeLabel();
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            AlchemistMoleculeTree.this.hideMagnifierPopup();
                        }
                    });
                }
            }
        });
        this.addTreeWillExpandListener(new TreeWillExpandListener(){

            @Override
            public void treeWillCollapse(TreeExpansionEvent event) throws ExpandVetoException {
                AlchemistMoleculeTree.this.clickedOnTreeHandler = true;
            }

            @Override
            public void treeWillExpand(TreeExpansionEvent event) throws ExpandVetoException {
                if (AlchemistMoleculeTree.this.loadingNodes) {
                    throw new ExpandVetoException(event);
                }
                AlchemistMoleculeTree.this.clickedOnTreeHandler = true;
                TreePath path = event.getPath();
                Object obj = path.getLastPathComponent();
                if (obj instanceof AlchemistTreeNode) {
                    AlchemistMoleculeTree.this.loadingNodeRoot = (AlchemistTreeNode)obj;
                    if (AlchemistMoleculeTree.this.loadingNodeRoot.isChildrenLoaded()) {
                        return;
                    }
                    AlchemistMoleculeTree.this.expandingNewNode = true;
                    if (!AlchemistMoleculeTree.ROOT_UNIQUE_ID.equals(AlchemistMoleculeTree.this.loadingNodeRoot.getUniqueID())) {
                        AlchemistMoleculeTree.this.setCursor(Cursor.getPredefinedCursor(3));
                        while (AlchemistMoleculeTree.this.loadingNodeRoot.getChildCount() > 0) {
                            AlchemistTreeNode node = (AlchemistTreeNode)AlchemistMoleculeTree.this.loadingNodeRoot.getChildAt(0);
                            AlchemistMoleculeTree.this.nodeMap.remove(node.getUniqueID());
                            ((DefaultTreeModel)AlchemistMoleculeTree.this.getModel()).removeNodeFromParent(node);
                            AlchemistMoleculeTree.this.visibleNodesMap.remove(node);
                        }
                        if (!AlchemistMoleculeTree.this.loadingNodes) {
                            AlchemistMoleculeTree.this.loadingNodeRoot.setLoading(true);
                            AlchemistMoleculeTree.this.loadingNodes = true;
                            AlchemistMoleculeTree.this.firePropertyChange(AlchemistMoleculeTree.PROPERTY_KEY_NODE_LOADING, Boolean.FALSE, Boolean.TRUE);
                            Thread thread = new Thread(new Runnable(){
                                AlchemistTreeNode[] result = null;

                                @Override
                                public void run() {
                                    try {
                                        this.result = AlchemistMoleculeTree.this.dataProvider.getTreeData(AlchemistMoleculeTree.this.loadingNodeRoot, AlchemistMoleculeTree.this.innerProgressMonitor);
                                    }
                                    catch (IOException e) {
                                        AlchemistErrorDialog.showError("Data provider exception", (Exception)e);
                                    }
                                    AlchemistMoleculeTree.this.expandLock = true;
                                    if (this.result != null) {
                                        AlchemistMoleculeTree.this.addNodes(this.result);
                                    }
                                    AlchemistMoleculeTree.this.expandLock = false;
                                    SwingUtilities.invokeLater(new Runnable(){

                                        @Override
                                        public void run() {
                                            AlchemistMoleculeTree.this.loadingNodes = false;
                                            if (AlchemistMoleculeTree.this.loadingNodeRoot != null) {
                                                AlchemistMoleculeTree.this.loadingNodeRoot.setLoading(false);
                                                ((DefaultTreeModel)AlchemistMoleculeTree.this.getModel()).nodeChanged(AlchemistMoleculeTree.this.loadingNodeRoot);
                                                if (!AlchemistMoleculeTree.this.innerProgressMonitor.isCanceled()) {
                                                    AlchemistMoleculeTree.this.loadingNodeRoot.setChildrenLoaded(true);
                                                    boolean removed = false;
                                                    for (int i = 0; i < AlchemistMoleculeTree.this.loadingNodeRoot.getChildCount() && !removed; ++i) {
                                                        AlchemistTreeNode child = (AlchemistTreeNode)AlchemistMoleculeTree.this.loadingNodeRoot.getChildAt(i);
                                                        if (!child.getUniqueID().equalsIgnoreCase("virtual" + AlchemistMoleculeTree.this.loadingNodeRoot.getUniqueID())) continue;
                                                        removed = true;
                                                        AlchemistMoleculeTree.this.nodeMap.remove(child.getUniqueID());
                                                        ((DefaultTreeModel)AlchemistMoleculeTree.this.getModel()).removeNodeFromParent(child);
                                                    }
                                                    AlchemistMoleculeTree.this.expandPath(new TreePath(AlchemistMoleculeTree.this.loadingNodeRoot.getPath()));
                                                    if (AlchemistMoleculeTree.this.loadingNodeRoot.getChildCount() == 0) {
                                                        AlchemistMoleculeTree.this.loadingNodeRoot.setChildrenDepth(-1);
                                                    }
                                                }
                                            }
                                            AlchemistMoleculeTree.this.loadingNodeRoot = null;
                                            AlchemistMoleculeTree.this.setCursor(Cursor.getPredefinedCursor(0));
                                            AlchemistMoleculeTree.this.firePropertyChange(AlchemistMoleculeTree.PROPERTY_KEY_NODE_LOADING, Boolean.TRUE, Boolean.FALSE);
                                        }
                                    });
                                }
                            });
                            thread.setPriority(4);
                            thread.start();
                            AlchemistMoleculeTree.this.nodeLoadTimer.start();
                        }
                        throw new ExpandVetoException(event);
                    }
                }
            }
        });
        this.addTreeExpansionListener(new TreeExpansionListener(){

            @Override
            public void treeCollapsed(TreeExpansionEvent event) {
                AlchemistMoleculeTree.this.gatherVisibleNodes();
                AlchemistMoleculeTree.this.hideMoleculeLabel();
            }

            @Override
            public void treeExpanded(TreeExpansionEvent event) {
                TreePath path = event.getPath();
                Object[] pathObj = path.getPath();
                boolean done = false;
                for (int i = pathObj.length - 1; i > 0 && !done; --i) {
                    if (!(pathObj[i] instanceof AlchemistTreeNode)) continue;
                    AlchemistTreeNode node = (AlchemistTreeNode)pathObj[i];
                    if (i == pathObj.length - 1) {
                        node.setChildrenDepth(((IterableTreeModel)AlchemistMoleculeTree.this.getModel()).getSubTreeHeight(node));
                    }
                    boolean bl = done = !((IterableTreeModel)AlchemistMoleculeTree.this.getModel()).isNodeInDeepestPath(node);
                    if (done) continue;
                    AlchemistTreeNode parentNode = (AlchemistTreeNode)node.getParent();
                    parentNode.setChildrenDepth(((IterableTreeModel)AlchemistMoleculeTree.this.getModel()).getSubTreeHeight(node) + 1);
                }
                if (AlchemistMoleculeTree.this.expandingNewNode) {
                    AlchemistMoleculeTree.this.recalculateTreeData();
                }
                AlchemistMoleculeTree.this.expandingNewNode = false;
                AlchemistMoleculeTree.this.gatherVisibleNodes();
                if (AlchemistMoleculeTree.this.popupNode != null) {
                    AlchemistMoleculeTree.this.popupNode = (AlchemistTreeNode)event.getPath().getLastPathComponent();
                }
                AlchemistMoleculeTree.this.hideMoleculeLabel();
            }
        });
        this.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                if (e.getNewLeadSelectionPath() == null) {
                    AlchemistMoleculeTree.this.selectedReactionNode = null;
                }
                AlchemistMoleculeTree.this.handleLabelUpdate(AlchemistMoleculeTree.this.getSelectionPath());
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getButton() == 1) {
                    Rectangle[] rcoords = AlchemistMoleculeTree.this.zoneLabelsMap.keySet().toArray(new Rectangle[0]);
                    for (int i = 0; i < rcoords.length; ++i) {
                        Rectangle rrect = rcoords[i];
                        if (!rrect.contains(e.getX(), e.getY())) continue;
                        AlchemistMoleculeTree.this.selectedReactionNode = AlchemistMoleculeTree.this.zonesMap.get(rrect);
                        AlchemistMoleculeTree.this.setSelectionRow(-1);
                        AlchemistMoleculeTree.this.repaint();
                        return;
                    }
                    if (!AlchemistMoleculeTree.this.clickedOnTreeHandler && AlchemistMoleculeTree.this.getRowForLocation(e.getX(), e.getY()) == -1) {
                        AlchemistMoleculeTree.this.setSelectionRow(-1);
                    }
                    AlchemistMoleculeTree.this.clickedOnTreeHandler = false;
                    if (AlchemistMoleculeTree.this.getSelectionPath() != null) {
                        AlchemistMoleculeTree.this.handleLabelUpdate(AlchemistMoleculeTree.this.getSelectionPath());
                    }
                } else if (e.getButton() == 3 && !AlchemistMoleculeTree.this.exportersMap.isEmpty()) {
                    if (AlchemistMoleculeTree.this.getSelectionCount() > 0) {
                        AlchemistMoleculeTree.this.getPopupMenu().show(AlchemistMoleculeTree.this, e.getX(), e.getY());
                    } else {
                        AlchemistTreeNode[] nodes = AlchemistMoleculeTree.this.visibleNodesMap.keySet().toArray(new AlchemistTreeNode[0]);
                        for (int i = 0; i < nodes.length; ++i) {
                            Rectangle rrect = AlchemistMoleculeTree.this.visibleNodesMap.get(nodes[i]);
                            if (!rrect.contains(e.getX(), e.getY())) continue;
                            AlchemistMoleculeTree.this.setSelectionPath(new TreePath(nodes[i].getPath()));
                            AlchemistMoleculeTree.this.getPopupMenu().show(AlchemistMoleculeTree.this, e.getX(), e.getY());
                            return;
                        }
                    }
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.getButton() == 3) {
                    AlchemistMoleculeTree.this.dragStartPoint = e.getPoint();
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (AlchemistMoleculeTree.this.dragStartPoint != null) {
                    int w = Math.abs(AlchemistMoleculeTree.this.dragStartPoint.x - e.getX());
                    int h = Math.abs(AlchemistMoleculeTree.this.dragStartPoint.y - e.getY());
                    if (w < 10 || h < 10) {
                        AlchemistMoleculeTree.this.dragStartPoint = null;
                        return;
                    }
                    float factor = (float)AlchemistMoleculeTree.this.getVisibleRect().getWidth() / (float)w * AlchemistMoleculeTree.this.getZoomFactor();
                    AlchemistMoleculeTree.this.scrollRectToVisible(new Rectangle((int)((float)AlchemistMoleculeTree.this.dragStartPoint.x * factor), (int)((float)AlchemistMoleculeTree.this.dragStartPoint.y * factor), (int)((float)w * factor), (int)((float)h * factor)));
                    AlchemistMoleculeTree.this.dragStartPoint = null;
                }
                AlchemistMoleculeTree.this.repaint();
            }
        });
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        Rectangle rect = this.getVisibleRect();
        Graphics2D gr = (Graphics2D)g;
        if (this.isStepLineVisible()) {
            int x = rect.x;
            int y = rect.y;
            while (x % (int)(100.0f * this.getZoomFactor() + 13.0f) != 0) {
                ++x;
            }
            gr.setColor(Color.LIGHT_GRAY);
            gr.setStroke(AlchemistGraphicsUtilities.DASHED_STROKE);
            int i = x -= 2;
            while (i < rect.x + this.getWidth()) {
                gr.drawLine(i, y, i, y + rect.height);
                i = i + (int)(100.0f * this.getZoomFactor()) + 13;
            }
        }
        if (this.isNodeLineVisible()) {
            Set<AlchemistTreeNode> set = this.visibleNodesMap.keySet();
            AlchemistTreeNode[] obj = set.toArray(new AlchemistTreeNode[0]);
            boolean hasSelected = false;
            int sx = 0;
            int sy = 0;
            int r = 10;
            for (int i = 0; i < obj.length; ++i) {
                Rectangle nSibRect;
                AlchemistTreeNode node = obj[i];
                AlchemistTreeNode nSib = (AlchemistTreeNode)node.getNextSibling();
                AlchemistTreeNode pSib = (AlchemistTreeNode)node.getPreviousSibling();
                Rectangle nRect = this.visibleNodesMap.get(obj[i]);
                if (nRect == null) continue;
                int hws = (int)((float)(nRect.x - nRect.width / 2) - (1.0f - this.getZoomFactor()) * 13.0f);
                int hha = nRect.y + nRect.height / 2;
                gr.setColor(Color.LIGHT_GRAY);
                gr.setStroke(AlchemistGraphicsUtilities.DOTTED_STROKE);
                gr.drawLine(nRect.x, hha, hws, hha);
                if (pSib != null) {
                    Rectangle pSibRect = this.visibleNodesMap.get(pSib);
                    if (pSibRect == null) {
                        gr.drawLine(hws, hha, hws, rect.y);
                    } else {
                        gr.drawLine(hws, hha, hws, pSibRect.y + pSibRect.height / 2);
                    }
                } else {
                    Rectangle pRect = this.visibleNodesMap.get(node.getParent());
                    if (pRect == null) {
                        gr.drawLine(hws, hha, hws, rect.y);
                    } else {
                        gr.drawLine(hws, hha, hws, pRect.y + pRect.height);
                    }
                }
                if (nSib != null && (nSibRect = this.visibleNodesMap.get(nSib)) == null) {
                    gr.drawLine(hws, hha, hws, rect.y + rect.height);
                }
                gr.setStroke(AlchemistGraphicsUtilities.NORMAL_STROKE);
                int x1 = hws - 5;
                int y1 = hha - 5;
                if (this.getSelectedReactionNode() != null && node == this.getSelectedReactionNode()) {
                    hasSelected = true;
                    sx = x1;
                    sy = y1;
                    continue;
                }
                gr.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                gr.fillOval(x1, y1, r + 1, r + 1);
                gr.setColor(Color.WHITE);
                gr.fillOval(x1 + 2, y1 + 2, r - 3, r - 3);
                gr.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            }
            if (hasSelected) {
                gr.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                gr.setColor(Color.RED);
                gr.fillOval(sx, sy, r + 1, r + 1);
                gr.setColor(Color.LIGHT_GRAY);
                gr.fillOval(sx + 2, sy + 2, r - 3, r - 3);
                gr.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            }
        }
        if (this.isMagnifierEnabled() && this.popupNode != null) {
            Graphics gr2 = gr.create();
            gr2.translate(this.lastMagnifierPopup.x, this.lastMagnifierPopup.y);
            gr2.setColor(Color.WHITE);
            gr2.fillRect(0, 0, 200, this.isNodeStatusbarVisible() ? 225 : 200);
            AlchemistMoleculePainter.drawMolecule(this.popupNode.getMolecule(), gr2);
            gr2.setColor(AlchemistMoleculeTreeCellRenderer.getNodeColor(this, this.popupNode));
            gr2.drawRect(0, 0, 200, this.isNodeStatusbarVisible() ? 225 : 200);
            gr2.dispose();
            if (this.isNodeStatusbarVisible()) {
                Graphics2D gr3 = (Graphics2D)gr.create();
                gr3.setColor(Color.BLACK);
                gr3.translate(this.lastMagnifierPopup.x, this.lastMagnifierPopup.y + 200);
                AlchemistMoleculeTreeCellRenderer.paintToolBar(gr3, 1.5f, this.popupNode);
                gr3.dispose();
            }
        }
        if (this.zonePopupText != null) {
            Graphics gr2 = gr.create();
            int w = SwingUtilities.computeStringWidth(this.getFontMetrics(this.getFont()), this.zonePopupText) + 6;
            gr2.translate(this.lastZonePopup.x + 10, this.lastZonePopup.y + 10);
            gr2.setColor(AlchemistGraphicsUtilities.ALCHEMIST_TOOLTIP_BGR);
            gr2.fillRect(0, 0, w, 20);
            gr2.setColor(Color.BLACK);
            gr2.drawString(this.zonePopupText, 3, 15);
            gr2.drawRect(0, 0, w, 20);
            gr2.dispose();
        }
        this.paintMoleculeDataPopup(gr);
        if (this.popupLabelImage != null) {
            Graphics g2 = g.create();
            g2.drawImage(this.popupLabelImage, this.lastLabelPopup.x, this.lastLabelPopup.y, Color.WHITE, null);
            g2.dispose();
        }
        if (this.dragStartPoint != null) {
            gr.setStroke(AlchemistGraphicsUtilities.NORMAL_STROKE);
            gr.setColor(Color.BLUE);
            gr.drawRect(this.dragStartPoint.x, this.dragStartPoint.y, this.mousePosition.x, this.mousePosition.y);
        }
        if (this.getZoomFactor() != 1.0f) {
            Graphics2D gr2 = (Graphics2D)g.create();
            gr2.setColor(AlchemistGraphicsUtilities.ALCHEMIST_TOOLTIP_BGR);
            gr2.setStroke(AlchemistGraphicsUtilities.NORMAL_STROKE);
            gr2.setFont(this.getFont().deriveFont(1));
            String text = "Zoom: " + (int)(this.getZoomFactor() * 100.0f) + "%";
            int height = gr2.getFontMetrics().getHeight() + 3;
            int width = SwingUtilities.computeStringWidth(gr2.getFontMetrics(), text) + 10;
            gr2.translate(rect.x + rect.width - (width + 10), rect.y + 5);
            gr2.fillRect(0, 0, width, height + 6);
            gr2.setColor(Color.BLACK);
            int y = gr2.getFontMetrics().getAscent() + 5;
            gr2.drawString(text, 5, y);
            gr2.drawRect(0, 0, width, height + 6);
            gr2.dispose();
        }
    }

    protected void paintMoleculeDataPopup(Graphics g) {
        if (this.isDetailsEnabled() && this.popupNode != null && this.popupNode.getMolecule() != null && !this.popupNode.getMolecule().isReaction()) {
            Graphics gr2 = g.create();
            gr2.translate(this.isMagnifierEnabled() ? this.lastMagnifierPopup.x + 205 : this.lastMagnifierPopup.x, this.lastMagnifierPopup.y + 11);
            gr2.setColor(AlchemistGraphicsUtilities.ALCHEMIST_TOOLTIP_BGR);
            int count = 0;
            for (String label : this.detailedPropertiesMap.keySet()) {
                if (this.popupNode.getProperty(label) == null) continue;
                ++count;
            }
            if (count > 0) {
                int height = count * (gr2.getFontMetrics().getHeight() + 3);
                if (this.isNodeBorderVisible()) {
                    height += 15 + 6 * (gr2.getFontMetrics().getHeight() + 3);
                }
                gr2.fillRect(0, 0, 175, height + 10);
                gr2.setColor(Color.BLACK);
                int y = gr2.getFontMetrics().getAscent() + 5;
                Font normalFont = gr2.getFont();
                Font boldFont = normalFont.deriveFont(1);
                for (String label : this.detailedPropertiesMap.keySet()) {
                    if (this.popupNode.getProperty(label) == null) continue;
                    gr2.setFont(boldFont);
                    gr2.drawString(this.detailedPropertiesMap.get(label) + ":", 5, y);
                    gr2.setFont(normalFont);
                    String data = new DecimalFormat("0.00").format(Float.parseFloat(this.popupNode.getProperty(label)) * 100.0f) + "%";
                    gr2.drawString(data, 125, y);
                    y += gr2.getFontMetrics().getHeight() + 3;
                }
                gr2.drawRect(0, 0, 175, height + 10);
            }
            gr2.dispose();
        }
    }

    public void setZoomFactor(float zoomFactor) {
        if (zoomFactor < 0.1f || zoomFactor > 2.0f) {
            throw new IllegalArgumentException("Zoom factor is out of range [0.1, 2.0]");
        }
        this.putClientProperty(PROPERTY_KEY_ZOOM_FACTOR, Float.valueOf(zoomFactor));
        this.hideMagnifierPopup();
        this.hideMoleculeLabel();
        ((BasicTreeUI)this.getUI()).setLeftChildIndent((int)(100.0f * zoomFactor));
        this.revalidate();
        this.gatherVisibleNodes();
    }

    public float getZoomFactor() {
        return this.getClientProperty(PROPERTY_KEY_ZOOM_FACTOR) instanceof Float ? ((Float)this.getClientProperty(PROPERTY_KEY_ZOOM_FACTOR)).floatValue() : 1.0f;
    }

    public AlchemistTreeNode getSelectedReactionNode() {
        return this.selectedReactionNode;
    }

    public boolean isMagnifierEnabled() {
        return Boolean.TRUE.equals(this.getClientProperty(PROPERTY_KEY_MAGNIFIER_ENABLED));
    }

    public void setMagnifierEnabled(boolean enabled) {
        this.putClientProperty(PROPERTY_KEY_MAGNIFIER_ENABLED, enabled);
        this.repaint();
    }

    public boolean isDetailsEnabled() {
        return Boolean.TRUE.equals(this.getClientProperty(PROPERTY_KEY_DETAILS_ENABLED));
    }

    public void setDetailsEnabled(boolean enabled) {
        this.putClientProperty(PROPERTY_KEY_DETAILS_ENABLED, enabled);
        this.repaint();
    }

    public boolean isNodeLineVisible() {
        return Boolean.TRUE.equals(this.getClientProperty(PROPERTY_KEY_SHOW_NODE_LINES));
    }

    public void setNodeLineVisible(boolean visible) {
        this.putClientProperty(PROPERTY_KEY_SHOW_NODE_LINES, visible);
        this.repaint();
    }

    public boolean isNodeStatusbarVisible() {
        return Boolean.TRUE.equals(this.getClientProperty(PROPERTY_KEY_SHOW_NODE_STATUSBAR));
    }

    public void setNodeStatusbarVisible(boolean visible) {
        this.putClientProperty(PROPERTY_KEY_SHOW_NODE_STATUSBAR, visible);
        ((BasicTreeUI)this.getUI()).setLeftChildIndent((int)(100.0f * this.getZoomFactor()));
        this.revalidate();
        this.gatherVisibleNodes();
    }

    public boolean isNodeMoleculeVisible() {
        return Boolean.TRUE.equals(this.getClientProperty(PROPERTY_KEY_SHOW_MOLECULE));
    }

    public void setNodeMoleculeVisible(boolean visible) {
        this.putClientProperty(PROPERTY_KEY_SHOW_MOLECULE, visible);
        ((BasicTreeUI)this.getUI()).setLeftChildIndent((int)(100.0f * this.getZoomFactor()));
        this.revalidate();
        this.gatherVisibleNodes();
    }

    public boolean isStepLineVisible() {
        return Boolean.TRUE.equals(this.getClientProperty(PROPERTY_KEY_SHOW_STEP_LINES));
    }

    public void setStepLineVisible(boolean visible) {
        this.putClientProperty(PROPERTY_KEY_SHOW_STEP_LINES, visible);
        this.repaint();
    }

    public boolean isNodeCaptionVisible() {
        return Boolean.TRUE.equals(this.getClientProperty(PROPERTY_KEY_SHOW_NODE_CAPTION));
    }

    public void setNodeCaptionVisible(boolean visible) {
        this.putClientProperty(PROPERTY_KEY_SHOW_NODE_CAPTION, visible);
        ((BasicTreeUI)this.getUI()).setLeftChildIndent((int)(100.0f * this.getZoomFactor()));
        this.revalidate();
        this.gatherVisibleNodes();
    }

    public boolean isNodeBorderVisible() {
        return Boolean.TRUE.equals(this.getClientProperty(PROPERTY_KEY_SHOW_NODE_BORDER));
    }

    public void setNodeBorderVisible(boolean visible) {
        this.putClientProperty(PROPERTY_KEY_SHOW_NODE_BORDER, visible);
        this.repaint();
    }

    protected void setSelectedReactionNode(AlchemistTreeNode selectedReactionNode) {
        AlchemistTreeNode oldValue = this.getSelectedReactionNode();
        this.selectedReactionNode = selectedReactionNode;
        this.firePropertyChange(PROPERTY_KEY_SELECTED_REACTION_NODE, oldValue, selectedReactionNode);
    }

    protected void showMagnifierPopup(AlchemistTreeNode node, Point coords) {
        if (!coords.equals(this.lastMagnifierPopup)) {
            this.lastMagnifierPopup = coords;
            this.popupNode = node;
            this.repaint(coords.x, coords.y, coords.x + (this.isDetailsEnabled() ? 400 : 225), coords.y + 225);
        }
    }

    protected void hideMagnifierPopup() {
        if (this.lastMagnifierPopup != null) {
            this.repaint(this.lastMagnifierPopup.x, this.lastMagnifierPopup.y, this.lastMagnifierPopup.x + (this.isDetailsEnabled() ? 400 : 225), this.lastMagnifierPopup.y + 225);
        }
        this.popupNode = null;
        this.lastMagnifierPopup = null;
    }

    public void gatherVisibleNodes() {
        if (!this.expandLock) {
            this.visibleNodesMap.clear();
            this.zonesMap.clear();
            Rectangle rect = this.getVisibleRect();
            int startX = rect.x;
            int startY = rect.y;
            int j = 0;
            while (j < rect.height) {
                for (int i = 0; i < rect.width; i += (int)(100.0f * this.getZoomFactor()) - 1) {
                    TreePath path = this.getClosestPathForLocation(startX + i, startY + j);
                    if (path == null) continue;
                    AlchemistTreeNode node = (AlchemistTreeNode)path.getLastPathComponent();
                    Rectangle rowBound = this.getRowBounds(this.getRowForPath(path));
                    if (rowBound == null || this.visibleNodesMap.containsKey(node)) continue;
                    this.visibleNodesMap.put(node, rowBound);
                    int hws = (int)((float)(rowBound.x - rowBound.width / 2) - (1.0f - this.getZoomFactor()) * 13.0f);
                    int hha = rowBound.y + rowBound.height / 2;
                    int x1 = hws - 5;
                    int y1 = hha - 5;
                    int d = 10;
                    Rectangle reactionZoneBound = new Rectangle(x1, y1, d, d);
                    this.zonesMap.put(reactionZoneBound, node);
                }
                j = (int)((float)j + 12.0f * this.getZoomFactor());
            }
            this.repaint();
        }
    }

    public String[] getNodeIDsFromRoot(AlchemistTreeNode node) {
        String[] result = null;
        String synthesisCode = node.getUniqueID();
        if (synthesisCode != null) {
            int lastIndex = synthesisCode.lastIndexOf(40);
            String leftPart = lastIndex == -1 ? synthesisCode : synthesisCode.substring(0, lastIndex);
            String[] tmp = leftPart.split("\\(");
            result = new String[tmp.length];
            for (int i = 0; i < tmp.length; ++i) {
                result[i] = tmp[tmp.length - i - 1];
            }
        }
        return result;
    }

    protected void showZoneLabel(String text, Point coords) {
        if (!coords.equals(this.lastZonePopup)) {
            this.lastZonePopup = coords;
            this.zonePopupText = text;
            int w = SwingUtilities.computeStringWidth(this.getFontMetrics(this.getFont()), this.zonePopupText) + 6;
            this.repaint(this.lastZonePopup.x, this.lastZonePopup.y, this.lastZonePopup.x + w, this.lastZonePopup.y + 20);
        }
    }

    protected void hideZoneLabel() {
        if (this.lastZonePopup != null) {
            int w = SwingUtilities.computeStringWidth(this.getFontMetrics(this.getFont()), this.zonePopupText) + 6;
            this.repaint(this.lastZonePopup.x, this.lastZonePopup.y, this.lastZonePopup.x + w, this.lastZonePopup.y + 20);
        }
        this.lastZonePopup = null;
        this.zonePopupText = null;
    }

    protected void handleLabelUpdate(TreePath path) {
        if (path == null) {
            this.hideMoleculeLabel();
            return;
        }
        AlchemistTreeNode node = (AlchemistTreeNode)path.getLastPathComponent();
        Rectangle r = this.visibleNodesMap.get(node);
        if (r == null) {
            return;
        }
        Point labelCoord = new Point(r.x + (this.isMagnifierEnabled() ? r.width : 2), r.y + 2);
        if (this.isNodeCaptionVisible() && (this.lastLabelPopup == null || this.lastLabelPopup.x != r.x || this.lastLabelPopup.y != r.y)) {
            TreePath selPath = this.getSelectionPath();
            this.showMoleculeLabel(labelCoord, selPath == path, node);
        } else {
            this.hideMoleculeLabel();
        }
    }

    protected void showMoleculeLabel(Point coords, boolean selected, AlchemistTreeNode node) {
        if (this.popupLabelImage != null && !coords.equals(this.lastLabelPopup)) {
            this.hideMoleculeLabel();
        }
        this.lastLabelPopup = coords;
        this.popupLabelImage = AlchemistMoleculeTreeCellRenderer.getFullTextLabelImage(node, this, this.getZoomFactor(), selected, false, this.isMagnifierEnabled());
        this.repaint(coords.x, coords.y, this.popupLabelImage.getWidth(), this.popupLabelImage.getHeight());
        if (this.getBorder() instanceof EmptyBorder) {
            EmptyBorder border = (EmptyBorder)this.getBorder();
            int inset = border.getBorderInsets((Component)this).right;
            if (inset < this.popupLabelImage.getWidth()) {
                this.setBorder(BorderFactory.createEmptyBorder(0, 0, 220, this.popupLabelImage.getWidth() + 20));
                this.revalidate();
            }
        }
    }

    @Override
    public void setModel(TreeModel newModel) {
        if (!(newModel instanceof IterableTreeModel)) {
            throw new IllegalArgumentException("Only IterableTreeModel instances are supported!");
        }
        super.setModel(newModel);
    }

    protected boolean isExpandLock() {
        return this.expandLock;
    }

    protected void hideMoleculeLabel() {
        if (this.popupLabelImage != null && this.lastLabelPopup != null) {
            this.repaint(this.lastLabelPopup.x, this.lastLabelPopup.y, this.getWidth(), this.popupLabelImage.getHeight());
        }
        this.popupLabelImage = null;
        this.lastLabelPopup = null;
    }

    public synchronized void addNodes(AlchemistTreeNode[] nodeArray) {
        for (int i = 0; i < nodeArray.length && !Thread.currentThread().isInterrupted(); ++i) {
            if (nodeArray[i].getParentID() == null) {
                if (this.nodeMap.get(nodeArray[i].getUniqueID()) == null) {
                    AlchemistTreeNode root = (AlchemistTreeNode)this.getModel().getRoot();
                    ((DefaultTreeModel)this.getModel()).insertNodeInto(nodeArray[i], root, root.getChildCount());
                    this.nodeMap.put(nodeArray[i].getUniqueID(), nodeArray[i]);
                    continue;
                }
                this.nodeMap.get(nodeArray[i].getUniqueID()).setMolecule(nodeArray[i].getMolecule());
                continue;
            }
            if (this.nodeMap.get(nodeArray[i].getUniqueID()) == null) {
                AlchemistTreeNode parentNode = this.nodeMap.get(nodeArray[i].getParentID());
                ((DefaultTreeModel)this.getModel()).insertNodeInto(nodeArray[i], parentNode, parentNode.getChildCount());
                if (parentNode.isExcluded()) {
                    ((IterableTreeModel)this.getModel()).excludeNode(nodeArray[i]);
                } else {
                    ((IterableTreeModel)this.getModel()).includeNode(nodeArray[i]);
                }
                this.nodeMap.put(nodeArray[i].getUniqueID(), nodeArray[i]);
                continue;
            }
            this.nodeMap.get(nodeArray[i].getUniqueID()).setMolecule(nodeArray[i].getMolecule());
        }
        this.recalculateTreeData();
    }

    public TreeDataProvider<?> getDataProvider() {
        return this.dataProvider;
    }

    public void setDataProvider(TreeDataProvider<AlchemistTreeNode> dataProvider) {
        if (dataProvider == null) {
            throw new IllegalArgumentException("Data provider should not be null!");
        }
        if (this.innerProgressMonitor != null) {
            this.innerProgressMonitor.reset();
        }
        this.dataProvider = dataProvider;
    }

    public AlchemistProgressMonitor getProgressMonitor() {
        return this.innerProgressMonitor;
    }

    public AlchemistTreeNode getNode(String uniqueID) {
        return this.nodeMap.get(uniqueID);
    }

    public void clear() {
        this.nodeMap.clear();
        this.visibleNodesMap.clear();
        this.zoneLabelsMap.clear();
        this.setModel(new IterableTreeModel(new AlchemistTreeNode(ROOT_UNIQUE_ID){

            @Override
            public Molecule getMolecule() {
                return null;
            }

            @Override
            public void setMolecule(Molecule molecule) {
            }
        }));
    }

    public Map<String, String> getZoneLabelMap() {
        return Collections.unmodifiableMap(this.zoneLabelsMap);
    }

    public void setZoneLabelMap(Map<String, String> zoneLabels) {
        this.zoneLabelsMap.clear();
        this.zoneLabelsMap.putAll(zoneLabels);
    }

    protected void recalculateTreeData() {
    }

    public void addPropertyToDetails(String propertyKey, String label) {
        this.detailedPropertiesMap.put(propertyKey, label);
    }

    public String removePropertyFromDetails(String propertyKey) {
        return this.detailedPropertiesMap.remove(propertyKey);
    }

    protected JPopupMenu getPopupMenu() {
        if (this.popupMenu == null) {
            this.popupMenu = new JPopupMenu();
            if (this.getExportersMenu().getMenuComponentCount() > 0) {
                this.popupMenu.add(this.getExportersMenu());
            }
        }
        return this.popupMenu;
    }

    private JMenu getExportersMenu() {
        if (this.exportersMenu == null) {
            this.exportersMenu = new JMenu("Export");
            final MoleculeTreeExporter[] exporters = this.exportersMap.values().toArray(new MoleculeTreeExporter[this.exportersMap.size()]);
            Arrays.sort(exporters, new Comparator<MoleculeTreeExporter>(){

                @Override
                public int compare(MoleculeTreeExporter o1, MoleculeTreeExporter o2) {
                    return o1.getName().compareTo(o2.getName());
                }
            });
            for (int i = 0; i < exporters.length; ++i) {
                final int index = i;
                JMenuItem export = new JMenuItem(new AbstractAction(){
                    private static final long serialVersionUID = 1670625470174503432L;

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        AlchemistMoleculeTree.this.exportTreeData(exporters[index]);
                    }
                });
                export.setText(exporters[i].getName());
                export.setToolTipText(exporters[i].getDescription());
                this.exportersMenu.add(export);
            }
        }
        return this.exportersMenu;
    }

    protected void exportTreeData(MoleculeTreeExporter exporter) {
        exporter.export(this, System.out, "mrv");
    }

    public void addExporter(MoleculeTreeExporter exporter) {
        this.exportersMap.put(exporter.getClass(), exporter);
        if (this.popupMenu != null) {
            this.popupMenu.setVisible(false);
        }
        this.popupMenu = null;
    }

    public void removeExporter(Class<? extends MoleculeTreeExporter> exporterClass) {
        this.exportersMap.remove(exporterClass);
        if (this.popupMenu != null) {
            this.popupMenu.setVisible(false);
        }
        this.popupMenu = null;
    }

    public void collapseAll() {
        for (int i = this.getRowCount() - 1; i >= 0; --i) {
            this.collapseRow(i);
        }
    }

    public void expandAll() {
        this.expandLock = true;
        ArrayList<AlchemistTreeNode> parentList = new ArrayList<AlchemistTreeNode>();
        parentList.add((AlchemistTreeNode)this.getModel().getRoot());
        while (!parentList.isEmpty()) {
            AlchemistTreeNode parentNode = (AlchemistTreeNode)parentList.remove(0);
            this.expandPath(new TreePath(parentNode.getPath()));
            for (int i = 0; i < parentNode.getChildCount(); ++i) {
                AlchemistTreeNode node = (AlchemistTreeNode)parentNode.getChildAt(i);
                if (!((IterableTreeModel)this.getModel()).isNodeRealParent(node)) continue;
                parentList.add(node);
            }
        }
        this.expandLock = false;
        this.gatherVisibleNodes();
    }

    public void selectAll() {
        int[] rows = new int[this.getRowCount()];
        for (int i = 0; i < rows.length; ++i) {
            rows[i] = i;
        }
        this.setSelectionRows(rows);
    }

    public void invertSelection() {
        HashSet<Integer> set = new HashSet<Integer>();
        for (int i = 0; i < this.getRowCount(); ++i) {
            set.add(i);
        }
        int[] selrows = this.getSelectionRows();
        for (int i = 0; i < selrows.length; ++i) {
            set.remove(selrows[i]);
        }
        Integer[] integers = set.toArray(new Integer[set.size()]);
        int[] ints = new int[integers.length];
        for (int i = 0; i < ints.length; ++i) {
            ints[i] = integers[i];
        }
        this.setSelectionRows(ints);
    }

    public void selectPath() {
        TreePath[] paths = this.getSelectionPaths();
        HashSet<Integer> selectionSet = new HashSet<Integer>();
        for (int i = 0; i < paths.length; ++i) {
            while (paths[i] != null) {
                selectionSet.add(this.getRowForPath(paths[i]));
                paths[i] = paths[i].getParentPath();
            }
        }
        Integer[] sel = selectionSet.toArray(new Integer[selectionSet.size()]);
        int[] rows = new int[sel.length];
        for (int i = 0; i < sel.length; ++i) {
            rows[i] = sel[i];
        }
        this.setSelectionRows(rows);
    }

    public void selectSiblings() {
        TreePath[] paths = this.getSelectionPaths();
        HashSet<Integer> selectionSet = new HashSet<Integer>();
        for (int i = 0; i < paths.length; ++i) {
            TreePath parentPath = paths[i].getParentPath();
            AlchemistTreeNode parent = (AlchemistTreeNode)parentPath.getLastPathComponent();
            for (int j = 0; j < parent.getChildCount(); ++j) {
                selectionSet.add(this.getRowForPath(parentPath.pathByAddingChild(parent.getChildAt(j))));
            }
        }
        Integer[] sel = selectionSet.toArray(new Integer[selectionSet.size()]);
        int[] rows = new int[sel.length];
        for (int i = 0; i < sel.length; ++i) {
            rows[i] = sel[i];
        }
        this.setSelectionRows(rows);
    }

    public void selectSubtree() {
        TreePath[] paths = this.getSelectionPaths();
        HashSet<Integer> selectionSet = new HashSet<Integer>();
        ArrayList<TreePath> parentList = new ArrayList<TreePath>();
        parentList.addAll(Arrays.asList(paths));
        while (!parentList.isEmpty()) {
            TreePath path = (TreePath)parentList.remove(0);
            selectionSet.add(this.getRowForPath(path));
            AlchemistTreeNode parent = (AlchemistTreeNode)path.getLastPathComponent();
            for (int j = 0; j < parent.getChildCount(); ++j) {
                parentList.add(path.pathByAddingChild(parent.getChildAt(j)));
            }
        }
        Integer[] sel = selectionSet.toArray(new Integer[selectionSet.size()]);
        int[] rows = new int[sel.length];
        for (int i = 0; i < sel.length; ++i) {
            rows[i] = sel[i];
        }
        this.setSelectionRows(rows);
    }

    protected int getMoleculeIndex(String uniqueId) {
        AlchemistTreeNode root = (AlchemistTreeNode)this.getModel().getRoot();
        for (int i = 0; i < root.getChildCount(); ++i) {
            if (!((AlchemistTreeNode)root.getChildAt(i)).getUniqueID().equals(uniqueId)) continue;
            return i;
        }
        return -1;
    }
}

