/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.alchemist.utils.moleculetree;

import chemaxon.alchemist.utils.moleculetree.AlchemistTreeNode;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;

public class IterableTreeModel
extends DefaultTreeModel
implements Iterable<AlchemistTreeNode> {
    private static final long serialVersionUID = 865804778425751298L;
    private long modificationCount = Long.MIN_VALUE;

    public IterableTreeModel(TreeNode root) {
        super(root, true);
    }

    @Override
    public Iterator<AlchemistTreeNode> iterator() {
        return new TreeNodeIterator(this);
    }

    public boolean isNodeRealParent(AlchemistTreeNode node) {
        if (node.getChildCount() > 0) {
            String id = ((AlchemistTreeNode)node.getChildAt(0)).getUniqueID();
            if (id.equalsIgnoreCase("virtual" + node.getUniqueID())) {
                return false;
            }
            boolean hasChild = false;
            for (int i = 0; i < node.getChildCount() && !hasChild; ++i) {
                hasChild = !((AlchemistTreeNode)node.getChildAt(i)).isExcluded();
            }
            return hasChild;
        }
        return false;
    }

    public boolean isNodeInDeepestPath(AlchemistTreeNode node) {
        boolean isInDeepestPath = true;
        if (node.isExcluded()) {
            return false;
        }
        int childDepth = node.getChildrenDepth();
        Enumeration<? extends TreeNode> childrenEnumeration = node.getParent().children();
        while (childrenEnumeration.hasMoreElements() && isInDeepestPath) {
            AlchemistTreeNode sibling = (AlchemistTreeNode)childrenEnumeration.nextElement();
            if (sibling.equals(node) || sibling.getChildrenDepth() < childDepth || sibling.isExcluded()) continue;
            isInDeepestPath = false;
        }
        return isInDeepestPath;
    }

    public int getSubTreeHeight(AlchemistTreeNode root) {
        int height = 0;
        if (root.isExcluded()) {
            return 0;
        }
        if (this.isNodeRealParent(root)) {
            for (int i = 0; i < root.getChildCount(); ++i) {
                AlchemistTreeNode node = (AlchemistTreeNode)root.getChildAt(i);
                if (node.isExcluded() || node.getChildrenDepth() <= height) continue;
                height = node.getChildrenDepth();
            }
        } else {
            return 0;
        }
        return ++height;
    }

    protected synchronized void setNodeExcluded(AlchemistTreeNode node, boolean value) {
        if (this.getModificationCount() != Long.MAX_VALUE) {
            this.setModificationCount(this.getModificationCount() + 1L);
        } else {
            this.setModificationCount(Long.MIN_VALUE);
        }
        node.setExcluded(value);
    }

    public void excludeNode(AlchemistTreeNode node) {
        if (!node.isExcluded()) {
            this.setNodeExcluded(node, true);
        }
    }

    public void includeNode(AlchemistTreeNode node) {
        if (node.isExcluded()) {
            this.setNodeExcluded(node, false);
        }
    }

    protected void setModificationCount(long modificationCount) {
        this.modificationCount = modificationCount;
    }

    protected long getModificationCount() {
        return this.modificationCount;
    }

    private class TreeNodeIterator
    implements Iterator<AlchemistTreeNode> {
        private final List<AlchemistTreeNode> parentList = new ArrayList<AlchemistTreeNode>();
        private AlchemistTreeNode parentNode = null;
        private int childIndex = 0;
        private final long modificationId;

        public TreeNodeIterator(DefaultTreeModel model) {
            this.parentNode = (AlchemistTreeNode)model.getRoot();
            this.modificationId = IterableTreeModel.this.getModificationCount();
        }

        @Override
        public boolean hasNext() {
            boolean hasNext = true;
            if (this.parentList.size() <= 0) {
                hasNext = false;
                for (int i = this.childIndex; i < this.parentNode.getChildCount() && !hasNext; ++i) {
                    hasNext = !((AlchemistTreeNode)this.parentNode.getChildAt(i)).isExcluded();
                }
            }
            return hasNext;
        }

        @Override
        public AlchemistTreeNode next() {
            boolean readNext = true;
            AlchemistTreeNode nextNode = null;
            while (readNext) {
                if (IterableTreeModel.this.getModificationCount() != this.modificationId) {
                    throw new ConcurrentModificationException();
                }
                if (this.childIndex >= this.parentNode.getChildCount()) {
                    if (!this.parentList.isEmpty()) {
                        this.parentNode = this.parentList.remove(0);
                        this.childIndex = 0;
                    } else {
                        throw new NoSuchElementException();
                    }
                }
                nextNode = (AlchemistTreeNode)this.parentNode.getChildAt(this.childIndex);
                ++this.childIndex;
                if (nextNode.isExcluded()) continue;
                readNext = false;
                if (!IterableTreeModel.this.isNodeRealParent(nextNode)) continue;
                this.parentList.add(nextNode);
            }
            return nextNode;
        }

        @Override
        public void remove() throws UnsupportedOperationException {
            throw new UnsupportedOperationException();
        }
    }
}

