/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.alchemist.utils.transition;

import chemaxon.alchemist.utils.transition.AlchemistTransition;
import java.awt.AlphaComposite;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.JPanel;
import javax.swing.Timer;

public class AlchemistTransitionPanel
extends JPanel
implements AlchemistTransition {
    private static final long serialVersionUID = 1662785924871585445L;
    float increment = 0.1f;
    boolean normalPlay = true;
    float value = 0.0f;
    private TransitionEffect effect = TransitionEffect.FADE;
    private final Component secondaryComponent;
    private boolean effectEnabled = true;
    private final Timer animationTimer = new Timer(50, new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            if (AlchemistTransitionPanel.this.normalPlay) {
                AlchemistTransitionPanel.this.value += AlchemistTransitionPanel.this.increment;
                if (AlchemistTransitionPanel.this.value >= 1.0f) {
                    AlchemistTransitionPanel.this.value = 1.0f;
                    AlchemistTransitionPanel.this.animationTimer.stop();
                }
            } else {
                AlchemistTransitionPanel.this.value -= AlchemistTransitionPanel.this.increment;
                if (AlchemistTransitionPanel.this.value <= 0.0f) {
                    AlchemistTransitionPanel.this.value = 0.0f;
                    AlchemistTransitionPanel.this.animationTimer.stop();
                }
            }
            AlchemistTransitionPanel.this.repaint();
        }
    });

    public AlchemistTransitionPanel(Component component) {
        this(component, null);
    }

    public AlchemistTransitionPanel(final Component primaryComponent, final Component secondaryComponent) {
        super(new CardLayout());
        this.setBorder(null);
        this.add(primaryComponent, "primary");
        this.secondaryComponent = secondaryComponent;
        if (secondaryComponent != null) {
            this.add(secondaryComponent, "secondary");
            primaryComponent.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent e) {
                    secondaryComponent.setSize(primaryComponent.getSize());
                }
            });
        }
    }

    @Override
    public void startTransition() {
        if (this.effectEnabled) {
            this.normalPlay = true;
            this.animationTimer.restart();
        }
    }

    @Override
    public void startTransitionReversed() {
        if (this.effectEnabled) {
            this.normalPlay = false;
            this.animationTimer.restart();
        }
    }

    public float getIncrement() {
        return this.increment;
    }

    public void setIncrement(float increment) {
        this.increment = Math.abs(increment);
    }

    public void setEffect(TransitionEffect effect) {
        this.effect = effect;
        this.repaint();
    }

    public TransitionEffect getEffect() {
        return this.effect;
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g.create();
        if (this.secondaryComponent == null) {
            switch (this.effect) {
                case FADE: {
                    super.paint(g);
                    float[] components = this.getBackground().getRGBComponents(null);
                    g2.setColor(new Color(components[0], components[1], components[2], 1.0f - this.value));
                    g2.fillRect(0, 0, this.getWidth(), this.getHeight());
                    break;
                }
                case SLIDE_DOWN: {
                    g2.setColor(this.getBackground());
                    g2.fillRect(0, 0, this.getWidth(), this.getHeight());
                    g.translate(0, -((int)((float)this.getHeight() * (1.0f - this.value))));
                    super.paint(g);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid effect occurred. effect=" + (Object)((Object)this.effect));
                }
            }
        } else {
            switch (this.effect) {
                case FADE: {
                    super.paint(g);
                    AlphaComposite composite = AlphaComposite.getInstance(3, 1.0f - this.value);
                    g2.setComposite(composite);
                    this.secondaryComponent.paint(g2);
                    break;
                }
                case SLIDE_DOWN: {
                    this.secondaryComponent.paint(g2);
                    g.translate(0, -((int)((float)this.getHeight() * (1.0f - this.value))));
                    super.paint(g);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid effect occurred. effect=" + (Object)((Object)this.effect));
                }
            }
        }
        g2.dispose();
    }

    public void setEffectEnabled(boolean enabled) {
        this.effectEnabled = enabled;
    }

    public boolean isEffectEnabled() {
        return this.effectEnabled;
    }

    public static enum TransitionEffect {
        FADE,
        SLIDE_DOWN;

    }
}

