/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.alchemist.utils.transition;

import chemaxon.alchemist.utils.transition.AlchemistTransition;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

public final class AlchemistTransitionUtils {
    private AlchemistTransitionUtils() {
    }

    public static void transitionOnMouseOver(final AlchemistTransition componentToAnimate, Component sensitiveArea) {
        final MouseAdapter mouseListener = new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                componentToAnimate.startTransition();
            }

            @Override
            public void mouseExited(MouseEvent e) {
                componentToAnimate.startTransitionReversed();
            }
        };
        ContainerListener containerListener = new ContainerListener(){

            @Override
            public void componentAdded(ContainerEvent e) {
                AlchemistTransitionUtils.registerTransitionOnMouseOver(componentToAnimate, e.getChild(), mouseListener, this);
            }

            @Override
            public void componentRemoved(ContainerEvent e) {
                AlchemistTransitionUtils.unregisterTransitionOnMouseOver(componentToAnimate, e.getChild(), mouseListener, this);
            }
        };
        AlchemistTransitionUtils.registerTransitionOnMouseOver(componentToAnimate, sensitiveArea, mouseListener, containerListener);
    }

    private static void registerTransitionOnMouseOver(AlchemistTransition componentToFade, Component sensitiveArea, MouseListener mouseListener, ContainerListener containerListener) {
        sensitiveArea.addMouseListener(mouseListener);
        if (sensitiveArea instanceof Container) {
            ((Container)sensitiveArea).addContainerListener(containerListener);
            Component[] components = ((Container)sensitiveArea).getComponents();
            for (int i = 0; i < components.length; ++i) {
                AlchemistTransitionUtils.registerTransitionOnMouseOver(componentToFade, components[i], mouseListener, containerListener);
            }
        }
    }

    private static void unregisterTransitionOnMouseOver(AlchemistTransition componentToFade, Component sensitiveArea, MouseListener mouseListener, ContainerListener containerListener) {
        sensitiveArea.removeMouseListener(mouseListener);
        if (sensitiveArea instanceof Container) {
            ((Container)sensitiveArea).removeContainerListener(containerListener);
            Component[] components = ((Container)sensitiveArea).getComponents();
            for (int i = 0; i < components.length; ++i) {
                AlchemistTransitionUtils.unregisterTransitionOnMouseOver(componentToFade, components[i], mouseListener, containerListener);
            }
        }
    }
}

