/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.calculations;

import chemaxon.calculations.Charge;
import chemaxon.calculations.pka.AtomPolarizabilityPKa;
import chemaxon.struc.MolAtom;
import chemaxon.struc.Molecule;

class AtomPolarizabilityTautomter
extends AtomPolarizabilityPKa {
    protected AtomPolarizabilityTautomter(Molecule molecule) {
        super(molecule);
    }

    protected AtomPolarizabilityTautomter(Charge charge) {
        super(charge);
    }

    @Override
    protected double[] getCarbonPolarizability(int atomIndex, Charge charge, boolean polCharge) {
        int protonCount = 6;
        MolAtom atom = this.standardizedMolecule.getAtom(atomIndex);
        double[] res = new double[]{0.0, protonCount, 0.0};
        int valence = this.getBondCount(atom);
        switch (valence) {
            case 4: {
                res[0] = (1.0 + 3.0 * (-0.053 - charge.getTotalCharge(atomIndex))) * APOL[1];
                res[2] = 6.697744 / (double)protonCount;
                return res;
            }
            case 3: {
                res[0] = atom.hasAromaticBond() && this.getAromaticNeighbourCount(atom) >= 3 ? APOL[3] : (1.0 + 3.0 * (-0.0622 - charge.getTotalCharge(atomIndex))) * APOL[2];
                res[2] = 4.0 * res[0] * res[0] / (double)protonCount;
                return res;
            }
            case 2: {
                res[0] = (1.0 + 3.0 * (-0.1234 - charge.getTotalCharge(atomIndex))) * APOL[4];
                res[2] = 4.0 * res[0] * res[0] / (double)protonCount;
                return res;
            }
        }
        return this.getDefaultPolarizability(protonCount);
    }

    @Override
    protected double[] getPolarizabilityParameter(int atomIndex) {
        return super.getPolarizabilityParameter(atomIndex);
    }
}

