/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.calculations;

import chemaxon.struc.MolAtom;
import chemaxon.struc.Molecule;

public class Aza {
    public static int[] calculate(Molecule molecule) {
        int i;
        int[] aza = new int[molecule.getAtomCount()];
        for (i = 0; i < aza.length; ++i) {
            aza[i] = -1;
        }
        for (i = 0; i < aza.length; ++i) {
            MolAtom atom = molecule.getAtom(i);
            if (atom.getAtno() != 7) continue;
            for (int j = 0; j < atom.getBondCount(); ++j) {
                int nb;
                MolAtom neighbour = atom.getBond(j).getOtherAtom(atom);
                if (neighbour.getAtno() != 7) continue;
                aza[i] = nb = molecule.indexOf(neighbour);
                aza[nb] = i;
            }
        }
        return aza;
    }
}

