/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.calculations;

import chemaxon.calculations.CriticalErrorCalculation;
import chemaxon.calculations.HMO;
import chemaxon.calculations.PolarGroups;
import chemaxon.calculations.RingAnalyzer;
import chemaxon.calculations.Tautomerization;
import chemaxon.struc.MolAtom;
import chemaxon.struc.Molecule;

public class Charge {
    private RingAnalyzer rings;
    private Tautomerization resonance;
    protected Molecule mol;
    protected PolarGroups pg;
    public MolAtom[] atomArray;
    private double[] accumCharge;
    protected int[][] aAtoms;
    private int[][] spp;
    protected int[][] nonAring;
    protected int[][] bHtab;
    public int[][] cHtab;
    protected double[] Qsigma;
    protected double[] Qpi;
    protected double[] Qsum;
    private double[] spsChg;
    protected String[] aSymbol;
    private boolean complexAtomCharge = false;
    private int[] complexCharge = null;
    public int MOLATOMS;
    protected int IMPLICITH;
    protected int aRingNumber;
    protected int multiRing;
    protected boolean baseInfoAvailable = false;
    int[] stereoPos = null;
    double[] EWD;
    int[] arIndex;
    int[] atIndex;
    public int[] delocAble;
    private int[] delocIsland;
    protected int[] sigmaAtomType;
    private int[] piAtomType;
    public int[][] RRPairs;
    private int[][] araDist = null;
    public int[] sAtoms = null;
    protected int[] sAra;
    private int[] piDecType = null;
    private int sphSize;
    boolean hValenceError;
    boolean resonanceCharge;
    protected boolean criticalError;
    private int ringSize;
    private int ringIndex;
    public int maxDelocLength = 0;
    public int[] hyperC;
    public int[] hconj;
    double[] cc;
    double ccsum = 0.0;
    int semiACount;
    boolean pKaCalc = false;
    boolean takeMajorRes;
    boolean allowHypConj = false;
    protected int aromatizationType = -1;
    int[] reParAtom = null;
    private static final double[][] AOE = new double[][]{{7.17, 6.24, -0.56}, {7.98, 9.18, 1.88}, {8.79, 9.32, 1.51}, {10.39, 9.45, 0.73}, {11.54, 10.82, 1.36}, {12.87, 11.15, 0.85}, {15.68, 11.7, -0.27}, {14.18, 12.92, 1.39}, {17.07, 13.79, 0.47}, {14.66, 13.85, 2.31}, {11.0, 9.69, 1.35}, {10.08, 8.47, 1.16}, {9.9, 7.96, 0.96}, {10.14, 9.13, 1.38}, {12.32, 11.195, 1.335}, {15.68, 11.7, -0.27}, {12.76, 11.62, 1.25}, {7.1, 6.57, 2.63}, {7.9, 6.81, 2.04}, {9.06, 7.07, 0.05}, {5.98, 6.82, 1.6}, {6.33, 7.16, 1.42}, {7.33, 7.75, 1.47}, {7.11, 7.13, 1.3}, {6.42, 6.81, 1.32}, {11.24, 9.02, 0.26}, {9.66, 8.53, 0.73}, {9.47, 8.52, 0.93}, {8.9, 8.23, 0.95}, {4.09, 3.805, 0.25}, {4.04, 3.88, 0.23}, {3.3, 3.99, 0.85}, {6.52, 5.45, 0.75}, {5.37, 4.95, 0.86}, {4.47, 4.95, 0.94}, {3.8, 5.05, 1.46}, {10.88, 9.34, 1.2}, {8.79, 9.32, 1.51}, {10.12, 8.12, 0.234}, {8.69, 7.68, 0.65}, {8.52, 7.67, 0.83}, {8.01, 7.41, 0.85}, {6.52, 5.45, 0.75}, {6.52, 5.45, 0.75}, {6.52, 5.45, 0.75}, {6.52, 5.45, 0.75}, {6.52, 5.45, 0.75}, {6.52, 5.45, 0.75}, {6.52, 5.45, 0.75}, {6.52, 5.45, 0.75}, {6.52, 5.45, 0.75}, {6.52, 5.45, 0.75}, {6.52, 5.45, 0.75}, {6.52, 5.45, 0.75}, {6.52, 5.45, 0.75}, {6.52, 5.45, 0.75}, {6.52, 5.45, 0.75}, {6.52, 5.45, 0.75}, {6.52, 5.45, 0.75}, {6.52, 5.45, 0.75}, {6.52, 5.45, 0.75}, {6.52, 5.45, 0.75}, {6.52, 5.45, 0.75}, {6.52, 5.45, 0.75}, {6.52, 5.45, 0.75}};
    private static final double[][] piAOE = new double[][]{{10.09, 11.73, 2.87}, {7.73, 8.16, 1.81}, {7.95, 9.73, 2.67}, {5.6, 8.93, 2.94}, {10.09, 11.73, 2.87}, {5.9, 6.1, 1.26}, {4.95, 6.23, 2.03}, {6.77, 7.42, 1.57}, {2.6, 3.8, 1.22}, {4.63, 4.28, 1.08}, {3.27, 5.05, 0.68}, {5.26, 8.4, 2.76}, {7.91, 14.76, 6.85}, {6.6, 10.32, 3.72}, {4.54, 11.86, 7.32}, {7.34, 13.86, 9.64}, {6.5, 9.69, 5.49}, {5.2, 9.68, 4.48}, {4.95, 8.81, 3.86}, {5.07, 5.56, 1.17}, {7.34, 13.86, 9.64}, {7.91, 8.38, 1.36}, {6.5, 9.69, 5.49}, {4.54, 11.86, 7.32}, {5.64, 0.0, 1.1654}};
    public boolean debug = false;

    public boolean getCriticalErrorFlag() {
        return this.criticalError;
    }

    public void setCriticalErrorFlag(boolean error) {
        this.criticalError = error;
    }

    public void setTakeMajorResonanceContributors(boolean majorRes) {
        this.takeMajorRes = majorRes;
    }

    public Charge() {
    }

    public Charge(Molecule molecule, PolarGroups pg) {
        this();
        this.setMolecule(molecule);
        this.pg = pg;
    }

    public void setMolecule(Molecule mol) {
        this.mol = mol;
        this.rings = null;
        this.hValenceError = false;
        this.criticalError = CriticalErrorCalculation.calculate(this.mol);
    }

    public Molecule getMolecule() {
        return this.mol;
    }

    public boolean getHValenceError() {
        return this.hValenceError;
    }

    public void initChargeCalc() {
        this.MOLATOMS = this.mol.getAtomCount();
        this.IMPLICITH = this.mol.getImplicitHcount();
        this.initArrays();
        if (this.criticalError) {
            return;
        }
        if (!this.baseInfoAvailable) {
            this.complexCharge = new int[this.MOLATOMS];
            this.araDist = new int[9][7];
            this.stereoPos = new int[28];
            this.hconj = new int[this.MOLATOMS];
            this.piAtomType = new int[this.MOLATOMS];
            this.sigmaAtomType = new int[this.MOLATOMS];
            this.piDecType = new int[this.MOLATOMS];
            this.aSymbol = new String[this.MOLATOMS];
            this.sAra = new int[this.MOLATOMS];
            this.spsChg = new double[this.MOLATOMS];
            this.setProtonCount();
            this.getAromaticRings();
            this.setCarboxylGroup();
            this.complexAtomCharge = false;
            this.getComplexAtomCharge();
        }
        if (!this.baseInfoAvailable) {
            this.setDelocAbleAtoms();
            this.cancelFalseHConjCarbon();
        } else {
            this.resetDelocAbleAtoms();
        }
        if (!this.baseInfoAvailable) {
            this.setRingResonance();
        }
        this.setEleneType();
        if (!this.baseInfoAvailable) {
            this.setSemiAraAtoms();
            this.setComplexGoupProperty();
        }
    }

    private void setComplexGoupProperty() {
        boolean[] isInRing = this.getRings().isInRing();
        for (int i = 0; i < this.MOLATOMS; ++i) {
            if (this.pg.carboxy[i] == 2) {
                if (!isInRing[i] || this.sAra[i] != 1) continue;
                this.pg.groupProperty[i] = 412;
                continue;
            }
            if (this.pg.carboxy[i] != 200 && this.pg.carboxy[i] != 500 || !this.getSymbol(i).equals("N") || this.sAra[i] != 1 || this.pg.groupProperty[i] != 411) continue;
            this.pg.groupProperty[i] = 420;
        }
    }

    private void setProtonCount() {
        for (int i = 0; i < this.MOLATOMS; ++i) {
            MolAtom a = this.mol.getAtom(i);
            this.aSymbol[i] = a.getSymbol();
        }
    }

    private void setEleneType() {
        int i;
        for (i = 0; i < this.MOLATOMS; ++i) {
            this.setSigmaEleNeType(i);
        }
        for (i = 0; i < this.MOLATOMS; ++i) {
            if (this.delocAble[i] != 1) continue;
            this.setPiEleNeType(i);
            if (!this.baseInfoAvailable) {
                this.setDecreasedEleNeType(i);
                continue;
            }
            this.reSetDecreasedEleNeType(i);
        }
    }

    private void reSetDecreasedEleNeType(int atom) {
        switch (this.piDecType[atom]) {
            case 1: {
                this.piAtomType[atom] = 21;
                break;
            }
            case 2: {
                this.piAtomType[atom] = 20;
                break;
            }
            case 3: {
                int n = atom;
                this.Qsigma[n] = this.Qsigma[n] + 0.2;
                this.piAtomType[atom] = 22;
                break;
            }
            case 4: {
                int n = atom;
                this.Qsigma[n] = this.Qsigma[n] + 0.2;
                this.piAtomType[atom] = 17;
                break;
            }
            case 100: {
                this.sigmaAtomType[atom] = 2;
            }
        }
    }

    private void setDecreasedEleNeType(int atom) {
        if (this.piAtomType[atom] == 14 && this.sigmaAtomType[atom] == 4 && this.isAraConnect(atom)) {
            if (this.isVinilAliphaticIsland(atom, 3)) {
                this.setVinilAliPiDecreas(atom);
            } else {
                this.setSimpleAliPiDecreas(atom);
            }
        }
    }

    private void setSimpleAliPiDecreas(int atom) {
        boolean notFind = false;
        for (int j = 0; j < this.sphSize && !notFind; ++j) {
            int t;
            int a = this.sAtoms[j];
            int d = this.delocIsland[a];
            if (d == 2) {
                t = this.pg.carboxy[a];
                if (t == 1200 || t == 100 || t == 400) {
                    this.piAtomType[atom] = 21;
                    notFind = true;
                    this.piDecType[atom] = 1;
                    continue;
                }
                if (t != 1 && t != 2) continue;
                this.piAtomType[atom] = 20;
                notFind = true;
                this.piDecType[atom] = 2;
                continue;
            }
            if (d != 3) continue;
            t = this.pg.carboxy[a];
            if (t == 1200 || t == 100 || t == 400) {
                int n = atom;
                this.Qsigma[n] = this.Qsigma[n] + 0.2;
                this.piAtomType[atom] = 22;
                notFind = true;
                this.piDecType[atom] = 3;
                continue;
            }
            if (t != 1 && t != 2) continue;
            int n = atom;
            this.Qsigma[n] = this.Qsigma[n] + 0.2;
            this.piAtomType[atom] = 17;
            notFind = true;
            this.piDecType[atom] = 4;
        }
    }

    private void setVinilAliPiDecreas(int atom) {
        boolean notFind = false;
        for (int j = 0; j < this.sphSize && !notFind; ++j) {
            int t;
            int a = this.sAtoms[j];
            int d = this.delocIsland[a];
            if (d == 2) {
                t = this.pg.carboxy[a];
                if (t == 1200 || t == 100 || t == 400) {
                    this.sigmaAtomType[atom] = 2;
                    notFind = true;
                    this.piDecType[atom] = 100;
                    continue;
                }
                if (t != 1 && t != 2 && t != 300) continue;
                this.sigmaAtomType[atom] = 2;
                notFind = true;
                this.piDecType[atom] = 100;
                continue;
            }
            if (d != 3) continue;
            t = this.pg.carboxy[a];
            if (t == 1200 || t == 100 || t == 400) {
                this.sigmaAtomType[atom] = 2;
                notFind = true;
                this.piDecType[atom] = 100;
                continue;
            }
            if (t != 1 && t != 2 && t != 300) continue;
            this.sigmaAtomType[atom] = 2;
            notFind = true;
            this.piDecType[atom] = 100;
        }
    }

    private boolean isAraConnect(int atom) {
        int info;
        if (this.isArA(atom)) {
            return false;
        }
        boolean araConectionAvailable = false;
        for (int i = 0; i < this.cHtab[atom].length; ++i) {
            int nb = this.cHtab[atom][i];
            if (nb >= this.MOLATOMS || !this.isArA(nb)) continue;
            int rIndex = this.findSmallestAraRing(nb);
            for (int j = 0; j < this.aAtoms[rIndex].length; ++j) {
                if (this.getSymbol(this.aAtoms[rIndex][j]).equals("C")) continue;
                return true;
            }
            araConectionAvailable = true;
        }
        return araConectionAvailable && this.getRings().isInRing()[atom] && ((info = this.isSemiAromaticRing(this.getRings().getLargestRingIndex(atom))) == 200 || info == 100);
    }

    public void calcCharges() {
        this.initChargeCalc();
        if (this.criticalError) {
            return;
        }
        this.setInitialCharge();
        this.calcSigmaCharge();
        this.setInitialCharge();
        this.calcPiCharge();
        if (this.complexAtomCharge) {
            this.setComplexCharge();
        }
        this.finishChargeCalc();
    }

    private void printChg() {
        if (!this.debug) {
            return;
        }
        System.out.flush();
        for (int i = 0; i < this.MOLATOMS; ++i) {
            System.err.println("Atom " + (i + 1) + "   Qsum  " + this.Qsum[i] + "  Qpi " + this.Qpi[i]);
        }
        System.err.flush();
    }

    public void calcMajorResonanceCharge() {
        this.setMajorResonanceCharge();
    }

    private void setMajorResonanceCharge() {
        this.resonanceCharge = true;
        Molecule oMol = this.mol.cloneMoleculeWithDocument();
        this.aromatizationType = 2;
        this.resonance = new Tautomerization();
        this.resonance.setMolecule(this.mol);
        this.resonance.setSymmetryFiltering(false);
        this.resonance.setResChargeCalc(true);
        this.resonance.setResonantCalc(true);
        this.resonance.setMajorResonantCalc(true);
        this.resonance.setStoreAtomIndex(true);
        this.resonance.createDACouples();
        int[] aImp = this.resonance.getAtomIndexMap();
        double[] resQtot = new double[aImp.length + 100];
        double[] resQsigma = new double[aImp.length + 100];
        double[] resQpi = new double[aImp.length + 100];
        int resCount = this.resonance.getTCount();
        if (resCount == 1) {
            resCount = 0;
        }
        for (int i = 0; i < resCount; ++i) {
            this.mol = this.resonance.getTMolecule(i);
            this.mol.aromatize(2);
            this.calcCharges();
            for (int j = 0; j < this.MOLATOMS + this.IMPLICITH; ++j) {
                try {
                    int n = j;
                    resQtot[n] = resQtot[n] + this.Qsum[aImp[j]];
                    int n2 = j;
                    resQsigma[n2] = resQsigma[n2] + this.Qsigma[aImp[j]];
                    int n3 = j;
                    resQpi[n3] = resQpi[n3] + this.Qpi[aImp[j]];
                    continue;
                }
                catch (ArrayIndexOutOfBoundsException ex) {
                    // empty catch block
                }
            }
        }
        this.mol = oMol;
        this.baseInfoAvailable = false;
        this.aromatizationType = -1;
        this.calcCharges();
        if (resCount != 0) {
            for (int j = 0; j < this.MOLATOMS + this.IMPLICITH; ++j) {
                this.Qsum[j] = 1.0 / (double)resCount * resQtot[j];
                this.Qsigma[j] = 1.0 / (double)resCount * resQsigma[j];
                this.Qpi[j] = 1.0 / (double)resCount * resQpi[j];
            }
        }
        this.resonanceCharge = false;
        this.resonance.setResChargeCalc(false);
    }

    private void getComplexAtomCharge() {
        for (int i = 0; i < this.MOLATOMS; ++i) {
            int charge = this.atomArray[i].getCharge();
            if (charge > 1) {
                this.complexCharge[i] = charge - 1;
                this.complexAtomCharge = true;
                continue;
            }
            if (charge >= -1) continue;
            this.complexCharge[i] = charge + 1;
            this.complexAtomCharge = true;
        }
    }

    private void setComplexCharge() {
        for (int i = 0; i < this.MOLATOMS; ++i) {
            if (this.complexCharge[i] == 0) continue;
            int n = i;
            this.Qsigma[n] = this.Qsigma[n] + (double)this.complexCharge[i];
            this.setTotalCharge(i);
        }
    }

    private void finishChargeCalc() {
        this.baseInfoAvailable = this.pKaCalc;
    }

    private void resetDelocableAtoms() {
        this.setDelocAbleAtoms();
        this.cancelFalseHConjCarbon();
    }

    private void cancelFalseHConjCarbon() {
        for (int i = 0; i < this.MOLATOMS; ++i) {
            if (this.hconj[i] != 1 || !this.isHyperConjugationBreaked(i, 3)) continue;
            this.hconj[i] = 0;
            this.delocAble[i] = -1;
        }
    }

    public int getAtomCount() {
        return this.mol.getAtomCount();
    }

    public String getSymbol(int i) {
        if (i >= this.MOLATOMS) {
            return "H";
        }
        return this.aSymbol[i];
    }

    public double getSigmaCharge(int i) {
        if (this.criticalError) {
            return 0.0;
        }
        return this.Qsigma[i];
    }

    public double getPiCharge(int i) {
        if (this.criticalError) {
            return 0.0;
        }
        return this.Qpi[i];
    }

    public double getTotalCharge(int i) {
        if (this.criticalError) {
            return 0.0;
        }
        return this.Qsum[i];
    }

    public double getSigmaOEN(int atomIndex) {
        if (this.criticalError) {
            return 0.0;
        }
        if (atomIndex < this.MOLATOMS) {
            return this.getSigmaTypeEleNe(atomIndex)[0];
        }
        return Double.NaN;
    }

    public double getPiOEN(int atomIndex) {
        if (this.criticalError) {
            return 0.0;
        }
        if (atomIndex < this.MOLATOMS && this.delocAble[atomIndex] == 1 && this.hconj[atomIndex] != 1) {
            return this.getPiTypeEleNe(this.piAtomType[atomIndex], atomIndex)[0];
        }
        return Double.NaN;
    }

    private void setAliphaticEWDAtoms() {
        this.EWD = new double[this.MOLATOMS];
        for (int i = 0; i < this.MOLATOMS; ++i) {
            if (this.isArA(i)) continue;
            this.EWD[i] = this.isEWDAtom(i);
        }
    }

    private double isEWDAtom(int ai) {
        int pc = this.atomArray[ai].getAtno();
        int en1 = MolAtom.electronegOf(pc);
        double ediff = 0.0;
        for (int i = 0; i < this.cHtab[ai].length; ++i) {
            int nb = this.cHtab[ai][i];
            if (nb >= this.MOLATOMS) continue;
            pc = this.atomArray[nb].getAtno();
            int en2 = MolAtom.electronegOf(pc);
            ediff += (double)(en1 - en2);
            for (int j = 0; j < this.cHtab[nb].length; ++j) {
                int nnb = this.cHtab[nb][j];
                if (nnb >= this.MOLATOMS || nnb == ai) continue;
                pc = this.atomArray[nnb].getAtno();
                int en3 = MolAtom.electronegOf(pc);
                ediff += 0.3 * (double)(en2 - en3);
            }
        }
        return -(ediff /= 10.0);
    }

    private void setDelocAbleAtoms() {
        this.delocAble = new int[this.MOLATOMS];
        for (int i = 0; i < this.MOLATOMS; ++i) {
            this.delocAble[i] = -1;
            if (!this.isRightAtom(i)) continue;
            this.delocAble[i] = 1;
        }
    }

    private void setSemiAraAtoms() {
        this.semiACount = 0;
        if (this.nonAring.length != 0) {
            int rc = this.nonAring.length;
            int k = 0;
            for (int i = 0; i < rc; ++i) {
                int r = this.isSemiAromaticRing(i);
                if (r != 100 && r != 200) continue;
                ++this.semiACount;
                for (int j = 0; j < this.nonAring[i].length; ++j) {
                    k = this.nonAring[i][j];
                    this.sAra[k] = 1;
                }
            }
        }
    }

    public int getSemiAromaticRingCount() {
        return this.semiACount;
    }

    private void resetDelocAbleAtoms() {
        for (int atom = 0; atom < this.MOLATOMS; ++atom) {
            if (this.getSymbol(atom).equals("N")) {
                if (this.pg.carboxy[atom] == 1200) {
                    this.delocAble[atom] = 1;
                    continue;
                }
                if (this.cHtab[atom].length != 4) {
                    this.delocAble[atom] = 1;
                    continue;
                }
                if (this.cHtab[atom].length == 4) {
                    if (this.atomArray[atom].getCharge() == 0) {
                        this.delocAble[atom] = 1;
                        continue;
                    }
                    this.delocAble[atom] = -1;
                    continue;
                }
                this.delocAble[atom] = -1;
                continue;
            }
            if (this.getSymbol(atom).equals("P")) {
                this.delocAble[atom] = 1;
                continue;
            }
            if (!this.getSymbol(atom).equals("C")) continue;
            if (this.cHtab[atom].length != 4) {
                this.delocAble[atom] = 1;
                continue;
            }
            if (this.hconj[atom] == 1) continue;
            this.delocAble[atom] = -1;
        }
    }

    public double getResultantImplicitHCharge(int heavyAtom) {
        double sum = 0.0;
        for (int i = 0; i < this.cHtab[heavyAtom].length; ++i) {
            int nb = this.cHtab[heavyAtom][i];
            if (nb < this.MOLATOMS) continue;
            sum += this.Qsum[nb];
        }
        if (sum == 0.0) {
            return Double.NaN;
        }
        return sum;
    }

    public double getAromaticSystemCharge(int atomIndex, int chgType) {
        double chg = 0.0;
        if (this.isArA(atomIndex)) {
            int rIndex = this.getLargestAraRingIndex(atomIndex);
            for (int i = 0; i < this.aAtoms[rIndex].length; ++i) {
                if (chgType == 0) {
                    chg += this.Qsum[this.aAtoms[rIndex][i]];
                    continue;
                }
                if (chgType == 1) {
                    chg += this.Qsigma[this.aAtoms[rIndex][i]];
                    continue;
                }
                if (chgType != 2) continue;
                chg += this.Qpi[this.aAtoms[rIndex][i]];
            }
        }
        return chg;
    }

    public double getAromaticRingCharge(int atomIndex, int chgType) {
        double chg = 0.0;
        if (this.isArA(atomIndex)) {
            int rIndex = this.findSmallestAraRing(atomIndex);
            for (int i = 0; i < this.aAtoms[rIndex].length; ++i) {
                if (chgType == 0) {
                    chg += this.Qsum[this.aAtoms[rIndex][i]];
                    continue;
                }
                if (chgType == 1) {
                    chg += this.Qsigma[this.aAtoms[rIndex][i]];
                    continue;
                }
                if (chgType != 2) continue;
                chg += this.Qpi[this.aAtoms[rIndex][i]];
            }
        }
        return chg;
    }

    public double getAccumulatedCharge(int i) {
        if (this.criticalError) {
            return 0.0;
        }
        double sum = this.getTotalCharge(i);
        for (int j = 0; j < this.cHtab[i].length; ++j) {
            if (!this.getSymbol(this.cHtab[i][j]).equals("H")) continue;
            sum += this.getTotalCharge(this.cHtab[i][j]);
        }
        return sum;
    }

    private void getAromaticRings() {
        this.rings = null;
        this.aAtoms = this.getRings().getAromaticRings();
        this.aRingNumber = this.aAtoms.length;
        this.nonAring = this.getRings().getNonAromaticRings();
        if (this.getArCount() != 0) {
            this.arIndex = new int[this.getArCount()];
            this.atIndex = new int[this.MOLATOMS];
            int k = 0;
            for (int i = 0; i < this.MOLATOMS; ++i) {
                if (!this.isArA(i)) continue;
                this.arIndex[k] = i;
                this.atIndex[i] = k++;
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public int isSemiAromaticRing(int rIndex) {
        if (rIndex == -1) {
            return -1;
        }
        r = 0;
        d = 0;
        thioKeto = false;
        noSemiAra = false;
        carbonCount = 0;
        block12: for (i = 0; i < this.nonAring[rIndex].length; ++i) {
            ra = this.nonAring[rIndex][i];
            if (this.delocAble[ra] != 1 || this.hconj[ra] == 1) continue;
            ++d;
            if (this.pg.groupType[ra] == 18 || this.pg.groupType[ra] == 11) {
                thioKeto = true;
            }
            switch (this.sigmaAtomType[ra]) {
                case 2: {
                    if (this.getSymbol(ra).equals("N")) {
                        r += 2;
                        continue block12;
                    }
                    if (this.pg.carboxy[ra] == -1) {
                        ++r;
                        ++carbonCount;
                        continue block12;
                    }
                    if (this.pg.carboxy[ra] != 1700 && this.pg.carboxy[ra] != 1500 && this.pg.carboxy[ra] != 1600 && this.pg.carboxy[ra] != 2 && this.pg.carboxy[ra] != 300 || this.isKetoLikeN(ra)) continue block12;
                    ++r;
                    ++carbonCount;
                    continue block12;
                }
                case 4: {
                    if (this.pg.carboxy[ra] == 1200) continue block12;
                    r += 2;
                    continue block12;
                }
                case 14: {
                    r += 2;
                    continue block12;
                }
                case 5: {
                    if (this.atomArray[ra].getCharge() == -1) {
                        r += 2;
                        continue block12;
                    }
                    ++r;
                    continue block12;
                }
                case 7: {
                    if (this.pg.carboxy[ra] == 1000 || this.pg.carboxy[ra] == 1100) {
                        r += 2;
                        continue block12;
                    }
                    if (this.pg.carboxy[ra] == 2) {
                        r += 2;
                        continue block12;
                    }
                    if (this.pg.carboxy[ra] != 600) continue block12;
                    r += 2;
                    continue block12;
                }
                case 13: {
                    if (this.pg.carboxy[ra] == 1000 || this.pg.carboxy[ra] == 1100) {
                        r += 2;
                        continue block12;
                    }
                    if (this.pg.carboxy[ra] == 2) {
                        r += 2;
                        continue block12;
                    }
                    if (this.pg.carboxy[ra] != 600) continue block12;
                    r += 2;
                    continue block12;
                }
                case 36: {
                    if (!this.isArA(ra)) ** GOTO lbl64
                    r += 2;
                    ** GOTO lbl66
lbl64:
                    // 1 sources

                    if (this.pg.groupProperty[ra] == 422 || this.pg.groupProperty[ra] == 3500) {
                        noSemiAra = true;
                    }
                }
lbl66:
                // 5 sources

                case 22: {
                    if (this.pg.carboxy[ra] != -1) continue block12;
                    ++r;
                    continue block12;
                }
                case 18: {
                    if (this.pg.carboxy[ra] != -1) continue block12;
                    ++r;
                    continue block12;
                }
                case 26: {
                    if (this.pg.carboxy[ra] != -1) continue block12;
                    ++r;
                    continue block12;
                }
                default: {
                    if (!this.isArA(ra) || !this.getSymbol(ra).equals("Te")) continue block12;
                    r += 2;
                }
            }
        }
        if (noSemiAra) {
            return 0;
        }
        if (d == this.nonAring[rIndex].length && carbonCount != d && (r == 6 || r == 10 || r == 14 || r == 18 || r == 22 || r == 26)) {
            if (thioKeto) {
                return 200;
            }
            return 100;
        }
        return r;
    }

    private boolean isKetoLikeN(int C) {
        int gInd = this.pg.groupIndex[C];
        for (int i = 0; i < this.cHtab[C].length; ++i) {
            int nb = this.cHtab[C][i];
            if (nb >= this.MOLATOMS || this.pg.groupIndex[nb] != gInd || this.getRings().isInRing()[nb] || this.mol.getBond(this.bHtab[C][nb]).getType() != 2) continue;
            return true;
        }
        return false;
    }

    public int getARingNum() {
        return this.aRingNumber;
    }

    public double getSpecNonARingIncrement(int atomIndex) {
        for (int i = 0; i < this.nonAring.length; ++i) {
            for (int j = 0; j < this.nonAring[i].length; ++j) {
                int ra = this.nonAring[i][j];
                if (ra != atomIndex) continue;
                if (this.nonAring[i].length == 5) {
                    return 1.23;
                }
                if (this.nonAring[i].length != 4) continue;
                return 1.23;
            }
        }
        return 0.0;
    }

    protected int getSmallestExclusiveRingIndex(int atomIndex, int rIndx) {
        int size = 1000;
        int rInd = -1;
        for (int i = 0; i < this.nonAring.length; ++i) {
            for (int j = 0; j < this.nonAring[i].length; ++j) {
                int ra = this.nonAring[i][j];
                if (ra != atomIndex || this.nonAring[i].length >= size || rIndx == rInd) continue;
                size = this.nonAring[i].length;
                rInd = i;
            }
        }
        return rInd;
    }

    protected int getSmallestRingIndex(int atomIndex) {
        return this.getNonARingIndex(atomIndex);
    }

    protected int getNonARingIndex(int atomIndex) {
        int size = 1000;
        int rInd = -1;
        this.multiRing = 0;
        for (int i = 0; i < this.nonAring.length; ++i) {
            for (int j = 0; j < this.nonAring[i].length; ++j) {
                int ra = this.nonAring[i][j];
                if (ra != atomIndex || this.nonAring[i].length >= size) continue;
                size = this.nonAring[i].length;
                rInd = i;
                ++this.multiRing;
            }
        }
        return rInd;
    }

    public int getAllNonAringIndex(int atomIndex) {
        int ringCount = 0;
        for (int i = 0; i < this.nonAring.length; ++i) {
            for (int j = 0; j < this.nonAring[i].length; ++j) {
                int ra = this.nonAring[i][j];
                int size = this.nonAring[i].length;
                if (ra != atomIndex || size > 6) continue;
                ++ringCount;
            }
        }
        return ringCount;
    }

    private void changeRingOrder(int index1, int index2, int[] ringOrder) {
        int indexOf1 = 0;
        while (ringOrder[indexOf1] != index1) {
            ++indexOf1;
        }
        int indexOf2 = 0;
        while (ringOrder[indexOf2] != index2) {
            ++indexOf2;
        }
        if (indexOf2 - indexOf1 > 1) {
            int a = ringOrder[indexOf2];
            int i = 0;
            while (indexOf2 - i > indexOf1) {
                ringOrder[indexOf2 - i] = ringOrder[indexOf2 - i - 1];
                ++i;
            }
            ringOrder[indexOf1] = a;
        } else if (indexOf2 > indexOf1) {
            int a = ringOrder[indexOf1];
            ringOrder[indexOf1] = ringOrder[indexOf2];
            ringOrder[indexOf2] = a;
        }
    }

    protected void initArrays() {
        this.accumCharge = new double[this.MOLATOMS + this.IMPLICITH];
        this.Qsigma = new double[this.MOLATOMS + this.IMPLICITH];
        this.Qpi = new double[this.MOLATOMS + this.IMPLICITH];
        this.Qsum = new double[this.MOLATOMS + this.IMPLICITH];
        this.initMolArrays();
    }

    private void initMolArrays() {
        this.atomArray = this.mol.getAtomArray();
        this.bHtab = this.mol.createBHtab();
        this.cHtab = this.mol.createCHtab();
    }

    public void setChargeCalcType(boolean pKaCalc) {
        this.pKaCalc = pKaCalc;
    }

    protected void allowHMOHypConj(boolean alloHc) {
        this.allowHypConj = alloHc;
    }

    public void initHMOCalc() {
        this.MOLATOMS = this.mol.getAtomCount();
        this.IMPLICITH = this.mol.getImplicitHcount();
        this.hconj = new int[this.MOLATOMS];
        this.aSymbol = new String[this.MOLATOMS];
        this.setProtonCount();
        this.getAromaticRings();
        this.initMolArrays();
        this.setCarboxylGroup();
        this.setDelocAbleAtoms();
        this.addBrI();
        if (!this.allowHypConj) {
            for (int i = 0; i < this.MOLATOMS; ++i) {
                if (this.isAllowedElement(i)) continue;
                this.delocAble[i] = 0;
            }
        } else {
            this.addAminCations();
        }
    }

    private boolean isAllowedElement(int ai) {
        MolAtom a = this.mol.getAtom(ai);
        int pc = a.getAtno();
        if (pc == 6 || pc == 7 || pc == 8 || pc == 16) {
            return true;
        }
        if (pc == 9 || pc == 17) {
            return true;
        }
        return pc == 5 || pc == 15 || pc == 14;
    }

    private boolean isSuperConjugate(int atom) {
        String symbol = this.getSymbol(atom);
        boolean found = false;
        if (symbol.equals("C") & this.cHtab[atom].length == 4) {
            for (int i = 0; i < 4; ++i) {
                int nb = this.cHtab[atom][i];
                if (nb >= this.MOLATOMS || !this.isArA(nb)) continue;
                if (this.atomArray[nb].getCharge() < 0) {
                    return false;
                }
                found = true;
            }
        }
        return found;
    }

    private void addBrI() {
        for (int i = 0; i < this.MOLATOMS; ++i) {
            if (!this.getSymbol(i).equals("I") && !this.getSymbol(i).equals("Br")) continue;
            this.delocAble[i] = 1;
        }
    }

    private void addAminCations() {
        int charge = 0;
        for (int i = 0; i < this.MOLATOMS; ++i) {
            charge = this.atomArray[i].getCharge();
            if (charge != 1) continue;
            this.delocAble[i] = 1;
        }
    }

    public void calcHMODelocIsland(int startAtom) {
        this.extendWithHyperCon();
        this.calcExtendedDelocPath(startAtom, this.MOLATOMS);
        this.delFalseHyperC();
    }

    private void delFalseHyperC() {
        for (int i = 0; i < this.sphSize; ++i) {
            int a = this.sAtoms[i];
            if (this.hyperC[a] != 1) continue;
            this.delocAble[a] = 0;
            this.hyperC[a] = 0;
        }
    }

    private void calcHMO(int atom) {
        int charge = this.atomArray[atom].getCharge();
        double[] hmoCharge = new double[this.MOLATOMS];
        int k = 0;
        this.calcHMODelocIsland(atom);
        if (this.maxDelocLength > 1) {
            Molecule mm = this.mol.cloneMoleculeWithDocument();
            HMO hmo = new HMO(mm);
            hmo.setHMOCalcType(false);
            hmo.setHMOVariables(this.MOLATOMS, mm, this.sAtoms, this.maxDelocLength, this.hyperC, this.pg.carboxy);
            hmo.calcHMO(mm);
            hmoCharge = hmo.getTotalCharge();
            if (hmoCharge != null) {
                int a;
                int i;
                double[][] eig = new double[this.maxDelocLength + 1][this.maxDelocLength + 1];
                eig = hmo.getEigenVector();
                int homo = 0;
                for (int j = 0; j < this.maxDelocLength + 1; ++j) {
                    if (hmo.orbType[j] != 1) continue;
                    homo = j - 1;
                }
                k = 0;
                this.ccsum = 0.0;
                this.cc = new double[this.maxDelocLength + 1];
                for (i = 0; i < this.sphSize; ++i) {
                    a = this.sAtoms[i];
                    int ind = hmo.map[a] - 1;
                    for (int j = 0; j <= homo; ++j) {
                        int n = k;
                        this.cc[n] = this.cc[n] + eig[ind][j] * eig[ind][j];
                    }
                    this.ccsum += this.cc[k];
                    ++k;
                }
                k = 0;
                for (i = 0; i < this.sphSize; ++i) {
                    int n = a = this.sAtoms[i];
                    this.spsChg[n] = this.spsChg[n] + (double)charge * this.cc[k] / this.ccsum;
                    ++k;
                }
            }
        } else {
            int n = atom;
            this.spsChg[n] = this.spsChg[n] + (double)charge;
        }
    }

    public void setInitialCharge() {
        int i;
        for (i = 0; i < this.MOLATOMS; ++i) {
            this.spsChg[i] = 0.0;
        }
        for (i = 0; i < this.MOLATOMS; ++i) {
            double charge = this.atomArray[i].getCharge();
            if (charge == 0.0) continue;
            if (this.getSymbol(i).equals("O") || this.getSymbol(i).equals("S")) {
                if (!this.isArA(i)) {
                    if (charge < 0.0) {
                        if (this.isVinilLike(i)) {
                            if (this.setVinilCharge(i, 4)) continue;
                            int n = i;
                            this.spsChg[n] = this.spsChg[n] + charge;
                            continue;
                        }
                        try {
                            if (this.sAra[this.cHtab[i][0]] != 1) {
                                this.chargeDispersion(i, charge, 3);
                                continue;
                            }
                            int n = i;
                            this.spsChg[n] = this.spsChg[n] + charge;
                        }
                        catch (ArrayIndexOutOfBoundsException ex) {
                            int n = i;
                            this.spsChg[n] = this.spsChg[n] + charge;
                        }
                        continue;
                    }
                    if (!(charge > 0.0)) continue;
                    this.chargeDispersion(i, charge, 3);
                    continue;
                }
                int n = i;
                this.spsChg[n] = this.spsChg[n] + charge;
                continue;
            }
            if (this.getSymbol(i).equals("C")) {
                if (!this.pKaCalc || this.isArA(i) && charge < 0.0) {
                    this.calcHMO(i);
                    this.resetDelocableAtoms();
                    continue;
                }
                this.carbonDispersion(i, charge);
                continue;
            }
            if (this.getSymbol(i).equals("N") || this.getSymbol(i).equals("P")) {
                if (this.isArA(i)) {
                    if (!this.pKaCalc) {
                        this.heteroDispersion(i, charge);
                        continue;
                    }
                    int n = i;
                    this.spsChg[n] = this.spsChg[n] + charge;
                    continue;
                }
                if (charge > 0.0) {
                    this.setAzaCorrection(i, charge);
                    continue;
                }
                if (this.pg.groupType[i] == 11 || this.pg.groupType[i] == 12) {
                    int n = i;
                    this.spsChg[n] = this.spsChg[n] + charge;
                    continue;
                }
                this.chargeDispersion(i, charge, 2);
                continue;
            }
            if (charge > 1.0) {
                charge = 1.0;
            } else if (charge < -1.0) {
                charge = -1.0;
            }
            int n = i;
            this.spsChg[n] = this.spsChg[n] + charge;
        }
        for (i = 0; i < this.MOLATOMS; ++i) {
            int n = i;
            this.Qsigma[n] = this.Qsigma[n] + this.spsChg[i];
            this.setTotalCharge(i);
        }
    }

    private boolean isVinilLike(int atom) {
        try {
            int nb = this.cHtab[atom][0];
            if (this.isArA(nb)) {
                return true;
            }
            if (this.getSymbol(nb).equals("C")) {
                int nnb = 0;
                for (int i = 0; i < this.cHtab[nb].length; ++i) {
                    nnb = this.cHtab[nb][i];
                    if (!this.getSymbol(nnb).equals("C") && !this.getSymbol(nnb).equals("N") || this.mol.getBond(this.bHtab[nb][nnb]).getType() != 2) continue;
                    return true;
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        return false;
    }

    private void setAzaCorrection(int atom, double charge) {
        int nb;
        int i;
        int j = 1;
        for (i = 0; i < this.cHtab[atom].length; ++i) {
            nb = this.cHtab[atom][i];
            if (!this.getSymbol(nb).equals("N") && !this.getSymbol(nb).equals("P") || this.isWithDrawed(nb)) continue;
            ++j;
        }
        if (j != 1) {
            for (i = 0; i < this.cHtab[atom].length; ++i) {
                nb = this.cHtab[atom][i];
                if (!this.getSymbol(nb).equals("N") && !this.getSymbol(nb).equals("P") || this.isWithDrawed(nb)) continue;
                int n = nb;
                this.spsChg[n] = this.spsChg[n] + charge / (double)j;
            }
        }
        int n = atom;
        this.spsChg[n] = this.spsChg[n] + charge / (double)j;
    }

    private boolean isWithDrawed(int a) {
        boolean withDrawed = false;
        if (this.pg.carboxy[a] != -1) {
            return true;
        }
        for (int i = 0; i < this.cHtab[a].length; ++i) {
            int nb = this.cHtab[a][i];
            if (nb >= this.MOLATOMS || this.pg.carboxy[nb] == -1) continue;
            withDrawed = true;
        }
        return withDrawed;
    }

    private void carbonDispersion(int carbon, double charge) {
        if (charge < 0.0) {
            int i;
            double sum = 0.0;
            double[] a = new double[]{0.0, 0.0};
            double[] elene = new double[this.MOLATOMS];
            a = this.getSigmaTypeEleNe(carbon);
            elene[carbon] = a[0];
            sum += elene[carbon];
            for (i = 0; i < this.cHtab[carbon].length; ++i) {
                int type;
                int nb1 = this.cHtab[carbon][i];
                if (nb1 >= this.MOLATOMS || (type = this.pg.carboxy[nb1]) != 100 && type != 1300) continue;
                for (int j = 0; j < this.cHtab[nb1].length; ++j) {
                    int nb2 = this.cHtab[nb1][j];
                    if (nb2 == carbon) continue;
                    a = this.getSigmaTypeEleNe(nb2);
                    elene[nb2] = a[0];
                    sum += elene[nb2];
                }
                a = this.getSigmaTypeEleNe(nb1);
                elene[nb1] = a[0];
                sum += elene[nb1];
            }
            for (i = 0; i < this.MOLATOMS; ++i) {
                if (elene[i] == 0.0) continue;
                int n = i;
                this.spsChg[n] = this.spsChg[n] + charge * elene[i] / sum;
            }
        } else {
            int n = carbon;
            this.spsChg[n] = this.spsChg[n] + charge;
        }
    }

    private boolean setVinilCharge(int atom, int deep) {
        int n;
        int i;
        this.getResonanceIsland(atom, deep);
        double[] a = new double[]{0.0, 0.0};
        double sum = 0.0;
        double[] elene = new double[this.MOLATOMS];
        if (this.getSymbol(atom).equals("S")) {
            return false;
        }
        for (i = 0; i < this.sphSize; ++i) {
            n = this.sAtoms[i];
            if (this.getSymbol(n).equals("N") && this.pg.carboxy[n] == -1) {
                return false;
            }
            if (this.pg.carboxy[n] == 200 || this.pg.carboxy[n] == 500) {
                return false;
            }
            a = this.getSigmaTypeEleNe(n);
            elene[n] = a[0];
            sum += elene[n];
        }
        for (i = 0; i < this.sphSize; ++i) {
            int n2 = n = this.sAtoms[i];
            this.spsChg[n2] = this.spsChg[n2] + -1.0 * elene[n] / sum;
        }
        return true;
    }

    private void chargeDispersion(int atom, double charge, int deep) {
        block7: {
            int n;
            int i;
            double[] elene;
            double S;
            double sum;
            block6: {
                if (this.isEquivalent(atom)) {
                    this.getCarboxyDelIsland(atom);
                } else {
                    this.getDelocalizationIsland(atom, deep);
                }
                double[] a = new double[]{0.0, 0.0};
                sum = 0.0;
                S = 0.0;
                elene = new double[this.MOLATOMS];
                for (i = 0; i < this.sphSize; ++i) {
                    n = this.sAtoms[i];
                    a = this.getSigmaTypeEleNe(n);
                    elene[n] = a[0];
                    sum += elene[n];
                }
                if (!(charge < 0.0)) break block6;
                for (i = 0; i < this.sphSize; ++i) {
                    int n2 = n = this.sAtoms[i];
                    this.spsChg[n2] = this.spsChg[n2] + charge * elene[n] / sum;
                }
                break block7;
            }
            if (!(charge > 0.0)) break block7;
            for (i = 0; i < this.sphSize; ++i) {
                n = this.sAtoms[i];
                S += sum / elene[n];
            }
            for (i = 0; i < this.sphSize; ++i) {
                int n3 = n = this.sAtoms[i];
                this.spsChg[n3] = this.spsChg[n3] + charge * sum / (S * elene[n]);
            }
        }
    }

    private boolean isEquivalent(int ai) {
        if (this.isCarboxyl(ai)) {
            for (int i = 0; i < this.cHtab[ai].length; ++i) {
                int nb = this.cHtab[ai][i];
                if (nb >= this.MOLATOMS) continue;
                for (int j = 0; j < this.cHtab[nb].length; ++j) {
                    int nnb = this.cHtab[nb][j];
                    if (nnb >= this.MOLATOMS || this.atomArray[nnb].getCharge() != -1) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private boolean isCarboxyl(int ai) {
        return this.pg.carboxy[ai] == 300 || this.pg.carboxy[ai] == 600 || this.pg.carboxy[ai] == 700;
    }

    private void getCarboxyDelIsland(int oh) {
        int nb = this.cHtab[oh][0];
        int L = this.cHtab[nb].length + 1;
        this.sAtoms = new int[L];
        this.sphSize = 0;
        this.sAtoms[this.sphSize] = oh;
        ++this.sphSize;
        this.sAtoms[this.sphSize] = nb;
        ++this.sphSize;
        for (int i = 0; i < this.cHtab[nb].length; ++i) {
            int nnb = this.cHtab[nb][i];
            if (nnb >= this.MOLATOMS || nnb == oh || !this.getSymbol(nnb).equals("O")) continue;
            double ch = this.atomArray[nnb].getCharge();
            if (ch == -1.0) {
                this.sAtoms[this.sphSize] = nnb;
                ++this.sphSize;
                continue;
            }
            if (this.isKeto(nnb, ch)) {
                this.sAtoms[this.sphSize] = nnb;
                ++this.sphSize;
                continue;
            }
            if (this.pg.carboxy[nnb] != 300) continue;
            this.sAtoms[this.sphSize] = nnb;
            ++this.sphSize;
        }
    }

    private boolean isKeto(int o, double ch) {
        return ch == 0.0 && this.cHtab[o].length == 1;
    }

    public void extendWithHyperCon() {
        this.hyperC = new int[this.MOLATOMS];
        for (int i = 0; i < this.MOLATOMS; ++i) {
            if (!this.isSuperConjugate(i)) continue;
            this.delocAble[i] = 1;
            this.hyperC[i] = 1;
        }
    }

    protected void getDelocalizationIsland(int atom, int maxDistance) {
        int actAtom = atom;
        this.delocIsland = new int[this.MOLATOMS];
        this.sAtoms = new int[this.MOLATOMS];
        for (int i = 0; i < this.MOLATOMS; ++i) {
            this.sAtoms[i] = -1;
        }
        int distance = 1;
        boolean sChange = true;
        int i = 0;
        this.sphSize = 0;
        if (this.delocAble[atom] == 1) {
            this.sAtoms[this.sphSize] = atom;
            ++this.sphSize;
        } else {
            sChange = false;
        }
        while (distance < maxDistance + 1 & sChange) {
            sChange = false;
            if (actAtom != -1) {
                int length = this.cHtab[actAtom].length;
                for (int j = 0; j < length; ++j) {
                    int sphereAtom = this.cHtab[actAtom][j];
                    if (sphereAtom >= this.MOLATOMS || !(this.delocIsland[sphereAtom] == 0 & sphereAtom != atom) || this.delocAble[sphereAtom] != 1 || this.isArA(sphereAtom) || this.pg.carboxy[sphereAtom] == 1400) continue;
                    this.delocIsland[sphereAtom] = distance;
                    this.sAtoms[this.sphSize] = sphereAtom;
                    ++this.sphSize;
                }
            }
            if (this.sAtoms[i] != -1) {
                actAtom = this.sAtoms[i];
                distance = this.delocIsland[actAtom] + 1;
                sChange = true;
            } else {
                sChange = false;
            }
            if (++i != this.MOLATOMS) continue;
            sChange = false;
        }
        this.delocIsland[atom] = 0;
    }

    protected int getSphereSize() {
        return this.sphSize;
    }

    protected void getResonanceIsland(int atom, int maxDistance) {
        int actAtom = atom;
        this.delocIsland = new int[this.MOLATOMS];
        this.sAtoms = new int[this.MOLATOMS];
        int[] par = new int[this.MOLATOMS];
        for (int i = 0; i < this.MOLATOMS; ++i) {
            this.sAtoms[i] = -1;
        }
        int distance = 1;
        boolean sChange = true;
        int i = 0;
        int parentAtom = -1;
        this.sphSize = 0;
        if (this.delocAble[atom] == 1) {
            this.sAtoms[this.sphSize] = atom;
            ++this.sphSize;
        } else {
            sChange = false;
        }
        while (distance < maxDistance + 1 & sChange) {
            sChange = false;
            if (actAtom != -1) {
                int length = this.cHtab[actAtom].length;
                for (int j = 0; j < length; ++j) {
                    int sphereAtom = this.cHtab[actAtom][j];
                    if (sphereAtom >= this.MOLATOMS || !(this.delocIsland[sphereAtom] == 0 & sphereAtom != atom) || this.delocAble[sphereAtom] != 1 || this.isArA(sphereAtom)) continue;
                    if (parentAtom == -1) {
                        this.delocIsland[sphereAtom] = distance;
                        this.sAtoms[this.sphSize] = sphereAtom;
                        par[sphereAtom] = actAtom;
                        ++this.sphSize;
                        continue;
                    }
                    boolean cond = false;
                    int bParent = this.mol.getBond(this.bHtab[actAtom][parentAtom]).getType();
                    int bChild = this.mol.getBond(this.bHtab[actAtom][sphereAtom]).getType();
                    boolean singleBonded = this.isSingleBonded(sphereAtom);
                    if (this.pg.carboxy[sphereAtom] == 2) {
                        cond = true;
                    } else if (bParent != bChild && !singleBonded) {
                        cond = true;
                    }
                    if (!cond) continue;
                    this.delocIsland[sphereAtom] = distance;
                    this.sAtoms[this.sphSize] = sphereAtom;
                    par[sphereAtom] = actAtom;
                    ++this.sphSize;
                }
            }
            if (i + 1 == this.MOLATOMS) {
                sChange = false;
            } else if (this.sAtoms[i + 1] != -1) {
                actAtom = this.sAtoms[i + 1];
                parentAtom = par[actAtom];
                distance = this.delocIsland[actAtom] + 1;
                sChange = true;
            } else {
                sChange = false;
            }
            if (++i != this.MOLATOMS) continue;
            sChange = false;
        }
        this.delocIsland[atom] = 0;
        this.maxDelocLength = this.sphSize;
    }

    protected boolean isSingleBonded(int a) {
        for (int i = 0; i < this.cHtab[a].length; ++i) {
            int bt;
            int nb = this.cHtab[a][i];
            if (nb >= this.MOLATOMS || (bt = this.mol.getBond(this.bHtab[nb][a]).getType()) == 1) continue;
            return false;
        }
        return true;
    }

    public void calcExtendedDelocPath(int atom, int maxDistance) {
        boolean bb = true;
        if (!this.allowHypConj && this.hyperC != null) {
            bb = false;
        }
        int actAtom = atom;
        this.delocIsland = new int[this.MOLATOMS];
        this.sAtoms = new int[this.MOLATOMS];
        for (int i = 0; i < this.MOLATOMS; ++i) {
            this.sAtoms[i] = -1;
        }
        int distance = 1;
        boolean sChange = true;
        int i = 0;
        this.maxDelocLength = 0;
        this.sphSize = 0;
        if (this.delocAble[atom] == 1) {
            this.sAtoms[this.sphSize] = atom;
            ++this.sphSize;
        } else {
            sChange = false;
        }
        while (distance < maxDistance + 1 & sChange) {
            sChange = false;
            if (actAtom != -1) {
                int length = this.cHtab[actAtom].length;
                for (int j = 0; j < length; ++j) {
                    int sphereAtom = this.cHtab[actAtom][j];
                    if (sphereAtom >= this.MOLATOMS || !(this.delocIsland[sphereAtom] == 0 & sphereAtom != atom)) continue;
                    boolean vv = true;
                    if (!bb && this.hyperC[sphereAtom] == 1) {
                        vv = false;
                        this.delocAble[sphereAtom] = 0;
                        this.hyperC[sphereAtom] = 0;
                    }
                    if (this.delocAble[sphereAtom] != 1 || !vv) continue;
                    this.delocIsland[sphereAtom] = distance;
                    this.sAtoms[this.sphSize] = sphereAtom;
                    ++this.sphSize;
                }
            }
            if (this.sAtoms[i] != -1) {
                actAtom = this.sAtoms[i];
                distance = this.delocIsland[actAtom] + 1;
                sChange = true;
            } else {
                sChange = false;
            }
            if (++i != this.MOLATOMS) continue;
            sChange = false;
        }
        if (this.sphSize != 0) {
            this.delocIsland[atom] = 0;
            this.maxDelocLength = this.sphSize;
        }
    }

    private boolean isHyperConjugationBreaked(int atom, int deep) {
        int actAtom = atom;
        this.delocIsland = new int[this.MOLATOMS];
        this.sAtoms = new int[this.MOLATOMS];
        for (int i = 0; i < this.MOLATOMS; ++i) {
            this.sAtoms[i] = -1;
        }
        int distance = 1;
        boolean sChange = true;
        boolean direction = false;
        int i = 0;
        this.sphSize = 0;
        if (this.delocAble[atom] == 1) {
            this.sAtoms[this.sphSize] = atom;
            ++this.sphSize;
        } else {
            sChange = false;
        }
        while (distance < deep + 1 & sChange) {
            sChange = false;
            if (actAtom != -1) {
                int length = this.cHtab[actAtom].length;
                for (int j = 0; j < length; ++j) {
                    int sphereAtom = this.cHtab[actAtom][j];
                    if (sphereAtom >= this.MOLATOMS) continue;
                    if (actAtom == atom) {
                        direction = !this.isArA(sphereAtom);
                    }
                    if (!direction || this.delocIsland[sphereAtom] != 0 || sphereAtom == atom) continue;
                    if (this.delocAble[sphereAtom] == -1) {
                        this.delocIsland[sphereAtom] = distance;
                        this.sAtoms[this.sphSize] = sphereAtom;
                        ++this.sphSize;
                        continue;
                    }
                    if (!this.isHyperConjBreaker(sphereAtom)) continue;
                    return true;
                }
            }
            if (this.sAtoms[i] != -1) {
                actAtom = this.sAtoms[i];
                distance = this.delocIsland[actAtom] + 1;
                sChange = true;
                direction = true;
            } else {
                sChange = false;
            }
            if (++i != this.MOLATOMS) continue;
            sChange = false;
        }
        this.delocIsland[atom] = 0;
        return false;
    }

    private boolean isHyperConjBreaker(int atom) {
        int t = this.pg.carboxy[atom];
        switch (t) {
            case 1: {
                return true;
            }
            case 200: {
                return true;
            }
            case 100: {
                return true;
            }
            case 300: {
                return true;
            }
            case 500: {
                return true;
            }
            case 2: {
                return true;
            }
            case 1200: {
                return true;
            }
            case 1300: {
                return true;
            }
            case 800: {
                return true;
            }
            case 600: {
                return true;
            }
            case 400: {
                return true;
            }
            case 700: {
                return true;
            }
        }
        return false;
    }

    private boolean isVinilAliphaticIsland(int atom, int deep) {
        int actAtom = atom;
        this.sphSize = 0;
        this.delocIsland = new int[this.MOLATOMS];
        this.sAtoms = new int[this.MOLATOMS];
        int[] v = new int[this.MOLATOMS];
        for (int i = 0; i < this.MOLATOMS; ++i) {
            this.sAtoms[i] = -1;
            v[i] = -1;
        }
        int distance = 1;
        boolean sChange = true;
        boolean direction = false;
        int i = 0;
        boolean vinilPathBreaked = false;
        if (this.delocAble[atom] != -1) {
            v[actAtom] = 1;
        }
        while (distance < deep + 1 & sChange) {
            sChange = false;
            if (actAtom != -1) {
                int length = this.cHtab[actAtom].length;
                for (int j = 0; j < length; ++j) {
                    int sphereAtom = this.cHtab[actAtom][j];
                    if (sphereAtom >= this.MOLATOMS) continue;
                    if (actAtom == atom) {
                        direction = !this.isArA(sphereAtom);
                    }
                    if (!direction || this.delocIsland[sphereAtom] != 0 || sphereAtom == atom) continue;
                    this.delocIsland[sphereAtom] = distance;
                    this.sAtoms[this.sphSize] = sphereAtom;
                    ++this.sphSize;
                    if (this.delocAble[sphereAtom] == -1 || v[actAtom] != 1) continue;
                    v[sphereAtom] = 1;
                    if (distance <= 1 || !this.isVinilBrakerGroup(sphereAtom)) continue;
                    vinilPathBreaked = true;
                }
            }
            if (this.sAtoms[i] != -1) {
                actAtom = this.sAtoms[i];
                distance = this.delocIsland[actAtom] + 1;
                sChange = true;
                direction = true;
            } else {
                sChange = false;
            }
            ++i;
        }
        this.delocIsland[atom] = 0;
        return vinilPathBreaked;
    }

    private boolean isVinilBrakerGroup(int atom) {
        int t = this.pg.carboxy[atom];
        switch (t) {
            case 1: {
                return true;
            }
            case 200: {
                return true;
            }
            case 100: {
                return true;
            }
            case 300: {
                return true;
            }
            case 500: {
                return true;
            }
            case 2: {
                return true;
            }
            case 1200: {
                return true;
            }
            case 1300: {
                return true;
            }
            case 800: {
                return true;
            }
            case 600: {
                return true;
            }
            case 400: {
                return true;
            }
            case 700: {
                return true;
            }
        }
        return false;
    }

    private void getAtomDistances(int atom, int MAXSPHERE) {
        int i;
        int actAtom = atom;
        int sphSize = 0;
        int[] dist = new int[this.MOLATOMS];
        int[] used = new int[this.MOLATOMS];
        int[] sphere = new int[this.MOLATOMS];
        int maxNb = 7;
        for (i = 0; i < this.MOLATOMS; ++i) {
            sphere[i] = -1;
        }
        for (i = 0; i < 8; ++i) {
            this.araDist[i][0] = -1;
            this.araDist[i][1] = -1;
            this.araDist[i][2] = -1;
            this.araDist[i][3] = -1;
            this.araDist[i][4] = -1;
            this.araDist[i][5] = -1;
            this.araDist[i][6] = -1;
        }
        int distance = 1;
        int k = 0;
        boolean sChange = true;
        int i2 = 0;
        while (distance < MAXSPHERE + 1 & sChange) {
            sChange = false;
            if (actAtom != -1) {
                int length = this.cHtab[actAtom].length;
                for (int j = 0; j < length; ++j) {
                    int sphereAtom = this.cHtab[actAtom][j];
                    if (sphereAtom >= this.MOLATOMS || this.mol.getBond(this.bHtab[sphereAtom][actAtom]).getType() != 4 || used[sphereAtom] == 1 || sphereAtom == atom || k >= maxNb) continue;
                    dist[sphereAtom] = distance;
                    used[sphereAtom] = 1;
                    this.araDist[distance][k] = sphereAtom;
                    sphere[sphSize] = sphereAtom;
                    ++sphSize;
                    ++k;
                }
            }
            if (sphere[i2] != -1) {
                actAtom = sphere[i2];
                distance = dist[actAtom] + 1;
                for (k = 0; k < maxNb && this.araDist[distance][k] != -1; ++k) {
                }
                sChange = k < maxNb;
            } else {
                sChange = false;
            }
            ++i2;
        }
    }

    protected int getLargestAraRingIndex(int atom) {
        int rIndex = -1;
        int j = 0;
        boolean find = false;
        for (int i = this.aRingNumber - 1; i > -1 && !find; --i) {
            for (j = 0; j < this.aAtoms[i].length && !find; ++j) {
                if (this.aAtoms[i][j] != atom) continue;
                rIndex = i;
                find = true;
            }
        }
        return rIndex;
    }

    public int[] findLargestRing(int atom) {
        int i;
        boolean notFind = true;
        int[] ringInfo = new int[]{-1, -1, -1, -1, -1};
        for (i = 0; notFind && i < this.aRingNumber; ++i) {
            for (int j = 0; j < this.aAtoms[i].length; ++j) {
                if (this.aAtoms[i][j] != atom) continue;
                notFind = false;
                ringInfo[0] = i;
            }
        }
        if (ringInfo[0] != -1) {
            int ringIndex = ringInfo[0];
            int ncount = 0;
            int xcount = 0;
            for (i = 0; i < this.aAtoms[ringIndex].length; ++i) {
                if (this.getSymbol(this.aAtoms[ringIndex][i]).equals("C")) continue;
                ringInfo[1] = 1;
                if (this.getSymbol(this.aAtoms[ringIndex][i]).equals("N")) {
                    ++ncount;
                    ringInfo[3] = this.aAtoms[ringIndex][i];
                }
                ++xcount;
            }
            ringInfo[4] = xcount;
            ringInfo[2] = ncount;
        }
        return ringInfo;
    }

    protected int getSmallestAraRingIndex(int atom) {
        return this.findSmallestAraRing(atom);
    }

    protected int findSmallestAraRing(int atom) {
        for (int i = 0; i < this.aRingNumber; ++i) {
            for (int j = 0; j < this.aAtoms[i].length; ++j) {
                if (this.aAtoms[i][j] != atom) continue;
                return i;
            }
        }
        return -1;
    }

    protected int getLargestRing(int atom) {
        int rSize = 0;
        if (this.isArA(atom)) {
            for (int i = 0; i < this.aRingNumber; ++i) {
                for (int j = 0; j < this.aAtoms[i].length; ++j) {
                    if (this.aAtoms[i][j] != atom || rSize >= this.aAtoms[i].length) continue;
                    rSize = this.aAtoms[i].length;
                    this.ringIndex = i;
                }
            }
        }
        return this.ringIndex;
    }

    private void heteroDispersion(int atom, double charge) {
        int[] ringInfo = this.findLargestRing(atom);
        double sum = 0.0;
        double[] a = new double[]{0.0, 0.0};
        if (ringInfo[1] == 1) {
            int aAtom;
            int i;
            int size = this.aAtoms[ringInfo[0]].length;
            for (i = 0; i < size; ++i) {
                aAtom = this.aAtoms[ringInfo[0]][i];
                a = this.getSigmaTypeEleNe(aAtom);
                sum += a[0];
            }
            if (charge < 0.0) {
                for (i = 0; i < size; ++i) {
                    aAtom = this.aAtoms[ringInfo[0]][i];
                    a = this.getSigmaTypeEleNe(aAtom);
                    int n = aAtom;
                    this.spsChg[n] = this.spsChg[n] + charge * a[0] / sum;
                }
            }
            if (charge > 0.0) {
                int n = atom;
                this.spsChg[n] = this.spsChg[n] + charge;
            }
        }
    }

    public int[] findLargestHeteroRing(int atom) {
        int i;
        int[] ringInfo = new int[]{-1, -1, -1, -1};
        boolean find = false;
        for (i = this.aRingNumber - 1; i > -1 && !find; --i) {
            for (int j = 0; j < this.aAtoms[i].length && !find; ++j) {
                if (this.aAtoms[i][j] != atom) continue;
                ringInfo[0] = i;
                find = true;
            }
        }
        if (ringInfo[0] != -1) {
            int ringIndex = ringInfo[0];
            int ncount = 0;
            for (i = 0; i < this.aAtoms[ringIndex].length; ++i) {
                if (this.getSymbol(this.aAtoms[ringIndex][i]).equals("C")) continue;
                ringInfo[1] = 1;
                if (!this.getSymbol(this.aAtoms[ringIndex][i]).equals("N")) continue;
                ++ncount;
                ringInfo[3] = this.aAtoms[ringIndex][i];
            }
            ringInfo[2] = ncount;
        }
        return ringInfo;
    }

    private void setSigmaCharge(int i, double q) {
        this.Qsigma[i] = q;
    }

    private void setPiCharge(int i, double q) {
        this.Qpi[i] = q;
    }

    private void setTotalCharge(int i) {
        this.Qsum[i] = this.Qpi[i] + this.Qsigma[i];
    }

    public int[] getRingInfo(int atom) {
        this.ringSize = 0;
        if (!this.isArA(atom)) {
            return new int[]{this.ringSize, this.ringIndex};
        }
        for (int i = 0; i < this.aRingNumber && this.ringSize == 0; ++i) {
            for (int j = 0; j < this.aAtoms[i].length; ++j) {
                if (this.aAtoms[i][j] != atom) continue;
                this.ringSize = this.aAtoms[i].length;
                this.ringIndex = i;
            }
        }
        return new int[]{this.ringSize, this.ringIndex};
    }

    private void mesomerEffect(int ara, double inputCharge, double itStep, boolean innerRes) {
        int j;
        double[] aoe = new double[]{0.0, 0.0};
        double plusM = 0.0;
        double minusM = 0.0;
        if (this.isOddNumber(this.ringSize)) {
            this.setStereoPosFMR(ara, this.ringIndex);
        } else if (this.ringSize != 0) {
            this.setStereoPosSMR(ara, this.ringIndex, innerRes);
        }
        double[] arEleNe = new double[this.stereoPos.length];
        int k = 0;
        for (j = 0; j < this.stereoPos.length; ++j) {
            if (this.stereoPos[j] == -1) continue;
            aoe = this.getPiTypeEleNe(this.piAtomType[this.stereoPos[j]], this.stereoPos[j]);
            plusM += aoe[0];
            minusM += 1.0 / aoe[0];
            arEleNe[k] = aoe[0];
            ++k;
        }
        k = 0;
        for (j = 0; j < this.stereoPos.length; ++j) {
            double Wj;
            if (this.stereoPos[j] == -1) continue;
            double d = Wj = inputCharge < 0.0 ? arEleNe[k] / plusM : 1.0 / (arEleNe[k] * minusM);
            if (Wj > 1.0) {
                Wj = 0.95;
            } else if (Wj < -1.0) {
                Wj = -0.95;
            }
            int n = this.stereoPos[j];
            this.accumCharge[n] = this.accumCharge[n] + Wj * inputCharge * Math.pow(0.5, itStep);
            ++k;
        }
    }

    private boolean isOddNumber(int d) {
        int y = d & 1;
        return y == 1;
    }

    protected boolean isArA(int atom) {
        return this.getRings().isAra(atom);
    }

    private int getArCount() {
        return this.getRings().getAromaticAtomCount();
    }

    public RingAnalyzer getRings() {
        if (this.rings == null) {
            this.rings = new RingAnalyzer(this.getMolecule(), this.aromatizationType);
        }
        return this.rings;
    }

    private void calcSigmaCharge() {
        double alpha = 1.0;
        do {
            int i = 0;
            while (i < this.MOLATOMS + this.IMPLICITH) {
                double[] Ai = this.getSigmaTypeEleNe(i);
                double sum1 = 0.0;
                for (int j = 0; j < this.cHtab[i].length; ++j) {
                    int an = this.cHtab[i][j];
                    double[] Aj = this.getSigmaTypeEleNe(an);
                    if (Aj[0] > Ai[0]) {
                        sum1 += (Aj[0] - Ai[0]) / Ai[1];
                        continue;
                    }
                    sum1 += (Aj[0] - Ai[0]) / Aj[1];
                }
                int n = i++;
                this.accumCharge[n] = this.accumCharge[n] + sum1 * Math.pow(0.5, alpha);
            }
            alpha += 1.0;
            for (i = 0; i < this.MOLATOMS + this.IMPLICITH; ++i) {
                this.setSigmaCharge(i, this.accumCharge[i]);
                this.setTotalCharge(i);
            }
        } while (alpha < 10.0);
    }

    public boolean isRightAtom(int atom) {
        if (this.getSymbol(atom).equals("H")) {
            return false;
        }
        if (this.getSymbol(atom).equals("I")) {
            return false;
        }
        if (this.getSymbol(atom).equals("Br")) {
            return false;
        }
        if (this.getSymbol(atom).equals("N")) {
            if (this.pg.carboxy[atom] == 1200) {
                return true;
            }
            if (this.cHtab[atom].length != 4) {
                return true;
            }
            if (this.cHtab[atom].length == 4) {
                return this.atomArray[atom].getCharge() == 0;
            }
            return false;
        }
        if (this.getSymbol(atom).equals("P")) {
            return true;
        }
        if (this.getSymbol(atom).equals("C")) {
            if (this.cHtab[atom].length != 4) {
                return true;
            }
            if (this.isHyperconjugate(atom)) {
                this.hconj[atom] = 1;
                return true;
            }
            return false;
        }
        return !this.getSymbol(atom).equals("Si") && !this.getSymbol(atom).equals("Ge") && !this.getSymbol(atom).equals("Sn");
    }

    private boolean isHyperconjugate(int atom) {
        boolean hypCond = false;
        int nbCounter = 0;
        if (this.getSymbol(atom).equals("C") && this.cHtab[atom].length == 4) {
            for (int i = 0; i < this.cHtab[atom].length; ++i) {
                int nb = this.cHtab[atom][i];
                String symbol = nb >= this.MOLATOMS ? "H" : this.getSymbol(nb);
                if (this.isArA(nb)) {
                    if (this.atomArray[nb].getCharge() < 0) {
                        return false;
                    }
                    ++nbCounter;
                    hypCond = true;
                    continue;
                }
                if (!symbol.equals("C") && !symbol.equals("H")) {
                    return false;
                }
                if (symbol.equals("C") && this.cHtab[nb].length == 4) {
                    ++nbCounter;
                    continue;
                }
                if (symbol.equals("H")) {
                    ++nbCounter;
                    continue;
                }
                return false;
            }
            if (nbCounter == 4 & hypCond) {
                return true;
            }
        }
        return false;
    }

    private void setRingResonance() {
        int i;
        if (this.resonanceCharge) {
            return;
        }
        if (this.getArCount() == 0) {
            return;
        }
        this.RRPairs = new int[this.getArCount()][9];
        for (i = 0; i < 9; ++i) {
            for (int j = 0; j < this.getArCount(); ++j) {
                this.RRPairs[j][i] = -1;
            }
        }
        for (i = 0; i < this.getArCount(); ++i) {
            int ai = this.arIndex[i];
            if (!this.isArA(ai) || this.getValenceState(ai) == 12) continue;
            for (int j = 0; j < this.cHtab[ai].length; ++j) {
                int[] rIndex1;
                int nb = this.cHtab[ai][j];
                if (this.getValenceState(nb) != 12 || !this.CheckHeteroAtoms(rIndex1 = this.getRings(nb))) continue;
                int[] rIndex2 = this.getRings(ai);
                boolean sRing = !this.findRingDiff(rIndex1, rIndex2);
                int k = 0;
                while (k < 3 & !sRing) {
                    if (rIndex1[k] != rIndex2[k] && rIndex1[k] != -1) {
                        sRing = true;
                        int ind = this.atIndex[nb];
                        if (this.RRPairs[ind][0] == -1) {
                            this.RRPairs[ind][0] = ai;
                            this.RRPairs[ind][1] = rIndex1[k];
                            this.RRPairs[ind][2] = this.aAtoms[rIndex1[k]].length;
                        } else if (this.RRPairs[ind][3] == -1) {
                            this.RRPairs[ind][3] = ai;
                            this.RRPairs[ind][4] = rIndex1[k];
                            this.RRPairs[ind][5] = this.aAtoms[rIndex1[k]].length;
                        } else if (this.RRPairs[ind][6] == -1) {
                            this.RRPairs[ind][6] = ai;
                            this.RRPairs[ind][7] = rIndex1[k];
                            this.RRPairs[ind][8] = this.aAtoms[rIndex1[k]].length;
                        }
                    }
                    ++k;
                }
            }
        }
    }

    private boolean findRingDiff(int[] rIndex1, int[] rIndex2) {
        int common = 0;
        for (int j = 0; j < 3; ++j) {
            for (int i = 0; i < 3; ++i) {
                if (rIndex1[i] != rIndex2[j] || rIndex1[i] == -1) continue;
                ++common;
            }
        }
        for (int i = 0; i < 3; ++i) {
            if (rIndex1[i] != -1) continue;
            ++common;
        }
        return common < 3;
    }

    private boolean CheckHeteroAtoms(int[] rIndex1) {
        int totHCount = 0;
        boolean ringRes = true;
        int sixCount = 0;
        int fiveCount = 0;
        for (int i = 0; i < 3; ++i) {
            int hCount = 0;
            int ri = rIndex1[i];
            if (ri == -1) continue;
            int L = this.aAtoms[ri].length;
            for (int j = 0; j < L; ++j) {
                if (this.getSymbol(this.aAtoms[ri][j]).equals("C")) continue;
                ++hCount;
                ++totHCount;
            }
            if (hCount > 1) {
                if (L == 6) {
                    ++sixCount;
                }
                if (L != 5) continue;
                ringRes = false;
                continue;
            }
            if (hCount != true) continue;
            if (L == 6) {
                ++sixCount;
            }
            if (L != 5) continue;
            ++fiveCount;
        }
        if (sixCount > 1) {
            ringRes = false;
        } else if (fiveCount == 1 & totHCount == 1) {
            ringRes = false;
        } else if (sixCount == 1 & totHCount > 1 & fiveCount == 0) {
            ringRes = true;
        } else if (totHCount == 0) {
            ringRes = false;
        }
        return ringRes;
    }

    private int[] getRings(int atom) {
        int ringCount = 0;
        int[] rIndex = new int[]{-1, -1, -1};
        int i = 0;
        while (ringCount < 3 & i < this.aRingNumber) {
            boolean ringFind = false;
            int L = this.aAtoms[i].length;
            if (L <= 6) {
                for (int j = 0; j < L && !ringFind; ++j) {
                    if (this.aAtoms[i][j] != atom) continue;
                    rIndex[ringCount] = i;
                    ringFind = true;
                    ++ringCount;
                }
            }
            ++i;
        }
        return rIndex;
    }

    private void calcPiCharge() {
        double[] Ai = new double[]{0.0, 0.0};
        double[] Aj = new double[]{0.0, 0.0};
        double sum1 = 0.0;
        double alpha = 1.0;
        for (int i = 0; i < this.MOLATOMS; ++i) {
            this.accumCharge[i] = 0.0;
        }
        this.setSpArray();
        do {
            int i;
            for (i = 0; i < this.MOLATOMS; ++i) {
                if (this.delocAble[i] != 1) continue;
                Ai = this.getPiTypeEleNe(this.piAtomType[i], i);
                sum1 = 0.0;
                for (int j = 0; j < this.cHtab[i].length; ++j) {
                    double sum;
                    int an = this.cHtab[i][j];
                    if (an >= this.MOLATOMS || this.delocAble[an] != 1) continue;
                    Aj = this.getPiTypeEleNe(this.piAtomType[an], an);
                    double diff = Aj[0] - Ai[0];
                    double d = sum = Aj[0] > Ai[0] ? diff / Ai[1] : diff / Aj[1];
                    if (this.isArA(i) && !this.isArA(an)) {
                        this.getRingInfo(i);
                        this.mesomerEffect(i, sum, alpha, false);
                        continue;
                    }
                    if (this.isArA(i) && this.isArA(an)) {
                        int bondOrder = this.mol.getBond(this.bHtab[an][i]).getType();
                        if (bondOrder != 4) {
                            if (this.isBiphenylBond(i, an)) {
                                this.getRingInfo(i);
                                this.mesomerEffect(i, sum, alpha, true);
                                continue;
                            }
                            if (!this.isAraBondExist(i, an)) continue;
                            this.getRingInfo(i);
                            this.mesomerEffect(i, sum, alpha, true);
                            continue;
                        }
                        if (!this.resonanceCharge) {
                            int ind = this.atIndex[i];
                            if (this.RRPairs[ind][0] == an) {
                                this.ringIndex = this.RRPairs[ind][1];
                                this.ringSize = this.RRPairs[ind][2];
                                this.mesomerEffect(i, sum, alpha, true);
                                continue;
                            }
                            if (this.RRPairs[ind][3] == an) {
                                this.ringIndex = this.RRPairs[ind][4];
                                this.ringSize = this.RRPairs[ind][5];
                                this.mesomerEffect(i, sum, alpha, true);
                                continue;
                            }
                            if (this.RRPairs[ind][6] == an) {
                                this.ringIndex = this.RRPairs[ind][7];
                                this.ringSize = this.RRPairs[ind][8];
                                this.mesomerEffect(i, sum, alpha, true);
                                continue;
                            }
                            sum1 += sum;
                            continue;
                        }
                        sum1 += sum;
                        continue;
                    }
                    sum1 += sum;
                }
                double prev = this.accumCharge[i];
                double power = Math.pow(0.5, alpha);
                int n = i;
                this.accumCharge[n] = this.accumCharge[n] + sum1 * Math.pow(0.5, alpha);
            }
            alpha += 1.0;
            for (i = 0; i < this.MOLATOMS; ++i) {
                this.setPiCharge(i, this.accumCharge[i]);
                this.setTotalCharge(i);
            }
        } while (alpha < 10.0);
    }

    private boolean isAraBondExist(int a1, int a2) {
        return this.getLargestAraRingIndex(a1) == this.getLargestAraRingIndex(a2);
    }

    private void setSpArray() {
        int i;
        int k = 0;
        for (i = 0; i < this.MOLATOMS; ++i) {
            if (!this.isArA(i)) continue;
            ++k;
        }
        this.spp = new int[k][4];
        k = 0;
        for (i = 0; i < this.MOLATOMS; ++i) {
            if (!this.isArA(i)) continue;
            this.spp[k][0] = i;
            this.spp[k][1] = -1;
            this.spp[k][2] = -1;
            this.spp[k][3] = -1;
            ++k;
        }
    }

    private boolean isBiphenylBond(int a1, int a2) {
        if (this.findSmallestAraRing(a1) == this.findSmallestAraRing(a2)) {
            return false;
        }
        return this.isDiAra(a1) && this.isDiAra(a2);
    }

    private boolean isDiAra(int a1) {
        int c = 0;
        for (int i = 0; i < this.cHtab[a1].length; ++i) {
            int nb = this.cHtab[a1][i];
            if (!this.isArA(nb) || this.mol.getBond(this.bHtab[a1][nb]).getType() != 4) continue;
            ++c;
        }
        return c == 2;
    }

    public int getValenceState(int atom1) {
        int j = this.cHtab[atom1].length;
        int valence = 0;
        for (int i = 0; i < j; ++i) {
            int atom2 = this.cHtab[atom1][i];
            if (this.bHtab[atom1][atom2] == -2) {
                ++valence;
                continue;
            }
            valence += this.mol.getBond(this.bHtab[atom1][atom2]).getType();
        }
        return valence;
    }

    private int[] setStereoPosFMR(int sp, int rIndex) {
        int nb;
        for (int i = 0; i < this.stereoPos.length; ++i) {
            this.stereoPos[i] = -1;
        }
        if (rIndex == -1) {
            return this.stereoPos;
        }
        if (this.isSingleBondedAraAtom(sp)) {
            return this.stereoPos;
        }
        int ind = this.getSpIndex(sp);
        if (ind == -1) {
            return this.stereoPos;
        }
        if (this.spp[ind][1] != -1) {
            this.stereoPos[0] = this.spp[ind][1];
            this.stereoPos[1] = this.spp[ind][2];
            this.stereoPos[2] = this.spp[ind][3];
            return this.stereoPos;
        }
        int L = this.cHtab[sp].length;
        boolean find = false;
        int xx = -1;
        int j = 0;
        int[] x = new int[]{-1, -1, -1, -1};
        for (int k = 0; k < L; ++k) {
            nb = this.cHtab[sp][k];
            if (nb >= this.MOLATOMS || !this.isArA(nb) || !this.isInThisRing(nb, rIndex)) continue;
            x[j] = nb;
            if (this.isSingleBondedAraAtom(nb)) {
                find = true;
                xx = nb;
            }
            ++j;
        }
        if (find) {
            this.stereoPos[0] = x[0];
            this.stereoPos[1] = x[1];
            for (int i = 0; i < this.cHtab[xx].length; ++i) {
                nb = this.cHtab[xx][i];
                if (nb >= this.MOLATOMS || nb == sp || !this.isInThisRing(nb, rIndex)) continue;
                this.stereoPos[2] = nb;
            }
            this.spp[ind][1] = this.stereoPos[0];
            this.spp[ind][2] = this.stereoPos[1];
            this.spp[ind][3] = this.stereoPos[2];
            return this.stereoPos;
        }
        int z = -1;
        if (j == 2) {
            z = this.isXNbExist(x[0], sp, rIndex);
            if (z != -1) {
                this.stereoPos[0] = x[0];
                this.stereoPos[1] = z;
            } else {
                z = this.isXNbExist(x[1], sp, rIndex);
                if (z != -1) {
                    this.stereoPos[0] = x[1];
                    this.stereoPos[1] = z;
                }
            }
        }
        this.spp[ind][1] = this.stereoPos[0];
        this.spp[ind][2] = this.stereoPos[1];
        this.spp[ind][3] = this.stereoPos[2];
        return this.stereoPos;
    }

    private int getSpIndex(int sp) {
        for (int i = 0; i < this.spp.length; ++i) {
            if (this.spp[i][0] != sp) continue;
            return i;
        }
        return -1;
    }

    private int isXNbExist(int a, int sp, int ri) {
        for (int i = 0; i < this.cHtab[a].length; ++i) {
            int nb = this.cHtab[a][i];
            if (nb >= this.MOLATOMS || !this.isArA(nb) || !this.isInThisRing(nb, ri) || nb == sp || !this.isSingleBondedAraAtom(nb)) continue;
            return nb;
        }
        return -1;
    }

    private boolean isInThisRing(int nb, int rIndex) {
        for (int i = 0; i < this.aAtoms[rIndex].length; ++i) {
            int a = this.aAtoms[rIndex][i];
            if (a != nb) continue;
            return true;
        }
        return false;
    }

    private int[] setStereoPosSMR(int sp, int rIndex, boolean innerRes) {
        for (int j = 0; j < this.stereoPos.length; ++j) {
            this.stereoPos[j] = -1;
        }
        if (!innerRes) {
            if (this.isHeteroRing(rIndex)) {
                this.set3Pos(rIndex, sp);
            } else if (this.isLargestHeteroRing(sp)) {
                this.getAtomDistances(sp, 7);
                int k = 0;
                int m = 0;
                for (int j = 0; j < this.stereoPos.length; j += 7) {
                    k = 2 * m + 1;
                    this.stereoPos[j] = this.araDist[k][0];
                    this.stereoPos[j + 1] = this.araDist[k][1];
                    this.stereoPos[j + 2] = this.araDist[k][2];
                    this.stereoPos[j + 3] = this.araDist[k][3];
                    this.stereoPos[j + 4] = this.araDist[k][4];
                    this.stereoPos[j + 5] = this.araDist[k][5];
                    this.stereoPos[j + 6] = this.araDist[k][6];
                    ++m;
                }
            } else {
                this.set3Pos(rIndex, sp);
            }
        } else {
            this.set3Pos(rIndex, sp);
        }
        return this.stereoPos;
    }

    private void set3Pos(int rIndex, int keyAtom) {
        int nb1 = 0;
        int nb2 = 0;
        int nb3 = 0;
        try {
            nb1 = this.cHtab[keyAtom][0];
            nb2 = this.cHtab[keyAtom][1];
            nb3 = this.cHtab[keyAtom][2];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return;
        }
        for (int i = 0; i < this.aAtoms[rIndex].length; ++i) {
            int ra = this.aAtoms[rIndex][i];
            if (ra == nb1) {
                if (this.stereoPos[0] == -1) {
                    this.stereoPos[0] = nb1;
                    continue;
                }
                this.stereoPos[1] = nb1;
                continue;
            }
            if (ra == nb2) {
                if (this.stereoPos[0] == -1) {
                    this.stereoPos[0] = nb2;
                    continue;
                }
                this.stereoPos[1] = nb2;
                continue;
            }
            if (ra != nb3) continue;
            if (this.stereoPos[0] == -1) {
                this.stereoPos[0] = nb3;
                continue;
            }
            this.stereoPos[1] = nb3;
        }
        boolean find = false;
        for (int i = 0; i < this.aAtoms[rIndex].length && !find; ++i) {
            int ra = this.aAtoms[rIndex][i];
            find = true;
            for (int j = 0; j < this.cHtab[ra].length; ++j) {
                if (this.cHtab[ra][j] == this.stereoPos[0]) {
                    find = false;
                    continue;
                }
                if (this.cHtab[ra][j] == this.stereoPos[1]) {
                    find = false;
                    continue;
                }
                if (ra != this.stereoPos[0] && ra != this.stereoPos[1]) continue;
                find = false;
            }
            if (!find) continue;
            this.stereoPos[2] = ra;
        }
    }

    private boolean isLargestHeteroRing(int atom) {
        int[] ringInfo = new int[]{-1, -1, -1, -1};
        boolean find = false;
        for (int i = this.aRingNumber - 1; i > -1 && !find; --i) {
            for (int j = 0; j < this.aAtoms[i].length && !find; ++j) {
                if (this.aAtoms[i][j] != atom) continue;
                ringInfo[0] = i;
                find = true;
                if (!this.isHeteroRing(i)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isHeteroRing(int rIndex) {
        for (int i = 0; i < this.aAtoms[rIndex].length; ++i) {
            if (this.getSymbol(this.aAtoms[rIndex][i]).equals("C")) continue;
            return true;
        }
        return false;
    }

    private void setPiEleNeType(int atom) {
        int na = this.cHtab[atom].length;
        int atno = this.getAtno(atom);
        switch (atno) {
            case 7: {
                if (this.isArA(atom)) {
                    if (na == 3) {
                        if (this.atomArray[atom].getCharge() == 1 || this.pg.carboxy[atom] == 1200) {
                            this.getPzEleNe(atom, atno);
                            break;
                        }
                        this.getFreeEleNe(atom, atno);
                        break;
                    }
                    if (this.atomArray[atom].getCharge() == -1) {
                        this.getFreeEleNe(atom, atno);
                        break;
                    }
                    this.getPzEleNe(atom, atno);
                    break;
                }
                if (na < 3 || this.getValenceState(atom) == 5 || this.pg.carboxy[atom] == 1200) {
                    this.getPzEleNe(atom, atno);
                    break;
                }
                this.getFreeEleNe(atom, atno);
                break;
            }
            case 6: {
                if (na < 4) {
                    this.getPzEleNe(atom, atno);
                    break;
                }
                this.piAtomType[atom] = 14;
                break;
            }
            case 15: {
                if (this.getValenceState(atom) == 3) {
                    this.getFreeEleNe(atom, atno);
                    break;
                }
                this.getPzEleNe(atom, atno);
                break;
            }
            case 4: 
            case 5: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 33: 
            case 80: {
                this.getPzEleNe(atom, atno);
                break;
            }
            case 8: {
                if (this.isArA(atom) || na == 1 || na == 2 && this.getValenceState(atom) == 3) {
                    this.getPzEleNe(atom, atno);
                    break;
                }
                this.getFreeEleNe(atom, atno);
                break;
            }
            case 16: 
            case 34: {
                if (!this.isArA(atom) && na == this.getValenceState(atom)) {
                    if (this.atomArray[atom].getCharge() == -1) {
                        this.getPzEleNe(atom, atno);
                        break;
                    }
                    this.getFreeEleNe(atom, atno);
                    break;
                }
                this.getPzEleNe(atom, atno);
                break;
            }
            case 9: 
            case 17: 
            case 35: 
            case 53: {
                this.getFreeEleNe(atom, atno);
                break;
            }
            default: {
                this.getPzEleNe(atom, atno);
            }
        }
    }

    protected void getFreeEleNe(int atom, int atno) {
        if (atno == 8) {
            this.piAtomType[atom] = 12;
        } else if (atno == 16 || atno == 34) {
            this.piAtomType[atom] = 13;
        } else if (atno == 7) {
            this.piAtomType[atom] = this.pg.carboxy[atom] == 500 || this.pg.carboxy[atom] == 700 ? 20 : 14;
        } else if (atno == 15) {
            this.piAtomType[atom] = 23;
        } else if (atno == 9) {
            this.piAtomType[atom] = 15;
        } else if (atno == 17) {
            this.piAtomType[atom] = 16;
        } else if (atno == 35) {
            this.piAtomType[atom] = 17;
        } else if (atno == 53) {
            this.piAtomType[atom] = 18;
        }
    }

    private void getPzEleNe(int atom, int atno) {
        int nb = this.cHtab[atom].length;
        this.piAtomType[atom] = 9;
        if (atno == 8) {
            this.piAtomType[atom] = this.atomArray[atom].getCharge() == -1 ? 4 : 0;
        } else if (atno == 16 || atno == 34) {
            this.piAtomType[atom] = nb == 3 ? 11 : 1;
        } else if (atno == 7) {
            this.piAtomType[atom] = 2;
        } else if (atno == 14) {
            this.piAtomType[atom] = 5;
        } else if (atno == 6) {
            this.piAtomType[atom] = this.atomArray[atom].getCharge() == 1 ? 8 : (this.atomArray[atom].getCharge() == -1 ? 24 : 3);
        } else if (atno == 5) {
            this.piAtomType[atom] = 6;
        } else if (atno == 15) {
            this.piAtomType[atom] = 7;
        } else if (atno == 33) {
            this.piAtomType[atom] = 19;
        } else if (atno == 12) {
            this.piAtomType[atom] = 8;
        } else if (atno == 13) {
            this.piAtomType[atom] = 9;
        } else if (atno == 80) {
            this.piAtomType[atom] = 9;
        } else if (atno == 11) {
            this.piAtomType[atom] = 9;
        } else if (atno == 27) {
            this.piAtomType[atom] = 9;
        } else if (atno == 4) {
            this.piAtomType[atom] = 10;
        }
    }

    private double[] getSigmaTypeEleNe(int atomIndex) {
        double[] aoe = new double[]{0.0, 0.0};
        if (atomIndex >= this.MOLATOMS) {
            int typeInd = 0;
            double q = this.Qsigma[atomIndex];
            aoe[0] = AOE[typeInd][0] + AOE[typeInd][1] * q + AOE[typeInd][2] * q * q;
            aoe[1] = 20.02;
        } else {
            int typeInd = this.sigmaAtomType[atomIndex];
            if (typeInd == 0) {
                double q = this.Qsigma[atomIndex];
                aoe[0] = AOE[typeInd][0] + AOE[typeInd][1] * q + AOE[typeInd][2] * q * q;
                aoe[1] = 20.02;
            } else {
                double q = this.Qpi[atomIndex] + this.Qsigma[atomIndex];
                aoe[0] = AOE[typeInd][0] + AOE[typeInd][1] * q + AOE[typeInd][2] * q * q;
                aoe[1] = AOE[typeInd][0] + AOE[typeInd][1] + AOE[typeInd][2];
            }
        }
        return aoe;
    }

    private double[] getPiTypeEleNe(int typeIndex, int atomIndex) {
        double[] aoe = new double[]{0.0, 0.0};
        double q = this.Qpi[atomIndex] + this.Qsigma[atomIndex];
        aoe[0] = typeIndex == 24 ? 5.64 * Math.pow(2.718282, 1.1654 * q) : piAOE[typeIndex][0] + piAOE[typeIndex][1] * q + piAOE[typeIndex][2] * q * q;
        aoe[1] = piAOE[typeIndex][0] + piAOE[typeIndex][1] + piAOE[typeIndex][2];
        return aoe;
    }

    protected void setSigmaEleNeType(int atom) {
        String symb = this.getSymbol(atom);
        int na = this.cHtab[atom].length;
        int vs = this.getValenceState(atom);
        if (symb.equals("H")) {
            this.sigmaAtomType[atom] = 0;
            if (na > 1) {
                this.hValenceError = true;
            }
        } else if (symb.equals("C")) {
            if (na == 4) {
                this.sigmaAtomType[atom] = 1;
            } else if (na == 3) {
                this.sigmaAtomType[atom] = this.atomArray[atom].getCharge() == 1 ? 1 : 2;
            } else if (na == 2) {
                this.sigmaAtomType[atom] = 3;
            }
        } else if (symb.equals("N")) {
            if (na == 4) {
                this.sigmaAtomType[atom] = this.pg.carboxy[atom] == 1200 ? 5 : 15;
            } else if (na == 3) {
                if (this.isArA(atom)) {
                    int ind = this.atomArray[atom].getCharge() == 1 ? 5 : (vs == 10 ? 5 : 14);
                    this.sigmaAtomType[atom] = ind;
                } else {
                    this.sigmaAtomType[atom] = vs == 5 ? 5 : (this.atomArray[atom].getCharge() == 1 ? 5 : (this.pg.carboxy[atom] == 1200 ? 5 : 4));
                }
            } else if (na == 2) {
                this.sigmaAtomType[atom] = this.pg.carboxy[atom] == 400 ? (this.pg.chargeState[atom] == 900 ? 8 : 5) : 5;
            } else if (na == 1) {
                this.sigmaAtomType[atom] = 6;
            }
        } else if (symb.equals("O")) {
            if (na == 2) {
                this.sigmaAtomType[atom] = vs == 3 ? 7 : 7;
            } else if (na == 1) {
                this.sigmaAtomType[atom] = vs == 1 ? 16 : (this.isEquivalent(atom) ? 16 : 8);
            } else if (na == 3 && this.atomArray[atom].getCharge() == 1) {
                this.sigmaAtomType[atom] = 8;
            }
        } else if (symb.equals("F")) {
            this.sigmaAtomType[atom] = 9;
        } else if (symb.equals("Cl")) {
            this.sigmaAtomType[atom] = 10;
        } else if (symb.equals("Br")) {
            this.sigmaAtomType[atom] = 11;
        } else if (symb.equals("I")) {
            this.sigmaAtomType[atom] = 12;
        } else if (symb.equals("Si")) {
            if (na == 4) {
                this.sigmaAtomType[atom] = 17;
            } else if (na == 3) {
                this.sigmaAtomType[atom] = 18;
            } else if (na == 2) {
                this.sigmaAtomType[atom] = 19;
            }
        } else if (symb.equals("B")) {
            this.sigmaAtomType[atom] = na == 1 ? 23 : (na == 2 ? (!this.isArA(atom) ? 22 : 24) : (na == 3 ? 21 : 20));
        } else if (symb.equals("P")) {
            if (na == 1) {
                this.sigmaAtomType[atom] = 25;
            } else if (na == 2) {
                this.sigmaAtomType[atom] = 26;
            } else if (na == 3) {
                if (!this.isArA(atom)) {
                    this.sigmaAtomType[atom] = 28;
                }
            } else {
                this.sigmaAtomType[atom] = 27;
            }
        } else if (symb.equals("Mg")) {
            this.sigmaAtomType[atom] = na == 1 ? 30 : (na == 2 ? 29 : 31);
        } else if (symb.equals("Al")) {
            this.sigmaAtomType[atom] = na == 2 ? 32 : 33;
        } else if (symb.equals("Be")) {
            if (na == 1) {
                this.sigmaAtomType[atom] = 34;
            } else if (na == 2) {
                this.sigmaAtomType[atom] = 35;
            }
        } else if (symb.equals("S") || symb.equals("Se")) {
            if (na == 3) {
                this.sigmaAtomType[atom] = 37;
            } else if (na == 1 || na == 4) {
                this.sigmaAtomType[atom] = 36;
            } else if (na == 2) {
                this.sigmaAtomType[atom] = this.isArA(atom) ? 36 : 13;
            }
        } else if (symb.equals("As")) {
            if (na == 1) {
                this.sigmaAtomType[atom] = 38;
            } else if (na == 2) {
                this.sigmaAtomType[atom] = 39;
            } else if (na == 3) {
                if (!this.isArA(atom)) {
                    this.sigmaAtomType[atom] = 41;
                }
            } else {
                this.sigmaAtomType[atom] = 40;
            }
        } else {
            this.sigmaAtomType[atom] = symb.equals("Se") ? 42 : (symb.equals("Hg") ? 43 : (symb.equals("Na") ? 44 : (symb.equals("Co") ? 45 : (symb.equals("Ca") ? 46 : (symb.equals("Bi") ? 47 : (symb.equals("Cd") ? 48 : (symb.equals("Fe") ? 49 : (symb.equals("Ag") ? 50 : (symb.equals("Pb") ? 51 : (symb.equals("K") ? 52 : (symb.equals("Ba") ? 53 : (symb.equals("Sr") ? 54 : (symb.equals("Zn") ? 55 : (symb.equals("Ni") ? 56 : (symb.equals("Tl") ? 57 : (symb.equals("Sb") ? 58 : (symb.equals("Cu") ? 59 : (symb.equals("Mn") ? 60 : (symb.equals("Au") ? 61 : (symb.equals("Cr") ? 62 : (symb.equals("Pt") ? 63 : 64)))))))))))))))))))));
        }
    }

    protected void setCarboxylGroup() {
        this.pg = new PolarGroups(this.mol);
        this.pg.setGroups();
    }

    private boolean isSingleBondedAraAtom(int i) {
        int pc = this.atomArray[i].getAtno();
        int chg = this.atomArray[i].getCharge();
        int L = this.cHtab[i].length;
        if (pc == 6 || pc == 14) {
            if (chg == -1) {
                if (L == 3) {
                    if (this.getAraNbCount(i) == 3) {
                        return true;
                    }
                    return true;
                }
            } else if (chg == 1) {
                if (L == 3) {
                    if (this.getAraNbCount(i) == 3) {
                        return true;
                    }
                    return true;
                }
            } else if (chg == 0 && L == 3 && this.isArAOxideLike(i)) {
                int ac = this.getAraNbCount(i);
                if (ac == 2) {
                    return true;
                }
                return true;
            }
        } else if (pc == 16) {
            if (chg == 0 && L == 2) {
                int ac = this.getAraNbCount(i);
                if (ac == 2) {
                    return true;
                }
                return true;
            }
        } else if (pc == 8) {
            if (chg == 0 && L == 2) {
                int ac = this.getAraNbCount(i);
                if (ac == 2) {
                    return true;
                }
                return true;
            }
        } else if (pc == 7) {
            if (chg == 0) {
                if (L == 3) {
                    if (this.getAraNbCount(i) == 3) {
                        return true;
                    }
                    if (!this.isArAOxideLike(i)) {
                        return true;
                    }
                } else if (L == 2) {
                    if (this.isRadical(i)) {
                        return true;
                    }
                } else if (L == 4) {
                    int ac = this.getAraNbCount(i);
                    if (ac == 3) {
                        return true;
                    }
                    if (ac == 2 && this.isImpHGiven(i)) {
                        return true;
                    }
                }
            } else if (chg == -1 ? L == 2 && !this.isRadical(i) : chg == 1 && this.isArAOxideLike(i)) {
                return true;
            }
        } else if (pc == 34 || pc == 52) {
            if (chg == 0) {
                if (L == 2) {
                    int ac = this.getAraNbCount(i);
                    if (ac == 2) {
                        return true;
                    }
                    return true;
                }
                if (L == 4) {
                    int ac = this.getAraNbCount(i);
                    if (ac == 3) {
                        return true;
                    }
                    if (ac == 4) {
                        return true;
                    }
                }
            }
        } else if (pc == 5) {
            if (chg == 0 && L == 3) {
                if (this.getAraNbCount(i) == 3) {
                    return true;
                }
                return true;
            }
        } else if (pc == 33) {
            if (chg == 0 && L == 4) {
                if (this.getAraNbCount(i) == 3) {
                    return true;
                }
                return true;
            }
        } else if (pc == 15 && L == 5) {
            return true;
        }
        return false;
    }

    private int getAraNbCount(int ai) {
        int c = 0;
        for (int i = 0; i < this.cHtab[ai].length; ++i) {
            int bt;
            int nb = this.cHtab[ai][i];
            if (!this.isArA(nb) || (bt = this.mol.getBond(this.bHtab[ai][nb]).getType()) != 4) continue;
            ++c;
        }
        return c;
    }

    private boolean isArAOxideLike(int ai) {
        for (int i = 0; i < this.cHtab[ai].length; ++i) {
            int b;
            int nb = this.cHtab[ai][i];
            if (nb >= this.MOLATOMS || this.isAromaticBond(nb, ai) || (b = this.mol.getBond(this.bHtab[ai][nb]).getType()) != 2) continue;
            return true;
        }
        return false;
    }

    private boolean isRadical(int ai) {
        return this.atomArray[ai].getRadical() != 0;
    }

    private boolean isImpHGiven(int ai) {
        for (int i = 0; i < this.cHtab[ai].length; ++i) {
            if (this.cHtab[ai][i] < this.MOLATOMS) continue;
            return true;
        }
        return false;
    }

    private boolean isAromaticBond(int a1, int a2) {
        try {
            if (this.mol.getBond(this.bHtab[a1][a2]).getType() == 4) {
                return true;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        return false;
    }

    protected int getCarboxy(int atomIndex) {
        if (this.pg.carboxy == null || atomIndex < 0 || atomIndex > this.pg.carboxy.length) {
            return -1;
        }
        return this.pg.carboxy[atomIndex];
    }

    protected boolean isDelocable(int atomIndex) {
        if (this.delocAble == null || atomIndex < 0 || atomIndex > this.delocAble.length) {
            return false;
        }
        return this.delocAble[atomIndex] > 0;
    }

    protected int getHConj(int atomIndex) {
        if (this.hconj == null || atomIndex < 0 || atomIndex > this.hconj.length) {
            return -1;
        }
        return this.hconj[atomIndex];
    }

    protected int getAtno(int index) {
        if (index < 0 || index >= this.atomArray.length) {
            return 1;
        }
        return this.atomArray[index].getAtno();
    }

    public PolarGroups getPolarGroups() {
        if (this.pg == null) {
            this.setCarboxylGroup();
        }
        return this.pg;
    }

    public void setAromatizationType(int aromType) {
        this.aromatizationType = aromType;
        this.rings = null;
    }

    public int getLargestRingIndex(int atomIndex) {
        return this.getRings().getLargestRingIndex(atomIndex);
    }

    public boolean[] isInRing() {
        return this.rings.isInRing();
    }

    public int[] getSigmaAtomType() {
        return this.sigmaAtomType;
    }

    public int[] getSemiAromaticAtomIndexes() {
        return this.sAra;
    }
}

