/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.calculations;

import chemaxon.struc.MolAtom;
import chemaxon.struc.Molecule;

public class CriticalErrorCalculation {
    private CriticalErrorCalculation() {
    }

    public static boolean calculate(Molecule mol) {
        boolean criticalError = false;
        int n = mol.getAtomCount();
        for (int i = 0; i < n; ++i) {
            int chg;
            MolAtom a = mol.getAtom(i);
            int pc = a.getAtno();
            if (a.hasValenceError()) {
                int vc = a.getValence();
                if (pc == 1) {
                    criticalError = true;
                    continue;
                }
                if (pc <= 10 && vc > 4) {
                    if (CriticalErrorCalculation.isRNO(a)) continue;
                    criticalError = true;
                    continue;
                }
                if (pc > 10 && vc > 8) {
                    criticalError = true;
                    continue;
                }
                if (CriticalErrorCalculation.isMetal(pc, a)) continue;
                criticalError = true;
                continue;
            }
            if (pc != 7 || (chg = a.getCharge()) >= 0) continue;
            int absChg = -1 * chg;
            int implicitHCount = a.getImplicitHcount();
            int v = a.getBondCount() + (implicitHCount + absChg);
            if (v <= 3) continue;
            criticalError = true;
        }
        return criticalError;
    }

    protected static boolean isMetal(int pc, MolAtom a) {
        int bc = a.getBondCount();
        if (bc > 6) {
            return false;
        }
        if (pc >= 5 && pc <= 9) {
            return false;
        }
        if (pc >= 14 && pc <= 17) {
            return false;
        }
        if (pc >= 33 && pc <= 35) {
            return false;
        }
        if (pc >= 52 && pc <= 53) {
            return false;
        }
        return pc < 84 || pc > 85;
    }

    private static boolean isRNO(MolAtom a) {
        if (a.getAtno() == 7) {
            int bc = a.getBondCount();
            for (int i = 0; i < bc; ++i) {
                if (a.getBond(i).getType() != 2) continue;
                return true;
            }
        }
        return false;
    }

    protected static boolean hasHValenceError(Molecule molecule) {
        for (int i = 0; i < molecule.getAtomCount(); ++i) {
            MolAtom atom = molecule.getAtom(i);
            if (atom.getAtno() != 1 || atom.getBondCount() <= 1) continue;
            return true;
        }
        return false;
    }
}

