/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.calculations;

import chemaxon.marvin.modelling.linalg.GradientOptimization;
import chemaxon.struc.Molecule;

abstract class FunctionArea
implements GradientOptimization.FunctionToMinimize {
    double sign = 1.0;
    double[] variables = new double[3];
    double[] gradient = new double[3];

    FunctionArea() {
    }

    static double scale(double fi, double fi0) {
        if (fi < 0.0) {
            return 1.0;
        }
        double scale = 0.0;
        double a = 16.0 / (3.0 * fi0 * fi0 * fi0) * fi * fi * fi;
        if (fi >= 0.0 && fi < fi0 / 4.0) {
            scale = 1.0 - a;
        } else if (fi >= fi0 / 4.0 && fi < 0.75 * fi0) {
            scale = a - 8.0 / (fi0 * fi0) * fi * fi + 2.0 / fi0 * fi + 0.8333333333333334;
        } else if (fi >= 0.75 * fi0 && fi < fi0) {
            scale = -a + 16.0 / (fi0 * fi0) * fi * fi - 16.0 / fi0 * fi + 5.333333333333333;
        }
        if (scale < 0.0) {
            if (scale < -1.0E-12) {
                System.err.println("[INFO] scale < 0 scale=");
            }
            scale = 0.0;
        }
        return scale;
    }

    public abstract Molecule outputAsMol();

    static double scaleGrad(double fi, double fi0) {
        double diff = 0.0;
        double a = 16.0 / (fi0 * fi0 * fi0) * fi * fi;
        if (fi < 0.0) {
            diff = 0.0;
        } else if (fi >= 0.0 && fi < fi0 / 4.0) {
            diff = -a;
        } else if (fi >= fi0 / 4.0 && fi < 0.75 * fi0) {
            diff = a - a * fi0 / fi + 2.0 / fi0;
        } else if (fi >= 0.75 * fi0 && fi < fi0) {
            diff = -a + 2.0 * a * fi0 / fi - 16.0 / fi0;
        }
        if (diff > 0.0) {
            diff = 0.0;
        }
        return diff;
    }

    @Override
    public boolean isCancelled() {
        return false;
    }

    @Override
    public double[] getVariables() {
        return this.variables;
    }

    @Override
    public void print() {
    }

    @Override
    public void print(String string) {
    }

    public double[] getNumericDerivate(double[] ret) {
        double small = 1.0E-5;
        for (int i = 0; i < ret.length; ++i) {
            double c = this.variables[i];
            int n = i;
            this.variables[n] = this.variables[n] + small;
            this.setVariables(this.variables);
            double e1 = this.getFunctionValue();
            this.variables[i] = c - small;
            this.setVariables(this.variables);
            double e2 = this.getFunctionValue();
            ret[i] = (e1 - e2) / (2.0 * small);
            this.variables[i] = c;
            this.setVariables(this.variables);
        }
        return ret;
    }

    void setMax(boolean b) {
        this.sign = b ? -1.0 : 1.0;
    }

    public double getSign() {
        return this.sign;
    }
}

