/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.calculations;

import chemaxon.calculations.clean.Clean3D;
import chemaxon.core.calculations.LonePairCounter;
import chemaxon.core.spi.HydrogenizeIface;
import chemaxon.marvin.util.MarvinModule;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;

public class HBondViewer {
    int[] LPCount;
    int[][] cHtab;
    int[][] bHtab;
    int[] dist;
    int[] sphere;
    int sphereSize;
    int[] pCount;
    int atomCount;
    Molecule molCopy;
    Molecule[] conformers;
    int[][] HBondCouples;
    double[][] HBondParameters;
    String[] aSymbol;
    boolean criticalError;
    boolean[] isArom;
    double[][] xyz;
    final int UNKNOWN = -1;
    int[] don;
    int[] acc;
    int accCount;
    int donCount;
    int hBondCount;
    int conformerCount = 0;
    int actH;
    final double DA = 3.9;
    final double HA = 2.6;
    final double DHA = 90.0;
    final double HA_AA = 90.0;
    final double DH_AA = 90.0;
    double DAdist;
    double HAdist;
    double DHAangle;
    double H_A_AA;
    double D_H_AA;
    int[] ConformerIndex;
    int[] ADCoupleIndex;
    int[][] ADCouples;
    int[] AD;
    int confCount;
    boolean takeConformers = true;
    int initHBCount;

    public void setMolecule(Molecule mol) {
        this.molCopy = mol.cloneMoleculeWithDocument();
        this.setCriticalErrorFlag();
    }

    public boolean getCriticalErrorFlag() {
        return this.criticalError;
    }

    public void setTakeConformers(boolean takeConf) {
        this.takeConformers = takeConf;
    }

    public Molecule getConformer(int cIndex) {
        return this.conformers[this.ConformerIndex[cIndex]];
    }

    public int getConformerCount() {
        return this.confCount;
    }

    public Molecule getMaxHBondedConformer() {
        return this.getConformer(this.getMaxHBCIndex());
    }

    public int getHBondCountOfConformer(int cIndex) {
        return this.ADCouples[this.ADCoupleIndex[cIndex]].length / 2;
    }

    public int[] getADCoupleOfConformer(int confIndex, int bondIndex) {
        this.AD[0] = this.ADCouples[this.ADCoupleIndex[confIndex]][2 * bondIndex];
        this.AD[1] = this.ADCouples[this.ADCoupleIndex[confIndex]][2 * bondIndex + 1];
        return this.AD;
    }

    private int getMaxHBCIndex() {
        int maxHBC = -1;
        int maxIndex = 0;
        for (int i = 0; i < this.confCount; ++i) {
            int m = this.getHBondCountOfConformer(i);
            if (m <= maxHBC) continue;
            maxHBC = m;
            maxIndex = i;
        }
        return maxIndex;
    }

    public void calcDACouples() {
        if (this.criticalError) {
            return;
        }
        this.initHBondSketcher();
        this.setAcceptors();
        this.setDonors();
        this.initHBCount = 3 * this.conformerCount;
        this.HBondCouples = new int[this.initHBCount][5];
        this.HBondParameters = new double[this.initHBCount][5];
        this.AD = new int[2];
        this.hBondCount = 0;
        for (int k = 0; k < this.conformerCount; ++k) {
            this.setConformerCoordinates(k);
            for (int i = 0; i < this.atomCount; ++i) {
                if (this.acc[i] == 0) continue;
                for (int j = 0; j < this.atomCount; ++j) {
                    if (this.don[j] == 0 || i == j || !this.isHBondCondOK(i, j, k)) continue;
                    this.storeHBond(i, j, k);
                }
            }
        }
        this.setBestHBondCouples();
    }

    private void storeHBond(int acc, int don, int k) {
        if (this.isADHBondedYet(acc, don, k)) {
            return;
        }
        if (this.isFiveMemRing(acc, this.actH)) {
            return;
        }
        if (this.hBondCount >= this.initHBCount) {
            int j;
            int i;
            int[][] hbc = new int[this.initHBCount][5];
            double[][] hbp = new double[this.initHBCount][5];
            for (i = 0; i < this.initHBCount; ++i) {
                for (j = 0; j < 5; ++j) {
                    hbc[i][j] = this.HBondCouples[i][j];
                }
                for (j = 0; j < 5; ++j) {
                    hbp[i][j] = this.HBondParameters[i][j];
                }
            }
            this.initHBCount += 6;
            this.HBondCouples = new int[this.initHBCount][5];
            this.HBondParameters = new double[this.initHBCount][5];
            for (i = 0; i < this.initHBCount - 6; ++i) {
                for (j = 0; j < 5; ++j) {
                    this.HBondCouples[i][j] = hbc[i][j];
                }
                for (j = 0; j < 5; ++j) {
                    this.HBondParameters[i][j] = hbp[i][j];
                }
            }
        }
        this.HBondCouples[this.hBondCount][0] = acc;
        this.HBondCouples[this.hBondCount][1] = don;
        this.HBondCouples[this.hBondCount][2] = k;
        this.HBondCouples[this.hBondCount][4] = this.actH;
        this.HBondParameters[this.hBondCount][0] = this.DAdist;
        this.HBondParameters[this.hBondCount][1] = this.HAdist;
        this.HBondParameters[this.hBondCount][2] = this.DHAangle;
        this.HBondParameters[this.hBondCount][3] = this.H_A_AA;
        this.HBondParameters[this.hBondCount][4] = this.D_H_AA;
        ++this.hBondCount;
    }

    private boolean isADHBondedYet(int acc, int don, int k) {
        for (int i = 0; i < this.hBondCount; ++i) {
            if (this.HBondCouples[i][1] != acc || this.HBondCouples[i][0] != don || this.HBondCouples[i][2] != k) continue;
            return true;
        }
        return false;
    }

    private boolean isFiveMemRing(int acc, int don) {
        this.getAtomDistances(acc, 6);
        boolean find = false;
        for (int j = 0; j < this.sphereSize && !find; ++j) {
            int a = this.sphere[j];
            if (a != don) continue;
            int d = this.dist[a];
            find = true;
            if (d >= 5) continue;
            return true;
        }
        return false;
    }

    private void setBestHBondCouples() {
        int i;
        int cIndex;
        int multi;
        int[] used = new int[this.conformerCount];
        int coupleCount = 0;
        for (int i2 = 0; i2 < this.hBondCount; ++i2) {
            multi = 0;
            cIndex = this.HBondCouples[i2][2];
            if (used[cIndex] == 1) continue;
            for (int j = 0; j < this.hBondCount; ++j) {
                if (this.HBondCouples[j][2] != cIndex) continue;
                ++multi;
            }
            used[cIndex] = 1;
            this.HBondCouples[i2][3] = multi;
            ++coupleCount;
        }
        this.ADCouples = new int[coupleCount][];
        int[] confIndex = new int[coupleCount];
        int[][] hbIndex = new int[coupleCount][];
        int k = 0;
        for (int i3 = 0; i3 < this.hBondCount; ++i3) {
            multi = this.HBondCouples[i3][3];
            if (multi == 0) continue;
            this.ADCouples[k] = new int[2 * multi];
            hbIndex[k] = new int[multi];
            confIndex[k] = cIndex = this.HBondCouples[i3][2];
            int z = 0;
            int t = 0;
            for (int j = 0; j < this.hBondCount; ++j) {
                if (this.HBondCouples[j][2] != cIndex) continue;
                hbIndex[k][t] = j;
                this.ADCouples[k][z] = this.HBondCouples[j][0];
                this.ADCouples[k][z + 1] = this.HBondCouples[j][4];
                z += 2;
                ++t;
            }
            ++k;
        }
        for (i = 0; i < coupleCount; ++i) {
            int L = this.ADCouples[i].length;
            for (int j = i + 1; j < coupleCount; ++j) {
                int w = 0;
                if (this.ADCouples[j].length == L) {
                    for (int y = 0; y < L; ++y) {
                        if (this.ADCouples[j][y] != this.ADCouples[i][y]) continue;
                        ++w;
                    }
                }
                if (w != L) continue;
                int g = L / 2;
                double sum1 = 0.0;
                double sum2 = 0.0;
                int ind = 0;
                for (int q = 0; q < g; ++q) {
                    int hbi = hbIndex[i][q];
                    sum1 += this.HBondParameters[hbi][2];
                    hbi = hbIndex[j][q];
                    sum2 += this.HBondParameters[hbi][2];
                }
                ind = sum2 > sum1 ? j : i;
                for (int y = 0; y < this.ADCouples[ind].length; ++y) {
                    this.ADCouples[ind][y] = -1;
                }
            }
        }
        this.confCount = 0;
        for (i = 0; i < coupleCount; ++i) {
            if (this.ADCouples[i][0] == -1) continue;
            ++this.confCount;
        }
        this.ConformerIndex = new int[this.confCount];
        this.ADCoupleIndex = new int[this.confCount];
        k = 0;
        for (i = 0; i < coupleCount; ++i) {
            if (this.ADCouples[i][0] == -1) continue;
            this.ConformerIndex[k] = confIndex[i];
            this.ADCoupleIndex[k] = i;
            ++k;
        }
    }

    private boolean isHBondCondOK(int acc, int don, int k) {
        this.DAdist = -1.0;
        this.HAdist = -1.0;
        this.DHAangle = -1.0;
        this.H_A_AA = -1.0;
        this.D_H_AA = -1.0;
        this.DAdist = this.getDAdistance(acc, don);
        if (this.DAdist != -1.0) {
            this.HAdist = this.getHAdistance(acc, don);
            if (this.HAdist != -1.0 && this.DAdist > this.HAdist) {
                this.DHAangle = this.getDHAangle(don, acc, this.actH);
                if (this.DHAangle < 0.0) {
                    return true;
                }
            }
        }
        return false;
    }

    private double getDAdistance(int acc, int don) {
        double d1 = this.xyz[acc][0] - this.xyz[don][0];
        double absD1 = Math.abs(d1);
        double d2 = this.xyz[acc][1] - this.xyz[don][1];
        double absD2 = Math.abs(d2);
        double d3 = this.xyz[acc][2] - this.xyz[don][2];
        double absD3 = Math.abs(d3);
        if (absD1 <= 10.0 && absD2 <= 10.0 && absD3 <= 10.0) {
            double sum = d1 * d1 + d2 * d2 + d3 * d3;
            if ((sum = Math.sqrt(sum)) <= 3.9) {
                return sum;
            }
        }
        return -1.0;
    }

    private double getHAdistance(int acc, int don) {
        for (int i = 0; i < this.cHtab[don].length; ++i) {
            int nb = this.cHtab[don][i];
            if (nb >= this.atomCount || !this.getSymbol(nb).equals("H")) continue;
            double d1 = this.xyz[acc][0] - this.xyz[nb][0];
            double absD1 = Math.abs(d1);
            double d2 = this.xyz[acc][1] - this.xyz[nb][1];
            double absD2 = Math.abs(d2);
            double d3 = this.xyz[acc][2] - this.xyz[nb][2];
            double absD3 = Math.abs(d3);
            if (!(absD1 <= 10.0) || !(absD2 <= 10.0) || !(absD3 <= 10.0)) continue;
            double sum = d1 * d1 + d2 * d2 + d3 * d3;
            if (!((sum = Math.sqrt(sum)) <= 2.6)) continue;
            this.actH = nb;
            return sum;
        }
        return -1.0;
    }

    private double getDHAangle(int don, int acc, int h) {
        double[] a = new double[3];
        double[] b = new double[3];
        double cos = 0.0;
        a[0] = this.xyz[h][0] - this.xyz[don][0];
        a[1] = this.xyz[h][1] - this.xyz[don][1];
        a[2] = this.xyz[h][2] - this.xyz[don][2];
        b[0] = this.xyz[h][0] - this.xyz[acc][0];
        b[1] = this.xyz[h][1] - this.xyz[acc][1];
        b[2] = this.xyz[h][2] - this.xyz[acc][2];
        double absA = a[0] * a[0] + a[1] * a[1] + a[2] * a[2];
        absA = Math.sqrt(absA);
        double absB = b[0] * b[0] + b[1] * b[1] + b[2] * b[2];
        absB = Math.sqrt(absB);
        double AB = a[0] * b[0] + a[1] * b[1] + a[2] * b[2];
        cos = AB / (absA * absB);
        return cos;
    }

    private void initHBondSketcher() {
        this.molCopy.dearomatize();
        this.molCopy.aromatize(2);
        this.hydrogenize();
        this.atomCount = this.molCopy.getAtomCount();
        this.cHtab = this.molCopy.createCHtab();
        this.bHtab = this.molCopy.createBHtab();
        this.pCount = new int[this.atomCount];
        this.aSymbol = new String[this.atomCount];
        this.isArom = new boolean[this.atomCount];
        for (int i = 0; i < this.atomCount; ++i) {
            MolAtom a = this.molCopy.getAtom(i);
            this.pCount[i] = a.getAtno();
            this.aSymbol[i] = a.getSymbol();
            this.isArom[i] = a.hasAromaticBond();
        }
        this.calcLP();
        this.calc3DConformers();
        this.xyz = new double[this.atomCount][3];
    }

    private void hydrogenize() {
        HydrogenizeIface hydrogenize = (HydrogenizeIface)MarvinModule.load("chemaxon.calculations.hydrogenize.HydrogenizeUtil", null);
        hydrogenize.addHAtoms(this.molCopy, null);
    }

    private void calcLP() {
        this.LPCount = new int[this.atomCount];
        LonePairCounter LPc = (LonePairCounter)MarvinModule.load("LonePairCounter", null);
        this.LPCount = LPc.getLonePairCount(this.molCopy);
    }

    private void setAcceptors() {
        this.acc = new int[this.atomCount];
        this.accCount = 0;
        for (int i = 0; i < this.atomCount; ++i) {
            if (this.LPCount[i] == 0) continue;
            this.acc[i] = this.LPCount[i];
            ++this.accCount;
        }
    }

    private void setDonors() {
        this.don = new int[this.atomCount];
        for (int i = 0; i < this.atomCount; ++i) {
            int en;
            MolAtom a = this.molCopy.getAtom(i);
            int impHc = a.getImplicitHcount();
            if (impHc == 0 && !this.isExplicitHAdded(i) || (en = MolAtom.electronegOf(this.pCount[i])) <= 25) continue;
            int n = i;
            this.don[n] = this.don[n] + 1;
            ++this.donCount;
        }
    }

    private boolean isExplicitHAdded(int ai) {
        for (int i = 0; i < this.cHtab[ai].length; ++i) {
            int nb = this.cHtab[ai][i];
            if (nb >= this.atomCount || !this.getSymbol(nb).equals("H")) continue;
            return true;
        }
        return false;
    }

    public String getSymbol(int i) {
        if (i >= this.atomCount) {
            return "H";
        }
        return this.aSymbol[i];
    }

    protected boolean isArA(int atom) {
        if (atom >= this.atomCount) {
            return false;
        }
        return this.isArom[atom];
    }

    protected void setCriticalErrorFlag() {
        this.criticalError = false;
        int n = this.molCopy.getAtomCount();
        for (int i = 0; i < n; ++i) {
            MolAtom a = this.molCopy.getAtom(i);
            if (!a.hasValenceError()) continue;
            int vc = a.getValence();
            int pc = a.getAtno();
            if (pc == 1 && vc > 1) {
                this.criticalError = true;
                return;
            }
            if (pc <= 10 && vc > 4) {
                if (this.isRNO(a)) continue;
                this.criticalError = true;
                return;
            }
            if (pc <= 10 || vc <= 8) continue;
            this.criticalError = true;
            return;
        }
    }

    private boolean isRNO(MolAtom a) {
        if (a.getSymbol().equals("N")) {
            int bc = a.getBondCount();
            for (int i = 0; i < bc; ++i) {
                MolBond b = a.getBond(i);
                if (b.getType() != 2) continue;
                return true;
            }
        }
        return false;
    }

    private void getAtomDistances(int atom, int MAXSPHERE) {
        int actAtom = atom;
        this.sphereSize = 0;
        this.dist = new int[this.atomCount];
        this.sphere = new int[this.atomCount];
        for (int i = 0; i < this.atomCount; ++i) {
            this.sphere[i] = -1;
        }
        int distance = 1;
        boolean sChange = true;
        int i = 0;
        while (distance < MAXSPHERE + 1 & sChange) {
            sChange = false;
            if (actAtom != -1) {
                int length = this.cHtab[actAtom].length;
                for (int j = 0; j < length; ++j) {
                    int sphereAtom = this.cHtab[actAtom][j];
                    if (sphereAtom >= this.atomCount || !(this.dist[sphereAtom] == 0 & sphereAtom != atom)) continue;
                    this.dist[sphereAtom] = distance;
                    this.sphere[this.sphereSize] = sphereAtom;
                    ++this.sphereSize;
                }
            }
            if (this.sphere[i] != -1) {
                actAtom = this.sphere[i];
                distance = this.dist[actAtom] + 1;
                sChange = true;
            } else {
                sChange = false;
            }
            ++i;
        }
    }

    private void setConformerCoordinates(int ci) {
        Molecule m = this.conformers[ci];
        for (int i = 0; i < this.atomCount; ++i) {
            MolAtom a = m.getAtom(i);
            this.xyz[i][0] = a.getX();
            this.xyz[i][1] = a.getY();
            this.xyz[i][2] = a.getZ();
        }
    }

    private void calc3DConformers() {
        if (this.takeConformers) {
            this.calcConformers(this.molCopy);
            if (this.conformers == null) {
                Clean3D clean3D = new Clean3D();
                clean3D.optimization3D(this.molCopy, "S4", null);
                this.calcConformers(this.molCopy);
            }
        } else if (this.molCopy.getDim() == 3) {
            this.conformers = new Molecule[1];
            this.conformers[0] = this.molCopy;
        }
        if (this.conformers != null) {
            this.conformerCount = this.conformers.length;
        }
    }

    private void calcConformers(Molecule m) {
        Clean3D conformers3D = new Clean3D();
        this.conformers = conformers3D.calcConformers(m);
    }
}

