/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.calculations;

import chemaxon.calculations.Charge;
import chemaxon.calculations.CriticalErrorCalculation;
import chemaxon.calculations.hydrogenize.Hydrogenize;
import chemaxon.calculations.pka.Ionizer;
import chemaxon.struc.MolAtom;
import chemaxon.struc.Molecule;

public class Interaction {
    private Molecule mol;
    private Ionizer ionizer;
    private int MOLATOMS;
    private int[][] cHtab;
    private int[][] bHtab;
    private double[] atomDC = null;
    private double[] atomAC = null;
    private int[] asc = null;
    private int[] dsc = null;
    private MolAtom[] atomArray;
    private MolAtom[] oAtoms;
    private int[] fGroups = null;
    private int[] atomIndexMap;
    private double DonorSiteCount = 0.0;
    private double AcceptorSiteCount = 0.0;
    private Molecule oMol;
    private int aromType = -1;
    private double aSiteHolderNumber = 0.0;
    private double dSiteHolderNumber = 0.0;
    private boolean hValenceError;
    private boolean ResonanceFlag;
    private boolean metalComplex;
    private boolean criticalError;
    private boolean excludeSulfur = true;
    private boolean excludeHalogens = true;

    public void setMolecule(Molecule m) {
        this.mol = m.cloneMoleculeWithDocument();
        this.hValenceError = false;
    }

    public boolean getCriticalErrorFlag() {
        return this.criticalError;
    }

    public Molecule getMolecule() {
        return this.mol;
    }

    protected void setAromatizationType(int aromType) {
        this.aromType = aromType;
    }

    private void implicitize(Molecule m) {
        Hydrogenize.removeHAtoms(m, 2047);
    }

    public void setExcludeSulfur(boolean f) {
        this.excludeSulfur = f;
    }

    public void setExcludeHalogens(boolean f) {
        this.excludeHalogens = f;
    }

    private void calcMacropKa(Molecule input) {
        Molecule temp = input.cloneMoleculeWithDocument();
        this.ionizer = new Ionizer();
        this.ionizer.setpKaPrefixType(1);
        this.ionizer.setMolecule(temp);
        this.ionizer.setMspHCalc(true);
        this.ionizer.setAromatizationType(this.aromType);
        this.ionizer.calculatepKa(0.0);
        if (this.ionizer.getHValenceError()) {
            this.hValenceError = true;
        }
        if (this.ionizer.getCriticalErrorFlag()) {
            return;
        }
        this.fGroups = this.ionizer.getSpecialGroups();
    }

    public void calcAcceptorDonorCount() {
        this.initHBond();
        this.initGroups();
        if (this.criticalError) {
            this.mol = this.oMol;
            this.asc = new int[this.oAtoms.length];
            this.dsc = new int[this.oAtoms.length];
            return;
        }
        if (CriticalErrorCalculation.hasHValenceError(this.mol)) {
            this.hValenceError = true;
        }
        this.calcDonorSiteCountOfMicrospecies();
        this.calcAcceptorSiteCountOfMicrospecies();
        this.setAcceptorDonorSiteCount(this.atomAC, this.atomDC);
        this.mol = this.oMol;
        int a = this.mol.getAtomCount();
        this.asc = new int[a];
        this.dsc = new int[a];
        for (int i = 0; i < a; ++i) {
            this.asc[i] = (int)this.atomAC[i];
            this.dsc[i] = (int)this.atomDC[i];
        }
    }

    private void initGroups() {
        Charge charge = new Charge();
        charge.setMolecule(this.mol);
        charge.setAromatizationType(this.aromType);
        charge.initChargeCalc();
        this.criticalError = CriticalErrorCalculation.calculate(this.mol);
        this.fGroups = charge.getPolarGroups().getCarboxy();
    }

    public void calcAcceptorDonorCount(double pH) {
        double bruttoDonorSiteCount = 0.0;
        double bruttoAcceptorSiteCount = 0.0;
        this.aSiteHolderNumber = 0.0;
        this.dSiteHolderNumber = 0.0;
        this.criticalError = false;
        if (this.oMol != this.mol) {
            this.initHBond();
            this.calcMacropKa(this.mol);
            if (this.ionizer.getCriticalErrorFlag()) {
                this.setAcceptorDonorSiteCount();
                this.criticalError = true;
                this.mol = this.oMol;
                return;
            }
        }
        if (this.ionizer.getCriticalErrorFlag()) {
            this.setAcceptorDonorSiteCount();
            this.criticalError = true;
            this.mol = this.oMol;
            return;
        }
        int ionCount = this.ionizer.getIonizableAtomCount();
        if (ionCount != 0) {
            double[] pHDist = this.ionizer.getMspH(pH);
            double[] ac = new double[this.mol.getAtomCount()];
            double[] dc = new double[this.mol.getAtomCount()];
            for (int msIndex = 0; msIndex < this.ionizer.microSpecCount; ++msIndex) {
                Molecule microSpecies;
                this.mol = microSpecies = this.ionizer.getMspHMolecule(msIndex);
                this.cHtab = this.mol.createCHtab();
                this.bHtab = this.mol.createBHtab();
                this.atomArray = this.mol.getAtomArray();
                this.calcDonorSiteCountOfMicrospecies();
                this.calcAcceptorSiteCountOfMicrospecies();
                bruttoDonorSiteCount += this.DonorSiteCount * pHDist[msIndex];
                bruttoAcceptorSiteCount += this.AcceptorSiteCount * pHDist[msIndex];
                for (int i = 0; i < this.MOLATOMS; ++i) {
                    int n = i;
                    ac[n] = ac[n] + 0.01 * this.atomAC[i] * pHDist[msIndex];
                    int n2 = i;
                    dc[n2] = dc[n2] + 0.01 * this.atomDC[i] * pHDist[msIndex];
                    if (this.atomAC[i] != 0.0) {
                        this.aSiteHolderNumber += 0.01 * pHDist[msIndex];
                    }
                    if (this.atomDC[i] == 0.0) continue;
                    this.dSiteHolderNumber += 0.01 * pHDist[msIndex];
                }
            }
            bruttoDonorSiteCount = 0.01 * bruttoDonorSiteCount;
            bruttoAcceptorSiteCount = 0.01 * bruttoAcceptorSiteCount;
            this.setAcceptorDonorSiteCount(ac, dc);
        } else if (ionCount == 0) {
            this.mol = this.oMol;
            this.calcDonorSiteCountOfMicrospecies();
            this.calcAcceptorSiteCountOfMicrospecies();
            this.setAcceptorDonorSiteCount();
            bruttoDonorSiteCount = this.DonorSiteCount;
            bruttoAcceptorSiteCount = this.AcceptorSiteCount;
            for (int i = 0; i < this.MOLATOMS; ++i) {
                if (this.atomAC[i] != 0.0) {
                    this.aSiteHolderNumber += 1.0;
                }
                if (this.atomDC[i] == 0.0) continue;
                this.dSiteHolderNumber += 1.0;
            }
        }
        this.mol = this.oMol;
        this.DonorSiteCount = bruttoDonorSiteCount;
        this.AcceptorSiteCount = bruttoAcceptorSiteCount;
    }

    private void setAcceptorDonorSiteCount(double[] ac, double[] dc) {
        int newIndex = 0;
        this.atomDC = new double[this.oAtoms.length];
        this.atomAC = new double[this.oAtoms.length];
        for (int i = 0; i < this.oAtoms.length; ++i) {
            newIndex = this.atomIndexMap[i];
            if (newIndex < 0) continue;
            this.atomAC[i] = ac[newIndex];
            this.atomDC[i] = dc[newIndex];
        }
    }

    private void setAcceptorDonorSiteCount() {
        int newIndex = 0;
        double[] ac = new double[this.oAtoms.length];
        double[] dc = new double[this.oAtoms.length];
        for (int i = 0; i < this.atomAC.length; ++i) {
            ac[i] = this.atomAC[i];
            dc[i] = this.atomDC[i];
        }
        double[] atomAC = new double[this.oAtoms.length];
        double[] atomDC = new double[this.oAtoms.length];
        for (int i = 0; i < this.oAtoms.length; ++i) {
            newIndex = this.atomIndexMap[i];
            if (newIndex < 0) continue;
            atomAC[i] = ac[newIndex];
            atomDC[i] = dc[newIndex];
        }
    }

    private void initHBond() {
        this.oMol = this.mol.cloneMoleculeWithDocument();
        this.oAtoms = this.mol.getAtomArray();
        this.implicitize(this.mol);
        this.atomIndexMap = new int[this.oAtoms.length];
        for (int i = 0; i < this.oAtoms.length; ++i) {
            this.atomIndexMap[i] = this.mol.indexOf(this.oAtoms[i]);
        }
        this.MOLATOMS = this.mol.getAtomCount();
        this.cHtab = this.mol.createCHtab();
        this.bHtab = this.mol.createBHtab();
        this.atomArray = this.mol.getAtomArray();
        this.atomDC = new double[this.oAtoms.length];
        this.atomAC = new double[this.oAtoms.length];
    }

    public int[] getDonorAtomListOfMicrospecies() {
        int[] daList = null;
        if (this.atomDC != null) {
            int i;
            int a = this.mol.getAtomCount();
            int dnum = 0;
            for (i = 0; i < a; ++i) {
                if (this.atomDC[i] == 0.0) continue;
                ++dnum;
            }
            daList = new int[dnum];
            int j = 0;
            for (i = 0; i < a; ++i) {
                if (this.atomDC[i] == 0.0) continue;
                daList[j] = i;
                ++j;
            }
        }
        return daList;
    }

    public int[] getDonorSiteCountListOfMicrospecies() {
        return this.dsc;
    }

    public int[] getAcceptorAtomListOfMicrospecies() {
        int[] aaList = null;
        if (this.atomAC != null) {
            int i;
            int a = this.mol.getAtomCount();
            int anum = 0;
            for (i = 0; i < a; ++i) {
                if (this.atomAC[i] == 0.0) continue;
                ++anum;
            }
            aaList = new int[anum];
            int j = 0;
            for (i = 0; i < a; ++i) {
                if (this.atomAC[i] == 0.0) continue;
                aaList[j] = i;
                ++j;
            }
        }
        return aaList;
    }

    public int[] getAcceptorSiteCountListOfMicrospecies() {
        return this.asc;
    }

    public int getDonorAtomCountOfMicrospecies() {
        int dnum = 0;
        if (this.atomDC != null) {
            int a = this.mol.getAtomCount();
            for (int i = 0; i < a; ++i) {
                if (this.atomDC[i] == 0.0) continue;
                ++dnum;
            }
        }
        return dnum;
    }

    public int getAcceptorAtomCountOfMicrospecies() {
        int anum = 0;
        if (this.atomAC != null) {
            int a = this.mol.getAtomCount();
            for (int i = 0; i < a; ++i) {
                if (this.atomAC[i] == 0.0) continue;
                ++anum;
            }
        }
        return anum;
    }

    public int getAcceptorSiteCountOfMicrospecies() {
        return (int)this.AcceptorSiteCount;
    }

    public int getDonorSiteCountOfMicrospecies() {
        return (int)this.DonorSiteCount;
    }

    public double getAcceptorAtomNumberOfMacroState() {
        return this.aSiteHolderNumber;
    }

    public double getDonorAtomNumberOfMacroState() {
        return this.dSiteHolderNumber;
    }

    public double getAcceptorSiteCountOfMacroState() {
        return this.AcceptorSiteCount;
    }

    public double getDonorSiteCountOfMacroState() {
        return this.DonorSiteCount;
    }

    public double[] getAcceptorSiteCountListOfMacroState() {
        return this.atomAC;
    }

    public double[] getDonorSiteCountListOfMacroState() {
        return this.atomDC;
    }

    private void calcDonorSiteCountOfMicrospecies() {
        this.DonorSiteCount = 0.0;
        int d = 0;
        for (int atom = 0; atom < this.MOLATOMS; ++atom) {
            String symb = this.getSymbol(atom);
            if (!symb.equals("O") && !symb.equals("N") && !symb.equals("S")) continue;
            d = this.getHCount(atom);
            this.DonorSiteCount += (double)d;
            int n = atom;
            this.atomDC[n] = this.atomDC[n] + (double)d;
        }
    }

    private void calcAcceptorSiteCountOfMicrospecies() {
        this.AcceptorSiteCount = 0.0;
        int falseNAcceptorSiteCount = 0;
        int falseSAcceptor = 0;
        int falseOAcceptorSiteCount = 0;
        int chg = 0;
        for (int atom = 0; atom < this.MOLATOMS; ++atom) {
            MolAtom a = this.mol.getAtom(atom);
            chg = a.getCharge();
            String symb = this.getSymbol(atom);
            if (symb.equals("O")) {
                if (chg == 1) continue;
                this.AcceptorSiteCount += 1.0;
                int n = atom;
                this.atomAC[n] = this.atomAC[n] + 1.0;
                if (chg != -1 & this.cHtab[atom].length == 1) {
                    this.AcceptorSiteCount += 1.0;
                    int n2 = atom;
                    this.atomAC[n2] = this.atomAC[n2] + 1.0;
                    continue;
                }
                if (chg != -1 || this.cHtab[atom].length != 1) continue;
                this.AcceptorSiteCount += 1.0;
                int n3 = atom;
                this.atomAC[n3] = this.atomAC[n3] + 1.0;
                continue;
            }
            if (symb.equals("N")) {
                this.AcceptorSiteCount += 1.0;
                int n = atom;
                this.atomAC[n] = this.atomAC[n] + 1.0;
                continue;
            }
            if (symb.equals("S") && !this.excludeSulfur) {
                if (chg == 1) continue;
                this.AcceptorSiteCount += 1.0;
                int n = atom;
                this.atomAC[n] = this.atomAC[n] + 1.0;
                if (this.getValenceState(atom) == 6) {
                    ++falseSAcceptor;
                    int n4 = atom;
                    this.atomAC[n4] = this.atomAC[n4] - 1.0;
                    continue;
                }
                if (this.getValenceState(atom) == 4 & this.cHtab[atom].length == 2) {
                    ++falseSAcceptor;
                    int n5 = atom;
                    this.atomAC[n5] = this.atomAC[n5] - 1.0;
                    continue;
                }
                if (this.fGroups[atom] == 1) {
                    ++falseSAcceptor;
                    int n6 = atom;
                    this.atomAC[n6] = this.atomAC[n6] - 1.0;
                    continue;
                }
                if (this.fGroups[atom] == 1100 && this.cHtab[atom].length == 2) {
                    ++falseSAcceptor;
                    int n7 = atom;
                    this.atomAC[n7] = this.atomAC[n7] - 1.0;
                    continue;
                }
                if (this.fGroups[atom] != 2 || this.cHtab[atom].length != 2) continue;
                ++falseSAcceptor;
                int n8 = atom;
                this.atomAC[n8] = this.atomAC[n8] - 1.0;
                continue;
            }
            if (!symb.equals("Cl") && !symb.equals("F") && !symb.equals("Br") && !symb.equals("I") || this.excludeHalogens) continue;
            this.AcceptorSiteCount += 1.0;
            int n = atom;
            this.atomAC[n] = this.atomAC[n] + 1.0;
        }
        falseNAcceptorSiteCount = this.calcFalseNAcceptorSite();
        falseOAcceptorSiteCount = this.calcFalseOAcceptorSite();
        this.AcceptorSiteCount = this.AcceptorSiteCount - (double)falseNAcceptorSiteCount - (double)falseSAcceptor - (double)falseOAcceptorSiteCount;
    }

    private int getHCount(int atomIndex) {
        int hcount = 0;
        for (int i = 0; i < this.cHtab[atomIndex].length; ++i) {
            if (!this.getSymbol(this.cHtab[atomIndex][i]).equals("H")) continue;
            ++hcount;
        }
        return hcount;
    }

    private String getSymbol(int atomIndex) {
        if (atomIndex >= this.MOLATOMS) {
            return "H";
        }
        return this.atomArray[atomIndex].getSymbol();
    }

    private boolean isNitroTypeNitrogen(int atom) {
        return this.fGroups[atom] == 100 || this.fGroups[atom] == 1200 || this.fGroups[atom] == 1300;
    }

    private boolean isPyrroleTypeNitrogen(int nitrogen) {
        int vs = this.getValenceState(nitrogen);
        return vs == 9 || vs == 12;
    }

    private int calcFalseNAcceptorSite() {
        int falseNAcceptor = 0;
        double charge = 0.0;
        for (int i = 0; i < this.MOLATOMS; ++i) {
            if (!this.getSymbol(i).equals("N")) continue;
            charge = this.atomArray[i].getCharge();
            if (charge == 1.0) {
                ++falseNAcceptor;
                int n = i;
                this.atomAC[n] = this.atomAC[n] - 1.0;
                continue;
            }
            if (this.isNitroTypeNitrogen(i)) {
                ++falseNAcceptor;
                int n = i;
                this.atomAC[n] = this.atomAC[n] - 1.0;
                continue;
            }
            if (charge == -1.0) continue;
            if (this.isPyrroleTypeNitrogen(i)) {
                ++falseNAcceptor;
                int n = i;
                this.atomAC[n] = this.atomAC[n] - 1.0;
                continue;
            }
            if (this.fGroups[i] != 200 && this.fGroups[i] != 500) continue;
            ++falseNAcceptor;
            int n = i;
            this.atomAC[n] = this.atomAC[n] - 1.0;
        }
        return falseNAcceptor;
    }

    private int calcFalseOAcceptorSite() {
        int falseOAcceptor = 0;
        for (int i = 0; i < this.MOLATOMS; ++i) {
            if (!this.getSymbol(i).equals("O")) continue;
            if (this.fGroups[i] == 1100) {
                ++falseOAcceptor;
                int n = i;
                this.atomAC[n] = this.atomAC[n] - 1.0;
                continue;
            }
            if (this.fGroups[i] == 2) {
                if (this.cHtab[i].length != 2) continue;
                ++falseOAcceptor;
                int n = i;
                this.atomAC[n] = this.atomAC[n] - 1.0;
                continue;
            }
            if (this.fGroups[i] != 600 || this.cHtab[i].length != 2) continue;
            ++falseOAcceptor;
            int n = i;
            this.atomAC[n] = this.atomAC[n] - 1.0;
        }
        return falseOAcceptor;
    }

    private int getValenceState(int atom1) {
        int j = this.cHtab[atom1].length;
        int valence = 0;
        for (int i = 0; i < j; ++i) {
            int atom2 = this.cHtab[atom1][i];
            if (this.bHtab[atom1][atom2] == -2) {
                ++valence;
                continue;
            }
            valence += this.mol.getBond(this.bHtab[atom1][atom2]).getType();
        }
        return valence;
    }

    public boolean getHValenceError() {
        return this.hValenceError;
    }

    private void initTautomerADCOunt() {
        this.MOLATOMS = this.mol.getAtomCount();
        this.cHtab = this.mol.createCHtab();
        this.bHtab = this.mol.createBHtab();
        this.atomArray = this.mol.getAtomArray();
        this.atomDC = new double[this.MOLATOMS];
        this.atomAC = new double[this.MOLATOMS];
    }

    public void calcTautomerAcceptorDonorCount() {
        this.initTautomerADCOunt();
        this.initGroups();
        if (this.criticalError) {
            return;
        }
        if (CriticalErrorCalculation.hasHValenceError(this.mol)) {
            this.hValenceError = true;
        }
        this.calcDonorSiteCountOfMicrospecies();
        this.calcAcceptorSiteCountOfMicrospecies();
    }

    public int[] getTautomerAbleAcceptorAtoms() {
        int[] aaList = null;
        if (this.atomAC != null) {
            int i;
            int a = this.mol.getAtomCount();
            int anum = 0;
            for (i = 0; i < a; ++i) {
                if (this.atomAC[i] != 0.0) {
                    if (!this.isTautomerAbleAcceptor(i)) continue;
                    ++anum;
                    continue;
                }
                if (this.isAcceptorCarbon(i)) {
                    this.atomAC[i] = 1.0;
                    ++anum;
                    continue;
                }
                if (this.isPositiveCharge(i)) {
                    this.atomAC[i] = 1.0;
                    ++anum;
                    continue;
                }
                if (this.isAcceptorNO2(i)) {
                    this.atomAC[i] = 1.0;
                    ++anum;
                    continue;
                }
                if (!this.isDBondedAcceptor(i)) continue;
                this.atomAC[i] = 1.0;
                ++anum;
            }
            aaList = new int[anum];
            int j = 0;
            for (i = 0; i < a; ++i) {
                if (this.atomAC[i] == 0.0) continue;
                aaList[j] = i;
                ++j;
            }
        }
        return aaList;
    }

    private boolean isPositiveCharge(int a) {
        this.metalComplex = false;
        if (this.isTautomerAbleAcceptor(a) && this.atomArray[a].getCharge() > 0) {
            int pc = this.atomArray[a].getAtno();
            int impHc = this.atomArray[a].getImplicitHcount();
            if (pc == 8) {
                if (this.cHtab[a].length > 2) {
                    if (!this.ResonanceFlag) {
                        this.metalComplex = true;
                        return false;
                    }
                    return true;
                }
                if (this.cHtab[a].length == 2 && impHc == 0) {
                    if (!this.ResonanceFlag) {
                        this.metalComplex = true;
                        return false;
                    }
                    return true;
                }
            }
            return true;
        }
        return false;
    }

    public void setResonanceFlag(boolean ee) {
        this.ResonanceFlag = ee;
    }

    public int[] getTautomerAbleDonorAtoms() {
        int[] daList = null;
        if (this.atomDC != null) {
            int i;
            int a = this.mol.getAtomCount();
            int dnum = 0;
            for (i = 0; i < a; ++i) {
                if (this.atomDC[i] != 0.0) {
                    if (!this.isSingleBondedDonor(i)) continue;
                    ++dnum;
                    continue;
                }
                if (!this.isTautomerAbleDonor(i)) continue;
                this.atomDC[i] = 1.0;
                ++dnum;
            }
            daList = new int[dnum];
            int j = 0;
            for (i = 0; i < a; ++i) {
                if (this.atomDC[i] == 0.0) continue;
                daList[j] = i;
                ++j;
            }
        }
        return daList;
    }

    private boolean isTautomerAbleAcceptor(int a) {
        int b = 0;
        for (int i = 0; i < this.cHtab[a].length; ++i) {
            int nb = this.cHtab[a][i];
            if (nb < this.MOLATOMS) {
                b = this.mol.getBond(this.bHtab[nb][a]).getType();
            }
            if (b == true) continue;
            return true;
        }
        this.atomAC[a] = 0.0;
        return false;
    }

    private boolean isDBondedAcceptor(int a) {
        if (this.metalComplex) {
            return false;
        }
        int b = 0;
        for (int i = 0; i < this.cHtab[a].length; ++i) {
            int nb = this.cHtab[a][i];
            if (nb < this.MOLATOMS) {
                b = this.mol.getBond(this.bHtab[nb][a]).getType();
            }
            if (b != 2) continue;
            return true;
        }
        this.atomAC[a] = 0.0;
        return false;
    }

    private boolean isSingleBondedDonor(int a) {
        int b = 0;
        for (int i = 0; i < this.cHtab[a].length; ++i) {
            int nb = this.cHtab[a][i];
            if (nb < this.MOLATOMS) {
                b = this.mol.getBond(this.bHtab[nb][a]).getType();
            }
            if (b == true || b == 4) continue;
            this.atomDC[a] = 0.0;
            return false;
        }
        if (this.atomArray[a].getCharge() > 0) {
            this.atomDC[a] = 0.0;
            return false;
        }
        return true;
    }

    private boolean isAcceptorNO2(int a) {
        int pc = this.atomArray[a].getAtno();
        if (pc == 7) {
            if (this.fGroups[a] == 100) {
                return true;
            }
            if (this.fGroups[a] == 1300) {
                return true;
            }
        }
        return false;
    }

    private boolean isAcceptorCarbon(int a) {
        int chg;
        int pc = this.atomArray[a].getAtno();
        return pc == 6 && this.cHtab[a].length != 4 && (chg = this.atomArray[a].getCharge()) >= 0;
    }

    private boolean isTautomerAbleDonor(int a) {
        int ch;
        boolean keto = false;
        boolean h = false;
        int pc = this.atomArray[a].getAtno();
        if (this.fGroups[a] != -1 && this.ResonanceFlag && pc != 6) {
            if (this.fGroups[a] == 1100) {
                return true;
            }
            if (this.fGroups[a] == 1000) {
                return true;
            }
            if (this.fGroups[a] == 3) {
                return true;
            }
            if (this.fGroups[a] == 2 && this.cHtab[a].length == 2) {
                return true;
            }
        }
        if ((ch = this.atomArray[a].getCharge()) < 0) {
            return true;
        }
        if (pc == 6) {
            if (this.cHtab[a].length == 4) {
                for (int i = 0; i < this.cHtab[a].length; ++i) {
                    int nb = this.cHtab[a][i];
                    if (nb < this.MOLATOMS) {
                        int t = this.fGroups[nb];
                        if (t == 1 || t == 100) {
                            keto = true;
                            continue;
                        }
                        pc = this.atomArray[nb].getAtno();
                        if (pc != 1) continue;
                        h = true;
                        continue;
                    }
                    h = true;
                }
            }
        } else if (pc == 15) {
            if (this.cHtab[a].length == 5) {
                for (int i = 0; i < this.cHtab[a].length; ++i) {
                    int nb = this.cHtab[a][i];
                    if (nb < this.MOLATOMS) {
                        pc = this.atomArray[nb].getAtno();
                        if (pc != 1) continue;
                        return true;
                    }
                    return true;
                }
            }
        } else if (pc == 53 && this.cHtab[a].length == 3) {
            for (int i = 0; i < this.cHtab[a].length; ++i) {
                int nb = this.cHtab[a][i];
                if (nb < this.MOLATOMS) {
                    pc = this.atomArray[nb].getAtno();
                    if (pc != 1) continue;
                    return true;
                }
                return true;
            }
        }
        if (h && keto) {
            return true;
        }
        return h && this.isDBNb(a);
    }

    private boolean isDBNb(int a) {
        int bt = 0;
        for (int i = 0; i < this.cHtab[a].length; ++i) {
            int nb = this.cHtab[a][i];
            if (nb >= this.MOLATOMS) continue;
            for (int j = 0; j < this.cHtab[nb].length; ++j) {
                int nnb = this.cHtab[nb][j];
                if (nnb >= this.MOLATOMS || (bt = this.mol.getBond(this.bHtab[nb][nnb]).getType()) != 2 && bt != 3) continue;
                return true;
            }
        }
        return false;
    }
}

