/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.calculations;

public class LinearFitting {
    double[][] a;
    double[][] v;
    double[][] u;
    double[] w;
    double[] b;
    double[] res;
    double[] afunc;
    double[] X;
    double[] Y;
    double[] sig;
    int m;
    int n;
    double[][] mX;
    double[][] cov;
    double[][] T;
    double[][] P;

    private void svdcmp() {
        int j;
        double h;
        double f;
        int k;
        double s;
        int i;
        int l = 0;
        int nm = 0;
        double[] rv1 = new double[this.n];
        double anorm = 0.0;
        double scale = 0.0;
        double g = 0.0;
        for (i = 0; i < this.n; ++i) {
            l = i + 2;
            rv1[i] = scale * g;
            scale = 0.0;
            s = 0.0;
            g = 0.0;
            if (i < this.m) {
                for (k = i; k < this.m; ++k) {
                    scale += Math.abs(this.a[k][i]);
                }
                if (scale != 0.0) {
                    for (k = i; k < this.m; ++k) {
                        double[] dArray = this.a[k];
                        int n = i;
                        dArray[n] = dArray[n] / scale;
                        s += this.a[k][i] * this.a[k][i];
                    }
                    f = this.a[i][i];
                    g = -this.sign(Math.sqrt(s), f);
                    h = f * g - s;
                    this.a[i][i] = f - g;
                    for (j = l - 1; j < this.n; ++j) {
                        s = 0.0;
                        for (k = i; k < this.m; ++k) {
                            s += this.a[k][i] * this.a[k][j];
                        }
                        f = s / h;
                        for (k = i; k < this.m; ++k) {
                            double[] dArray = this.a[k];
                            int n = j;
                            dArray[n] = dArray[n] + f * this.a[k][i];
                        }
                    }
                    for (k = i; k < this.m; ++k) {
                        double[] dArray = this.a[k];
                        int n = i;
                        dArray[n] = dArray[n] * scale;
                    }
                }
            }
            this.w[i] = scale * g;
            scale = 0.0;
            s = 0.0;
            g = 0.0;
            if (i + 1 <= this.m && i + 1 != this.n) {
                for (k = l - 1; k < this.n; ++k) {
                    scale += Math.abs(this.a[i][k]);
                }
                if (scale != 0.0) {
                    for (k = l - 1; k < this.n; ++k) {
                        double[] dArray = this.a[i];
                        int n = k;
                        dArray[n] = dArray[n] / scale;
                        s += this.a[i][k] * this.a[i][k];
                    }
                    f = this.a[i][l - 1];
                    g = -this.sign(Math.sqrt(s), f);
                    h = f * g - s;
                    this.a[i][l - 1] = f - g;
                    for (k = l - 1; k < this.n; ++k) {
                        rv1[k] = this.a[i][k] / h;
                    }
                    for (j = l - 1; j < this.m; ++j) {
                        s = 0.0;
                        for (k = l - 1; k < this.n; ++k) {
                            s += this.a[j][k] * this.a[i][k];
                        }
                        for (k = l - 1; k < this.n; ++k) {
                            double[] dArray = this.a[j];
                            int n = k;
                            dArray[n] = dArray[n] + s * rv1[k];
                        }
                    }
                    k = l - 1;
                    while (k < this.n) {
                        double[] dArray = this.a[i];
                        int n = k++;
                        dArray[n] = dArray[n] * scale;
                    }
                }
            }
            anorm = Math.max(anorm, Math.abs(this.w[i]) + Math.abs(rv1[i]));
        }
        i = this.n - 1;
        while (i >= 0) {
            if (i < this.n - 1) {
                if (g != 0.0) {
                    for (j = l; j < this.n; ++j) {
                        this.v[j][i] = this.a[i][j] / this.a[i][l] / g;
                    }
                    for (j = l; j < this.n; ++j) {
                        s = 0.0;
                        for (k = l; k < this.n; ++k) {
                            s += this.a[i][k] * this.v[k][j];
                        }
                        for (k = l; k < this.n; ++k) {
                            double[] dArray = this.v[k];
                            int n = j;
                            dArray[n] = dArray[n] + s * this.v[k][i];
                        }
                    }
                }
                for (j = l; j < this.n; ++j) {
                    this.v[j][i] = 0.0;
                    this.v[i][j] = 0.0;
                }
            }
            this.v[i][i] = 1.0;
            g = rv1[i];
            l = i--;
        }
        i = Math.min(this.m, this.n) - 1;
        while (i >= 0) {
            l = i + 1;
            g = this.w[i];
            for (j = l; j < this.n; ++j) {
                this.a[i][j] = 0.0;
            }
            if (g != 0.0) {
                g = 1.0 / g;
                for (j = l; j < this.n; ++j) {
                    s = 0.0;
                    for (k = l; k < this.m; ++k) {
                        s += this.a[k][i] * this.a[k][j];
                    }
                    f = s / this.a[i][i] * g;
                    for (k = i; k < this.m; ++k) {
                        double[] dArray = this.a[k];
                        int n = j;
                        dArray[n] = dArray[n] + f * this.a[k][i];
                    }
                }
                for (j = i; j < this.m; ++j) {
                    double[] dArray = this.a[j];
                    int n = i;
                    dArray[n] = dArray[n] * g;
                }
            } else {
                for (j = i; j < this.m; ++j) {
                    this.a[j][i] = 0.0;
                }
            }
            double[] dArray = this.a[i];
            int n = i--;
            dArray[n] = dArray[n] + 1.0;
        }
        block27: for (k = this.n - 1; k >= 0; --k) {
            for (int its = 0; its < 30; ++its) {
                double z;
                double y;
                double c;
                boolean flag = true;
                for (l = k; l >= 0; --l) {
                    nm = l - 1;
                    if (Math.abs(rv1[l]) + anorm == anorm || nm < 0) {
                        flag = false;
                        break;
                    }
                    if (Math.abs(this.w[nm]) + anorm == anorm) break;
                }
                if (flag) {
                    c = 0.0;
                    s = 1.0;
                    for (i = l; i < k + 1; ++i) {
                        f = s * rv1[i];
                        rv1[i] = c * rv1[i];
                        if (Math.abs(f) + anorm == anorm) break;
                        g = this.w[i];
                        this.w[i] = h = this.pythag(f, g);
                        h = 1.0 / h;
                        c = g * h;
                        s = -f * h;
                        for (j = 0; j < this.m; ++j) {
                            y = this.a[j][nm];
                            z = this.a[j][i];
                            this.a[j][nm] = y * c + z * s;
                            this.a[j][i] = z * c - y * s;
                        }
                    }
                }
                z = this.w[k];
                if (l == k) {
                    if (!(z < 0.0)) continue block27;
                    this.w[k] = -z;
                    for (j = 0; j < this.n; ++j) {
                        this.v[j][k] = -this.v[j][k];
                    }
                    continue block27;
                }
                if (its == 29) {
                    System.err.println("no convergence in 30 svdcmp iterations");
                }
                double x = this.w[l];
                nm = k - 1;
                y = this.w[nm];
                g = rv1[nm];
                h = rv1[k];
                f = ((y - z) * (y + z) + (g - h) * (g + h)) / (2.0 * h * y);
                g = this.pythag(f, 1.0);
                f = ((x - z) * (x + z) + h * (y / (f + this.sign(g, f)) - h)) / x;
                s = 1.0;
                c = 1.0;
                for (j = l; j <= nm; ++j) {
                    int jj;
                    i = j + 1;
                    g = rv1[i];
                    y = this.w[i];
                    h = s * g;
                    g = c * g;
                    rv1[j] = z = this.pythag(f, h);
                    c = f / z;
                    s = h / z;
                    f = x * c + g * s;
                    g = g * c - x * s;
                    h = y * s;
                    y *= c;
                    for (jj = 0; jj < this.n; ++jj) {
                        x = this.v[jj][j];
                        z = this.v[jj][i];
                        this.v[jj][j] = x * c + z * s;
                        this.v[jj][i] = z * c - x * s;
                    }
                    this.w[j] = z = this.pythag(f, h);
                    if (z != 0.0) {
                        z = 1.0 / z;
                        c = f * z;
                        s = h * z;
                    }
                    f = c * g + s * y;
                    x = c * y - s * g;
                    for (jj = 0; jj < this.m; ++jj) {
                        y = this.a[jj][j];
                        z = this.a[jj][i];
                        this.a[jj][j] = y * c + z * s;
                        this.a[jj][i] = z * c - y * s;
                    }
                }
                rv1[l] = 0.0;
                rv1[k] = f;
                this.w[k] = x;
            }
        }
    }

    private double sign(double a1, double a2) {
        a1 = a2 < 0.0 ? -1.0 * Math.abs(a1) : 1.0 * Math.abs(a1);
        return a1;
    }

    private double pythag(double a, double b) {
        double abs_a = Math.abs(a);
        double abs_b = Math.abs(b);
        double res = 0.0;
        if (abs_a > abs_b) {
            double c = abs_b / abs_a;
            c *= c;
            res = abs_a * Math.sqrt(1.0 + c);
        } else if (abs_b == 0.0) {
            res = 0.0;
        } else {
            double c = abs_a / abs_b;
            c *= c;
            res = abs_b * Math.sqrt(1.0 + c);
        }
        return res;
    }

    private void svbksb(double[][] u, double[] w, double[][] v, int m, int n) {
        double s;
        int j;
        double[] tmp = new double[n];
        for (j = 0; j < n; ++j) {
            s = 0.0;
            if (w[j] != 0.0) {
                for (int i = 0; i < m; ++i) {
                    s += u[i][j] * this.b[i];
                }
                s /= w[j];
            }
            tmp[j] = s;
        }
        for (j = 0; j < n; ++j) {
            s = 0.0;
            for (int jj = 0; jj < n; ++jj) {
                s += v[j][jj] * tmp[jj];
            }
            this.res[j] = s;
        }
    }

    private void svdfit() {
        int j;
        int i;
        double TOL = 1.0E-5;
        this.res = new double[this.n];
        this.a = new double[this.m][this.n];
        this.v = new double[this.n][this.n];
        this.w = new double[this.n];
        int ndata = this.m;
        int ma = this.n;
        this.b = new double[this.m];
        for (i = 0; i < ndata; ++i) {
            this.funcs(i);
            double tmp = 1.0 / this.sig[i];
            for (j = 0; j < ma; ++j) {
                this.a[i][j] = this.afunc[j] * tmp;
            }
            this.b[i] = this.Y[i] * tmp;
        }
        this.svdcmp();
        double wmax = 0.0;
        for (j = 0; j < ma; ++j) {
            if (!(this.w[j] > wmax)) continue;
            wmax = this.w[j];
        }
        double thresh = TOL * wmax;
        for (j = 0; j < ma; ++j) {
            if (!(this.w[j] < thresh)) continue;
            this.w[j] = 0.0;
        }
        this.svbksb(this.a, this.w, this.v, this.m, this.n);
        double chisq = 0.0;
        for (i = 0; i < ndata; ++i) {
            this.funcs(i);
            double sum = 0.0;
            for (j = 0; j < ma; ++j) {
                sum += this.res[j] * this.afunc[j];
            }
            double p = (this.Y[i] - sum) / this.sig[i];
            p *= p;
            chisq += p;
        }
    }

    private void funcs(int ind) {
        for (int i = 0; i < this.n; ++i) {
            this.afunc[i] = this.mX[ind][i];
        }
    }

    private void setXYData(int mm, int nn) {
        this.m = mm;
        this.n = nn;
        this.afunc = new double[this.n];
        this.X = new double[this.m];
        this.Y = new double[this.m];
        this.sig = new double[this.m];
        this.X[0] = 1.0;
        this.X[1] = 2.0;
        this.X[2] = 3.0;
        this.X[3] = 4.0;
        this.X[4] = 5.0;
        this.X[5] = 6.0;
        this.X[6] = 7.0;
        this.X[7] = 8.0;
        this.X[8] = 9.0;
        this.X[9] = 10.0;
        this.Y[0] = 1.0;
        this.Y[1] = 0.0;
        this.Y[2] = -2.0;
        this.Y[3] = -3.0;
        this.Y[4] = -4.0;
        this.Y[5] = -1.0;
        this.Y[6] = 0.2;
        this.Y[7] = 0.1;
        this.Y[8] = 0.1;
        this.Y[9] = 0.0;
        for (int i = 0; i < this.m; ++i) {
            this.sig[i] = 1.0;
        }
    }

    protected void setMultyXYSize(int mm, int nn) {
        this.m = mm;
        this.n = nn;
        this.afunc = new double[this.n];
        this.mX = new double[this.m][this.n];
        this.Y = new double[this.m];
        this.sig = new double[this.m];
        this.cov = new double[this.n][this.n];
        for (int i = 0; i < this.m; ++i) {
            this.sig[i] = 1.0;
        }
    }

    protected void setYValue(int indx, double yValue) {
        this.Y[indx] = yValue;
    }

    protected void setMultyXValue(int rowIndx, int[] xValues) {
        for (int i = 0; i < this.n; ++i) {
            this.mX[rowIndx][i] = xValues[i];
        }
    }

    protected void runMultyRegression() {
        this.svdfit();
        this.calcCovMatrix();
    }

    protected double[] getFittedParameters() {
        return this.res;
    }

    protected double getCovij(int i, int j) {
        return this.cov[i][j];
    }

    private void calcCovMatrix() {
        int i;
        double[] wti = new double[this.n];
        for (i = 0; i < this.n; ++i) {
            wti[i] = 0.0;
            if (this.w[i] == 0.0) continue;
            wti[i] = 1.0 / (this.w[i] * this.w[i]);
        }
        for (i = 0; i < this.n; ++i) {
            for (int j = 0; j <= i; ++j) {
                double sum = 0.0;
                for (int k = 0; k < this.n; ++k) {
                    sum += this.v[i][k] * this.v[j][k] * wti[k];
                }
                this.cov[i][j] = sum;
                this.cov[j][i] = sum;
            }
        }
    }

    private void test() {
        this.n = 3;
        this.m = 3;
        this.a = new double[this.m][this.n];
        this.a[0][0] = 2.0;
        this.a[0][1] = -2.0;
        this.a[0][2] = 3.0;
        this.a[1][0] = 1.0;
        this.a[1][1] = -2.5;
        this.a[1][2] = 1.5;
        this.a[2][0] = -3.5;
        this.a[2][1] = -1.5;
        this.a[2][2] = -1.0;
        this.b = new double[this.m];
        this.b[0] = 5.0;
        this.b[1] = 2.0;
        this.b[2] = 3.0;
        this.v = new double[this.n][this.n];
        this.w = new double[this.n];
        this.svdcmp();
        this.res = new double[this.n];
        this.svbksb(this.a, this.w, this.v, this.m, this.n);
        for (int i = 0; i < this.n; ++i) {
            System.err.println(i + "   " + this.res[i]);
        }
    }

    private void test2() {
        int j;
        int i;
        this.n = 3;
        this.m = 3;
        double[][] noise = new double[this.m][this.m];
        noise[0][0] = 10.0;
        noise[0][1] = -3.0;
        noise[0][2] = -4.0;
        noise[1][0] = -3.0;
        noise[1][1] = -6.0;
        noise[1][2] = 7.0;
        noise[2][0] = -7.0;
        noise[2][1] = 9.0;
        noise[2][2] = -3.0;
        this.a = new double[this.m][this.n];
        this.a[0][0] = -1.0;
        this.a[0][1] = -1.0;
        this.a[0][2] = -1.0;
        this.a[1][0] = 0.0;
        this.a[1][1] = 0.0;
        this.a[1][2] = 0.0;
        this.a[2][0] = 1.0;
        this.a[2][1] = 1.0;
        this.a[2][2] = 1.0;
        for (i = 0; i < this.n; ++i) {
            for (j = 0; j < this.m; ++j) {
                this.a[i][j] = this.a[i][j] + 1.0E-8 * noise[i][j];
            }
        }
        this.v = new double[this.n][this.n];
        this.w = new double[this.n];
        this.svdcmp();
        System.err.println("MATRIX U");
        for (i = 0; i < this.n; ++i) {
            for (j = 0; j < this.m; ++j) {
                System.err.print(this.a[i][j] + "  ");
            }
            System.err.println();
        }
        System.err.println("MATRIX P");
        for (i = 0; i < this.n; ++i) {
            for (j = 0; j < this.n; ++j) {
                System.err.print(this.v[i][j] + "  ");
            }
            System.err.println();
        }
        System.err.println("EIGEN VALUE  D(diag)");
        for (i = 0; i < this.n; ++i) {
            System.err.println(this.w[i]);
        }
        this.setScore(this.n);
        this.setLoad(this.n);
        System.err.println("SCORE ");
        for (i = 0; i < this.n; ++i) {
            for (j = 0; j < this.n; ++j) {
                System.err.print(this.T[i][j] + "  ");
            }
            System.err.println();
        }
        System.err.println("LOAD ");
        for (i = 0; i < this.n; ++i) {
            for (j = 0; j < this.n; ++j) {
                System.err.print(this.P[i][j] + "  ");
            }
            System.err.println();
        }
        System.err.println();
    }

    private void setScore(int n) {
        this.T = new double[n][n];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                this.T[i][j] = this.a[i][j] * this.w[j];
            }
        }
    }

    private void setLoad(int n) {
        this.P = new double[n][n];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                this.P[i][j] = this.v[j][i];
            }
        }
    }
}

