/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.calculations;

import chemaxon.calculations.AtomPolarizability;
import chemaxon.calculations.CalculationException;
import chemaxon.struc.Molecule;

public class MolPolarizability {
    public Double calculate(Molecule molecule) throws CalculationException {
        AtomPolarizability atomPol = new AtomPolarizability(molecule);
        return MolPolarizability.calculate(atomPol);
    }

    public static Double calculate(AtomPolarizability atomPol) throws CalculationException {
        double[] sm = new double[3];
        double sumTau = 0.0;
        int sumEcount = 0;
        Molecule molecule = atomPol.getMolecule();
        atomPol.setChargePolEffect(true);
        int atomCount = molecule.getAtomCount() + molecule.getImplicitHcount();
        for (int i = 0; i < atomCount; ++i) {
            sm = atomPol.getPolarizabilityParameter(i);
            sumTau += sm[0];
            sumEcount = (int)((double)sumEcount + sm[1]);
        }
        atomPol.setChargePolEffect(false);
        return 4.0 * sumTau * sumTau / (double)sumEcount;
    }
}

