/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.calculations;

import chemaxon.calculations.Charge;
import chemaxon.calculations.PolarGroups;
import chemaxon.calculations.clean.Cleaner;
import chemaxon.calculations.hydrogenize.Hydrogenize;
import chemaxon.license.Licensable;
import chemaxon.license.LicenseException;
import chemaxon.license.LicenseHandler;
import chemaxon.struc.MolAtom;
import chemaxon.struc.Molecule;

public class MolSurfaceArea
implements Licensable {
    private Molecule molCopy;
    private MolAtom[] atomArray;
    PolarGroups pg;
    Charge chg;
    private int[][] bHtab;
    private int[][] cHtab;
    private int atomCount;
    boolean[] isArom;
    double[][] xyz;
    double[] aSA;
    String[] aSymbol;
    double[] VDWRadii;
    final int UNKNOWN = -1;
    final double tchg = 0.125;
    double Rprob = 1.4;
    double SASA;
    double VDWSA;
    boolean criticalError;
    protected String licenseEnvironment = "";

    @Override
    public boolean isLicensed() {
        return LicenseHandler.getInstance().isLicensed("Geometry Plugin Group", this.licenseEnvironment);
    }

    private void checkLicense() throws LicenseException {
        LicenseHandler.getInstance().checkLicense("Geometry Plugin Group", this.licenseEnvironment);
    }

    @Override
    public void setLicenseEnvironment(String env) {
        this.licenseEnvironment = env;
    }

    public void setMolecule(Molecule mol) {
        this.molCopy = mol.cloneMoleculeWithDocument();
    }

    public void setRpobe(double r) {
        this.Rprob = r;
    }

    public boolean getCriticalErrorFlag() {
        return this.criticalError;
    }

    public Molecule getMolecule() {
        return this.molCopy;
    }

    public double getASA() {
        return this.getSASA();
    }

    public double getASAPlus() {
        double asap = 0.0;
        for (int i = 0; i < this.atomCount; ++i) {
            if (!(this.chg.Qsum[i] > 0.0)) continue;
            asap += this.getAtomicSA(i);
        }
        return asap;
    }

    public double getASANegative() {
        double asan = 0.0;
        for (int i = 0; i < this.atomCount; ++i) {
            if (!(this.chg.Qsum[i] < 0.0)) continue;
            asan += this.getAtomicSA(i);
        }
        return asan;
    }

    public double getASAHydrophobic() {
        double asah = 0.0;
        for (int i = 0; i < this.atomCount; ++i) {
            if (!(Math.abs(this.chg.Qsum[i]) < 0.125)) continue;
            asah += this.getAtomicSA(i);
        }
        return asah;
    }

    public double getASAPolar() {
        double asap = 0.0;
        for (int i = 0; i < this.atomCount; ++i) {
            if (!(Math.abs(this.chg.Qsum[i]) >= 0.125)) continue;
            asap += this.getAtomicSA(i);
        }
        return asap;
    }

    public double getAtomicSA(int ai) {
        return this.aSA[ai];
    }

    public double getSASA() {
        return this.SASA;
    }

    public double getVDWSA() {
        return this.VDWSA;
    }

    public void calcSASA() {
        this.initCalc();
        if (this.chg.getCriticalErrorFlag()) {
            return;
        }
        this.calcAtomicSASA();
        for (int i = 0; i < this.atomCount; ++i) {
            this.SASA += this.aSA[i];
        }
    }

    public void calcVDWSA() {
        this.initCalc();
        if (this.chg.getCriticalErrorFlag()) {
            return;
        }
        double Rpo = this.Rprob;
        this.Rprob = 0.0;
        this.calcAtomicSASA();
        for (int i = 0; i < this.atomCount; ++i) {
            this.VDWSA += this.aSA[i];
        }
        this.Rprob = Rpo;
    }

    private void initCalc() {
        this.setVDWRadii();
        this.hydrogenize();
        this.criticalError = this.calc3DCoordinates() & this.calcCharge();
        if (this.criticalError) {
            return;
        }
        this.cHtab = this.molCopy.createCHtab();
        this.bHtab = this.molCopy.createBHtab();
        this.aSymbol = new String[this.atomCount];
        this.isArom = new boolean[this.atomCount];
        this.aSA = new double[this.atomCount];
        for (int i = 0; i < this.atomCount; ++i) {
            MolAtom a = this.molCopy.getAtom(i);
            this.aSymbol[i] = a.getSymbol();
            this.isArom[i] = a.hasAromaticBond();
        }
        this.setGroups(this.molCopy);
        this.SASA = 0.0;
        this.VDWSA = 0.0;
    }

    private boolean calcCharge() {
        this.chg = new Charge();
        this.chg.setMolecule(this.molCopy);
        this.chg.calcMajorResonanceCharge();
        return this.chg.getCriticalErrorFlag();
    }

    private double getVDWRadii(int a) {
        int hc;
        int pc = this.atomArray[a].getAtno();
        if (this.VDWRadii[pc] == 0.0) {
            return 2.0;
        }
        if (pc == 6) {
            int hc2 = this.getHc(a);
            if (!this.isArA(a)) {
                if (this.isUnsaturated(a)) {
                    if (this.isCarbonyl(a)) {
                        return 1.72;
                    }
                } else if (hc2 == 2) {
                    return 1.9;
                }
            }
        } else if (pc == 8) {
            if (!this.isArA(a) && this.isKeto(a)) {
                return 1.7;
            }
        } else if (!(pc != 7 || this.isArA(a) || (hc = this.getHc(a)) != 3 && hc != 2)) {
            return 1.6;
        }
        return this.VDWRadii[pc];
    }

    private boolean isCarbonyl(int ai) {
        for (int i = 0; i < this.cHtab[ai].length; ++i) {
            int pc;
            int nb = this.cHtab[ai][i];
            if (nb >= this.atomCount || this.molCopy.getBond(this.bHtab[ai][nb]).getType() < 2 || (pc = this.atomArray[nb].getAtno()) != 16 && pc != 8) continue;
            return true;
        }
        return false;
    }

    private boolean isKeto(int ox) {
        for (int i = 0; i < this.cHtab[ox].length; ++i) {
            int nb = this.cHtab[ox][i];
            if (nb >= this.atomCount || this.molCopy.getBond(this.bHtab[ox][nb]).getType() < 2) continue;
            return true;
        }
        return false;
    }

    private void setVDWRadii() {
        this.VDWRadii = new double[150];
        this.VDWRadii[47] = 1.72;
        this.VDWRadii[18] = 1.88;
        this.VDWRadii[33] = 1.85;
        this.VDWRadii[79] = 1.66;
        this.VDWRadii[35] = 1.85;
        this.VDWRadii[6] = 1.8;
        this.VDWRadii[48] = 1.58;
        this.VDWRadii[17] = 1.75;
        this.VDWRadii[29] = 1.4;
        this.VDWRadii[9] = 1.47;
        this.VDWRadii[31] = 1.87;
        this.VDWRadii[1] = 1.1;
        this.VDWRadii[2] = 1.4;
        this.VDWRadii[80] = 1.55;
        this.VDWRadii[53] = 1.98;
        this.VDWRadii[49] = 1.93;
        this.VDWRadii[19] = 2.75;
        this.VDWRadii[36] = 2.02;
        this.VDWRadii[3] = 1.82;
        this.VDWRadii[12] = 1.73;
        this.VDWRadii[7] = 1.55;
        this.VDWRadii[11] = 2.27;
        this.VDWRadii[10] = 1.54;
        this.VDWRadii[28] = 1.63;
        this.VDWRadii[8] = 1.52;
        this.VDWRadii[15] = 1.8;
        this.VDWRadii[82] = 2.02;
        this.VDWRadii[46] = 1.63;
        this.VDWRadii[78] = 1.72;
        this.VDWRadii[16] = 1.8;
        this.VDWRadii[34] = 1.9;
        this.VDWRadii[14] = 2.1;
        this.VDWRadii[50] = 2.17;
        this.VDWRadii[52] = 2.06;
        this.VDWRadii[81] = 1.96;
        this.VDWRadii[92] = 1.86;
        this.VDWRadii[54] = 2.16;
        this.VDWRadii[30] = 1.39;
    }

    private double getPi(int a) {
        String symb = this.getSymbol(a);
        if (symb.equals("C")) {
            if (this.isArA(a)) {
                return 1.073;
            }
            if (this.isUnsaturated(a)) {
                return 1.554;
            }
            int hc = this.getHc(a);
            if (hc == 1) {
                return 1.276;
            }
            if (hc == 2) {
                return 1.045;
            }
            if (hc == 3) {
                return 0.88;
            }
        } else {
            if (symb.equals("O")) {
                int hc = this.getHc(a);
                if (hc != 0) {
                    return 1.08;
                }
                if (this.isUnsaturated(a)) {
                    return 0.926;
                }
                return 0.922;
            }
            if (symb.equals("N")) {
                if (this.pg.carboxy[a] == 200 || this.pg.carboxy[a] == 500 || this.pg.carboxy[a] == 800 || this.pg.carboxy[a] == 1600 || this.pg.carboxy[a] == 1500 || this.pg.carboxy[a] == 600 || this.pg.carboxy[a] == 1200 || this.pg.carboxy[a] == 1300 || this.pg.carboxy[a] == 400) {
                    return 1.028;
                }
                int hc = this.getHc(a);
                if (hc == 2 || hc == 3) {
                    return 1.215;
                }
                return 1.028;
            }
            if (symb.equals("S")) {
                return 1.121;
            }
            if (symb.equals("H")) {
                if (this.isPolarHydrogen(a)) {
                    return 1.128;
                }
                return 1.0;
            }
        }
        return 1.0;
    }

    private boolean isPolarHydrogen(int ai) {
        int nb = this.cHtab[ai][0];
        if (nb != -1) {
            MolAtom a = this.molCopy.getAtom(nb);
            int pc = a.getAtno();
            double en = MolAtom.electronegOf(pc);
            int chg = a.getCharge();
            if (chg != 0) {
                return true;
            }
            double absEn = Math.abs((en /= 10.0) - 2.2);
            if (absEn > 0.5) {
                return true;
            }
            if (this.getHc(nb) == 3 && this.isAlphaEWD(nb)) {
                return true;
            }
        }
        return false;
    }

    private boolean isAlphaEWD(int ai) {
        for (int i = 0; i < this.cHtab[ai].length; ++i) {
            if (!this.isEWD(this.cHtab[ai][i])) continue;
            return true;
        }
        return false;
    }

    private boolean isEWD(int ai) {
        if (this.getSymbol(ai).equals("H")) {
            return false;
        }
        switch (this.pg.carboxy[ai]) {
            case 200: {
                return true;
            }
            case 500: {
                return true;
            }
            case 400: {
                return true;
            }
            case 600: {
                return true;
            }
            case 700: {
                return true;
            }
            case 800: {
                return true;
            }
            case 1200: {
                return true;
            }
            case 100: {
                return true;
            }
            case 1300: {
                return true;
            }
            case 1400: {
                return true;
            }
            case 1: {
                return true;
            }
            case 2: {
                return true;
            }
            case 1700: {
                return true;
            }
        }
        return false;
    }

    private int getHc(int a) {
        int c = 0;
        for (int i = 0; i < this.cHtab[a].length; ++i) {
            int nb = this.cHtab[a][i];
            if (!this.getSymbol(nb).equals("H")) continue;
            ++c;
        }
        return c;
    }

    private boolean isUnsaturated(int a) {
        for (int i = 0; i < this.cHtab[a].length; ++i) {
            int bt;
            int nb = this.cHtab[a][i];
            if (nb >= this.atomCount || (bt = this.molCopy.getBond(this.bHtab[a][nb]).getType()) < 2) continue;
            return true;
        }
        return false;
    }

    private double getPij(int i, int j) {
        for (int k = 0; k < this.cHtab[i].length; ++k) {
            int nb = this.cHtab[i][k];
            if (nb != j) continue;
            return 0.8875;
        }
        return 0.3516;
    }

    private double getDistance(int i, int j) {
        double d1 = this.xyz[i][0] - this.xyz[j][0];
        double d2 = this.xyz[i][1] - this.xyz[j][1];
        double d3 = this.xyz[i][2] - this.xyz[j][2];
        double sum = d1 * d1 + d2 * d2 + d3 * d3;
        sum = Math.sqrt(sum);
        return sum;
    }

    private double getBij(int i, int j) {
        double vdw_j;
        double vdw_i;
        double c;
        double d = this.getDistance(i, j);
        if (d > (c = (vdw_i = this.getVDWRadii(i)) + (vdw_j = this.getVDWRadii(j)) + 2.0 * this.Rprob)) {
            return 0.0;
        }
        double s1 = 3.141593 * (vdw_i + this.Rprob);
        s1 *= c - d;
        double s2 = (vdw_j - vdw_i) / d;
        s2 = 1.0 + s2;
        return s1 *= s2;
    }

    private void calcAtomicSASA() {
        for (int i = 0; i < this.atomCount; ++i) {
            double si = this.getSi(i);
            double pr = 1.0;
            for (int j = 0; j < this.atomCount; ++j) {
                double bij = 0.0;
                double s1 = 1.0;
                if (i != j) {
                    bij = this.getBij(i, j);
                }
                if (!(bij > 0.0)) continue;
                s1 = this.getPi(i) * this.getPij(i, j) * bij;
                s1 /= this.getSi(j);
                s1 = 1.0 - s1;
                pr *= s1;
            }
            this.aSA[i] = si * pr;
        }
    }

    private double getSi(int ai) {
        double sasa_i = this.getVDWRadii(ai) + this.Rprob;
        double s_i = sasa_i * sasa_i;
        double si = 12.566372 * s_i;
        return si;
    }

    private void setGroups(Molecule m) {
        this.pg = new PolarGroups(m);
        this.pg.setGroups();
    }

    public String getSymbol(int i) {
        if (i >= this.atomCount) {
            return "H";
        }
        return this.aSymbol[i];
    }

    protected boolean isArA(int atom) {
        if (atom >= this.atomCount) {
            return false;
        }
        return this.isArom[atom];
    }

    private boolean calc3DCoordinates() {
        boolean ok;
        this.atomCount = this.molCopy.getAtomCount();
        boolean criticalError = false;
        if (this.molCopy.getDim() <= 2 && !(ok = Cleaner.clean(this.molCopy, 3, "S3"))) {
            criticalError = true;
        }
        this.atomArray = this.molCopy.getAtomArray();
        this.xyz = new double[this.atomCount][3];
        for (int i = 0; i < this.atomCount; ++i) {
            this.xyz[i][0] = this.atomArray[i].getX();
            this.xyz[i][1] = this.atomArray[i].getY();
            this.xyz[i][2] = this.atomArray[i].getZ();
        }
        return criticalError;
    }

    private void hydrogenize() {
        int IMPLICITH = this.molCopy.getImplicitHcount();
        if (IMPLICITH == 0) {
            return;
        }
        Hydrogenize.addHAtoms(this.molCopy, null, 1);
    }
}

