/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.calculations;

import java.util.Iterator;

public class PointsOnSphere
implements Iterator<double[]> {
    private int n;
    private double[] var = new double[2];
    private int k = 0;
    private double phiPrev = 0.0;

    public PointsOnSphere(int n) {
        this.n = n;
    }

    @Override
    public boolean hasNext() {
        return this.k < this.n;
    }

    @Override
    public double[] next() {
        double h = -1.0 + 2.0 * (double)this.k / (double)(this.n - 1);
        this.var[0] = Math.acos(h);
        this.var[1] = 0.0;
        if (this.k != 0 && this.k != this.n - 1) {
            this.var[1] = (this.phiPrev + 3.6 / Math.sqrt((double)this.n * (1.0 - h * h))) % (Math.PI * 2);
        }
        this.phiPrev = this.var[1];
        ++this.k;
        return this.var;
    }

    @Override
    public void remove() {
    }
}

