/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.calculations;

import chemaxon.struc.Molecule;
import chemaxon.struc.PeriodicSystem;
import java.util.Random;

public class ProjectionArea {
    private Molecule m = null;
    private double[] radii = null;
    private double area = 0.0;
    private boolean valid = false;
    private double accuracy = 1.0E-4;

    ProjectionArea(Molecule m) {
        this.m = m;
        this.radii = this.getRadii();
    }

    private double calculateArea() {
        double area0;
        double area = 0.0;
        double[][] rectangle = new double[2][2];
        for (int i = 0; i < this.m.getAtomCount(); ++i) {
            if (this.m.getAtom(i).getX() - this.radii[i] < rectangle[0][0]) {
                rectangle[0][0] = this.m.getAtom(i).getX() - this.radii[i];
                continue;
            }
            if (this.m.getAtom(i).getX() + this.radii[i] > rectangle[0][1]) {
                rectangle[0][1] = this.m.getAtom(i).getX() + this.radii[i];
                continue;
            }
            if (this.m.getAtom(i).getY() - this.radii[i] < rectangle[1][0]) {
                rectangle[1][0] = this.m.getAtom(i).getY() - this.radii[i];
                continue;
            }
            if (!(this.m.getAtom(i).getY() + this.radii[i] > rectangle[1][1])) continue;
            rectangle[1][1] = this.m.getAtom(i).getY() + this.radii[i];
        }
        double maxarea = (rectangle[0][1] - rectangle[0][0]) * (rectangle[1][1] - rectangle[1][0]);
        double xRange = rectangle[0][1] - rectangle[0][0];
        double yRange = rectangle[0][1] - rectangle[0][0];
        long inCounter = 0L;
        int nCyc = 10000;
        long nTry = 0L;
        Random ran = new Random(12345678L);
        do {
            area0 = area;
            int iCyc = nCyc;
            if (nTry < (long)nCyc) {
                iCyc /= 2;
            }
            block2: for (int i = 0; i < iCyc; ++i) {
                ++nTry;
                double r = ran.nextDouble();
                double x = rectangle[0][0] + r * xRange;
                r = ran.nextDouble();
                double y = rectangle[1][0] + r * yRange;
                for (int j = 0; j < this.m.getAtomCount(); ++j) {
                    double ya;
                    double xa = this.m.getAtom(j).getX();
                    if (!(Math.sqrt((x - xa) * (x - xa) + (y - (ya = this.m.getAtom(j).getY())) * (y - ya)) < this.radii[j])) continue;
                    ++inCounter;
                    continue block2;
                }
            }
        } while (Math.abs((area = maxarea * (double)inCounter / (double)nTry) - area0) > this.accuracy);
        this.valid = true;
        return area;
    }

    private Object println(String string) {
        return null;
    }

    public double[] getRadii() {
        if (this.m == null) {
            return null;
        }
        if (this.radii == null) {
            this.radii = new double[this.m.getAtomCount()];
            for (int i = 0; i < this.radii.length; ++i) {
                this.radii[i] = PeriodicSystem.getVanDerWaalsRadius(this.m.getAtom(i).getAtno());
            }
        }
        return this.radii;
    }

    public double getArea() {
        if (!this.valid) {
            this.area = this.calculateArea();
        }
        return this.area;
    }

    public Molecule getM() {
        return this.m;
    }

    public void setM(Molecule m) {
        this.m = m;
        this.valid = false;
    }

    public double getAccuracy() {
        return this.accuracy;
    }

    public void setAccuracy(double accuracy) {
        this.accuracy = accuracy;
    }
}

