/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.calculations;

import chemaxon.core.util.BondTable;
import chemaxon.license.Licensable;
import chemaxon.license.LicenseException;
import chemaxon.license.LicenseHandler;
import chemaxon.struc.MoleculeGraph;

public class Ring
implements Licensable {
    private String licenseEnvironment = "";
    private static final int RINGMASK = 2;
    private static final int AROMATICMASK = 4;
    private static final int AROMATICRINGMASK = 8;
    private static final int ALIPHATICRINGMASK = 16;
    private static final int HYDROGENMASK = 32;
    private static final int FUSEDRINGMASK = 64;
    private static final int FUSEDALIPHATICRINGMASK = 128;
    private static final int FUSEDAROMATICRINGMASK = 256;
    private static final int RINGCONNECTIONMASK = 512;
    private static final int RINGSYSTEMMASK = 1024;
    private static final int HETERORINGMASK = 2048;
    private static final int CONNECTION_FUSED = 2;
    private MoleculeGraph mol;
    private int aromatizationMode;
    private int initialized = 0;
    private int[] bonds;
    private int[] atoms;
    private BondTable btab;
    private int[][] arings;
    private int[][] aromaticRings;
    private int[][] aliphaticRings;
    private int[] heteroRings;
    private int[][] rings;
    private int[][] ringSystems;
    private int[] fusedAliphaticRings;
    private int[] fusedAromaticRings;
    private int[] fusedRings;
    private int[][] ringConnections;
    private int explicitHydrogenCount;

    public MoleculeGraph getMolecule() {
        return this.mol;
    }

    public void setMolecule(MoleculeGraph mol) {
        this.checkLicense();
        this.setMolecule(mol, 2);
    }

    public void setMolecule(MoleculeGraph mol, int aromatizationMode) {
        this.mol = mol;
        this.initialized = 0;
        this.atoms = new int[mol.getAtomCount()];
        this.bonds = new int[mol.getBondCount()];
        this.btab = mol.getBondTable();
        this.aromatizationMode = aromatizationMode;
    }

    public int aliphaticAtomCount() {
        if ((this.initialized & 0x20) == 0) {
            this.findHydrogens();
        }
        return this.atoms.length - this.explicitHydrogenCount - this.aromaticAtomCount();
    }

    public int aliphaticBondCount() {
        if ((this.initialized & 0x20) == 0) {
            this.findHydrogens();
        }
        return this.bonds.length - this.explicitHydrogenCount - this.aromaticBondCount();
    }

    public int aliphaticRingCount() {
        if ((this.initialized & 0x10) == 0) {
            this.findAliphaticRings();
        }
        return this.aliphaticRings.length;
    }

    public int aliphaticRingCount(int size) {
        if ((this.initialized & 0x10) == 0) {
            this.findAliphaticRings();
        }
        int c = 0;
        for (int i = 0; i < this.aliphaticRings.length; ++i) {
            if (this.aliphaticRings[i].length != size) continue;
            ++c;
        }
        return c;
    }

    public int[][] aliphaticRings() {
        if ((this.initialized & 0x10) == 0) {
            this.findAliphaticRings();
        }
        if (this.aliphaticRings.length == 0) {
            return null;
        }
        return (int[][])this.aliphaticRings.clone();
    }

    public int[][] aliphaticRings(int size) {
        int c = this.aliphaticRingCount(size);
        if (c == 0) {
            return null;
        }
        int[][] result = new int[c][];
        int j = 0;
        for (int i = 0; i < this.aliphaticRings.length; ++i) {
            if (this.aliphaticRings[i].length != size) continue;
            result[j] = (int[])this.aliphaticRings[i].clone();
            ++j;
        }
        return result;
    }

    public int aromaticAtomCount() {
        if ((this.initialized & 4) == 0) {
            this.findAromatic();
        }
        int c = 0;
        for (int i = 0; i < this.atoms.length; ++i) {
            if ((this.atoms[i] & 4) != 4) continue;
            ++c;
        }
        return c;
    }

    public int aromaticBondCount() {
        if ((this.initialized & 4) == 0) {
            this.findAromatic();
        }
        int c = 0;
        for (int i = 0; i < this.bonds.length; ++i) {
            if ((this.bonds[i] & 4) != 4) continue;
            ++c;
        }
        return c;
    }

    public int aromaticRingCount() {
        if ((this.initialized & 8) == 0) {
            this.findAromaticRings();
        }
        return this.aromaticRings.length;
    }

    public int aromaticRingCount(int size) {
        if ((this.initialized & 8) == 0) {
            this.findAromaticRings();
        }
        int c = 0;
        for (int i = 0; i < this.aromaticRings.length; ++i) {
            if (this.aromaticRings[i].length != size) continue;
            ++c;
        }
        return c;
    }

    public int[][] aromaticRings() {
        if ((this.initialized & 8) == 0) {
            this.findAromaticRings();
        }
        if (this.aromaticRings.length == 0) {
            return null;
        }
        return (int[][])this.aromaticRings.clone();
    }

    public int[][] aromaticRings(int size) {
        int c = this.aromaticRingCount(size);
        if (c == 0) {
            return null;
        }
        int[][] result = new int[c][];
        int j = 0;
        for (int i = 0; i < this.aromaticRings.length; ++i) {
            if (this.aromaticRings[i].length != size) continue;
            result[j] = (int[])this.aromaticRings[i].clone();
            ++j;
        }
        return result;
    }

    public int carboaliphaticRingCount() {
        return this.aliphaticRingCount() - this.heteroaliphaticRingCount();
    }

    public int carboaromaticRingCount() {
        return this.aromaticRingCount() - this.heteroaromaticRingCount();
    }

    public int carboRingCount() {
        return this.ringCount() - this.heteroRingCount();
    }

    public int carboRingCount(int size) {
        if ((this.initialized & 0x800) == 0) {
            this.findHeteroRings();
        }
        int c = 0;
        for (int i = 0; i < this.rings.length; ++i) {
            for (int j = 0; j < this.heteroRings.length && this.heteroRings[j] != i; ++j) {
                if (this.rings[i].length != size) continue;
                ++c;
            }
        }
        return c;
    }

    public int[][] carboRings() {
        if ((this.initialized & 0x800) == 0) {
            this.findHeteroRings();
        }
        if (this.rings.length - this.heteroRings.length == 0) {
            return null;
        }
        int[][] result = new int[this.rings.length - this.heteroRings.length][];
        int c = 0;
        for (int i = 0; i < this.rings.length; ++i) {
            boolean hetero = false;
            for (int j = 0; j < this.heteroRings.length; ++j) {
                if (this.heteroRings[j] != i) continue;
                hetero = true;
                break;
            }
            if (hetero) continue;
            result[c] = (int[])this.rings[i].clone();
            ++c;
        }
        return result;
    }

    public int[][] carboRings(int size) {
        if (this.carboRingCount(size) == 0) {
            return null;
        }
        int[][] result = new int[this.carboRingCount(size)][];
        int c = 0;
        for (int i = 0; i < this.rings.length; ++i) {
            boolean hetero = false;
            for (int j = 0; j < this.heteroRings.length; ++j) {
                if (this.heteroRings[j] != i) continue;
                hetero = true;
                break;
            }
            if (hetero || this.rings[i].length != size) continue;
            result[c] = (int[])this.rings[i].clone();
            ++c;
        }
        return result;
    }

    public int chainAtomCount() {
        if ((this.initialized & 0x20) == 0) {
            this.findHydrogens();
        }
        return this.atoms.length - this.explicitHydrogenCount - this.ringAtomCount();
    }

    public int chainBondCount() {
        if ((this.initialized & 0x20) == 0) {
            this.findHydrogens();
        }
        return this.bonds.length - this.explicitHydrogenCount - this.ringBondCount();
    }

    private void findAliphaticRings() {
        if ((this.initialized & 2) == 0) {
            this.findRings();
        }
        if ((this.initialized & 8) == 0) {
            this.findAromatic();
        }
        if (this.arings.length == 0) {
            this.aliphaticRings = this.rings;
        } else {
            int i;
            int c = 0;
            boolean[] sssrRings = new boolean[this.rings.length];
            block0: for (i = 0; i < this.rings.length; ++i) {
                for (int j = 0; j < this.rings[i].length; ++j) {
                    if ((this.atoms[this.rings[i][j]] & 4) != 0) continue;
                    sssrRings[i] = true;
                    ++c;
                    continue block0;
                }
            }
            this.aliphaticRings = new int[c][];
            c = 0;
            for (i = 0; i < sssrRings.length; ++i) {
                if (!sssrRings[i]) continue;
                this.aliphaticRings[c] = this.rings[i];
                ++c;
            }
        }
        this.initialized |= 0x10;
    }

    private void findAromatic() {
        this.arings = this.mol.getAromaticAndAliphaticRings(this.aromatizationMode, true, false, 24, 1000)[0];
        if (this.arings.length > 0) {
            for (int i = 0; i < this.arings.length; ++i) {
                int n = this.arings[i][0];
                this.atoms[n] = this.atoms[n] | 4;
                int n2 = this.btab.getBondIndex(this.arings[i][0], this.arings[i][this.arings[i].length - 1]);
                this.bonds[n2] = this.bonds[n2] | 4;
                for (int j = 1; j < this.arings[i].length; ++j) {
                    int n3 = this.arings[i][j];
                    this.atoms[n3] = this.atoms[n3] | 4;
                    int n4 = this.btab.getBondIndex(this.arings[i][j], this.arings[i][j - 1]);
                    this.bonds[n4] = this.bonds[n4] | 4;
                }
            }
        }
        this.initialized |= 4;
    }

    private void findAromaticRings() {
        if ((this.initialized & 4) == 0) {
            this.findAromatic();
        }
        if (this.arings.length == 0) {
            this.aromaticRings = this.arings;
        }
        if (this.arings.length > 0) {
            int i;
            for (int i2 = 0; i2 < this.arings.length; ++i2) {
                int n = this.arings[i2][0];
                this.atoms[n] = this.atoms[n] | 4;
                int n2 = this.btab.getBondIndex(this.arings[i2][0], this.arings[i2][this.arings[i2].length - 1]);
                this.bonds[n2] = this.bonds[n2] | 4;
                for (int j = 1; j < this.arings[i2].length; ++j) {
                    int n3 = this.arings[i2][j];
                    this.atoms[n3] = this.atoms[n3] | 4;
                    int n4 = this.btab.getBondIndex(this.arings[i2][j], this.arings[i2][j - 1]);
                    this.bonds[n4] = this.bonds[n4] | 4;
                }
            }
            int c = 0;
            boolean[] sssrRings = new boolean[this.arings.length];
            block2: for (i = 0; i < this.arings.length; ++i) {
                int[] ring = new int[this.arings[i].length];
                for (int j = 0; j < this.arings.length; ++j) {
                    if (this.arings[i].length <= this.arings[j].length) continue;
                    for (int k = 0; k < this.arings[i].length; ++k) {
                        for (int m = 0; m < this.arings[j].length; ++m) {
                            if (this.arings[i][k] != this.arings[j][m]) continue;
                            ring[k] = -1;
                        }
                    }
                }
                for (int n = 0; n < ring.length; ++n) {
                    if (ring[n] == -1) continue;
                    sssrRings[i] = true;
                    ++c;
                    continue block2;
                }
            }
            this.aromaticRings = new int[c][];
            c = 0;
            for (i = 0; i < sssrRings.length; ++i) {
                if (!sssrRings[i]) continue;
                this.aromaticRings[c] = this.arings[i];
                ++c;
            }
        }
        this.initialized |= 8;
    }

    private int[] findFused(int[][] r) {
        int m;
        this.ringConnections = new int[r.length][r.length];
        for (int i = 0; i < r.length; ++i) {
            for (int j = 0; j < r[i].length; ++j) {
                for (m = i + 1; m < r.length; ++m) {
                    for (int n = 0; n < r[m].length; ++n) {
                        if (r[i][j] != r[m][n] || this.ringConnections[i][m] == 2) continue;
                        int[] nArray = this.ringConnections[i];
                        int n2 = m;
                        nArray[n2] = nArray[n2] + 1;
                        int[] nArray2 = this.ringConnections[m];
                        int n3 = i;
                        nArray2[n3] = nArray2[n3] + 1;
                    }
                }
            }
        }
        int c = 0;
        block4: for (int i = 0; i < this.ringConnections.length; ++i) {
            for (m = 0; m < this.ringConnections[i].length; ++m) {
                if (this.ringConnections[i][m] != 2) continue;
                ++c;
                continue block4;
            }
        }
        int d = 0;
        int[] result = new int[c];
        block6: for (int i = 0; i < this.ringConnections.length; ++i) {
            for (int m2 = 0; m2 < this.ringConnections[i].length; ++m2) {
                if (this.ringConnections[i][m2] != 2) continue;
                result[d] = i;
                ++d;
                continue block6;
            }
        }
        return result;
    }

    private void findFusedAliphaticRings() {
        if ((this.initialized & 0x10) == 0) {
            this.findAliphaticRings();
        }
        this.fusedAliphaticRings = this.findFused(this.aliphaticRings);
        this.initialized |= 0x80;
    }

    private void findFusedAromaticRings() {
        if ((this.initialized & 8) == 0) {
            this.findAromaticRings();
        }
        this.fusedAromaticRings = this.findFused(this.aromaticRings);
        this.initialized |= 0x100;
    }

    private void findFusedRings() {
        if ((this.initialized & 2) == 0) {
            this.findRings();
        }
        this.fusedRings = this.findFused(this.rings);
        this.initialized |= 0x40;
    }

    private void findHeteroRings() {
        if ((this.initialized & 2) == 0) {
            this.findRings();
        }
        int[] r = new int[this.rings.length];
        int c = 0;
        block0: for (int i = 0; i < this.rings.length; ++i) {
            for (int j = 0; j < this.rings[i].length; ++j) {
                if (this.mol.getAtom(this.rings[i][j]).getAtno() == 6) continue;
                r[c] = i;
                ++c;
                continue block0;
            }
        }
        this.heteroRings = new int[c];
        System.arraycopy(r, 0, this.heteroRings, 0, c);
        this.initialized |= 0x800;
    }

    private void findHydrogens() {
        this.explicitHydrogenCount = 0;
        block0: for (int i = 0; i < this.atoms.length; ++i) {
            if (this.mol.getAtom(i).getAtno() != 1) continue;
            ++this.explicitHydrogenCount;
            int n = i;
            this.atoms[n] = this.atoms[n] | 0x20;
            for (int j = 0; j < this.btab.getAtomCount(); ++j) {
                if (this.btab.getBondIndex(i, j) == -1) continue;
                int n2 = this.btab.getBondIndex(i, j);
                this.bonds[n2] = this.bonds[n2] | 0x20;
                continue block0;
            }
        }
    }

    private void findRingConnections() {
        if ((this.initialized & 2) == 0) {
            this.findRings();
        }
        this.ringConnections = new int[this.rings.length][this.rings.length];
        for (int i = 0; i < this.rings.length; ++i) {
            for (int j = 0; j < this.rings[i].length; ++j) {
                for (int m = i + 1; m < this.rings.length; ++m) {
                    for (int n = 0; n < this.rings[m].length; ++n) {
                        if (this.rings[i][j] != this.rings[m][n]) continue;
                        int[] nArray = this.ringConnections[i];
                        int n2 = m;
                        nArray[n2] = nArray[n2] + 1;
                        int[] nArray2 = this.ringConnections[m];
                        int n3 = i;
                        nArray2[n3] = nArray2[n3] + 1;
                    }
                }
            }
        }
        this.initialized |= 0x200;
    }

    private void findRings() {
        this.rings = this.mol.getSSSR();
        for (int i = 0; i < this.rings.length; ++i) {
            int n = this.rings[i][0];
            this.atoms[n] = this.atoms[n] | 2;
            int n2 = this.btab.getBondIndex(this.rings[i][0], this.rings[i][this.rings[i].length - 1]);
            this.bonds[n2] = this.bonds[n2] | 2;
            for (int j = 1; j < this.rings[i].length; ++j) {
                int n3 = this.rings[i][j];
                this.atoms[n3] = this.atoms[n3] | 2;
                int n4 = this.btab.getBondIndex(this.rings[i][j], this.rings[i][j - 1]);
                this.bonds[n4] = this.bonds[n4] | 2;
            }
        }
        this.initialized |= 2;
    }

    private void findRingSystems() {
        int i;
        if ((this.initialized & 0x200) == 0) {
            this.findRingConnections();
        }
        int[] systems = new int[this.rings.length];
        if (this.rings.length == 0) {
            this.ringSystems = new int[0][];
            this.initialized |= 0x400;
            return;
        }
        int c = 0;
        for (i = 0; i < this.ringConnections.length; ++i) {
            if (systems[i] == 0) {
                systems[i] = ++c;
            }
            for (int j = i + 1; j < this.ringConnections[i].length; ++j) {
                if (this.ringConnections[i][j] <= 0) continue;
                if (systems[j] == 0) {
                    systems[j] = systems[i];
                    continue;
                }
                int lo = systems[i] < systems[j] ? systems[i] : systems[j];
                int hi = systems[i] < systems[j] ? systems[j] : systems[i];
                for (int k = 0; k < systems.length; ++k) {
                    if (systems[k] != hi) continue;
                    systems[k] = lo;
                }
            }
        }
        c = 0;
        for (i = 0; i < systems.length; ++i) {
            if (c >= systems[i]) continue;
            c = systems[i];
        }
        this.ringSystems = new int[c][];
        for (int i2 = 0; i2 < c; ++i2) {
            int j;
            int d = 0;
            for (j = 0; j < systems.length; ++j) {
                if (systems[j] != i2 + 1) continue;
                ++d;
            }
            this.ringSystems[i2] = new int[d];
            d = 0;
            for (j = 0; j < systems.length; ++j) {
                if (systems[j] != i2 + 1) continue;
                this.ringSystems[i2][d] = j;
                ++d;
            }
        }
        this.initialized |= 0x400;
    }

    public int fusedAliphaticRingCount() {
        if ((this.initialized & 0x80) == 0) {
            this.findFusedAliphaticRings();
        }
        return this.fusedAliphaticRings.length;
    }

    public int fusedAliphaticRingCount(int size) {
        if ((this.initialized & 0x80) == 0) {
            this.findFusedAliphaticRings();
        }
        int c = 0;
        for (int i = 0; i < this.fusedAliphaticRings.length; ++i) {
            if (size != 0 && this.rings[this.fusedAliphaticRings[i]].length != size) continue;
            ++c;
        }
        return c;
    }

    public int[][] fusedAliphaticRings() {
        return this.fusedAliphaticRings(0);
    }

    public int[][] fusedAliphaticRings(int size) {
        int c = this.fusedAliphaticRingCount();
        if (c == 0) {
            return null;
        }
        int[][] result = new int[c][];
        c = 0;
        for (int i = 0; i < this.fusedAliphaticRings.length; ++i) {
            if (size != 0 && this.rings[this.fusedAliphaticRings[i]].length != size) continue;
            result[c] = (int[])this.rings[this.fusedAliphaticRings[i]].clone();
            ++c;
        }
        return result;
    }

    public int fusedAromaticRingCount() {
        if ((this.initialized & 0x100) == 0) {
            this.findFusedAromaticRings();
        }
        return this.fusedAromaticRings.length;
    }

    public int fusedAromaticRingCount(int size) {
        if ((this.initialized & 0x100) == 0) {
            this.findFusedAromaticRings();
        }
        int c = 0;
        for (int i = 0; i < this.fusedAromaticRings.length; ++i) {
            if (size != 0 && this.arings[this.fusedAromaticRings[i]].length != size) continue;
            ++c;
        }
        return c;
    }

    public int[][] fusedAromaticRings() {
        return this.fusedAromaticRings(0);
    }

    public int[][] fusedAromaticRings(int size) {
        int c = this.fusedAromaticRingCount();
        if (c == 0) {
            return null;
        }
        int[][] result = new int[c][];
        c = 0;
        for (int i = 0; i < this.fusedAromaticRings.length; ++i) {
            if (size != 0 && this.rings[this.fusedAromaticRings[i]].length != size) continue;
            result[c] = (int[])this.arings[this.fusedAromaticRings[i]].clone();
            ++c;
        }
        return result;
    }

    public int fusedRingCount() {
        if ((this.initialized & 0x40) == 0) {
            this.findFusedRings();
        }
        return this.fusedRings.length;
    }

    public int heteroaliphaticRingCount() {
        return this.heteroaliphaticRingCount(0);
    }

    public int heteroaliphaticRingCount(int size) {
        if ((this.initialized & 0x10) == 0) {
            this.findAliphaticRings();
        }
        int c = 0;
        block0: for (int i = 0; i < this.aliphaticRings.length; ++i) {
            if (size != 0 && this.aliphaticRings[i].length != size) continue;
            for (int j = 0; j < this.aliphaticRings[i].length; ++j) {
                if (this.mol.getAtom(this.aliphaticRings[i][j]).getAtno() == 6) continue;
                ++c;
                continue block0;
            }
        }
        return c;
    }

    public int[][] heteroaliphaticRings() {
        return this.heteroaliphaticRings(0);
    }

    public int[][] heteroaliphaticRings(int size) {
        int c = this.heteroaliphaticRingCount();
        if (c == 0) {
            return null;
        }
        int[][] result = new int[c][];
        block0: for (int i = 0; i < this.aliphaticRings.length; ++i) {
            if (size != 0 && this.aliphaticRings[i].length != size) continue;
            for (int j = 0; j < this.aliphaticRings[i].length; ++j) {
                if (this.mol.getAtom(this.aliphaticRings[i][j]).getAtno() == 6) continue;
                result[c] = (int[])this.aliphaticRings[i].clone();
                ++c;
                continue block0;
            }
        }
        return result;
    }

    public int heteroaromaticRingCount() {
        return this.heteroaromaticRingCount(0);
    }

    public int heteroaromaticRingCount(int size) {
        if ((this.initialized & 8) == 0) {
            this.findAromaticRings();
        }
        int c = 0;
        block0: for (int i = 0; i < this.aromaticRings.length; ++i) {
            if (size != 0 && this.aromaticRings[i].length != size) continue;
            for (int j = 0; j < this.aromaticRings[i].length; ++j) {
                if (this.mol.getAtom(this.aromaticRings[i][j]).getAtno() == 6) continue;
                ++c;
                continue block0;
            }
        }
        return c;
    }

    public int[][] heteroaromaticRings() {
        return this.heteroaromaticRings(0);
    }

    public int[][] heteroaromaticRings(int size) {
        int c = this.heteroaromaticRingCount();
        if (c == 0) {
            return null;
        }
        int[][] result = new int[c][];
        block0: for (int i = 0; i < this.aromaticRings.length; ++i) {
            if (size != 0 && this.aromaticRings[i].length != size) continue;
            for (int j = 0; j < this.aromaticRings[i].length; ++j) {
                if (this.mol.getAtom(this.aromaticRings[i][j]).getAtno() == 6) continue;
                result[c] = (int[])this.aromaticRings[i].clone();
                ++c;
                continue block0;
            }
        }
        return result;
    }

    public int heteroRingCount() {
        return this.heteroRingCount(0);
    }

    public int heteroRingCount(int size) {
        if ((this.initialized & 0x800) == 0) {
            this.findHeteroRings();
        }
        int c = 0;
        for (int i = 0; i < this.heteroRings.length; ++i) {
            if (size != 0 && this.rings[this.heteroRings[i]].length != size) continue;
            ++c;
        }
        return c;
    }

    public int[][] heteroRings() {
        return this.heteroRings(0);
    }

    public int[][] heteroRings(int size) {
        if (this.heteroRingCount(size) == 0) {
            return null;
        }
        int[][] result = new int[this.heteroRingCount(size)][];
        int j = 0;
        for (int i = 0; i < this.heteroRings.length; ++i) {
            if (size != 0 && this.rings[this.heteroRings[i]].length != size) continue;
            result[j] = (int[])this.rings[this.heteroRings[i]].clone();
            ++j;
        }
        return result;
    }

    public boolean isAliphaticAtom(int a) {
        return !this.isAromaticAtom(a);
    }

    public boolean isAromaticAtom(int a) {
        if ((this.initialized & 4) == 0) {
            this.findAromatic();
        }
        return (this.atoms[a] & 4) == 4;
    }

    public boolean isAliphaticBond(int b) {
        return !this.isAromaticBond(b);
    }

    public boolean isAromaticBond(int b) {
        if ((this.initialized & 4) == 0) {
            this.findAromatic();
        }
        return (this.bonds[b] & 4) == 4;
    }

    public boolean isChainAtom(int a) {
        return !this.isRingAtom(a);
    }

    public boolean isChainBond(int b) {
        return !this.isRingBond(b);
    }

    public boolean isRingAtom(int a) {
        if ((this.initialized & 2) == 0) {
            this.findRings();
        }
        return (this.atoms[a] & 2) == 2;
    }

    public boolean isRingBond(int b) {
        if ((this.initialized & 2) == 0) {
            this.findRings();
        }
        return (this.bonds[b] & 2) == 2;
    }

    public int[] largestRing() {
        if ((this.initialized & 2) == 0) {
            this.findRings();
        }
        if (this.rings.length == 0) {
            return null;
        }
        int s = 0;
        int j = 0;
        for (int i = 0; i < this.rings.length; ++i) {
            if (s >= this.rings[i].length) continue;
            s = this.rings[i].length;
            j = i;
        }
        return (int[])this.rings[j].clone();
    }

    public int largestRingSize() {
        if ((this.initialized & 2) == 0) {
            this.findRings();
        }
        int s = 0;
        for (int i = 0; i < this.rings.length; ++i) {
            if (s >= this.rings[i].length) continue;
            s = this.rings[i].length;
        }
        return s;
    }

    public int largestRingSizeOfAtom(int a) {
        if ((this.initialized & 2) == 0) {
            this.findRings();
        }
        int s = 0;
        for (int i = 0; i < this.rings.length; ++i) {
            for (int j = 0; j < this.rings[i].length; ++j) {
                if (this.rings[i][j] != a || s >= this.rings[i].length) continue;
                s = this.rings[i].length;
            }
        }
        return s;
    }

    public int[] largestRingSystem() {
        if ((this.initialized & 0x400) == 0) {
            this.findRingSystems();
        }
        if (this.ringSystems.length == 0) {
            return null;
        }
        int s = 0;
        int j = 0;
        for (int i = 0; i < this.ringSystems.length; ++i) {
            if (s >= this.ringSystems[i].length) continue;
            s = this.ringSystems[i].length;
            j = i;
        }
        return (int[])this.ringSystems[j].clone();
    }

    public int largestRingSystemSize() {
        if ((this.initialized & 0x400) == 0) {
            this.findRingSystems();
        }
        int s = 0;
        for (int i = 0; i < this.ringSystems.length; ++i) {
            if (s >= this.ringSystems[i].length) continue;
            s = this.ringSystems[i].length;
        }
        return s;
    }

    public int ringAtomCount() {
        if ((this.initialized & 2) == 0) {
            this.findRings();
        }
        int c = 0;
        for (int i = 0; i < this.atoms.length; ++i) {
            if ((this.atoms[i] & 2) != 2) continue;
            ++c;
        }
        return c;
    }

    public int ringBondCount() {
        if ((this.initialized & 2) == 0) {
            this.findRings();
        }
        int c = 0;
        for (int i = 0; i < this.bonds.length; ++i) {
            if ((this.bonds[i] & 2) != 2) continue;
            ++c;
        }
        return c;
    }

    public int ringCount() {
        if ((this.initialized & 2) == 0) {
            this.findRings();
        }
        return this.rings.length;
    }

    public int ringCount(int size) {
        if ((this.initialized & 2) == 0) {
            this.findRings();
        }
        int c = 0;
        for (int i = 0; i < this.rings.length; ++i) {
            if (this.rings[i].length != size) continue;
            ++c;
        }
        return c;
    }

    public int ringCountOfAtom(int a) {
        if ((this.initialized & 2) == 0) {
            this.findRings();
        }
        int c = 0;
        block0: for (int i = 0; i < this.rings.length; ++i) {
            for (int j = 0; j < this.rings[i].length; ++j) {
                if (this.rings[i][j] != a) continue;
                ++c;
                continue block0;
            }
        }
        return c;
    }

    public int[][] rings() {
        if ((this.initialized & 2) == 0) {
            this.findRings();
        }
        if (this.rings.length == 0) {
            return null;
        }
        return (int[][])this.rings.clone();
    }

    public int[][] rings(int size) {
        int c = this.ringCount(size);
        if (c == 0) {
            return null;
        }
        int[][] result = new int[c][];
        int j = 0;
        for (int i = 0; i < this.rings.length; ++i) {
            if (this.rings[i].length != size) continue;
            result[j] = (int[])this.rings[i].clone();
            ++j;
        }
        return result;
    }

    public int ringSystemCount() {
        if ((this.initialized & 0x400) == 0) {
            this.findRingSystems();
        }
        return this.ringSystems.length;
    }

    public int ringSystemCount(int size) {
        if ((this.initialized & 0x400) == 0) {
            this.findRingSystems();
        }
        int c = 0;
        for (int i = 0; i < this.ringSystems.length; ++i) {
            if (this.ringSystems[i].length != size) continue;
            ++c;
        }
        return c;
    }

    public int[][] ringSystems() {
        if ((this.initialized & 0x400) == 0) {
            this.findRingSystems();
        }
        if (this.ringSystems.length == 0) {
            return null;
        }
        return (int[][])this.ringSystems.clone();
    }

    public int[][] ringSystems(int size) {
        int c = this.ringSystemCount(size);
        if (c == 0) {
            return null;
        }
        int[][] result = new int[c][];
        int j = 0;
        for (int i = 0; i < this.ringSystems.length; ++i) {
            if (this.ringSystems[i].length != size) continue;
            result[j] = (int[])this.ringSystems[i].clone();
            ++j;
        }
        return result;
    }

    public int[] smallestRing() {
        if ((this.initialized & 2) == 0) {
            this.findRings();
        }
        if (this.rings.length == 0) {
            return null;
        }
        int s = 0;
        int j = 0;
        for (int i = 0; i < this.rings.length; ++i) {
            if (s != 0 && s <= this.rings[i].length) continue;
            s = this.rings[i].length;
            j = i;
        }
        return this.rings[j];
    }

    public int smallestRingSize() {
        if ((this.initialized & 2) == 0) {
            this.findRings();
        }
        int s = 0;
        for (int i = 0; i < this.rings.length; ++i) {
            if (s != 0 && s <= this.rings[i].length) continue;
            s = this.rings[i].length;
        }
        return s;
    }

    public int[] smallestRingSystem() {
        if ((this.initialized & 0x400) == 0) {
            this.findRingSystems();
        }
        if (this.ringSystems.length == 0) {
            return null;
        }
        int s = 0;
        int j = 0;
        for (int i = 0; i < this.ringSystems.length; ++i) {
            if (s != 0 && s <= this.ringSystems[i].length) continue;
            s = this.ringSystems[i].length;
            j = i;
        }
        return this.ringSystems[j];
    }

    public int smallestRingSystemSize() {
        if ((this.initialized & 0x400) == 0) {
            this.findRingSystems();
        }
        int s = 0;
        for (int i = 0; i < this.ringSystems.length; ++i) {
            if (s != 0 && s <= this.ringSystems[i].length) continue;
            s = this.ringSystems[i].length;
        }
        return s;
    }

    public int smallestRingSizeOfAtom(int a) {
        if ((this.initialized & 2) == 0) {
            this.findRings();
        }
        int s = 0;
        for (int i = 0; i < this.rings.length; ++i) {
            for (int j = 0; j < this.rings[i].length; ++j) {
                if (this.rings[i][j] != a || s != 0 && s <= this.rings[i].length) continue;
                s = this.rings[i].length;
            }
        }
        return s;
    }

    @Override
    public void setLicenseEnvironment(String env) {
        this.licenseEnvironment = env;
    }

    @Override
    public boolean isLicensed() {
        return LicenseHandler.getInstance().isLicensed("Geometry Plugin Group", this.licenseEnvironment);
    }

    private void checkLicense() throws LicenseException {
        LicenseHandler.getInstance().checkLicense("Geometry Plugin Group", this.licenseEnvironment);
    }
}

