/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.calculations;

import chemaxon.struc.Molecule;
import java.util.ArrayList;

public class RingAnalyzer {
    private Molecule molecule;
    private boolean[] isArom;
    private int arCount = -1;
    private int[][] nonAring;
    private boolean[] isInRing;
    private int[][] aAtoms;
    private int aromatizationType;
    private int multiRing;

    public RingAnalyzer(Molecule molecule, int aromatizationType) {
        this.molecule = molecule.cloneMoleculeWithDocument();
        this.aromatizationType = aromatizationType;
    }

    private void setIsArom() {
        this.isArom = new boolean[this.molecule.getAtomCount()];
        int[][] aatoms = this.getAromaticRings();
        this.arCount = 0;
        for (int i = 0; i < aatoms.length; ++i) {
            for (int j = 0; j < aatoms[i].length; ++j) {
                if (!this.isArom[aatoms[i][j]]) {
                    ++this.arCount;
                }
                this.isArom[aatoms[i][j]] = true;
            }
        }
    }

    public boolean isAra(int atomIndex) {
        if (atomIndex < 0 || atomIndex >= this.molecule.getAtomCount()) {
            return false;
        }
        if (this.isArom == null) {
            this.setIsArom();
        }
        return this.isArom[atomIndex];
    }

    public int getAromaticAtomCount() {
        if (this.arCount == -1) {
            this.setIsArom();
        }
        return this.arCount;
    }

    public int[][] getNonAromaticRings() {
        if (this.nonAring == null) {
            int at = this.aromatizationType == -1 ? 1 : 2;
            this.nonAring = this.molecule.getAromaticAndAliphaticRings(at, false, false, 18, 1000)[1];
        }
        return this.nonAring;
    }

    public boolean[] isInRing() {
        if (this.isInRing == null) {
            this.isInRing = new boolean[this.molecule.getAtomCount()];
            for (int i = 0; i < this.getNonAromaticRings().length; ++i) {
                for (int j = 0; j < this.getNonAromaticRings()[i].length; ++j) {
                    this.isInRing[this.getNonAromaticRings()[i][j]] = true;
                }
            }
        }
        return this.isInRing;
    }

    public int getLargestRingIndex(int atomIndex) {
        int size = 0;
        int rInd = -1;
        for (int i = 0; i < this.getNonAromaticRings().length; ++i) {
            for (int j = 0; j < this.nonAring[i].length; ++j) {
                int ra = this.nonAring[i][j];
                if (ra != atomIndex || this.nonAring[i].length <= size) continue;
                size = this.nonAring[i].length;
                rInd = i;
            }
        }
        return rInd;
    }

    public int getSmallestRingIndex(int atomIndex) {
        int size = 1000;
        int rInd = -1;
        this.multiRing = 0;
        for (int i = 0; i < this.getNonAromaticRings().length; ++i) {
            for (int j = 0; j < this.nonAring[i].length; ++j) {
                int ra = this.nonAring[i][j];
                if (ra != atomIndex || this.nonAring[i].length >= size) continue;
                size = this.nonAring[i].length;
                rInd = i;
                ++this.multiRing;
            }
        }
        return rInd;
    }

    public int getSmallestExclusiveRingIndex(int atomIndex, int index) {
        int size = 1000;
        int rInd = -1;
        for (int i = 0; i < this.getNonAromaticRings().length; ++i) {
            for (int j = 0; j < this.nonAring[i].length; ++j) {
                int ra = this.nonAring[i][j];
                if (ra != atomIndex || rInd == index || this.nonAring[i].length >= size) continue;
                size = this.nonAring[i].length;
                rInd = i;
            }
        }
        return rInd;
    }

    public int getMultiRingCount() {
        return this.multiRing;
    }

    public int findSmallestAraRing(int atom) {
        for (int i = 0; i < this.getAromaticRings().length; ++i) {
            for (int j = 0; j < this.aAtoms[i].length; ++j) {
                if (this.aAtoms[i][j] != atom) continue;
                return i;
            }
        }
        return -1;
    }

    public int getLargestAraRingIndex(int atom) {
        for (int i = this.getAromaticRings().length - 1; i >= 0; --i) {
            for (int j = 0; j < this.aAtoms[i].length; ++j) {
                if (this.aAtoms[i][j] != atom) continue;
                return i;
            }
        }
        return -1;
    }

    public int[][] getAromaticRings() {
        if (this.aAtoms == null) {
            int at;
            int s = 18;
            int n = at = this.aromatizationType == -1 ? 1 : 2;
            if (at == 2) {
                s = 36;
            }
            int[][] aring = this.molecule.getAromaticAndAliphaticRings(at, true, false, s, 1000)[0];
            int aRingNumber = aring.length;
            this.aAtoms = new int[aRingNumber][];
            ArrayList[] rings = new ArrayList[this.molecule.getAtomCount() + 1];
            for (int i = 0; i < aring.length; ++i) {
                int ringLen = aring[i].length;
                if (rings[ringLen] == null) {
                    rings[ringLen] = new ArrayList();
                }
                rings[ringLen].add(aring[i]);
            }
            int index = 0;
            for (int i = 0; i < rings.length; ++i) {
                if (rings[i] == null) continue;
                while (!rings[i].isEmpty()) {
                    this.aAtoms[index++] = (int[])rings[i].remove(0);
                }
            }
        }
        return this.aAtoms;
    }
}

