/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.calculations;

import chemaxon.calculations.Ring;
import chemaxon.calculations.stereo.Stereochemistry;
import chemaxon.core.calculations.ElementalAnalysisCalc;
import chemaxon.core.util.BondTable;
import chemaxon.license.Licensable;
import chemaxon.license.LicenseException;
import chemaxon.license.LicenseHandler;
import chemaxon.struc.MoleculeGraph;
import chemaxon.struc.PeriodicSystem;

public class TopologyAnalyser
implements Licensable {
    private String licenseEnvironment = "";
    Ring ring = new Ring();
    Stereochemistry stereo = new Stereochemistry();
    private static final int BONDTYPEMASK = 7;
    private static final int HYDROGENMASK = 32;
    private static final int ROTATABLEMASK = 64;
    private static final int TERMINALMASK = 128;
    private static final int BARREDMASK = 256;
    private static final int BIARYLMASK = 512;
    private static final int GRAPHINVARIANTMASK = 1024;
    private static final int ATOMTABLEMASK = 2048;
    private MoleculeGraph mol;
    private int initialized = 0;
    private int[] bonds;
    private int[] atoms;
    private BondTable btab;
    private int[][] ctab;
    private int[][] dtab;
    private int explicitHydrogenCount;
    private int[] graphInvariant;
    private boolean connected = false;

    public MoleculeGraph getMolecule() {
        return this.mol;
    }

    public void setMolecule(MoleculeGraph mol) {
        this.checkLicense();
        this.setMolecule(mol, 2);
    }

    public void setMolecule(MoleculeGraph mol, int aromatizationMode) {
        this.mol = mol;
        this.initialized = 0;
        this.atoms = new int[mol.getAtomCount()];
        this.bonds = new int[mol.getBondCount()];
        this.btab = mol.getBondTable();
        this.dtab = null;
        this.ring.setMolecule(mol, aromatizationMode);
        this.stereo.setMolecule(mol);
    }

    @Deprecated
    public int aliphaticAtomCount() {
        return this.ring.aliphaticAtomCount();
    }

    @Deprecated
    public int aliphaticBondCount() {
        return this.ring.aliphaticBondCount();
    }

    @Deprecated
    public int aliphaticRingCount() {
        return this.ring.aliphaticRingCount();
    }

    @Deprecated
    public int aliphaticRingCount(int size) {
        return this.ring.aliphaticRingCount(size);
    }

    @Deprecated
    public int[][] aliphaticRings() {
        return this.ring.aliphaticRings();
    }

    @Deprecated
    public int[][] aliphaticRings(int size) {
        return this.ring.aliphaticRings(size);
    }

    @Deprecated
    public int aromaticAtomCount() {
        return this.ring.aromaticAtomCount();
    }

    @Deprecated
    public int aromaticBondCount() {
        return this.ring.aromaticBondCount();
    }

    @Deprecated
    public int aromaticRingCount() {
        return this.ring.aromaticRingCount();
    }

    @Deprecated
    public int aromaticRingCount(int size) {
        return this.ring.aromaticRingCount(size);
    }

    @Deprecated
    public int[][] aromaticRings() {
        return this.ring.aromaticRings();
    }

    @Deprecated
    public int[][] aromaticRings(int size) {
        return this.ring.aromaticRings();
    }

    @Deprecated
    public int asymmetricAtomCount() {
        return this.stereo.asymmetricAtomCount();
    }

    @Deprecated
    public int[] asymmetricAtoms() {
        return this.stereo.asymmetricAtoms();
    }

    public int atomCount() {
        ElementalAnalysisCalc ea = new ElementalAnalysisCalc();
        ea.setMolecule(this.mol);
        return ea.atomCount();
    }

    private int[][] atomTable() {
        if ((this.initialized & 0x800) == 0) {
            this.ctab = this.mol.getCtab();
            this.initialized |= 0x800;
        }
        return this.ctab;
    }

    public double balabanIndex() {
        if (this.dtab == null) {
            this.distanceMatrix();
        }
        if (!this.connected) {
            return Double.POSITIVE_INFINITY;
        }
        double b = 0.0;
        for (int i = 0; i < this.dtab.length; ++i) {
            for (int j = i + 1; j < this.dtab[i].length; ++j) {
                if (this.dtab[i][j] != 1) continue;
                b += Math.pow(this.distanceDegree(i) * this.distanceDegree(j), -0.5);
            }
        }
        b = (double)((this.bonds.length - this.explicitHydrogenCount) / (this.cyclomaticNumber() + 1)) * b;
        return b;
    }

    public int bondCount() {
        return this.bonds.length + this.mol.getImplicitHcount();
    }

    public int bondType(int b) {
        if ((this.initialized & 7) == 0) {
            this.findBondTypes();
        }
        return this.bonds[b] & 7;
    }

    @Deprecated
    public int carboaliphaticRingCount() {
        return this.ring.carboaliphaticRingCount();
    }

    @Deprecated
    public int carboaromaticRingCount() {
        return this.ring.carboaromaticRingCount();
    }

    @Deprecated
    public int carboRingCount() {
        return this.ring.carboRingCount();
    }

    @Deprecated
    public int carboRingCount(int size) {
        return this.ring.carboRingCount(size);
    }

    @Deprecated
    public int[][] carboRings() {
        return this.ring.carboRings();
    }

    @Deprecated
    public int[][] carboRings(int size) {
        return this.ring.carboRings(size);
    }

    @Deprecated
    public int chainAtomCount() {
        return this.ring.chainAtomCount();
    }

    @Deprecated
    public int chainBondCount() {
        return this.ring.chainBondCount();
    }

    @Deprecated
    public int chiralCenterCount() {
        return this.stereo.chiralCenterCount();
    }

    @Deprecated
    public int[] chiralCenters() {
        return this.stereo.chiralCenters();
    }

    public int cyclomaticNumber() {
        return this.bonds.length - this.atoms.length + 1;
    }

    public int distanceCount(int a, int d) {
        if (this.dtab == null) {
            this.distanceMatrix();
        }
        int c = 0;
        for (int i = 0; i < this.dtab.length; ++i) {
            if (this.dtab[a][i] != d) continue;
            ++c;
        }
        return c;
    }

    public int distanceDegree(int a) {
        if (this.dtab == null) {
            this.distanceMatrix();
        }
        if (!this.connected) {
            return Integer.MAX_VALUE;
        }
        int d = 0;
        for (int i = 0; i < this.dtab.length; ++i) {
            d += this.dtab[a][i];
        }
        return d;
    }

    private void distanceMatrix() {
        int j;
        int i;
        if ((this.initialized & 0x20) == 0) {
            this.findHydrogens();
        }
        int c = this.btab.getAtomCount();
        this.dtab = new int[c][c];
        int[][] pred = new int[c][c];
        for (i = 0; i < c; ++i) {
            for (j = i + 1; j < c; ++j) {
                if (this.btab.getBondIndex(i, j) != -1) {
                    this.dtab[i][j] = 1;
                    this.dtab[j][i] = 1;
                    pred[i][j] = i;
                    pred[j][i] = j;
                    continue;
                }
                this.dtab[i][j] = c;
                this.dtab[j][i] = c;
                pred[i][j] = -1;
                pred[j][i] = -1;
            }
        }
        for (int k = 0; k < c; ++k) {
            for (j = 0; j < c; ++j) {
                for (int i2 = 0; i2 < c; ++i2) {
                    int s = this.dtab[i2][k] + this.dtab[k][j];
                    if (s >= this.dtab[i2][j]) continue;
                    this.dtab[i2][j] = s;
                    pred[i2][j] = pred[k][j];
                }
            }
        }
        this.connected = true;
        for (i = 0; i < c; ++i) {
            if ((this.atoms[i] & 0x20) == 32) {
                for (j = 0; j < c; ++j) {
                    this.dtab[i][j] = 0;
                    this.dtab[j][i] = 0;
                }
            }
            for (j = i + 1; j < c; ++j) {
                if (this.dtab[i][j] != c) continue;
                this.connected = false;
                this.dtab[i][j] = Integer.MAX_VALUE;
                this.dtab[j][i] = Integer.MAX_VALUE;
            }
        }
    }

    public int eccentricity(int a) {
        if (this.dtab == null) {
            this.distanceMatrix();
        }
        if (!this.connected) {
            return Integer.MAX_VALUE;
        }
        int e = 0;
        for (int i = 0; i < this.dtab.length; ++i) {
            if (this.dtab[a][i] <= e) continue;
            e = this.dtab[a][i];
        }
        return e;
    }

    private void findBarredGroups() {
        if ((this.initialized & 7) == 0) {
            this.findBondTypes();
        }
        if ((this.initialized & 0x20) == 0) {
            this.findHydrogens();
        }
        for (int i = 0; i < this.atoms.length; ++i) {
            if (this.mol.getAtom(i).getAtno() != 7) continue;
            for (int j = 0; j < this.btab.getAtomCount(); ++j) {
                if (this.btab.getBondIndex(i, j) <= -1 || (this.bonds[this.btab.getBondIndex(i, j)] & 7) != 1 || this.mol.getAtom(j).getAtno() != 6 && this.mol.getAtom(j).getAtno() != 16) continue;
                for (int k = 0; k < this.btab.getAtomCount(); ++k) {
                    if (this.btab.getBondIndex(j, k) <= -1 || (this.bonds[this.btab.getBondIndex(j, k)] & 7) != 2 || this.mol.getAtom(k).getAtno() != 7 && this.mol.getAtom(k).getAtno() != 8 && this.mol.getAtom(k).getAtno() != 16) continue;
                    int n = i;
                    this.atoms[n] = this.atoms[n] | 0x100;
                    int n2 = j;
                    this.atoms[n2] = this.atoms[n2] | 0x100;
                    int n3 = k;
                    this.atoms[n3] = this.atoms[n3] | 0x100;
                    int n4 = this.btab.getBondIndex(i, j);
                    this.bonds[n4] = this.bonds[n4] | 0x100;
                    int n5 = this.btab.getBondIndex(j, k);
                    this.bonds[n5] = this.bonds[n5] | 0x100;
                }
            }
        }
        this.initialized |= 0x100;
    }

    private void findBondTypes() {
        for (int i = 0; i < this.bonds.length; ++i) {
            if (this.ring.isAromaticBond(i)) {
                int n = i;
                this.bonds[n] = this.bonds[n] | 4;
                continue;
            }
            int n = i;
            this.bonds[n] = this.bonds[n] | 7 & this.mol.getBond(i).getType();
        }
        this.initialized |= 7;
    }

    private void findHinderedBiarylBridgeBonds() {
        if ((this.initialized & 7) == 0) {
            this.findBondTypes();
        }
        if ((this.initialized & 0x20) == 0) {
            this.findHydrogens();
        }
        for (int i = 0; i < this.btab.getAtomCount(); ++i) {
            for (int j = i + 1; j < this.btab.getAtomCount(); ++j) {
                if (this.btab.getBondIndex(i, j) == -1 || !this.ring.isAromaticAtom(i) || !this.ring.isAromaticAtom(j) || (this.bonds[this.btab.getBondIndex(i, j)] & 7) != 1) continue;
                int c = 0;
                for (int k = 0; k < this.btab.getAtomCount(); ++k) {
                    int m;
                    int clocal;
                    if (k == i || k == j) continue;
                    if (this.btab.getBondIndex(i, k) != -1) {
                        clocal = 0;
                        for (m = 0; m < this.btab.getAtomCount(); ++m) {
                            if (m == i || this.btab.getBondIndex(k, m) == -1 || (this.bonds[this.btab.getBondIndex(k, m)] & 0x20) != 0 || ++clocal != 2) continue;
                            ++c;
                            break;
                        }
                    }
                    if (c < 3 && this.btab.getBondIndex(j, k) != -1) {
                        clocal = 0;
                        for (m = 0; m < this.btab.getAtomCount(); ++m) {
                            if (m == j || this.btab.getBondIndex(k, m) == -1 || (this.bonds[this.btab.getBondIndex(k, m)] & 0x20) != 0 || ++clocal != 2) continue;
                            ++c;
                            break;
                        }
                    }
                    if (c <= 2) continue;
                    int n = i;
                    this.atoms[n] = this.atoms[n] | 0x200;
                    int n2 = j;
                    this.atoms[n2] = this.atoms[n2] | 0x200;
                    int n3 = this.btab.getBondIndex(i, j);
                    this.bonds[n3] = this.bonds[n3] | 0x200;
                }
            }
        }
        this.initialized |= 0x200;
    }

    private void findHydrogens() {
        this.explicitHydrogenCount = 0;
        block0: for (int i = 0; i < this.atoms.length; ++i) {
            if (this.mol.getAtom(i).getAtno() != 1) continue;
            ++this.explicitHydrogenCount;
            int n = i;
            this.atoms[n] = this.atoms[n] | 0x20;
            for (int j = 0; j < this.btab.getAtomCount(); ++j) {
                if (this.btab.getBondIndex(i, j) == -1) continue;
                int n2 = this.btab.getBondIndex(i, j);
                this.bonds[n2] = this.bonds[n2] | 0x20;
                continue block0;
            }
        }
    }

    private void findRotatableBonds() {
        if ((this.initialized & 7) == 0) {
            this.findBondTypes();
        }
        if ((this.initialized & 0x80) == 0) {
            this.findTerminalBonds();
        }
        if ((this.initialized & 0x100) == 0) {
            this.findBarredGroups();
        }
        if ((this.initialized & 0x200) == 0) {
            this.findHinderedBiarylBridgeBonds();
        }
        for (int i = 0; i < this.bonds.length; ++i) {
            if ((this.bonds[i] & 7) != 1 || this.ring.isRingBond(i) || (this.bonds[i] & 0x80) != 0 || (this.bonds[i] & 0x100) != 0 || (this.bonds[i] & 0x200) != 0) continue;
            int n = i;
            this.bonds[n] = this.bonds[n] | 0x40;
        }
        int c = this.btab.getAtomCount();
        for (int i = 0; i < c; ++i) {
            for (int j = 0; j < i; ++j) {
                if (this.btab.getBondIndex(i, j) == -1 || (this.bonds[this.btab.getBondIndex(i, j)] & 7) != 3 || (this.bonds[this.btab.getBondIndex(i, j)] & 0x80) == 0) continue;
                for (int k = 0; k < c; ++k) {
                    if (this.btab.getBondIndex(i, k) != -1) {
                        this.bonds[this.btab.getBondIndex((int)i, (int)k)] = this.bonds[this.btab.getBondIndex(i, k)] & 0xFFFFFFBF;
                    }
                    if (this.btab.getBondIndex(j, k) == -1) continue;
                    this.bonds[this.btab.getBondIndex((int)j, (int)k)] = this.bonds[this.btab.getBondIndex(j, k)] & 0xFFFFFFBF;
                }
            }
        }
        this.initialized |= 0x40;
    }

    private void findTerminalBonds() {
        for (int i = 0; i < this.bonds.length; ++i) {
            if (this.mol.getBond(i).getAtom1().getBondCount() != 1 && this.mol.getBond(i).getAtom2().getBondCount() != 1 && this.mol.getBond(i).getAtom1().getBondCount() - this.mol.getBond(i).getAtom1().getExplicitHcount() >= 2 && this.mol.getBond(i).getAtom2().getBondCount() - this.mol.getBond(i).getAtom2().getExplicitHcount() >= 2) continue;
            int n = i;
            this.bonds[n] = this.bonds[n] | 0x80;
        }
        this.initialized |= 0x80;
    }

    public int fragmentCount() {
        return this.mol.getFragCount(1);
    }

    @Deprecated
    public int fusedAliphaticRingCount() {
        return this.ring.fusedAliphaticRingCount();
    }

    @Deprecated
    public int fusedAliphaticRingCount(int size) {
        return this.ring.fusedAliphaticRingCount(size);
    }

    @Deprecated
    public int[][] fusedAliphaticRings() {
        return this.ring.fusedAliphaticRings();
    }

    @Deprecated
    public int[][] fusedAliphaticRings(int size) {
        return this.ring.fusedAliphaticRings(size);
    }

    @Deprecated
    public int fusedAromaticRingCount() {
        return this.ring.fusedAromaticRingCount();
    }

    @Deprecated
    public int fusedAromaticRingCount(int size) {
        return this.ring.fusedAliphaticRingCount(size);
    }

    @Deprecated
    public int[][] fusedAromaticRings() {
        return this.ring.fusedAromaticRings();
    }

    @Deprecated
    public int[][] fusedAromaticRings(int size) {
        return this.ring.fusedAromaticRings(size);
    }

    @Deprecated
    public int fusedRingCount() {
        return this.ring.fusedRingCount();
    }

    public int[] graphInvariant() {
        if ((this.initialized & 0x400) == 0) {
            this.graphInvariant = new int[this.atoms.length];
            this.mol.calcDehydrogenizedGrinv(this.graphInvariant);
            this.initialized |= 0x400;
        }
        return this.graphInvariant;
    }

    public double hararyIndex() {
        if (this.dtab == null) {
            this.distanceMatrix();
        }
        if (!this.connected) {
            return Double.POSITIVE_INFINITY;
        }
        double h = 0.0;
        for (int i = 0; i < this.dtab.length; ++i) {
            for (int j = i + 1; j < this.dtab[i].length; ++j) {
                if (this.dtab[i][j] == 0) continue;
                h += 1.0 / (double)this.dtab[i][j];
            }
        }
        return h;
    }

    @Deprecated
    public int heteroaliphaticRingCount() {
        return this.ring.heteroaliphaticRingCount();
    }

    @Deprecated
    public int heteroaliphaticRingCount(int size) {
        return this.ring.heteroaliphaticRingCount(size);
    }

    @Deprecated
    public int[][] heteroaliphaticRings() {
        return this.ring.heteroaromaticRings();
    }

    @Deprecated
    public int[][] heteroaliphaticRings(int size) {
        return this.ring.heteroaliphaticRings(size);
    }

    @Deprecated
    public int heteroaromaticRingCount() {
        return this.ring.heteroaromaticRingCount();
    }

    @Deprecated
    public int heteroaromaticRingCount(int size) {
        return this.ring.heteroaromaticRingCount(size);
    }

    @Deprecated
    public int[][] heteroaromaticRings() {
        return this.ring.heteroaromaticRings();
    }

    @Deprecated
    public int[][] heteroaromaticRings(int size) {
        return this.ring.heteroaromaticRings(size);
    }

    @Deprecated
    public int heteroRingCount() {
        return this.ring.heteroRingCount();
    }

    @Deprecated
    public int heteroRingCount(int size) {
        return this.ring.heteroRingCount(size);
    }

    @Deprecated
    public int[][] heteroRings() {
        return this.ring.heteroRings();
    }

    @Deprecated
    public int[][] heteroRings(int size) {
        return this.ring.heteroRings(size);
    }

    public int hyperWienerIndex() {
        if (this.dtab == null) {
            this.distanceMatrix();
        }
        if (!this.connected) {
            return Integer.MAX_VALUE;
        }
        int ww = 0;
        for (int i = 0; i < this.dtab.length; ++i) {
            for (int j = i + 1; j < this.dtab[i].length; ++j) {
                ww += this.dtab[i][j] + this.dtab[i][j] * this.dtab[i][j];
            }
        }
        return ww / 2;
    }

    @Deprecated
    public boolean isAliphaticAtom(int a) {
        return this.ring.isAliphaticAtom(a);
    }

    @Deprecated
    public boolean isAromaticAtom(int a) {
        return this.ring.isAromaticAtom(a);
    }

    @Deprecated
    public boolean isAsymmetricAtom(int a) {
        return this.stereo.isAsymmetricAtom(a);
    }

    public boolean isBarredAtom(int a) {
        if ((this.initialized & 0x100) == 0) {
            this.findBarredGroups();
        }
        return (this.atoms[a] & 0x100) == 256;
    }

    @Deprecated
    public boolean isChainAtom(int a) {
        return this.ring.isChainAtom(a);
    }

    @Deprecated
    public boolean isChainBond(int b) {
        return this.ring.isChainBond(b);
    }

    @Deprecated
    public boolean isChiral() {
        return this.stereo.isChiral();
    }

    @Deprecated
    public boolean isChiralCenter(int a) {
        return this.stereo.isChiralCenter(a);
    }

    public boolean isConnected() {
        if (this.dtab == null) {
            this.distanceMatrix();
        }
        return this.connected;
    }

    public boolean isConnected(int atom1, int atom2) {
        if (this.dtab == null) {
            this.distanceMatrix();
        }
        return this.dtab[atom1][atom2] != Integer.MAX_VALUE;
    }

    public boolean isHinderedBiarylBridgeBond(int b) {
        if ((this.initialized & 0x200) == 0) {
            this.findHinderedBiarylBridgeBonds();
        }
        return (this.bonds[b] & 0x200) == 512;
    }

    @Deprecated
    public boolean isRingAtom(int a) {
        return this.ring.isRingAtom(a);
    }

    @Deprecated
    public boolean isRingBond(int b) {
        return this.ring.isRingBond(b);
    }

    public boolean isRotatableBond(int b) {
        if ((this.initialized & 0x40) == 0) {
            this.findRotatableBonds();
        }
        return (this.bonds[b] & 0x40) == 64;
    }

    @Deprecated
    public int[] largestRing() {
        return this.ring.largestRing();
    }

    @Deprecated
    public int largestRingSize() {
        return this.ring.largestRingSize();
    }

    @Deprecated
    public int largestRingSizeOfAtom(int a) {
        return this.ring.largestRingSizeOfAtom(a);
    }

    @Deprecated
    public int[] largestRingSystem() {
        return this.ring.largestRingSystem();
    }

    @Deprecated
    public int largestRingSystemSize() {
        return this.ring.largestRingSystemSize();
    }

    public int plattIndex() {
        this.atomTable();
        int p = 0;
        for (int i = 0; i < this.ctab.length; ++i) {
            for (int j = 0; j < this.ctab[i].length; ++j) {
                if (i >= this.ctab[i][j]) continue;
                p += this.ctab[i].length + this.ctab[this.ctab[i][j]].length - 2;
            }
        }
        return p;
    }

    public double randicIndex() {
        this.atomTable();
        double r = 0.0;
        for (int i = 0; i < this.ctab.length; ++i) {
            for (int j = 0; j < this.ctab[i].length; ++j) {
                if (i >= this.ctab[i][j]) continue;
                r += Math.sqrt(1.0 / (double)(this.ctab[i].length * this.ctab[this.ctab[i][j]].length));
            }
        }
        return r;
    }

    @Deprecated
    public int ringAtomCount() {
        return this.ring.ringAtomCount();
    }

    @Deprecated
    public int ringBondCount() {
        return this.ring.ringBondCount();
    }

    @Deprecated
    public int ringCount() {
        return this.ring.ringCount();
    }

    @Deprecated
    public int ringCount(int size) {
        return this.ring.ringCount(size);
    }

    @Deprecated
    public int ringCountOfAtom(int a) {
        return this.ring.ringCountOfAtom(a);
    }

    @Deprecated
    public int[][] rings() {
        return this.ring.rings();
    }

    @Deprecated
    public int[][] rings(int size) {
        return this.ring.aliphaticRings(size);
    }

    @Deprecated
    public int ringSystemCount() {
        return this.ring.ringSystemCount();
    }

    @Deprecated
    public int ringSystemCount(int size) {
        return this.ring.ringSystemCount(size);
    }

    @Deprecated
    public int[][] ringSystems() {
        return this.ring.ringSystems();
    }

    @Deprecated
    public int[][] ringSystems(int size) {
        return this.ring.ringSystems(size);
    }

    public int rotatableBondCount() {
        if ((this.initialized & 0x40) == 0) {
            this.findRotatableBonds();
        }
        int c = 0;
        for (int i = 0; i < this.bonds.length; ++i) {
            if ((this.bonds[i] & 0x40) != 64) continue;
            ++c;
        }
        return c;
    }

    public int shortestPath(int atom1, int atom2) {
        if (this.dtab == null) {
            this.distanceMatrix();
        }
        return this.dtab[atom1][atom2];
    }

    @Deprecated
    public int[] smallestRing() {
        return this.ring.smallestRing();
    }

    @Deprecated
    public int smallestRingSize() {
        return this.ring.smallestRingSize();
    }

    @Deprecated
    public int smallestRingSizeOfAtom(int a) {
        return this.ring.smallestRingSizeOfAtom(a);
    }

    @Deprecated
    public int[] smallestRingSystem() {
        return this.ring.smallestRingSystem();
    }

    @Deprecated
    public int smallestRingSystemSize() {
        return this.ring.smallestRingSystemSize();
    }

    @Deprecated
    public String stereo(int a) {
        return this.stereo.stereo(a);
    }

    @Deprecated
    public String stereo(int a1, int a2) {
        return this.stereo.stereo(a1, a2);
    }

    @Deprecated
    public int stereoDoubleBondCount() {
        return this.stereo.stereoDoubleBondCount();
    }

    public double stericEffectIndex(int a) {
        if (this.dtab == null) {
            this.distanceMatrix();
        }
        double h = 0.0;
        double crad = PeriodicSystem.getCovalentRadius(6);
        for (int i = 0; i < this.dtab[a].length; ++i) {
            if (i == a || this.dtab[a][i] == Integer.MAX_VALUE || this.dtab[a][i] == 0) continue;
            double r = PeriodicSystem.getCovalentRadius(this.mol.getAtom(i).getAtno()) / crad;
            h += r * r * r / (double)(this.dtab[a][i] * this.dtab[a][i] * this.dtab[a][i]);
        }
        return h;
    }

    public int szegedIndex() {
        if (this.dtab == null) {
            this.distanceMatrix();
        }
        int s = 0;
        for (int i = 0; i < this.dtab.length; ++i) {
            for (int j = i + 1; j < this.dtab[i].length; ++j) {
                if (this.dtab[i][j] != 1) continue;
                int ni = 1;
                int nj = 1;
                for (int k = 0; k < this.dtab[i].length; ++k) {
                    if (k == i || k == j) continue;
                    if (this.dtab[i][k] < this.dtab[j][k]) {
                        ++ni;
                        continue;
                    }
                    if (this.dtab[i][k] <= this.dtab[j][k]) continue;
                    ++nj;
                }
                s += ni * nj;
            }
        }
        return s;
    }

    @Override
    public void setLicenseEnvironment(String env) {
        this.licenseEnvironment = env;
    }

    @Override
    public boolean isLicensed() {
        return LicenseHandler.getInstance().isLicensed("Geometry Plugin Group", this.licenseEnvironment);
    }

    private void checkLicense() throws LicenseException {
        LicenseHandler.getInstance().checkLicense("Geometry Plugin Group", this.licenseEnvironment);
    }

    public int wienerIndex() {
        if (this.dtab == null) {
            this.distanceMatrix();
        }
        if (!this.connected) {
            return Integer.MAX_VALUE;
        }
        int w = 0;
        for (int i = 0; i < this.dtab.length; ++i) {
            for (int j = i + 1; j < this.dtab[i].length; ++j) {
                w += this.dtab[i][j];
            }
        }
        return w;
    }

    public int wienerPolarity() {
        if (this.dtab == null) {
            this.distanceMatrix();
        }
        if (!this.connected) {
            return Integer.MAX_VALUE;
        }
        int p = 0;
        for (int i = 0; i < this.dtab.length; ++i) {
            for (int j = i + 1; j < this.dtab[i].length; ++j) {
                if (this.dtab[i][j] != 3) continue;
                ++p;
            }
        }
        return p;
    }
}

