/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.calculations;

import chemaxon.calculations.clean.Cleaner;
import chemaxon.license.Licensable;
import chemaxon.license.LicenseException;
import chemaxon.license.LicenseHandler;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import chemaxon.struc.PeriodicSystem;

public class VanDerWaalsVolume
implements Licensable {
    private Molecule molecule;
    private String generate3Dopts = "";
    private double volume = 0.0;
    private String licenseEnvironment = "";
    private static final double C_VOLUME = 20.579526276115534;
    private static final double H_VOLUME = 7.2382294738708834;

    final void checkLicense() throws LicenseException {
        LicenseHandler.getInstance().checkLicense("Geometry Plugin Group", this.licenseEnvironment);
    }

    @Override
    public boolean isLicensed() {
        return LicenseHandler.getInstance().isLicensed("Geometry Plugin Group", this.licenseEnvironment);
    }

    @Override
    public void setLicenseEnvironment(String env) {
        this.licenseEnvironment = env;
    }

    public void setMolecule(Molecule molecule) {
        if (molecule.getDim() != 3) {
            Cleaner.clean(molecule, 3, this.generate3Dopts);
        }
        this.molecule = molecule;
    }

    public void setGenerate3Dopts(String generate3Dopts) {
        this.generate3Dopts = generate3Dopts;
    }

    private double getSphereVolume(double r1) {
        return 4.0 * r1 * r1 * r1 * Math.PI / 3.0;
    }

    private double getAnalitcVoulmeOfIntersection(double r1, double r2, double a) {
        double l0 = (a - r1) * (a - r1) - r2 * r2;
        double v1 = l0 * l0 * (a * a + 4.0 * a * r1 + r1 * r1 - r2 * r2);
        double l1 = a + r1 - r2;
        double l2 = -a + r1 + r2;
        double v2 = l1 * l1 * l2 * l2 * (a * a + 4.0 * a * r2 - r1 * r1 + r2 * r2);
        return Math.PI / (24.0 * a * a * a) * (v1 + v2);
    }

    public void run() {
        this.checkLicense();
        this.volume = 0.0;
        for (int j = 0; j < this.molecule.getAtomCount(); ++j) {
            int z = this.molecule.getAtom(j).getAtno();
            if (z == 1) {
                this.volume += 7.2382294738708834;
                continue;
            }
            if (z == 6) {
                this.volume += 20.579526276115534;
                continue;
            }
            double vdw = PeriodicSystem.getVanDerWaalsRadius(z);
            this.volume += this.getSphereVolume(vdw);
        }
        for (int i = 0; i < this.molecule.getBondCount(); ++i) {
            MolBond b = this.molecule.getBond(i);
            double vdwAtom1 = PeriodicSystem.getVanDerWaalsRadius(b.getAtom1().getAtno());
            double vdwAtom2 = PeriodicSystem.getVanDerWaalsRadius(b.getAtom2().getAtno());
            double length = b.getLength();
            double inters = this.getAnalitcVoulmeOfIntersection(vdwAtom1, vdwAtom2, length);
            this.volume -= inters;
        }
    }

    public double getVolume() {
        return this.volume;
    }
}

