/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.calculations.clean;

import chemaxon.calculations.clean.Cleaner;
import chemaxon.calculations.clean.FRPRMinimalization;
import chemaxon.common.util.ArrayTools;
import chemaxon.common.util.BasicEnvironment;
import chemaxon.common.util.IntVector;
import chemaxon.core.calculations.AtomBranchCoords;
import chemaxon.core.util.BondTable;
import chemaxon.core.util.GeomUtil;
import chemaxon.formats.MolExporter;
import chemaxon.formats.MolFormatException;
import chemaxon.formats.MolInputStream;
import chemaxon.marvin.io.MPropHandler;
import chemaxon.marvin.io.MRecordImporter;
import chemaxon.marvin.io.MRecordParseException;
import chemaxon.marvin.modules.SubstructureSearch;
import chemaxon.marvin.util.CleanUtil;
import chemaxon.struc.CTransform3D;
import chemaxon.struc.DPoint3;
import chemaxon.struc.MDocument;
import chemaxon.struc.MObject;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import chemaxon.struc.MoleculeGraph;
import chemaxon.struc.RgMolecule;
import chemaxon.struc.RxnMolecule;
import chemaxon.struc.SelectionMolecule;
import chemaxon.struc.Sgroup;
import chemaxon.struc.StereoConstants;
import chemaxon.struc.graphics.MEFlow;
import chemaxon.struc.sgroup.MulticenterSgroup;
import chemaxon.struc.sgroup.SgroupAtom;
import chemaxon.struc.sgroup.SuperatomSgroup;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Vector;
import java.util.logging.Logger;

public class Clean2D
implements StereoConstants {
    private static final Logger logger = Logger.getLogger(Clean2D.class.getName());
    private static final int SMALL_RING_SIZE = 10;
    private static final double INT_ANGLE_SET = 1.0;
    static final double ATOM_FIXED = 2.0;
    static final double ATOM_TMP_FIXED = 3.0;
    static final double REMOVED_H = 5.0;
    static final double ROOT_ATOM = 10.0;
    private static final double twoPI = Math.PI * 2;
    private static final int CISTRANS = 192;
    private static final int STEREO1_MASK = 48;
    private static final double CCLENGTH = 1.54;
    public static final double CCLENGTH2 = 2.3716;
    private static final double DIST2 = 0.2635111111111111;
    private static final double MIN_DIST2 = 0.06587777777777777;
    private static final double COLL_DIST = 0.0154;
    private static final double HEX_2_X = 1.3336791159999999;
    private static final double HEX_3_X = 2.6673582319999998;
    private static DPoint3[] HEXAGON = new DPoint3[]{new DPoint3(0.0, 0.0, 0.0), new DPoint3(0.0, 1.54, 0.0), new DPoint3(1.3336791159999999, 2.31, 0.0), new DPoint3(2.6673582319999998, 1.54, 0.0), new DPoint3(2.6673582319999998, 0.0, 0.0), new DPoint3(1.3336791159999999, -0.77, 0.0)};
    private static final double PENT_2_X = 1.4646324000000002;
    private static final double PENT_2_Y = 0.47586;
    private static DPoint3[] PENTAGON = new DPoint3[]{new DPoint3(0.0, 0.0, 0.0), new DPoint3(0.0, 1.54, 0.0), new DPoint3(1.4646324000000002, 2.01586, 0.0), new DPoint3(2.3698136, 0.77, 0.0), new DPoint3(1.4646324000000002, -0.47586, 0.0)};
    private static String sep = System.getProperty("file.separator");
    private static String dir = null;
    private static String userhome = null;
    private String[] template_local = null;
    private static final String[] TEMPLATEFILES = new String[]{"/chemaxon/marvin/templates/bicycles.t", "/chemaxon/marvin/templates/crown_ethers.t", "/chemaxon/marvin/templates/heterocycles.t", "/chemaxon/marvin/templates/cleantemplate.cxsmi"};
    private static final String[] CAGETEMPLATEFILES = new String[]{"/chemaxon/marvin/templates/bicycles.t", "/chemaxon/marvin/templates/fullerenes.t", "/chemaxon/marvin/templates/bridged_polycycles.t", "/chemaxon/marvin/templates/cleancage.cxsmi"};
    private long timeStart = 0L;
    private long timeStart_structure = 0L;
    private long timeLimit = 10000L;
    private long timeLimit_structure = 5000L;
    private IntVector[] MoleculeInvariants = null;
    private IntVector[] CageMolInv = new IntVector[CAGETEMPLATEFILES.length];
    private int Debug = 0;
    FileOutputStream out = null;
    private static final int STD_ERR = 1;
    private static int Error = 0;
    private int molCount = 0;
    private PartialOptimization opt = new PartialOptimization();
    static final int FIXED_ATOMS_ONLY = 1;
    static final int ADDH = 2;
    static final int FORCE_IDEAL_SMALLRINGS = 4;
    static final int ABSOLUTE_FIXED_ATOMS = 8;
    static final int RELATIVE_FIXED_ATOMS = 16;
    private boolean removeCTEither = false;
    private boolean partialCleanForMolecules = false;
    private boolean partialClean = false;
    private int[] fixedAtoms = null;
    private boolean use_2D_Alignment = false;
    private boolean addHydrogensToChiralAtoms = false;
    private boolean addExplicitHToCageSystem = false;
    private boolean setParities = true;
    private boolean useStereoFromFlags = false;
    private boolean wedgeClean = false;
    private boolean onlyWedgeClean = false;
    private boolean forceTemplates = false;
    MoleculeGraph ORIG;
    static final int RINGATOM = 1;
    static final int CHAINATOM = 2;
    static final int TERMINALATOM = 4;
    static final int CHAINEND = 6;
    static final int STEREOATOM = 8;
    static final int LONEATOM = 16;
    static final int SMALLFRAG = 32;
    static final int ATOMTYPE_MASK = 63;
    static final int DEGENERATE = 64;
    static final int BRANCHSTART = 128;
    static final int AROMATOM = 256;
    private static final int FIXED_AT_PARTIALCLEAN = 512;
    static final int STEREO_FIXED = 1024;
    private static final int PARTIALLY_FIXED = 2048;
    private static final int LONEDBSTEREO = 4096;
    private static final int TEMPLATECAGEATOM = 8192;
    private static final int ORGANOMETALLIC = 16384;
    private static final int INTANG_FIXED = 32768;
    private static final int SPIRO = 65536;
    private static final int READY = 131072;
    private static final int LONGESTCHAIN = 262144;
    private static final int DB1 = 524288;
    private static final int DB2 = 0x100000;
    private static final int ADAMANTANE = 0x200000;
    private static final int LONGESTCHAINSTART = 0x400000;
    private static final int MAP_PARTIALCLEAN = 2;
    private static final int NONRECURSETYPE = 140;
    static final int SUCCESS = 0;
    private static final int COLLISION = 1;
    private static final int PARTIALCLEAN_FAILURE = 2;
    private static final int FAILURE = 3;
    private static final int STEP_LIMIT = 4;
    private static final int BT_LIMIT = 5;
    int levelAheadLimit = Integer.MAX_VALUE;
    static final int DEFAULT_STEP_LIMIT = 4999;
    int stepLimit = 4999;
    int[][] cssr;
    int[][] ctab;
    BondTable btab;
    int[] fragID;
    private static final int FRAGMENT_ID_MASK = 65535;
    private static final int DB_ID_OFFSET = 16;
    double[][] intang;
    BitSet[] ringBitset;
    boolean[] isRingBond;
    int[][] atomInRing;
    int[][] commRingAtomNu;
    double coll_dist_sq = 0.5929;

    public Clean2D() {
        String[] stringArray;
        try {
            userhome = System.getProperty("user.home");
            dir = userhome + sep + (sep.equals("/") ? ".chemaxon" : "chemaxon");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (dir == null) {
            stringArray = new String[]{};
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = dir + "/cleantemplates.t";
        }
        this.template_local = stringArray;
        this.MoleculeInvariants = new IntVector[TEMPLATEFILES.length + this.template_local.length];
    }

    public Clean2D(MoleculeGraph mol) {
        this();
        this.ORIG = mol;
    }

    public boolean clean(MoleculeGraph m) {
        this.ORIG = m;
        Integer s = this.cleanMoleculeStructure();
        int success = s;
        return success == 0;
    }

    public int clean(MoleculeGraph m, String opts) {
        return this.clean(m, opts, null);
    }

    public int clean(MoleculeGraph m, String opts, int[] fixedAtoms) {
        this.ORIG = m;
        this.fixedAtoms = fixedAtoms;
        if (fixedAtoms != null && fixedAtoms.length > 0) {
            this.partialCleanForMolecules = true;
        }
        this.readOptions(opts);
        Integer success = null;
        success = this.cleanMoleculeStructure();
        return success != null ? (success == 0 ? success : 1) : 1;
    }

    public int clean(MoleculeGraph m, String opts, MoleculeGraph template, int[] map) {
        this.ORIG = m;
        this.fixedAtoms = null;
        boolean success = Clean2D.partialClean(this.ORIG, template, map, opts);
        return success ? 0 : 1;
    }

    public int clean(Molecule m, String opts, Molecule[] template) {
        this.ORIG = m;
        this.fixedAtoms = null;
        boolean success = this.partialClean((Molecule)this.ORIG, template, opts);
        return success ? 0 : 1;
    }

    void readOptions(String opts) {
        if (opts != null) {
            block15: for (int i = 0; i < opts.length(); ++i) {
                char c = opts.charAt(i);
                switch (c) {
                    case 'd': {
                        if (i >= opts.length() - 1) continue block15;
                        c = opts.charAt(i + 1);
                        if (c >= '0' && c <= '9') {
                            this.Debug = c - 48;
                            ++i;
                            continue block15;
                        }
                        this.Debug = 1;
                        continue block15;
                    }
                    case 'E': {
                        if (i >= opts.length() - 1) continue block15;
                        c = opts.charAt(i + 1);
                        if (c >= '0' && c <= '9') {
                            Error = c - 48;
                            ++i;
                            continue block15;
                        }
                        Error = 1;
                        continue block15;
                    }
                    case 'e': {
                        this.removeCTEither = true;
                        continue block15;
                    }
                    case '2': {
                        this.use_2D_Alignment = true;
                        continue block15;
                    }
                    case 'p': {
                        this.setParities = false;
                        continue block15;
                    }
                    case 'H': {
                        this.addHydrogensToChiralAtoms = true;
                        this.wedgeClean = true;
                        continue block15;
                    }
                    case 'w': {
                        this.wedgeClean = true;
                        continue block15;
                    }
                    case 'W': {
                        this.onlyWedgeClean = true;
                        continue block15;
                    }
                    case 'f': {
                        this.useStereoFromFlags = true;
                        continue block15;
                    }
                    case 'l': {
                        this.levelAheadLimit = 0;
                        while (i < opts.length() - 1) {
                            char c2 = opts.charAt(i + 1);
                            c = c2;
                            if (c2 < '0' || c > 57) break;
                            int n = c - 48;
                            this.levelAheadLimit = this.levelAheadLimit * 10 + n;
                            ++i;
                        }
                        if (this.levelAheadLimit != 0) continue block15;
                        this.levelAheadLimit = 1;
                        continue block15;
                    }
                    case 'b': {
                        int n;
                        int st = 0;
                        while (i < opts.length() - 1) {
                            char c3 = opts.charAt(i + 1);
                            c = c3;
                            if (c3 < '0' || c > 57) break;
                            n = c - 48;
                            st = st * 10 + n;
                            ++i;
                        }
                        this.stepLimit = st;
                        continue block15;
                    }
                    case 't': {
                        int n;
                        if (opts.charAt(i + 1) == 's') {
                            this.timeLimit_structure = 0L;
                            ++i;
                            while (i < opts.length() - 1) {
                                char c4 = opts.charAt(i + 1);
                                c = c4;
                                if (c4 < '0' || c > 57) continue block15;
                                n = c - 48;
                                this.timeLimit_structure = this.timeLimit_structure * 10L + (long)n;
                                ++i;
                            }
                            continue block15;
                        }
                        this.timeLimit = 0L;
                        while (i < opts.length() - 1) {
                            char c5 = opts.charAt(i + 1);
                            c = c5;
                            if (c5 < '0' || c > 57) continue block15;
                            n = c - 48;
                            this.timeLimit = this.timeLimit * 10L + (long)n;
                            ++i;
                        }
                        continue block15;
                    }
                    case 'T': {
                        while ((c = i + 1 < opts.length() ? (char)opts.charAt(i + 1) : (char)' ') == 'f' || c == '{') {
                            if (c == 'f') {
                                this.forceTemplates = true;
                            } else if (c == '{') {
                                ++i;
                                String filenames = "";
                                while (i < opts.length() - 1) {
                                    char c6 = opts.charAt(i + 1);
                                    c = c6;
                                    if (c6 == '}') break;
                                    filenames = filenames + c;
                                    ++i;
                                }
                                int l = this.template_local.length;
                                String[] tmp = new String[l + 1];
                                tmp[0] = filenames;
                                System.arraycopy(this.template_local, 0, tmp, 1, l);
                                this.template_local = tmp;
                                this.MoleculeInvariants = new IntVector[TEMPLATEFILES.length + this.template_local.length];
                            }
                            ++i;
                        }
                        continue block15;
                    }
                    default: {
                        System.err.println(String.valueOf(c) + ": bad Clean2D option");
                    }
                }
            }
        }
    }

    private static boolean partialClean(MoleculeGraph m, MoleculeGraph template, int[] map, String opts) {
        int i;
        int i2;
        if (map.length != template.getAtomCount()) {
            return false;
        }
        int[] parities = new int[m.getAtomCount()];
        for (i2 = 0; i2 < parities.length; ++i2) {
            parities[i2] = m.getParity(i2);
        }
        for (i2 = m.getBondCount() - 1; i2 >= 0; --i2) {
            MolBond b = m.getBond(i2);
            MolAtom a1 = b.getCTAtom1();
            MolAtom a4 = b.getCTAtom4();
            if (a1 == null || a4 == null) continue;
            int s = m.getStereo2(b, a1, a4, false);
            b.setFlags(s, 448);
        }
        int excludedN = 0;
        for (int i3 = 0; i3 < template.getAtomCount(); ++i3) {
            MolAtom t_a = template.getAtom(i3);
            int idx = map[i3];
            if (idx >= 0) {
                MolAtom a = m.getAtom(idx);
                a.setXYZ(t_a.getX(), t_a.getY(), 0.0);
                continue;
            }
            ++excludedN;
        }
        int[] fixed = map;
        if (excludedN > 0) {
            int ml = map.length;
            fixed = new int[ml - excludedN];
            int n = 0;
            for (int i4 = 0; i4 < ml; ++i4) {
                int idx = map[i4];
                if (idx < 0) continue;
                fixed[n++] = idx;
            }
        }
        boolean templateHasWedge = false;
        for (i = 0; i < template.getBondCount() && !templateHasWedge; ++i) {
            MolBond b = template.getBond(i);
            templateHasWedge = (b.getFlags() & 0x30) != 0;
        }
        if (templateHasWedge) {
            for (i = 0; i < m.getBondCount(); ++i) {
                MolBond b = m.getBond(i);
                b.setFlags(0, 48);
            }
        }
        boolean success = Cleaner.partialClean(m, 2, fixed, opts == null ? "p" : opts + "p");
        if (templateHasWedge && template.getDim() == 2) {
            BondTable targetBtab = null;
            int bc = template.getBondCount();
            for (int i5 = 0; i5 < bc; ++i5) {
                MolBond tb;
                MolBond b = template.getBond(i5);
                if ((b.getFlags() & 0x30) == 0) continue;
                MolAtom a1 = b.getAtom1();
                MolAtom a2 = b.getAtom2();
                int i1 = template.indexOf(a1);
                int i22 = template.indexOf(a2);
                int ti1 = map[i1];
                int ti2 = map[i22];
                if (ti1 < 0 || ti2 < 0) continue;
                if (targetBtab == null) {
                    targetBtab = m.getBondTable();
                }
                if (m.indexOf((tb = m.getBond(targetBtab.getBondIndex(ti1, ti2))).getAtom1()) != ti1) {
                    tb.swap();
                }
                tb.setFlags(b.getFlags() & 0x30, 48);
            }
        }
        if (!m.setParity(parities)) {
            logger.warning("Partial parity information is applied.");
        }
        CleanUtil.arrangeComponents(m, false);
        CleanUtil.arrangeDataSgroupData(m);
        CleanUtil.arrangeSgBrackets(m);
        return success;
    }

    private boolean partialClean(Molecule m, Molecule[] template, String opts) {
        BitSet smallRingBond = Clean2D.getSmallringBondSet(m);
        int l = template.length;
        SubstructureSearch sss = new SubstructureSearch();
        sss.setIgnoreHybridization(true);
        sss.setIgnoreCharge(true);
        sss.setTarget(m);
        for (int i = 0; i < l; ++i) {
            Molecule query = template[i];
            if (query.getDim() != 2 || query.getBondCount() <= 0) continue;
            sss.setQuery(query);
            boolean found = sss.findFirst();
            while (found) {
                int[] map = sss.getResult();
                if (Clean2D.ringToRingCorrespondance(m, query, map) && Clean2D.cisTransInformationCheck(m, query, map, smallRingBond)) {
                    boolean success = Cleaner.partialClean((MoleculeGraph)m, query, map, opts);
                    return success;
                }
                found = sss.findNext();
            }
        }
        return false;
    }

    private static boolean ringToRingCorrespondance(Molecule m, Molecule query, int[] map) {
        int[] invMap = new int[m.getAtomCount()];
        Arrays.fill(invMap, -1);
        int i = 0;
        while (i < map.length) {
            int tIdx = map[i];
            invMap[tIdx] = i++;
        }
        BondTable btab = query.getBondTable();
        int[][] sssr = m.getSSSR();
        int l = sssr.length;
        int ml = map.length;
        long[] sssrBondSetT = query.getSSSRBondSetInLong();
        for (int i2 = 0; i2 < l; ++i2) {
            int[] r = sssr[i2];
            int rl = r.length;
            for (int j = 0; j < rl; ++j) {
                int tbidx;
                int h = r[j];
                int n = r[(j + 1) % rl];
                if (h >= ml || n >= ml) continue;
                int th = invMap[h];
                int tn = invMap[n];
                if (th < 0 || tn < 0 || (sssrBondSetT[(tbidx = btab.getBondIndex(th, tn)) / 64] & 1L << 63 - tbidx % 64) != 0L) continue;
                return false;
            }
        }
        return true;
    }

    Integer cleanMoleculeStructure() {
        if (this.Debug > 3) {
            try {
                this.out = new FileOutputStream("save.sdf");
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        if (this.onlyWedgeClean) {
            return new Integer(this.ORIG.stereoClean() ? 0 : 3);
        }
        this.timeStart = System.currentTimeMillis();
        ++this.molCount;
        int structureSuccess = 0;
        MoleculeGraph molecule = this.cloneAndInitialize(this.ORIG);
        if (molecule.getAtomCount() == 0) {
            return new Integer(structureSuccess);
        }
        MolAtom[] origAtoms = molecule.getAtomArray();
        MolBond[] origBonds = molecule.getBondArray();
        int[] atomFlags = new int[origAtoms.length];
        boolean hasMulticenterSG = false;
        if (this.ORIG instanceof Molecule) {
            Molecule m = (Molecule)this.ORIG;
            hasMulticenterSG = Clean2D.hasMulticentSGroup(null, m);
        }
        MoleculeGraph[] mols = null;
        mols = molecule.findBasicFrags(Molecule.class);
        int fragCount = mols.length;
        boolean arrangeMolecules = !this.partialCleanForMolecules;
        int startAtomCount = 0;
        for (int s = 0; s < fragCount; ++s) {
            int success = 0;
            MoleculeGraph frag = mols[s];
            if (this.Debug > 0) {
                System.err.println(s + ". FRAGMENT atoms " + frag.getAtomCount());
            }
            int ac = frag.getAtomCount();
            int[] atomFlags_frag = new int[ac];
            success = this.cleanFragment(frag, atomFlags_frag);
            if (ac != frag.getAtomCount()) {
                origAtoms = Clean2D.addAtoms(origAtoms, frag, ac);
            }
            if (this.Debug > 1) {
                System.err.println("cleanFragment " + (success == 0 ? "success" : (success == 2 ? "PARTIALCLEAN_FAILURE" : (success == 3 ? "FAILURE" : "???"))));
            }
            int n = success == 3 ? 3 : (structureSuccess = success == 2 ? 3 : 0);
            if (atomFlags.length < startAtomCount + ac) {
                int[] tmp = new int[startAtomCount + ac];
                System.arraycopy(atomFlags, 0, tmp, 0, atomFlags.length);
                atomFlags = tmp;
            }
            System.arraycopy(atomFlags_frag, 0, atomFlags, startAtomCount, ac);
            startAtomCount += frag.getAtomCount();
        }
        Clean2D.writeCoordsandBonds(origAtoms, origBonds, this.ORIG);
        Clean2D.bondCrossArrangement(this.ORIG, atomFlags);
        boolean bl = arrangeMolecules = Clean2D.fragsAtTheSamePlace(mols) ? true : arrangeMolecules;
        if (!this.partialCleanForMolecules && hasMulticenterSG && !Clean2D.arrangeMultiCenter(this.ORIG, this.Debug)) {
            structureSuccess = 3;
        }
        fragCount = mols.length;
        if (hasMulticenterSG) {
            Molecule mol = new Molecule();
            MoleculeGraph umol = this.ORIG.getGraphUnion();
            umol.clonecopy(mol);
            fragCount = ((Molecule[])mol.findFrags(Molecule.class, 1)).length;
        }
        if (fragCount > 1) {
            RgMolecule m;
            Molecule r;
            boolean reaction;
            boolean bl2 = reaction = this.ORIG instanceof RxnMolecule;
            if (!reaction && this.ORIG instanceof RgMolecule && (r = (m = (RgMolecule)this.ORIG).getRoot()) instanceof RxnMolecule) {
                reaction = true;
            }
            if (reaction) {
                Clean2D.arrangeSaltMolecules(this.ORIG);
            }
            if (arrangeMolecules && !CleanUtil.arrangeComponents(this.ORIG, false)) {
                MoleculeGraph ORIGUnion = this.ORIG.getGraphUnion();
                MoleculeGraph[] frags = ORIGUnion.findFrags(SelectionMolecule.class, 1);
                CleanUtil.arrangeMolecules(frags, 2, -1);
            }
        }
        CleanUtil.arrangeDataSgroupData(this.ORIG);
        CleanUtil.arrangeSgBrackets(this.ORIG);
        this.ORIG.setDim(2);
        if (this.Debug > 1) {
            System.err.println("cleanStructure end");
        }
        return new Integer(structureSuccess);
    }

    int cleanFragment(MoleculeGraph molfrag, int[] atomFlags) {
        this.timeStart_structure = System.currentTimeMillis();
        boolean[] alignFragment = new boolean[]{!this.use_2D_Alignment};
        int ac = molfrag.getAtomCount();
        if (ac < 2) {
            return 0;
        }
        this.cssr = molfrag.getCSSR();
        this.ctab = molfrag.getCtab();
        this.btab = molfrag.getBondTable();
        DPoint3 fragmentCenter = null;
        boolean dimGreater2 = Clean2D.isMoleculeNot0Dimension(molfrag);
        if (dimGreater2) {
            fragmentCenter = molfrag.calcCenter();
        }
        int[] bondFlags = null;
        if (!this.useStereoFromFlags) {
            bondFlags = Clean2D.storeStereoInFlags(molfrag, this.cssr, this.btab, dimGreater2, this.partialClean, this.addHydrogensToChiralAtoms);
        }
        Clean2D.setZ(molfrag, 0.0);
        int[] fixedIdxes = Clean2D.getAndSetFixedIdxes(molfrag);
        if (fixedIdxes != null && fixedIdxes.length == ac) {
            Clean2D.setZ(molfrag, 0.0);
            return 0;
        }
        boolean oneAtomFixed = fixedIdxes != null && fixedIdxes.length == 1;
        DPoint3 fCoords = null;
        if (oneAtomFixed) {
            MolAtom a = molfrag.getAtom(fixedIdxes[0]);
            fCoords = a.getLocation();
            a.setZ(0.0);
        }
        boolean bl = this.partialClean = fixedIdxes != null && fixedIdxes.length > 1;
        if (this.Debug > 0) {
            System.err.println("The fragment needs partialClean " + this.partialClean);
        }
        if (Clean2D.getFragCount(molfrag, fixedIdxes) > 1) {
            if (this.Debug > 0) {
                System.err.println("The fixed indexes are located in more than one fragment");
            }
            Clean2D.setZ(molfrag, 0.0);
            return 2;
        }
        if (this.partialClean) {
            alignFragment[0] = false;
        }
        MoleculeGraph frag_noH = molfrag;
        if (!this.partialClean) {
            frag_noH = Clean2D.removeTerminalHydrogens(molfrag);
            this.ctab = frag_noH.getCtab();
            this.btab = frag_noH.getBondTable();
            this.cssr = frag_noH.getCSSR();
        }
        if (!CleanUtil.removeCTflagFromSmallRings(frag_noH)) {
            System.err.println("Warning: TRANS ring bond in ring smaller than size 8. Stereo property is removed. ");
        }
        int bc = frag_noH.getBondCount();
        ac = frag_noH.getAtomCount();
        double[] saved_coords = new double[ac * 2];
        Clean2D.saveCoordinates(frag_noH, saved_coords);
        int[] atomFlags_frag = new int[ac];
        int rl = this.cssr.length;
        int[] minRS = new int[bc];
        this.ringBitset = new BitSet[rl];
        this.atomInRing = new int[ac][];
        this.commRingAtomNu = new int[rl][rl];
        this.isRingBond = new boolean[bc];
        Clean2D.setupRingInfo(this.cssr, frag_noH, minRS, this.ringBitset, atomFlags_frag, this.atomInRing, this.commRingAtomNu, this.btab, this.isRingBond);
        frag_noH.setDim(2);
        this.intang = new double[bc][bc];
        this.fragID = new int[frag_noH.getAtomCount() + 1];
        int n = this.fragID.length - 1;
        this.fragID[n] = this.fragID[n] + 1;
        boolean molCleaned = this.calcInitialGeometry(frag_noH, alignFragment, this.stepLimit, saved_coords, atomFlags_frag);
        if (!frag_noH.equals(molfrag)) {
            if (this.Debug > 2) {
                System.err.println("EXPLICIT H in the molecule (atomcount " + molfrag.getAtomCount() + ")");
            }
            Clean2D.setBondFlags(bondFlags, molfrag);
            Clean2D.setNonHCoordinates(frag_noH, molfrag);
            this.ctab = molfrag.getCtab();
            this.btab = molfrag.getBondTable();
            this.cssr = molfrag.getCSSR();
            rl = this.cssr.length;
            bc = molfrag.getBondCount();
            ac = molfrag.getAtomCount();
            this.atomInRing = new int[ac][];
            int[] newfragID = new int[ac + 1];
            Clean2D.transformAtomFlagsAndIDs(atomFlags, atomFlags_frag, newfragID, this.fragID, molfrag);
            atomFlags_frag = atomFlags;
            this.fragID = newfragID;
            this.isRingBond = new boolean[bc];
            Clean2D.setupRingInfo(this.cssr, molfrag, null, this.ringBitset, null, this.atomInRing, null, this.btab, this.isRingBond);
            this.intang = new double[bc][bc];
            Clean2D.generateInternalAngleForFixedLigands(molfrag, this.ctab, this.btab, this.intang);
            Clean2D.arrangeHydrogens(molfrag, this.ctab, this.btab, this.intang, this.atomInRing, this.isRingBond, this.cssr, this.ringBitset, this.opt);
        }
        if (this.addExplicitHToCageSystem) {
            Clean2D.addExpHtoCage(molfrag, atomFlags_frag, this.ctab);
            this.ctab = molfrag.getCtab();
            this.btab = molfrag.getBondTable();
            bc = molfrag.getBondCount();
            this.intang = new double[bc][bc];
            ac = molfrag.getAtomCount();
            int[][] newatomInRing = new int[ac][];
            System.arraycopy(this.atomInRing, 0, newatomInRing, 0, this.atomInRing.length);
            for (int i = this.atomInRing.length; i < ac; ++i) {
                newatomInRing[i] = new int[0];
            }
            this.atomInRing = newatomInRing;
            Clean2D.generateInternalAngleForFixedLigands(molfrag, this.ctab, this.btab, this.intang);
            Clean2D.arrangeHydrogens(molfrag, this.ctab, this.btab, this.intang, this.atomInRing, this.isRingBond, this.cssr, null, this.opt);
        }
        Clean2D.setZ(molfrag, 0.0);
        if (!molCleaned) {
            if (Error == 1 || this.Debug > 0) {
                System.err.println("Geometry calculation failure");
                if (this.Debug > 0) {
                    Clean2D.saveMoleculeToFile(frag_noH, false, "clean_fail_" + this.molCount + ".mrv");
                }
            }
            System.arraycopy(atomFlags_frag, 0, atomFlags, 0, atomFlags_frag.length);
            return 3;
        }
        if (alignFragment[0]) {
            Clean2D.orientMolecule(molfrag, this.ctab, this.btab, atomFlags_frag, this.fragID, this.cssr, this.atomInRing);
        }
        if (!this.partialClean) {
            Clean2D.translateToCenter(fragmentCenter, molfrag);
        }
        if (this.setParities) {
            molfrag.setDim(2);
            if (!Clean2D.setParityFromFlags(molfrag, !this.wedgeClean) && Error == 1) {
                System.err.println("setParity error");
            }
        }
        if (!this.removeCTEither) {
            CleanUtil.setCTWigglyBond(molfrag);
        }
        if (oneAtomFixed) {
            CTransform3D T = new CTransform3D();
            DPoint3 c = molfrag.getAtom(fixedIdxes[0]).getLocation();
            T.setTranslation(c.x - fCoords.x, c.y - fCoords.y, 0.0);
            molfrag.transform(T);
        }
        System.arraycopy(atomFlags_frag, 0, atomFlags, 0, atomFlags_frag.length);
        return 0;
    }

    static MoleculeGraph removeTerminalHydrogens(MoleculeGraph m) {
        MolAtom a;
        int i;
        Molecule m_noH = new Molecule();
        m.clonecopy(m_noH);
        int removeFlags = -35;
        boolean hremoved = false;
        int ac = m_noH.getAtomCount();
        int[] bondc = new int[ac];
        for (i = ac - 1; i >= 0; --i) {
            a = m_noH.getAtom(i);
            bondc[i] = a.getBondCount();
        }
        for (i = ac - 1; i >= 0; --i) {
            a = m_noH.getAtom(i);
            if (a.getAtno() != 1 || bondc[i] != 1 || a.getBondCount() != 1) continue;
            int dbs = 0;
            MolBond dbsb = null;
            MolAtom a1 = a.getLigand(0);
            int l = a1.getBondCount();
            for (int j = 0; j < l; ++j) {
                MolBond b = a1.getBond(j);
                int t = b.getType();
                if (t != 2) continue;
                dbs = b.getFlags() & 0x1C0;
                if (!(dbs != 128 && dbs != 64 || b.getCTAtom1() != a && b.getCTAtom4() != a)) {
                    dbs = dbs & 0xC0 ^ 0xC0;
                }
                dbsb = b;
            }
            m_noH.removeAtom(i, removeFlags);
            m.getAtom(i).setZ(5.0);
            hremoved = true;
            if (dbsb == null || dbs == 0) continue;
            dbsb.setFlags(dbs, 448);
        }
        return hremoved ? m_noH : m;
    }

    static void addExpHtoCage(MoleculeGraph m, int[] f, int[][] ctab) {
        int ac = m.getAtomCount();
        for (int i = 0; i < ac; ++i) {
            if ((f[i] & 0x2000) == 0) continue;
            MolAtom a = m.getAtom(i);
            int[] an = ctab[i];
            int p = a.getFlags() & 7;
            boolean hasNonRingLigand = false;
            int l = an.length;
            for (int j = 0; j < l; ++j) {
                if ((f[an[j]] & 1) != 0) continue;
                hasNonRingLigand = true;
                break;
            }
            if (p == 0 || p == 7 || hasNonRingLigand || a.getImplicitHcount() <= 0) continue;
            MolAtom H1 = new MolAtom(1, 0.0, 0.0, 0.0);
            m.add(H1);
            m.add(new MolBond(a, H1, 1));
        }
    }

    static MolAtom[] addAtoms(MolAtom[] atoms, MoleculeGraph m, int startIndex) {
        int ac = m.getAtomCount();
        MolAtom[] newAtoms = new MolAtom[ac];
        System.arraycopy(atoms, 0, newAtoms, 0, atoms.length);
        for (int i = startIndex; i < ac; ++i) {
            MolAtom a;
            newAtoms[i] = a = m.getAtom(i);
        }
        return newAtoms;
    }

    static void setNonHCoordinates(MoleculeGraph from, MoleculeGraph to) {
        int ac = to.getAtomCount();
        int n = 0;
        for (int i = 0; i < ac; ++i) {
            MolAtom a = to.getAtom(i);
            if (a.getZ() == 5.0) continue;
            MolAtom a_from = from.getAtom(n++);
            a.setLocation(a_from.getLocation());
        }
    }

    static void setupRingInfo(int[][] cssr, MoleculeGraph m, int[] minRS, BitSet[] ringBitset, int[] atomFlags, int[][] atomInRing, int[][] commRingAtomNu, BondTable btab, boolean[] isRingBond) {
        int i;
        MoleculeGraph aromm = (MoleculeGraph)m.clone();
        aromm.aromatize();
        int ac = m.getAtomCount();
        int[] atomInRl = new int[atomInRing.length];
        for (i = atomInRing.length - 1; i >= 0; --i) {
            int[] tmp = new int[cssr.length];
            atomInRing[i] = tmp;
        }
        for (i = cssr.length - 1; i >= 0; --i) {
            int[] r = cssr[i];
            BitSet s = null;
            if (ringBitset != null) {
                s = new BitSet(ac);
            }
            for (int j = r.length - 1; j >= 0; --j) {
                int idx = r[j];
                if (ringBitset != null) {
                    s.set(idx);
                }
                if (atomFlags != null) {
                    int n = idx;
                    atomFlags[n] = atomFlags[n] | 1;
                    int n2 = idx;
                    atomFlags[n2] = atomFlags[n2] | (Clean2D.isAromatic(aromm.getAtom(idx)) ? 256 : 0);
                }
                int n = idx;
                int n3 = atomInRl[n];
                atomInRl[n] = n3 + 1;
                atomInRing[idx][n3] = i;
            }
            if (ringBitset == null) continue;
            ringBitset[i] = s;
        }
        for (i = atomInRing.length - 1; i >= 0; --i) {
            int rl = atomInRl[i];
            int[] tmp = new int[rl];
            System.arraycopy(atomInRing[i], 0, tmp, 0, rl);
            atomInRing[i] = tmp;
        }
        if (ringBitset != null && commRingAtomNu != null) {
            for (i = cssr.length - 1; i >= 0; --i) {
                BitSet s1 = ringBitset[i];
                for (int j = i - 1; j >= 0; --j) {
                    int c;
                    BitSet s2 = (BitSet)ringBitset[j].clone();
                    s2.and(s1);
                    int n = c = s2.cardinality();
                    commRingAtomNu[j][i] = n;
                    commRingAtomNu[i][j] = n;
                }
            }
        }
        for (i = cssr.length - 1; i >= 0; --i) {
            int[] r = cssr[i];
            int l = r.length;
            for (int j = l - 1; j >= 0; --j) {
                int h = r[j];
                int n = r[(j + 1) % l];
                int b = btab.getBondIndex(h, n);
                isRingBond[b] = true;
                if (minRS == null || minRS[b] != 0 && minRS[b] <= l) continue;
                minRS[b] = l;
            }
        }
    }

    boolean calcInitialGeometry(MoleculeGraph m, boolean[] align, int step_limit, double[] saved_coords, int[] atomFlags) {
        boolean success = true;
        int ac = m.getAtomCount();
        if (ac < 2) {
            m.getAtom(0).setZ(2.0);
            return true;
        }
        if (step_limit == 4999) {
            step_limit = ac < 50 ? 4999 : (ac < 100 ? 2499 : (ac < 200 ? 1249 : (ac < 400 ? 624 : 100)));
        }
        if (this.fixedAtoms != null && this.fixedAtoms.length > 0 && !Clean2D.setFixFlag(m, atomFlags, this.Debug)) {
            if (this.Debug > 1) {
                System.err.println("Collision of fixed atoms!");
            }
            Clean2D.restoreCoordinates(m, saved_coords);
            return false;
        }
        Clean2D.setTerminalAtoms(m, atomFlags, this.fragID);
        int[][] d = new int[ac][ac];
        int[][] pred = new int[ac][ac];
        int[] longestChainIdx = Clean2D.setLongestChain(atomFlags, this.btab, d, pred);
        Clean2D.setAtomTypes(m, atomFlags, this.ctab, this.fragID, this.Debug);
        Clean2D.setDegenerateFlags(m, this.ctab, atomFlags);
        if (this.cssr.length > 0) {
            if (this.partialClean) {
                Clean2D.setZ(m, 0.0);
                success = this.fixPartialRingCoordinates(m, this.ctab, this.btab, atomFlags, this.intang, this.atomInRing, this.commRingAtomNu, this.cssr, this.ringBitset, this.isRingBond, this.fragID, this.MoleculeInvariants, this.CageMolInv, this.forceTemplates, this.template_local, this.opt, this.Debug);
                Clean2D.fixFixedAtoms(m, atomFlags);
            } else {
                success = this.calcRingCoordinates(m, this.ctab, this.btab, atomFlags, this.intang, this.atomInRing, this.commRingAtomNu, this.cssr, this.ringBitset, this.isRingBond, this.fragID, this.MoleculeInvariants, this.CageMolInv, this.forceTemplates, this.template_local, this.Debug, this.opt, align, this.timeStart, this.timeLimit, this.timeStart_structure, this.timeLimit_structure);
            }
        }
        if (Clean2D.timeLimit(this.timeStart, this.timeLimit, this.timeStart_structure, this.timeLimit_structure)) {
            return false;
        }
        if (this.Debug > 5) {
            Clean2D.printAtomFlags(atomFlags, this.fragID);
        }
        if (!success) {
            return false;
        }
        Clean2D.setStereoAtomIntAng(m, atomFlags, this.ctab, this.btab, this.intang, this.fragID, this.atomInRing, this.Debug);
        Clean2D.fixLongestChainInternalAngleToTrans(longestChainIdx, m, atomFlags, this.ctab, this.btab, this.intang, this.Debug);
        Clean2D.fixChainInternalAngles(m, atomFlags, this.ctab, this.btab, this.intang, this.fragID, this.Debug);
        Clean2D.fixIntAngForRestAtoms(m, atomFlags, this.ctab, this.btab, this.intang, this.fragID, this.Debug);
        if (this.partialClean) {
            Clean2D.generateInternalAngleForFixedLigands(m, this.ctab, this.btab, this.intang);
            Clean2D.generateIntangAtPartialClean(m, this.ctab, this.btab, this.intang, this.atomInRing, this.cssr, this.ringBitset, atomFlags, this.isRingBond);
        }
        if (Clean2D.timeLimit(this.timeStart, this.timeLimit, this.timeStart_structure, this.timeLimit_structure)) {
            if (this.Debug > 0) {
                System.err.println("Time limit reached. Set coordinates without backtrack.");
            }
            this.generateCoordinates(m, atomFlags, this.ctab, this.btab, this.intang, this.fragID, this.partialClean, 0, 0, this.opt, 0L, 0L, 0L, 0L, 0.0, null, null, this.Debug);
            return false;
        }
        this.generateCoordinates(m, atomFlags, this.ctab, this.btab, this.intang, this.fragID, this.partialClean, this.levelAheadLimit, step_limit, this.opt, this.timeStart, this.timeLimit, this.timeStart_structure, this.timeLimit_structure, this.coll_dist_sq, d, pred, this.Debug);
        if (step_limit > 0) {
            Clean2D.correctCoordsForOptimization(m, atomFlags, 0.2635111111111111);
        }
        if (step_limit > 0) {
            if (Clean2D.checkMolCollapsion(m, atomFlags)) {
                if (this.Debug > 0) {
                    System.err.println("Collapsion after coordinate generation. Set coordinates without backtrack.");
                }
                this.generateCoordinates(m, atomFlags, this.ctab, this.btab, this.intang, this.fragID, this.partialClean, 0, 0, this.opt, 0L, 0L, 0L, 0L, 0.0, null, null, this.Debug);
                return false;
            }
            return true;
        }
        return true;
    }

    static void generateInternalAngleForFixedLigands(MoleculeGraph m, int[][] ctab, BondTable btab, double[][] intang) {
        int ac = m.getAtomCount();
        for (int i = 0; i < ac; ++i) {
            if (m.getAtom(i).getZ() != 2.0) continue;
            Clean2D.coordinate2IntAng(i, ctab[i], btab, m, intang);
        }
    }

    static void generateIntangAtPartialClean(MoleculeGraph m, int[][] ctab, BondTable btab, double[][] intang, int[][] atomInRing, int[][] cssr, BitSet[] rs, int[] atomFlags, boolean[] isRingBond) {
        for (int i = m.getAtomCount() - 1; i >= 0; --i) {
            int[] an = ctab[i];
            if ((atomFlags[i] & 0x200) == 0 || (atomFlags[i] & 0x8000) != 0 || !Clean2D.hasNonfixedLigand(m, an)) continue;
            Clean2D.generateIntAngForLigands(i, ctab, btab, m, intang, atomInRing, cssr, rs, atomFlags, false, isRingBond);
        }
    }

    boolean fixPartialRingCoordinates(MoleculeGraph m, int[][] ctab, BondTable btab, int[] atomFlags, double[][] intang, int[][] atomInRing, int[][] commRingAtomNu, int[][] cssr, BitSet[] ringBitset, boolean[] isRingBond, int[] fragID, IntVector[] MoleculeInvariants, IntVector[] CageMolInv, boolean forceTemplates, String[] template_local, PartialOptimization opt, int Debug2) {
        int sl = cssr.length;
        int ac = m.getAtomCount();
        BitSet ringSet = new BitSet(sl);
        for (int i = ringBitset.length - 1; i >= 0; --i) {
            ringSet.set(i);
        }
        BitSet ringSystemSet = new BitSet(sl);
        while (Clean2D.locateRingSystem(ringSystemSet, ringSet, commRingAtomNu)) {
            if (Debug2 > 0) {
                System.err.println("Partial clean Ring System " + ringSystemSet.toString() + "  " + ringSet.toString());
            }
            Clean2D.assignFragIdToRingSystem(ringSystemSet, cssr, fragID);
            BitSet commonBonds = new BitSet(m.getBondCount());
            int[] ringRemovalOrder = Clean2D.partialCleanRingDegradation(ringBitset, ringSystemSet, commonBonds, cssr, atomFlags, m);
            BitSet ringSystemAtoms = new BitSet(m.getAtomCount());
            boolean hasfixedAtoms = Clean2D.hasAtomFixedPartialClean(ringSystemSet, cssr, atomFlags);
            boolean success = true;
            if (hasfixedAtoms) {
                success = this.setRootSystemFromPartialInfo(m, ringBitset, ringSystemSet, intang, cssr, btab, ringSystemAtoms, atomInRing, commonBonds, MoleculeInvariants, CageMolInv, forceTemplates, template_local, Debug2, opt, atomFlags, isRingBond);
            } else {
                double[] c = this.setRingSystem(m, ringBitset, ringSystemSet, ringSystemAtoms, cssr, btab, commonBonds, MoleculeInvariants, CageMolInv, forceTemplates, template_local, atomFlags, Debug2, opt, null);
                if (c == null) {
                    return false;
                }
                int n = 0;
                int k = ringSystemAtoms.nextSetBit(0);
                while (k >= 0) {
                    MolAtom a = m.getAtom(k);
                    a.setXYZ(c[n], c[n + 1], 2.0);
                    n += 2;
                    k = ringSystemAtoms.nextSetBit(k + 1);
                }
            }
            if (!success) {
                return false;
            }
            BitSet complexRingSet = new BitSet(sl);
            for (int i = ringRemovalOrder.length - 1; i >= 0; --i) {
                int ridx = ringRemovalOrder[i];
                complexRingSet.clear();
                complexRingSet.set(ridx);
                BitSet ringAtomSetToAttach = new BitSet(ac);
                double[] c = this.setRingSystem(m, ringBitset, complexRingSet, ringAtomSetToAttach, cssr, btab, commonBonds, MoleculeInvariants, CageMolInv, forceTemplates, template_local, atomFlags, Debug2, opt, null);
                if (c == null) {
                    return false;
                }
                Clean2D.connectToFixedSystem(c, m, ringAtomSetToAttach, ringSystemAtoms, Debug2);
                ringSystemSet.or(complexRingSet);
            }
            Clean2D.ringCoordsToIntang(m, ringSystemSet, cssr, ctab, btab, intang);
            Clean2D.generateIntAngForRingLigands(m, ringSystemSet, cssr, atomFlags, ctab, btab, intang, atomInRing, ringBitset, isRingBond);
            Clean2D.setZToIntAngle(m, ringSystemSet, cssr);
            ringSystemSet.clear();
        }
        return true;
    }

    boolean calcRingCoordinates(MoleculeGraph m, int[][] ctab, BondTable btab, int[] atomFlags, double[][] intang, int[][] atomInRing, int[][] commRingAtomNu, int[][] cssr, BitSet[] ringBitset, boolean[] isRingBond, int[] fragID, IntVector[] MoleculeInvariants, IntVector[] CageMolInv, boolean forceTemplates, String[] template_local, int Debug2, PartialOptimization opt, boolean[] align, long timeStart, long timeLimit, long timeStart_structure, long timeLimit_structure) {
        int ac = m.getAtomCount();
        int sl = cssr.length;
        BitSet ringSet = new BitSet(sl);
        for (int i = ringBitset.length - 1; i >= 0; --i) {
            ringSet.set(i);
        }
        BitSet ringSystemSet = new BitSet(sl);
        while (Clean2D.locateRingSystem(ringSystemSet, ringSet, commRingAtomNu)) {
            if (Debug2 > 0) {
                System.err.println("Ring System " + ringSystemSet.toString() + "  rest rings in the molecule " + ringSet.toString());
            }
            int fragmentID = Clean2D.assignFragIdToRingSystem(ringSystemSet, cssr, fragID);
            BitSet commonBonds = new BitSet(m.getBondCount());
            int[][] ringRemovalOrder = Clean2D.ringSeparation(ringBitset, ringSystemSet, commonBonds, m);
            BitSet complexRingSet = new BitSet(sl);
            BitSet ringSystemAtoms = new BitSet(ac);
            for (int i = ringRemovalOrder.length - 1; i >= 0; --i) {
                if (Clean2D.timeLimit(timeStart, timeLimit, timeStart_structure, timeLimit_structure)) {
                    return false;
                }
                int[] ring = ringRemovalOrder[i];
                if (Debug2 > 1) {
                    System.err.print("Set coordinates and attach rings: ");
                    for (int k = 0; k < ring.length; ++k) {
                        System.err.print(ring[k] + " ");
                    }
                    System.err.println("\n     fixed rings " + ringSystemSet);
                }
                complexRingSet.clear();
                for (int j = 0; j < ring.length; ++j) {
                    complexRingSet.set(ring[j]);
                }
                BitSet ringAtomSetToAttach = new BitSet(ac);
                double[] c = this.setRingSystem(m, ringBitset, complexRingSet, ringAtomSetToAttach, cssr, btab, commonBonds, MoleculeInvariants, CageMolInv, forceTemplates, template_local, atomFlags, Debug2, opt, align);
                if (c == null) {
                    return false;
                }
                if (ringSystemSet.cardinality() != 0) {
                    Clean2D.connectToFixedSystem(c, m, ringAtomSetToAttach, ringSystemAtoms, Debug2);
                } else {
                    int n = 0;
                    int k = ringAtomSetToAttach.nextSetBit(0);
                    while (k >= 0) {
                        MolAtom a = m.getAtom(k);
                        a.setXYZ(c[n], c[n + 1], 2.0);
                        n += 2;
                        ringSystemAtoms.set(k);
                        k = ringAtomSetToAttach.nextSetBit(k + 1);
                    }
                }
                if (ring.length == 1) {
                    ringSystemSet.set(ring[0]);
                    continue;
                }
                ringSystemSet.or(complexRingSet);
            }
            Clean2D.postProcessRingSystem(ringSystemSet, ringBitset, m, fragmentID, fragID, atomFlags, Debug2);
            Clean2D.ringCoordsToIntang(m, ringSystemSet, cssr, ctab, btab, intang);
            Clean2D.generateIntAngForRingLigands(m, ringSystemSet, cssr, atomFlags, ctab, btab, intang, atomInRing, ringBitset, isRingBond);
            Clean2D.setZToIntAngle(m, ringSystemSet, cssr);
            ringSystemSet.clear();
        }
        return true;
    }

    static boolean locateRingSystem(BitSet ringSystemSet, BitSet ringSet, int[][] commAtNu) {
        if (ringSet.cardinality() == 0) {
            return false;
        }
        int f_idx = -1;
        for (int i = commAtNu.length - 1; i >= 0 && f_idx < 0; --i) {
            if (!ringSet.get(i)) continue;
            ringSystemSet.set(i);
            ringSet.clear(i);
            f_idx = i;
        }
        boolean added = false;
        do {
            added = false;
            for (int i = f_idx; i >= 0; --i) {
                if (!ringSystemSet.get(i)) continue;
                for (int j = f_idx - 1; j >= 0; --j) {
                    if (!ringSet.get(j) || commAtNu[i][j] <= 0) continue;
                    ringSystemSet.set(j);
                    ringSet.clear(j);
                    added = true;
                }
            }
        } while (added);
        return true;
    }

    static int assignFragIdToRingSystem(BitSet ringSystemSet, int[][] cssr, int[] fragID) {
        int n = fragID.length - 1;
        int n2 = fragID[n];
        fragID[n] = n2 + 1;
        int id = n2;
        for (int i = cssr.length - 1; i >= 0; --i) {
            if (!ringSystemSet.get(i)) continue;
            int[] r = cssr[i];
            for (int j = r.length - 1; j >= 0; --j) {
                int sid = fragID[r[j]] & 0xFFFF0000;
                fragID[r[j]] = id + sid;
            }
        }
        return id;
    }

    static int[] partialCleanRingDegradation(BitSet[] rs, BitSet ringSet, BitSet cb, int[][] cssr, int[] atomFlags, MoleculeGraph m) {
        int[] ringRemovalOrder = new int[rs.length];
        boolean[] smallRings = new boolean[rs.length];
        boolean[] fullyFixedR = new boolean[rs.length];
        for (int i = rs.length - 1; i >= 0; --i) {
            int[] r = cssr[i];
            fullyFixedR[i] = true;
            for (int j = r.length - 1; j > 0; --j) {
                if ((atomFlags[r[j]] & 0x200) != 0) continue;
                fullyFixedR[i] = false;
                break;
            }
            if (r.length >= 10) continue;
            smallRings[i] = true;
        }
        int n = 0;
        int common = 1;
        boolean removed = false;
        do {
            removed = false;
            for (int i = rs.length - 1; i >= 0; --i) {
                if (!ringSet.get(i) || !smallRings[i] || fullyFixedR[i] || !Clean2D.checkRingCommonIdx(i, common, rs, ringSet, cb, m)) continue;
                ringRemovalOrder[n++] = i;
                ringSet.clear(i);
                removed = true;
            }
            if (removed) {
                common = 1;
                continue;
            }
            ++common;
        } while (common < 3 || removed);
        int[] tmp = new int[n];
        System.arraycopy(ringRemovalOrder, 0, tmp, 0, n);
        return tmp;
    }

    static boolean checkRingCommonIdx(int idx, int common, BitSet[] rs, BitSet ringSet, BitSet cb, MoleculeGraph m) {
        BondTable btab = null;
        BitSet tmp = new BitSet(rs[0].length());
        BitSet checkRingSet = new BitSet(rs[0].length());
        BitSet commonBits = new BitSet(rs[0].length());
        BitSet commonBond = new BitSet(cb.size());
        checkRingSet.or(rs[idx]);
        boolean found = false;
        for (int i = rs.length - 1; i >= 0; --i) {
            if (idx == i || !ringSet.get(i)) continue;
            checkRingSet.and(rs[i]);
            int c = checkRingSet.cardinality();
            if (c > 0) {
                if (c == common) {
                    if (!found) {
                        int a2;
                        int a1;
                        int b_idx;
                        commonBits.or(checkRingSet);
                        if (c == 2 && (b_idx = (btab = btab == null ? m.getBondTable() : btab).getBondIndex(a1 = checkRingSet.nextSetBit(0), a2 = checkRingSet.nextSetBit(a1 + 1))) >= 0) {
                            commonBond.set(b_idx);
                            found = true;
                        }
                    } else if (commonBits.cardinality() < common) {
                        tmp.or(checkRingSet);
                        tmp.or(commonBits);
                        if (!tmp.equals(checkRingSet)) {
                            return false;
                        }
                        commonBits.or(checkRingSet);
                    } else {
                        tmp.or(commonBits);
                        tmp.or(checkRingSet);
                        if (!tmp.equals(commonBits)) {
                            return false;
                        }
                    }
                } else {
                    if (c > common) {
                        return false;
                    }
                    if (!found) {
                        commonBits.or(checkRingSet);
                        found = true;
                    } else {
                        tmp.or(commonBits);
                        tmp.or(checkRingSet);
                        if (!tmp.equals(commonBits)) {
                            return false;
                        }
                        tmp.clear();
                    }
                }
            }
            checkRingSet.or(rs[idx]);
        }
        if (found) {
            cb.or(commonBond);
        }
        return found;
    }

    static int[][] ringSeparation(BitSet[] rs, BitSet ringSet, BitSet cb, MoleculeGraph m) {
        int rsl = rs.length;
        int[][] ringRemovalOrder = new int[rsl][];
        MoleculeGraph ringGraph = new MoleculeGraph();
        for (int i = 0; i < rsl; ++i) {
            if (!ringSet.get(i)) continue;
            MolAtom a = new MolAtom(6);
            a.setAtomMap(i);
            ringGraph.add(a);
        }
        int rac = ringGraph.getAtomCount();
        BitSet commonAtomSet = new BitSet();
        for (int i = 0; i < rac; ++i) {
            MolAtom r1 = ringGraph.getAtom(i);
            BitSet set1 = rs[r1.getAtomMap()];
            block7: for (int j = i + 1; j < rac; ++j) {
                commonAtomSet.clear();
                commonAtomSet.or(set1);
                MolAtom r2 = ringGraph.getAtom(j);
                BitSet set2 = rs[r2.getAtomMap()];
                commonAtomSet.and(set2);
                switch (commonAtomSet.cardinality()) {
                    case 0: {
                        continue block7;
                    }
                    case 1: {
                        ringGraph.add(new MolBond(r1, r2, 1));
                        continue block7;
                    }
                    case 2: {
                        ringGraph.add(new MolBond(r1, r2, 2));
                        continue block7;
                    }
                    default: {
                        ringGraph.add(new MolBond(r1, r2, 3));
                    }
                }
            }
        }
        int removed = 0;
        BitSet removedAtomSet = new BitSet();
        do {
            removedAtomSet.clear();
            commonAtomSet.clear();
            int[] removedIdxes = Clean2D.findRemovableNodes(ringGraph, rs);
            for (int i = removedIdxes.length - 1; i >= 0; --i) {
                ringSet.clear(removedIdxes[i]);
                removedAtomSet.or(rs[removedIdxes[i]]);
            }
            Clean2D.setCurrentAtomset(commonAtomSet, rs, ringSet);
            commonAtomSet.and(removedAtomSet);
            if (commonAtomSet.cardinality() > 1) {
                Clean2D.setCommonBonds(commonAtomSet, cb, m);
            }
            ringRemovalOrder[removed++] = removedIdxes;
        } while (ringSet.cardinality() > 0);
        int[][] tmp = new int[removed][];
        System.arraycopy(ringRemovalOrder, 0, tmp, 0, removed);
        return tmp;
    }

    static void removeDuplicatBondsFromRing(MoleculeGraph g, BitSet[] rs) {
        int[][] sssr = g.getSSSR();
        for (int i = 0; i < sssr.length; ++i) {
            int[] r = sssr[i];
            int l = r.length;
            BitSet[] cas = new BitSet[l];
            for (int j = 0; j < l; ++j) {
                int h = r[j];
                int n = r[(j + 1) % l];
                int ringIdx1 = g.getAtom(h).getAtomMap();
                int ringIdx2 = g.getAtom(n).getAtomMap();
                BitSet t = new BitSet();
                t.or(rs[ringIdx1]);
                t.and(rs[ringIdx2]);
                cas[j] = t;
            }
            int remove = -1;
            for (int j = 0; j < l && remove < 0; ++j) {
                BitSet set1 = cas[j];
                for (int k = j + 1; k < l && remove < 0; ++k) {
                    if (!set1.equals(cas[k])) continue;
                    remove = k;
                }
            }
            if (remove < 0) continue;
            MolAtom a1 = g.getAtom(r[remove]);
            MolAtom a2 = g.getAtom(r[(remove + 1) % l]);
            MolBond e = a1.getBondTo(a2);
            g.removeBond(e);
        }
    }

    static void setCurrentAtomset(BitSet s, BitSet[] rs, BitSet ringSet) {
        int i = ringSet.nextSetBit(0);
        while (i >= 0) {
            s.or(rs[i]);
            i = ringSet.nextSetBit(i + 1);
        }
    }

    static void setCommonBonds(BitSet c, BitSet cb, MoleculeGraph m) {
        BondTable btab = m.getBondTable();
        int i = c.nextSetBit(0);
        while (i >= 0) {
            int j = c.nextSetBit(i + 1);
            while (j >= 0) {
                int bidx = btab.getBondIndex(i, j);
                if (bidx >= 0) {
                    cb.set(bidx);
                }
                j = c.nextSetBit(j + 1);
            }
            i = c.nextSetBit(i + 1);
        }
    }

    static int[] findRemovableNodes(MoleculeGraph g, BitSet[] rs) {
        int[] ringIdxes = null;
        MolAtom t1Atom = null;
        MolAtom t2Atom = null;
        for (int i = g.getAtomCount() - 1; i >= 0; --i) {
            MolAtom n = g.getAtom(i);
            if (n.getBondCount() != 1) continue;
            MolBond b = n.getBond(0);
            int cc = b.getType();
            if (cc == 1) {
                t1Atom = n;
                break;
            }
            if (cc != 2) continue;
            t2Atom = n;
        }
        if (t1Atom != null) {
            g.removeAtom(t1Atom);
            return new int[]{t1Atom.getAtomMap()};
        }
        if (t2Atom != null) {
            g.removeAtom(t2Atom);
            return new int[]{t2Atom.getAtomMap()};
        }
        Clean2D.removeDuplicatBondsFromRing(g, rs);
        MoleculeGraph[] gf = g.findFrags(SelectionMolecule.class, 1);
        if (gf.length != 1) {
            if (gf.length > 2 && Error == 1) {
                System.err.println("Some unexpected situation in findRemovableNodes");
            }
            for (int i = gf.length - 1; i >= 0; --i) {
                MoleculeGraph sg = gf[i];
                boolean hasTerminal = false;
                for (int j = sg.getAtomCount() - 1; j >= 0; --j) {
                    MolAtom n = sg.getAtom(j);
                    if (n.getBondCount() != 1) continue;
                    hasTerminal = true;
                    break;
                }
                if (hasTerminal) continue;
                int nc = sg.getAtomCount();
                ringIdxes = new int[nc];
                for (int j = nc - 1; j >= 0; --j) {
                    MolAtom n = sg.getAtom(j);
                    ringIdxes[j] = n.getAtomMap();
                    g.removeAtom(n);
                }
                return ringIdxes;
            }
        }
        int grSize = Integer.MAX_VALUE;
        MolBond breakb = null;
        for (int i = g.getBondCount() - 1; i >= 0; --i) {
            MolBond b = g.getBond(i);
            int cc = b.getType();
            if (cc >= 3) continue;
            g.removeBond(b);
            MoleculeGraph[] f = g.findFrags(SelectionMolecule.class, 1);
            boolean smallerFrag = false;
            boolean equalFrag = false;
            for (int j = 0; j < f.length; ++j) {
                int fnc = f[j].getAtomCount();
                if (fnc < grSize) {
                    grSize = fnc;
                    smallerFrag = true;
                    continue;
                }
                if (fnc != grSize || smallerFrag) continue;
                equalFrag = true;
            }
            if (cc == 1 && (smallerFrag || equalFrag)) {
                breakb = b;
            } else if (cc == 2 && smallerFrag) {
                breakb = b;
            }
            g.add(b);
        }
        if (breakb != null) {
            g.removeBond(breakb);
            MoleculeGraph[] f = g.findFrags(SelectionMolecule.class, 1);
            MoleculeGraph frag = null;
            for (int j = 0; j < f.length; ++j) {
                int fnc = f[j].getAtomCount();
                if (fnc != grSize) continue;
                frag = f[j];
                break;
            }
            ringIdxes = new int[grSize];
            for (int i = grSize - 1; i >= 0; --i) {
                MolAtom n = frag.getAtom(i);
                ringIdxes[i] = n.getAtomMap();
                g.removeAtom(n);
            }
        } else {
            int nc = g.getAtomCount();
            ringIdxes = new int[nc];
            for (int i = nc - 1; i >= 0; --i) {
                MolAtom n = g.getAtom(i);
                ringIdxes[i] = n.getAtomMap();
                g.removeAtom(i);
            }
        }
        return ringIdxes;
    }

    static void postProcessRingSystem(BitSet ringSystemSet, BitSet[] ringBitset, MoleculeGraph m, int fID, int[] fragID, int[] atomFlags, int Debug2) {
        IntVector[] spiroRingConnIdxes = null;
        IntVector spiroAtomIdxes = new IntVector();
        spiroRingConnIdxes = Clean2D.locateSpiroAtomIdxes(ringSystemSet, ringBitset, spiroAtomIdxes, atomFlags);
        if (spiroRingConnIdxes == null || !Clean2D.coincidingAtoms(fID, m, fragID, 0.0154)) {
            return;
        }
        if (Debug2 > 2) {
            System.err.println("arrangeSpiroRingConnections");
        }
        int i = 0;
        do {
            int idx = spiroAtomIdxes.get(i);
            if (spiroRingConnIdxes[i].size() <= 2) continue;
            Clean2D.rearrangeAndElongateSpiro(idx, m, ringSystemSet, ringBitset, spiroRingConnIdxes[i]);
        } while (Clean2D.coincidingAtoms(fID, m, fragID, 0.0154) && ++i < spiroAtomIdxes.size());
    }

    static IntVector[] locateSpiroAtomIdxes(BitSet ringSystemSet, BitSet[] ringBitset, IntVector idxes, int[] atomFlags) {
        int l = ringSystemSet.length();
        IntVector[] spCR = new IntVector[]{};
        BitSet commonSet = new BitSet(ringBitset[0].size());
        for (int i = 0; i < l; ++i) {
            if (!ringSystemSet.get(i)) continue;
            BitSet s1 = ringBitset[i];
            commonSet.or(s1);
            for (int j = i + 1; j < l; ++j) {
                if (!ringSystemSet.get(j)) continue;
                BitSet s2 = ringBitset[j];
                commonSet.and(s2);
                if (commonSet.cardinality() == 1) {
                    int spiroIdx;
                    int n = spiroIdx = commonSet.nextSetBit(0);
                    atomFlags[n] = atomFlags[n] | 0x10000;
                    int index = idxes.indexOf(spiroIdx);
                    if (index < 0) {
                        idxes.add(spiroIdx);
                        int size = idxes.size();
                        IntVector spr = new IntVector();
                        spr.add(i);
                        spr.add(j);
                        if (size > spCR.length) {
                            IntVector[] tmp = new IntVector[size];
                            System.arraycopy(spCR, 0, tmp, 0, size - 1);
                            spCR = tmp;
                        }
                        spCR[size - 1] = spr;
                    } else {
                        IntVector spr = spCR[index];
                        if (!spr.contains(i)) {
                            spr.add(i);
                        }
                        if (!spr.contains(j)) {
                            spr.add(j);
                        }
                    }
                }
                commonSet.or(s1);
            }
            commonSet.clear();
        }
        return spCR.length == 0 ? null : spCR;
    }

    static void rearrangeAndElongateSpiro(int idx, MoleculeGraph m, BitSet ringSystemSet, BitSet[] ringBitset, IntVector ringIdxes) {
        int i;
        MolAtom a = m.getAtom(idx);
        int[] spiroRingIdx = ringIdxes.toArray();
        int n = spiroRingIdx.length;
        BitSet[] system = new BitSet[n];
        double[][] cm = new double[n][];
        for (int i2 = 0; i2 < n; ++i2) {
            system[i2] = Clean2D.getSystemFromRing(spiroRingIdx[i2], idx, ringSystemSet, ringBitset);
            system[i2].clear(idx);
            cm[i2] = Clean2D.calcCM(ringBitset[spiroRingIdx[i2]], m);
        }
        double fi_rot = Math.PI * 2 / (double)n;
        DPoint3 c = a.getLocation();
        double fi_0 = c.angle2D(cm[0][0], cm[0][1]);
        CTransform3D T = new CTransform3D();
        for (i = 1; i < n; ++i) {
            double fi = fi_0 + (double)i * fi_rot;
            double fi_orig = c.angle2D(cm[i][0], cm[i][1]);
            T.setIdentity();
            T.setRotation(0.0, 0.0, 1.0, fi - fi_orig);
            T.setRotationCenter(c);
            Clean2D.transform(system[i], m, T);
        }
        for (i = 0; i < n; ++i) {
            cm[i] = Clean2D.calcCM(ringBitset[spiroRingIdx[i]], m);
            T.setIdentity();
            T.setTranslation(cm[i][0] - c.x, cm[i][1] - c.y, 0.0);
            Clean2D.transform(system[i], m, T);
        }
    }

    static BitSet getSystemFromRing(int spiroRingIdx, int idx, BitSet ringSystemSet, BitSet[] ringBitset) {
        BitSet set = (BitSet)ringSystemSet.clone();
        BitSet toFlip = new BitSet();
        toFlip.or(ringBitset[spiroRingIdx]);
        set.clear(spiroRingIdx);
        int l = ringSystemSet.length();
        boolean added = false;
        do {
            added = false;
            for (int i = 0; i < l; ++i) {
                if (!set.get(i) || ringBitset[i].get(idx) || !toFlip.intersects(ringBitset[i])) continue;
                toFlip.or(ringBitset[i]);
                set.clear(i);
                added = true;
            }
        } while (added);
        return toFlip;
    }

    static boolean hasAtomFixedPartialClean(BitSet ringSet, int[][] cssr, int[] atomFlags) {
        for (int i = ringSet.length() - 1; i >= 0; --i) {
            if (!ringSet.get(i)) continue;
            int[] r = cssr[i];
            for (int j = r.length - 1; j >= 0; --j) {
                int idx = r[j];
                if ((atomFlags[idx] & 0x200) == 0) continue;
                return true;
            }
        }
        return false;
    }

    boolean setRootSystemFromPartialInfo(MoleculeGraph m, BitSet[] rs, BitSet ringSet, double[][] intang, int[][] cssr, BondTable btab, BitSet ringA, int[][] atomInRing, BitSet cb, IntVector[] MoleculeInvariants, IntVector[] CageMolInv, boolean forceTemplates, String[] template_local, int Debug2, PartialOptimization opt, int[] atomFlags, boolean[] isRingBond) {
        if (Debug2 > 1) {
            System.err.println("setRootSystemFromPartialInfo ");
        }
        int ac = m.getAtomCount();
        int oneFixedIdx = -1;
        int fixedAtomCount = 0;
        int i = ringSet.nextSetBit(0);
        while (i >= 0) {
            if (ringSet.get(i)) {
                int[] r = cssr[i];
                for (int j = r.length - 1; j >= 0; --j) {
                    int idx = r[j];
                    if (!ringA.get(idx) && (atomFlags[idx] & 0x200) != 0) {
                        oneFixedIdx = idx;
                        ++fixedAtomCount;
                    }
                    ringA.set(idx);
                }
            }
            i = ringSet.nextSetBit(i + 1);
        }
        int nOfAtomInTheSystem = ringA.cardinality();
        if (nOfAtomInTheSystem <= fixedAtomCount) {
            int[] fixedIdxes = new int[fixedAtomCount];
            int n = 0;
            for (int i2 = ringA.length() - 1; i2 >= 0; --i2) {
                if (!ringA.get(i2)) continue;
                fixedIdxes[n++] = i2;
            }
            Clean2D.setZ(fixedIdxes, m, 2.0);
            return true;
        }
        if (fixedAtomCount == 1) {
            MolAtom a;
            int[][] ctab = m.getCtab();
            MolAtom fixedAtom = m.getAtom(oneFixedIdx);
            DPoint3 c_orig = fixedAtom.getLocation();
            double[] c = this.setRingSystem(m, rs, ringSet, ringA, cssr, btab, cb, MoleculeInvariants, CageMolInv, forceTemplates, template_local, atomFlags, Debug2, opt, null);
            if (c == null) {
                return false;
            }
            int n = 0;
            int k = ringA.nextSetBit(0);
            while (k >= 0) {
                MolAtom a2 = m.getAtom(k);
                a2.setXYZ(c[n], c[n + 1], 2.0);
                n += 2;
                k = ringA.nextSetBit(k + 1);
            }
            DPoint3 c_t = fixedAtom.getLocation();
            CTransform3D T = new CTransform3D();
            T.setTranslation(c_orig.x - c_t.x, c_orig.y - c_t.y, 0.0);
            for (int i3 = 0; i3 < ac; ++i3) {
                if (!ringA.get(i3)) continue;
                MolAtom a3 = m.getAtom(i3);
                a3.transform(T, false);
            }
            Clean2D.ringCoordsToIntang(m, ringSet, cssr, ctab, btab, intang);
            Clean2D.generateIntAngForLigands(oneFixedIdx, ctab, btab, m, intang, atomInRing, cssr, rs, atomFlags, false, isRingBond);
            int fixedLigandIdx = -1;
            double fixedLigandAngle = 0.0;
            int nonFixedLigandIdx = -1;
            for (int idx : ctab[oneFixedIdx]) {
                a = m.getAtom(idx);
                if (a.getZ() == 2.0) {
                    fixedLigandIdx = idx;
                    fixedLigandAngle = c_orig.angle2D(a.getX(), a.getY());
                    continue;
                }
                nonFixedLigandIdx = idx;
            }
            if (fixedLigandIdx >= 0 && nonFixedLigandIdx >= 0) {
                double fi = intang[btab.getBondIndex(fixedLigandIdx, oneFixedIdx)][btab.getBondIndex(nonFixedLigandIdx, oneFixedIdx)];
                a = m.getAtom(nonFixedLigandIdx);
                double fi_0 = c_orig.angle2D(a.getX(), a.getY());
                T.setIdentity();
                T.setRotation(0.0, 0.0, 1.0, fi_0 - (fixedLigandAngle + fi));
                T.setRotationCenter(c_orig);
                for (int i4 = 0; i4 < ac; ++i4) {
                    if (!ringA.get(i4)) continue;
                    a = m.getAtom(i4);
                    a.transform(T, false);
                }
            }
            return true;
        }
        Clean2D.generateNonFixedCordinates(ringSet, m, atomFlags, cssr, ringA);
        int[] idxToIdx = new int[ac];
        boolean[] fixed = new boolean[nOfAtomInTheSystem];
        double[] coords = new double[nOfAtomInTheSystem * 2];
        int n = 0;
        for (int i5 = 0; i5 < ac; ++i5) {
            if (ringA.get(i5)) {
                idxToIdx[i5] = n;
                MolAtom a = m.getAtom(i5);
                if ((atomFlags[i5] & 0x200) != 0) {
                    fixed[n] = true;
                }
                coords[n * 2] = a.getX();
                coords[n++ * 2 + 1] = a.getY();
                continue;
            }
            idxToIdx[i5] = -1;
        }
        int bc = m.getBondCount();
        int[] eP1 = new int[bc];
        int[] eP2 = new int[bc];
        n = 0;
        for (int i6 = 0; i6 < bc; ++i6) {
            MolBond b = m.getBond(i6);
            int n1 = m.indexOf(b.getAtom1());
            int n2 = m.indexOf(b.getAtom2());
            if (!ringA.get(n1) || !ringA.get(n2)) continue;
            eP1[n] = idxToIdx[n1];
            eP2[n++] = idxToIdx[n2];
        }
        int[] tmp = new int[n];
        System.arraycopy(eP1, 0, tmp, 0, n);
        eP1 = tmp;
        tmp = new int[n];
        System.arraycopy(eP2, 0, tmp, 0, n);
        eP2 = tmp;
        int[] iter = new int[]{0};
        double[] d = new double[coords.length];
        PartialOptimization.access$102(opt, eP1);
        PartialOptimization.access$202(opt, eP2);
        PartialOptimization.access$302(opt, fixed);
        opt.btab = m.getBondTable();
        try {
            opt.frprmin(coords, null, 1.0E-5, iter, d, System.currentTimeMillis());
        }
        catch (Exception e) {
            return false;
        }
        n = 0;
        if (Clean2D.ringCoordsAreConvex(coords, idxToIdx, ringSet, cssr, atomFlags)) {
            for (int i7 = 0; i7 < ac; ++i7) {
                if (!ringA.get(i7)) continue;
                MolAtom a = m.getAtom(i7);
                a.setXYZ(coords[n * 2], coords[n * 2 + 1], 2.0);
                if ((atomFlags[i7] & 0x200) == 0) {
                    int n2 = i7;
                    atomFlags[n2] = atomFlags[n2] | 0x200;
                }
                ++n;
            }
        }
        return true;
    }

    static boolean ringCoordsAreConvex(double[] coords, int[] idxToIdx, BitSet ringSet, int[][] cssr, int[] atomFlags) {
        int i = ringSet.nextSetBit(0);
        while (i >= 0) {
            int idx;
            int j;
            int[] r = cssr[i];
            double[] c = new double[r.length * 2];
            for (j = r.length - 1; j >= 0; --j) {
                idx = idxToIdx[r[j]];
                c[j * 2] = coords[idx * 2];
                c[j * 2 + 1] = coords[idx * 2 + 1];
            }
            for (j = r.length - 1; j >= 0; --j) {
                idx = idxToIdx[r[j]];
                if ((atomFlags[idx] & 0x200) != 0 || Clean2D.isConvex(j, c)) continue;
                return false;
            }
            i = ringSet.nextSetBit(i + 1);
        }
        return true;
    }

    static void generateNonFixedCordinates(BitSet ringSet, MoleculeGraph m, int[] atomFlags, int[][] sssr, BitSet ringA) {
        int setL = ringSet.cardinality();
        if (setL > 1) {
            return;
        }
        int[] r = sssr[ringSet.nextSetBit(0)];
        int l = r.length;
        double[] c = new double[l * 2];
        Clean2D.idealPolygon(c);
        double[] cc = new double[l * 2];
        int n = 0;
        int i = ringA.nextSetBit(0);
        while (i >= 0) {
            int idx = Clean2D.indexOf(r, i);
            cc[n++] = c[idx * 2];
            cc[n++] = c[idx * 2 + 1];
            i = ringA.nextSetBit(i + 1);
        }
        c = cc;
        Clean2D.fitCoordinatesToAtoms(c, r, m, atomFlags, ringA);
        n = 0;
        i = ringA.nextSetBit(0);
        while (i >= 0) {
            MolAtom a = m.getAtom(i);
            if (a.getZ() != 2.0 && (atomFlags[i] & 0x200) == 0) {
                a.setXYZ(c[n * 2], c[n * 2 + 1], 2.0);
            }
            ++n;
            i = ringA.nextSetBit(i + 1);
        }
    }

    static void fitCoordinatesToAtoms(double[] c, int[] r, MoleculeGraph m, int[] atomFlags, BitSet ringA) {
        int l = r.length;
        BitSet fixedRingAtoms = new BitSet(atomFlags.length);
        for (int i = 0; i < l; ++i) {
            int idx = r[i];
            if ((atomFlags[idx] & 0x200) == 0 && m.getAtom(idx).getZ() != 2.0) continue;
            fixedRingAtoms.set(idx);
        }
        int idx1 = fixedRingAtoms.nextSetBit(0);
        int idx2 = fixedRingAtoms.nextSetBit(idx1 + 1);
        Clean2D.attachWOB(idx1, idx2, c, ringA, fixedRingAtoms, true, m, 0);
    }

    double[] setRingSystem(MoleculeGraph m, BitSet[] rs, BitSet ringSet, BitSet ringA, int[][] cssr, BondTable btab, BitSet cb, IntVector[] MoleculeInvariants, IntVector[] CageMolInv, boolean forceTemplates, String[] template_local, int[] atomFlags, int Debug2, PartialOptimization opt, boolean[] align) {
        boolean isCageMolecule;
        int i;
        MolAtom a;
        if (Debug2 > 2) {
            System.err.println("\tRings in system " + ringSet.toString());
        }
        boolean oneRing = false;
        if (ringSet.cardinality() == 1) {
            oneRing = true;
        }
        if (oneRing && !forceTemplates) {
            if (Debug2 > 2) {
                System.err.println("\tTry one ring with cis trans ");
            }
            int idx = ringSet.nextSetBit(0);
            int[] r = cssr[idx];
            double[] c = Clean2D.singleRingCoordinate(m, r, cb, btab, Debug2);
            ringA.or(rs[idx]);
            double[] coords = new double[c.length];
            int n = 0;
            int i2 = ringA.nextSetBit(0);
            while (i2 >= 0) {
                int k = Clean2D.indexOf(r, i2);
                coords[2 * n] = c[2 * k];
                coords[2 * n + 1] = c[2 * k + 1];
                ++n;
                i2 = ringA.nextSetBit(i2 + 1);
            }
            return coords;
        }
        boolean isMetalloOrganic = false;
        int rootAc = 0;
        int mac = m.getAtomCount();
        int i3 = ringSet.nextSetBit(0);
        while (i3 >= 0) {
            int[] r = cssr[i3];
            ringA.or(rs[i3]);
            for (int j = r.length - 1; j >= 0; --j) {
                int idx = r[j];
                a = m.getAtom(idx);
                if (a.getZ() == 10.0) continue;
                m.getAtom(idx).setZ(10.0);
                ++rootAc;
            }
            i3 = ringSet.nextSetBit(i3 + 1);
        }
        SelectionMolecule s = new SelectionMolecule();
        int[] convIdx = new int[rootAc];
        BitSet clc = new BitSet(rootAc);
        rootAc = 0;
        for (int i4 = 0; i4 < mac; ++i4) {
            a = m.getAtom(i4);
            if (a.getZ() != 10.0) continue;
            s.add(a);
            if (Clean2D.isHeavy(a)) {
                isMetalloOrganic = true;
            }
            convIdx[rootAc] = i4;
            for (int j = 0; j < a.getBondCount(); ++j) {
                MolAtom l = a.getLigand(j);
                if (l.getZ() == 10.0) continue;
                clc.set(rootAc);
                break;
            }
            ++rootAc;
        }
        int bc = m.getBondCount();
        for (int i5 = 0; i5 < bc; ++i5) {
            MolBond b = m.getBond(i5);
            MolAtom a1 = b.getAtom1();
            MolAtom a2 = b.getAtom2();
            if (a1.getZ() != 10.0 || a2.getZ() != 10.0) continue;
            s.add(b);
        }
        Molecule root = new Molecule();
        s.clonecopy(root);
        Clean2D.SSSWorkAround(root);
        root.setDim(0);
        bc = root.getBondCount();
        BitSet cb_t = new BitSet(bc);
        for (i = 0; i < bc; ++i) {
            MolAtom a4;
            MolAtom a1;
            MolBond b = root.getBond(i);
            MolAtom a2 = b.getAtom1();
            int i2 = root.indexOf(a2);
            MolAtom a3 = b.getAtom2();
            int i32 = root.indexOf(a3);
            MolAtom molAtom = a2.getBondCount() <= 1 ? null : (a1 = a2.getLigand(0) == a3 ? a2.getLigand(1) : a2.getLigand(0));
            MolAtom molAtom2 = a3.getBondCount() <= 1 ? null : (a4 = a3.getLigand(0) == a2 ? a3.getLigand(1) : a3.getLigand(0));
            if (a1 != null && a4 != null && b.getType() == 2) {
                int bidx = btab.getBondIndex(convIdx[i2], convIdx[i32]);
                if ((b.getFlags() & 0xC0) != 0) {
                    int i1 = root.indexOf(a1);
                    int i4 = root.indexOf(a4);
                    MolBond b_m = m.getBond(bidx);
                    a1 = m.getAtom(convIdx[i1]);
                    a4 = m.getAtom(convIdx[i4]);
                    int f = b_m.transformCT(a1, a4, b_m.getFlags());
                    b.setFlags(f);
                    continue;
                }
                if (!cb.get(bidx)) continue;
                cb_t.set(i);
                continue;
            }
            b.setFlags(b.getFlags() & 0xFFFFFF3F);
        }
        cb = cb_t;
        if (isMetalloOrganic && !Clean2D.hasMulticentSGroup(ringA, (Molecule)m)) {
            if (Debug2 > 2) {
                System.err.println("\tCONVERT to MULTICENTER");
            }
            if (Clean2D.changeToAndCleanMulticenter(root, m, rs, convIdx, opt, Debug2)) {
                if (Debug2 > 2) {
                    System.err.println("\tMULTICENTER clean successful");
                }
                i = ringA.nextSetBit(0);
                while (i >= 0) {
                    int n = i;
                    atomFlags[n] = atomFlags[n] | 0x4000;
                    i = ringA.nextSetBit(i + 1);
                }
                return Clean2D.getMolCoordinates(root);
            }
            if (Debug2 > 2) {
                System.err.println("\tMULTICENTER clean fail or not necessary");
            }
        }
        int sssrl = root.getBondCount() - root.getAtomCount() + 1;
        boolean bl = isCageMolecule = ringSet.cardinality() != sssrl;
        if (Debug2 > 2) {
            System.err.println("\tCAGE root system " + isCageMolecule + " common bonds " + cb.toString());
        }
        if (isCageMolecule) {
            boolean[] isCageWithPossBondRearr = new boolean[1];
            boolean success = Clean2D.setCoordinatesFromCageTemplates(cb, clc, root, CageMolInv, isCageWithPossBondRearr, Debug2);
            if (!success) {
                if (Debug2 > 1) {
                    System.err.println("\tcage root template not found\n");
                }
                Clean2D.setCoordinatesForCageRingSystem(cb, clc, root, opt, Debug2);
            } else if (align != null) {
                align[0] = false;
            }
            int i6 = ringA.nextSetBit(0);
            while (i6 >= 0) {
                int n = i6;
                atomFlags[n] = atomFlags[n] | 0x2000;
                i6 = ringA.nextSetBit(i6 + 1);
            }
            if (isCageWithPossBondRearr[0]) {
                i6 = ringA.nextSetBit(0);
                while (i6 >= 0) {
                    int n = i6;
                    atomFlags[n] = atomFlags[n] | 0x200000;
                    i6 = ringA.nextSetBit(i6 + 1);
                }
            }
            return Clean2D.getMolCoordinates(root);
        }
        if (Clean2D.setCoordinatesFromTemplates(cb, null, root, MoleculeInvariants, template_local, Debug2)) {
            if (Debug2 > 0) {
                System.err.println("\tCoordinate set from template");
            }
            if (align != null) {
                align[0] = false;
            }
            return Clean2D.getMolCoordinates(root);
        }
        this.buildFromSimpleRings(root, cb, opt, Debug2);
        if (Debug2 > 0) {
            System.err.println("\tCoordinate set from simple rings");
        }
        return Clean2D.getMolCoordinates(root);
    }

    static double[] getMolCoordinates(MoleculeGraph m) {
        int ac = m.getAtomCount();
        double[] c = new double[ac * 2];
        for (int i = 0; i < ac; ++i) {
            MolAtom a = m.getAtom(i);
            c[2 * i] = a.getX();
            c[2 * i + 1] = a.getY();
        }
        return c;
    }

    static void setCoordinatesForCageRingSystem(BitSet cb, BitSet clc, MoleculeGraph m, PartialOptimization opt, int Debug2) {
        int[] r;
        if (Debug2 > 1) {
            System.err.println("setCoordinatesForCageRingSystem ");
        }
        if ((r = Clean2D.getLargestSet(cb, clc, m)) == null) {
            if (Debug2 > 1) {
                System.err.println("getLargestSet fail");
            }
            r = m.getSSSR()[0];
        }
        double[] c = new double[r.length * 2];
        Clean2D.idealPolygon(c);
        for (int i = 0; i < r.length; ++i) {
            MolAtom a = m.getAtom(r[i]);
            a.setXYZ(c[i * 2], c[i * 2 + 1], 2.0);
        }
        int[][] sssr = m.getSSSR();
        int l = sssr.length;
        int ac = m.getAtomCount();
        while (Clean2D.getFixedAtomCount(m) != ac) {
            BitSet fixedAtoms = Clean2D.getFixedIdxSet(m);
            for (int i = 0; i < l; ++i) {
                int[] bridge = Clean2D.convertContinuousAtomIndex(sssr[i], fixedAtoms);
                if (bridge == null) continue;
                Clean2D.arrangeAtomsInLine(bridge, m);
            }
        }
        if (Clean2D.checkMolCollapsion(m)) {
            Clean2D.correctStructure(m);
        }
        if (!Clean2D.bondLengthAcceptable(1.8479999999999999, m)) {
            if (Debug2 > 4) {
                System.err.println("setCoordinatesForCageRingSystem optimalization");
            }
            Clean2D.optimizeMolecule(m, null, opt, 0, 0, Debug2);
        }
    }

    static int[] getLargestSet(BitSet bidx, BitSet clc, MoleculeGraph m) {
        int[][] ctab = m.getCtab();
        int start = 0;
        if (bidx != null && bidx.cardinality() > 0) {
            start = bidx.nextSetBit(0);
            MolBond b = m.getBond(start);
            start = m.indexOf(b.getAtom1());
        } else if (clc != null && clc.cardinality() > 0) {
            start = clc.nextSetBit(0);
        }
        IntVector largestR = new IntVector();
        BitSet s = new BitSet();
        IntVector r = new IntVector();
        r.add(0);
        r.add(0);
        if (Clean2D.getLargestRing(start, -1, ctab, r, s, largestR, clc, 10000)) {
            largestR.remove(0);
            return largestR.toArray();
        }
        return null;
    }

    static boolean getLargestRing(int idx, int from, int[][] ctab, IntVector t, BitSet s, IntVector r, BitSet clc, int stepLimit) {
        if (s.get(idx)) {
            if (t.size() > 2 && t.get(2) == idx && (t.size() - 1 > r.size() || t.size() - 1 == r.size() && r.get(0) < t.get(1))) {
                r.clear();
                r.addAll(t);
                r.remove(0);
            }
            return true;
        }
        t.add(idx);
        int step = t.get(0);
        if (step > stepLimit) {
            return false;
        }
        t.set(0, step++);
        s.set(idx);
        int w = t.get(1);
        if (clc.get(idx)) {
            t.set(1, ++w);
        }
        int[] an = ctab[idx];
        for (int i = 0; i < an.length; ++i) {
            int next = an[i];
            if (next == from || Clean2D.getLargestRing(next, idx, ctab, t, s, r, clc, stepLimit)) continue;
            return false;
        }
        t.remove(t.size() - 1);
        s.clear(idx);
        int w2 = t.get(1);
        if (clc.get(idx)) {
            t.set(1, --w2);
        }
        return true;
    }

    static boolean changeToAndCleanMulticenter(MoleculeGraph g, MoleculeGraph orig, BitSet[] rs, int[] convIdx, PartialOptimization opt, int Debug2) {
        Molecule f = (Molecule)g.clone();
        int ac = f.getAtomCount();
        for (int i = ac - 1; i >= 0; --i) {
            MolAtom a = f.getAtom(i);
            a.setZ(i);
        }
        BitSet[] tmp = new BitSet[ac];
        int[][] ctab = g.getCtab();
        int removedHeavyAC = 0;
        boolean[] removedAtom = new boolean[ac];
        for (int i = ac - 1; i >= 0; --i) {
            MolAtom a = f.getAtom(i);
            int[] an = ctab[i];
            int[] origIdxes = Clean2D.convert(an, convIdx);
            if (!Clean2D.isHeavy(a) || !Clean2D.idxesInMoreSSSR(origIdxes, rs)) continue;
            BitSet s = new BitSet(ac);
            for (int j = an.length - 1; j >= 0; --j) {
                s.set(an[j]);
            }
            removedAtom[i] = true;
            f.removeAtom(i);
            tmp[removedHeavyAC++] = s;
        }
        if (removedHeavyAC < 1) {
            return false;
        }
        BitSet[] removedAtomConnIdxes = new BitSet[removedHeavyAC];
        System.arraycopy(tmp, 0, removedAtomConnIdxes, 0, removedHeavyAC);
        MoleculeGraph[] frags = f.findBasicFrags(SelectionMolecule.class);
        int sgroupCount = frags.length;
        boolean hasRings = false;
        for (int i = 0; i < sgroupCount && !hasRings; ++i) {
            int[][] fragRings = frags[i].getSSSR();
            if (fragRings.length == 0) continue;
            hasRings = true;
        }
        if (!hasRings) {
            return false;
        }
        boolean success = false;
        Molecule m = null;
        if (sgroupCount == 1) {
            m = (Molecule)g.clone();
            BitSet connPoints = new BitSet();
            ArrayList<MolBond> edges = new ArrayList<MolBond>();
            MolAtom heavyAtom1 = null;
            int n = 0;
            for (int i = ac - 1; i >= 0; --i) {
                MolAtom a = m.getAtom(i);
                if (!Clean2D.isHeavy(a)) continue;
                ++n;
                heavyAtom1 = a;
                int[] an = ctab[i];
                for (int j = a.getBondCount() - 1; j >= 0; --j) {
                    MolBond e = a.getBond(j);
                    edges.add(e);
                    m.removeBond(e);
                    connPoints.set(an[j]);
                }
            }
            success = Cleaner.clean(m, 2, null);
            double[] cm = Clean2D.calcCM(connPoints, m);
            if (n == 1) {
                heavyAtom1.setXYZ(cm[0], cm[1], 0.0);
            } else {
                for (int i = edges.size() - 1; i >= 0; --i) {
                    m.add((MolBond)edges.get(i));
                }
                int[] flags = new int[ac];
                for (int i = 0; i < ac; ++i) {
                    MolAtom a = m.getAtom(i);
                    flags[i] = Clean2D.isHeavy(a) ? 0 : 1;
                }
                Clean2D.optimizeMolecule(m, flags, opt, 8, 1, Debug2);
            }
        } else {
            m = (Molecule)g.clone();
            for (int i = 0; i < sgroupCount; ++i) {
                MoleculeGraph frag = frags[i];
                for (int k = frag.getAtomCount() - 1; k >= 0; --k) {
                    int idx = (int)frag.getAtom(k).getZ();
                    MolAtom n = m.getAtom(idx);
                    n.setZ(i);
                }
            }
            Clean2D.removeCTStereo(m);
            MulticenterSgroup[] sg = new MulticenterSgroup[sgroupCount];
            BitSet[] fragmentSet = new BitSet[sgroupCount];
            for (int i = 0; i < sgroupCount; ++i) {
                sg[i] = new MulticenterSgroup(m);
                BitSet s = new BitSet();
                MoleculeGraph frag = frags[i];
                for (int k = frag.getAtomCount() - 1; k >= 0; --k) {
                    int idx = (int)frag.getAtom(k).getZ();
                    s.set(idx);
                    MolAtom n = m.getAtom(idx);
                    m.setSgroupParent(n, sg[i], true);
                }
                sg[i].addCentralAtom();
                fragmentSet[i] = s;
            }
            int n = 0;
            BitSet[] multipleConnectionFragAt = new BitSet[removedHeavyAC];
            BitSet tmpSet = new BitSet(ac);
            for (int i = ac - 1; i >= 0; --i) {
                if (!removedAtom[i]) continue;
                BitSet s = new BitSet(ac);
                for (int k = sgroupCount - 1; k >= 0; --k) {
                    tmpSet.clear();
                    tmpSet.or(fragmentSet[k]);
                    tmpSet.and(removedAtomConnIdxes[n]);
                    if (tmpSet.cardinality() <= 1) continue;
                    s.or(tmpSet);
                }
                multipleConnectionFragAt[n++] = s;
            }
            n = 0;
            IntVector idxes = new IntVector();
            for (int i = ac - 1; i >= 0; --i) {
                int j;
                MolAtom a = m.getAtom(i);
                if (!removedAtom[i]) continue;
                idxes.clear();
                int[] an = ctab[i];
                for (j = a.getBondCount() - 1; j >= 0; --j) {
                    MolAtom l = a.getLigand(j);
                    int fidx = (int)l.getZ();
                    int idx = an[j];
                    if (!multipleConnectionFragAt[n].get(idx)) continue;
                    m.removeBond(a.getBond(j));
                    if (removedAtom[idx] || idxes.contains(fidx)) continue;
                    idxes.addElement(fidx);
                }
                for (j = idxes.size() - 1; j >= 0; --j) {
                    int idx = idxes.get(j);
                    MolAtom c = sg[idx].getCentralAtom();
                    m.add(new MolBond(a, c, 9));
                }
                ++n;
            }
            int removedSgroup = 0;
            for (int i = sgroupCount - 1; i >= 0; --i) {
                MolAtom c = sg[i].getCentralAtom();
                if (c.getBondCount() != 0) continue;
                sg[i].removeAtom(c);
                m.ungroupSgroup(sg[i]);
                ++removedSgroup;
            }
            if (sgroupCount == removedSgroup) {
                return false;
            }
            success = Cleaner.clean(m, 2, null);
        }
        Clean2D.copyMolCoordinates(m, g);
        return success;
    }

    static boolean idxesInMoreSSSR(int[] an, BitSet[] rs) {
        for (int idx : an) {
            int n = 0;
            for (int j = 0; j < rs.length && n < 2; ++j) {
                if (!rs[j].get(idx)) continue;
                ++n;
            }
            if (n >= 2) continue;
            return false;
        }
        return true;
    }

    static boolean inTheSameRing(int i1, int i2, BitSet[] rs) {
        for (BitSet bitSet : rs) {
            if (!bitSet.get(i1) || !bitSet.get(i2)) continue;
            return true;
        }
        return false;
    }

    static void copyMolCoordinates(MoleculeGraph from, MoleculeGraph to) {
        int ac = to.getAtomCount();
        DPoint3 p = new DPoint3();
        for (int i = 0; i < ac; ++i) {
            MolAtom a_orig = to.getAtom(i);
            MolAtom a_cleaned = from.getAtom(i);
            a_cleaned.getLocation(p);
            a_orig.setLocation(p);
            a_orig.setZ(2.0);
        }
    }

    void buildFromSimpleRings(MoleculeGraph m, BitSet cb, PartialOptimization opt, int Debug2) {
        if (Debug2 > 2) {
            System.err.println("\tTry build system from single rings, common bonds " + cb);
        }
        int[][] cssr = m.getCSSR();
        Clean2D.sortCSSR(cssr);
        if (!Clean2D.joinFromSingleRings(m, cssr, cb, opt, Debug2)) {
            if (Debug2 > 4) {
                System.err.println("\tjoin from single rings failed");
            }
            Clean2D.setZ(m, 0.0);
            Clean2D.singleRingCoordinates(m, cssr, cb, Debug2);
        } else if (Debug2 > 2) {
            System.err.println("\tjoinFromSingleRings success");
        }
        if (Debug2 > 7) {
            System.err.println("Molecule After SimpleRing build saved to save.sdf");
            MoleculeGraph clone = Clean2D.getFixedClone(m);
            Clean2D.saveMoleculeToFile(clone, null, this.out, "After SimpleRing build");
        }
        if (Clean2D.checkMolCollapsion(m)) {
            Clean2D.correctStructure(m);
        }
        if (!Clean2D.bondLengthAcceptable(1.8479999999999999, m)) {
            if (Debug2 > 4) {
                System.err.println("\tbuildFromSimpleRings optimalization");
            }
            int[] f = new int[m.getAtomCount()];
            for (int i = m.getBondCount() - 1; i >= 0; --i) {
                int n;
                if (!cb.get(i)) continue;
                MolBond e = m.getBond(i);
                int n2 = n = m.indexOf(e.getAtom1());
                f[n2] = f[n2] | 1;
                int n3 = n = m.indexOf(e.getAtom2());
                f[n3] = f[n3] | 1;
            }
            Clean2D.optimizeMolecule(m, f, opt, 12, 1, Debug2);
            if (Debug2 > 7) {
                System.err.println("Molecule After optimalization saved to save.sdf");
                Clean2D.saveMoleculeToFile(m, null, this.out, "After SimpleRing build optimalization");
            }
        }
    }

    static boolean setCoordinatesFromTemplates(BitSet cb, BitSet clc, Molecule m, IntVector[] MoleculeInvariants, String[] template_local, int Debug2) {
        Molecule target;
        int inv;
        if (Debug2 > 2) {
            System.err.println("\tTry from templates ");
        }
        if (Clean2D.checkTemplateFiles(template_local, false, 0, inv = Clean2D.calcInvariant(m), target = new Molecule(), m, cb, clc, MoleculeInvariants, null, Debug2)) {
            return true;
        }
        return Clean2D.checkTemplateFiles(TEMPLATEFILES, true, template_local.length, inv, target, m, cb, clc, MoleculeInvariants, null, Debug2);
    }

    static boolean setCoordinatesFromCageTemplates(BitSet cb, BitSet clc, Molecule m, IntVector[] cageInvariants, boolean[] isCageWithPossBondRearr, int Debug2) {
        Molecule target;
        int inv;
        if (Debug2 > 2) {
            System.err.println("\tTry from cage templates ");
        }
        return Clean2D.checkTemplateFiles(CAGETEMPLATEFILES, true, 0, inv = Clean2D.calcInvariant(m), target = new Molecule(), m, cb, clc, cageInvariants, isCageWithPossBondRearr, Debug2);
    }

    static boolean checkTemplateFiles(String[] filenames, boolean system, int inv_start, int inv, Molecule target, Molecule m, BitSet cb, BitSet clc, IntVector[] MoleculeInvariants, boolean[] isCageWithPossBondRearr, int Debug2) {
        block16: {
            int[] n = new int[1];
            try {
                int l = filenames.length;
                for (int i = 0; i < l; ++i) {
                    n[0] = 0;
                    InputStream is = null;
                    if (system) {
                        is = BasicEnvironment.getResourceAsStream(Molecule.class, filenames[i]);
                    } else {
                        try {
                            is = new FileInputStream(filenames[i]);
                        }
                        catch (FileNotFoundException e) {
                            // empty catch block
                        }
                    }
                    if (is == null) {
                        if (i == l - 1 || Error != 1) continue;
                        System.err.println("Cannot find template file " + filenames[i]);
                        continue;
                    }
                    MolInputStream mis = new MolInputStream(is);
                    MRecordImporter molimp = new MRecordImporter(mis, null);
                    if (MoleculeInvariants[i + inv_start] == null) {
                        MoleculeInvariants[i + inv_start] = new IntVector();
                    }
                    IntVector molInvariants = MoleculeInvariants[i + inv_start];
                    if (Debug2 > 5) {
                        System.err.println("Use template file " + filenames[i]);
                    }
                    while (Clean2D.locateTarget(molimp, target, molInvariants, n, inv)) {
                        if (Debug2 > 3) {
                            System.err.println("Found a possible template");
                        }
                        if (isCageWithPossBondRearr != null) {
                            isCageWithPossBondRearr[0] = Clean2D.needToRearrangeBond(target);
                        }
                        if (!Clean2D.matchTarget(m, target, cb, clc, Debug2)) continue;
                        if (Debug2 > 3) {
                            System.err.println("\tCoordinate set from template");
                        }
                        mis.close();
                        return true;
                    }
                    mis.close();
                }
            }
            catch (IOException e) {
                if (Error == 1) {
                    System.err.println("Error in template file");
                    e.printStackTrace();
                }
            }
            catch (MRecordParseException e) {
                if (Error != 1) break block16;
                System.err.println("Error in template file");
                e.printStackTrace();
            }
        }
        return false;
    }

    static boolean needToRearrangeBond(Molecule m) {
        String name = m.getName();
        return name != null && name.toLowerCase().equals("adamantane");
    }

    static int calcInvariant(MoleculeGraph m) {
        int ac = m.getAtomCount();
        int bc = m.getBondCount();
        int ligandSum = 0;
        int ligandSqr = 1;
        for (int i = 0; i < ac; ++i) {
            int lc = m.getAtom(i).getBondCount();
            ligandSum += lc;
            ligandSqr *= lc;
        }
        return ligandSum | ligandSqr | ac * 1013904223 | 1664525 * bc + 1013904223;
    }

    static boolean locateTarget(MRecordImporter molimp, Molecule t, IntVector molInvariants, int[] p, int inv) throws MRecordParseException, MolFormatException, IOException {
        boolean allInvCalculated;
        int n = p[0];
        int ALLC = Integer.MAX_VALUE;
        boolean bl = allInvCalculated = molInvariants.size() != 0 && molInvariants.lastElement() == ALLC;
        if (allInvCalculated) {
            int l = molInvariants.size() - 1;
            for (int i = n; i < l; ++i) {
                if (molInvariants.get(i) == inv) {
                    molimp.readMol(t);
                    p[0] = i + 1;
                    return true;
                }
                molimp.skipRecord();
            }
            p[0] = l;
            return false;
        }
        boolean hasMore = true;
        boolean molLoaded = false;
        do {
            molLoaded = false;
            int l = molInvariants.size();
            if (n >= l || molInvariants.get(n) == 0) {
                hasMore = molimp.readMol(t) != null;
                if (hasMore) {
                    molLoaded = true;
                    if (n >= l) {
                        molInvariants.setSize(n + 1);
                    }
                    molInvariants.setElementAt(Clean2D.calcInvariant(t), n);
                } else {
                    molInvariants.setSize(n + 1);
                    molInvariants.setElementAt(ALLC, n);
                    return false;
                }
            }
            if (molInvariants.get(n) == inv) {
                if (molLoaded || (hasMore = molimp.readMol(t) != null)) {
                    p[0] = ++n;
                    return true;
                }
            } else if (!molLoaded) {
                hasMore = molimp.skipRecord() != null;
            }
            ++n;
        } while (hasMore);
        return false;
    }

    static boolean matchTarget(Molecule m, Molecule target, BitSet cb, BitSet clc, int Debug2) {
        if (Debug2 > 8) {
            System.err.println("Match target start ");
        }
        int clcl = clc == null ? 0 : clc.cardinality();
        int ac = m.getAtomCount();
        SubstructureSearch sss = new SubstructureSearch();
        sss.setQuery(m);
        sss.setTarget(target);
        sss.setIgnoreAtomType(true);
        sss.setIgnoreBondType(true);
        sss.setIgnoreHybridization(true);
        sss.setIgnoreCharge(true);
        int[] mapWithCT = null;
        boolean found = true;
        found = sss.findFirst();
        while (found) {
            int[] map;
            if (Debug2 > 8) {
                System.err.println("Try  match ");
            }
            if (Clean2D.cisTransMatch(m, target, map = sss.getResult(), cb)) {
                mapWithCT = mapWithCT == null ? new int[ac] : mapWithCT;
                System.arraycopy(map, 0, mapWithCT, 0, ac);
                if (clcl == 0 || Clean2D.ligandConnectionsAtPerimeter(target, map, clc) == clcl) {
                    if (Debug2 > 7) {
                        System.err.println("Match target found");
                    }
                    Clean2D.setCoordinates(m, target, map);
                    return true;
                }
            }
            found = sss.findNext();
        }
        if (mapWithCT != null) {
            Clean2D.setCoordinates(m, target, mapWithCT);
            return true;
        }
        if (Debug2 > 8) {
            System.err.println("Match target not found");
        }
        return false;
    }

    static void setCoordinates(Molecule query, Molecule target, int[] map) {
        int ac = query.getAtomCount();
        for (int i = 0; i < ac; ++i) {
            MolAtom qa = query.getAtom(i);
            MolAtom ta = target.getAtom(map[i]);
            qa.setLocation(ta.getLocation());
        }
    }

    static boolean cisTransMatch(MoleculeGraph query, MoleculeGraph target, int[] map, BitSet cb) {
        BondTable btab_t = target.getBondTable();
        int bc = query.getBondCount();
        int[] id = new int[4];
        for (int i = 0; i < bc; ++i) {
            int stereo;
            MolAtom a;
            int j;
            double[][] c;
            int f;
            MolBond b = query.getBond(i);
            id[1] = query.indexOf(b.getAtom1());
            id[2] = query.indexOf(b.getAtom2());
            if (b.getType() == 2 && (f = b.getFlags() & 0xC0) != 0) {
                id[0] = query.indexOf(b.getCTAtom1());
                id[3] = query.indexOf(b.getCTAtom4());
                c = new double[4][2];
                for (j = 0; j < 4; ++j) {
                    a = target.getAtom(map[id[j]]);
                    c[j][0] = a.getX();
                    c[j][1] = a.getY();
                }
                stereo = Clean2D.getStereo2(c[0], c[1], c[2], c[3]);
                if (f != stereo) {
                    return false;
                }
            }
            if (!cb.get(i)) continue;
            int t_bidx = btab_t.getBondIndex(map[id[1]], map[id[2]]);
            if (Clean2D.bondCross(target.getBond(t_bidx), target)) {
                return false;
            }
            id[0] = query.indexOf(b.getCTAtom1());
            id[3] = query.indexOf(b.getCTAtom4());
            c = new double[4][2];
            for (j = 0; j < 4; ++j) {
                a = target.getAtom(map[id[j]]);
                c[j][0] = a.getX();
                c[j][1] = a.getY();
            }
            stereo = Clean2D.getStereo2(c[0], c[1], c[2], c[3]);
            if (stereo == 128) continue;
            return false;
        }
        return true;
    }

    static int ligandConnectionsAtPerimeter(Molecule m, int[] map, BitSet clc) {
        BitSet envelope = Clean2D.buildEnvelopePolygonIndexes(m);
        int n = 0;
        int i = clc.nextSetBit(0);
        while (i >= 0) {
            if (envelope.get(map[i])) {
                ++n;
            }
            i = clc.nextSetBit(i + 1);
        }
        return n;
    }

    static BitSet buildEnvelopePolygonIndexes(Molecule m) {
        int ac = m.getAtomCount();
        BitSet p = new BitSet(ac);
        double minX = Double.MAX_VALUE;
        int minIdx = 0;
        for (int i = 0; i < ac; ++i) {
            MolAtom a = m.getAtom(i);
            if (!(a.getX() < minX)) continue;
            minX = a.getX();
            minIdx = i;
        }
        p.set(minIdx);
        MolAtom ref = m.getAtom(minIdx);
        int l = ref.getBondCount();
        double minY = Double.MAX_VALUE;
        MolAtom center = null;
        for (int i = 0; i < l; ++i) {
            MolAtom a = ref.getLigand(i);
            if (!(a.getY() < minY)) continue;
            minY = a.getY();
            center = a;
        }
        int nextIdx = -1;
        do {
            MolAtom next = Clean2D.ligandWithSmallestAngle(center, ref);
            nextIdx = m.indexOf(next);
            int centerIdx = m.indexOf(center);
            p.set(centerIdx);
            ref = center;
            center = next;
        } while (!p.get(nextIdx));
        return p;
    }

    static MolAtom ligandWithSmallestAngle(MolAtom c, MolAtom ref) {
        int l = c.getBondCount();
        DPoint3 center = c.getLocation();
        double refAngle = center.angle2D(ref.getX(), ref.getY());
        double minAngle = Double.MAX_VALUE;
        MolAtom ret = null;
        for (int i = 0; i < l; ++i) {
            double phy;
            MolAtom a = c.getLigand(i);
            if (a == ref || !((phy = center.angle2D(a.getX(), a.getY()) - refAngle) < minAngle)) continue;
            minAngle = phy;
            ret = a;
        }
        return ret;
    }

    static void connectToFixedSystem(double[] c, MoleculeGraph m, BitSet ringA, BitSet fixedRingAtoms, int Debug2) {
        if (Debug2 > 4) {
            System.err.println("connect to system ");
            System.err.println("ring atoms " + ringA + " fixed atoms " + fixedRingAtoms + " coordintates " + c.length);
        }
        BitSet cs = (BitSet)ringA.clone();
        cs.and(fixedRingAtoms);
        int cn = cs.cardinality();
        if (cn == 1) {
            int idx = cs.nextSetBit(0);
            Clean2D.attachAsSpiro(idx, c, ringA, m);
        } else {
            int idx1 = cs.nextSetBit(0);
            int idx2 = cs.nextSetBit(idx1 + 1);
            if (Debug2 > 4) {
                System.err.println(idx1 + "-" + idx2 + " common atoms");
            }
            Clean2D.attachWOB(idx1, idx2, c, ringA, fixedRingAtoms, false, m, Debug2);
        }
        int n = 0;
        int i = ringA.nextSetBit(0);
        while (i >= 0) {
            MolAtom a = m.getAtom(i);
            a.setXYZ(c[n * 2], c[n * 2 + 1], 2.0);
            ++n;
            fixedRingAtoms.set(i);
            i = ringA.nextSetBit(i + 1);
        }
    }

    static boolean attachAsSpiro(int idx, double[] c, BitSet s, MoleculeGraph m) {
        CTransform3D T = new CTransform3D();
        MolAtom a = m.getAtom(idx);
        int ref = Clean2D.numberOfSetBitUntil(s, idx);
        T.setTranslation(a.getX() - c[2 * ref], a.getY() - c[2 * ref + 1], 0.0);
        Clean2D.transform(c, T);
        double[] cm = Clean2D.calcCM(c);
        double[] cml = new double[2];
        int n = 0;
        for (int i = a.getBondCount() - 1; i >= 0; --i) {
            MolAtom ligand = a.getLigand(i);
            if (ligand.getZ() != 2.0) continue;
            cml[0] = cml[0] + ligand.getX();
            cml[1] = cml[1] + ligand.getY();
            ++n;
        }
        cml[0] = cml[0] / (double)n;
        cml[1] = cml[1] / (double)n;
        DPoint3 o = a.getLocation();
        double phi = o.angle2D(cml[0], cml[1]) + Math.PI - o.angle2D(cm[0], cm[1]);
        T.setIdentity();
        T.setRotation(0.0, 0.0, 1.0, phi);
        T.setRotationCenter(o);
        Clean2D.transform(c, T);
        return true;
    }

    static boolean attachWOB(int idx1, int idx2, double[] c, BitSet ringA, BitSet fixedA, boolean sameside, MoleculeGraph m, int Debug2) {
        CTransform3D T = new CTransform3D();
        MolAtom a1 = m.getAtom(idx1);
        int ref1 = Clean2D.numberOfSetBitUntil(ringA, idx1);
        T.setTranslation(a1.getX() - c[2 * ref1], a1.getY() - c[2 * ref1 + 1], 0.0);
        Clean2D.transform(c, T);
        DPoint3 o = a1.getLocation();
        MolAtom a2 = m.getAtom(idx2);
        int ref2 = Clean2D.numberOfSetBitUntil(ringA, idx2);
        double phi = o.angle2D(a2.getX(), a2.getY()) - o.angle2D(c[2 * ref2], c[2 * ref2 + 1]);
        T.setIdentity();
        T.setRotation(0.0, 0.0, 1.0, phi);
        T.setRotationCenter(o);
        Clean2D.transform(c, T);
        double[] rco = new double[fixedA.cardinality() * 2];
        int n = 0;
        int i = fixedA.nextSetBit(0);
        while (i >= 0) {
            MolAtom a = m.getAtom(i);
            rco[n * 2] = a.getX();
            rco[n * 2 + 1] = a.getY();
            ++n;
            i = fixedA.nextSetBit(i + 1);
        }
        double[] p = new double[]{c[2 * ref1], c[2 * ref1 + 1], c[2 * ref2], c[2 * ref2 + 1]};
        boolean cmAway = Clean2D.isCentOfMassAway(p[0], p[1], p[2], p[3], c, rco);
        if (!(sameside ^ cmAway)) {
            if (Debug2 > 4) {
                System.err.println("Setup ring at the other side ");
            }
            Clean2D.mirrorCoords(p[0], p[1], p[2], p[3], c);
        }
        return true;
    }

    static double[] singleRingCoordinate(MoleculeGraph m, int[] sr, BitSet cb, BondTable btab, int Debug2) {
        int x;
        int l = sr.length;
        boolean aromaticRing = true;
        BitSet cb_f = new BitSet();
        BitSet tb_f = new BitSet();
        for (int i = 0; i < l; ++i) {
            int i1 = sr[i];
            int i2 = sr[(i + 1) % l];
            int i3 = sr[(i + 2) % l];
            int i4 = sr[(i + 3) % l];
            int b_idx = btab.getBondIndex(i2, i3);
            MolBond b = m.getBond(b_idx);
            if (b.getType() == 2) {
                MolAtom a4;
                int s = b.getFlags() & 0x1C0;
                if (s != 128 && s != 64) continue;
                MolAtom a1 = m.getAtom(i1);
                s = b.transformCT(a1, a4 = m.getAtom(i4), s);
                if (s == 64) {
                    tb_f.set(b_idx);
                    continue;
                }
                if (s != 128) continue;
                cb_f.set(b_idx);
                continue;
            }
            if (b.getType() == 4) continue;
            aromaticRing = false;
        }
        if (Debug2 > 1) {
            System.err.println("\tsingleRingCoordinate ring count " + l + " aromatic " + aromaticRing);
        }
        if (aromaticRing) {
            double[] c = new double[sr.length * 2];
            Clean2D.idealPolygon(c);
            if (Debug2 > 2) {
                System.err.println("\tIdealpolygon format " + (c != null));
            }
            return c;
        }
        if (l == 10) {
            int i;
            double[] c = new double[2 * l];
            if (Debug2 > 2) {
                System.err.println("\t RingSize 10 ");
            }
            CTransform3D T = new CTransform3D();
            Clean2D.initHEXAGON(HEXAGON);
            for (i = 0; i < 4; ++i) {
                c[2 * i] = Clean2D.HEXAGON[i].x;
                c[2 * i + 1] = Clean2D.HEXAGON[i].y;
            }
            c[16] = Clean2D.HEXAGON[4].x;
            c[17] = Clean2D.HEXAGON[4].y;
            c[18] = Clean2D.HEXAGON[5].x;
            c[19] = Clean2D.HEXAGON[5].y;
            T.setTranslation(Clean2D.HEXAGON[4].x, 0.0, 0.0);
            Clean2D.transform(HEXAGON, T);
            for (i = 2; i < 6; ++i) {
                c[2 * (i + 2)] = Clean2D.HEXAGON[i].x;
                c[2 * (i + 2) + 1] = Clean2D.HEXAGON[i].y;
            }
            BitSet cidx = Clean2D.convertBondToAtomIndex(cb, m);
            boolean success = Clean2D.transformCoordinateAccordingToCisTrans(m, sr, c, null, null, cb_f, tb_f, cidx, btab, Debug2);
            if (Debug2 > 2) {
                System.err.println("\t ringSize 10  " + success);
            }
            if (success) {
                return c;
            }
        } else if (l > 10 && (l - 10) % 2 == 0) {
            x = (l - 10) / 2;
            double[] c = Clean2D.ringDoubleRowForm(m, sr, x += 2, cb, cb_f, tb_f, btab, Debug2);
            if (Debug2 > 2) {
                System.err.println("\tEVEN double row format " + (c != null ? "set" : "not successfull"));
            }
            if (c != null) {
                return c;
            }
        } else if (l > 10 && (l - 10) % 2 == 1) {
            x = (l - 9) / 2;
            double[] c = Clean2D.ringDoubleRowForm(m, sr, x += 2, cb, cb_f, tb_f, btab, Debug2);
            if (Debug2 > 2) {
                System.err.println("\tODD double row format " + (c != null ? "set" : "not successfull"));
            }
            if (c != null) {
                return c;
            }
        }
        double[] c = Clean2D.polygon(m, sr, cb, null, cb_f, tb_f, btab, Debug2);
        return c;
    }

    static BitSet convertBondToAtomIndex(BitSet b, MoleculeGraph m) {
        if (b == null) {
            return null;
        }
        BitSet convexAtomIdx = new BitSet(m.getAtomCount());
        int i = b.nextSetBit(0);
        while (i >= 0) {
            MolBond e = m.getBond(i);
            MolAtom node = e.getAtom1();
            convexAtomIdx.set(m.indexOf(node));
            node = e.getAtom2();
            convexAtomIdx.set(m.indexOf(node));
            i = b.nextSetBit(i + 1);
        }
        return convexAtomIdx;
    }

    private static double[] polygon(MoleculeGraph m, int[] r, BitSet cb, BitSet tb, BitSet cb_f, BitSet tb_f, BondTable btab, int Debug2) {
        int l = r.length;
        double[] c = new double[2 * l];
        BitSet cisb = new BitSet();
        BitSet transb = new BitSet();
        if (cb != null) {
            cisb.or(cb);
        }
        if (cb_f != null) {
            cisb.or(cb_f);
        }
        if (tb != null) {
            transb.or(tb);
        }
        if (tb_f != null) {
            transb.or(tb_f);
        }
        if (Debug2 > 3) {
            System.err.println("makeFromIdealPolygon l " + l);
            System.err.println("trans " + transb.toString());
        }
        Clean2D.idealPolygon(c);
        if (transb.cardinality() == 0) {
            return c;
        }
        if (l > 64) {
            System.err.println("64 limit reached in 2d clean");
            return c;
        }
        double[] c1 = new double[2];
        double[] c2 = new double[2];
        double[] c3 = new double[2];
        double[] c4 = new double[2];
        for (int i = 0; i < l; ++i) {
            int p = r[(i - 1 + l) % l];
            int h = r[i];
            int n = r[(i + 1) % l];
            int nn = r[(i + 2) % l];
            int k = (i - 1 + l) % l;
            c1[0] = c[k * 2];
            c1[1] = c[k * 2 + 1];
            k = i;
            c2[0] = c[k * 2];
            c2[1] = c[k * 2 + 1];
            k = (i + 1) % l;
            c3[0] = c[k * 2];
            c3[1] = c[k * 2 + 1];
            k = (i + 2) % l;
            c4[0] = c[k * 2];
            c4[1] = c[k * 2 + 1];
            int b_idx = btab.getBondIndex(h, n);
            int s = Clean2D.getStereo2(c1, c2, c3, c4);
            if (!transb.get(b_idx) || s == 64) continue;
            int p_idx = -1;
            int bn_idx = btab.getBondIndex(n, nn);
            int bp_idx = btab.getBondIndex(p, h);
            p_idx = transb.get(bn_idx) ? i + 1 : (transb.get(bp_idx) ? i : (cisb.get(bn_idx) ? i : (cisb.get(bp_idx) ? i + 1 : i)));
            p = r[(p_idx - 1 + l) % l];
            h = r[p_idx % l];
            n = r[(p_idx + 1) % l];
            double[] selected = new double[2];
            k = p_idx % l;
            selected[0] = c[k * 2];
            selected[1] = c[k * 2 + 1];
            double[] c_c = new double[4];
            k = (p_idx - 1 + l) % l;
            c_c[0] = c[k * 2];
            c_c[1] = c[k * 2 + 1];
            k = (p_idx + 1) % l;
            c_c[2] = c[k * 2];
            c_c[3] = c[k * 2 + 1];
            Clean2D.mirrorCoords(c_c[0], c_c[1], c_c[2], c_c[3], selected);
            k = p_idx % l;
            c[k * 2] = selected[0];
            c[k * 2 + 1] = selected[1];
        }
        return c;
    }

    private static void idealPolygon(double[] c) {
        int l = c.length / 2;
        CTransform3D T = new CTransform3D();
        double fi = Math.PI - Math.PI * 2 / (double)l;
        c[0] = 0.0;
        c[1] = 0.0;
        c[2] = 0.0;
        c[3] = 1.54;
        DPoint3 c1 = new DPoint3();
        DPoint3 c2 = new DPoint3();
        int i = 2;
        while (i < l) {
            int p = i - 2;
            int h = i - 1;
            int n = i++;
            c1.x = c[2 * p];
            c1.y = c[2 * p + 1];
            c2.x = c[2 * h];
            c2.y = c[2 * h + 1];
            T.setIdentity();
            T.setRotation(0.0, 0.0, 1.0, fi);
            T.setRotationCenter(c2);
            T.transform(c1);
            c[2 * n] = c1.x;
            c[2 * n + 1] = c1.y;
        }
    }

    static double[] ringDoubleRowForm(MoleculeGraph m, int[] r, int n, BitSet cb, BitSet cb_f, BitSet tb_f, BondTable btab, int Debug2) {
        int i;
        CTransform3D T;
        int l = r.length;
        double[] c = new double[2 * l];
        Clean2D.initHEXAGON(HEXAGON);
        int x = 4;
        if (l % 2 == 1) {
            Clean2D.initPENTAGON(PENTAGON);
            T = new CTransform3D();
            T.setRotationCenter(new DPoint3(0.0, 0.0, 0.0));
            T.setRotation(0.0, 0.0, 1.0, -0.5235987755982988);
            Clean2D.transform(PENTAGON, T);
            T.setIdentity();
            T.setTranslation(Clean2D.HEXAGON[4].x - Clean2D.PENTAGON[3].x, Clean2D.HEXAGON[4].y - Clean2D.PENTAGON[3].y, 0.0);
            Clean2D.transform(PENTAGON, T);
            x = 3;
            for (i = 0; i < x; ++i) {
                c[2 * i] = Clean2D.PENTAGON[i].x;
                c[2 * i + 1] = Clean2D.PENTAGON[i].y;
            }
        } else {
            for (int i2 = 0; i2 < x; ++i2) {
                c[2 * i2] = Clean2D.HEXAGON[i2].x;
                c[2 * i2 + 1] = Clean2D.HEXAGON[i2].y;
            }
        }
        T = new CTransform3D();
        T.setTranslation(2.6673582319999998, 0.0, 0.0);
        for (i = 0; i < (n - 1) / 2; ++i) {
            Clean2D.transform(HEXAGON, T);
            c[2 * x] = Clean2D.HEXAGON[2].x;
            c[2 * x + 1] = Clean2D.HEXAGON[2].y;
            c[2 * ++x] = Clean2D.HEXAGON[3].x;
            c[2 * x + 1] = Clean2D.HEXAGON[3].y;
            ++x;
        }
        c[2 * x] = Clean2D.HEXAGON[4].x;
        c[2 * x + 1] = Clean2D.HEXAGON[4].y;
        ++x;
        if (n % 2 == 0) {
            T.setTranslation(1.3336791159999999, -2.31, 0.0);
        } else {
            T.setTranslation(-1.3336791159999999, -2.31, 0.0);
        }
        Clean2D.transform(HEXAGON, T);
        c[2 * x] = Clean2D.HEXAGON[3].x;
        c[2 * x + 1] = Clean2D.HEXAGON[3].y;
        c[2 * ++x] = Clean2D.HEXAGON[4].x;
        c[2 * x + 1] = Clean2D.HEXAGON[4].y;
        c[2 * ++x] = Clean2D.HEXAGON[5].x;
        c[2 * x + 1] = Clean2D.HEXAGON[5].y;
        ++x;
        T.setTranslation(-2.6673582319999998, 0.0, 0.0);
        for (i = 0; i < n / 2 - 1; ++i) {
            Clean2D.transform(HEXAGON, T);
            c[2 * x] = Clean2D.HEXAGON[4].x;
            c[2 * x + 1] = Clean2D.HEXAGON[4].y;
            c[2 * ++x] = Clean2D.HEXAGON[5].x;
            c[2 * x + 1] = Clean2D.HEXAGON[5].y;
            ++x;
        }
        c[2 * x] = Clean2D.HEXAGON[0].x;
        c[2 * x + 1] = Clean2D.HEXAGON[0].y;
        ++x;
        if (l % 2 == 1) {
            c[2 * x] = Clean2D.PENTAGON[4].x;
            c[2 * x + 1] = Clean2D.PENTAGON[4].y;
        } else {
            c[2 * x] = Clean2D.HEXAGON[1].x;
            c[2 * x + 1] = Clean2D.HEXAGON[1].y;
        }
        ++x;
        BitSet cidx = Clean2D.convertBondToAtomIndex(cb, m);
        if (!Clean2D.transformCoordinateAccordingToCisTrans(m, r, c, null, null, cb_f, tb_f, cidx, btab, Debug2)) {
            for (int i3 = 1; i3 < l / 2; ++i3) {
                double t = c[2 * i3];
                c[2 * i3] = c[2 * (l - i3)];
                c[2 * (l - i3)] = t;
                t = c[2 * i3 + 1];
                c[2 * i3 + 1] = c[2 * (l - i3) + 1];
                c[2 * (l - i3) + 1] = t;
            }
            if (!Clean2D.transformCoordinateAccordingToCisTrans(m, r, c, null, null, cb_f, tb_f, cidx, btab, Debug2)) {
                return null;
            }
        }
        return c;
    }

    private static boolean joinFromSingleRings(MoleculeGraph m, int[][] cssr, BitSet cb, PartialOptimization opt, int Debug2) {
        int i;
        int cssrLength = cssr.length;
        int[] ringLength = new int[cssrLength];
        for (int i2 = 0; i2 < cssrLength; ++i2) {
            ringLength[i2] = cssr[i2].length;
        }
        BondTable btab = m.getBondTable();
        int nLarge = 0;
        int endOfSmallR = -1;
        int i3 = 0;
        while (i3 < cssrLength && ringLength[i3] >= 10) {
            ++nLarge;
            endOfSmallR = i3++;
        }
        BitSet[] ringBonds = new BitSet[cssrLength];
        BitSet[] ringAtoms = new BitSet[cssrLength];
        for (int i4 = cssrLength - 1; i4 >= 0; --i4) {
            ringBonds[i4] = Clean2D.generateRingBondSet(cssr[i4], btab);
            ringAtoms[i4] = Clean2D.generateRingAtomSet(cssr[i4]);
        }
        if (Debug2 > 3) {
            System.err.println("\tjoinFromSingleRings sssr size " + cssrLength + " large rings " + nLarge);
        }
        if (nLarge == 0 && cssrLength < 3 && Clean2D.mergeTwoRings(ringBonds, cb, m)) {
            if (Debug2 > 3) {
                System.err.println("mergeTwoRings success");
            }
            return true;
        }
        double[][] c = new double[cssrLength][];
        for (int i5 = cssrLength - 1; i5 >= 0; --i5) {
            int[] r = cssr[i5];
            c[i5] = new double[r.length * 2];
            Clean2D.idealPolygon(c[i5]);
        }
        boolean[] fixedR = new boolean[cssrLength];
        int[] rC = Clean2D.getRingConnections(cssr, endOfSmallR, ringBonds);
        Vector<BitSet> smallRingSystems = Clean2D.generateCoordinatesForSmallrings(m, cssr, opt, Debug2, cssrLength, endOfSmallR, ringBonds, c, fixedR, rC);
        if (nLarge == 0) {
            Clean2D.setCoordinates(m, cssr, c);
            return true;
        }
        for (i = cssrLength - 1; i >= 0; --i) {
            if (ringLength[i] < 10) continue;
            if (!Clean2D.largeRingFromPolygons(i, cssr, c, ringAtoms, smallRingSystems, m, Debug2)) {
                if (ringLength[i] > 20) {
                    Clean2D.idealPolygon(c[i]);
                }
                boolean[] join = Clean2D.locateCommonRings(i, ringBonds);
                Clean2D.setCoordinatesFromRings(i, join, c, cssr, smallRingSystems, ringAtoms);
            }
            Clean2D.joinSystems(smallRingSystems, i);
        }
        if (Debug2 > 7) {
            for (i = 0; i < cssr.length; ++i) {
                String filename = "largeRing" + i + ".mrv";
                System.err.println("ring coordinates saved: " + filename);
                Clean2D.doubleArray_toMolecule(c[i], filename);
            }
        }
        Clean2D.setCoordinates(m, cssr, c);
        return true;
    }

    private static Vector<BitSet> generateCoordinatesForSmallrings(MoleculeGraph m, int[][] cssr, PartialOptimization opt, int Debug2, int cssrl, int endOfSmallR, BitSet[] ringBonds, double[][] c, boolean[] fixedR, int[] ringConnections) {
        int ringIdxToAttach;
        BitSet ringSystemBondSet = new BitSet();
        Vector<BitSet> smallRingSystems = new Vector<BitSet>();
        while ((ringIdxToAttach = Clean2D.getRingSystemStart(fixedR, ringConnections, endOfSmallR)) >= 0) {
            BitSet smallRingIdxSet = new BitSet();
            fixedR[ringIdxToAttach] = true;
            smallRingIdxSet.set(ringIdxToAttach);
            while (ringIdxToAttach != Integer.MAX_VALUE) {
                if (Debug2 > 6) {
                    System.err.println("\t\tInitial ring idx " + ringIdxToAttach + " atom indexes " + Arrays.toString(cssr[ringIdxToAttach]));
                }
                BitSet commonBondSet = new BitSet();
                BitSet currentRingBondSet1 = ringBonds[ringIdxToAttach];
                commonBondSet.or(currentRingBondSet1);
                ringSystemBondSet.or(currentRingBondSet1);
                for (int i = cssrl - 1; i > endOfSmallR; --i) {
                    if (fixedR[i]) continue;
                    BitSet currentRingBondSet2 = ringBonds[i];
                    commonBondSet.and(currentRingBondSet2);
                    ringSystemBondSet.or(currentRingBondSet2);
                    Clean2D.attachRings(ringIdxToAttach, i, m, cssr, opt, Debug2, c, fixedR, smallRingIdxSet, commonBondSet);
                    commonBondSet.clear();
                    commonBondSet.or(ringBonds[ringIdxToAttach]);
                }
                ringIdxToAttach = Clean2D.getRingIdxToFixTo(fixedR, cssr, endOfSmallR, ringBonds);
            }
            smallRingSystems.add(smallRingIdxSet);
            if (Debug2 <= 4) continue;
            System.err.println(smallRingIdxSet);
        }
        return smallRingSystems;
    }

    private static void attachRings(int ringIdx1, int ringIdx2, MoleculeGraph m, int[][] cssr, PartialOptimization opt, int Debug2, double[][] coordinates, boolean[] fixedRing, BitSet smallRingIdxSet, BitSet commonBondSet) {
        int numberOfCommonBond = commonBondSet.cardinality();
        if (numberOfCommonBond > 0) {
            if (Debug2 > 6) {
                System.err.println("\t\t  join ring idx " + ringIdx2 + " atom indexes " + Arrays.toString(cssr[ringIdx2]));
            }
            Clean2D.attachCoordinates(coordinates[ringIdx1], coordinates[ringIdx2], cssr[ringIdx1], cssr[ringIdx2], commonBondSet.nextSetBit(0), m);
            Clean2D.optimizeAttachedRingIfNeeded(ringIdx2, commonBondSet, coordinates, cssr, smallRingIdxSet, m, opt, Debug2);
            fixedRing[ringIdx2] = true;
            smallRingIdxSet.set(ringIdx2);
        }
    }

    static boolean mergeTwoRings(BitSet[] ringBonds, BitSet cb, MoleculeGraph m) {
        BitSet lls = new BitSet();
        lls.or(ringBonds[0]);
        lls.xor(ringBonds[1]);
        int i = cb.nextSetBit(0);
        while (i >= 0) {
            if (!lls.get(i)) {
                return false;
            }
            i = cb.nextSetBit(i + 1);
        }
        double[] c = new double[lls.cardinality() * 2];
        Clean2D.idealPolygon(c);
        int bidx = lls.nextSetBit(0);
        MolBond b = m.getBond(bidx);
        MolAtom a = b.getAtom1();
        int n = 0;
        a.setXYZ(c[n], c[n + 1], 2.0);
        lls.clear(bidx);
        ++n;
        while ((a = Clean2D.getConnectingAtom(a, m, lls)) != null) {
            a.setXYZ(c[2 * n], c[2 * n + 1], 2.0);
            ++n;
        }
        lls.clear();
        lls.or(ringBonds[0]);
        lls.and(ringBonds[1]);
        int[] bridge = Clean2D.convertBondToContinuousAtomIndex(lls, m);
        Clean2D.arrangeAtomsInLine(bridge, m);
        return true;
    }

    static MolAtom getConnectingAtom(MolAtom a, MoleculeGraph m, BitSet s) {
        for (int i = 0; i < a.getBondCount(); ++i) {
            MolBond b = a.getBond(i);
            int bidx = m.indexOf(b);
            if (!s.get(bidx)) continue;
            s.clear(bidx);
            return a.getLigand(i);
        }
        return null;
    }

    static void arrangeAtomsInLine(int[] idx, MoleculeGraph m) {
        int l = idx.length - 1;
        double[] c = new double[4];
        MolAtom a = m.getAtom(idx[0]);
        c[0] = a.getX();
        c[1] = a.getY();
        a = m.getAtom(idx[l]);
        c[2] = a.getX();
        c[3] = a.getY();
        double dx = (c[2] - c[0]) / (double)l;
        double dy = (c[3] - c[1]) / (double)l;
        for (int i = 1; i < l; ++i) {
            a = m.getAtom(idx[i]);
            if (a.getZ() == 2.0) continue;
            a.setXYZ(c[0] + (double)i * dx - dy / 4.0, c[1] + (double)i * dy + dx / 4.0, 2.0);
        }
    }

    static int[] convertBondToContinuousAtomIndex(BitSet s, MoleculeGraph m) {
        IntVector aidx = new IntVector();
        BitSet bset = (BitSet)s.clone();
        BitSet aset = new BitSet();
        int bidx = bset.nextSetBit(0);
        MolBond b = m.getBond(bidx);
        bset.clear(bidx);
        MolAtom node = b.getAtom1();
        int n = m.indexOf(node);
        aidx.add(n);
        aset.set(n);
        node = b.getAtom2();
        n = m.indexOf(node);
        aset.set(n);
        aidx.add(n);
        while ((bidx = Clean2D.getConnectingBond(node, bset, m)) > 0) {
            b = m.getBond(bidx);
            bset.clear(bidx);
            node = b.getAtom1();
            n = m.indexOf(node);
            if (!aset.get(n)) {
                aidx.add(n);
                aset.set(n);
                continue;
            }
            node = b.getAtom2();
            n = m.indexOf(node);
            if (aset.get(n)) continue;
            aidx.add(n);
            aset.set(n);
        }
        node = b.getAtom1();
        while ((bidx = Clean2D.getConnectingBond(node, bset, m)) > 0) {
            b = m.getBond(bidx);
            bset.clear(bidx);
            node = b.getAtom1();
            n = m.indexOf(node);
            if (!aset.get(n)) {
                aidx.insertElementAt(n, 0);
                aset.set(n);
                continue;
            }
            node = b.getAtom2();
            n = m.indexOf(node);
            if (aset.get(n)) continue;
            aidx.insertElementAt(n, 0);
            aset.set(n);
        }
        return aidx.toArray();
    }

    static int[] convertContinuousAtomIndex(int[] r, BitSet s) {
        int nidx;
        int idx;
        int i;
        int l = r.length;
        IntVector bridge = new IntVector();
        int start = -1;
        for (i = 0; i < l; ++i) {
            idx = r[i];
            nidx = r[(i + 1) % l];
            if (s.get(nidx) || !s.get(idx)) continue;
            start = i;
            break;
        }
        if (start == -1) {
            return null;
        }
        for (i = 0; i < l; ++i) {
            idx = r[(i + start) % l];
            nidx = r[(i + start + 1) % l];
            if (s.get(nidx) && !s.get(idx)) {
                bridge.add(idx);
                bridge.add(nidx);
                break;
            }
            bridge.add(idx);
        }
        return bridge.toArray();
    }

    static int getConnectingBond(MolAtom n, BitSet set, MoleculeGraph m) {
        int l = n.getBondCount();
        for (int i = 0; i < l; ++i) {
            int eidx = m.indexOf(n.getBond(i));
            if (!set.get(eidx)) continue;
            return eidx;
        }
        return -1;
    }

    static int[] getRingConnections(int[][] cssr, int l, BitSet[] rb) {
        BitSet s = new BitSet();
        int cssrl = cssr.length;
        int[] rC = new int[cssrl];
        for (int i = cssrl - 1; i > l; --i) {
            for (int j = cssrl - 1; j > l; --j) {
                if (i == j) continue;
                s.clear();
                s.or(rb[i]);
                s.and(rb[j]);
                int c = s.cardinality();
                if (c <= 0) continue;
                int n = i;
                rC[n] = rC[n] + 1;
            }
        }
        return rC;
    }

    static int getRingIdxToFixTo(boolean[] fixed, int[][] cssr, int l, BitSet[] rb) {
        BitSet s = new BitSet();
        int cssrl = cssr.length;
        int highConnectedRingIdx = Integer.MAX_VALUE;
        int connectionCount = Integer.MAX_VALUE;
        for (int i = cssrl - 1; i > l; --i) {
            for (int j = i - 1; j > l; --j) {
                if (fixed[i] == fixed[j]) continue;
                s.clear();
                s.or(rb[i]);
                s.and(rb[j]);
                int c = s.cardinality();
                if (c == 1) {
                    return fixed[i] ? i : j;
                }
                if (c <= 0 || c >= connectionCount) continue;
                highConnectedRingIdx = fixed[i] ? i : j;
                connectionCount = c;
            }
        }
        return highConnectedRingIdx;
    }

    static int getRingSystemStart(boolean[] fixed, int[] rc, int l) {
        int cssrl = fixed.length;
        int max = -1;
        int maxid = -1;
        for (int i = cssrl - 1; i > l; --i) {
            if (fixed[i] || rc[i] <= max) continue;
            max = rc[i];
            maxid = i;
        }
        return maxid;
    }

    static void setCoordinates(MoleculeGraph m, int[][] cssr, double[][] c) {
        int cssrl = cssr.length;
        for (int i = cssrl - 1; i >= 0; --i) {
            int[] r = cssr[i];
            int l = r.length;
            double[] coord = c[i];
            for (int j = 0; j < l; ++j) {
                MolAtom a = m.getAtom(r[j]);
                a.setXYZ(coord[j * 2], coord[j * 2 + 1], 0.0);
            }
        }
    }

    static double[] getCoordinates(int idx, int ex, int[][] r, double[][] c) {
        for (int i = r.length - 1; i >= 0; --i) {
            if (i == ex) continue;
            int[] ring = r[i];
            for (int j = ring.length - 1; j >= 0; --j) {
                if (ring[j] != idx) continue;
                return new double[]{c[i][2 * j], c[i][2 * j + 1]};
            }
        }
        return null;
    }

    private static boolean attachCoordinates(double[] c1, double[] c2, int[] r1, int[] r2, int b_idx, MoleculeGraph m) {
        int i;
        MolBond b = m.getBond(b_idx);
        int i1 = m.indexOf(b.getAtom1());
        int i2 = m.indexOf(b.getAtom2());
        double[] c_c = new double[8];
        for (i = r1.length - 1; i >= 0; --i) {
            if (r1[i] == i1) {
                c_c[0] = c1[i * 2];
                c_c[1] = c1[i * 2 + 1];
                continue;
            }
            if (r1[i] != i2) continue;
            c_c[2] = c1[i * 2];
            c_c[3] = c1[i * 2 + 1];
        }
        for (i = r2.length - 1; i >= 0; --i) {
            if (r2[i] == i1) {
                c_c[4] = c2[i * 2];
                c_c[5] = c2[i * 2 + 1];
                continue;
            }
            if (r2[i] != i2) continue;
            c_c[6] = c2[i * 2];
            c_c[7] = c2[i * 2 + 1];
        }
        CTransform3D T = new CTransform3D();
        T.setTranslation(c_c[0] - c_c[4], c_c[1] - c_c[5], 0.0);
        Clean2D.transform(c2, T);
        c_c[6] = c_c[6] + (c_c[0] - c_c[4]);
        c_c[7] = c_c[7] + (c_c[1] - c_c[5]);
        T.setIdentity();
        DPoint3 c = new DPoint3();
        c.x = c_c[0];
        c.y = c_c[1];
        double phi = c.angle2D(c_c[2], c_c[3]) - c.angle2D(c_c[6], c_c[7]);
        T.setRotation(0.0, 0.0, 1.0, phi);
        T.setRotationCenter(c);
        Clean2D.transform(c2, T);
        if (!Clean2D.isCentOfMassAway(c_c[0], c_c[1], c_c[2], c_c[3], c1, c2)) {
            Clean2D.mirrorCoords(c_c[0], c_c[1], c_c[2], c_c[3], c2);
        }
        return true;
    }

    private static void optimizeAttachedRingIfNeeded(int r_idx, BitSet bs, double[][] c, int[][] cssr, BitSet ss, MoleculeGraph m, PartialOptimization opt, int Debug2) {
        int[] r;
        int ac = m.getAtomCount();
        double[] tmp = new double[ac * 2];
        BitSet fs = new BitSet(ac);
        int n = 0;
        int i = ss.nextSetBit(0);
        while (i >= 0) {
            r = cssr[i];
            for (int j = r.length - 1; j >= 0; --j) {
                int idx = r[j];
                MolAtom a = m.getAtom(idx);
                a.setXYZ(c[i][j * 2], c[i][j * 2 + 1], 0.0);
                if (fs.get(idx)) continue;
                fs.set(idx);
                tmp[n++] = c[i][j * 2];
                tmp[n++] = c[i][j * 2 + 1];
            }
            i = ss.nextSetBit(i + 1);
        }
        double[] mc = new double[n];
        System.arraycopy(tmp, 0, mc, 0, mc.length);
        r = cssr[r_idx];
        double[] cr = c[r_idx];
        boolean overlap = false;
        double[] c_1 = new double[2];
        double[] c_2 = new double[2];
        for (int i2 = r.length - 1; i2 >= 0; --i2) {
            int idx = r[i2];
            if (fs.get(idx)) continue;
            c_2[0] = cr[i2 * 2];
            c_2[1] = cr[i2 * 2 + 1];
            for (int j = mc.length - 1; j >= 0; j -= 2) {
                c_1[1] = mc[j];
                c_1[0] = mc[j - 1];
                if (!(Clean2D.dist2(c_1, c_2) < 0.0154)) continue;
                overlap = true;
                cr[i2 * 2] = c_2[0] + 0.077;
                cr[i2 * 2 + 1] = c_2[1] + 0.077;
            }
        }
        if (overlap) {
            int i3;
            MolAtom a;
            BitSet ms = new BitSet(ac);
            for (int i4 = r.length - 1; i4 >= 0; --i4) {
                int idx = r[i4];
                if (fs.get(idx)) continue;
                a = m.getAtom(idx);
                a.setXYZ(c[r_idx][i4 * 2], c[r_idx][i4 * 2 + 1], 0.0);
                ms.set(idx);
            }
            int[] f = new int[ac];
            for (i3 = 0; i3 < ac; ++i3) {
                a = m.getAtom(i3);
                if (fs.get(i3)) {
                    f[i3] = 1;
                    a.setZ(2.0);
                    continue;
                }
                if (!ms.get(i3)) continue;
                a.setZ(2.0);
            }
            Clean2D.optimizeMolecule(m, f, opt, 9, 1, Debug2);
            for (i3 = r.length - 1; i3 >= 0; --i3) {
                int idx = r[i3];
                if (!ms.get(idx)) continue;
                MolAtom a2 = m.getAtom(idx);
                c[r_idx][i3 * 2] = a2.getX();
                c[r_idx][i3 * 2 + 1] = a2.getY();
            }
        }
    }

    private static void singleRingCoordinates(MoleculeGraph m, int[][] cssr, BitSet cb, int Debug2) {
        int[] r;
        if (Debug2 > 2) {
            System.err.println("Try build from single rings ");
        }
        int cssrl = cssr.length;
        int ac = m.getAtomCount();
        BitSet[] rs = new BitSet[cssrl];
        for (int i = 0; i < cssrl; ++i) {
            BitSet s = new BitSet(ac);
            r = cssr[i];
            for (int j = r.length - 1; j >= 0; --j) {
                s.set(r[j]);
            }
            rs[i] = s;
        }
        BondTable btab = m.getBondTable();
        boolean[] fixedR = new boolean[cssrl];
        r = cssr[cssrl - 1];
        double[] c = Clean2D.singleRingCoordinate(m, r, cb, btab, Debug2);
        for (int i = 0; i < r.length; ++i) {
            MolAtom a = m.getAtom(r[i]);
            a.setXYZ(c[i * 2], c[i * 2 + 1], 2.0);
        }
        fixedR[cssrl - 1] = true;
        BitSet fixedAtoms = new BitSet(ac);
        fixedAtoms.or(rs[cssrl - 1]);
        int fixedRingCount = 1;
        do {
            for (int i = 0; i < cssrl; ++i) {
                BitSet fixed = new BitSet(ac);
                fixed.or(fixedAtoms);
                fixed.and(rs[i]);
                if (fixedR[i] || fixed.cardinality() <= 1) continue;
                r = cssr[i];
                int[] fixedr = null;
                for (int j = 0; j < cssrl && fixedr == null; ++j) {
                    fixed.clear();
                    fixed.or(rs[i]);
                    fixed.and(rs[j]);
                    if (!fixedR[j] || fixed.cardinality() <= 1) continue;
                    fixedr = cssr[j];
                }
                Clean2D.rearrangeRingAccording(r, fixedr, fixed, m);
                int rl = r.length;
                double fi = Math.PI - Math.PI * 2 / (double)rl;
                for (int j = 1; j < rl; ++j) {
                    int p = r[j - 1];
                    int h = r[j];
                    int n = r[(j + 1) % rl];
                    MolAtom ap = m.getAtom(p);
                    MolAtom ah = m.getAtom(h);
                    MolAtom an = m.getAtom(n);
                    MolBond b = m.getBond(btab.getBondIndex(n, h));
                    Clean2D.setXY(m, ap, ah, an, b, fi, false, 0);
                }
                fixedR[i] = true;
                ++fixedRingCount;
                fixedAtoms.or(rs[i]);
            }
        } while (fixedRingCount < cssrl);
    }

    private static BitSet generateRingBondSet(int[] r, BondTable btab) {
        BitSet s = new BitSet();
        int l = r.length;
        for (int i = 0; i < l; ++i) {
            int h = r[i];
            int n = r[(i + 1) % l];
            s.set(btab.getBondIndex(h, n));
        }
        return s;
    }

    private static BitSet generateRingAtomSet(int[] r) {
        BitSet s = new BitSet();
        int l = r.length;
        for (int i = 0; i < l; ++i) {
            s.set(r[i]);
        }
        return s;
    }

    static boolean isCentOfMassAway(double x_0, double y_0, double x_1, double y_1, double[] c1, double[] c2) {
        double[] cm1 = new double[2];
        for (int i = c1.length - 1; i >= 0; --i) {
            cm1[1] = cm1[1] + c1[i];
            cm1[0] = cm1[0] + c1[i - 1];
            --i;
        }
        cm1[0] = cm1[0] / (double)(c1.length / 2);
        cm1[1] = cm1[1] / (double)(c1.length / 2);
        double[] cm2 = new double[2];
        for (int i = c2.length - 1; i >= 0; --i) {
            cm2[1] = cm2[1] + c2[i];
            cm2[0] = cm2[0] + c2[i - 1];
            --i;
        }
        cm2[1] = cm2[1] / (double)(c2.length / 2);
        cm2[0] = cm2[0] / (double)(c2.length / 2);
        double dist1_x = cm1[0] - cm2[0];
        double dist1_y = cm1[1] - cm2[1];
        double dist1 = dist1_x * dist1_x + dist1_y * dist1_y;
        Clean2D.mirrorCoords(x_0, y_0, x_1, y_1, cm1);
        double dist2_x = cm1[0] - cm2[0];
        double dist2_y = cm1[1] - cm2[1];
        double dist2 = dist2_x * dist2_x + dist2_y * dist2_y;
        return dist1 > dist2;
    }

    static boolean largeRingFromPolygons(int idx, int[][] r, double[][] c, BitSet[] ringAtoms, Vector<BitSet> rss, MoleculeGraph m, int Debug2) {
        if (Debug2 > 3) {
            System.err.println("\t\tlarge Ring From Polygons");
        }
        int[] lr = r[idx];
        int l = lr.length;
        BitSet llset = ringAtoms[idx];
        BitSet common = new BitSet();
        BitSet cx = new BitSet();
        BitSet cc = new BitSet();
        for (int i = r.length - 1; i >= 0; --i) {
            if (r[i].length >= 10) continue;
            common.clear();
            common.or(llset);
            common.and(ringAtoms[i]);
            if (common.cardinality() <= 1) continue;
            for (int j = 0; j < l; ++j) {
                int p = lr[(j - 1 + l) % l];
                int h = lr[j];
                int n = lr[(j + 1) % l];
                if (!common.get(h)) continue;
                if (common.get(p) && common.get(n)) {
                    cc.set(h);
                    continue;
                }
                cx.set(h);
            }
        }
        BondTable btab = m.getBondTable();
        double[] coord = Clean2D.singleRingCoordinate(m, lr, null, btab, 0);
        boolean success = Clean2D.transformCoordinateAccordingToCisTrans(m, lr, coord, cx, cc, null, null, null, btab, Debug2);
        if (!success) {
            for (int i = 1; i < l / 2; ++i) {
                double t = coord[2 * i];
                coord[2 * i] = coord[2 * (l - i)];
                coord[2 * (l - i)] = t;
                t = coord[2 * i + 1];
                coord[2 * i + 1] = coord[2 * (l - i) + 1];
                coord[2 * (l - i) + 1] = t;
            }
            success = Clean2D.transformCoordinateAccordingToCisTrans(m, lr, coord, cx, cc, null, null, null, btab, Debug2);
        }
        if (Debug2 > 3) {
            System.err.println("large ring from polygons " + success);
        }
        if (success) {
            c[idx] = coord;
            for (int j = rss.size() - 1; j >= 0; --j) {
                BitSet s = rss.get(j);
                common.clear();
                int k = s.nextSetBit(0);
                while (k >= 0) {
                    common.or(ringAtoms[k]);
                    k = s.nextSetBit(k + 1);
                }
                common.and(llset);
                int idx1 = -1;
                int idx2 = -1;
                for (int k2 = 0; k2 < l; ++k2) {
                    int h = lr[k2];
                    if (!common.get(h)) continue;
                    if (idx1 == -1) {
                        idx1 = k2;
                        continue;
                    }
                    idx2 = k2;
                }
                if (idx1 < 0 || idx2 < 0) continue;
                Clean2D.transformCoordinatesToIndexes(idx1, idx2, r, c, idx, s);
                if (!Clean2D.commonAtomCoordinateMatch(common, r, c, idx, s)) {
                    double[] p = new double[]{c[idx][idx1 * 2], c[idx][idx1 * 2 + 1], c[idx][idx2 * 2], c[idx][idx2 * 2 + 1]};
                    int k3 = s.nextSetBit(0);
                    while (k3 >= 0) {
                        Clean2D.mirrorCoords(p[0], p[1], p[2], p[3], c[k3]);
                        k3 = s.nextSetBit(k3 + 1);
                    }
                }
                s.set(idx);
            }
        }
        return success;
    }

    static boolean commonAtomCoordinateMatch(BitSet cs, int[][] r, double[][] c, int idx, BitSet s) {
        int[] lr = r[idx];
        int l = lr.length;
        for (int i = 0; i < l; ++i) {
            double dy;
            int h = lr[i];
            if (!cs.get(h)) continue;
            double[] dArray = new double[]{c[idx][i * 2], c[idx][i * 2 + 1]};
            double[] llcoord = dArray;
            double[] coord = Clean2D.getCoordinates(h, idx, r, c);
            double dx = llcoord[0] - coord[0];
            if (!(dx * dx + (dy = llcoord[1] - coord[1]) * dy > 0.2635111111111111)) continue;
            return false;
        }
        return true;
    }

    private static boolean[] locateCommonRings(int idx, BitSet[] ringBonds) {
        int l = ringBonds.length;
        boolean[] commonrings = new boolean[l];
        BitSet largeRB = ringBonds[idx];
        BitSet cs = new BitSet();
        cs.or(largeRB);
        for (int i = l - 1; i > idx; --i) {
            cs.and(ringBonds[i]);
            if (cs.cardinality() > 0) {
                commonrings[i] = true;
            }
            cs.clear();
            cs.or(largeRB);
        }
        return commonrings;
    }

    static void setCoordinatesFromRings(int idx, boolean[] join, double[][] c, int[][] r, Vector<BitSet> rss, BitSet[] ringAtoms) {
        int[] lr = r[idx];
        int l = lr.length;
        boolean[] moved = new boolean[join.length];
        BitSet commonAtoms = new BitSet();
        BitSet commonAtomsWithActuatSystem = new BitSet();
        for (int i = join.length - 1; i >= 0; --i) {
            if (join[i] && !moved[i]) {
                int n;
                commonAtomsWithActuatSystem.clear();
                commonAtomsWithActuatSystem.or(ringAtoms[idx]);
                BitSet rs = null;
                for (int j = rss.size() - 1; j >= 0; --j) {
                    BitSet s = rss.get(j);
                    if (!s.get(i)) continue;
                    rs = s;
                    break;
                }
                if (rs == null) continue;
                BitSet atomSystemSet = new BitSet();
                int j = rs.nextSetBit(0);
                while (j >= 0) {
                    atomSystemSet.or(ringAtoms[j]);
                    moved[j] = true;
                    j = rs.nextSetBit(j + 1);
                }
                commonAtomsWithActuatSystem.and(atomSystemSet);
                int idx1 = -1;
                int idx2 = -1;
                for (int j2 = l - 1; j2 >= 0; --j2) {
                    int p = lr[(j2 + l - 1) % l];
                    int h = lr[j2];
                    n = lr[(j2 + 1) % l];
                    if (atomSystemSet.get(h) && !atomSystemSet.get(p)) {
                        idx1 = j2;
                        continue;
                    }
                    if (!atomSystemSet.get(h) || atomSystemSet.get(n)) continue;
                    idx2 = j2;
                }
                if (idx1 >= 0 && idx2 >= 0) {
                    BitSet nonCommonAtoms = new BitSet(l);
                    nonCommonAtoms.or(ringAtoms[idx]);
                    double[] cm = Clean2D.calcCM(c[idx], lr, nonCommonAtoms);
                    Clean2D.transformCoordinatesToIndexes(idx1, idx2, r, c, idx, rs);
                    double[] cms = new double[2];
                    n = 0;
                    int j3 = rs.nextSetBit(0);
                    while (j3 >= 0) {
                        double[] tmp = Clean2D.calcCM(c[j3]);
                        cms[0] = cms[0] + tmp[0];
                        cms[1] = cms[1] + tmp[1];
                        ++n;
                        j3 = rs.nextSetBit(j3 + 1);
                    }
                    cms[0] = cms[0] / (double)n;
                    cms[1] = cms[1] / (double)n;
                    double dx = cm[0] - cms[0];
                    double dy = cm[1] - cms[1];
                    double d1 = Math.sqrt(dx * dx + dy * dy);
                    double[] p = new double[]{c[idx][idx1 * 2], c[idx][idx1 * 2 + 1], c[idx][idx2 * 2], c[idx][idx2 * 2 + 1]};
                    int j4 = rs.nextSetBit(0);
                    while (j4 >= 0) {
                        Clean2D.mirrorCoords(p[0], p[1], p[2], p[3], c[j4]);
                        j4 = rs.nextSetBit(j4 + 1);
                    }
                    cms[0] = 0.0;
                    cms[1] = 0.0;
                    n = 0;
                    j4 = rs.nextSetBit(0);
                    while (j4 >= 0) {
                        double[] tmp = Clean2D.calcCM(c[j4]);
                        cms[0] = cms[0] + tmp[0];
                        cms[1] = cms[1] + tmp[1];
                        ++n;
                        j4 = rs.nextSetBit(j4 + 1);
                    }
                    cms[0] = cms[0] / (double)n;
                    cms[1] = cms[1] / (double)n;
                    dx = cm[0] - cms[0];
                    dy = cm[1] - cms[1];
                    double d2 = Math.sqrt(dx * dx + dy * dy);
                    if (d1 > d2) {
                        int j5 = rs.nextSetBit(0);
                        while (j5 >= 0) {
                            Clean2D.mirrorCoords(p[0], p[1], p[2], p[3], c[j5]);
                            j5 = rs.nextSetBit(j5 + 1);
                        }
                    }
                    double[] llc = c[idx];
                    for (int j6 = l - 1; j6 >= 0; --j6) {
                        int h = lr[j6];
                        if (!atomSystemSet.get(h)) continue;
                        double[] coord = Clean2D.getCoordinates(h, idx, r, c);
                        llc[j6 * 2] = coord[0];
                        llc[j6 * 2 + 1] = coord[1];
                    }
                }
                rs.set(idx);
            }
            commonAtoms.or(commonAtomsWithActuatSystem);
            moved[i] = true;
        }
    }

    static void joinSystems(Vector<BitSet> s, int idx) {
        int l = s.size();
        for (int i = 0; i < l; ++i) {
            BitSet ss = s.get(i);
            if (!ss.get(idx)) continue;
            for (int j = l - 1; j >= i + 1; --j) {
                BitSet js = s.get(j);
                if (!js.get(idx)) continue;
                ss.or(js);
                s.removeElementAt(j);
            }
            return;
        }
    }

    static void transformCoordinatesToIndexes(int idx1, int idx2, int[][] r, double[][] c, int idx, BitSet rs) {
        double[] llc = c[idx];
        int atomIdx1 = r[idx][idx1];
        int atomIdx2 = r[idx][idx2];
        double[] coord = Clean2D.getCoordinates(atomIdx1, idx, r, c);
        CTransform3D T = new CTransform3D();
        T.setTranslation(llc[idx1 * 2] - coord[0], llc[idx1 * 2 + 1] - coord[1], 0.0);
        int j = rs.nextSetBit(0);
        while (j >= 0) {
            Clean2D.transform(c[j], T);
            j = rs.nextSetBit(j + 1);
        }
        coord = Clean2D.getCoordinates(atomIdx2, idx, r, c);
        DPoint3 p = new DPoint3();
        p.x = llc[idx1 * 2];
        p.y = llc[idx1 * 2 + 1];
        double phi = p.angle2D(llc[idx2 * 2], llc[idx2 * 2 + 1]) - p.angle2D(coord[0], coord[1]);
        T.setRotation(0.0, 0.0, 1.0, phi);
        T.setRotationCenter(p);
        int j2 = rs.nextSetBit(0);
        while (j2 >= 0) {
            Clean2D.transform(c[j2], T);
            j2 = rs.nextSetBit(j2 + 1);
        }
    }

    static void mirrorCoords(double x_0, double y_0, double x_1, double y_1, double[] c) {
        double n_x = x_0 - x_1;
        double n_y = y_0 - y_1;
        double n_l = Math.sqrt(n_x * n_x + n_y * n_y);
        n_x /= n_l;
        n_y /= n_l;
        for (int i = c.length - 1; i >= 0; --i) {
            double y = c[i];
            double x = c[i - 1];
            double d = (x - x_0) * n_x + (y - y_0) * n_y;
            c[i] = -y + 2.0 * (y_0 + n_y * d);
            c[i - 1] = -x + 2.0 * (x_0 + n_x * d);
            --i;
        }
    }

    static boolean rearrangeRingTohaveCommonAtFirst(int[] r, MoleculeGraph m, BitSet cs) {
        int rl = r.length;
        for (int i = 0; i < rl; ++i) {
            int h = r[i];
            int n = r[(i + 1) % rl];
            if (!cs.get(h) || !cs.get(n)) continue;
            int[] tmp = new int[rl];
            System.arraycopy(r, i, tmp, 0, rl - i);
            System.arraycopy(r, 0, tmp, rl - i, i);
            System.arraycopy(tmp, 0, r, 0, rl);
            return true;
        }
        return false;
    }

    private static void rearrangeRingAccording(int[] r1, int[] r2, BitSet cs, MoleculeGraph m) {
        int l = r1.length;
        for (int i = 0; i < l - 1; ++i) {
            int l2;
            int j;
            int idx = r1[i];
            int idx_n = r1[i + 1];
            if (!cs.get(idx) || !cs.get(idx_n)) continue;
            for (j = r2.length - 1; j >= 0 && r2[j] != idx; --j) {
            }
            if (j < 0 && Error == 1) {
                System.err.println(" Error rearranging rings at idx loc");
            }
            int j1 = j;
            for (j = r2.length - 1; j >= 0 && r2[j] != idx_n; --j) {
            }
            if (j < 0 && Error == 1) {
                System.err.println(" Error rearrangingr rings at idx_n loc");
            }
            if ((j1 + 1) % (l2 = r2.length) == j) {
                Clean2D.flipRing(r1);
                break;
            }
            if ((j1 - 1 + l2) % l2 == j || Error != 1) break;
            System.err.println(" Error rearranging rings " + j1 + " " + j);
            break;
        }
        if (!Clean2D.rearrangeRingTohaveCommonAtFirst(r1, m, cs) && Error == 1) {
            System.err.println(" Error rearrangingr rings");
        }
    }

    static void setXY(MoleculeGraph m, MolAtom ao, MolAtom ac, MolAtom an, MolBond bnew, double fi, boolean checkfixed, int Debug2) {
        if (!checkfixed || an.getZ() != 2.0) {
            double l = m.getDesiredLength(bnew);
            double dx = ao.getX() - ac.getX();
            double dy = ao.getY() - ac.getY();
            double c = Math.cos(fi);
            double s = Math.sin(fi);
            double dxn = c * dx - s * dy;
            double dyn = c * dy + s * dx;
            double dn = Math.sqrt(dxn * dxn + dyn * dyn);
            an.setXYZ(ac.getX() + dxn / dn * l, ac.getY() + dyn / dn * l, 2.0);
            if (Debug2 > 7) {
                System.err.println("atom " + (m.indexOf(an) + 1) + "  angle " + (m.indexOf(ao) + 1) + "-" + (m.indexOf(ac) + 1) + "-" + (m.indexOf(an) + 1) + ": " + "  " + fi);
            }
        }
    }

    static void setXY(double[] c0, double[] c1, double[] c2, double fi) {
        double l = 1.54;
        double dx = c0[0] - c1[0];
        double dy = c0[1] - c1[1];
        double c = Math.cos(fi);
        double s = Math.sin(fi);
        double dxn = c * dx - s * dy;
        double dyn = c * dy + s * dx;
        double dn = Math.sqrt(dxn * dxn + dyn * dyn);
        c2[0] = c1[0] + dxn / dn * l;
        c2[1] = c1[1] + dyn / dn * l;
    }

    static boolean transformCoordinateAccordingToCisTrans(MoleculeGraph m, int[] r, double[] c, BitSet cx, BitSet cc, BitSet cb_f, BitSet tb_f, BitSet cidx, BondTable btab, int Debug2) {
        int l = r.length;
        if (l > 64 && (cc != null && cc.cardinality() > 0 || tb_f != null && tb_f.cardinality() > 0)) {
            return false;
        }
        long[] bitsets = new long[9];
        for (int i = 0; i < l; ++i) {
            int i2 = r[i];
            int i3 = r[(i + 1) % l];
            int n = (i - 1 + l) % l;
            double[] c1 = new double[]{c[2 * n], c[2 * n + 1]};
            double[] c2 = new double[]{c[2 * i], c[2 * i + 1]};
            n = (i + 1) % l;
            double[] c3 = new double[]{c[2 * n], c[2 * n + 1]};
            n = (i + 2) % l;
            double[] c4 = new double[]{c[2 * n], c[2 * n + 1]};
            long bn = 1L << i;
            int b_idx = btab.getBondIndex(i2, i3);
            int s = Clean2D.getStereo2(c1, c2, c3, c4);
            if (s == 64) {
                bitsets[0] = bitsets[0] | bn;
            } else if (s == 128) {
                bitsets[1] = bitsets[1] | bn;
            }
            if (Clean2D.isConvex(i, c)) {
                bitsets[6] = bitsets[6] | bn;
            } else {
                bitsets[7] = bitsets[7] | bn;
            }
            if (cx != null && cx.get(i2)) {
                bitsets[2] = bitsets[2] | bn;
            }
            if (cc != null && cc.get(i2)) {
                bitsets[3] = bitsets[3] | bn;
            }
            if (cb_f != null && cb_f.get(b_idx)) {
                bitsets[5] = bitsets[5] | bn;
            }
            if (tb_f != null && tb_f.get(b_idx)) {
                bitsets[4] = bitsets[4] | bn;
            }
            if (cidx == null || !cidx.get(i2)) continue;
            bitsets[8] = bitsets[8] | bn;
        }
        int shift = 0;
        long mask = (long)(Math.pow(2.0, l) - 1.0);
        long lastbit = 1L << l - 1;
        while (!(shift >= l || Clean2D.isTheSetsMatch(bitsets[2], bitsets[6]) && Clean2D.isTheSetsMatch(bitsets[3], bitsets[7]) && Clean2D.isTheSetsMatch(bitsets[4], bitsets[0]) && Clean2D.isTheSetsMatch(bitsets[5], bitsets[1]) && Clean2D.isTheSetsMatch(bitsets[8], bitsets[6]))) {
            ++shift;
            long set = bitsets[0];
            boolean addone = (set & lastbit) == lastbit;
            long tmp1 = set << 1;
            if (addone) {
                tmp1 |= 1L;
            }
            bitsets[0] = tmp1 & mask;
            set = bitsets[1];
            addone = (set & lastbit) == lastbit;
            tmp1 = set << 1;
            if (addone) {
                tmp1 |= 1L;
            }
            bitsets[1] = tmp1 & mask;
            set = bitsets[6];
            addone = (set & lastbit) == lastbit;
            tmp1 = set << 1;
            if (addone) {
                tmp1 |= 1L;
            }
            bitsets[6] = tmp1 & mask;
            set = bitsets[7];
            addone = (set & lastbit) == lastbit;
            tmp1 = set << 1;
            if (addone) {
                tmp1 |= 1L;
            }
            bitsets[7] = tmp1 & mask;
        }
        if (shift >= l) {
            if (Debug2 > 3) {
                System.err.println("transformCoordinateAccordingToCisTrans failure shift " + shift);
            }
            return false;
        }
        if (shift == 0) {
            return true;
        }
        double[] tmp = new double[2 * l];
        System.arraycopy(c, 2 * (l - shift), tmp, 0, 2 * shift);
        System.arraycopy(c, 0, tmp, 2 * shift, 2 * (l - shift));
        System.arraycopy(tmp, 0, c, 0, 2 * l);
        return true;
    }

    static boolean isTheSetsMatch(long a, long b) {
        long andset = a & b;
        return andset == a;
    }

    static void flipRing(int[] r) {
        int l = r.length;
        for (int i = l / 2 - 1; i >= 0; --i) {
            int t = r[i];
            r[i] = r[l - 1 - i];
            r[l - 1 - i] = t;
        }
    }

    static void ringCoordsToIntang(MoleculeGraph m, BitSet system, int[][] cssr, int[][] ctab, BondTable btab, double[][] intang) {
        for (int i = cssr.length - 1; i >= 0; --i) {
            if (!system.get(i)) continue;
            int[] r = cssr[i];
            for (int j = r.length - 1; j >= 0; --j) {
                int idx = r[j];
                Clean2D.coordinate2IntAng(idx, ctab[idx], btab, m, intang);
            }
        }
    }

    static void coordinate2IntAng(int idx, int[] ct, BondTable btab, MoleculeGraph m, double[][] intang) {
        MolAtom center = m.getAtom(idx);
        for (int i = ct.length - 1; i >= 0; --i) {
            int l1 = ct[i];
            MolAtom a1 = m.getAtom(l1);
            if (a1.getZ() != 2.0) continue;
            int b1 = btab.getBondIndex(idx, l1);
            for (int j = i - 1; j >= 0; --j) {
                int l2 = ct[j];
                MolAtom a2 = m.getAtom(l2);
                if (a2.getZ() != 2.0) continue;
                double fi = Clean2D.getAngleFromCoords(a1, center, a2);
                int b2 = btab.getBondIndex(idx, l2);
                intang[b1][b2] = fi;
                intang[b2][b1] = -fi;
            }
        }
    }

    static double getAngleFromCoords(MolAtom a1, MolAtom c, MolAtom a2) {
        double y2;
        double x1 = a1.getX() - c.getX();
        double y1 = a1.getY() - c.getY();
        double x2 = a2.getX() - c.getX();
        double x = (x1 * x2 + y1 * (y2 = a2.getY() - c.getY())) / (Math.sqrt(x1 * x1 + y1 * y1) * Math.sqrt(x2 * x2 + y2 * y2));
        x = x > 1.0 ? 1.0 : (x < -1.0 ? -1.0 : x);
        double fi = Math.acos(x);
        double s = x1 * y2 - x2 * y1;
        return s < 0.0 ? -fi : fi;
    }

    static void generateIntAngForRingLigands(MoleculeGraph m, BitSet system, int[][] cssr, int[] atomFlags, int[][] ctab, BondTable btab, double[][] intang, int[][] atomInRing, BitSet[] rs, boolean[] isRingBond) {
        for (int i = cssr.length - 1; i >= 0; --i) {
            if (!system.get(i)) continue;
            int[] r = cssr[i];
            for (int j = r.length - 1; j >= 0; --j) {
                int idx = r[j];
                if ((atomFlags[idx] & 0x8000) != 0) continue;
                Clean2D.generateIntAngForLigands(idx, ctab, btab, m, intang, atomInRing, cssr, rs, atomFlags, false, isRingBond);
                if (ctab[idx].length != 3 || atomInRing[idx].length != 1 || !Clean2D.hasTerminal(ctab[idx], atomFlags)) continue;
                int n = idx;
                atomFlags[n] = atomFlags[n] | 0x40;
            }
        }
    }

    static void generateIntAngForLigands(int idx, int[][] ctab, BondTable btab, MoleculeGraph m, double[][] intang, int[][] atomInRing, int[][] cssr, BitSet[] rs, int[] atomFlags, boolean isH, boolean[] isRingBond) {
        MolAtom center = m.getAtom(idx);
        int[] an = ctab[idx];
        int ac = an.length;
        int fixedC = 0;
        int nonfixedC = 0;
        int fixedNonRingC = 0;
        int[] b = new int[ac];
        int[] l = new int[ac];
        int ref = -1;
        boolean triplebond = false;
        int oneNonfixedIdx = -1;
        boolean allNonFixedIsH = true;
        for (int i = 0; i < ac; ++i) {
            int ligand = an[i];
            MolAtom a1 = m.getAtom(ligand);
            if (a1.getZ() == 2.0) {
                int bidx;
                b[fixedC] = bidx = btab.getBondIndex(idx, ligand);
                l[fixedC] = ligand;
                if (ref == -1) {
                    ref = i;
                }
                ++fixedC;
                if (atomInRing[ligand].length == 0) {
                    ++fixedNonRingC;
                }
            } else {
                if (a1.getAtno() != 1) {
                    allNonFixedIsH = false;
                }
                ++nonfixedC;
                oneNonfixedIdx = ligand;
            }
            isH = !isH ? true : allNonFixedIsH;
            int t = center.getBond(i).getType();
            if (t != 3) continue;
            triplebond = true;
        }
        if (nonfixedC == 0) {
            return;
        }
        int f = 0;
        if (atomFlags != null) {
            int n = idx;
            atomFlags[n] = atomFlags[n] | 0x80;
            f = atomFlags[idx];
        }
        ++nonfixedC;
        if (fixedC == 0) {
            double fi_0 = nonfixedC - 1 < 3 ? 2.0943951023931953 : Math.PI * 2 / (double)(nonfixedC - 1);
            ref = 0;
            b[0] = btab.getBondIndex(idx, an[0]);
            Clean2D.setUnsetIntang(idx, ref, an, m, btab, fi_0, b[0], intang);
        } else if (fixedC == 1) {
            double fi_0 = Math.PI * 2 / (double)nonfixedC;
            if (nonfixedC - 1 == 1 && !triplebond && !(center instanceof SgroupAtom)) {
                fi_0 = 2.0943951023931953;
            }
            Clean2D.setUnsetIntang(idx, ref, an, m, btab, fi_0, b[0], intang);
            int s = m.getBond(b[0]).getFlags() & 0xC0;
            if (s != 0 && !Clean2D.intAngCorrespondToStereo(b[0], ctab, btab, intang, m)) {
                Clean2D.setUnsetIntang(idx, ref, an, m, btab, -fi_0, b[0], intang);
            }
        } else if (fixedC == 2) {
            double fi_fix = intang[b[0]][b[1]];
            double fi_0 = 0.0;
            boolean convex = true;
            if ((f & 1) != 0 && (f & 0x400) == 0) {
                convex = Clean2D.isConvexInSmallestRing(idx, cssr, atomInRing[idx], m);
            }
            fi_0 = convex ? (fi_fix < 0.0 ? Math.PI * 2 + fi_fix : Math.PI * -2 + fi_fix) : (nonfixedC - 1 == 1 && atomFlags[oneNonfixedIdx] == 4 ? (fi_fix < 0.0 ? Math.PI * 2 + fi_fix : Math.PI * -2 + fi_fix) : fi_fix);
            fi_0 /= (double)nonfixedC;
            if (isH && nonfixedC - 1 == 2) {
                int n = 1;
                for (int i = 1; i < ac; ++i) {
                    double fi;
                    int ligand = an[(ref + i) % ac];
                    MolAtom a1 = m.getAtom(ligand);
                    if (a1.getZ() == 2.0) continue;
                    int b1 = btab.getBondIndex(idx, ligand);
                    intang[b[0]][b1] = fi = n == 1 ? (double)n++ * fi_0 * 1.15 : fi_0 * 1.85;
                    intang[b1][b[0]] = -fi;
                }
                Clean2D.resolveIntAngFromReference(an[ref], idx, btab, an, intang);
            } else {
                Clean2D.setUnsetIntang(idx, ref, an, m, btab, fi_0, b[0], intang);
            }
        } else if (fixedC > 2) {
            int idxInRings = atomInRing[idx].length;
            if (idxInRings == 0) {
                if (isH) {
                    int new_ref = Clean2D.putWedgeBondToTheTop(center, b, an, m);
                    ref = new_ref >= 0 ? new_ref : ref;
                }
                double fi_fix = intang[b[0]][b[1]];
                double fi_0 = fi_fix / (double)nonfixedC;
                Clean2D.setUnsetIntang(idx, ref, an, m, btab, fi_0, b[0], intang);
            } else if (atomFlags != null && (atomFlags[idx] & 0x10000) == 65536) {
                Clean2D.calcIntAngAroundSpiroAtom(idx, an, rs, btab, intang, m);
            } else {
                double fi_0;
                double fi_fix;
                if (idxInRings == 1) {
                    int n = 0;
                    boolean ringBondLocated = false;
                    for (int i = 0; i < fixedC && n < 3; ++i) {
                        if (!isRingBond[b[i]]) {
                            if (n == 0) {
                                ref = Clean2D.indexOf(an, l[i]);
                            }
                            b[n++] = b[i];
                            continue;
                        }
                        if (ringBondLocated) continue;
                        if (n == 0) {
                            ref = Clean2D.indexOf(an, l[i]);
                        }
                        b[n++] = b[i];
                        ringBondLocated = true;
                    }
                    fi_0 = fi_fix = intang[b[0]][b[1]];
                } else if (idxInRings == 2) {
                    int[] rIdxes = atomInRing[idx];
                    int n = 0;
                    int bCommonIdx = -1;
                    for (int i = 0; i < fixedC; ++i) {
                        if (!Clean2D.allContains(rIdxes, atomInRing[l[i]])) {
                            if (n == 0) {
                                ref = Clean2D.indexOf(an, l[i]);
                            }
                            b[n++] = b[i];
                            continue;
                        }
                        bCommonIdx = b[i];
                    }
                    fi_fix = intang[b[0]][b[1]];
                    boolean convex = true;
                    if (fi_fix != Math.PI && fi_fix != -Math.PI) {
                        convex = Clean2D.isConvexInRings(idx, btab, cssr, atomInRing[idx], m);
                    } else if (bCommonIdx >= 0) {
                        double fi_to_common = intang[b[0]][bCommonIdx];
                        fi_fix = (fi_to_common = Clean2D.convertToPos(fi_to_common)) > Math.PI ? -Math.PI : Math.PI;
                    }
                    fi_0 = convex ? (fi_fix < 0.0 ? Math.PI * 2 + fi_fix : Math.PI * -2 + fi_fix) : fi_fix;
                } else {
                    fi_fix = 0.0;
                    int b0 = 0;
                    for (int i = 0; i < fixedC; ++i) {
                        int bn = (i + 1) % fixedC;
                        double fi = intang[b[i]][b[bn]] % (Math.PI * 2);
                        if (!(Math.abs(fi) > Math.abs(fi_fix))) continue;
                        fi_fix = fi;
                        ref = Clean2D.indexOf(an, l[i]);
                        b0 = b[i];
                    }
                    b[0] = b0;
                    double[] polyeder = new double[fixedC * 2];
                    for (int i = 0; i < fixedC; ++i) {
                        MolAtom a = m.getAtom(l[i]);
                        polyeder[i * 2] = a.getX();
                        polyeder[i * 2 + 1] = a.getY();
                    }
                    double[] centerc = new double[]{center.getX(), center.getY()};
                    boolean inside = Clean2D.inpoly(polyeder, centerc);
                    double d = fi_0 = inside ? fi_fix : Math.PI * -2 + fi_fix;
                }
                if (isH && fixedNonRingC == 1) {
                    fi_0 = fi_fix;
                }
                Clean2D.setUnsetIntang(idx, ref, an, m, btab, fi_0 /= (double)nonfixedC, b[0], intang);
            }
        } else if (Error == 1) {
            System.err.println("not yet supported ");
        }
        if (atomFlags != null) {
            int n = idx;
            atomFlags[n] = atomFlags[n] | 0x8000;
        }
    }

    static int putWedgeBondToTheTop(MolAtom c, int[] bidxes, int[] an, MoleculeGraph m) {
        int l = bidxes.length;
        int t = 0;
        MolBond b = null;
        for (int i = 0; i < l; ++i) {
            b = m.getBond(bidxes[i]);
            if (b.getAtom1() != c || (b.getFlags() & 0x30) == 0) continue;
            t = bidxes[0];
            bidxes[0] = bidxes[i];
            bidxes[i] = t;
            break;
        }
        if (b == null) {
            return -1;
        }
        int idx = m.indexOf(b.getAtom2());
        return Clean2D.indexOf(an, idx);
    }

    static boolean calcIntAngAroundSpiroAtom(int idx, int[] an, BitSet[] rs, BondTable btab, double[][] intang, MoleculeGraph m) {
        MolAtom a0 = m.getAtom(idx);
        int l = a0.getBondCount();
        int[] tmp = new int[l];
        int n = 0;
        for (int i = 0; i < l; ++i) {
            MolAtom lig = a0.getLigand(i);
            if (lig.getZ() != 2.0) continue;
            tmp[n++] = i;
        }
        int nonFixedC = l - n;
        int[] bi = new int[n];
        System.arraycopy(tmp, 0, bi, 0, n);
        double[] angles = GeomUtil.bondAngles(a0, bi);
        double[] diffs = GeomUtil.calcAngleDiffs(angles, bi, null);
        n = 0;
        l = bi.length;
        for (int i = 0; i < l; ++i) {
            int id1 = an[bi[i]];
            int id2 = an[bi[(i + 1) % l]];
            if (Clean2D.inTheSameRing(id1, id2, rs)) continue;
            ++n;
        }
        if (n <= 0) {
            return false;
        }
        int possiblePos = n;
        int arrangeC = nonFixedC / n;
        int ac = an.length;
        int ref = -1;
        double dfi_ref = 0.0;
        int b0 = -1;
        int j = 1;
        for (int i = 0; i < l; ++i) {
            int id1 = an[bi[i]];
            int id2 = an[bi[(i + 1) % l]];
            if (!Clean2D.inTheSameRing(id1, id2, rs)) {
                --n;
                if (ref == -1) {
                    ref = Clean2D.indexOf(an, id1);
                    b0 = btab.getBondIndex(id1, idx);
                }
                if (n == 0) {
                    arrangeC = nonFixedC - (possiblePos - 1) * arrangeC;
                }
                double fi_0 = diffs[i] / (double)(arrangeC + 1);
                int count = 0;
                while (j < ac && count < arrangeC) {
                    int ligand = an[(ref + j) % ac];
                    MolAtom a1 = m.getAtom(ligand);
                    if (a1.getZ() != 2.0) {
                        double fi;
                        int b = btab.getBondIndex(idx, ligand);
                        intang[b0][b] = fi = (double)(++count) * fi_0 + dfi_ref;
                        intang[b][b0] = -fi;
                    }
                    ++j;
                }
            }
            if (ref < 0) continue;
            dfi_ref += diffs[i];
        }
        Clean2D.resolveIntAngFromReference(an[ref], idx, btab, an, intang);
        return true;
    }

    static boolean isConvexInRings(int idx, BondTable btab, int[][] cssr, int[] inRing, MoleculeGraph m) {
        BitSet[] bs = new BitSet[inRing.length];
        for (int i = inRing.length - 1; i >= 0; --i) {
            BitSet rbs;
            int ridx = inRing[i];
            bs[i] = rbs = Clean2D.generateRingBondSet(cssr[ridx], btab);
        }
        BitSet joinedRingBonds = new BitSet();
        for (int i = bs.length - 1; i >= 0; --i) {
            joinedRingBonds.or(bs[i]);
        }
        BitSet common = new BitSet();
        BitSet tmp = new BitSet();
        for (int i = bs.length - 1; i >= 0; --i) {
            tmp.clear();
            tmp.or(bs[i]);
            for (int j = bs.length - 1; j >= 0; --j) {
                tmp.and(bs[j]);
            }
            common.or(tmp);
        }
        joinedRingBonds.andNot(common);
        int[] atomIdxes = Clean2D.convertBondToContinuousAtomIndex(joinedRingBonds, m);
        int l = atomIdxes.length;
        int n = 0;
        for (int i = 0; i < l; ++i) {
            if (atomIdxes[i] != idx) continue;
            n = i;
            break;
        }
        int[] modIdxes = new int[--l];
        System.arraycopy(atomIdxes, 0, modIdxes, 0, n);
        System.arraycopy(atomIdxes, n + 1, modIdxes, n, l - n);
        double[] c = new double[l * 2];
        n = 0;
        for (int i = 0; i < l; ++i) {
            MolAtom a = m.getAtom(modIdxes[i]);
            c[n++] = a.getX();
            c[n++] = a.getY();
        }
        MolAtom a = m.getAtom(idx);
        double[] atomc = new double[]{a.getX(), a.getY()};
        return !Clean2D.inpoly(c, atomc);
    }

    static void setUnsetIntang(int idx, int ref, int[] an, MoleculeGraph m, BondTable btab, double fi_0, int b0, double[][] intang) {
        int ac = an.length;
        int n = 1;
        for (int i = 1; i < ac; ++i) {
            double fi;
            int ligand = an[(ref + i) % ac];
            MolAtom a1 = m.getAtom(ligand);
            if (a1.getZ() == 2.0) continue;
            int b = btab.getBondIndex(idx, ligand);
            intang[b0][b] = fi = (double)n++ * fi_0;
            intang[b][b0] = -fi;
        }
        Clean2D.resolveIntAngFromReference(an[ref], idx, btab, an, intang);
    }

    static int getLargestRingIdx(int[] pool, int[][] cssr) {
        int largestIdx = -1;
        int largestSize = -1;
        boolean equalRings = true;
        for (int i = pool.length - 1; i >= 0; --i) {
            int l = cssr[pool[i]].length;
            if (l <= largestSize) continue;
            largestIdx = pool[i];
            largestSize = l;
            if (!equalRings || i >= pool.length - 1) continue;
            equalRings = false;
        }
        return equalRings ? -largestSize : largestIdx;
    }

    static void fixFixedAtoms(MoleculeGraph m, int[] atomFlags) {
        int ac = m.getAtomCount();
        for (int i = ac - 1; i >= 0; --i) {
            if ((atomFlags[i] & 0x200) == 0) continue;
            MolAtom a = m.getAtom(i);
            a.setZ(2.0);
        }
    }

    static boolean setFixFlag(MoleculeGraph m, int[] atomFlags, int Debug2) {
        int ac = m.getAtomCount();
        for (int i = ac - 1; i >= 0; --i) {
            MolAtom a = m.getAtom(i);
            if (a.getZ() != 2.0) continue;
            if (Double.isNaN(a.getY()) || Double.isNaN(a.getY())) {
                return false;
            }
            int n = i;
            atomFlags[n] = atomFlags[n] | 0x200;
            if (Debug2 > 1) {
                System.err.println(i + " fixed at PC");
            }
            for (int j = i - 1; j >= 0; --j) {
                double d2;
                MolAtom a2 = m.getAtom(j);
                if (a2.getZ() != 2.0 || !((d2 = Clean2D.dist2(a, a2)) < 0.0154)) continue;
                return false;
            }
        }
        return true;
    }

    static void setTerminalAtoms(MoleculeGraph m, int[] atomFlags, int[] fragID) {
        int ac = m.getAtomCount();
        int id = fragID[fragID.length - 1];
        for (int i = ac - 1; i >= 0; --i) {
            MolAtom a = m.getAtom(i);
            int f = atomFlags[i];
            if ((f & 0x3F) == 0 && a.getBondCount() == 1) {
                int n = i;
                atomFlags[n] = atomFlags[n] | 4;
                int n2 = i;
                fragID[n2] = fragID[n2] | id++;
            }
            if (!a.isPseudo() || a.getAliasstr() != "attach") continue;
            int n = i;
            atomFlags[n] = atomFlags[n] | 0x400000;
        }
        fragID[fragID.length - 1] = id;
    }

    static final int[] setLongestChain(int[] atomFlags, BondTable btab, int[][] d, int[][] pred) {
        int j;
        int i;
        Clean2D.distanceMatrix(btab, d, pred);
        int l = d.length;
        int max = -1;
        int max_i = -1;
        int max_j = -1;
        BitSet lcidxes = new BitSet(l);
        for (int i2 = 0; i2 < l; ++i2) {
            if ((atomFlags[i2] & 0x400000) == 0) continue;
            max_i = i2;
            int n = i2;
            atomFlags[n] = atomFlags[n] & 0xFFBFFFFF;
            lcidxes.set(i2);
        }
        int startCount = lcidxes.cardinality();
        if (startCount == 1) {
            for (i = 0; i < l; ++i) {
                if (d[max_i][i] <= max) continue;
                max = d[max_i][i];
                max_j = i;
            }
        } else if (startCount > 1) {
            i = lcidxes.nextSetBit(0);
            while (i >= 0) {
                j = lcidxes.nextSetBit(i);
                while (j >= 0) {
                    if (d[i][j] > max) {
                        max = d[i][j];
                        max_i = i;
                        max_j = j;
                    }
                    j = lcidxes.nextSetBit(j + 1);
                }
                i = lcidxes.nextSetBit(i + 1);
            }
        } else {
            for (i = 0; i < l; ++i) {
                for (j = i + 1; j < l; ++j) {
                    if (d[i][j] <= max) continue;
                    max = d[i][j];
                    max_i = i;
                    max_j = j;
                }
            }
        }
        int[] chain = new int[max + 1];
        int n = 0;
        while (pred[max_i][max_j] != -1 && max_i != max_j) {
            int n2 = max_j;
            atomFlags[n2] = atomFlags[n2] | 0x40000;
            chain[n++] = max_j;
            max_j = pred[max_i][max_j];
        }
        int n3 = max_i;
        atomFlags[n3] = atomFlags[n3] | 0x40000;
        chain[n++] = max_i;
        return chain;
    }

    static void setAtomTypes(MoleculeGraph m, int[] atomFlags, int[][] ctab, int[] fragID, int Debug2) {
        int fl;
        int l;
        int j;
        int[] ct;
        int i;
        if (Debug2 > 2) {
            System.err.println("Set Atom Types");
        }
        int ac = m.getAtomCount();
        int terminalArom = 4;
        int id = fragID[fragID.length - 1];
        int sid = 0;
        for (int i2 = m.getBondCount() - 1; i2 >= 0; --i2) {
            int ctinfo;
            MolBond b = m.getBond(i2);
            int t = b.getType();
            if (t != 2 && t != 3) continue;
            MolAtom a1 = b.getAtom1();
            MolAtom a2 = b.getAtom2();
            int idx1 = m.indexOf(a1);
            int idx2 = m.indexOf(a2);
            if ((atomFlags[idx1] & terminalArom) != 0 || (atomFlags[idx2] & terminalArom) != 0) continue;
            boolean inc = false;
            int n = idx1;
            atomFlags[n] = atomFlags[n] | 8;
            int n2 = idx2;
            atomFlags[n2] = atomFlags[n2] | 8;
            if (fragID[idx1] == 0 && (atomFlags[idx1] & 1) == 0) {
                fragID[idx1] = id;
                inc = true;
            }
            if (fragID[idx2] == 0 && (atomFlags[idx2] & 1) == 0) {
                fragID[idx2] = id;
                inc = true;
            }
            if (inc) {
                ++id;
            }
            if ((ctinfo = b.getFlags() & 0xC0) != 128 && ctinfo != 64) continue;
            int sID = ++sid << 16;
            int n3 = idx1;
            atomFlags[n3] = atomFlags[n3] | 0x400;
            int n4 = idx1;
            fragID[n4] = fragID[n4] | sID;
            int n5 = idx2;
            atomFlags[n5] = atomFlags[n5] | 0x400;
            int n6 = idx2;
            fragID[n6] = fragID[n6] | sID;
            if ((atomFlags[idx1] & 1) == 0 && (atomFlags[idx2] & 1) != 0) {
                int n7 = idx1;
                atomFlags[n7] = atomFlags[n7] | 0x1000;
                continue;
            }
            if ((atomFlags[idx2] & 1) != 0 || (atomFlags[idx1] & 1) == 0) continue;
            int n8 = idx2;
            atomFlags[n8] = atomFlags[n8] | 0x1000;
        }
        for (int k = ac - 1; k >= 0; --k) {
            int lc = ctab[k].length;
            if (lc <= 3 || (atomFlags[k] & 0x3F) != 0) continue;
            block2: for (i = 0; i < lc; ++i) {
                int idx = ctab[k][i];
                int[] an = ctab[idx];
                for (int j2 = an.length - 1; j2 >= 0; --j2) {
                    int lidx = an[j2];
                    if (lidx == k || (atomFlags[lidx] & 4) != 0) continue;
                    int n = lidx;
                    atomFlags[n] = atomFlags[n] | 0x10;
                    continue block2;
                }
            }
        }
        boolean inc = false;
        boolean[] lSet = new boolean[ac];
        while (Clean2D.getLongestChainSet(m, ctab, atomFlags, lSet) > 3) {
            inc = false;
            for (int k = ac - 1; k >= 0; --k) {
                if (!lSet[k]) continue;
                int n = k;
                atomFlags[n] = atomFlags[n] | 2;
                if (fragID[k] != 0 || (atomFlags[k] & 1) != 0) continue;
                fragID[k] = id;
                inc = true;
            }
            if (!inc) continue;
            ++id;
        }
        for (i = ac - 1; i >= 0; --i) {
            int f = atomFlags[i];
            if ((f & 0x3F) != 2) continue;
            ct = ctab[i];
            int chainAtomCount = 0;
            for (j = ct.length - 1; j >= 0 && chainAtomCount < 2; --j) {
                l = ct[j];
                fl = atomFlags[l];
                if ((fl & 2) == 0) continue;
                ++chainAtomCount;
            }
            if (chainAtomCount != 1) continue;
            int n = i;
            atomFlags[n] = atomFlags[n] | 4;
        }
        for (i = ac - 1; i >= 0; --i) {
            int f = atomFlags[i];
            inc = false;
            if ((f & 0x3F) != 0) continue;
            ct = ctab[i];
            int notAssignedLigandCount = 0;
            for (j = ct.length - 1; j >= 0; --j) {
                l = ct[j];
                fl = atomFlags[l];
                if (fl != 0) continue;
                ++notAssignedLigandCount;
            }
            if (notAssignedLigandCount == 0) {
                int n = i;
                atomFlags[n] = atomFlags[n] | 0x10;
                fragID[i] = id;
                inc = true;
            } else {
                int n = i;
                atomFlags[n] = atomFlags[n] | 0x20;
                if (fragID[i] == 0) {
                    fragID[i] = id;
                    inc = true;
                }
                for (j = ct.length - 1; j >= 0; --j) {
                    int lidx = ct[j];
                    if (atomFlags[lidx] != 0) continue;
                    int n9 = lidx;
                    atomFlags[n9] = atomFlags[n9] | 0x20;
                    if (fragID[lidx] != 0) continue;
                    fragID[lidx] = id;
                    inc = true;
                }
            }
            if (!inc) continue;
            ++id;
        }
        fragID[fragID.length - 1] = id;
    }

    static int getLongestChainSet(MoleculeGraph m, int[][] ctab, int[] atomFlags, boolean[] longestSet) {
        int ac = m.getAtomCount();
        int longestLength = 0;
        boolean[] lSet = new boolean[ac];
        for (int i = ac - 1; i >= 0; --i) {
            int f = atomFlags[i];
            if ((f & 0x3F) != 0) continue;
            int[] ct = ctab[i];
            int notAssignedlLigandCount = 0;
            for (int j = ct.length - 1; j >= 0; --j) {
                int l = ct[j];
                int fl = atomFlags[l];
                if ((fl & 0x3F) != 0) continue;
                ++notAssignedlLigandCount;
            }
            if (notAssignedlLigandCount != true) continue;
            boolean[] set = new boolean[ac];
            int[] d = new int[]{1, 1};
            int longestChainLength = Clean2D.getLongestChainSet(i, d, ctab, lSet, set, atomFlags);
            if (longestChainLength <= longestLength) continue;
            longestLength = longestChainLength;
            System.arraycopy(lSet, 0, longestSet, 0, ac);
        }
        return longestLength;
    }

    static int getLongestChainSet(int idx, int[] d, int[][] ctab, boolean[] lset, boolean[] set, int[] atomFlags) {
        set[idx] = true;
        if (d[0] > d[1]) {
            System.arraycopy(set, 0, lset, 0, set.length);
            d[1] = d[0];
        }
        for (int i = ctab[idx].length - 1; i >= 0; --i) {
            int lig = ctab[idx][i];
            if (set[lig] || atomFlags != null && (atomFlags[lig] & 0x3F) != 0) continue;
            d[0] = d[0] + 1;
            Clean2D.getLongestChainSet(lig, d, ctab, lset, set, atomFlags);
            d[0] = d[0] - 1;
        }
        set[idx] = false;
        return d[1];
    }

    static void setDegenerateFlags(MoleculeGraph m, int[][] ctab, int[] atomFlags) {
        int ac = m.getAtomCount();
        int[] grinv = new int[ac];
        m.getGrinv(grinv, 0);
        for (int i = ac - 1; i >= 0; --i) {
            int[] an = ctab[i];
            int l = an.length;
            int nonfixed = 0;
            if (l == 1) continue;
            boolean degenerate = false;
            int grinv1 = -1;
            int grinv2 = -1;
            int diffGrinv = 0;
            for (int j = 0; j < l; ++j) {
                int idx = an[j];
                if (m.getAtom(idx).getZ() == 2.0 || (atomFlags[idx] & 0x200) != 0) continue;
                int g = grinv[idx];
                ++nonfixed;
                if (grinv1 == -1) {
                    ++diffGrinv;
                    grinv1 = g;
                    continue;
                }
                if (grinv1 == g) continue;
                if (grinv2 == -1) {
                    ++diffGrinv;
                    grinv2 = g;
                    continue;
                }
                if (grinv2 == g) continue;
                ++diffGrinv;
                break;
            }
            if (nonfixed == 0 || diffGrinv < 3 && nonfixed - diffGrinv > 0) {
                degenerate = true;
            }
            if (!degenerate) continue;
            int n = i;
            atomFlags[n] = atomFlags[n] | 0x40;
        }
    }

    static final void fixLongestChainInternalAngleToTrans(int[] chain, MoleculeGraph m, int[] atomFlags, int[][] ctab, BondTable btab, double[][] intang, int Debug2) {
        int l = chain.length;
        for (int i = 1; i < l - 1; ++i) {
            int idx = chain[i];
            int from = chain[i - 1];
            int next = chain[i + 1];
            MolAtom c = m.getAtom(idx);
            if (c.getZ() != 0.0) continue;
            Clean2D.setIntAng(idx, from, next, m, intang, ctab, btab, null, atomFlags, -1, true, Debug2);
        }
        Clean2D.refineLongestChainInternalAngles(chain, ctab, btab, m, intang, atomFlags);
    }

    static final void refineLongestChainInternalAngles(int[] chain, int[][] ctab, BondTable btab, MoleculeGraph m, double[][] intang, int[] atomFlags) {
        double RATIO = 0.25;
        int l = chain.length;
        double[] c = new double[l * 2];
        Clean2D.fillCoordinates(chain, c, btab, intang, m);
        if (Clean2D.rectangleCheck(c, l, RATIO)) {
            return;
        }
        double[] c0 = new double[]{c[0], c[1]};
        double[] ce = new double[]{0.0, 0.0};
        int STEP = 5;
        int[] possChangeIdxes = new int[STEP];
        int n = 0;
        for (int i = 1; i < l; ++i) {
            int idx = chain[i];
            int f = atomFlags[idx];
            if ((f & 9) != 0 || Clean2D.getHypotheticalEdges(m.getAtom(idx)) != 3) continue;
            possChangeIdxes[n] = idx;
            if (++n != STEP && i != l - 1) continue;
            ce[0] = c[(i + 1) * 2 + 1];
            ce[1] = c[(i + 1) * 2];
            double distmax = Clean2D.dist2(c0, ce);
            for (int j = 0; j < n; ++j) {
                idx = possChangeIdxes[j];
                Clean2D.flipInternalAngle(idx, ctab[idx], btab, intang);
                Clean2D.fillCoordinates(chain, c, btab, intang, m);
                ce[0] = c[(i + 1) * 2 + 1];
                ce[1] = c[(i + 1) * 2];
                double d = Clean2D.dist2(c0, ce);
                if (distmax < d) {
                    distmax = d;
                    break;
                }
                Clean2D.flipInternalAngle(idx, ctab[idx], btab, intang);
                Clean2D.fillCoordinates(chain, c, btab, intang, m);
            }
            n = 0;
        }
    }

    static void fixChainInternalAngles(MoleculeGraph m, int[] atomFlags, int[][] ctab, BondTable btab, double[][] intang, int[] fragID, int Debug2) {
        if (Debug2 > 2) {
            System.err.println("Fix Chains");
        }
        for (int i = m.getAtomCount() - 1; i >= 0; --i) {
            int f = atomFlags[i];
            if ((f & 0x3F) != 6 || m.getAtom(i).getZ() != 0.0) continue;
            int fID = fragID[i] & 0xFFFF;
            int fromIdx = Clean2D.getOneAtomNotType(2, ctab[i], atomFlags);
            if (Debug2 > 5) {
                System.err.println("atom idx " + (i + 1) + " fix Chain frag " + fID);
            }
            Clean2D.setIntAng(i, fromIdx, -1, m, intang, ctab, btab, fragID, atomFlags, fID, true, Debug2);
        }
    }

    private static int getOneAtomNotType(int type, int[] an, int[] atomFlags) {
        int retIdx = -1;
        for (int i = an.length - 1; i >= 0; --i) {
            int idx = an[i];
            if ((atomFlags[idx] & 0x3F) == type) continue;
            return idx;
        }
        return retIdx;
    }

    static int getOneFixedAtom(int c, int[] an, MoleculeGraph m) {
        if (an.length < 1) {
            return -1;
        }
        for (int i = an.length - 1; i >= 0; --i) {
            int idx = an[i];
            if (m.getAtom(idx).getZ() != 2.0) continue;
            return idx;
        }
        return -1;
    }

    static void setStereoAtomIntAng(MoleculeGraph m, int[] atomFlags, int[][] ctab, BondTable btab, double[][] intang, int[] fragID, int[][] atomInRing, int Debug2) {
        int i;
        if (Debug2 > 2) {
            System.err.println("Fix Stereo Atoms");
        }
        int ringStereoBranch = 1161;
        int ac = m.getAtomCount();
        for (i = ac - 1; i >= 0; --i) {
            int f = atomFlags[i];
            int fID = fragID[i] & 0xFFFF;
            if ((f & 0x3F) == 8 && (f & 0x200) == 0 && (f & 0x1000) == 0 && m.getAtom(i).getZ() != 1.0) {
                MolAtom a;
                int t;
                if (Debug2 > 6) {
                    System.err.println(i + 1 + " EndChain STEREO");
                }
                int fromIdx = (t = (a = m.getAtom(i)).getBond(0).getType()) == 2 || t == 3 ? ctab[i][1] : ctab[i][0];
                boolean flip = true;
                Clean2D.setIntAng(i, fromIdx, -1, m, intang, ctab, btab, fragID, atomFlags, fID, flip, Debug2);
                continue;
            }
            if ((f & 0x1000) != 0 && (f & 0x20000) == 0) {
                if (Debug2 > 6) {
                    System.err.println(i + 1 + " LONEDBSTEREO ");
                }
                int fromIdx = -1;
                MolAtom a = m.getAtom(i);
                for (int j = 0; j < a.getBondCount(); ++j) {
                    int t = a.getBond(j).getType();
                    if (t != 2 && t != 3) continue;
                    fromIdx = ctab[i][j];
                }
                if (fromIdx < 0) continue;
                boolean flip = false;
                Clean2D.setIntAng(i, fromIdx, -1, m, intang, ctab, btab, fragID, atomFlags, fID, flip, Debug2);
                f |= 0x20000;
                int n = fromIdx;
                atomFlags[n] = atomFlags[n] | 0x20000;
                continue;
            }
            if ((f & ringStereoBranch) != ringStereoBranch || (f & 0x20000) != 0) continue;
            int fromIdx = Clean2D.getIdxWithFlag(ringStereoBranch, atomFlags, ctab[i]);
            int b_idx = 0;
            if (fromIdx == -1 || atomInRing[i][0] == atomInRing[fromIdx][0] || m.getBond(b_idx = btab.getBondIndex(i, fromIdx)).getType() != 2) continue;
            if (Debug2 > 6) {
                System.err.println(i + 1 + "-" + (fromIdx + 1) + " Ring Ring STEREO");
            }
            if (!Clean2D.intAngCorrespondToStereo(b_idx, ctab, btab, intang, m)) {
                MolAtom a1 = m.getAtom(i);
                DPoint3 p1 = a1.getLocation();
                int i0 = ctab[i][0];
                i0 = i0 == fromIdx ? ctab[i][1] : i0;
                DPoint3 p2 = Clean2D.calculateCoordFromIntang(fromIdx, i, i0, intang, btab, m);
                Clean2D.flipCoordinatesWithId(p1, p2, fID, fragID, m);
                boolean[] done = new boolean[ac];
                done[fromIdx] = true;
                for (int j = 0; j < ac; ++j) {
                    if ((fragID[j] & 0xFFFF) != fID) continue;
                    Clean2D.flipInternalAngle(j, ctab[j], btab, intang);
                    Clean2D.recursiveIntangChange(j, intang, ctab, btab, atomFlags, done);
                }
            }
            f |= 0x20000;
            int n = fromIdx;
            atomFlags[n] = atomFlags[n] | 0x20000;
        }
        i = ac - 1;
        while (i >= 0) {
            int n = i--;
            atomFlags[n] = atomFlags[n] & 0xFFFDFFFF;
        }
    }

    static boolean intAngCorrespondToStereo(int b_idx, int[][] ctab, BondTable btab, double[][] intang, MoleculeGraph m) {
        MolBond b = m.getBond(b_idx);
        int i1 = m.indexOf(b.getCTAtom1());
        int i2 = m.indexOf(b.getAtom1());
        int i3 = m.indexOf(b.getAtom2());
        int i4 = m.indexOf(b.getCTAtom4());
        int b1 = btab.getBondIndex(i1, i2);
        int b2 = btab.getBondIndex(i2, i3);
        int b3 = btab.getBondIndex(i3, i4);
        int stereo = b.getFlags() & 0xC0;
        boolean flagCis = stereo == 128;
        double fi1 = intang[b1][b2];
        fi1 = Clean2D.convertToPos(fi1);
        double fi2 = intang[b2][b3];
        fi2 = Clean2D.convertToPos(fi2);
        boolean fi1_p = fi1 < Math.PI;
        boolean fi2_p = fi2 < Math.PI;
        boolean intAngTrans = fi1_p ^ fi2_p;
        return flagCis ^ intAngTrans;
    }

    static DPoint3 calculateCoordFromIntang(int i2, int i1, int i0, double[][] intang, BondTable btab, MoleculeGraph m) {
        int b0 = btab.getBondIndex(i0, i1);
        int b1 = btab.getBondIndex(i1, i2);
        double phi = intang[b0][b1];
        DPoint3 p0 = m.getAtom(i0).getLocation();
        DPoint3 p1 = m.getAtom(i1).getLocation();
        DPoint3 p3 = (DPoint3)p0.clone();
        CTransform3D T = new CTransform3D();
        T.setRotationCenter(p1);
        T.setRotation(0.0, 0.0, 1.0, phi);
        T.transform(p3);
        return p3;
    }

    static boolean hasOneStereoLigand(int[] atomFlags, int[] ct) {
        int n = 0;
        for (int i = ct.length - 1; i >= 0 && n < 2; --i) {
            int idx = ct[i];
            int f = atomFlags[idx];
            if ((f & 0x3F) != 8) continue;
            ++n;
        }
        return n < 2;
    }

    static void setIntAng(int cIdx, int prevIdx, int next, MoleculeGraph m, double[][] intang, int[][] ctab, BondTable btab, int[] fragID, int[] atomFlags, int fID, boolean flip, int Debug2) {
        int n;
        int bPrevIdx;
        int nextIdx;
        int[] an = ctab[cIdx];
        int bondCount = an.length;
        MolAtom c = m.getAtom(cIdx);
        int hedges = Clean2D.getHypotheticalEdges(c);
        int refNextInFrag = -1;
        int oppIdx = next;
        int startRef = -1;
        if (next >= 0) {
            for (int i = 0; i < bondCount; ++i) {
                nextIdx = an[i];
                if (nextIdx != oppIdx) continue;
                startRef = i;
                break;
            }
            if (startRef < 0) {
                System.err.println("Next index is badly specified in internal angle calculation, recalculating ...");
                next = -1;
            }
        }
        if (next < 0) {
            int ref_other = -1;
            for (int i = 0; i < bondCount; ++i) {
                boolean notfixed;
                nextIdx = an[i];
                int id = fragID != null ? fragID[nextIdx] & 0xFFFF : -1;
                boolean bl = notfixed = nextIdx != prevIdx && m.getAtom(nextIdx).getZ() == 0.0;
                if (id == fID && nextIdx != prevIdx) {
                    refNextInFrag = i;
                    continue;
                }
                if ((atomFlags[nextIdx] & 4) != 0 || !notfixed) continue;
                ref_other = i;
            }
            startRef = refNextInFrag >= 0 ? refNextInFrag : -1;
            int n2 = startRef = startRef < 0 ? ref_other : refNextInFrag;
            startRef = startRef < 0 ? (an[0] == prevIdx ? 1 : 0) : startRef;
            oppIdx = an[startRef % bondCount];
        }
        if (c.getZ() > 0.0 && refNextInFrag >= 0) {
            boolean newFlip = hedges == 3 ? !flip : flip;
            Clean2D.setIntAng(oppIdx, cIdx, -1, m, intang, ctab, btab, fragID, atomFlags, fID, newFlip, Debug2);
            return;
        }
        if (prevIdx < 0) {
            prevIdx = an[0];
            bPrevIdx = btab.getBondIndex(cIdx, prevIdx);
        } else {
            bPrevIdx = btab.getBondIndex(cIdx, prevIdx);
        }
        MolBond b_prev = m.getBond(bPrevIdx);
        double fi = Math.PI * 2 / (double)hedges;
        int stereo = b_prev.getFlags() & 0xC0;
        if (stereo != 0 && stereo != 192 && ctab[prevIdx].length > 1) {
            int i0 = ctab[prevIdx][0] == cIdx ? ctab[prevIdx][1] : ctab[prevIdx][0];
            stereo = b_prev.transformCT(m.getAtom(i0), m.getAtom(oppIdx), stereo);
            double fi_p = intang[btab.getBondIndex(prevIdx, i0)][bPrevIdx];
            fi = Clean2D.convertToPos(fi_p) > Math.PI ^ stereo == 128 ? fi : -fi;
        } else if (hedges != 4 && (atomFlags[cIdx] & 0x40000) != 0 && (atomFlags[prevIdx] & 0x40000) != 0 && (atomFlags[oppIdx] & 0x40000) != 0) {
            double fi_p = Clean2D.getPreviousRelevantIntang(prevIdx, cIdx, ctab, btab, atomFlags, intang, m);
            if (fi_p != 0.0) {
                fi = Clean2D.convertToPos(fi_p) < Math.PI ? -fi : fi;
            }
        } else {
            double d = fi = flip ? -fi : fi;
        }
        if (Debug2 > 6) {
            System.err.println("   SetIntAng    prev " + (prevIdx + 1) + " center " + (cIdx + 1) + "  fragId " + fID + " h_edges " + hedges + "\n                CIS " + (stereo == 128) + " flip " + flip + " refNextInFrag " + (refNextInFrag >= 0 ? an[refNextInFrag] + 1 : -1) + " oppIdx " + (oppIdx + 1) + " fi " + fi);
        }
        if (oppIdx >= 0) {
            int bNextIdx = btab.getBondIndex(cIdx, oppIdx);
            intang[bPrevIdx][bNextIdx] = (double)(hedges / 2) * fi;
            intang[bNextIdx][bPrevIdx] = (double)(-hedges / 2) * fi;
            if (Debug2 > 6) {
                System.err.println("   IntAng " + (prevIdx + 1) + "-" + (cIdx + 1) + "-" + (oppIdx + 1) + " " + (double)(hedges / 2) * fi);
            }
            n = 1;
            for (int i = 1; i < bondCount; ++i) {
                nextIdx = an[(i + startRef) % bondCount];
                if (nextIdx == prevIdx) continue;
                if (nextIdx == oppIdx) {
                    System.err.println("   ERROR opposit should not be here ");
                }
                if (n == hedges / 2) {
                    ++n;
                }
                bNextIdx = btab.getBondIndex(cIdx, nextIdx);
                intang[bPrevIdx][bNextIdx] = (double)n * fi;
                intang[bNextIdx][bPrevIdx] = (double)(-n) * fi;
                if (Debug2 > 6) {
                    System.err.println("   IntAng " + (prevIdx + 1) + "-" + (cIdx + 1) + "-" + (nextIdx + 1) + " " + (double)n * fi);
                }
                ++n;
            }
        } else {
            n = 1;
            for (int i = 0; i < bondCount; ++i) {
                nextIdx = an[i];
                if (nextIdx == prevIdx) continue;
                int bNextIdx = btab.getBondIndex(cIdx, nextIdx);
                intang[bPrevIdx][bNextIdx] = (double)n * fi;
                intang[bNextIdx][bPrevIdx] = (double)(-n) * fi;
                if (Debug2 > 6) {
                    System.err.println("   IntAng " + (prevIdx + 1) + "-" + (cIdx + 1) + "-" + (nextIdx + 1) + " (" + bPrevIdx + ":" + bNextIdx + ") " + (double)n * fi);
                }
                ++n;
            }
        }
        Clean2D.resolveIntAngFromReference(prevIdx, cIdx, btab, an, intang);
        if ((atomFlags[cIdx] & 0x200) == 0) {
            c.setZ(1.0);
        }
        if (refNextInFrag >= 0) {
            boolean newFlip = hedges == 3 ? !flip : flip;
            Clean2D.setIntAng(an[refNextInFrag], cIdx, -1, m, intang, ctab, btab, fragID, atomFlags, fID, newFlip, Debug2);
        }
    }

    static final double getPreviousRelevantIntang(int idx, int from, int[][] ctab, BondTable btab, int[] atomFlags, double[][] intang, MoleculeGraph m) {
        int[] c = Clean2D.getCenterWith3Edges(idx, from, ctab, m, atomFlags);
        if (c == null) {
            return 0.0;
        }
        int a1 = c[0];
        int a0 = c[1];
        int a2 = -1;
        int[] an = ctab[a1];
        for (int i = an.length - 1; i >= 0; --i) {
            int l = an[i];
            if (l == a0 || (atomFlags[l] & 0x40000) == 0) continue;
            a2 = l;
        }
        if (a2 < 0) {
            return 0.0;
        }
        return intang[btab.getBondIndex(a2, a1)][btab.getBondIndex(a1, a0)];
    }

    static final int[] getCenterWith3Edges(int idx, int from, int[][] ctab, MoleculeGraph m, int[] atomFlags) {
        int hedges = Clean2D.getHypotheticalEdges(m.getAtom(idx));
        if (hedges == 3) {
            return new int[]{idx, from};
        }
        int[] an = ctab[idx];
        for (int i = an.length - 1; i >= 0; --i) {
            int l = an[i];
            if (l == from || (atomFlags[l] & 0x40000) == 0) continue;
            return Clean2D.getCenterWith3Edges(l, idx, ctab, m, atomFlags);
        }
        return null;
    }

    static void resolveIntAngFromReference(int refIdx, int cIdx, BondTable btab, int[] an, double[][] intang) {
        int anl = an.length;
        int refEIdx = btab.getBondIndex(refIdx, cIdx);
        for (int i = 0; i < anl; ++i) {
            if (an[i] == refIdx) continue;
            int nb1 = btab.getBondIndex(an[i], cIdx);
            double ia1 = intang[refEIdx][nb1];
            for (int j = i + 1; j < anl; ++j) {
                double fi;
                if (an[j] == refIdx) continue;
                int nb2 = btab.getBondIndex(an[j], cIdx);
                double ia2 = intang[refEIdx][nb2];
                intang[nb2][nb1] = fi = ia1 - ia2;
                intang[nb1][nb2] = -fi;
            }
        }
    }

    static void fixIntAngForRestAtoms(MoleculeGraph m, int[] atomFlags, int[][] ctab, BondTable btab, double[][] intang, int[] fragID, int Debug2) {
        int fromIdx;
        int i;
        int ac = m.getAtomCount();
        if (Debug2 > 2) {
            System.err.println("Fix Rest Atoms");
        }
        for (i = ac - 1; i >= 0; --i) {
            if ((atomFlags[i] & 0x20) == 0 || m.getAtom(i).getZ() != 0.0) continue;
            int fID = fragID[i] & 0xFFFF;
            fromIdx = Clean2D.getOneAtomNotType(32, ctab[i], atomFlags);
            if (fromIdx < 0) continue;
            Clean2D.setIntAng(i, fromIdx, -1, m, intang, ctab, btab, fragID, atomFlags, fID, true, Debug2);
            if (Debug2 <= 4) continue;
            System.err.println("Fix SMALLFRAG " + (i + 1) + " from atom " + (fromIdx + 1));
        }
        for (i = ac - 1; i >= 0; --i) {
            MolAtom a = m.getAtom(i);
            if ((atomFlags[i] & 0x10) == 0 || a.getZ() != 0.0) continue;
            fromIdx = -1;
            int[] an = ctab[i];
            for (int j = an.length - 1; j >= 0; --j) {
                int l = an[j];
                if ((atomFlags[l] & 4) != 0) continue;
                fromIdx = l;
            }
            boolean flip = true;
            if (fromIdx >= 0) {
                int i0 = ctab[fromIdx][0] == i ? ctab[fromIdx][1] : ctab[fromIdx][0];
                double fi = intang[btab.getBondIndex(fromIdx, i)][btab.getBondIndex(fromIdx, i0)];
                boolean bl = flip = Clean2D.convertToPos(fi) > Math.PI;
            }
            if (Debug2 > 4) {
                System.err.println("Fix LONEATOM " + (i + 1) + " from atom " + (fromIdx + 1));
            }
            Clean2D.setIntAng(i, fromIdx, -1, m, intang, ctab, btab, fragID, atomFlags, -1, flip, Debug2);
        }
    }

    boolean generateCoordinates(MoleculeGraph m, int[] atomFlags, int[][] ctab, BondTable btab, double[][] intang, int[] fragID, boolean partialClean, int levelAheadLimit, int stepLimit, PartialOptimization opt, long timeStart, long timeLimit, long timeStart_structure, long timeLimit_structure, double coll_dist_sq, int[][] d, int[][] pred, int Debug2) {
        if (stepLimit == 0) {
            Clean2D.fixInternalAngles(m, intang, atomFlags, fragID, ctab, btab, partialClean);
            return true;
        }
        int ac = m.getAtomCount();
        double[] savedRingCoord = new double[ac * 2];
        Clean2D.saveCoordinates(m, savedRingCoord);
        boolean initStartSystem = true;
        if (!partialClean) {
            Clean2D.fixStartSystem(m, atomFlags, fragID, intang, ctab, btab, Debug2);
        } else {
            Clean2D.fixFixedSystems(m, atomFlags, fragID, ctab);
        }
        int bc = m.getBondCount();
        double[][] intangc = new double[bc][bc];
        if (Debug2 > 3) {
            System.err.println("    Saving the molecule to save.sdf ");
            Clean2D.saveMoleculeToFile(m, fragID, this.out, "Initial system");
        }
        IntVector startIndexes = new IntVector();
        Clean2D.locateNonfixedLigand(startIndexes, stepLimit, m, ctab, atomFlags, fragID, partialClean);
        if (Debug2 > 4) {
            System.err.println(" startIndexes: ");
            for (int i = 0; i < startIndexes.size(); ++i) {
                System.err.println("     fixed: " + (startIndexes.get(i) + 1));
            }
        }
        int success = 1;
        int[] bt = new int[7];
        double[][] bestArrangement = new double[][]{new double[1], null};
        double[][] bestIA = new double[bc][bc];
        while (success != 0) {
            Clean2D.copy(intang, intangc);
            if (Debug2 > 1) {
                System.err.println("GenerateCoordinatesBT ");
            }
            bt[0] = 0;
            bt[1] = 0;
            bt[2] = levelAheadLimit;
            bt[3] = stepLimit;
            bt[4] = 0;
            bt[5] = 1;
            bt[6] = 0;
            BitSet usedAtoms = new BitSet(ac);
            success = Clean2D.generateCoordinatesBackTrack(startIndexes, 0, m, atomFlags, ctab, btab, intangc, fragID, partialClean, Debug2, this.out, bt, usedAtoms, coll_dist_sq);
            if (Debug2 > 2) {
                System.err.println(success == 0 ? "success" : (success == 4 ? "step limit" : (success == 5 ? "bt limit" : (success == 1 ? "collision" : (success == 3 ? "failure" : " valami mas")))));
            }
            if (success == 3) {
                return false;
            }
            if (success == 4 || success == 1) {
                if (Clean2D.timeLimit(timeStart, timeLimit, timeStart_structure, timeLimit_structure)) {
                    return false;
                }
                if (initStartSystem) {
                    if (Debug2 > 2) {
                        System.err.println("Restore all coordinates");
                    }
                    Clean2D.restoreRingCoordinates(m, atomFlags, savedRingCoord, true);
                    initStartSystem = false;
                } else {
                    if (Debug2 > 2) {
                        System.err.println("Restore unfixed ring coordinates");
                    }
                    Clean2D.restoreRingCoordinates(m, atomFlags, savedRingCoord, false);
                }
                if (Debug2 > 1) {
                    System.err.println("POSTPROCESS until level " + bt[4] + " collision found at level " + bt[1]);
                    if (Debug2 > 3) {
                        Clean2D.saveMoleculeToFile(m, fragID, this.out, "PostProcess start");
                    }
                }
                bestArrangement[0][0] = Double.MAX_VALUE;
                bt[0] = 0;
                bt[2] = bt[4];
                bt[5] = 1;
                bt[1] = 0;
                bt[4] = 0;
                Clean2D.copy(intang, intangc);
                Clean2D.getBestCoordinates(startIndexes, 0, m, atomFlags, ctab, btab, intangc, fragID, bt, bestArrangement, bestIA, partialClean, Debug2, this.out);
                double[] c = bestArrangement[1];
                int fixedC = 0;
                for (int i = 0; i < ac && c != null; ++i) {
                    int n = i * 3;
                    MolAtom a = m.getAtom(i);
                    double z_coord = c[n + 2];
                    if (z_coord == 2.0 || z_coord == 3.0) {
                        a.setX(c[n]);
                        a.setY(c[n + 1]);
                        a.setZ(z_coord == 3.0 ? 0.0 : 2.0);
                    }
                    if (z_coord != 2.0) continue;
                    ++fixedC;
                }
                if (Debug2 > 3) {
                    System.err.println("mol saved: BestCoord");
                    Clean2D.saveMoleculeToFile(m, fragID, this.out, "BestCoord");
                }
                Clean2D.copy(bestIA, intang);
                if (!Clean2D.postProcess(m, atomFlags, fragID, d, pred, ctab, btab, intang, fixedC, opt, Debug2, this.out)) {
                    return false;
                }
                Clean2D.generateInternalAngleForFixedLigands(m, ctab, btab, intang);
                bt[2] = levelAheadLimit;
                Clean2D.copy(intang, intangc);
                Clean2D.saveCoordinates(m, savedRingCoord);
                if (Debug2 > 3) {
                    System.err.println("mol saved: after PostProcess ");
                    Clean2D.saveMoleculeToFile(m, fragID, this.out, "after PostProcess");
                }
            }
            Clean2D.copy(intangc, intang);
            startIndexes.removeAllElements();
            Clean2D.locateNonfixedLigand(startIndexes, stepLimit, m, ctab, atomFlags, fragID, partialClean);
        }
        if (Debug2 > 3) {
            try {
                this.out.close();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        return true;
    }

    static void fixInternalAngles(MoleculeGraph m, double[][] intang, int[] atomFlags, int[] fragID, int[][] ctab, BondTable btab, boolean partialClean) {
        if (!partialClean) {
            Clean2D.fixStartSystem(m, atomFlags, fragID, intang, ctab, btab, 0);
        } else {
            Clean2D.fixFixedSystems(m, atomFlags, fragID, ctab);
        }
        IntVector startIndexes = new IntVector();
        int l = 0;
        do {
            Clean2D.locateNonfixedLigand(startIndexes, 10000, m, ctab, atomFlags, fragID, partialClean);
            l = startIndexes.size();
            for (int i = 0; i < l; ++i) {
                int fixed = startIndexes.get(i);
                int fromIdx = Clean2D.getOneFixedAtom(fixed, ctab[fixed], m);
                Clean2D.setCoordsFromIntangRecursively(fixed, fromIdx, -1, ctab, btab, intang, fragID, atomFlags, m, null, false, 0);
            }
            startIndexes.removeAllElements();
        } while (l > 0);
    }

    static void restoreRingCoordinates(MoleculeGraph m, int[] atomFlags, double[] savedRingCoord, boolean all) {
        int ac = m.getAtomCount();
        for (int i = 0; i < ac; ++i) {
            int n = i * 2;
            MolAtom a = m.getAtom(i);
            int f = atomFlags[i];
            if ((f & 1) == 0 || !all && ((f & 0x800) != 0 || a.getZ() == 2.0)) continue;
            a.setX(savedRingCoord[n]);
            a.setY(savedRingCoord[n + 1]);
        }
    }

    static void getBestCoordinates(IntVector startIndexes, int p, MoleculeGraph m, int[] atomFlags, int[][] ctab, BondTable btab, double[][] intang, int[] fragID, int[] bt, double[][] bestArr, double[][] bestIA, boolean partialClean, int Debug2, FileOutputStream out) {
        int[] an;
        int ac = m.getAtomCount();
        int level = bt[0];
        int btLimit = bt[2];
        int stepLimit = bt[3];
        int idx = startIndexes.get(p);
        int fromIdx = Clean2D.getOneFixedAtom(idx, an = ctab[idx], m);
        if (fromIdx < 0) {
            System.err.println(" no fixed atom found for " + (idx + 1));
        }
        int poss = Clean2D.getNumberOfPossibilities(idx, atomFlags, fragID, an, m, partialClean);
        int possibilities = poss + 1;
        int l = startIndexes.size();
        BitSet fixedLigands = null;
        BitSet fixedBonds = null;
        for (int i = 0; i < possibilities; ++i) {
            if (i > 0) {
                bt[5] = bt[5] + 1;
            }
            if (fixedLigands == null) {
                fixedLigands = new BitSet(ac);
                fixedBonds = new BitSet(m.getBondCount());
                Clean2D.setCoordinatesForLigands(idx, fromIdx, fixedLigands, fixedBonds, fragID, ctab, btab, intang, atomFlags, m, Debug2);
            } else {
                Clean2D.setCoordinatesForLigands(idx, fromIdx, null, null, fragID, ctab, btab, intang, atomFlags, m, Debug2);
            }
            if (p == l - 1) {
                if (level == btLimit) {
                    Clean2D.storeCoordinates(m, intang, bestArr, bestIA, ctab, atomFlags, fragID, Debug2, out, bt[5]);
                } else {
                    IntVector newStartIndexes = new IntVector();
                    Clean2D.locateNonfixedLigand(newStartIndexes, stepLimit, m, ctab, atomFlags, fragID, partialClean);
                    if (newStartIndexes.size() > 0) {
                        bt[0] = bt[0] + 1;
                        Clean2D.getBestCoordinates(newStartIndexes, 0, m, atomFlags, ctab, btab, intang, fragID, bt, bestArr, bestIA, partialClean, Debug2, out);
                        bt[0] = bt[0] - 1;
                    } else {
                        Clean2D.storeCoordinates(m, intang, bestArr, bestIA, ctab, atomFlags, fragID, Debug2, out, bt[5]);
                    }
                }
            } else {
                Clean2D.getBestCoordinates(startIndexes, p + 1, m, atomFlags, ctab, btab, intang, fragID, bt, bestArr, bestIA, partialClean, Debug2, out);
            }
            Clean2D.setFragmentTo(1.0, fixedLigands, m);
            if (i >= possibilities - 1) continue;
            Clean2D.changeInternalAngleAtFixed(idx, atomFlags, fragID, intang, ctab, btab, m, Debug2);
        }
    }

    static void storeCoordinates(MoleculeGraph m, double[][] intang, double[][] bestArr, double[][] bestIA, int[][] ctab, int[] atomFlags, int[] fragID, int Debug2, FileOutputStream out, int step) {
        double sum = Clean2D.getDistanceSqSumms(m, atomFlags);
        int ac = m.getAtomCount();
        BitSet idSet = new BitSet(ac);
        for (int i = 0; i < ac; ++i) {
            if (m.getAtom(i).getZ() != 2.0) continue;
            int id = fragID[i] & 0xFFFF;
            if (idSet.get(i) || (atomFlags[i] & 1) == 0 || !Clean2D.hasNonfixedRingAtom(i, id, ctab[i], atomFlags, fragID, m)) continue;
            for (int j = 0; j < ac; ++j) {
                if ((fragID[j] & 0xFFFF) != id) continue;
                idSet.set(j);
            }
        }
        if (sum < bestArr[0][0]) {
            if (Debug2 > 4) {
                System.err.println("mol saved: possible_bestc_" + step);
                Clean2D.saveMoleculeToFile(m, fragID, out, "possible_bestc_" + step);
            }
            bestArr[0][0] = sum;
            double[] coords = bestArr[1];
            if (coords == null || coords.length != 3 * ac) {
                coords = new double[3 * ac];
            }
            for (int k = 0; k < ac; ++k) {
                MolAtom a = m.getAtom(k);
                int n = k * 3;
                coords[n] = a.getX();
                coords[n + 1] = a.getY();
                coords[n + 2] = a.getZ() != 2.0 && idSet.get(k) ? 3.0 : a.getZ();
            }
            bestArr[1] = coords;
            Clean2D.copy(intang, bestIA);
        }
    }

    static int generateCoordinatesBackTrack(IntVector startIndexes, int p, MoleculeGraph m, int[] atomFlags, int[][] ctab, BondTable btab, double[][] intang, int[] fragID, boolean partialClean, int Debug2, FileOutputStream out, int[] bt, BitSet usedAtoms, double coll_dist_sq) {
        int[] an;
        if (startIndexes.size() == 0) {
            return 0;
        }
        int level = bt[0];
        int levelAheadLimit = bt[2];
        int stepLimit = bt[3];
        int sumPoss = bt[5];
        int fixedAtom = startIndexes.get(p);
        int fromIdx = Clean2D.getOneFixedAtom(fixedAtom, an = ctab[fixedAtom], m);
        if (fromIdx < 0) {
            if (Error == 1) {
                System.err.println(" No from Idx found at level " + level + " fixed " + (fixedAtom + 1));
            }
            return 3;
        }
        int poss = Clean2D.getNumberOfPossibilities(fixedAtom, atomFlags, fragID, an, m, partialClean);
        int possibilities = poss + 1;
        sumPoss = Clean2D.addToSumm(poss, fixedAtom, usedAtoms, sumPoss);
        if (usedAtoms != null) {
            usedAtoms.set(fixedAtom);
        }
        if (Debug2 > 1) {
            System.err.println("   At level " + level + " the number of possible state: " + sumPoss + "  actual Step " + bt[6]);
        }
        if (sumPoss < bt[3] && level - 1 > bt[4]) {
            bt[4] = level > 0 ? level - 1 : 0;
        }
        bt[5] = sumPoss;
        if (Debug2 > 2) {
            System.err.println(" startindexes at level " + level + " : " + Clean2D.toString(startIndexes));
            System.err.println("   Start branch for " + (fixedAtom + 1) + " fixed " + (fromIdx + 1));
        }
        BitSet fixedLigands = new BitSet(ctab.length);
        BitSet fixedBonds = new BitSet(m.getBondCount());
        Clean2D.setCoordinatesForLigands(fixedAtom, fromIdx, fixedLigands, fixedBonds, fragID, ctab, btab, intang, atomFlags, m, Debug2);
        if (Debug2 > 4) {
            String s = "fixed " + (fixedAtom + 1) + " level " + level + " poss " + possibilities;
            System.err.println("    Saving the molecule to save.sdf: " + s);
            Clean2D.saveMoleculeToFile(m, fragID, out, s);
        }
        int success = 0;
        boolean coincidence = false;
        do {
            if (Debug2 > 2) {
                System.err.println("    Coordinate set, around atom  " + (fixedAtom + 1) + " level " + level + " poss " + possibilities);
            }
            while ((success != 0 || (coincidence = Clean2D.checkCoincidence(fixedLigands, fixedBonds, fragID, m, coll_dist_sq))) && possibilities > 1) {
                if (Debug2 > 3) {
                    System.err.println("       Coincidence  fixedIdx " + (fixedAtom + 1) + " possibilities " + possibilities);
                }
                Clean2D.changeInternalAngleAtFixed(fixedAtom, atomFlags, fragID, intang, ctab, btab, fixedLigands, m, Debug2);
                --possibilities;
                Clean2D.setCoordinatesForLigands(fixedAtom, fromIdx, null, null, fragID, ctab, btab, intang, atomFlags, m, Debug2);
                if (Debug2 > 4) {
                    String s = "fixed " + (fixedAtom + 1) + " level " + level + " poss " + possibilities;
                    System.err.println("    Saving the molecule to save.sdf: " + s);
                    Clean2D.saveMoleculeToFile(m, fragID, out, s);
                }
                success = 0;
            }
            if ((coincidence || success != 0) && possibilities <= 1) {
                if (Debug2 > 3) {
                    System.err.println("  not successfull arrangement starting from atom " + (fixedAtom + 1) + "  fromidx " + (fromIdx + 1));
                }
                Clean2D.setFragmentTo(1.0, fixedLigands, m);
                bt[1] = bt[1] < level ? level : bt[1];
                return 1;
            }
            if (p + 1 < startIndexes.size()) {
                success = Clean2D.generateCoordinatesBackTrack(startIndexes, p + 1, m, atomFlags, ctab, btab, intang, fragID, partialClean, Debug2, out, bt, usedAtoms, coll_dist_sq);
            } else {
                if (bt[0] + 1 >= levelAheadLimit) {
                    return 5;
                }
                if (Debug2 > 4) {
                    System.err.println("  new Startindexes ");
                    Clean2D.saveMoleculeToFile(m, fragID, out, "new startidxes " + (bt[0] + 1));
                }
                IntVector newStartIndexes = new IntVector();
                Clean2D.locateNonfixedLigand(newStartIndexes, stepLimit, m, ctab, atomFlags, fragID, partialClean);
                if (newStartIndexes.size() > 0) {
                    bt[0] = bt[0] + 1;
                    success = Clean2D.generateCoordinatesBackTrack(newStartIndexes, 0, m, atomFlags, ctab, btab, intang, fragID, partialClean, Debug2, out, bt, usedAtoms, coll_dist_sq);
                    bt[0] = bt[0] - 1;
                }
            }
            if (success == 4 || success == 1 && bt[5] > bt[3]) {
                Clean2D.setFragmentTo(1.0, fixedLigands, m);
                return 4;
            }
            if (success == 5) {
                return 5;
            }
            if (success != 3) continue;
            return 3;
        } while (success != 0);
        return 0;
    }

    static void setBranchesToIntAngSet(int p, int end_p, IntVector startIndexes, int[] fragID, int[] atomFlags, MoleculeGraph m, int Debug2, FileOutputStream out) {
        for (int i = p; i < end_p; i += 2) {
            int fixed = startIndexes.get(i);
            int nonfixed = startIndexes.get(i + 1);
            int id = fragID[nonfixed] & 0xFFFF;
            Clean2D.recursiveIntangSet(id, m, fragID, atomFlags);
            if ((atomFlags[fixed] & 0x200) == 0) {
                m.getAtom(fixed).setZ(2.0);
            }
            if (Debug2 <= 4 || out == null) continue;
            System.err.println(" removed fix around atom " + (fixed + 1) + " id " + id);
            System.err.println("    Saving the molecule to save.sdf ");
            Clean2D.saveMoleculeToFile(m, fragID, out, null);
        }
    }

    private static int getNumberOfPossibilities(int idx, int[] atomFlags, int[] fragID, int[] an, MoleculeGraph m, boolean partialClean) {
        int poss;
        int f = atomFlags[idx];
        MolAtom a = m.getAtom(idx);
        int n = poss = (f & 0x40) != 0 ? 0 : Clean2D.getHypotheticalEdges(a) - Clean2D.fixedLigandCount(a) - 1;
        if (poss > 0) {
            Clean2D.setStereoDB(idx, an, atomFlags, fragID);
            if ((f & 8) != 0 && (f & 0x100000) != 0) {
                poss = 0;
            }
        }
        return poss < 0 ? 0 : poss;
    }

    static void setStereoDB(int idx, int[] an, int[] atomFlags, int[] fragID) {
        int f = atomFlags[idx];
        if ((f & 0x400) != 0 && (f & 0x80000) == 0 && (f & 0x100000) == 0) {
            int n = idx;
            atomFlags[n] = atomFlags[n] | 0x80000;
            int stereoID = fragID[idx] >> 16;
            for (int i = an.length - 1; i >= 0; --i) {
                int l = an[i];
                int stereoID_ligand = fragID[l] >> 16;
                if (stereoID != stereoID_ligand) continue;
                int n2 = l;
                atomFlags[n2] = atomFlags[n2] | 0x100000;
                break;
            }
        }
    }

    static int addToSumm(int p, int idx, BitSet usedAtoms, int sumPoss) {
        if (idx < 0 || !usedAtoms.get(idx)) {
            sumPoss = sumPoss < Integer.MAX_VALUE / (p + 1) ? (sumPoss *= p < 0 ? 1 : p + 1) : Integer.MAX_VALUE;
        }
        return sumPoss;
    }

    static int getLastLigand(int s, int fixed, IntVector startIndexes) {
        int l = startIndexes.size();
        for (int i = s; i < l; ++i) {
            if (fixed == startIndexes.get(i)) {
                ++i;
                continue;
            }
            return i;
        }
        return l;
    }

    static void fixStartSystem(MoleculeGraph m, int[] atomFlags, int[] fragID, double[][] intang, int[][] ctab, BondTable btab, int Debug2) {
        int id;
        int organoMetRingID = 0;
        int largestOrganoMetRingAtC = 0;
        int largestRingId = 0;
        int largestRingAtCount = 0;
        int largestId = 0;
        int largestAtCount = 0;
        int[] IDCount = new int[fragID[fragID.length - 1]];
        for (int i = atomFlags.length - 1; i >= 0; --i) {
            int c;
            int n;
            int id2 = fragID[i] & 0xFFFF;
            if (id2 > 0) {
                int n2 = id2;
                n = IDCount[n2] = IDCount[n2] + 1;
            } else {
                n = c = -1;
            }
            if ((atomFlags[i] & 0x4000) != 0) {
                if (largestOrganoMetRingAtC >= c) continue;
                largestOrganoMetRingAtC = c;
                organoMetRingID = id2;
                continue;
            }
            if ((atomFlags[i] & 1) != 0) {
                if (largestRingAtCount >= c) continue;
                largestRingAtCount = c;
                largestRingId = id2;
                continue;
            }
            if (largestAtCount >= c) continue;
            largestAtCount = c;
            largestId = id2;
        }
        int n = largestOrganoMetRingAtC > 1 ? organoMetRingID : (id = largestRingAtCount > 1 ? largestRingId : largestId);
        int count = largestOrganoMetRingAtC > 1 ? largestOrganoMetRingAtC : (largestRingAtCount > 1 ? largestRingAtCount : largestAtCount);
        int n3 = id = count < 2 ? -1 : id;
        if (Debug2 > 3) {
            System.err.println("fixStartSystem id " + id + " atomcount " + count);
        }
        if (largestOrganoMetRingAtC > 1 || largestRingAtCount > 1) {
            for (int i = ctab.length - 1; i >= 0; --i) {
                if ((fragID[i] & 0xFFFF) != id) continue;
                MolAtom a = m.getAtom(i);
                a.setZ(2.0);
                if (Debug2 <= 7) continue;
                System.err.println(" start fixed  " + (i + 1) + " x " + a.getX() + " " + a.getY());
            }
        } else {
            int c1 = 0;
            int c2 = 0;
            int i = ctab.length - 1;
            boolean fixed = false;
            block2: do {
                if (id != -1 && (fragID[i] & 0xFFFF) != id) continue;
                c1 = i;
                MolAtom a = m.getAtom(i);
                a.setXYZ(0.0, 0.0, 2.0);
                if (Debug2 > 7) {
                    System.err.println(" start fixed  " + (i + 1));
                }
                int[] an = ctab[i];
                for (int j = an.length - 1; j >= 0; --j) {
                    int idx = an[j];
                    if (id != -1 && (fragID[idx] & 0xFFFF) != id) continue;
                    c2 = idx;
                    a = m.getAtom(idx);
                    MolBond b = m.getBond(btab.getBondIndex(i, idx));
                    double l = m.getDesiredLength(b);
                    a.setXYZ(l, 0.0, 2.0);
                    fixed = true;
                    if (Debug2 <= 7) break block2;
                    System.err.println(" start fixed  " + (idx + 1));
                    break block2;
                }
                break;
            } while (!fixed && --i >= 0);
            if (id >= 0) {
                Clean2D.setCoordsFromIntangRecursively(c1, c2, id, ctab, btab, intang, fragID, atomFlags, m, null, true, Debug2);
                Clean2D.setCoordsFromIntangRecursively(c2, c1, id, ctab, btab, intang, fragID, atomFlags, m, null, true, Debug2);
            }
        }
    }

    static void fixFixedSystems(MoleculeGraph m, int[] atomFlags, int[] fragID, int[][] ctab) {
        for (int i = ctab.length - 1; i >= 0; --i) {
            if ((atomFlags[i] & 0x200) == 0) continue;
            if ((atomFlags[i] & 1) != 0) {
                int fid = fragID[i] & 0xFFFF;
                Clean2D.fixFragment(fid, fragID, atomFlags, m);
            }
            m.getAtom(i).setZ(2.0);
        }
        if (Clean2D.getFixedAtomCount(m) < 2) {
            int fixedIdx = Clean2D.getFixedIdx(m);
            if (fixedIdx < 0) {
                MolAtom a = m.getAtom(0);
                a.setXYZ(0.0, 0.0, 2.0);
                fixedIdx = 0;
            }
            MolAtom ac = m.getAtom(fixedIdx);
            MolBond b = ac.getBond(0);
            int[] an = ctab[fixedIdx];
            int idx = an[0];
            MolAtom a = m.getAtom(idx);
            double l = m.getDesiredLength(b);
            a.setXYZ(ac.getX() + l, ac.getY(), 2.0);
        }
    }

    static boolean postProcess(MoleculeGraph m, int[] atomFlags, int[] fragID, int[][] d, int[][] pred, int[][] ctab, BondTable btab, double[][] intang, int fixedC, PartialOptimization opt, int Debug2, FileOutputStream out) {
        int i;
        if (Debug2 > 3) {
            System.err.println("POSTPROCESSSING ");
        }
        int ac = m.getAtomCount();
        int n = 0;
        double[] fixedc = null;
        if (fixedC > 0) {
            fixedc = new double[fixedC * 2];
            for (int i2 = 0; i2 < ac; ++i2) {
                MolAtom a = m.getAtom(i2);
                if (a.getZ() != 2.0) continue;
                fixedc[n++] = a.getX();
                fixedc[n++] = a.getY();
            }
        }
        int step_limit = 20;
        n = 0;
        int[] path = null;
        while ((path = Clean2D.hasCoincidence(m, atomFlags, d, pred, fragID, 0.2635111111111111)) != null && ++n < step_limit) {
            if (Debug2 > 2) {
                System.err.println("     Collision at :" + (path[0] + 1) + " " + (path[path.length - 1] + 1));
            }
            if (Debug2 > 4) {
                System.err.print("     Shortest path atom indexes :");
                for (i = path.length - 1; i >= 0; --i) {
                    int idx = path[i];
                    System.err.print(" " + (idx + 1));
                }
                System.err.println();
                Clean2D.saveMoleculeToFile(m, fragID, out, "postProcess");
            }
            Clean2D.postprocessToAvoidCollision(m, atomFlags, d, pred, ctab, btab, intang, path, fragID, Debug2);
        }
        if (n >= step_limit) {
            if (Debug2 > 2) {
                System.err.println("     Optimize in postprocess");
            }
            n = 0;
            for (i = 0; i < ac && fixedC > 0; ++i) {
                MolAtom a = m.getAtom(i);
                if (a.getZ() != 2.0) continue;
                a.setX(fixedc[n++]);
                a.setY(fixedc[n++]);
            }
            Clean2D.optimizeMolecule(m, atomFlags, opt, 11, 1, Debug2);
            if (!Clean2D.coordinatesNot0D(m, true)) {
                if (Debug2 > 2) {
                    System.err.println("     Optimization was not successfull");
                }
                return false;
            }
        }
        for (i = 0; i < ac; ++i) {
            if (m.getAtom(i).getZ() != 2.0) continue;
            int f = atomFlags[i];
            int fid = fragID[i] & 0xFFFF;
            if ((f & 1) == 0 || !Clean2D.hasNonfixedRingAtom(i, fid, ctab[i], atomFlags, fragID, m)) continue;
            Clean2D.tranformRingAccordingToIntang(i, fid, ctab, btab, intang, fragID, m);
        }
        return true;
    }

    static boolean postprocessToAvoidCollision(MoleculeGraph m, int[] atomFlags, int[][] d, int[][] pred, int[][] ctab, BondTable btab, double[][] intang, int[] shortestPath, int[] fragID, int Debug2) {
        int idx_inPath = 0;
        int l = shortestPath.length;
        if (l < 3) {
            return false;
        }
        int i1 = -1;
        int i2 = -1;
        int i3 = -1;
        if ((atomFlags[shortestPath[0]] & 0x200) == 0 && (atomFlags[shortestPath[0]] & 4) != 0) {
            i1 = shortestPath[2];
            i2 = shortestPath[1];
            i3 = shortestPath[0];
        } else if ((atomFlags[shortestPath[l - 1]] & 0x200) == 0 && (atomFlags[shortestPath[l - 1]] & 4) != 0) {
            i1 = shortestPath[l - 3];
            i2 = shortestPath[l - 2];
            i3 = shortestPath[l - 1];
        } else {
            idx_inPath = Clean2D.locateUsableMiddle(shortestPath, atomFlags);
            if (idx_inPath != -1) {
                i2 = shortestPath[idx_inPath];
                if (!Clean2D.hasPreviouslyFixedAtom(shortestPath, idx_inPath, 1, atomFlags)) {
                    i1 = shortestPath[idx_inPath - 1];
                    i3 = shortestPath[idx_inPath + 1];
                } else if (!Clean2D.hasPreviouslyFixedAtom(shortestPath, idx_inPath, -1, atomFlags)) {
                    i3 = shortestPath[idx_inPath - 1];
                    i1 = shortestPath[idx_inPath + 1];
                } else {
                    idx_inPath = -1;
                }
            }
        }
        if (idx_inPath != -1) {
            if (Debug2 > 4) {
                System.err.println("\tInternal angle change: " + (i1 + 1) + "-" + (i2 + 1) + "-" + (i3 + 1));
            }
            Clean2D.intangChange(i1, i2, i3, m.getAtom(i2), 0.3141592653589793, ctab, btab, intang, m);
            return true;
        }
        return false;
    }

    static int locateUsableMiddle(int[] path, int[] atomFlags) {
        int mid = path.length / 2;
        int n = 0;
        int i = mid;
        boolean p = true;
        while (i > 0 && i < path.length - 1) {
            boolean chain;
            int idx = path[i];
            int f = atomFlags[idx];
            boolean bl = chain = (atomFlags[path[i + 1]] & f & atomFlags[path[i - 1]] & 2) != 0;
            if ((f & 0x20) != 0 || (f & 0x10) != 0 || (f & 6) == 6 || (f & 0x80) != 0 || (f & 8) != 0 && (f & 0x400) == 0 || !chain) {
                return i;
            }
            i = p ? mid - ++n : mid + n;
            p = !p;
        }
        return -1;
    }

    static boolean hasPreviouslyFixedAtom(int[] p, int s, int d, int[] atomFlags) {
        int l = p.length;
        for (int i = s + d; i >= 0 && i < l; i += d) {
            int idx = p[i];
            if ((atomFlags[idx] & 0x200) == 0) continue;
            return true;
        }
        return false;
    }

    static void tranformRingAccordingToIntang(int idx, int id, int[][] ctab, BondTable btab, double[][] intang, int[] fragID, MoleculeGraph m) {
        int[] an = ctab[idx];
        int fromIdx = -1;
        int trf1 = -1;
        int trf2 = -1;
        for (int i = an.length - 1; i >= 0 && (fromIdx < 0 || trf2 < 0); --i) {
            int lig = an[i];
            if (m.getAtom(lig).getZ() == 2.0) {
                fromIdx = lig;
                continue;
            }
            if ((fragID[lig] & 0xFFFF) != id) continue;
            if (trf1 == -1) {
                trf1 = lig;
                continue;
            }
            trf2 = lig;
        }
        if (fromIdx == -1 || trf1 == -1 || trf2 == -1) {
            if (Error == 1) {
                System.err.println("Error in ringtransformation");
            }
            return;
        }
        int b1 = btab.getBondIndex(idx, fromIdx);
        int b2 = btab.getBondIndex(idx, trf1);
        int b3 = btab.getBondIndex(idx, trf2);
        double fi = intang[b1][b2];
        CTransform3D T = new CTransform3D();
        MolAtom ao = m.getAtom(fromIdx);
        MolAtom ac = m.getAtom(idx);
        MolAtom a_trf1 = m.getAtom(trf1);
        double l = m.getDesiredLength(m.getBond(b2));
        double dx = ao.getX() - ac.getX();
        double dy = ao.getY() - ac.getY();
        double c = Math.cos(fi);
        double s = Math.sin(fi);
        double dxn = c * dx - s * dy;
        double dyn = c * dy + s * dx;
        double dn = Math.sqrt(dxn * dxn + dyn * dyn);
        T.setTranslation(ac.getX() + dxn / dn * l - a_trf1.getX(), ac.getY() + dyn / dn * l - a_trf1.getY(), 0.0);
        Clean2D.transformNonfixedFrag(T, id, fragID, m);
        l = m.getDesiredLength(m.getBond(b3));
        fi = intang[b1][b3];
        c = Math.cos(fi);
        s = Math.sin(fi);
        dxn = c * dx - s * dy;
        dyn = c * dy + s * dx;
        dn = Math.sqrt(dxn * dxn + dyn * dyn);
        DPoint3 loc_2 = new DPoint3(ac.getX() + dxn / dn * l, ac.getY() + dyn / dn * l, 0.0);
        T.setIdentity();
        DPoint3 o = a_trf1.getLocation();
        DPoint3 p_trf2 = m.getAtom(trf2).getLocation();
        double phi = o.angle2D(loc_2.x, loc_2.y);
        double phi_orig = o.angle2D(p_trf2.x, p_trf2.y);
        T.setRotation(0.0, 0.0, 1.0, phi - phi_orig);
        T.setRotationCenter(o);
        Clean2D.transformNonfixedFrag(T, id, fragID, m);
    }

    static void intangChange(int i1, int i2, int i3, MolAtom a2, double fi_0, int[][] ctab, BondTable btab, double[][] intang, MoleculeGraph m) {
        int[] an = ctab[i2];
        int b0 = btab.getBondIndex(i1, i2);
        int b1 = btab.getBondIndex(i2, i3);
        double phi_orig = intang[b0][b1];
        int l = an.length;
        int ref = Clean2D.indexOf(an, i1);
        for (int i = 1; i < l; ++i) {
            double fi;
            int lig = an[(ref + i) % l];
            int b = btab.getBondIndex(i2, lig);
            if (lig == i3) {
                fi = intang[b0][b];
                fi = (fi = Clean2D.convertToPos(fi)) < Math.PI ? fi + fi_0 : fi - fi_0;
            } else {
                fi = intang[b0][b];
                fi = (fi = Clean2D.convertToPos(fi)) < Math.PI ? fi + fi_0 / (double)(l - 1) : fi - fi_0 / (double)(l - 1);
            }
            intang[b0][b] = fi;
            intang[b][b0] = -fi;
        }
        Clean2D.resolveIntAngFromReference(i1, i2, btab, an, intang);
        double phi = intang[b0][b1];
        CTransform3D R = new CTransform3D();
        R.setRotation(0.0, 0.0, 1.0, phi - phi_orig);
        DPoint3 o = a2.getLocation();
        R.setRotationCenter(o);
        int ac = m.getAtomCount();
        BitSet needToTransform = new BitSet(ac);
        needToTransform.set(i2);
        needToTransform.set(i3);
        Clean2D.recursiveSelectAtomToTransformation(i3, ctab, needToTransform);
        needToTransform.clear(i2);
        int i = needToTransform.nextSetBit(0);
        while (i >= 0) {
            MolAtom a = m.getAtom(i);
            if (a.getZ() == 2.0) {
                a.transform(R, false);
            }
            i = needToTransform.nextSetBit(i + 1);
        }
    }

    private static void recursiveSelectAtomToTransformation(int idx, int[][] ctab, BitSet needToTransform) {
        needToTransform.set(idx);
        for (int i = ctab[idx].length - 1; i >= 0; --i) {
            int lig = ctab[idx][i];
            if (needToTransform.get(lig)) continue;
            Clean2D.recursiveSelectAtomToTransformation(lig, ctab, needToTransform);
        }
    }

    private static void recursiveIntangSet(int id, MoleculeGraph m, int[] fragID, int[] atomFlags) {
        int ac = m.getAtomCount();
        for (int j = 0; j < ac; ++j) {
            int fID = fragID[j] & 0xFFFF;
            if (fID != id || (atomFlags[j] & 0x200) != 0) continue;
            m.getAtom(j).setZ(1.0);
        }
    }

    static void setCoordsFromIntangRecursively(int c, int prev, int id, int[][] ctab, BondTable btab, double[][] intang, int[] fragID, int[] atomFlags, MoleculeGraph m, BitSet fixed, boolean recursive, int Debug2) {
        int b0 = btab.getBondIndex(c, prev);
        MolAtom cAtom = m.getAtom(c);
        int[] an = ctab[c];
        for (int i = an.length - 1; i >= 0; --i) {
            int idx = an[i];
            MolAtom a = m.getAtom(idx);
            int fID = fragID[idx] & 0xFFFF;
            if (idx == prev || a.getZ() == 2.0 || id >= 0 && fID != id) continue;
            int b1 = btab.getBondIndex(c, idx);
            MolBond b = m.getBond(b1);
            double fi = intang[b0][b1];
            int f = atomFlags[idx];
            if (id > 0 && (f & 1) != 0) {
                boolean fixall;
                boolean bl = fixall = recursive || (f & 0x8C) == 0;
                if (Debug2 > 6) {
                    System.err.println(" ringatom " + (idx + 1) + " all " + fixall + "  " + (prev + 1) + "-" + (c + 1) + "-" + (idx + 1));
                }
                Clean2D.attachRingsWithId(c, prev, idx, b0, b1, fi, id, fragID, fixall, ctab, btab, intang, atomFlags, m, fixed);
                if (Debug2 <= 6) continue;
                System.err.println(" atom " + (idx + 1) + " fixed");
                continue;
            }
            if (fixed != null) {
                fixed.set(idx);
            }
            Clean2D.setXY(m, m.getAtom(prev), cAtom, m.getAtom(idx), b, fi, true, Debug2);
            if (Debug2 > 6) {
                System.err.println(" atom " + (idx + 1) + " fixed recursive " + (recursive || (f & 0x8C) == 0));
            }
            if (!recursive && (f & 0x8C) != 0) continue;
            Clean2D.setCoordsFromIntangRecursively(idx, c, id, ctab, btab, intang, fragID, atomFlags, m, fixed, true, Debug2);
        }
    }

    static void setCoordsForLigands(int c, int prev, int[][] ctab, BondTable btab, double[][] intang, int[] fragID, int[] atomFlags, MoleculeGraph m, BitSet fixed, int Debug2) {
        MolAtom cAtom = m.getAtom(c);
        int b0 = btab.getBondIndex(c, prev);
        int[] an = ctab[c];
        for (int i = an.length - 1; i >= 0; --i) {
            int idx = an[i];
            MolAtom a = m.getAtom(idx);
            if (a.getZ() == 2.0) continue;
            int b1 = btab.getBondIndex(c, idx);
            MolBond b = m.getBond(b1);
            double fi = intang[b0][b1];
            int f = atomFlags[idx];
            if (fixed != null) {
                fixed.set(idx);
            }
            if ((f & 1) != 0) {
                int fID = fragID[idx] & 0xFFFF;
                Clean2D.attachRingsWithId(c, prev, idx, b0, b1, fi, fID, fragID, false, ctab, btab, intang, atomFlags, m, fixed);
                if (Debug2 <= 6) continue;
                System.err.println(" ring with id " + fID + " fixed ");
                continue;
            }
            Clean2D.setXY(m, m.getAtom(prev), cAtom, m.getAtom(idx), b, fi, true, Debug2);
            if (Debug2 <= 6) continue;
            System.err.println(" atom " + (idx + 1) + " fixed ");
        }
    }

    static void setCoordinatesForLigands(int idx, int from, BitSet fixedA, BitSet fixedB, int[] fragID, int[][] ctab, BondTable btab, double[][] intang, int[] atomFlags, MoleculeGraph m, int Debug2) {
        int fid = fragID[idx] & 0xFFFF;
        if (Debug2 > 6) {
            System.err.println("setCoordinatesForLigands " + (idx + 1) + " Fragment set " + fid);
        }
        int f = atomFlags[idx];
        int[] an = ctab[idx];
        if ((f & 1) != 0 && Clean2D.hasNonfixedRingAtom(idx, fid, an, atomFlags, fragID, m)) {
            Clean2D.setFragmentTo(2.0, fid, fragID, atomFlags, m, fixedA);
            if (Debug2 > 6) {
                System.err.println("atom " + (idx + 1) + " Fragment set " + fid);
            }
        } else {
            Clean2D.setCoordsFromIntangRecursively(idx, from, fid, ctab, btab, intang, fragID, atomFlags, m, fixedA, false, Debug2);
        }
        Clean2D.setCoordsForLigands(idx, from, ctab, btab, intang, fragID, atomFlags, m, fixedA, Debug2);
        if (fixedB != null) {
            fixedA.set(idx);
            Clean2D.generateBondSetFromAtomSet(fixedA, fixedB, m, ctab, btab);
            fixedA.clear(idx);
        }
    }

    private static void generateBondSetFromAtomSet(BitSet sA, BitSet sB, MoleculeGraph m, int[][] ctab, BondTable btab) {
        int i = sA.nextSetBit(0);
        while (i >= 0) {
            int[] an = ctab[i];
            for (int j = 0; j < an.length; ++j) {
                int k = an[j];
                if (!sA.get(k)) continue;
                int bidx = btab.getBondIndex(i, k);
                sB.set(bidx);
            }
            i = sA.nextSetBit(i + 1);
        }
    }

    private static void attachRingsWithId(int center, int prev, int next, int b0, int b1, double fi, int id, int[] fragID, boolean fixall, int[][] ctab, BondTable btab, double[][] intang, int[] atomFlags, MoleculeGraph m, BitSet fixed) {
        int fID;
        CTransform3D T = new CTransform3D();
        MolBond b = m.getBond(b1);
        double bl = m.getDesiredLength(b);
        MolAtom ao = m.getAtom(prev);
        MolAtom ac = m.getAtom(center);
        MolAtom an = m.getAtom(next);
        double dx = ao.getX() - ac.getX();
        double dy = ao.getY() - ac.getY();
        double c = Math.cos(fi);
        double s = Math.sin(fi);
        double dxn = c * dx - s * dy;
        double dyn = c * dy + s * dx;
        double dn = Math.sqrt(dxn * dxn + dyn * dyn);
        T.setTranslation(ac.getX() + dxn / dn * bl - an.getX(), ac.getY() + dyn / dn * bl - an.getY(), 0.0);
        CTransform3D R = new CTransform3D();
        MolAtom nexta = m.getAtom(next);
        int[] ct = ctab[next];
        int lig = 0;
        for (int i = ct.length - 1; i >= 0 && (fID = fragID[lig = ct[i]] & 0xFFFF) != id; --i) {
        }
        int b2 = btab.getBondIndex(next, lig);
        DPoint3 nextp = nexta.getLocation();
        DPoint3 ligp = m.getAtom(lig).getLocation();
        DPoint3 acp = ac.getLocation();
        double nextLigPhi = nextp.angle2D(ligp.x, ligp.y);
        T.transform(nextp);
        double nextCenterPhi = nextp.angle2D(acp.x, acp.y);
        double delta = nextLigPhi - nextCenterPhi;
        double psi = intang[b1][b2] - delta;
        R.setRotation(0.0, 0.0, 1.0, psi);
        R.setRotationCenter(nexta.getLocation());
        T.mul(R);
        int l = fragID.length;
        for (int i = 0; i < l; ++i) {
            int fID2 = fragID[i] & 0xFFFF;
            if (fID2 != id) continue;
            MolAtom a = m.getAtom(i);
            a.transform(T, false);
            int n = i;
            atomFlags[n] = atomFlags[n] | 0x800;
            if (!fixall && next != i) continue;
            if (fixed != null) {
                fixed.set(i);
            }
            a.setZ(2.0);
        }
    }

    static int[] storeStereoInFlags(MoleculeGraph m, int[][] cssr, BondTable btab, boolean d2, boolean partialClean, boolean hAdded) {
        int s;
        int i;
        if (!hAdded) {
            int i2;
            int ac = m.getAtomCount();
            int[] p = new int[ac];
            int pl = p.length;
            int dim = m.getDim();
            for (i2 = 0; i2 < pl; ++i2) {
                p[i2] = dim == 3 ? m.getParity(i2) : m.getLocalParity(i2);
            }
            for (i2 = 0; i2 < ac; ++i2) {
                MolAtom a = m.getAtom(i2);
                if (p[i2] > 0) {
                    a.setFlags(p[i2], 7);
                    continue;
                }
                a.setFlags(0, 7);
            }
        }
        int bondCount = m.getBondCount();
        int[] bondFlags = new int[bondCount];
        if (d2) {
            for (i = 0; i < bondCount; ++i) {
                s = 0;
                MolBond b = m.getBond(i);
                if ((b.getFlags() & 0xC0) != 192 && b.getType() == 2) {
                    MolAtom n2 = b.getAtom1();
                    MolAtom n3 = b.getAtom2();
                    if (n2.getBondCount() > 1 && n3.getBondCount() > 1) {
                        MolAtom a1 = null;
                        MolAtom a4 = null;
                        if (partialClean) {
                            MolAtom a;
                            int j;
                            for (j = n2.getBondCount() - 1; j >= 0 && a1 == null; --j) {
                                a = n2.getLigand(j);
                                if (a == n3 || a.getZ() != 2.0) continue;
                                a1 = a;
                            }
                            if (a1 != null) {
                                for (j = n3.getBondCount() - 1; j >= 0 && a4 == null; --j) {
                                    a = n3.getLigand(j);
                                    if (a == n2 || a.getZ() != 2.0) continue;
                                    a4 = a;
                                }
                            }
                            if (a1 != null && a4 != null) {
                                MolAtom a2 = n2;
                                MolAtom a3 = n3;
                                double[][] c = new double[][]{{a1.getX(), a1.getY()}, {a2.getX(), a2.getY()}, {a3.getX(), a3.getY()}, {a4.getX(), a4.getY()}};
                                s = Clean2D.getStereo2(c[0], c[1], c[2], c[3]);
                            }
                        } else {
                            a1 = b.getCTAtom1();
                            a4 = b.getCTAtom4();
                            s = m.getStereo2(b, a1, a4);
                        }
                        if (s != 512) {
                            b.setStereo2Flags(a1, a4, s);
                        }
                    }
                }
                bondFlags[i] = b.getFlags();
            }
        } else {
            for (i = 0; i < bondCount; ++i) {
                s = 0;
                MolBond b = m.getBond(i);
                if (b.getType() == 2) {
                    MolAtom a4;
                    MolAtom a1 = b.getCTAtom1();
                    if (a1 != null && (a4 = b.getCTAtom4()) != null) {
                        s = m.getStereo2(b, a1, a4);
                        if ((s & 0xC0) == 192 || s == 0) {
                            if (!m.canBeCT(m.indexOf(b.getAtom1()), m.indexOf(b.getAtom2()))) {
                                b.setFlags(0, 448);
                            } else {
                                b.setFlags(s, 448);
                            }
                        }
                    } else {
                        b.setFlags(0, 448);
                    }
                }
                bondFlags[i] = b.getFlags();
            }
        }
        for (i = 0; i < cssr.length; ++i) {
            int[] r = cssr[i];
            int l = r.length;
            if (l >= 8) continue;
            for (int j = l - 1; j >= 0; --j) {
                int h = r[j];
                int n = r[(j + 1) % l];
                int bn = btab.getBondIndex(h, n);
                MolBond b = m.getBond(bn);
                b.setFlags(0, 448);
            }
        }
        return bondFlags;
    }

    static void setBondFlags(int[] bf, MoleculeGraph m) {
        if (bf == null) {
            return;
        }
        int l = bf.length;
        for (int i = 0; i < l; ++i) {
            MolBond b = m.getBond(i);
            b.setFlags(bf[i]);
        }
    }

    static void writeCoordsandBonds(MolAtom[] atoms, MolBond[] bonds, MoleculeGraph m) {
        MoleculeGraph to = m.getGraphUnion();
        int ac = to.getAtomCount();
        MolAtom a = null;
        int al = atoms.length;
        for (int i = 0; i < al; ++i) {
            a = atoms[i];
            MolAtom atomToCoord = null;
            if (i >= ac) {
                MolAtom toA = m.getAtom(Clean2D.indexOf(atoms, a.getLigand(0)));
                MolBond refBond = a.getBond(0);
                atomToCoord = new MolAtom(1, 0.0, 0.0, 0.0);
                m.add(atomToCoord);
                MolBond bondToH = new MolBond(toA, atomToCoord, 1);
                int f = refBond.getFlags() & 0x30;
                m.add(bondToH);
                if (Clean2D.indexOf(atoms, refBond.getAtom1()) != to.indexOf(bondToH.getAtom1())) {
                    bondToH.swap();
                }
                bondToH.setFlags(f, 48);
            } else {
                atomToCoord = to.getAtom(i);
            }
            atomToCoord.setLocation(a.getLocation());
        }
        MolBond b = null;
        MolBond tob = null;
        int bl = m.getBondCount();
        for (int i = 0; i < bl; ++i) {
            b = bonds[i];
            int f = b.getFlags() & 0x30;
            tob = to.getBond(i);
            if (Clean2D.indexOf(atoms, b.getAtom1()) != to.indexOf(tob.getAtom1())) {
                tob.swap();
            }
            tob.setFlags(f, 48);
            if (b.getType() != 2) continue;
            tob = to.getBond(i);
            tob.setFlags(b.getFlags(), 448);
        }
        to.setDim(2);
    }

    static boolean isMoleculeNot0Dimension(MoleculeGraph m) {
        if (m.getDim() < 2) {
            return false;
        }
        return Clean2D.coordinatesNot0D(m, false);
    }

    static boolean coordinatesNot0D(MoleculeGraph m, boolean fixed) {
        double x1 = 0.0;
        double y1 = 0.0;
        double z1 = 0.0;
        int l = m.getAtomCount();
        for (int i = 0; i < l; ++i) {
            MolAtom a = m.getAtom(i);
            double x = a.getX();
            double y = a.getY();
            double z = a.getZ();
            if (fixed && (!fixed || z != 2.0)) continue;
            if (Double.isNaN(x) || Double.isNaN(y) || Double.isNaN(z)) {
                return false;
            }
            if (i == 0) {
                x1 = x;
                y1 = y;
                z1 = z;
                continue;
            }
            if (x != x1 || y != y1 || z != z1) continue;
            return false;
        }
        return true;
    }

    static boolean contractedSgroup(MolAtom a) {
        if (a instanceof SgroupAtom) {
            SuperatomSgroup s = ((SgroupAtom)a).getSgroup();
            return s.isContracted();
        }
        return false;
    }

    static void arrangeSaltMolecules(MoleculeGraph mol) {
        RxnMolecule rxn = null;
        if (mol instanceof RgMolecule) {
            RgMolecule rgm = (RgMolecule)mol;
            Molecule r = rgm.getRoot();
            if (r instanceof RxnMolecule) {
                rxn = (RxnMolecule)r;
            }
        } else if (mol instanceof RxnMolecule) {
            rxn = (RxnMolecule)mol;
        }
        if (rxn != null) {
            int f;
            Molecule m;
            int i;
            for (i = 0; i < rxn.getReactantCount(); ++i) {
                m = rxn.getReactant(i);
                f = m.getFragCount(1);
                if (f <= 1) continue;
                CleanUtil.arrangeMolecules(m.findFrags(SelectionMolecule.class, 1), 3, f);
            }
            for (i = 0; i < rxn.getAgentCount(); ++i) {
                m = rxn.getAgent(i);
                f = m.getFragCount(1);
                if (f <= 1) continue;
                CleanUtil.arrangeMolecules(m.findFrags(SelectionMolecule.class, 1), 2, f);
            }
            for (i = 0; i < rxn.getProductCount(); ++i) {
                m = rxn.getProduct(i);
                f = m.getFragCount(1);
                if (f <= 1) continue;
                CleanUtil.arrangeMolecules(m.findFrags(SelectionMolecule.class, 1), 2, f);
            }
        }
    }

    static boolean arrangeMultiCenter(MoleculeGraph m, int Debug2) {
        if (m instanceof RgMolecule) {
            RgMolecule rg = (RgMolecule)m;
            return Clean2D.arrangeMultiCenter(rg, Debug2);
        }
        Molecule mol = (Molecule)m;
        return Clean2D.arrangeMultiCenter(mol, Debug2);
    }

    static boolean arrangeMultiCenter(RgMolecule m, int Debug2) {
        if (!Clean2D.arrangeMultiCenter(m.getRoot(), Debug2)) {
            return false;
        }
        int l = m.getRgroupCount();
        for (int i = 0; i < l; ++i) {
            int rgm = m.getRgroupMemberCount(i);
            for (int j = 0; j < rgm; ++j) {
                if (Clean2D.arrangeMultiCenter(m.getRgroupMember(i, j), Debug2)) continue;
                return false;
            }
        }
        return true;
    }

    static boolean arrangeMultiCenter(Molecule m, int Debug2) {
        if (Debug2 > 0) {
            System.err.println("arrangeMultiCenter molecule ");
        }
        MoleculeGraph[] frags = m.findBasicFrags(SelectionMolecule.class);
        int l = frags.length;
        int ac = m.getAtomCount();
        int[] fragsID = new int[ac];
        for (int i = 0; i < l; ++i) {
            MoleculeGraph f = frags[i];
            for (int j = f.getAtomCount() - 1; j >= 0; --j) {
                MolAtom n = f.getAtom(j);
                int idx = m.indexOf(n);
                fragsID[idx] = i;
            }
        }
        Molecule sm = new Molecule();
        for (int i = 0; i < l; ++i) {
            MolAtom a = new MolAtom(136);
            sm.add(a);
        }
        boolean bondsadded = false;
        for (int i = 0; i < m.getSgroupCount(); ++i) {
            Sgroup sg = m.getSgroup(i);
            if (!(sg instanceof MulticenterSgroup)) continue;
            MulticenterSgroup mcsg = (MulticenterSgroup)sg;
            MolAtom ca = mcsg.getCentralAtom();
            int ca_idx = m.indexOf(ca);
            if (ca_idx < ac) {
                int i1 = fragsID[ca_idx];
                MolAtom a1 = sm.getAtom(i1);
                boolean hasMultiInOneFrag = false;
                double[] cm = new double[2];
                int n = 0;
                for (int j = mcsg.getAtomCount() - 1; j >= 0; --j) {
                    MolAtom ga = mcsg.getAtom(j);
                    int i2 = fragsID[m.indexOf(ga)];
                    MolAtom a2 = sm.getAtom(i2);
                    if (i1 == i2) {
                        hasMultiInOneFrag = true;
                        cm[0] = cm[0] + ga.getX();
                        cm[1] = cm[1] + ga.getY();
                        ++n;
                    }
                    if (Clean2D.hasBondBetween(a1, a2)) continue;
                    MolBond cb = new MolBond(a1, a2, 1);
                    sm.add(cb);
                    bondsadded = true;
                }
                if (!hasMultiInOneFrag) continue;
                ca.setXYZ(cm[0] / (double)n, cm[1] / (double)n, ca.getZ());
                continue;
            }
            DPoint3 center = mcsg.getSgroupGraph().calcCenter();
            ca.setXYZ(center.x, center.y, ca.getZ());
        }
        if (bondsadded) {
            int i;
            Cleaner.clean(sm, 2, null);
            BitSet hasMulticenterSgroup = new BitSet(l);
            for (int i2 = 0; i2 < m.getSgroupCount(); ++i2) {
                Sgroup sg = m.getSgroup(i2);
                if (!(sg instanceof MulticenterSgroup)) continue;
                int sgac = sg.getAtomCount();
                for (int j = 0; j < sgac; ++j) {
                    MolAtom a = sg.getAtom(j);
                    int idx = m.indexOf(a);
                    hasMulticenterSgroup.set(fragsID[idx]);
                }
            }
            int fixAround = -1;
            while ((fixAround = Clean2D.locateFirstFragment(sm, frags)) >= 0) {
                sm.getAtom(fixAround).setZ(2.0);
                while (fixAround >= 0) {
                    if (Clean2D.hasMulticenterAtom(frags[fixAround])) {
                        Clean2D.arrangeMcSgFragmentAround(frags, sm, fixAround, m, fragsID);
                    } else if (hasMulticenterSgroup.get(fixAround)) {
                        Clean2D.arrangeCentralAtomFragsAround(frags, sm, fixAround, m, fragsID);
                    }
                    fixAround = Clean2D.locateNextFragToFixAround(fixAround, sm, frags);
                }
            }
            for (i = 0; i < m.getSgroupCount(); ++i) {
                MulticenterSgroup mcsg;
                MolAtom ca;
                int ca_idx;
                Sgroup sg = m.getSgroup(i);
                if (!(sg instanceof MulticenterSgroup) || (ca_idx = m.indexOf(ca = (mcsg = (MulticenterSgroup)sg).getCentralAtom())) >= ac) continue;
                int i1 = fragsID[ca_idx];
                boolean hasMultiInOneFrag = false;
                double[] cm = new double[2];
                int n = 0;
                for (int j = mcsg.getAtomCount() - 1; j >= 0; --j) {
                    MolAtom ga = mcsg.getAtom(j);
                    int i2 = fragsID[m.indexOf(ga)];
                    if (i1 != i2) continue;
                    hasMultiInOneFrag = true;
                    cm[0] = cm[0] + ga.getX();
                    cm[1] = cm[1] + ga.getY();
                    ++n;
                }
                if (!hasMultiInOneFrag) continue;
                ca.setXYZ(cm[0] / (double)n, cm[1] / (double)n, ca.getZ());
            }
            for (i = 0; i < l; ++i) {
                Clean2D.setZ(frags[i], 0.0);
            }
            return !Clean2D.checkMolCollapsion(m);
        }
        return true;
    }

    static int locateFirstFragment(MoleculeGraph sm, MoleculeGraph[] f) {
        int maxConn = -1;
        int fixAround = -1;
        int l = sm.getAtomCount();
        for (int i = 0; i < l; ++i) {
            MolAtom a = sm.getAtom(i);
            if (a.getZ() == 2.0 || a.getBondCount() <= maxConn) continue;
            maxConn = a.getBondCount();
            fixAround = i;
        }
        return fixAround;
    }

    static boolean hasMulticenterAtom(MoleculeGraph m) {
        for (int i = m.getAtomCount() - 1; i >= 0; --i) {
            MolAtom a = m.getAtom(i);
            if (a.getAtno() != 137) continue;
            return true;
        }
        return false;
    }

    static int locateNextFragToFixAround(int idx, MoleculeGraph m, MoleculeGraph[] f) {
        MolAtom a = m.getAtom(idx);
        int fixAround = -1;
        int maxConn = 0;
        int l = a.getBondCount();
        for (int i = 0; i < l; ++i) {
            MolAtom n = a.getLigand(i);
            int atomIdx = m.indexOf(n);
            if (n.getZ() == 2.0 || n.getBondCount() <= maxConn) continue;
            maxConn = a.getBondCount();
            if (fixAround >= 0 && f[fixAround].getAtomCount() <= f[atomIdx].getAtomCount()) continue;
            fixAround = atomIdx;
        }
        return fixAround;
    }

    static void arrangeMcSgFragmentAround(MoleculeGraph[] f, MoleculeGraph s, int fixedID, Molecule m, int[] fragsID) {
        Clean2D.increaseCoordBondLength(f[fixedID], 0.5);
        MolAtom startAtom = s.getAtom(fixedID);
        int bc = startAtom.getBondCount();
        for (int i = 0; i < bc; ++i) {
            MolAtom l = startAtom.getLigand(i);
            int fId = s.indexOf(l);
            if (l.getZ() == 2.0) continue;
            Clean2D.fixMcSgFrag(fId, fixedID, f, m, fragsID);
            l.setZ(2.0);
        }
    }

    static void fixMcSgFrag(int id_toFix, int id_fixed, MoleculeGraph[] f, Molecule m, int[] fragsID) {
        CTransform3D T = new CTransform3D();
        MoleculeGraph fragTofix = f[id_toFix];
        MoleculeGraph fixedFrag = f[id_fixed];
        int fc = fixedFrag.getAtomCount();
        IntVector cIdx = new IntVector();
        IntVector mcsgIdx = new IntVector();
        for (int i = 0; i < fc; ++i) {
            MolAtom a = fixedFrag.getAtom(i);
            int mcsg = -1;
            if (a.getAtno() != 137 || (mcsg = Clean2D.connectToFrag(a, id_toFix, m, fragsID)) < 0) continue;
            cIdx.add(i);
            mcsgIdx.add(mcsg);
        }
        int l = mcsgIdx.size();
        if (l == 1) {
            int centerIdx = cIdx.get(0);
            MolAtom a = fixedFrag.getAtom(centerIdx);
            int mcsgIndex = mcsgIdx.get(0);
            MulticenterSgroup mcsg = (MulticenterSgroup)m.getSgroup(mcsgIndex);
            double[] cm = Clean2D.calcCM(mcsg);
            T.setTranslation(a.getX() - cm[0], a.getY() - cm[1], 0.0);
            fragTofix.transform(T);
            if (a.getBondCount() > 1 && mcsg.getAtomCount() > 1) {
                DPoint3 o = new DPoint3(a.getX(), a.getY(), 0.0);
                int[][] ctab = fixedFrag.getCtab();
                IntVector lIdx = new IntVector(ctab[centerIdx]);
                IntVector mcIdx = new IntVector();
                for (int i = 0; i < lIdx.size(); ++i) {
                    mcIdx.add(mcsgIndex);
                }
                double fi = 0.0;
                if (fragTofix.getAtomCount() == 2) {
                    double s_tofix = Clean2D.slope(fragTofix.getAtomArray());
                    double s_fixed = Clean2D.slope(fixedFrag.getAtomArray());
                    fi = Math.acos((1.0 + s_tofix * s_fixed) / (Math.sqrt(1.0 + s_tofix * s_tofix) * Math.sqrt(1.0 + s_fixed * s_fixed)));
                    fi -= 1.5707963267948966;
                } else {
                    int n = 10;
                    int min_angle = Clean2D.rotateToMinDist(fragTofix, o, n, mcIdx, lIdx, T, fixedFrag, m);
                    fi = Math.PI * 2 / (double)n * (double)(min_angle + 1);
                }
                T.setRotation(0.0, 0.0, 1.0, fi);
                T.setRotationCenter(o);
                fragTofix.transform(T);
            }
        } else if (l > 1) {
            double[] cm_c = new double[2];
            for (int i = 0; i < l; ++i) {
                MolAtom a = fixedFrag.getAtom(cIdx.get(i));
                cm_c[0] = cm_c[0] + a.getX();
                cm_c[1] = cm_c[1] + a.getY();
            }
            cm_c[0] = cm_c[0] / (double)l;
            cm_c[1] = cm_c[1] / (double)l;
            double[] cm_g = new double[2];
            double[][] cm_s = new double[l][2];
            for (int i = 0; i < l; ++i) {
                MulticenterSgroup mcsg = (MulticenterSgroup)m.getSgroup(mcsgIdx.get(i));
                cm_s[i] = Clean2D.calcCM(mcsg);
                cm_g[0] = cm_g[0] + cm_s[i][0];
                cm_g[1] = cm_g[1] + cm_s[i][1];
            }
            cm_g[0] = cm_g[0] / (double)l;
            cm_g[1] = cm_g[1] / (double)l;
            T.setTranslation(cm_c[0] - cm_g[0], cm_c[1] - cm_g[1], 0.0);
            fragTofix.transform(T);
            DPoint3 o = new DPoint3(cm_c[0], cm_c[1], 0.0);
            int n = 36;
            int min_angle = Clean2D.rotateToMinDist(fragTofix, o, n, mcsgIdx, cIdx, T, fixedFrag, m);
            T.setRotation(0.0, 0.0, 1.0, Math.PI * 2 / (double)n * (double)(min_angle + 1));
            T.setRotationCenter(o);
            fragTofix.transform(T);
            for (int i = 0; i < l; ++i) {
                MulticenterSgroup mcsg = (MulticenterSgroup)m.getSgroup(mcsgIdx.get(i));
                cm_s[i] = Clean2D.calcCM(mcsg);
                MolAtom a = fixedFrag.getAtom(cIdx.get(i));
                a.setXYZ(cm_s[i][0], cm_s[i][1], a.getZ());
            }
        } else if (Error == 1) {
            System.err.println("Some unexpected situation during multicenter arrangement");
        }
    }

    static int rotateToMinDist(MoleculeGraph f, DPoint3 o, int n, IntVector mcsgIdx, IntVector cIdx, CTransform3D T, MoleculeGraph fixed, Molecule m) {
        int min_angle = 0;
        double dist_min = Double.MAX_VALUE;
        T.setIdentity();
        T.setRotation(0.0, 0.0, 1.0, Math.PI * 2 / (double)n);
        T.setRotationCenter(o);
        for (int i = 0; i < n; ++i) {
            f.transform(T);
            double d = Clean2D.getDist(mcsgIdx, m, cIdx, fixed);
            if (!(d < dist_min)) continue;
            dist_min = d;
            min_angle = i;
        }
        return min_angle;
    }

    static void arrangeCentralAtomFragsAround(MoleculeGraph[] f, MoleculeGraph s, int fixedID, Molecule m, int[] fragsID) {
        int i;
        CTransform3D T = new CTransform3D();
        IntVector sgroupIdx = new IntVector();
        for (int i2 = 0; i2 < m.getSgroupCount(); ++i2) {
            Sgroup sg = m.getSgroup(i2);
            if (!(sg instanceof MulticenterSgroup)) continue;
            int sgac = sg.getAtomCount();
            for (int j = 0; j < sgac; ++j) {
                if (sgroupIdx.contains(i2)) continue;
                sgroupIdx.add(i2);
            }
        }
        int sgl = sgroupIdx.size();
        int[] groups = new int[sgl];
        int[] groupc = new int[sgl + 1];
        int[] centralAtom = new int[sgl];
        int[] fragIdx = new int[sgl];
        int n = 0;
        for (i = 0; i < sgl; ++i) {
            int id_toFix;
            int idx;
            MulticenterSgroup mcsg = (MulticenterSgroup)m.getSgroup(sgroupIdx.get(i));
            double[] cm = Clean2D.calcCM(mcsg);
            MolAtom ca = mcsg.getCentralAtom();
            centralAtom[i] = idx = m.indexOf(ca);
            fragIdx[i] = id_toFix = fragsID[idx];
            MoleculeGraph fragTofix = f[id_toFix];
            Clean2D.increaseCoordBondLength(fragTofix, 0.5);
            T.setIdentity();
            T.setTranslation(cm[0] - ca.getX(), cm[1] - ca.getY(), 0.0);
            fragTofix.transform(T);
            for (int j = 0; j < i; ++j) {
                MolAtom a = m.getAtom(centralAtom[j]);
                double d2 = Clean2D.dist2(ca, a);
                if (!(d2 < 0.154)) continue;
                groups[i] = groups[j];
                int n2 = j;
                groupc[n2] = groupc[n2] + 1;
                break;
            }
            if (groups[i] == 0) {
                groups[i] = ++n;
                int n3 = i;
                groupc[n3] = groupc[n3] + 1;
            }
            if (ca.getBondCount() > 0) {
                double fi = Clean2D.calcNeededAngle(mcsg, cm);
                DPoint3 o = ca.getLocation();
                MolAtom l = ca.getLigand(0);
                double fi_0 = o.angle2D(l.getX(), l.getY());
                T.setIdentity();
                T.setRotation(0.0, 0.0, 1.0, fi - fi_0);
                T.setRotationCenter(o);
                fragTofix.transform(T);
            }
            s.getAtom(id_toFix).setZ(2.0);
        }
        for (i = 0; i < sgl; ++i) {
            int count = groupc[i];
            if (count > 1) {
                int g = groups[i];
                double dfi = 0.0;
                if (count % 2 == 1) {
                    n = 1;
                } else {
                    n = 0;
                    dfi = 0.39269908169872414;
                }
                for (int j = i; j < sgl; ++j) {
                    MolAtom a;
                    if (g != groups[j] || (a = m.getAtom(centralAtom[j])).getBondCount() <= 0) continue;
                    DPoint3 o = a.getLocation();
                    MolAtom l = a.getLigand(0);
                    MoleculeGraph fragTofix = f[fragIdx[j]];
                    T.setIdentity();
                    T.setTranslation((l.getX() - a.getX()) / 4.0, (l.getY() - a.getY()) / 4.0, 0.0);
                    fragTofix.transform(T);
                    int pm = n % 2 == 0 ? 1 : -1;
                    T.setRotation(0.0, 0.0, 1.0, (double)(pm * (n / 2)) * Math.PI / 4.0 + (double)pm * dfi);
                    T.setRotationCenter(o);
                    fragTofix.transform(T);
                    groupc[j] = 0;
                    ++n;
                }
            }
            groupc[i] = 0;
        }
        for (i = 0; i < sgl; ++i) {
            int fid = fragIdx[i];
            boolean fragHasMoreConnection = false;
            for (int j = i + 1; j < sgl; ++j) {
                if (fragIdx[j] != fid) continue;
                fragHasMoreConnection = true;
                break;
            }
            if (!fragHasMoreConnection) continue;
            MoleculeGraph attached = f[fid];
            MoleculeGraph fixed = f[fixedID];
            MolAtom a0 = fixed.getAtom(0);
            MolAtom a1 = fixed.getAtomCount() > 1 ? fixed.getAtom(1) : null;
            DPoint3 p0 = a0.getLocation();
            DPoint3 p1 = a1 != null ? a1.getLocation() : null;
            Clean2D.fixMcSgFrag(fixedID, fid, f, m, fragsID);
            T.setIdentity();
            T.setTranslation(a0.getX() - p0.x, a0.getY() - p0.y, 0.0);
            fixed.transform(T);
            attached.transform(T);
            if (a1 == null) continue;
            double fi = p0.angle2D(p1.x, p1.y) - p0.angle2D(a1.getX(), a1.getY());
            T.setRotation(0.0, 0.0, 1.0, fi);
            T.setRotationCenter(p0);
            fixed.transform(T);
            attached.transform(T);
        }
    }

    static double calcNeededAngle(MulticenterSgroup m, double[] cm) {
        int ac = m.getAtomCount();
        if (ac < 3) {
            double[] cm2 = new double[2];
            int n = 0;
            for (int j = 0; j < m.getAtomCount(); ++j) {
                MolAtom a = m.getAtom(j);
                for (int i = 0; i < a.getBondCount(); ++i) {
                    MolAtom l = a.getLigand(i);
                    if (m.hasAtom(l)) continue;
                    cm2[0] = cm2[0] + l.getX();
                    cm2[1] = cm2[1] + l.getY();
                    ++n;
                }
            }
            cm2[0] = cm2[0] / (double)n;
            cm2[1] = cm2[1] / (double)n;
            if (Clean2D.dist2(cm, cm2) < 0.077) {
                return 0.0;
            }
            DPoint3 o = new DPoint3(cm2[0], cm2[1], 0.0);
            double fi = o.angle2D(cm[0], cm[1]);
            return fi;
        }
        double[] cm2 = new double[2];
        int n = 0;
        for (int i = 0; i < ac; ++i) {
            MolAtom a = m.getAtom(i);
            int nn = 0;
            for (int j = 0; j < a.getBondCount() && nn < 2; ++j) {
                MolAtom l = a.getLigand(j);
                if (!m.hasAtom(l)) continue;
                ++nn;
            }
            if (nn <= 1) continue;
            ++n;
            cm2[0] = cm2[0] + a.getX();
            cm2[1] = cm2[1] + a.getY();
        }
        cm2[0] = cm2[0] / (double)n;
        cm2[1] = cm2[1] / (double)n;
        if (Clean2D.dist2(cm, cm2) < 0.077) {
            return 0.0;
        }
        DPoint3 o = new DPoint3(cm[0], cm[1], 0.0);
        return o.angle2D(cm2[0], cm2[1]);
    }

    static double slope(MolAtom[] a) {
        double s = 0.0;
        int l = a.length;
        double x0 = a[0].getX();
        double y0 = a[0].getY();
        for (int i = 1; i < l; ++i) {
            s += (a[i].getY() - y0) / (a[i].getX() - x0);
        }
        return s /= (double)(l - 1);
    }

    static double getDist(IntVector mcsgIdx, Molecule m, IntVector cIdx, MoleculeGraph fixedFrag) {
        double d = 0.0;
        for (int i = 0; i < mcsgIdx.size(); ++i) {
            MolAtom a = fixedFrag.getAtom(cIdx.get(i));
            double x = a.getX();
            double y = a.getY();
            int idx = mcsgIdx.get(i);
            MulticenterSgroup mcsg = (MulticenterSgroup)m.getSgroup(idx);
            for (int j = 0; j < mcsg.getAtomCount(); ++j) {
                MolAtom sa = mcsg.getAtom(j);
                double dx = x - sa.getX();
                double dy = y - sa.getY();
                d += dx * dx + dy * dy;
            }
        }
        return d;
    }

    static int connectToFrag(MolAtom a, int id, Molecule m, int[] fragsID) {
        MulticenterSgroup mcsg = m.findContainingMulticenterSgroup(a);
        MolAtom sa = mcsg.getAtom(0);
        int idx = m.indexOf(sa);
        if (fragsID[idx] == id) {
            return m.indexOf(mcsg);
        }
        return -1;
    }

    static void increaseCoordBondLength(MoleculeGraph m, double f) {
        DPoint3 c = m.calcCenter();
        CTransform3D T = new CTransform3D();
        for (int i = m.getBondCount() - 1; i >= 0; --i) {
            MolBond b = m.getBond(i);
            MolAtom a1 = b.getAtom1();
            MolAtom a2 = b.getAtom2();
            if (a1.getAtno() == 137) {
                T.setTranslation((a1.getX() - a2.getX()) * f, (a1.getY() - a2.getY()) * f, 0.0);
                a1.transform(T, false);
                continue;
            }
            if (a2.getAtno() != 137) continue;
            T.setTranslation((a2.getX() - a1.getX()) * f, (a2.getY() - a1.getY()) * f, 0.0);
            a2.transform(T, false);
        }
        DPoint3 c_new = m.calcCenter();
        T.setTranslation(c.x - c_new.x, c.y - c_new.y, 0.0);
        m.transform(T);
    }

    static double[] calcCM(BitSet s, MoleculeGraph m) {
        double[] cm = new double[2];
        int l = s.length();
        int n = 0;
        for (int i = 0; i < l; ++i) {
            if (!s.get(i)) continue;
            MolAtom a = m.getAtom(i);
            cm[0] = cm[0] + a.getX();
            cm[1] = cm[1] + a.getY();
            ++n;
        }
        cm[0] = cm[0] / (double)n;
        cm[1] = cm[1] / (double)n;
        return cm;
    }

    static double[] calcCM(Sgroup s) {
        double[] cm = new double[2];
        int l = s.getAtomCount();
        for (int i = 0; i < l; ++i) {
            MolAtom a = s.getAtom(i);
            cm[0] = cm[0] + a.getX();
            cm[1] = cm[1] + a.getY();
        }
        cm[0] = cm[0] / (double)l;
        cm[1] = cm[1] / (double)l;
        return cm;
    }

    static double[] calcCM(double[] c) {
        double[] cm = new double[2];
        for (int i = c.length - 1; i >= 0; --i) {
            cm[1] = cm[1] + c[i];
            cm[0] = cm[0] + c[--i];
        }
        cm[0] = cm[0] / (double)(c.length / 2);
        cm[1] = cm[1] / (double)(c.length / 2);
        return cm;
    }

    static double[] calcCM(double[] c, int[] r, BitSet s) {
        double[] cm = new double[2];
        for (int i = r.length - 1; i >= 0; --i) {
            if (!s.get(r[i])) continue;
            cm[1] = cm[1] + c[i * 2];
            cm[0] = cm[0] + c[i * 2 + 1];
        }
        cm[0] = cm[0] / (double)(c.length / 2);
        cm[1] = cm[1] / (double)(c.length / 2);
        return cm;
    }

    static boolean setParityFromFlags(MoleculeGraph m, boolean useActualWedges) {
        int ac = m.getAtomCount();
        int[] p = null;
        if (m instanceof Molecule && ((Molecule)m).isExpandable(0)) {
            Molecule molecule = (Molecule)m;
            Molecule molc = (Molecule)molecule.clone();
            molc.expandSgroups(8);
            p = new int[molc.getAtomCount()];
        } else {
            p = new int[ac];
        }
        for (int i = 0; i < ac; ++i) {
            p[i] = m.getAtom(i).getFlags() & 7;
        }
        return m.setParity(p, useActualWedges);
    }

    static boolean hasBondBetween(MolAtom a1, MolAtom a2) {
        int l = a1.getBondCount();
        for (int i = 0; i < l; ++i) {
            if (a1.getLigand(i) != a2) continue;
            return true;
        }
        return false;
    }

    static int[] hasCoincidence(MoleculeGraph m, int[] atomFlags, int[][] d, int[][] pred, int[] fragID, double distLimit2) {
        int[] coll = new int[2];
        if (Clean2D.coincidingAtoms(-1, m, fragID, distLimit2, coll)) {
            int i = coll[0];
            int j = coll[1];
            int pathL = d[i][j];
            int[] path = new int[pathL + 1];
            Clean2D.getPath(i, j, path, pred);
            return path;
        }
        if (Clean2D.coincidingBonds(-1, m, fragID, distLimit2, coll)) {
            MolBond b1 = m.getBond(coll[0]);
            int[] n = new int[4];
            n[0] = m.indexOf(b1.getAtom1());
            n[1] = m.indexOf(b1.getAtom2());
            MolBond b2 = m.getBond(coll[1]);
            n[2] = m.indexOf(b2.getAtom1());
            n[3] = m.indexOf(b2.getAtom2());
            int idx1 = -1;
            int idx2 = -1;
            int pathL = -1;
            for (int i = 0; i < 2; ++i) {
                for (int j = 2; j < 4; ++j) {
                    if (d[n[i]][n[j]] <= pathL) continue;
                    pathL = d[n[i]][n[j]];
                    idx1 = n[i];
                    idx2 = n[j];
                }
            }
            int[] path = new int[pathL + 1];
            Clean2D.getPath(idx1, idx2, path, pred);
            return path;
        }
        return null;
    }

    static boolean checkCoincidence(int s, int e, int fixed, IntVector startIndexes, int[] fragID, int[] atomFlags, MoleculeGraph m, double coll_dist_sq) {
        boolean c = false;
        int id = -1;
        for (int i = s; i < e; ++i) {
            if (!c && fixed == startIndexes.get(i)) {
                if (c |= Clean2D.coincidingAtoms(id = fragID[startIndexes.get(++i)] & 0xFFFF, m, fragID, coll_dist_sq, null)) {
                    return true;
                }
                if (!(c |= Clean2D.coincidingBonds(id, m, fragID, coll_dist_sq, null))) continue;
                return true;
            }
            return c;
        }
        return c;
    }

    static boolean checkCoincidence(BitSet s, BitSet b, int[] fragID, MoleculeGraph m, double coll_dist_sq) {
        int i = s.nextSetBit(0);
        while (i >= 0) {
            if (Clean2D.atomCoincidence(i, m, fragID, coll_dist_sq, null)) {
                return true;
            }
            i = s.nextSetBit(i + 1);
        }
        i = b.nextSetBit(0);
        while (i >= 0) {
            if (Clean2D.bondCoincidence(i, m, fragID, coll_dist_sq, null)) {
                return true;
            }
            i = b.nextSetBit(i + 1);
        }
        return false;
    }

    static boolean coincidingBonds(int fid, MoleculeGraph m, int[] fragID, double distLimit2, int[] cb) {
        int bc = m.getBondCount();
        for (int i = 0; i < bc; ++i) {
            MolAtom a1_2;
            int idx2;
            int fID2;
            int fid1;
            MolBond b1 = m.getBond(i);
            MolAtom a1_1 = b1.getAtom1();
            int idx1 = m.indexOf(a1_1);
            int fID1 = fragID[idx1] & 0xFFFF;
            int n = fid1 = fID1 == (fID2 = fragID[idx2 = m.indexOf(a1_2 = b1.getAtom2())] & 0xFFFF) ? fID1 : -1;
            if (fid != -1 && fID1 != fid && fID2 != fid || a1_1.getZ() != 2.0 || a1_2.getZ() != 2.0) continue;
            for (int j = 0; j < bc; ++j) {
                MolAtom a2_2;
                int idx4;
                int fID4;
                int fid2;
                MolBond b2 = m.getBond(j);
                MolAtom a2_1 = b2.getAtom1();
                int idx3 = m.indexOf(a2_1);
                int fID3 = fragID[idx3] & 0xFFFF;
                int n2 = fid2 = fID3 == (fID4 = fragID[idx4 = m.indexOf(a2_2 = b2.getAtom2())] & 0xFFFF) ? fID3 : -1;
                if (idx1 == idx3 || idx1 == idx4 || idx2 == idx3 || idx2 == idx4 || a2_1.getZ() != 2.0 || a2_2.getZ() != 2.0 || fid1 != -1 && fid1 == fid2) continue;
                boolean common3FragId = Clean2D.common3(fID1, fID2, fID3, fID4);
                if (!Clean2D.crossing(b1, b2) && (common3FragId || !(Clean2D.calcDist(b1, b2) < distLimit2))) continue;
                if (cb != null) {
                    cb[0] = i;
                    cb[1] = j;
                }
                return true;
            }
        }
        return false;
    }

    static boolean bondCoincidence(int idx, MoleculeGraph m, int[] fragID, double distLimit2, int[] cb) {
        MolAtom a1_2;
        int idx2;
        int fID2;
        int bc = m.getBondCount();
        MolBond b1 = m.getBond(idx);
        MolAtom a1_1 = b1.getAtom1();
        int idx1 = m.indexOf(a1_1);
        int fID1 = fragID[idx1] & 0xFFFF;
        int fid1 = fID1 == (fID2 = fragID[idx2 = m.indexOf(a1_2 = b1.getAtom2())] & 0xFFFF) ? fID1 : -1;
        for (int i = 0; i < bc; ++i) {
            MolAtom a2_2;
            int idx4;
            int fID4;
            int fid2;
            MolBond b2 = m.getBond(i);
            MolAtom a2_1 = b2.getAtom1();
            int idx3 = m.indexOf(a2_1);
            int fID3 = fragID[idx3] & 0xFFFF;
            int n = fid2 = fID3 == (fID4 = fragID[idx4 = m.indexOf(a2_2 = b2.getAtom2())] & 0xFFFF) ? fID3 : -1;
            if (idx1 == idx3 || idx1 == idx4 || idx2 == idx3 || idx2 == idx4 || a2_1.getZ() != 2.0 || a2_2.getZ() != 2.0 || fid1 != -1 && fid1 == fid2) continue;
            boolean common3FragId = Clean2D.common3(fID1, fID2, fID3, fID4);
            if (!Clean2D.crossing(b1, b2) && (common3FragId || !(Clean2D.calcDist(b1, b2) < distLimit2))) continue;
            if (cb != null) {
                cb[0] = idx;
                cb[1] = i;
            }
            return true;
        }
        return false;
    }

    static boolean bondCross(MolBond bond, MoleculeGraph m) {
        int bc = m.getBondCount();
        for (int i = 0; i < bc; ++i) {
            MolBond b = m.getBond(i);
            if (Clean2D.hasCommonAtom(b, bond) || !Clean2D.crossing(b, bond)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasCommonAtom(MolBond e1, MolBond e2) {
        MolAtom n1 = e1.getAtom1();
        MolAtom n2 = e1.getAtom2();
        MolAtom n3 = e2.getAtom1();
        MolAtom n4 = e2.getAtom2();
        return n1 == n3 || n1 == n4 || n2 == n3 || n2 == n4;
    }

    public static boolean coincidingAtoms(int fid, MoleculeGraph m, int[] fragID, double distLimit2, int[] ca) {
        int ac = m.getAtomCount();
        int id1 = -1;
        for (int i = 0; i < ac; ++i) {
            MolAtom a1 = m.getAtom(i);
            if ((fragID == null || (id1 = fragID[i] & 0xFFFF) != fid) && fid != -1 || a1.getZ() != 2.0) continue;
            for (int j = 0; j < ac; ++j) {
                double d2;
                MolAtom a2 = m.getAtom(j);
                if (a2.getZ() != 2.0 || fragID != null && (fragID[j] & 0xFFFF) == id1 || !((d2 = Clean2D.dist2(a1, a2)) < distLimit2)) continue;
                if (ca != null) {
                    ca[0] = i;
                    ca[1] = j;
                }
                return true;
            }
        }
        return false;
    }

    static boolean coincidingAtoms(int fid, MoleculeGraph m, int[] fragID, double distLimit2) {
        int ac = m.getAtomCount();
        int id1 = -1;
        for (int i = 0; i < ac; ++i) {
            MolAtom a1 = m.getAtom(i);
            id1 = fragID[i] & 0xFFFF;
            if (id1 != fid) continue;
            for (int j = 0; j < ac; ++j) {
                double d2;
                MolAtom a2 = m.getAtom(j);
                if (i == j || (fragID[j] & 0xFFFF) != id1 || !((d2 = Clean2D.dist2(a1, a2)) < distLimit2)) continue;
                return true;
            }
        }
        return false;
    }

    static boolean atomCoincidence(int idx, MoleculeGraph m, int[] fragID, double distLimit2, int[] ca) {
        int ac = m.getAtomCount();
        MolAtom a1 = m.getAtom(idx);
        int id1 = fragID[idx] & 0xFFFF;
        for (int i = 0; i < ac; ++i) {
            double d2;
            MolAtom a2 = m.getAtom(i);
            if (i == idx || a2.getZ() != 2.0 || fragID != null && (fragID[i] & 0xFFFF) == id1 || !((d2 = Clean2D.dist2(a1, a2)) < distLimit2)) continue;
            if (ca != null) {
                ca[0] = idx;
                ca[1] = i;
            }
            return true;
        }
        return false;
    }

    static double getDistanceSqSumms(MoleculeGraph m, int[] atomFlags) {
        int ac = m.getAtomCount();
        double sum = 0.0;
        for (int i = 0; i < ac; ++i) {
            MolAtom a1 = m.getAtom(i);
            int f1 = atomFlags[i];
            if (a1.getZ() != 2.0) continue;
            double x1 = a1.getX();
            double y1 = a1.getY();
            for (int j = i + 1; j < ac; ++j) {
                double yd;
                MolAtom a2 = m.getAtom(j);
                int f2 = atomFlags[j];
                if (a2.getZ() != 2.0) continue;
                double xd = x1 - a2.getX();
                double d = xd * xd + (yd = y1 - a2.getY()) * yd;
                if (d < 0.06587777777777777) {
                    boolean terminal2;
                    d = 0.06587777777777777;
                    boolean terminal1 = (f1 & 4) == 4;
                    boolean bl = terminal2 = (f2 & 4) == 4;
                    if (terminal1) {
                        d *= 1.5;
                    }
                    if (terminal2) {
                        d *= 1.5;
                    }
                }
                sum += 1.0 / d;
            }
        }
        return sum;
    }

    static boolean bondLengthAcceptable(double t, MoleculeGraph m) {
        double t2 = t * t;
        for (int i = m.getBondCount() - 1; i >= 0; --i) {
            MolAtom a2;
            MolBond b = m.getBond(i);
            MolAtom a1 = b.getAtom1();
            if (!(Math.abs(Clean2D.dist2(a1, a2 = b.getAtom2()) - 2.3716) > t2)) continue;
            return false;
        }
        return true;
    }

    static void changeInternalAngleAtFixed(int idx, int[] atomFlags, int[] fragID, double[][] intang, int[][] ctab, BondTable btab, BitSet s, MoleculeGraph m, int Debug2) {
        Clean2D.setFragmentTo(1.0, s, m);
        Clean2D.changeInternalAngleAtFixed(idx, atomFlags, fragID, intang, ctab, btab, m, Debug2);
    }

    static void changeInternalAngleAtFixed(int idx, int[] atomFlags, int[] fragID, double[][] intang, int[][] ctab, BondTable btab, MoleculeGraph m, int Debug2) {
        int[] an = ctab[idx];
        int anl = an.length;
        int f = atomFlags[idx];
        int id = fragID[idx] & 0xFFFF;
        if (Debug2 > 5) {
            System.err.println("        changeInternalAngleAtFixed " + (idx + 1));
        }
        if ((f & 1) != 0 && Clean2D.hasNonfixedRingAtom(idx, id, an, atomFlags, fragID, m)) {
            int from = -1;
            for (int i = an.length - 1; i >= 0 && from < 0; --i) {
                int l = an[i];
                MolAtom a = m.getAtom(l);
                if (a.getZ() != 2.0) continue;
                from = l;
            }
            if (from == -1) {
                if (Error == 1) {
                    System.err.println("No from atom found for ring flip");
                }
                return;
            }
            Clean2D.flipRingCoordinatesAndIntAngs(idx, from, ctab, btab, fragID, intang, atomFlags, m);
            if (Debug2 > 5) {
                System.err.println("        Ring Internal Angle changed");
            }
            return;
        }
        if ((f & 0x400) != 0) {
            if (Debug2 > 5) {
                System.err.println("        " + (idx + 1) + " STEREOATOM flip");
            }
            int sid = fragID[idx] >> 16;
            for (int i = 0; i < anl; ++i) {
                int f_l;
                int l = an[i];
                int sid_l = fragID[l] >> 16;
                if (sid != sid_l) continue;
                if (Debug2 > 5) {
                    System.err.println("also flip STEREOATOM " + (l + 1));
                }
                if (((f_l = atomFlags[l]) & 1) != 0) {
                    int ac = ctab.length;
                    BitSet needToTransform = new BitSet(ac);
                    needToTransform.set(idx);
                    Clean2D.recursiveSelectAtomToTransformation(l, ctab, needToTransform);
                    needToTransform.clear(idx);
                    for (int j = 0; j < ac; ++j) {
                        if (!needToTransform.get(j)) continue;
                        MolAtom a = m.getAtom(j);
                        if (a.getZ() == 2.0) {
                            a.setZ(1.0);
                            continue;
                        }
                        needToTransform.clear(j);
                    }
                    MolAtom a = m.getAtom(l);
                    a.setZ(2.0);
                    BitSet flipped = Clean2D.flipRingCoordinatesAndIntAngs(l, idx, ctab, btab, fragID, intang, atomFlags, m);
                    needToTransform.andNot(flipped);
                    CTransform3D T = Clean2D.getFlippingTrasformation(l, idx, m);
                    int j = needToTransform.nextSetBit(0);
                    while (j >= 0) {
                        if (needToTransform.get(j)) {
                            MolAtom tr = m.getAtom(j);
                            tr.transform(T, false);
                            tr.setZ(2.0);
                        }
                        j = needToTransform.nextSetBit(j + 1);
                    }
                    a.setZ(1.0);
                    break;
                }
                Clean2D.flipInternalAngle(l, ctab[l], btab, intang);
                break;
            }
        }
        if (anl < 4) {
            Clean2D.flipInternalAngle(idx, an, btab, intang);
        } else {
            int i;
            int nonf = anl - Clean2D.fixedLigandCount(m.getAtom(idx));
            int fixeda = 0;
            int fixedb = 0;
            int[] nonfixedb = new int[nonf];
            int[] nonfixeda = new int[nonf];
            double[] intangf = new double[nonf];
            int nf = 0;
            for (i = 0; i < anl; ++i) {
                int l = an[i];
                if (m.getAtom(l).getZ() == 2.0) {
                    fixedb = btab.getBondIndex(idx, l);
                    fixeda = l;
                    continue;
                }
                nonfixedb[nf] = btab.getBondIndex(idx, l);
                nonfixeda[nf] = l;
                ++nf;
            }
            for (i = 0; i < nf; ++i) {
                intangf[i] = intang[fixedb][nonfixedb[i]];
            }
            for (i = 0; i < nf; ++i) {
                intang[fixedb][nonfixedb[(i + 1) % nf]] = intangf[i];
            }
            Clean2D.resolveIntAngFromReference(fixeda, idx, btab, an, intang);
        }
    }

    static BitSet flipRingCoordinatesAndIntAngs(int idx, int from, int[][] ctab, BondTable btab, int[] fragID, double[][] intang, int[] atomFlags, MoleculeGraph m) {
        int id = fragID[idx] & 0xFFFF;
        int ac = ctab.length;
        boolean[] done = new boolean[ac];
        for (int i = 0; i < ac; ++i) {
            int fID = fragID[i] & 0xFFFF;
            if (fID != id) continue;
            Clean2D.flipInternalAngle(i, ctab[i], btab, intang);
            if (m.getAtom(i).getZ() == 2.0) continue;
            Clean2D.recursiveIntangChange(i, intang, ctab, btab, atomFlags, done);
        }
        CTransform3D T = Clean2D.getFlippingTrasformation(idx, from, m);
        BitSet flipped = new BitSet(ac);
        for (int i = ac - 1; i >= 0; --i) {
            int lid = fragID[i] & 0xFFFF;
            if (lid != id) continue;
            flipped.set(i);
            MolAtom a = m.getAtom(i);
            a.transform(T, false);
            a.setZ(2.0);
        }
        return flipped;
    }

    static void recursiveIntangChange(int idx, double[][] intang, int[][] ctab, BondTable btab, int[] atomFlags, boolean[] done) {
        done[idx] = true;
        for (int lig : ctab[idx]) {
            if (done[lig] || (atomFlags[lig] & 1) != 0) continue;
            Clean2D.flipInternalAngle(lig, ctab[lig], btab, intang);
            Clean2D.recursiveIntangChange(lig, intang, ctab, btab, atomFlags, done);
        }
    }

    static void flipInternalAngle(int idx, int[] an, BondTable btab, double[][] intang) {
        int ac = an.length;
        for (int i = 0; i < ac; ++i) {
            int b0 = btab.getBondIndex(an[i], idx);
            for (int j = i + 1; j < ac; ++j) {
                int b1 = btab.getBondIndex(an[j], idx);
                double fi = intang[b0][b1];
                intang[b0][b1] = -fi;
                intang[b1][b0] = fi;
            }
        }
    }

    static CTransform3D getFlippingTrasformation(int i1, int i2, MoleculeGraph m) {
        MolAtom a1 = m.getAtom(i1);
        MolAtom a2 = m.getAtom(i2);
        DPoint3 p1 = a1.getLocation();
        DPoint3 p2 = a2.getLocation();
        return Clean2D.getFlippingTrasformation(p1, p2);
    }

    static CTransform3D getFlippingTrasformation(DPoint3 p1, DPoint3 p2) {
        CTransform3D T = new CTransform3D();
        T.setRotation(p1.x - p2.x, p1.y - p2.y, 0.0, Math.PI);
        T.setRotationCenter(p1);
        return T;
    }

    static void flipCoordinatesWithId(DPoint3 p1, DPoint3 p2, int id, int[] fragID, MoleculeGraph m) {
        CTransform3D T = Clean2D.getFlippingTrasformation(p1, p2);
        for (int i = m.getAtomCount() - 1; i >= 0; --i) {
            int lid = fragID[i] & 0xFFFF;
            if (lid != id) continue;
            MolAtom a = m.getAtom(i);
            boolean fixed = a.getZ() == 2.0;
            a.transform(T, false);
            if (fixed) {
                a.setZ(2.0);
                continue;
            }
            a.setZ(1.0);
        }
    }

    MoleculeGraph cloneAndInitialize(MoleculeGraph m) {
        MolAtom a;
        MoleculeGraph umol = m.getGraphUnion();
        if (this.addHydrogensToChiralAtoms) {
            int i;
            int[][] localctab = umol.getCtab();
            int l = localctab.length;
            int[] c = new int[l];
            for (i = 0; i < l; ++i) {
                c[i] = umol.getParity(i);
            }
            if (!this.useStereoFromFlags) {
                for (i = 0; i < l; ++i) {
                    a = m.getAtom(i);
                    if (c[i] <= 0) continue;
                    a.setFlags(c[i], 7);
                }
            }
            for (i = 0; i < l; ++i) {
                MolAtom center;
                if (c[i] != 1 && c[i] != 2 || (center = umol.getAtom(i)).getImplicitHcount() <= 0) continue;
                boolean terminalLigand = false;
                int[] an = localctab[i];
                for (int j = 0; j < an.length; ++j) {
                    int ligandIdx = an[j];
                    if (localctab[ligandIdx].length != 1) continue;
                    terminalLigand = true;
                    break;
                }
                if (terminalLigand) continue;
                MolAtom H = new MolAtom(1);
                umol.add(H);
                umol.add(new MolBond(center, H, 1));
            }
        }
        MoleculeGraph mol = new MoleculeGraph();
        umol.clonecopy(mol);
        for (int i = mol.getAtomCount() - 1; i >= 0; --i) {
            MolAtom a2 = mol.getAtom(i);
            a2.setAtomMap(0);
        }
        Clean2D.electronFlowSetup(m, umol, mol);
        Clean2D.multicenterBondSetup(m, mol);
        if (this.partialCleanForMolecules) {
            for (int fixIdx : this.fixedAtoms) {
                a = mol.getAtom(fixIdx);
                a.setAtomMap(2);
            }
        }
        return mol;
    }

    static void electronFlowSetup(MoleculeGraph m, MoleculeGraph umol, MoleculeGraph mol) {
        MDocument mrvDoc = m.getDocument();
        if (mrvDoc != null) {
            int objCount = mrvDoc.getObjectCount();
            for (int i = 0; i < objCount; ++i) {
                MolAtom sink1;
                MObject obj = mrvDoc.getObject(i);
                if (!(obj instanceof MEFlow)) continue;
                MEFlow eflow = (MEFlow)obj;
                Object sink = eflow.getMolObject(1);
                if (sink instanceof MolAtom[]) {
                    MolAtom[] sinkAtoms = (MolAtom[])sink;
                    sink1 = mol.getAtom(umol.indexOf(sinkAtoms[0]));
                    MolAtom sink2 = mol.getAtom(umol.indexOf(sinkAtoms[1]));
                    MolBond mockBond = new MolBond(sink1, sink2, 0);
                    mol.add(mockBond);
                    continue;
                }
                if (!(sink instanceof MolAtom)) continue;
                MolAtom sinkAtom = (MolAtom)sink;
                sink1 = mol.getAtom(umol.indexOf(sinkAtom));
                Object source = eflow.getMolObject(0);
                if (!(source instanceof MolAtom)) continue;
                MolAtom sourceAtom = (MolAtom)source;
                MolAtom source1 = mol.getAtom(umol.indexOf(sourceAtom));
                MolBond mockBond = new MolBond(source1, sink1, 0);
                mol.add(mockBond);
            }
        }
    }

    static void multicenterBondSetup(MoleculeGraph m_orig, MoleculeGraph mol) {
        if (m_orig instanceof Molecule) {
            Molecule m = (Molecule)m_orig;
            MolBond[] bondCorr = mol.getBondArray();
            for (int i = 0; i < m.getSgroupCount(); ++i) {
                Sgroup sg = m.getSgroup(i);
                if (!(sg instanceof MulticenterSgroup)) continue;
                MulticenterSgroup mcsg = (MulticenterSgroup)sg;
                MolAtom ca = mcsg.getCentralAtom();
                int bc = ca.getBondCount();
                for (int j = 0; j < bc; ++j) {
                    MolBond mcb = ca.getBond(j);
                    MolAtom closingAtom = Clean2D.isClosedPath(mcb, ca, m, mol, mcsg);
                    if (closingAtom == null) continue;
                    MolAtom ca_mol = mol.getAtom(m.indexOf(ca));
                    int mcb_idx = m.indexOf(mcb);
                    MolBond mcb_mol = bondCorr[mcb_idx];
                    MolAtom a2 = mcb_mol.getOtherAtom(ca_mol);
                    MolBond bnew = new MolBond(a2, closingAtom, mcb.getFlags());
                    mol.add(bnew);
                    bondCorr[mcb_idx] = bnew;
                    mol.removeBond(mcb_mol);
                }
            }
        }
    }

    static MolBond locateBond(MolBond b, Molecule m, MoleculeGraph mol) {
        int a1 = m.indexOf(b.getAtom1());
        int a2 = m.indexOf(b.getAtom2());
        BondTable btab = mol.getBondTable();
        int bidx = btab.getBondIndex(a1, a2);
        return bidx >= 0 ? mol.getBond(bidx) : null;
    }

    static MolAtom isClosedPath(MolBond b, MolAtom ca, Molecule m, MoleculeGraph mol, MulticenterSgroup mcsg) {
        MolAtom endp1 = b.getOtherAtom(ca);
        int ep = m.indexOf(endp1 = Clean2D.replaceCenterAtomWithSgroupAtom(endp1, m));
        if (ep < 0 && Error == 1) {
            System.err.println("Some problem during multicenterBondSetup, close path finding");
            return null;
        }
        int mcsg_ac = mcsg.getAtomCount();
        BitSet mset = new BitSet(mcsg_ac);
        for (int i = 0; i < mcsg_ac; ++i) {
            MolAtom a = mcsg.getAtom(i);
            if (a == ca) continue;
            int idx = m.indexOf(a);
            if (idx >= 0) {
                mset.set(idx);
                continue;
            }
            if (Error != 1) continue;
            System.err.println("Some problem during multicenterBondSetup, multicenter atom identification");
        }
        int[][] ctab = mol.getCtab();
        IntVector cp = new IntVector();
        BitSet used = new BitSet(mol.getAtomCount());
        used.set(ep);
        Clean2D.backTrack(ep, ctab, used, cp, mset);
        if (cp.size() != 1) {
            return null;
        }
        MolAtom sgroupConn = m.getAtom(cp.get(0));
        int sgConn = mcsg.indexOf(sgroupConn);
        int ac = mcsg.getAtomCount();
        boolean[] lSet = new boolean[ac];
        boolean[] set = new boolean[ac];
        int[] d = new int[]{1, 1};
        int[][] mcctab = Clean2D.getCtab(mcsg);
        int longestChainLength = Clean2D.getLongestChainSet(sgConn, d, mcctab, lSet, set, null);
        int c_idx = Clean2D.getElemenetAt(sgConn, longestChainLength / 2, lSet, mcctab);
        if (c_idx < 0 && Error == 1) {
            System.err.println("Some problem during multicenterBondSetup, center atom location");
            return null;
        }
        int c_idx_in_mol = m.indexOf(mcsg.getAtom(c_idx));
        return mol.getAtom(c_idx_in_mol);
    }

    static MolAtom replaceCenterAtomWithSgroupAtom(MolAtom a, Molecule m) {
        for (int i = 0; i < m.getSgroupCount(); ++i) {
            MulticenterSgroup mcsg;
            MolAtom ca;
            Sgroup sg = m.getSgroup(i);
            if (!(sg instanceof MulticenterSgroup) || (ca = (mcsg = (MulticenterSgroup)sg).getCentralAtom()) != a) continue;
            a = mcsg.getAtom(0);
            break;
        }
        return a;
    }

    static void backTrack(int idx, int[][] ctab, BitSet used, IntVector cp, BitSet set) {
        int[] an = ctab[idx];
        for (int i = 0; i < an.length; ++i) {
            int lig = an[i];
            if (used.get(lig)) continue;
            used.set(lig);
            if (set.get(lig)) {
                cp.add(lig);
            } else {
                Clean2D.backTrack(lig, ctab, used, cp, set);
            }
            used.clear(lig);
        }
    }

    static int getElemenetAt(int idx, int d, boolean[] s, int[][] ctab) {
        if (d == 0) {
            return idx;
        }
        int[] an = ctab[idx];
        for (int i = 0; i < an.length; ++i) {
            int lig = an[i];
            if (!s[lig]) continue;
            return Clean2D.getElemenetAt(lig, d - 1, s, ctab);
        }
        return -1;
    }

    static int[][] getCtab(Sgroup sg) {
        SelectionMolecule sgg = sg.getSgroupGraph();
        return sgg.getCtab();
    }

    static void arrangeHydrogens(MoleculeGraph m, int[][] ctab, BondTable btab, double[][] intang, int[][] atomInRing, boolean[] isRingBond, int[][] cssr, BitSet[] ringBitset, PartialOptimization opt) {
        int ac = m.getAtomCount();
        for (int i = ac - 1; i >= 0; --i) {
            MolAtom a = m.getAtom(i);
            if (a.getBondCount() != 1 || a.getAtno() != 1 || a.getZ() == 2.0) continue;
            int c = ctab[i][0];
            Clean2D.arrangeNonFixedHLigands(c, ctab, btab, m, intang, atomInRing, cssr, ringBitset, isRingBond);
        }
        int[][] d = null;
        int[][] pred = null;
        for (int i = ac - 1; i >= 0; --i) {
            MolAtom a1 = m.getAtom(i);
            if (a1.getBondCount() != 1 || a1.getAtno() != 1) continue;
            for (int j = ac - 1; j >= 0; --j) {
                MolAtom a2;
                double d2;
                if (i == j || !((d2 = Clean2D.dist2(a1, a2 = m.getAtom(j))) < 0.2635111111111111)) continue;
                if (d == null) {
                    pred = new int[ac][ac];
                    d = new int[ac][ac];
                    Clean2D.distanceMatrix(btab, d, pred);
                }
                int[] path = new int[d[i][j] + 1];
                Clean2D.getPath(j, i, path, pred);
                Clean2D.moveAwayAtom(i, j, ctab, btab, intang, m, path);
            }
        }
    }

    static void arrangeNonFixedHLigands(int idx, int[][] ctab, BondTable btab, MoleculeGraph m, double[][] intang, int[][] atomInRing, int[][] cssr, BitSet[] ringBitSet, boolean[] isRingBond) {
        Clean2D.generateIntAngForLigands(idx, ctab, btab, m, intang, atomInRing, cssr, ringBitSet, null, true, isRingBond);
        int[] an = ctab[idx];
        int fromIdx = Clean2D.getOneFixedAtom(idx, an, m);
        if (fromIdx == -1) {
            MolAtom a = m.getAtom(idx);
            fromIdx = an[0];
            MolAtom a2 = m.getAtom(fromIdx);
            MolBond b = m.getBond(btab.getBondIndex(idx, fromIdx));
            double l = m.getDesiredLength(b);
            a2.setXYZ(a.getX() + l, a.getY(), 2.0);
        }
        int b0 = btab.getBondIndex(idx, fromIdx);
        for (int i = an.length - 1; i >= 0; --i) {
            int lidx = an[i];
            MolAtom a = m.getAtom(lidx);
            if (lidx == fromIdx || a.getZ() == 2.0) continue;
            int b1 = btab.getBondIndex(idx, lidx);
            MolBond b = m.getBond(b1);
            double fi = intang[b0][b1];
            Clean2D.setXY(m, m.getAtom(fromIdx), m.getAtom(idx), m.getAtom(lidx), b, fi, true, 0);
        }
    }

    static void moveAwayAtom(int idx1, int idx2, int[][] ctab, BondTable btab, double[][] intang, MoleculeGraph m, int[] path) {
        double d2;
        boolean idx2_isH;
        double dfi = 0.3490658503988659;
        MolAtom a1 = m.getAtom(idx1);
        int l = path.length;
        a1.setZ(0.0);
        int c1 = path[1];
        int ref1 = path[2];
        int[] an = ctab[c1];
        int b0 = btab.getBondIndex(ref1, c1);
        int b1 = btab.getBondIndex(c1, idx1);
        double fi1 = intang[b0][b1];
        double newfi1 = fi1 < 0.0 ? fi1 - dfi : fi1 + dfi;
        Clean2D.setXY(m, m.getAtom(ref1), m.getAtom(c1), m.getAtom(idx1), m.getBond(b1), newfi1, true, 0);
        intang[b0][b1] = newfi1;
        Clean2D.resolveIntAngFromReference(ref1, c1, btab, an, intang);
        MolAtom a2 = m.getAtom(idx2);
        boolean bl = idx2_isH = a2.getAtno() == 1;
        if (idx2_isH) {
            a2.setZ(0.0);
            int c2 = path[l - 2];
            int ref2 = path[l - 3];
            an = ctab[c2];
            b0 = btab.getBondIndex(ref2, c2);
            b1 = btab.getBondIndex(c2, idx2);
            fi1 = intang[b0][b1];
            Clean2D.setXY(m, m.getAtom(ref2), m.getAtom(c2), m.getAtom(idx2), m.getBond(b1), fi1 + dfi, true, 0);
            double dp = Clean2D.dist2(a1, a2);
            Clean2D.setXY(m, m.getAtom(ref2), m.getAtom(c2), m.getAtom(idx2), m.getBond(b1), fi1 - dfi, true, 0);
            intang[b0][b1] = fi1 - dfi;
            double dm = Clean2D.dist2(a1, a2);
            if (dp > dm) {
                Clean2D.setXY(m, m.getAtom(ref2), m.getAtom(c2), m.getAtom(idx2), m.getBond(b1), fi1 + dfi, true, 0);
                intang[b0][b1] = fi1 + dfi;
            }
            Clean2D.resolveIntAngFromReference(ref2, c2, btab, an, intang);
        }
        if ((d2 = Clean2D.dist2(a1, a2)) < 0.2635111111111111) {
            a1.setZ(0.0);
            b0 = btab.getBondIndex(ref1, c1);
            b1 = btab.getBondIndex(c1, idx1);
            fi1 = intang[b0][b1];
            Clean2D.setXY(m, m.getAtom(ref1), m.getAtom(c1), m.getAtom(idx1), m.getBond(b1), fi1 + dfi, true, 0);
            intang[b0][b1] = fi1 + dfi;
            an = ctab[c1];
            Clean2D.resolveIntAngFromReference(ref1, c1, btab, an, intang);
        }
    }

    public static double dist2(MolAtom a1, MolAtom a2) {
        double dx = a1.getX() - a2.getX();
        double dy = a1.getY() - a2.getY();
        return dx * dx + dy * dy;
    }

    static double dist2(double[] c1, double[] c2) {
        double dx = c1[0] - c2[0];
        double dy = c1[1] - c2[1];
        return dx * dx + dy * dy;
    }

    static int getFixedIdx(MoleculeGraph m) {
        int l = m.getAtomCount();
        for (int i = 0; i < l; ++i) {
            if (m.getAtom(i).getZ() != 2.0) continue;
            return i;
        }
        return -1;
    }

    static BitSet getFixedIdxSet(MoleculeGraph m) {
        int l = m.getAtomCount();
        BitSet s = new BitSet(l);
        for (int i = 0; i < l; ++i) {
            if (m.getAtom(i).getZ() != 2.0) continue;
            s.set(i);
        }
        return s;
    }

    static int[] getAndSetFixedIdxes(MoleculeGraph m) {
        int l = m.getAtomCount();
        int[] tmp = new int[l];
        int n = 0;
        for (int i = 0; i < l; ++i) {
            MolAtom a = m.getAtom(i);
            if (a.getAtomMap() != 2) continue;
            a.setZ(2.0);
            a.setAtomMap(0);
            tmp[n] = i;
            ++n;
        }
        if (n < 1) {
            return null;
        }
        int[] f = new int[n];
        System.arraycopy(tmp, 0, f, 0, n);
        return f;
    }

    static int fixedLigandCount(MolAtom a) {
        int l = a.getBondCount();
        int n = 0;
        for (int i = 0; i < l; ++i) {
            if (a.getLigand(i).getZ() != 2.0) continue;
            ++n;
        }
        return n;
    }

    static int getFragCount(MoleculeGraph m, int[] f) {
        if (f == null) {
            return -1;
        }
        int[] compIds = m.findComponentIds(f);
        if (compIds.length == 0) {
            return -1;
        }
        BitSet s = new BitSet();
        for (int i = 0; i < compIds.length; ++i) {
            s.set(compIds[i]);
        }
        int n = s.cardinality();
        return n;
    }

    static boolean hasMulticentSGroup(BitSet s, Molecule m) {
        for (int i = 0; i < m.getSgroupCount(); ++i) {
            Sgroup sg = m.getSgroup(i);
            if (!(sg instanceof MulticenterSgroup)) continue;
            if (s == null) {
                return true;
            }
            int sgac = sg.getAtomCount();
            for (int j = 0; j < sgac; ++j) {
                MolAtom a = sg.getAtom(j);
                int idx = m.indexOf(a);
                if (!s.get(idx)) continue;
                return true;
            }
        }
        return false;
    }

    static void setZToIntAngle(MoleculeGraph m, BitSet system, int[][] cssr) {
        for (int i = cssr.length - 1; i >= 0; --i) {
            if (!system.get(i)) continue;
            int[] r = cssr[i];
            for (int j = r.length - 1; j >= 0; --j) {
                int idx = r[j];
                m.getAtom(idx).setZ(1.0);
            }
        }
    }

    static boolean isAromatic(MolAtom a) {
        for (int i = a.getBondCount() - 1; i >= 0; --i) {
            MolBond b = a.getBond(i);
            if (b.getType() != 4) continue;
            return true;
        }
        return false;
    }

    static boolean isHeavy(MolAtom a) {
        int n = a.getAtno();
        return n < 5 || n > 8 && n < 14 || n > 16;
    }

    static boolean hasTerminal(int[] an, int[] flags) {
        for (int i = an.length - 1; i >= 0; --i) {
            int idx = an[i];
            if ((flags[idx] & 0x3F) != 4) continue;
            return true;
        }
        return false;
    }

    static void locateNonfixedLigand(IntVector startIndexes, int stepLimit, MoleculeGraph m, int[][] ctab, int[] atomFlags, int[] fragID, boolean partialClean) {
        int poss = 0;
        int sumPoss = 1;
        for (int i = ctab.length - 1; i >= 0; --i) {
            MolAtom c = m.getAtom(i);
            if (c.getZ() != 2.0) continue;
            boolean fixedAdded = false;
            int[] an = ctab[i];
            for (int j = an.length - 1; j >= 0; --j) {
                int idx = an[j];
                int f = atomFlags[idx];
                MolAtom a = m.getAtom(idx);
                if (a.getZ() == 2.0) continue;
                if (!fixedAdded) {
                    poss = Clean2D.getNumberOfPossibilities(i, atomFlags, fragID, an, m, partialClean);
                    sumPoss = Clean2D.addToSumm(poss, -1, null, sumPoss);
                    if (sumPoss >= stepLimit) {
                        return;
                    }
                    startIndexes.addElement(i);
                    fixedAdded = true;
                }
                if (f == 4) continue;
                int[] anl = ctab[idx];
                poss = Clean2D.getNumberOfPossibilities(idx, atomFlags, fragID, anl, m, partialClean);
                sumPoss = Clean2D.addToSumm(poss, -1, null, sumPoss);
                if (sumPoss < stepLimit) {
                    startIndexes.addElement(idx);
                    continue;
                }
                return;
            }
        }
    }

    static boolean hasNonfixedLigand(MoleculeGraph m, int[] an) {
        for (int i = an.length - 1; i >= 0; --i) {
            MolAtom a = m.getAtom(an[i]);
            if (a.getZ() == 2.0) continue;
            return true;
        }
        return false;
    }

    static boolean hasNonfixedRingAtom(int idx, int id, int[] an, int[] atomFlags, int[] fragID, MoleculeGraph m) {
        for (int i = an.length - 1; i >= 0; --i) {
            int lig = an[i];
            int lid = fragID[lig] & 0xFFFF;
            MolAtom a = m.getAtom(lig);
            if ((atomFlags[lig] & 1) == 0 || id != lid || a.getZ() == 2.0) continue;
            return true;
        }
        return false;
    }

    static void fixFragment(int id, int[] fragID, int[] atomFlags, MoleculeGraph m) {
        int l = fragID.length;
        for (int i = 0; i < l; ++i) {
            int fID = fragID[i] & 0xFFFF;
            if (fID != id) continue;
            MolAtom a = m.getAtom(i);
            a.setZ(2.0);
            int n = i;
            atomFlags[n] = atomFlags[n] & 0xFFFFF7FF;
        }
    }

    static void setFragmentTo(double value, int id, int[] fragID, int[] atomFlags, MoleculeGraph m, BitSet s) {
        int l = fragID.length;
        for (int i = 0; i < l; ++i) {
            int fID = fragID[i] & 0xFFFF;
            if (fID != id) continue;
            MolAtom a = m.getAtom(i);
            int n = i;
            atomFlags[n] = atomFlags[n] & 0xFFFFF7FF;
            if (a.getZ() == value) continue;
            a.setZ(value);
            if (s == null) continue;
            s.set(i);
        }
    }

    static void setFragmentTo(double value, BitSet s, MoleculeGraph m) {
        int i = s.nextSetBit(0);
        while (i >= 0) {
            MolAtom a = m.getAtom(i);
            a.setZ(value);
            i = s.nextSetBit(i + 1);
        }
    }

    static int fragCount(int id, int[] fragID) {
        int l = fragID.length;
        int n = 0;
        for (int i = 0; i < l; ++i) {
            int fID = fragID[i] & 0xFFFF;
            if (fID != id) continue;
            ++n;
        }
        return n;
    }

    static void setZ(MoleculeGraph m, double n) {
        int ac = m.getAtomCount();
        for (int i = 0; i < ac; ++i) {
            m.getAtom(i).setZ(n);
        }
    }

    static void setZ(int[][] x, MoleculeGraph m, double n) {
        for (int i = x.length - 1; i >= 0; --i) {
            Clean2D.setZ(x[i], m, n);
        }
    }

    static void setZ(int[] x, MoleculeGraph m, double n) {
        for (int i = x.length - 1; i >= 0; --i) {
            MolAtom a = m.getAtom(x[i]);
            a.setZ(n);
        }
    }

    static void saveCoordinates(MoleculeGraph m, double[] c) {
        int ac = m.getAtomCount();
        int p = c.length / ac;
        for (int i = 0; i < ac; ++i) {
            MolAtom a = m.getAtom(i);
            int n = i * p;
            c[n] = a.getX();
            if (p > 1) {
                c[n + 1] = a.getY();
            }
            if (p <= 2) continue;
            c[n + 2] = a.getZ();
        }
    }

    static boolean restoreCoordinates(MoleculeGraph m, double[] d) {
        int ac = m.getAtomCount();
        if (d == null) {
            return false;
        }
        int p = d.length / ac;
        for (int i = 0; i < ac; ++i) {
            MolAtom a = m.getAtom(i);
            int n = i * p;
            a.setXYZ(d[n], p > 1 ? d[n + 1] : 0.0, p > 2 ? d[n + 2] : 0.0);
        }
        return true;
    }

    static int getFixedAtomCount(MoleculeGraph m) {
        int ac = m.getAtomCount();
        int n = 0;
        for (int i = 0; i < ac; ++i) {
            if (m.getAtom(i).getZ() != 2.0) continue;
            ++n;
        }
        return n;
    }

    static boolean hasTrans(int[] x, MoleculeGraph m, int[][] btab) {
        int l = x.length;
        for (int i = 0; i < l; ++i) {
            MolAtom a4;
            MolAtom a1;
            int s;
            int i1 = x[i];
            int i2 = x[(i + 1) % l];
            int i3 = x[(i + 2) % l];
            int i4 = x[(i + 3) % l];
            MolBond b = m.getBond(btab[i2][i3]);
            if (b.getType() != 2 || (s = b.getFlags() & 0x1C0) != 128 && s != 64 || (s = b.transformCT(a1 = m.getAtom(i1), a4 = m.getAtom(i4), s)) != 64) continue;
            return true;
        }
        return false;
    }

    static int getHypotheticalEdges(MolAtom a) {
        int bc = a.getBondCount();
        if (bc == 2) {
            int dbc = 0;
            for (int i = 0; i < bc; ++i) {
                int t = a.getBond(i).getType();
                if (t == 3 || t == 9) {
                    return 2;
                }
                if (t != 2) continue;
                ++dbc;
            }
            if (dbc == bc) {
                return 2;
            }
        }
        if (bc == 2 && !Clean2D.contractedSgroup(a) && !Clean2D.isHeavy(a)) {
            return 3;
        }
        return bc;
    }

    static int getIdxWithFlag(int f, int[] atomFlags, int[] idxes) {
        int l = idxes.length;
        for (int i = 0; i < l; ++i) {
            if ((atomFlags[idxes[i]] & f) != f) continue;
            return idxes[i];
        }
        return -1;
    }

    static int[] convert(int[] an, int[] convTable) {
        int l = an.length;
        int[] idxes = new int[l];
        for (int i = 0; i < l; ++i) {
            idxes[i] = convTable[an[i]];
        }
        return idxes;
    }

    static int indexOf(Object[] r, Object a) {
        int rl = r.length;
        for (int i = 0; i < rl; ++i) {
            if (r[i] != a) continue;
            return i;
        }
        return -1;
    }

    static int indexOf(int[] r, int a) {
        int rl = r.length;
        for (int i = 0; i < rl; ++i) {
            if (r[i] != a) continue;
            return i;
        }
        return -1;
    }

    static boolean allContains(int[] a, int[] b) {
        int l = a.length;
        for (int i = 0; i < l; ++i) {
            if (Clean2D.indexOf(b, a[i]) >= 0) continue;
            return false;
        }
        return true;
    }

    static int numberOfSetBitUntil(BitSet s, int idx) {
        int n = 0;
        int i = s.nextSetBit(0);
        while (i >= 0 && i < idx) {
            ++n;
            i = s.nextSetBit(i + 1);
        }
        return n;
    }

    static int getLargestIndex(double[] x) {
        double max_value = Double.MIN_VALUE;
        int max_idx = 0;
        for (int i = x.length - 1; i >= 0; --i) {
            if (!(x[i] > max_value)) continue;
            max_idx = i;
            max_value = x[i];
        }
        return max_idx;
    }

    static void transform(double[] c, CTransform3D t) {
        DPoint3 p = new DPoint3();
        for (int i = c.length - 1; i >= 0; --i) {
            p.y = c[i];
            p.x = c[i - 1];
            t.transform(p);
            c[i] = p.y;
            c[i - 1] = p.x;
            --i;
        }
    }

    static void transform(DPoint3[] p, CTransform3D t) {
        for (int i = p.length - 1; i >= 0; --i) {
            t.transform(p[i]);
        }
    }

    static void transform(BitSet set, MoleculeGraph m, CTransform3D T) {
        for (int i = 0; i < set.length(); ++i) {
            if (!set.get(i)) continue;
            MolAtom a = m.getAtom(i);
            a.transform(T, false);
        }
    }

    static void transform(MoleculeGraph m, int id, int[] fragID, CTransform3D T) {
        int l = fragID.length;
        for (int i = 0; i < l; ++i) {
            int fID = fragID[i] & 0xFFFF;
            if (fID != id) continue;
            MolAtom a = m.getAtom(i);
            a.transform(T, false);
        }
    }

    static void transformNonfixedFrag(CTransform3D T, int id, int[] fragID, MoleculeGraph m) {
        int ac = m.getAtomCount();
        for (int i = 0; i < ac; ++i) {
            MolAtom a = m.getAtom(i);
            int fID = fragID[i] & 0xFFFF;
            if (fID != id || a.getZ() == 2.0) continue;
            a.transform(T, false);
        }
    }

    static void removeCTStereo(MoleculeGraph m) {
        for (int i = m.getBondCount() - 1; i >= 0; --i) {
            MolBond b = m.getBond(i);
            if (b.getType() != 2) continue;
            b.setFlags(0, 192);
        }
    }

    static void sortCSSR(int[][] cssr) {
        int cssrl = cssr.length;
        int[] ringl = new int[cssrl];
        for (int i = 0; i < cssrl; ++i) {
            ringl[i] = cssr[i].length;
        }
        ArrayTools.sortDescending(ringl, cssr);
    }

    static int getStereo2(double[] c1, double[] c2, double[] c3, double[] c4) {
        double ax = c1[0] - c2[0];
        double bx = c3[0] - c2[0];
        double ay = c1[1] - c2[1];
        double by = c3[1] - c2[1];
        double ab = ax * bx + ay * by;
        double cx = c4[0] - c3[0];
        double cy = c4[1] - c3[1];
        double bc = bx * cx + by * cy;
        double ac = ax * cx + ay * cy;
        double bb = bx * bx + by * by;
        double scalar = ab * bc - ac * bb;
        double normsq = bb * bb * (ax * ax + ay * ay) * (cx * cx + cy * cy);
        double epsilon = 5.77E-5;
        return scalar * scalar < normsq * epsilon ? 192 : (scalar > 0.0 ? 64 : 128);
    }

    static boolean isConvex(int idx, double[] c) {
        int l = c.length;
        double[] p = new double[l - 2];
        int n = 0;
        for (int i = 0; i < l / 2; ++i) {
            if (i == idx) continue;
            p[n++] = c[2 * i];
            p[n++] = c[2 * i + 1];
        }
        double[] coord = new double[]{c[2 * idx], c[2 * idx + 1]};
        return !Clean2D.inpoly(p, coord);
    }

    static boolean isConvexInSmallestRing(int idx, int[][] cssr, int[] ridx, MoleculeGraph m) {
        int l = ridx.length;
        int[] smallestRing = null;
        int smallestlength = Integer.MAX_VALUE;
        for (int i = 0; i < l; ++i) {
            int[] r = cssr[ridx[i]];
            if (r.length >= smallestlength || Clean2D.indexOf(r, idx) < 0) continue;
            smallestRing = r;
            smallestlength = r.length;
        }
        if (smallestRing != null) {
            double[] c = new double[smallestlength * 2 - 2];
            double[] atomc = new double[2];
            int n = 0;
            for (int i = smallestlength - 1; i >= 0; --i) {
                int aidx = smallestRing[i];
                MolAtom a = m.getAtom(aidx);
                if (aidx != idx) {
                    c[n++] = a.getX();
                    c[n++] = a.getY();
                    continue;
                }
                atomc[0] = a.getX();
                atomc[1] = a.getY();
            }
            return !Clean2D.inpoly(c, atomc);
        }
        return true;
    }

    static void correctCoordsForOptimization(MoleculeGraph m, int[] atomFlags, double distLimit2) {
        double d;
        MolAtom a2;
        int n;
        int j;
        MolAtom a1;
        int i;
        int ac = m.getAtomCount();
        for (i = 0; i < ac; ++i) {
            a1 = m.getAtom(i);
            if (atomFlags != null && (atomFlags[i] & 0x200) != 0 || a1.getZ() != 2.0) continue;
            j = -1;
            n = 0;
            do {
                a2 = m.getAtom(++j);
                if (i == j || a2.getZ() != 2.0 || !((d = Clean2D.dist2(a1, a2)) < distLimit2)) continue;
                if (n < 5) {
                    Clean2D.moveFurther(a1, a2, false);
                } else {
                    Clean2D.moveFurther(a1, a2, true);
                }
                ++n;
                j = -1;
            } while (j < ac - 1);
        }
        for (i = 0; i < ac; ++i) {
            a1 = m.getAtom(i);
            if (atomFlags != null && (atomFlags[i] & 0x200) == 0 || a1.getZ() != 2.0) continue;
            j = -1;
            n = 0;
            do {
                a2 = m.getAtom(++j);
                if (i == j || a2.getZ() != 2.0 || !((d = Clean2D.dist2(a1, a2)) < distLimit2)) continue;
                if (n < 5) {
                    Clean2D.moveFurther(a1, a2, false);
                } else {
                    Clean2D.moveFurther(a1, a2, true);
                }
                ++n;
                j = -1;
            } while (j < ac - 1);
        }
    }

    static void moveFurther(MolAtom a1, MolAtom a2, boolean randomly) {
        double x1 = a1.getX();
        double y1 = a1.getY();
        if (!randomly) {
            double x2 = a2.getX();
            double y2 = a2.getY();
            double dx = x1 - x2;
            double dy = y1 - y2;
            dx = dx == 0.0 ? 1.0 : dx / Math.abs(dx);
            dy = dy == 0.0 ? 1.0 : dy / Math.abs(dy);
            a1.setXYZ(x1 + dx * 0.1 * 1.54, y1 + dy * 0.1 * 1.54, a1.getZ());
        } else {
            double fi = Math.random() * (Math.PI * 2);
            a1.setXYZ(x1 + 0.15400000000000003 * Math.cos(fi), y1 + 0.15400000000000003 * Math.sin(fi), a1.getZ());
        }
    }

    private static boolean optimizeMolecule(MoleculeGraph m, int[] atomFlags, PartialOptimization opt, int optFlags, int fixFlag, int Debug2) {
        boolean relativeFix;
        Clean2D.correctCoordsForOptimization(m, atomFlags, 0.2635111111111111);
        boolean fixedOnly = (optFlags & 1) != 0;
        boolean addH = (optFlags & 2) != 0;
        boolean useRings = (optFlags & 4) != 0;
        boolean absoluteFix = (optFlags & 8) != 0;
        boolean bl = relativeFix = (optFlags & 0x10) != 0;
        if (Debug2 > 5) {
            System.err.println("Optimization parameters:");
            System.err.println((fixedOnly ? "Only Fixed Atoms " : "") + (addH ? "Add Hydrogen atoms " : "") + (useRings ? "Force ideal small rings " : "") + (absoluteFix ? "Absolute fixed atoms " : "") + (relativeFix ? "Relative fixed atoms" : ""));
        }
        int ac_before = m.getAtomCount();
        if (addH) {
            Clean2D.addExplicitHydrogens(m, fixedOnly);
        }
        int ac = m.getAtomCount();
        boolean[] fixed = new boolean[ac];
        int[] atomConv = new int[ac];
        double[] coords = new double[ac * 2];
        int n = 0;
        for (int i = 0; i < ac; ++i) {
            MolAtom a = m.getAtom(i);
            if (fixedOnly && a.getZ() != 2.0) continue;
            coords[n++] = a.getX();
            coords[n++] = a.getY();
            atomConv[i] = n / 2 - 1;
            if (atomFlags == null || i >= ac_before || (atomFlags[i] & 0x200) == 0 && (!absoluteFix || (atomFlags[i] & fixFlag) == 0)) continue;
            fixed[n / 2 - 1] = true;
        }
        if (fixedOnly) {
            double[] tmp = new double[n];
            System.arraycopy(coords, 0, tmp, 0, n);
            coords = tmp;
            boolean[] t = new boolean[n / 2];
            System.arraycopy(fixed, 0, t, 0, n / 2);
            fixed = t;
        }
        if (coords.length == 0) {
            if (Debug2 > 5) {
                System.err.println("No atoms selected for optimization.");
            }
            return true;
        }
        n = 0;
        int bc = m.getBondCount();
        int[] eP1 = new int[bc];
        int[] eP2 = new int[bc];
        for (int i = 0; i < bc; ++i) {
            MolBond b = m.getBond(i);
            MolAtom n1 = b.getAtom1();
            MolAtom n2 = b.getAtom2();
            if (fixedOnly && (n1.getZ() != 2.0 || n2.getZ() != 2.0)) continue;
            int n1_idx = m.indexOf(n1);
            int n2_idx = m.indexOf(n2);
            eP1[n] = atomConv[n1_idx];
            eP2[n] = atomConv[n2_idx];
            ++n;
        }
        if (fixedOnly) {
            int[] tmp = new int[n];
            System.arraycopy(eP1, 0, tmp, 0, n);
            eP1 = tmp;
            tmp = new int[n];
            System.arraycopy(eP2, 0, tmp, 0, n);
            eP2 = tmp;
        }
        Object rings = null;
        if (useRings) {
            int i;
            int[][] t = m.getCSSR();
            n = 0;
            for (i = 0; i < t.length; ++i) {
                if (t[i].length >= 10) continue;
                ++n;
            }
            rings = new int[n][];
            n = 0;
            for (i = 0; i < t.length; ++i) {
                if (t[i].length >= 10) continue;
                rings[n++] = t[i];
            }
            int l = ((int[][])rings).length;
            double[] idealR = new double[l];
            for (int i2 = 0; i2 < l; ++i2) {
                int rl = rings[i2].length;
                idealR[i2] = 0.77 / Math.sin(Math.PI / (double)rl);
            }
            PartialOptimization.access$502(opt, idealR);
            PartialOptimization.access$602(opt, new double[l]);
            PartialOptimization.access$702(opt, new double[l]);
        }
        if (!fixedOnly && relativeFix) {
            IntVector atomIdxes = new IntVector();
            int l = Clean2D.generateFixMesh(m, atomFlags, fixFlag, atomIdxes);
            int[] feP1 = new int[l];
            int[] feP2 = new int[l];
            double[] distances = new double[l];
            n = 0;
            for (int i = 0; i < atomIdxes.size(); ++i) {
                int id1 = atomIdxes.get(i);
                if (id1 < 0) continue;
                int id2 = atomIdxes.get(++i);
                feP1[n] = id1;
                feP2[n] = id2;
                MolAtom a1 = m.getAtom(id1);
                MolAtom a2 = m.getAtom(id2);
                double dx = a1.getX() - a2.getX();
                double dy = a1.getY() - a2.getY();
                distances[n] = Math.sqrt(dx * dx + dy * dy);
                ++n;
            }
        }
        int[] iter = new int[]{0};
        double[] d = new double[coords.length];
        PartialOptimization.access$102(opt, eP1);
        PartialOptimization.access$202(opt, eP2);
        PartialOptimization.access$302(opt, fixed);
        opt.btab = m.getBondTable();
        PartialOptimization.access$802(opt, rings);
        boolean success = true;
        try {
            opt.frprmin(coords, null, 1.0E-5, iter, d, System.currentTimeMillis());
        }
        catch (Exception e) {
            if (Debug2 > 0) {
                System.err.println("Optimization failed");
            }
            success = false;
        }
        if (Debug2 > 7) {
            System.err.println("Optimization: " + coords.length + " atoms");
            System.err.println(" Iterations " + iter[0]);
        }
        if (addH) {
            for (int i = ac - 1; i >= ac_before; --i) {
                m.removeAtom(i, -33);
            }
        }
        if (!success) {
            return false;
        }
        n = 0;
        for (int i = 0; i < ac_before; ++i) {
            MolAtom a = m.getAtom(i);
            if (fixedOnly && a.getZ() != 2.0) continue;
            double x = coords[n++];
            double y = coords[n++];
            if (Double.isNaN(x) || Double.isNaN(y)) {
                if (Debug2 > 0) {
                    System.err.println("Optimization failed");
                }
                return false;
            }
            a.setXYZ(x, y, 2.0);
        }
        return true;
    }

    static void addExplicitHydrogens(MoleculeGraph m, boolean addToFixed) {
        int ac = m.getAtomCount();
        for (int i = 0; i < ac; ++i) {
            MolAtom a = m.getAtom(i);
            int ec = a.getBondCount();
            boolean triplebond = false;
            for (int j = 0; j < ec && !triplebond; ++j) {
                if (a.getBond(j).getType() != 3) continue;
                triplebond = true;
            }
            if (triplebond || ec >= 3 || addToFixed && a.getZ() != 2.0) continue;
            double[] angles = AtomBranchCoords.branchAngles2d(a, 1);
            double phi0 = angles[0];
            double dphi = angles[1];
            double phi = phi0 + dphi;
            double x = a.getX() + 1.54 * Math.cos(phi);
            double y = a.getY() + 1.54 * Math.sin(phi);
            double z = addToFixed ? 2.0 : 0.0;
            MolAtom H = new MolAtom(1, x, y, z);
            MolBond b = new MolBond(a, H);
            m.add(H);
            m.add(b);
        }
    }

    static int generateFixMesh(MoleculeGraph m, int[] f, int fix, IntVector mesh) {
        MoleculeGraph mf = (MoleculeGraph)m.clone();
        for (int i = f.length - 1; i >= 0; --i) {
            if ((f[i] & fix) != 0) continue;
            mf.removeAtom(i);
        }
        int[] conv = new int[mf.getAtomCount()];
        int n = 0;
        for (int i = 0; i < f.length; ++i) {
            if ((f[i] & fix) == 0) continue;
            conv[n] = i;
            ++n;
        }
        MoleculeGraph[] frags = mf.findFrags(SelectionMolecule.class, 1);
        for (int i = 0; i < frags.length; ++i) {
            MoleculeGraph frag = frags[i];
            for (int j = 0; j < frag.getAtomCount(); ++j) {
                MolAtom node = frag.getAtom(j);
                int l = node.getBondCount();
                if (l <= 1) continue;
                int idx1 = conv[mf.indexOf(node)];
                for (int k = 0; k < l; ++k) {
                    MolAtom ligand = node.getLigand(k);
                    int idx2 = conv[mf.indexOf(ligand)];
                    Clean2D.addIfNotIn(idx1, idx2, mesh);
                }
            }
            if (mesh.size() <= 0) continue;
            mesh.add(-1);
        }
        return n;
    }

    static void addIfNotIn(int idx1, int idx2, IntVector v) {
        for (int i = 0; i < v.size(); ++i) {
            int id1 = v.get(i);
            if (id1 < 0) continue;
            int id2 = v.get(++i);
            if ((id1 != idx1 || id2 != idx2) && (id1 != idx2 || id2 != idx1)) continue;
            return;
        }
        v.add(idx1);
        v.add(idx2);
    }

    static void orientMolecule(MoleculeGraph m, int[][] ctab, BondTable btab, int[] atomFlags, int[] fragID, int[][] cssr, int[][] atomInRing) {
        int minChainLength = cssr.length + 1;
        if (Clean2D.rotateToLongestTransChain(ctab, btab, m, atomFlags, fragID, minChainLength)) {
            return;
        }
        CTransform3D R = new CTransform3D();
        if (cssr != null && cssr.length > 0) {
            int[] ringsystem = null;
            for (int i = atomInRing.length - 1; i >= 0; --i) {
                int ainr = atomInRing[i].length;
                if (ainr <= 1 || ringsystem != null && ainr <= ringsystem.length) continue;
                ringsystem = atomInRing[i];
            }
            if (ringsystem == null) {
                DPoint3 c = new DPoint3();
                MolAtom ref = null;
                int[] r = cssr[0];
                for (int i = r.length - 1; i >= 0; --i) {
                    MolAtom a = m.getAtom(r[i]);
                    c.x += a.getX();
                    c.y += a.getY();
                    if (ref != null && ref.getBondCount() >= a.getBondCount()) continue;
                    ref = a;
                }
                c.x /= (double)r.length;
                c.y /= (double)r.length;
                double phi = 1.5707963267948966 - c.angle2D(ref.getX(), ref.getY());
                R.setRotation(0.0, 0.0, 1.0, phi);
                R.setRotationCenter(c);
                m.transform(R);
            } else {
                int i;
                IntVector rSystem = new IntVector();
                for (i = ringsystem.length - 1; i >= 0; --i) {
                    rSystem.addElement(ringsystem[i]);
                }
                for (i = 0; i < rSystem.size(); ++i) {
                    int r_idx = rSystem.get(i);
                    int[] r = cssr[r_idx];
                    for (int j = r.length - 1; j >= 0; --j) {
                        int[] r_idxes = atomInRing[r[j]];
                        for (int k = r_idxes.length - 1; k >= 0; --k) {
                            if (rSystem.contains(r_idxes[k])) continue;
                            rSystem.addElement(r_idxes[k]);
                        }
                    }
                }
                int l = rSystem.size();
                double[][] rc = new double[l][2];
                for (int i2 = 0; i2 < l; ++i2) {
                    int[] r = cssr[rSystem.get(i2)];
                    for (int j = r.length - 1; j >= 0; --j) {
                        MolAtom a = m.getAtom(r[j]);
                        double[] dArray = rc[i2];
                        dArray[0] = dArray[0] + a.getX();
                        double[] dArray2 = rc[i2];
                        dArray2[1] = dArray2[1] + a.getY();
                    }
                    double[] dArray = rc[i2];
                    dArray[0] = dArray[0] / (double)r.length;
                    double[] dArray3 = rc[i2];
                    dArray3[1] = dArray3[1] / (double)r.length;
                }
                if (rc.length > 2) {
                    Clean2D.shortAccordingToDistance(rc);
                }
                DPoint3 c = new DPoint3(rc[0][0], rc[0][1], 0.0);
                double phi = c.angle2D(rc[1][0], rc[1][1]);
                R.setRotation(0.0, 0.0, 1.0, -phi);
                R.setRotationCenter(c);
                m.transform(R);
            }
        } else {
            Clean2D.rotateToLongestTransChain(ctab, btab, m, atomFlags, fragID, 0);
        }
    }

    static void translateToCenter(DPoint3 c, MoleculeGraph m) {
        CTransform3D R = new CTransform3D();
        if (c != null) {
            DPoint3 center2 = m.calcCenter();
            R.setIdentity();
            R.setTranslation(c.x - center2.x, c.y - center2.y, 0.0);
            m.transform(R);
        }
    }

    static boolean rotateToLongestTransChain(int[][] ctab, BondTable btab, MoleculeGraph m, int[] atomFlags, int[] fragID, int minChainLength) {
        int id;
        int l = atomFlags.length;
        int size_l = fragID[fragID.length - 1];
        int[] sizes = new int[size_l];
        for (int i = 0; i < l; ++i) {
            id = fragID[i] & 0xFFFF;
            if ((atomFlags[i] & 2) == 0 || id <= 0) continue;
            int n = id;
            sizes[n] = sizes[n] + 1;
        }
        int longest = 0;
        id = -1;
        for (int i = 1; i < size_l; ++i) {
            if (sizes[i] <= longest) continue;
            longest = sizes[i];
            id = i;
        }
        if (longest < minChainLength) {
            return false;
        }
        boolean smallfragBond = false;
        if (longest == 0) {
            for (int i = 0; i < l; ++i) {
                int fid = fragID[i] & 0xFFFF;
                if ((atomFlags[i] & 0x20) == 0 || fid <= 0) continue;
                id = fid;
                smallfragBond = true;
            }
        }
        MolAtom a1 = null;
        MolAtom a2 = null;
        if (id > 0) {
            int cidx1 = -1;
            for (int i = 0; i < l; ++i) {
                int fid = fragID[i] & 0xFFFF;
                if (fid != id) continue;
                cidx1 = i;
                break;
            }
            if (cidx1 < 0) {
                return false;
            }
            int cidx2 = Clean2D.getLigandWithID(id, ctab[cidx1], fragID);
            if (cidx2 < 0) {
                return false;
            }
            int idx1 = Clean2D.getChainEnd(id, cidx1, cidx2, ctab, fragID);
            if (longest % 2 == 0 && !smallfragBond) {
                idx1 = Clean2D.getLigandWithID(id, ctab[idx1], fragID);
            }
            a1 = m.getAtom(idx1);
            a2 = m.getAtom(Clean2D.getChainEnd(id, cidx2, cidx1, ctab, fragID));
        } else if (l == 3) {
            for (int i = 0; i < l; ++i) {
                MolAtom a = m.getAtom(i);
                if (a.getBondCount() != 1) continue;
                if (a1 == null) {
                    a1 = a;
                    continue;
                }
                if (a2 != null) continue;
                a2 = a;
            }
        } else {
            return false;
        }
        DPoint3 p1 = a1.getLocation();
        double fi = p1.angle2D(a2.getX(), a2.getY());
        fi = smallfragBond ? fi - 0.5235987755982988 : fi;
        CTransform3D T = new CTransform3D();
        T.setIdentity();
        T.setRotation(0.0, 0.0, 1.0, -fi);
        T.setRotationCenter(p1);
        m.transform(T);
        return true;
    }

    static int getChainEnd(int id, int idx, int from, int[][] ctab, int[] fragID) {
        int[] an = ctab[idx];
        for (int i = an.length - 1; i >= 0; --i) {
            int n = an[i];
            int fID = fragID[n] & 0xFFFF;
            if (fID != id || from == n) continue;
            return Clean2D.getChainEnd(id, n, idx, ctab, fragID);
        }
        return idx;
    }

    static int getLigandWithID(int id, int[] an, int[] fragID) {
        for (int i = an.length - 1; i >= 0; --i) {
            int n = an[i];
            int fID = fragID[n] & 0xFFFF;
            if (fID != id) continue;
            return an[i];
        }
        return -1;
    }

    static void shortAccordingToDistance(double[][] c) {
        int l = c.length;
        double maxd = 0.0;
        int max_i = -1;
        int max_j = -1;
        double d = 0.0;
        for (int i = 0; i < l - 1; ++i) {
            double[] c1 = c[i];
            for (int j = i + 1; j < l; ++j) {
                double[] c2 = c[j];
                d = Clean2D.dist2(c1, c2);
                if (!(maxd < d)) continue;
                maxd = d;
                max_i = i;
                max_j = j;
            }
        }
        double[] tmp = c[0];
        c[0] = c[max_i];
        c[max_i] = tmp;
        tmp = c[1];
        c[1] = c[max_j];
        c[max_j] = tmp;
    }

    static void transformAtomFlagsAndIDs(int[] f, int[] of, int[] iDs, int[] oIds, MoleculeGraph m) {
        int n = 0;
        int ac = f.length;
        for (int i = 0; i < ac; ++i) {
            if (m.getAtom(i).getZ() == 5.0) continue;
            f[i] = of[n];
            iDs[i] = oIds[n++];
        }
        iDs[iDs.length - 1] = oIds[oIds.length - 1];
    }

    static boolean inpoly(double[] r, double[] c) {
        boolean inp = false;
        double ax = c[0];
        double ay = c[1];
        int rl = r.length / 2;
        int i = 0;
        int j = rl - 1;
        while (i < rl) {
            int n = i * 2;
            int k = j * 2;
            if ((r[n + 1] <= ay && ay < r[k + 1] || r[k + 1] <= ay && ay < r[n + 1]) && ax < (r[k] - r[n]) * (ay - r[n + 1]) / (r[k + 1] - r[n + 1]) + r[n]) {
                inp = !inp;
            }
            j = i++;
        }
        return inp;
    }

    static double calcDist(MolBond b1, MolBond b2) {
        double d;
        MolAtom a1 = b1.getAtom1();
        MolAtom a2 = b1.getAtom2();
        double x11 = a1.getX();
        double y11 = a1.getY();
        double x12 = a2.getX();
        double y12 = a2.getY();
        a1 = b2.getAtom1();
        a2 = b2.getAtom2();
        double x21 = a1.getX();
        double y21 = a1.getY();
        double x22 = a2.getX();
        double y22 = a2.getY();
        double x12x11 = x12 - x11;
        double x11x21 = x11 - x21;
        double y12y11 = y12 - y11;
        double y11y21 = y11 - y21;
        double x22x21 = x22 - x21;
        double y22y21 = y22 - y21;
        double l1 = x12x11 * x12x11 + y12y11 * y12y11;
        double sqrl1 = Math.sqrt(l1);
        double d1 = (-x11x21 * x12x11 + -y11y21 * y12y11) / l1;
        d1 = d1 >= 0.0 && d1 <= 1.0 ? Math.abs((y11y21 * x12x11 - x11x21 * y12y11) / sqrl1) : 999.0;
        double d2 = ((x22 - x11) * x12x11 + (y22 - y11) * y12y11) / l1;
        d2 = d2 >= 0.0 && d2 <= 1.0 ? Math.abs(((y11 - y22) * x12x11 - (x11 - x22) * y12y11) / sqrl1) : 999.0;
        double db1 = Math.min(d1, d2);
        double l2 = x22x21 * x22x21 + y22y21 * y22y21;
        double sqrl2 = Math.sqrt(l2);
        d1 = (x11x21 * x22x21 + y11y21 * y22y21) / l2;
        d1 = d1 >= 0.0 && d1 <= 1.0 ? Math.abs((-y11y21 * x22x21 - -x11x21 * y22y21) / sqrl2) : 999.0;
        d2 = ((x12 - x21) * x22x21 + (y12 - y21) * y22y21) / l2;
        d2 = d2 >= 0.0 && d2 <= 1.0 ? Math.abs(((y21 - y12) * x22x21 - (x21 - x12) * y22y21) / sqrl2) : 999.0;
        d2 = d2 >= 0.0 && d2 <= 1.0 ? d2 : 999.0;
        double db2 = Math.min(d1, d2);
        double r = Math.min(db1, db2);
        if (d < 998.0) {
            return r;
        }
        double r2 = (-x11x21 * x12x11 + -y11y21 * y12y11) / sqrl1;
        d1 = r2 < 0.0 ? Math.sqrt(x11x21 * x11x21 + y11y21 * y11y21) : (r2 > 1.0 ? Math.sqrt((x12 - x21) * (x12 - x21) + (y12 - y21) * (y12 - y21)) : (y11y21 * x12x11 - x11x21 * y12y11) / sqrl1);
        r2 = ((x22 - x11) * x12x11 + (y22 - y11) * y12y11) / sqrl1;
        d2 = r2 < 0.0 ? Math.sqrt((x11 - x22) * (x11 - x22) + (y11 - y22) * (y11 - y22)) : (r2 > 1.0 ? Math.sqrt((x12 - x22) * (x12 - x22) + (y12 - y22) * (y12 - y22)) : ((y11 - y22) * x12x11 - (x11 - x22) * y12y11) / sqrl1);
        db1 = Math.min(Math.abs(d1), Math.abs(d2));
        r2 = (x11x21 * x22x21 + y11y21 * y22y21) / sqrl2;
        d1 = r2 < 0.0 ? Math.sqrt(-x11x21 * -x11x21 + -y11y21 * -y11y21) : (r2 > 1.0 ? Math.sqrt((x22 - x11) * (x22 - x11) + (y22 - y11) * (y22 - y11)) : (-y11y21 * x22x21 - -x11x21 * y22y21) / sqrl2);
        r2 = ((x12 - x21) * x22x21 + (y12 - y21) * y22y21) / sqrl2;
        d2 = r2 < 0.0 ? Math.sqrt((x21 - x12) * (x21 - x12) + (y21 - y12) * (y21 - y12)) : (r2 > 1.0 ? Math.sqrt((x22 - x12) * (x22 - x12) + (y22 - y12) * (y22 - y12)) : ((y21 - y12) * x22x21 - (x21 - x12) * y22y21) / sqrl2);
        db2 = Math.min(Math.abs(d1), Math.abs(d2));
        return Math.min(db1, db2);
    }

    public static boolean crossing(MolBond e1, MolBond e2) {
        double err = 0.01;
        MolAtom a1 = e1.getAtom1();
        MolAtom a2 = e1.getAtom2();
        MolAtom a3 = e2.getAtom1();
        MolAtom a4 = e2.getAtom2();
        double x1 = a1.getX();
        double x2 = a2.getX();
        double y1 = a1.getY();
        double y2 = a2.getY();
        double x3 = a3.getX();
        double x4 = a4.getX();
        double y3 = a3.getY();
        double y4 = a4.getY();
        double x1min = x1;
        double x1max = x2;
        if (x2 < x1) {
            x1min = x2;
            x1max = x1;
        }
        double x2min = x3;
        double x2max = x4;
        if (x4 < x3) {
            x2min = x4;
            x2max = x3;
        }
        if (!Clean2D.overlap(x1min, x1max, x2min, x2max)) {
            return false;
        }
        double y1min = y1;
        double y1max = y2;
        if (y2 < y1) {
            y1min = y2;
            y1max = y1;
        }
        double y2min = y3;
        double y2max = y4;
        if (y4 < y3) {
            y2min = y4;
            y2max = y3;
        }
        if (!Clean2D.overlap(y1min, y1max, y2min, y2max)) {
            return false;
        }
        double dx1 = x2 - x1;
        double dx2 = x4 - x3;
        double dy1 = y2 - y1;
        double dy2 = y4 - y3;
        double m1 = dy1 / dx1;
        double m2 = dy2 / dx2;
        double px = 0.0;
        if (m1 == m2) {
            return true;
        }
        if (dx1 != 0.0 && dx2 != 0.0) {
            px = (x1 * m1 - x3 * m2 + y3 - y1) / (m1 - m2);
        } else {
            if (dx1 == 0.0) {
                px = x2;
            }
            if (dx2 == 0.0) {
                px = x3;
            }
        }
        return px >= x1min - err && px <= x1max + err && px >= x2min - err && px <= x2max + err;
    }

    static boolean overlap(double a, double b, double c, double d) {
        return a <= c ? b >= c : a <= d;
    }

    static boolean common3(int i1, int i2, int i3, int i4) {
        int n = 0;
        if (i1 == i2) {
            ++n;
        }
        if (i1 == i3) {
            ++n;
        }
        if (i1 == i4) {
            ++n;
        }
        if (i2 == i3) {
            ++n;
        }
        if (i2 == i4) {
            ++n;
        }
        if (i3 == i4) {
            ++n;
        }
        return n > 2;
    }

    static double convertToPos(double phi) {
        if (Double.isNaN(phi)) {
            return 0.0;
        }
        double phic = (phi + Math.PI * 2) % (Math.PI * 2);
        return phic >= 0.0 ? phic : Clean2D.convertToPos(phic);
    }

    static double round(double phi) {
        return phi < 0.001 && phi > -0.001 ? 0.0 : phi;
    }

    static void copy(double[][] from, double[][] to) {
        for (int i = from.length - 1; i >= 0; --i) {
            System.arraycopy(from[i], 0, to[i], 0, from.length);
        }
    }

    static boolean timeLimit(long start, long limit, long start2, long limit2) {
        if (limit > 0L) {
            boolean limitReached;
            boolean bl = limitReached = start + limit < System.currentTimeMillis();
            if (limitReached && Error == 1) {
                System.err.println("Time limit " + limit / 1000L + "s reached.");
            }
            return limitReached;
        }
        if (limit2 > 0L) {
            boolean limitReached;
            boolean bl = limitReached = start2 + limit2 < System.currentTimeMillis();
            if (limitReached && Error == 1) {
                System.err.println("Time limit " + limit2 / 1000L + "s reached.");
            }
            return limitReached;
        }
        return false;
    }

    static final void fillCoordinates(int[] idxes, double[] c, BondTable btab, double[][] intang, MoleculeGraph m) {
        double[] c0 = new double[2];
        double[] c1 = new double[2];
        double[] c2 = new double[2];
        int l = idxes.length;
        c[0] = 0.0;
        c[1] = 0.0;
        c[2] = 1.54;
        c[3] = 0.0;
        for (int i = 2; i < l; ++i) {
            int p = idxes[i - 2];
            int h = idxes[i - 1];
            int n = idxes[i];
            double fi = intang[btab.getBondIndex(p, h)][btab.getBondIndex(h, n)];
            c0[0] = c[(i - 2) * 2];
            c0[1] = c[(i - 2) * 2 + 1];
            c1[0] = c[(i - 1) * 2];
            c1[1] = c[(i - 1) * 2 + 1];
            Clean2D.setXY(c0, c1, c2, fi);
            c[i * 2] = c2[0];
            c[i * 2 + 1] = c2[1];
        }
    }

    static final boolean rectangleCheck(double[] c, int n, double ratio) {
        DPoint3 p1 = new DPoint3(c[0], c[1], 0.0);
        double fi = p1.angle2D(c[2 * n - 2], c[2 * n - 1]);
        CTransform3D T = new CTransform3D();
        T.setIdentity();
        T.setRotation(0.0, 0.0, 1.0, -fi);
        T.setRotationCenter(p1);
        Clean2D.transform(c, T);
        double[] minmax = new double[]{1000.0, -1000.0, 1000.0, -1000.0};
        for (int i = 0; i < n; ++i) {
            double x = c[2 * i];
            double y = c[2 * i + 1];
            if (x > minmax[1]) {
                minmax[1] = x;
            } else if (x < minmax[0]) {
                minmax[0] = x;
            }
            if (y > minmax[3]) {
                minmax[3] = y;
                continue;
            }
            if (!(y < minmax[2])) continue;
            minmax[2] = y;
        }
        double r = Math.abs((minmax[1] - minmax[0]) / (minmax[3] - minmax[2]));
        r = r > 1.0 ? 1.0 / r : r;
        return r < ratio;
    }

    static void initHEXAGON(DPoint3[] h) {
        h[0].x = 0.0;
        h[0].y = 0.0;
        h[0].z = 0.0;
        h[1].x = 0.0;
        h[1].y = 1.54;
        h[1].z = 0.0;
        h[2].x = 1.3336791159999999;
        h[2].y = 2.31;
        h[2].z = 0.0;
        h[3].x = 2.6673582319999998;
        h[3].y = 1.54;
        h[3].z = 0.0;
        h[4].x = 2.6673582319999998;
        h[4].y = 0.0;
        h[4].z = 0.0;
        h[5].x = 1.3336791159999999;
        h[5].y = -0.77;
        h[5].z = 0.0;
    }

    static void initPENTAGON(DPoint3[] h) {
        h[0].x = 0.0;
        h[0].y = 0.0;
        h[0].z = 0.0;
        h[1].x = 0.0;
        h[1].y = 1.54;
        h[1].z = 0.0;
        h[2].x = 1.4646324000000002;
        h[2].y = 2.01586;
        h[2].z = 0.0;
        h[3].x = 2.3698136;
        h[3].y = 0.77;
        h[3].z = 0.0;
        h[4].x = 1.4646324000000002;
        h[4].y = -0.47586;
        h[4].z = 0.0;
    }

    public static boolean checkMolCollapsion(MoleculeGraph m) {
        return Clean2D.checkMolCollapsion(m, null);
    }

    public static boolean checkMolCollapsion(MoleculeGraph m, int[] f) {
        int ac = m.getAtomCount();
        for (int i = 0; i < ac; ++i) {
            MolAtom a = m.getAtom(i);
            double x = a.getX();
            double y = a.getY();
            if (Double.isNaN(x) || Double.isNaN(y)) {
                return true;
            }
            boolean checkA1 = f == null || (f[i] & 0x2000) == 0;
            for (int j = i + 1; j < ac; ++j) {
                boolean checkA2;
                MolAtom a2 = m.getAtom(j);
                double x2 = a2.getX();
                double y2 = a2.getY();
                boolean bl = checkA2 = f == null || (f[j] & 0x2000) == 0;
                if (!checkA1 && !checkA2 || !Double.isNaN(x2) && !Double.isNaN(y2) && (!(Math.abs(x - x2) < 0.0154) || !(Math.abs(y - y2) < 0.0154))) continue;
                return true;
            }
        }
        return false;
    }

    static void correctStructure(MoleculeGraph m) {
        double DELTA = 0.15400000000000003;
        double smallx = 0.0;
        double smally = 0.0;
        int ac = m.getAtomCount();
        int i = 0;
        do {
            boolean reset = false;
            MolAtom a = m.getAtom(i);
            double x = a.getX();
            double y = a.getY();
            if (Double.isNaN(x)) {
                a.setX(smallx);
                smallx += DELTA;
                reset = true;
            }
            if (Double.isNaN(y)) {
                a.setY(smally);
                smally += DELTA;
                reset = true;
            }
            for (int j = i + 1; j < ac && !reset; ++j) {
                MolAtom a2 = m.getAtom(j);
                double x2 = a2.getX();
                double y2 = a2.getY();
                if (Double.isNaN(x2)) {
                    a2.setX(smallx);
                    x2 = a2.getX();
                    smallx += DELTA;
                    reset = true;
                }
                if (Double.isNaN(y)) {
                    a2.setY(smally);
                    y2 = a2.getY();
                    smally += DELTA;
                    reset = true;
                }
                if (!(Math.abs(x - x2) < 0.0154) || !(Math.abs(y - y2) < 0.0154)) continue;
                a2.setX(x + 0.0154 + DELTA);
                a2.setY(y + 0.0154 + DELTA);
                reset = true;
            }
            ++i;
            if (!reset) continue;
            i = 0;
        } while (i < ac);
    }

    static boolean fragsAtTheSamePlace(MoleculeGraph[] mols) {
        int l = mols.length;
        for (int i = 0; i < l; ++i) {
            MoleculeGraph m1 = mols[i];
            DPoint3 c1 = m1.calcCenter();
            for (int j = i + 1; j < l; ++j) {
                DPoint3 c2;
                MoleculeGraph m2 = mols[j];
                if (m1.getAtomCount() != m2.getAtomCount() || !(c1.distance2D(c2 = m2.calcCenter()) < 0.154)) continue;
                return true;
            }
        }
        return false;
    }

    static void bondCrossArrangement(MoleculeGraph m, int[] atomFlags) {
        BitSet adamantaneBondSet = null;
        BitSet verticalBondSet = null;
        int bc = m.getBondCount();
        for (int i = 0; i < bc; ++i) {
            MolBond b = m.getBond(i);
            MolAtom a1 = b.getAtom1();
            MolAtom a2 = b.getAtom2();
            int i1 = m.indexOf(a1);
            int i2 = m.indexOf(a2);
            int f1 = atomFlags[i1];
            int f2 = atomFlags[i2];
            if ((f1 & 0x200000) == 0 || (f2 & 0x200000) == 0) continue;
            if (adamantaneBondSet == null) {
                adamantaneBondSet = new BitSet(bc);
            }
            adamantaneBondSet.set(i);
            if (!(Math.abs(a1.getX() - a2.getX()) <= 0.001)) continue;
            if (verticalBondSet == null) {
                verticalBondSet = new BitSet(bc);
            }
            verticalBondSet.set(i);
        }
        if (verticalBondSet != null) {
            int to;
            MolBond[] bonds = new MolBond[bc];
            for (int i = 0; i < bc; ++i) {
                bonds[i] = m.getBond(i);
            }
            adamantaneBondSet.xor(verticalBondSet);
            BitSet s = verticalBondSet;
            int i = s.nextSetBit(0);
            while (i >= 0 && (to = adamantaneBondSet.length() - 1) > i) {
                adamantaneBondSet.clear(to);
                bonds[i] = m.getBond(to);
                bonds[to] = m.getBond(i);
                i = s.nextSetBit(i + 1);
            }
            m.sortBondsAccordingTo(bonds);
        }
    }

    static BitSet getSmallringBondSet(Molecule m) {
        BitSet srs = new BitSet();
        BondTable btab = m.getBondTable();
        int[][] sssr = m.getSSSR();
        for (int i = 0; i < sssr.length; ++i) {
            int[] r = sssr[i];
            int l = r.length;
            if (l >= 8) continue;
            for (int j = 0; j < l; ++j) {
                int h = r[j];
                int n = r[(j + 1) % l];
                int bidx = btab.getBondIndex(h, n);
                srs.set(bidx);
            }
        }
        return srs;
    }

    static boolean cisTransInformationCheck(MoleculeGraph target, MoleculeGraph query, int[] map, BitSet smallRingBond) {
        int bc = query.getBondCount();
        for (int i = 0; i < bc; ++i) {
            int ac;
            MolBond b;
            MolAtom a;
            MolBond qb = query.getBond(i);
            MolAtom qa2 = qb.getAtom1();
            MolAtom qa3 = qb.getAtom2();
            int qi2 = query.indexOf(qa2);
            int qi3 = query.indexOf(qa3);
            int ti2 = map[qi2];
            int ti3 = map[qi3];
            if (ti2 < 0 && ti3 >= 0) {
                a = new MolAtom(1);
                b = new MolBond(a, target.getAtom(ti3), 1);
                target.add(a);
                target.add(b);
                ac = target.getAtomCount();
                map[qi2] = ac - 1;
                ti2 = ac - 1;
                continue;
            }
            if (ti2 < 0 || ti3 >= 0) continue;
            a = new MolAtom(1);
            b = new MolBond(a, target.getAtom(ti2), 1);
            target.add(a);
            target.add(b);
            ac = target.getAtomCount();
            map[qi3] = ac - 1;
            ti3 = ac - 1;
        }
        BondTable tbtab = target.getBondTable();
        for (int i = 0; i < bc; ++i) {
            MolAtom ta4;
            MolAtom ta1;
            MolBond qb = query.getBond(i);
            MolAtom qa2 = qb.getAtom1();
            MolAtom qa3 = qb.getAtom2();
            int qi2 = query.indexOf(qa2);
            int qi3 = query.indexOf(qa3);
            int ti2 = map[qi2];
            int ti3 = map[qi3];
            if (ti2 < 0 || ti3 < 0) continue;
            int tbidx = tbtab.getBondIndex(ti2, ti3);
            if (!target.canBeCT(ti2, ti3, false) || smallRingBond.get(tbidx)) continue;
            MolAtom qa1 = qb.getCTAtom1();
            MolAtom qa4 = qb.getCTAtom4();
            if (qa1 == null || qa4 == null) continue;
            int qs = qb.calcStereo2(qa1, qa4);
            int qi1 = query.indexOf(qa1);
            int qi4 = query.indexOf(qa4);
            int ti1 = map[qi1];
            int ti4 = map[qi4];
            MolBond tb = target.getBond(tbidx);
            int ts = tb.calcStereo2(ta1 = target.getAtom(ti1), ta4 = target.getAtom(ti4));
            if (ts == qs) continue;
            return false;
        }
        return true;
    }

    static void SSSWorkAround(Molecule m) {
        int ac = m.getAtomCount();
        for (int i = 0; i < ac; ++i) {
            MolAtom a = m.getAtom(i);
            if (a.getBondCount() <= 1 || a.getAtno() != 1) continue;
            a.setAtno(131);
        }
    }

    static MoleculeGraph getFixedClone(MoleculeGraph m) {
        MoleculeGraph clone = (MoleculeGraph)m.clone();
        for (MolAtom a : clone.getAtomArray()) {
            a.setZ(2.0);
        }
        return clone;
    }

    static void SMILES_withID(MoleculeGraph origm, int[] fragID) throws IOException {
        Molecule m = (Molecule)origm.clone();
        for (int i = 0; i < m.getAtomCount(); ++i) {
            MolAtom a = m.getAtom(i);
            a.setAtomMap(fragID[i] & 0xFFFF);
        }
        System.err.println(MolExporter.exportToFormat(m, "smiles"));
    }

    static void saveMoleculeToFile(MoleculeGraph origm) throws IOException {
        FileOutputStream out = null;
        try {
            out = new FileOutputStream("save1.sdf");
        }
        catch (IOException e) {
            // empty catch block
        }
        Molecule m = (Molecule)origm.clone();
        byte[] data = MolExporter.exportToBinFormat(m, "mol");
        if (data != null) {
            try {
                ((OutputStream)out).write(data);
                System.err.println(" mol saved to save1.sdf");
            }
            catch (IOException e) {
                // empty catch block
            }
        }
    }

    static void saveMoleculeToFile(MoleculeGraph origm, String filename) {
        Clean2D.saveMoleculeToFile(origm, false, filename);
    }

    static void saveMoleculeToFile(MoleculeGraph origm, int[] fragID, OutputStream out, String name) {
        MolAtom a;
        int i;
        if (out == null) {
            try {
                out = new FileOutputStream("save.sdf");
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        Molecule m = (Molecule)origm.clone();
        for (i = m.getAtomCount() - 1; i >= 0; --i) {
            a = m.getAtom(i);
            a.setAtomMap(i + 1);
        }
        for (i = m.getAtomCount() - 1; i >= 0; --i) {
            a = m.getAtom(i);
            if (a.getZ() == 2.0) continue;
            m.removeAtom(a);
        }
        Clean2D.setDimensionByReflection(2, m);
        Clean2D.setZ(m, 0.0);
        m.setProperty("Name", name);
        try {
            byte[] data = MolExporter.exportToBinFormat(m, "sdf");
            if (data != null) {
                out.write(data);
            }
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
    }

    private static void setDimensionByReflection(int d, Molecule m) {
        try {
            Field field = m.getClass().getSuperclass().getDeclaredField("DIM_MASK");
            field.setAccessible(true);
            int DIM_MASK = field.getInt(m);
            field = m.getClass().getSuperclass().getDeclaredField("flags");
            field.setAccessible(true);
            int flags = field.getInt(m);
            flags = flags & DIM_MASK | d & DIM_MASK;
            field.setInt(m, flags);
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    static void saveMoleculeToFile(MoleculeGraph origm, boolean fixedOnly, String filename) {
        MolAtom a;
        int i;
        FileOutputStream out = null;
        int dot = filename.lastIndexOf(".");
        String format2 = filename.substring(dot + 1);
        try {
            out = new FileOutputStream(filename);
        }
        catch (IOException e) {
            // empty catch block
        }
        Molecule m = null;
        if (!(origm instanceof Molecule)) {
            int ac = origm.getAtomCount();
            double[] c = new double[ac * 2];
            for (int i2 = 0; i2 < ac; ++i2) {
                MolAtom a2 = origm.getAtom(i2);
                c[i2 * 2] = a2.getX();
                c[i2 * 2 + 1] = a2.getY();
            }
            Clean2D.doubleArray_toMolecule(c, filename);
            return;
        }
        m = (Molecule)origm.clone();
        for (i = m.getAtomCount() - 1; i >= 0; --i) {
            a = m.getAtom(i);
            a.setAtomMap(i + 1);
        }
        if (fixedOnly) {
            for (i = m.getAtomCount() - 1; i >= 0; --i) {
                a = m.getAtom(i);
                if (a.getZ() == 2.0) continue;
                m.removeAtom(a);
            }
        }
        Clean2D.setZ(m, 0.0);
        if (m.getDim() < 2) {
            Clean2D.setDimensionByReflection(2, m);
        }
        try {
            String data = MolExporter.exportToFormat(m, format2);
            if (data != null) {
                ((OutputStream)out).write(data.getBytes());
                System.err.println(" mol saved to " + filename);
            }
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
    }

    static void doubleArray_toMolecule(double[] c, String name) {
        int i;
        Molecule m = new Molecule();
        int l = c.length / 2;
        for (i = 0; i < l; ++i) {
            MolAtom a = new MolAtom(c[i * 2], c[i * 2 + 1]);
            m.add(a);
        }
        for (i = 0; i < l; ++i) {
            MolAtom a1 = m.getAtom(i);
            MolAtom a2 = m.getAtom((i + 1) % l);
            MolBond b = new MolBond(a1, a2);
            m.add(b);
        }
        Clean2D.saveMoleculeToFile(m, false, name);
    }

    static String getInfo(MoleculeGraph mg) {
        String s = null;
        try {
            Molecule m = (Molecule)mg;
            for (int i = 0; i < m.getPropertyCount(); ++i) {
                String p = m.getPropertyKey(i);
                if (p.indexOf("name") != -1) {
                    return MPropHandler.convertToString(m.properties(), p);
                }
                if (p.indexOf("id") == -1) continue;
                return MPropHandler.convertToString(m.properties(), p);
            }
            s = MolExporter.exportToFormat(m, "smiles:S");
        }
        catch (Exception e) {
            s = "The molecule cannot be represented as SMILES";
        }
        return s;
    }

    static void printAtomFlags(int[] atomFlags, int[] fragID) {
        for (int i = 0; i < atomFlags.length; ++i) {
            int f = atomFlags[i];
            int id = fragID != null ? fragID[i] & 0xFFFF : 0;
            int sid = fragID != null ? fragID[i] >> 16 : 0;
            System.err.println(i + 1 + " id " + id + " stereoID " + sid + " " + ((f & 1) != 0 ? "RINGATOM " : "") + ((f & 0x80) != 0 ? "BRANCHSTART " : "") + ((f & 2) != 0 ? "CHAINATOM " : "") + ((f & 4) != 0 ? "TERMINALATOM " : "") + ((f & 8) != 0 ? "STEREOATOM " : "") + ((f & 0x400) != 0 ? "STEREO_FIXED " : "") + ((f & 0x10) != 0 ? "LONEATOM " : "") + ((f & 0x20) != 0 ? "SMALLFRAG " : "") + ((f & 0x1000) != 0 ? "LONEDBSTEREO " : "") + ((f & 0x200) != 0 ? "FIXED_AT_PARTIALCLEAN " : "") + ((f & 0x800) != 0 ? "PARTIALLY_FIXED " : "") + ((f & 0x40) != 0 ? "DEGENERATE " : "") + ((f & 0x40000) != 0 ? "LONGESTCHAIN " : ""));
        }
    }

    static void printAtomFlags(int f) {
        System.err.println(" " + ((f & 1) != 0 ? "RINGATOM " : "") + ((f & 0x80) != 0 ? "BRANCHSTART " : "") + ((f & 2) != 0 ? "CHAINATOM " : "") + ((f & 4) != 0 ? "TERMINALATOM " : "") + ((f & 8) != 0 ? "STEREOATOM " : "") + ((f & 0x400) != 0 ? "STEREO_FIXED " : "") + ((f & 0x10) != 0 ? "LONEATOM " : "") + ((f & 0x20) != 0 ? "SMALLFRAG " : "") + ((f & 0x1000) != 0 ? "LONEDBSTEREO " : "") + ((f & 0x200) != 0 ? "FIXED_AT_PARTIALCLEAN " : "") + ((f & 0x800) != 0 ? "PARTIALLY_FIXED " : "") + ((f & 0x40) != 0 ? "DEGENERATE " : "") + ((f & 0x40000) != 0 ? "LONGESTCHAIN " : ""));
    }

    static void fixedAtomIdxes(MoleculeGraph m) {
        StringBuffer s = new StringBuffer("Fixed atom indexes :");
        for (int i = 0; i < m.getAtomCount(); ++i) {
            MolAtom a = m.getAtom(i);
            if (!Clean2D.isFixed(a)) continue;
            s.append(i + 1 + " ");
        }
        System.err.println(s.toString());
    }

    static boolean isFixed(MolAtom a) {
        return a.getZ() == 2.0;
    }

    static void printIntAng(int idx, MoleculeGraph m, double[][] intang) {
        int[][] ctab = m.getCtab();
        int[] an = ctab[idx];
        for (int i = 0; i < an.length; ++i) {
            for (int j = 0; j < an.length; ++j) {
                Clean2D.printIntAng(an[i], idx, an[j], m, intang);
            }
        }
    }

    static void printIntAng(int i, int j, int k, MoleculeGraph m, double[][] intang) {
        BondTable btab = m.getBondTable();
        int b1 = btab.getBondIndex(i, j);
        int b2 = btab.getBondIndex(j, k);
        if (b1 >= 0 && b2 >= 0) {
            System.out.println(i + 1 + "-" + (j + 1) + "-" + (k + 1) + " " + intang[b1][b2]);
        }
    }

    static void printIntAng(int c, int p, MoleculeGraph m, double[][] intang) {
        int[][] ctab = m.getCtab();
        BondTable btab = m.getBondTable();
        int[] an = ctab[c];
        int b1 = btab.getBondIndex(c, p);
        for (int i = 0; i < an.length; ++i) {
            if (an[i] == p) continue;
            int b2 = btab.getBondIndex(c, an[i]);
            System.out.println(p + 1 + "-" + (c + 1) + "-" + (an[i] + 1) + " " + intang[b1][b2]);
        }
    }

    static void printIntAng(MoleculeGraph m, double[][] intang) {
        int[][] ctab = m.getCtab();
        BondTable btab = m.getBondTable();
        for (int i = 0; i < ctab.length; ++i) {
            int[] an = ctab[i];
            int b1 = btab.getBondIndex(i, an[0]);
            for (int j = 1; j < an.length; ++j) {
                int b2 = btab.getBondIndex(i, an[j]);
                System.out.println(an[0] + 1 + "-" + (i + 1) + "-" + (an[j] + 1) + " " + intang[b1][b2]);
            }
        }
    }

    static void printBitSetVector(Vector<BitSet> v) {
        for (int i = 0; i < v.size(); ++i) {
            BitSet s = v.get(i);
            System.err.println(i + "th " + s);
        }
    }

    static void print(int[][] x) {
        for (int i = 0; i < x.length; ++i) {
            Clean2D.print(x[i]);
        }
    }

    static void print(int[] x) {
        for (int i = 0; i < x.length; ++i) {
            System.err.print(x[i] + " ");
        }
        System.err.println();
    }

    static void print(boolean[] x) {
        for (int i = 0; i < x.length; ++i) {
            if (!x[i]) continue;
            System.err.print(i + " ");
        }
        System.err.println();
    }

    static void print(MolAtom[] a, MoleculeGraph m) {
        for (int i = 0; i < a.length; ++i) {
            System.err.print(m.indexOf(a[i]) + " ");
        }
        System.err.println();
    }

    static void printZ(MoleculeGraph m) {
        for (int i = 0; i < m.getAtomCount(); ++i) {
            MolAtom a = m.getAtom(i);
            System.err.println(i + " " + a.getZ());
        }
    }

    static void print(double[] x) {
        for (int i = 0; i < x.length; ++i) {
            System.err.print(x[i] + " ");
        }
        System.err.println();
    }

    static void print(double[][] x) {
        for (int i = 0; i < x.length; ++i) {
            for (int j = 0; j < x[i].length; ++j) {
                System.err.print(x[i][j] + " ");
            }
            System.err.println();
        }
    }

    static void printBond(int idx, MoleculeGraph m) {
        MolBond b = m.getBond(idx);
        System.err.println(m.indexOf(b.getAtom1()) + 1 + "-" + (m.indexOf(b.getAtom2()) + 1));
    }

    static void printDoubleCol(double[] x, int n) {
        int l = n <= 0 ? x.length / 2 : n;
        for (int i = 0; i < l; ++i) {
            System.err.println(x[i * 2] + " " + x[i * 2 + 1]);
        }
        System.err.println();
    }

    static void printset(long x) {
        for (int i = 0; i < 64; ++i) {
            long bit = 1L << i;
            if ((bit & x) != bit) continue;
            System.err.print(i + " ");
        }
        System.err.println();
    }

    static void printFixedIdxes(MoleculeGraph m) {
        System.err.println("Fixed indexes ");
        for (int i = m.getAtomCount() - 1; i >= 0; --i) {
            MolAtom a = m.getAtom(i);
            if (a.getZ() != 2.0) continue;
            System.err.print(i + 1 + " ");
        }
        System.err.println();
    }

    static String toString(Object[] v) {
        StringBuffer s = new StringBuffer();
        for (int i = 0; i < v.length; ++i) {
            s.append(" " + v);
        }
        return s.toString();
    }

    static String toString(IntVector v) {
        StringBuffer s = new StringBuffer();
        for (int i = 0; i < v.size(); ++i) {
            s.append(" " + (v.get(i) + 1));
        }
        return s.toString();
    }

    static String toStringCT(int flag) {
        int f = flag & 0xC0;
        return f == 192 ? "CISTRANS" : (f == 128 ? "CIS" : (f == 64 ? "TRANS" : ""));
    }

    private static void distanceMatrix(BondTable btab, int[][] d, int[][] pred) {
        int j;
        int c = btab.getAtomCount();
        for (int i = 0; i < c; ++i) {
            for (j = i + 1; j < c; ++j) {
                if (btab.getBondIndex(i, j) != -1) {
                    d[i][j] = 1;
                    d[j][i] = 1;
                    pred[i][j] = i;
                    pred[j][i] = j;
                    continue;
                }
                d[i][j] = c;
                d[j][i] = c;
                pred[i][j] = -1;
                pred[j][i] = -1;
            }
        }
        for (int k = 0; k < c; ++k) {
            for (j = 0; j < c; ++j) {
                for (int i = 0; i < c; ++i) {
                    int s = d[i][k] + d[k][j];
                    if (s >= d[i][j]) continue;
                    d[i][j] = s;
                    pred[i][j] = pred[k][j];
                }
            }
        }
    }

    private static int getPath(int a, int b, int[] nodes, int[][] pred) {
        int len = 0;
        while (pred[a][b] != -1 && a != b) {
            nodes[len++] = b;
            b = pred[a][b];
        }
        nodes[len++] = a;
        return len;
    }

    public static void printMol(MoleculeGraph m) {
        int i;
        System.err.println(m);
        System.err.println("Dim " + m.getDim());
        System.err.println("Atoms :" + m.getAtomCount());
        System.err.println("Bonds :" + m.getBondCount());
        for (i = 0; i < m.getAtomCount(); ++i) {
            MolAtom a = m.getAtom(i);
            System.err.println(i + " atom " + a.toString() + " " + a.getLocation());
        }
        for (i = 0; i < m.getBondCount(); ++i) {
            MolBond b = m.getBond(i);
            MolAtom a1 = b.getAtom1();
            MolAtom a2 = b.getAtom2();
            System.err.println("bond " + i + ": " + m.indexOf(a1) + " " + m.indexOf(a2));
        }
    }

    private class PartialOptimization
    extends FRPRMinimalization {
        private static final int WEIGHT_OF_BONDLENGTH = 20;
        private static final int WEIGHT_OF_DISTANCE = 5;
        private static final int WEIGHT_OF_RINGSYMM = 20;
        private static final int WEIGHT_OF_REALTIVEFIX = 1000;
        private static final double CCLENGTH = 1.54;
        private static final double DIST_LIMIT = 3.0;
        private double distLimit = 21.3444;
        private int[] eP1;
        private int[] eP2;
        private BondTable btab;
        private boolean[] fixed;
        private int[][] rings;
        private double[] idealR;
        private double[] centersX;
        private double[] centersY;
        private int[] feP1;
        private int[] feP2;
        private double[] idealDistance;

        private PartialOptimization() {
        }

        @Override
        double f(double[] x) throws Exception {
            double d2;
            double d;
            double ty2;
            int ep1;
            int i;
            double sumA = 0.0;
            double sumB = 0.0;
            double sumC = 0.0;
            double sumD = 0.0;
            int l = this.eP1.length;
            for (i = 0; i < l; ++i) {
                ep1 = this.eP1[i];
                int ep2 = this.eP2[i];
                double tx = x[ep1 * 2] - x[ep2 * 2];
                double tx2 = tx * tx;
                double ty = x[ep1 * 2 + 1] - x[ep2 * 2 + 1];
                ty2 = ty * ty;
                d = Math.sqrt(tx2 + ty2) - 1.54;
                d2 = d * d;
                sumA += d2;
            }
            sumA *= 20.0;
            l = x.length / 2;
            for (i = 0; i < l; ++i) {
                for (int j = i + 1; j < l; ++j) {
                    if (this.btab.getBondIndex(i, j) >= 0) continue;
                    double tx = x[i * 2] - x[j * 2];
                    double ty = x[i * 2 + 1] - x[j * 2 + 1];
                    double sum = tx * tx + ty * ty;
                    if (sum == 0.0) {
                        throw new Exception("division by zero: In optimization f function elements " + i + " " + j);
                    }
                    if (!(sum < this.distLimit)) continue;
                    sumB += 1.0 / sum;
                }
            }
            sumB *= 5.0;
            if (this.rings != null) {
                int i2;
                int rsl = this.rings.length;
                for (i2 = 0; i2 < rsl; ++i2) {
                    int[] ring = this.rings[i2];
                    int rl = ring.length;
                    double sx = 0.0;
                    double sy = 0.0;
                    for (int j = 0; j < rl; ++j) {
                        int aN = ring[j];
                        sx += x[aN * 2];
                        sy += x[aN * 2 + 1];
                    }
                    this.centersX[i2] = sx / (double)rl;
                    this.centersY[i2] = sy / (double)rl;
                }
                for (i2 = 0; i2 < rsl; ++i2) {
                    int[] ring = this.rings[i2];
                    double d22 = 0.0;
                    for (int aN : ring) {
                        double dx = x[aN * 2] - this.centersX[i2];
                        double dy = x[aN * 2 + 1] - this.centersY[i2];
                        double d3 = Math.sqrt(dx * dx + dy * dy) - this.idealR[i2];
                        d22 += d3 * d3;
                    }
                    sumC += d22 * 20.0;
                }
            }
            l = this.feP1 == null ? 0 : this.feP1.length;
            for (i = 0; i < l; ++i) {
                ep1 = this.feP1[i];
                int ep2 = this.feP2[i];
                double tx = x[ep1 * 2] - x[ep2 * 2];
                double tx2 = tx * tx;
                double ty = x[ep1 * 2 + 1] - x[ep2 * 2 + 1];
                ty2 = ty * ty;
                d = Math.sqrt(tx2 + ty2) - this.idealDistance[i];
                d2 = d * d;
                sumD += d2;
            }
            sumD *= 1000.0;
            return sumA + sumB + sumC;
        }

        @Override
        double[] df(double[] x, double[] d) {
            double dfdy;
            double dfdx;
            double prod;
            double diffFromIdeal;
            double recsqrt;
            double sqrt;
            double ty2;
            double tx2;
            int ep1;
            int j;
            double prefix1 = 40.0;
            int l = this.eP1.length;
            for (j = 0; j < l; ++j) {
                ep1 = this.eP1[j];
                int ep2 = this.eP2[j];
                double tx = x[ep1 * 2] - x[ep2 * 2];
                tx2 = tx * tx;
                double ty = x[ep1 * 2 + 1] - x[ep2 * 2 + 1];
                ty2 = ty * ty;
                sqrt = Math.sqrt(tx2 + ty2);
                recsqrt = 1.0 / sqrt;
                diffFromIdeal = sqrt - 1.54;
                prod = prefix1 * diffFromIdeal * recsqrt;
                dfdx = prod * tx;
                dfdy = prod * ty;
                if (!this.fixed[ep1]) {
                    int n = ep1 * 2;
                    d[n] = d[n] + dfdx;
                    int n2 = ep1 * 2 + 1;
                    d[n2] = d[n2] + dfdy;
                }
                if (this.fixed[ep2]) continue;
                int n = ep2 * 2;
                d[n] = d[n] - dfdx;
                int n3 = ep2 * 2 + 1;
                d[n3] = d[n3] - dfdy;
            }
            l = x.length / 2;
            prefix1 = -10.0;
            for (int i = 0; i < l; ++i) {
                for (int j2 = i + 1; j2 < l; ++j2) {
                    double ty;
                    double tx;
                    double sum;
                    if (this.btab.getBondIndex(i, j2) >= 0 || this.fixed[i] && this.fixed[j2] || !((sum = (tx = x[i * 2] - x[j2 * 2]) * tx + (ty = x[i * 2 + 1] - x[j2 * 2 + 1]) * ty) < this.distLimit)) continue;
                    double prefix2 = prefix1 / (sum * sum);
                    double dfdx2 = prefix2 * tx;
                    double dfdy2 = prefix2 * ty;
                    if (!this.fixed[i]) {
                        int n = i * 2;
                        d[n] = d[n] + dfdx2;
                        int n4 = i * 2 + 1;
                        d[n4] = d[n4] + dfdy2;
                    }
                    if (this.fixed[j2]) continue;
                    int n = j2 * 2;
                    d[n] = d[n] - dfdx2;
                    int n5 = j2 * 2 + 1;
                    d[n5] = d[n5] - dfdy2;
                }
            }
            prefix1 = 40.0;
            if (this.rings != null) {
                int rsl = this.rings.length;
                for (int i = 0; i < rsl; ++i) {
                    int[] ring = this.rings[i];
                    int rl = ring.length;
                    double prefix2 = prefix1 * (double)(rl - 1) / (double)rl;
                    for (int j3 = 0; j3 < rl; ++j3) {
                        int aN = ring[j3];
                        if (this.fixed[aN]) continue;
                        double dx = x[aN * 2] - this.centersX[i];
                        double dy = x[aN * 2 + 1] - this.centersY[i];
                        double dk = Math.sqrt(dx * dx + dy * dy);
                        dk = dk == 0.0 ? FRPRMinimalization.EPS : dk;
                        double prefix3 = prefix2 * (dk - this.idealR[i]) / dk;
                        int n = aN * 2;
                        d[n] = d[n] + prefix3 * dx;
                        int n6 = aN * 2 + 1;
                        d[n6] = d[n6] + prefix3 * dy;
                    }
                }
            }
            prefix1 = 2000.0;
            l = this.feP1 == null ? 0 : this.feP1.length;
            for (j = 0; j < l; ++j) {
                ep1 = this.feP1[j];
                int ep2 = this.feP2[j];
                double tx = x[ep1 * 2] - x[ep2 * 2];
                tx2 = tx * tx;
                double ty = x[ep1 * 2 + 1] - x[ep2 * 2 + 1];
                ty2 = ty * ty;
                sqrt = Math.sqrt(tx2 + ty2);
                recsqrt = 1.0 / sqrt;
                diffFromIdeal = sqrt - this.idealDistance[j];
                prod = prefix1 * diffFromIdeal * recsqrt;
                dfdx = prod * tx;
                dfdy = prod * ty;
                if (!this.fixed[ep1]) {
                    int n = ep1 * 2;
                    d[n] = d[n] + dfdx;
                    int n7 = ep1 * 2 + 1;
                    d[n7] = d[n7] + dfdy;
                }
                if (this.fixed[ep2]) continue;
                int n = ep2 * 2;
                d[n] = d[n] - dfdx;
                int n8 = ep2 * 2 + 1;
                d[n8] = d[n8] - dfdy;
            }
            return d;
        }

        static /* synthetic */ int[] access$102(PartialOptimization x0, int[] x1) {
            x0.eP1 = x1;
            return x1;
        }

        static /* synthetic */ int[] access$202(PartialOptimization x0, int[] x1) {
            x0.eP2 = x1;
            return x1;
        }

        static /* synthetic */ boolean[] access$302(PartialOptimization x0, boolean[] x1) {
            x0.fixed = x1;
            return x1;
        }

        static /* synthetic */ double[] access$502(PartialOptimization x0, double[] x1) {
            x0.idealR = x1;
            return x1;
        }

        static /* synthetic */ double[] access$602(PartialOptimization x0, double[] x1) {
            x0.centersX = x1;
            return x1;
        }

        static /* synthetic */ double[] access$702(PartialOptimization x0, double[] x1) {
            x0.centersY = x1;
            return x1;
        }

        static /* synthetic */ int[][] access$802(PartialOptimization x0, int[][] x1) {
            x0.rings = x1;
            return x1;
        }
    }
}

