/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.calculations.clean;

import chemaxon.calculations.clean.Opt3D;
import chemaxon.calculations.hydrogenize.Hydrogenize;
import chemaxon.common.util.MProgressMonitor;
import chemaxon.core.spi.Clean3DIface;
import chemaxon.formats.MolExporter;
import chemaxon.license.LicenseHandler;
import chemaxon.marvin.modelling.CleanArgs;
import chemaxon.marvin.modelling.CleanSettings;
import chemaxon.marvin.modelling.build.fafuse.FragmentStore;
import chemaxon.marvin.modelling.build.fafuse.FuseBuilder;
import chemaxon.marvin.modelling.debug.SimpleVerbosePrinter;
import chemaxon.marvin.modelling.debug.VerbosePrinter;
import chemaxon.marvin.modelling.debug.debugPrintout;
import chemaxon.marvin.modelling.diag.Instrumentation;
import chemaxon.marvin.modelling.interfacing.CalculationAbortedException;
import chemaxon.marvin.modelling.interfacing.CalculationFailedException;
import chemaxon.marvin.modelling.interfacing.CxnMoleculeAdapter;
import chemaxon.marvin.modelling.interfacing.CxnMoleculeInput;
import chemaxon.marvin.modelling.interfacing.InvokeCalculation;
import chemaxon.marvin.modelling.interfacing.InvokeFAFBuildCalculation;
import chemaxon.marvin.modelling.interfacing.InvokeFFFBuildCalculation;
import chemaxon.marvin.modelling.interfacing.InvokeMinkowskiCalculation;
import chemaxon.marvin.modelling.interfacing.MultipleConformerResult;
import chemaxon.marvin.modelling.interfacing.OptimizerCalculation;
import chemaxon.marvin.modelling.interfacing.RandomCoordinatesCalculation;
import chemaxon.marvin.modelling.linalg.V;
import chemaxon.marvin.modelling.linalg.multiDim;
import chemaxon.marvin.modelling.struc.ConformersDescriptor;
import chemaxon.marvin.modelling.struc.myMolecule;
import chemaxon.marvin.modelling.util.myList;
import chemaxon.marvin.util.MulticenterTransform;
import chemaxon.struc.Molecule;
import java.io.IOException;

public class Clean3D
implements Clean3DIface {
    public static final double EPS = 1.0E-4;
    public static int OPT_counter_dreidingvdwcount = 0;
    public static boolean OPT_killflags = true;
    public static double OPT_CP_MINMET = 2.0;
    public static double OPT_CP_MINORTHOCANDIDATE = 0.2;
    public static double OPT_CP_EPS = 1.0E-4;
    public static boolean OPT_CP_ONETORSION = true;
    public static boolean OPT_CP_SKIP_NONPLACED_WISHES = true;
    public static boolean OPT_CP_OPTIMIZEONLYTHELASTRINGCLOSE = false;
    static double OPT_CP_RICT_MAX_DRMSD0 = 20.0;
    static double OPT_CP_RICT_MAX_DRMSD1 = 100.0;
    static double OPT_CP_OPTIM_MAX_DDENERGY = 10000.0;
    public static boolean OPT_CP_NOTORSIONIFDETERMINED = true;
    public static boolean OPT_CP_RICTENABLED = true;
    public static boolean OPT_DEBUG_SKIPBUILD = false;
    protected static boolean skipOneLicenseCheck = false;
    protected static boolean skipOneLicenseCheckRequested = false;
    boolean MERGETOBUILDMOL = false;
    public static boolean noCleanReinvoke = false;
    private boolean restrictConformerCount = true;

    public static void reset() {
        OPT_counter_dreidingvdwcount = 0;
        noCleanReinvoke = false;
        CleanArgs.reset();
    }

    public static void resetReinvokeDependents() {
        CleanArgs.resetReinvokeDependents();
    }

    private void reportOptionError(String cause) {
        System.err.println("ERROR IN OPTIONS: " + cause);
        throw new UnsupportedOperationException(cause);
    }

    private void processOptionFragsequence(int ca, debugPrintout debug, String arg1s) {
        if (ca == 0) {
            this.reportOptionError("No argument given for option [fragsequence]. Use 1 for balanced or 2 for unbalanced");
        }
        if (ca > 1) {
            this.reportOptionError("Too many argument given for option [fragsequence]. Use 1 for balanced or 2 for unbalanced");
        }
        if (arg1s.equalsIgnoreCase("1")) {
            CleanArgs.OPT_FRAGSEQUENCE = 1;
        } else if (arg1s.equalsIgnoreCase("2")) {
            CleanArgs.OPT_FRAGSEQUENCE = 2;
        } else {
            this.reportOptionError("Invalid argument given for option [fragsequence]. Use 1 for balanced or 2 for unbalanced");
        }
    }

    private void processOptionReinvoked(int ca, debugPrintout debug, String arg1s) {
        if (ca > 0) {
            this.reportOptionError("An argument passed for option [reinvoked].");
        }
        CleanArgs.CLEANER_REINVOKED = true;
    }

    private void processOptionOptimizer(int ca, debugPrintout debug, String arg1s) {
        if (ca == 0) {
            this.reportOptionError("No optimizer selection argument given for option [optimizer]. Use 0 or 1");
        }
        if (arg1s.equalsIgnoreCase("0")) {
            CleanArgs.OPT_OPTIMIZERTOUSE = 1;
            System.err.println("Warning! Using IS optimizer not recommended.");
        } else if (arg1s.equalsIgnoreCase("1")) {
            CleanArgs.OPT_OPTIMIZERTOUSE = 2;
        } else {
            this.reportOptionError("Missing or invalid optimizer selection in option [optimizer]. Use 0 or 1");
        }
        if (ca > 1) {
            this.reportOptionError("More than 1 argument given for option [optimizer].");
        }
    }

    private boolean processOption(String[] opt, debugPrintout debug) {
        String arg5s;
        String co = opt.length > 0 ? opt[0] : "";
        int ca = opt.length - 1;
        String arg1s = ca >= 1 ? opt[1] : "";
        String arg2s = ca >= 2 ? opt[2] : "";
        String arg3s = ca >= 3 ? opt[3] : "";
        String arg4s = ca >= 4 ? opt[4] : "";
        String string = arg5s = ca >= 5 ? opt[5] : "";
        if (co.equalsIgnoreCase("optimizer")) {
            this.processOptionOptimizer(ca, debug, arg1s);
            return true;
        }
        if (co.equalsIgnoreCase("fragsequence")) {
            this.processOptionFragsequence(ca, debug, arg1s);
            return true;
        }
        return false;
    }

    @Override
    public int optimization3D(Molecule mol, String opts, MProgressMonitor pmon) {
        if (noCleanReinvoke) {
            throw new UnsupportedOperationException("Clean3D reentry disabled");
        }
        if (mol == null || mol.getAtomCount() == 0) {
            if (mol != null) {
                mol.setDim(3);
            }
            return 0;
        }
        if (opts == null) {
            opts = "";
        }
        Clean3D.reset();
        CleanArgs.CLEANER_REINVOKED = false;
        if (opts.indexOf("[reinvoked]") >= 0) {
            CleanArgs.CLEANER_REINVOKED = true;
        }
        if (!CleanArgs.CLEANER_REINVOKED) {
            Clean3D.resetReinvokeDependents();
        }
        MulticenterTransform mct = new MulticenterTransform();
        mct.transformMulticenters(mol);
        int ret = this.modfunc_0(mol, opts, pmon);
        mct.restoreMulticenters(mol);
        return ret;
    }

    private int modfunc_0(Molecule orig, String opts, MProgressMonitor pmon) {
        boolean cleanAborted;
        boolean cleanFailed;
        boolean cleanFailedOrAborted;
        CxnMoleculeInput input;
        int addedHCount;
        CleanSettings cleanSettings;
        block119: {
            Molecule orig_clone;
            block118: {
                cleanSettings = new CleanSettings(orig, pmon);
                String[][] opt = cleanSettings.tokenizeOptions(opts);
                VerbosePrinter vp = cleanSettings.getVerbosePrinter("C3Dstart");
                SimpleVerbosePrinter generalvp = cleanSettings.getVerbosePrinter(CleanSettings.Verbosers.GENERAL);
                if (generalvp.isVerbosityLevelEnabled(1)) {
                    generalvp.print(1, "3D generation invoked, opts=" + opts);
                    if (generalvp.isVerbosityLevelEnabled(2)) {
                        generalvp.print(2, "Input structure: " + cleanSettings.getSourceSmiles());
                        generalvp.print(2, "Verbose level configuration for different verbose printers:");
                        for (CleanSettings.Verbosers v : CleanSettings.Verbosers.values()) {
                            generalvp.print(2, "    printer: " + v.getName() + " level: " + cleanSettings.getVerbosePrinter(v).getMaxEnabledLevel());
                        }
                    }
                }
                CleanArgs.checkToPrintHelpMessage(opts);
                debugPrintout debug = CleanArgs.getDebug();
                if (debug != null && debug.getWillPrint()) {
                    System.err.println("WARNING: Clean reentry disabled");
                    noCleanReinvoke = true;
                }
                boolean cleanStrategySet = false;
                FuseBuilder.CleanParams lastParams = new FuseBuilder.CleanParams();
                myList paramIters = new myList(10);
                paramIters.add(lastParams);
                if (vp != null) {
                    vp.print("Process remaining options");
                }
                if (debug != null) {
                    debug.incLevel("Process options");
                }
                for (int i = 0; i < opt.length; ++i) {
                    String arg5s;
                    String co = opt[i].length > 0 ? opt[i][0] : "";
                    int ca = opt[i].length - 1;
                    String arg1s = ca >= 1 ? opt[i][1] : "";
                    String arg2s = ca >= 2 ? opt[i][2] : "";
                    String arg3s = ca >= 3 ? opt[i][3] : "";
                    String arg4s = ca >= 4 ? opt[i][4] : "";
                    String string = arg5s = ca >= 5 ? opt[i][5] : "";
                    if (this.processOption(opt[i], debug)) continue;
                    if (co.equals("S")) {
                        if (arg1s.equals("0")) {
                            cleanStrategySet = true;
                            this.setCleanStrategy(0, paramIters, debug, cleanSettings);
                        } else if (arg1s.equals("1") || arg1s.equals("fast")) {
                            this.setCleanStrategy(1, paramIters, debug, cleanSettings);
                            cleanStrategySet = true;
                        } else if (arg1s.equals("2") || arg1s.equals("nofaulty")) {
                            cleanStrategySet = true;
                            this.setCleanStrategy(2, paramIters, debug, cleanSettings);
                        } else if (arg1s.equals("3") || arg1s.equals("fine")) {
                            this.setCleanStrategy(3, paramIters, debug, cleanSettings);
                            cleanStrategySet = true;
                        } else if (arg1s.equals("5")) {
                            cleanStrategySet = true;
                            this.setCleanStrategy(5, paramIters, debug, cleanSettings);
                        } else {
                            System.err.println("Invalid clean strategy: " + arg1s);
                            System.err.println("Default strategy will be used");
                        }
                        lastParams = (FuseBuilder.CleanParams)paramIters.get(paramIters.size() - 1);
                        continue;
                    }
                    if (co.equalsIgnoreCase("nolookup")) {
                        CleanArgs.OPT_CLEAN_SKIPDBLOOKUP = true;
                        continue;
                    }
                    if (co.equalsIgnoreCase("debug") || co.equalsIgnoreCase("trace")) continue;
                    if (co.equalsIgnoreCase("skipbuild")) {
                        OPT_DEBUG_SKIPBUILD = true;
                        if (debug == null) continue;
                        debug.println("[skipbuild] Skip build steps.");
                        continue;
                    }
                    if (co.equals("CPminmet")) {
                        try {
                            double d;
                            OPT_CP_MINMET = d = Double.parseDouble(arg1s);
                            if (debug == null) continue;
                            debug.println("[CPminmet] OPT_CP_MINMET=" + OPT_CP_MINMET);
                        }
                        catch (Exception e) {
                            if (debug != null) {
                                debug.println("[CPminmet] parse error.");
                            }
                            System.err.println("Bad [CPminmet] argumantum.");
                        }
                        continue;
                    }
                    if (co.equals("CPeps")) {
                        try {
                            double d;
                            OPT_CP_EPS = d = Double.parseDouble(arg1s);
                            if (debug == null) continue;
                            debug.println("[CPeps] OPT_CP_EPS=" + OPT_CP_EPS);
                        }
                        catch (Exception e) {
                            if (debug != null) {
                                debug.println("[CPeps] parse error.");
                            }
                            System.err.println("Bad [CPeps] argumantum.");
                        }
                        continue;
                    }
                    if (co.equals("CPonet")) {
                        boolean b;
                        OPT_CP_ONETORSION = b = Boolean.valueOf(arg1s).booleanValue();
                        if (debug == null) continue;
                        debug.println("[CPonet] OPT_CP_ONETORSION=" + OPT_CP_ONETORSION);
                        continue;
                    }
                    if (co.equalsIgnoreCase("nextparamset") || co.equalsIgnoreCase("np")) {
                        lastParams = (FuseBuilder.CleanParams)lastParams.clone();
                        paramIters.add(lastParams);
                        if (debug == null) continue;
                        debug.println("[nextparamset] Parameter list new item");
                        continue;
                    }
                    if (co.equalsIgnoreCase("acceptfault")) {
                        lastParams.ACCEPT_STEREO_NOK = true;
                        if (debug == null) continue;
                        debug.println("[acceptfault] Accept any structure generated");
                        continue;
                    }
                    if (co.equals("CPfragmulti") || co.equalsIgnoreCase("fm")) {
                        if (ca >= 1) {
                            int ii;
                            lastParams.OPT_CP_FRAGMULTI_CHAIN = ii = Integer.parseInt(opt[i][1]);
                            lastParams.OPT_CP_FRAGMULTI_RING = ii;
                            lastParams.OPT_CP_FRAGMULTI_RINGBEFORECLOSE = ii;
                        }
                        if (ca >= 2) {
                            int ii;
                            lastParams.OPT_CP_FRAGMULTI_RING = ii = Integer.parseInt(opt[i][2]);
                            lastParams.OPT_CP_FRAGMULTI_RINGBEFORECLOSE = ii;
                        }
                        if (ca >= 3) {
                            int ii;
                            lastParams.OPT_CP_FRAGMULTI_RINGBEFORECLOSE = ii = Integer.parseInt(opt[i][3]);
                        }
                        lastParams.OPT_CP_FRAGMULTI_MAX = Math.max(Math.max(lastParams.OPT_CP_FRAGMULTI_CHAIN, lastParams.OPT_CP_FRAGMULTI_RING), lastParams.OPT_CP_FRAGMULTI_RINGBEFORECLOSE);
                        if (debug == null) continue;
                        debug.println("[CPfragmulti]");
                        debug.println("    OPT_CP_FRAGMULTI_CHAIN=" + lastParams.OPT_CP_FRAGMULTI_CHAIN);
                        debug.println("    OPT_CP_FRAGMULTI_RING=" + lastParams.OPT_CP_FRAGMULTI_RING);
                        debug.println("    OPT_CP_FRAGMULTI_RINGBEFORECLOSE=" + lastParams.OPT_CP_FRAGMULTI_RINGBEFORECLOSE);
                        continue;
                    }
                    System.err.println("Unknown Clean3D option: " + co);
                }
                if (debug != null) {
                    debug.decLevel();
                }
                if (!cleanStrategySet && cleanSettings.getOptionCleanerToUse() == 0) {
                    if (vp != null) {
                        vp.print("Clean strat not set, set.");
                    }
                    this.setCleanStrategy(1, paramIters, debug, cleanSettings);
                }
                InvokeCalculation cleanbuilder = null;
                InvokeCalculation optimizer = null;
                InvokeCalculation forcefield = null;
                cleanbuilder = null;
                orig_clone = null;
                addedHCount = 0;
                if (cleanSettings.isOptionPrehydrogenizeGiven()) {
                    if (vp != null) {
                        vp.print("Hydrogenize input structure");
                    }
                    orig_clone = orig.cloneMolecule();
                    addedHCount = -orig.getAtomCount();
                    Hydrogenize.addHAtoms(orig);
                    addedHCount += orig.getAtomCount();
                    if (vp != null) {
                        vp.print("Added " + addedHCount + " explicit H atoms.");
                    }
                }
                input = new CxnMoleculeInput(orig);
                boolean invokeClean = false;
                if (cleanSettings.getOptionCleanerToUse() != 2) {
                    switch (cleanSettings.getOptionCleanForce()) {
                        case 0: {
                            if (vp != null) {
                                vp.print("Clean3D will be invoked");
                            }
                            invokeClean = true;
                            break;
                        }
                        case 1: {
                            boolean bl = invokeClean = !input.isMolecule3D();
                            if (vp == null) break;
                            vp.print("Clean only non 3D structures. Clean reqquired: " + invokeClean);
                        }
                    }
                } else if (vp != null) {
                    vp.print("No clean3D will be invoked");
                }
                MultipleConformerResult res = null;
                cleanFailedOrAborted = false;
                cleanFailed = false;
                cleanAborted = false;
                if (CleanArgs.getTracer() != null) {
                    CleanArgs.getTracer().changeTaskID(2);
                    debug = CleanArgs.getDebug();
                }
                boolean licensed = LicenseHandler.getInstance().isLicensed("Conformation Plugin Group");
                if (pmon == null && !licensed && cleanSettings.getReportedConformerCount() != 1 && cleanSettings.isOptionCAGiven()) {
                    System.err.println("Error! License not set for Conformers Plugin");
                    System.err.println("Only the lowest energy found conformer will be given back.");
                    cleanSettings.setSingleReportedConformer();
                }
                try {
                    if (invokeClean) {
                        if (cleanbuilder == null) {
                            if (vp != null) {
                                vp.print("Construct builder");
                            }
                            InvokeCalculation clean = null;
                            switch (cleanSettings.getOptionCleanerToUse()) {
                                case 0: {
                                    if (vp != null) {
                                        vp.print("Construct fuse builder");
                                    }
                                    InvokeFAFBuildCalculation fc = new InvokeFAFBuildCalculation();
                                    fc.setParams(paramIters);
                                    fc.setSettings(cleanSettings);
                                    clean = fc;
                                    break;
                                }
                                case 3: {
                                    if (vp != null) {
                                        vp.print("Construct FFF builder");
                                    }
                                    InvokeFFFBuildCalculation ff = new InvokeFFFBuildCalculation();
                                    ff.setSettings(cleanSettings);
                                    clean = ff;
                                    break;
                                }
                                case 1: {
                                    if (vp != null) {
                                        vp.print("Construct Minkowski builder");
                                    }
                                    System.err.println("WARNING! Using old coordinate generator is not supported.");
                                    InvokeMinkowskiCalculation fm = new InvokeMinkowskiCalculation();
                                    fm.setSettings(cleanSettings);
                                    clean = fm;
                                    break;
                                }
                                default: {
                                    clean = new RandomCoordinatesCalculation();
                                    System.err.println("WARNING! Using random coordinate calculations");
                                }
                            }
                            if (vp != null) {
                                vp.print("Construct molecule adapter");
                            }
                            cleanbuilder = new CxnMoleculeAdapter(clean);
                        }
                        if (vp != null) {
                            vp.print("Invoke actual building process");
                        }
                        if (generalvp.isVerbosityLevelEnabled(1)) {
                            generalvp.print(1, "Start coordinate generation");
                        }
                        res = (MultipleConformerResult)cleanbuilder.invoke(input);
                        if (generalvp.isVerbosityLevelEnabled(1)) {
                            generalvp.print(1, "Coordinate generation finished");
                            if (generalvp.isVerbosityLevelEnabled(2)) {
                                generalvp.print(2, "  Generated conformer count: " + res.size());
                            }
                        }
                        if (vp != null) {
                            vp.print("Building process returned");
                        }
                    }
                    if (cleanSettings.isOptimizeResultsRequired()) {
                        if (vp != null) {
                            vp.print("Check for optimization");
                        }
                        boolean invokeOpt = false;
                        if (res == null) {
                            invokeOpt = true;
                        } else if (res.getOptLimit() < 0.0 || res.getOptLimit() > cleanSettings.getOptLimitFinaloptValue()) {
                            invokeOpt = true;
                        }
                        if (invokeOpt) {
                            if (vp != null) {
                                vp.print("Optimization required");
                            }
                            if (optimizer == null) {
                                if (vp != null) {
                                    vp.print("Construct optimizer");
                                }
                                OptimizerCalculation optc = new OptimizerCalculation(2);
                                optc.setOptLimit(cleanSettings.getOptLimitFinaloptValue());
                                optc.setCleanSettings(cleanSettings);
                                optimizer = new CxnMoleculeAdapter(optc);
                            }
                            if (res == null) {
                                if (vp != null) {
                                    vp.print("Optimize input structure");
                                }
                                res = (MultipleConformerResult)optimizer.invoke(input, false);
                            } else {
                                if (vp != null) {
                                    vp.print("Optimize (further) generated structure");
                                }
                                res = (MultipleConformerResult)optimizer.invoke(res, false);
                            }
                        }
                    }
                    if (cleanSettings.isOptionEgiven()) {
                        if (vp != null) {
                            vp.print("Check for additional energy calculation");
                        }
                        if (res == null || !res.isEnergyAvailable()) {
                            if (vp != null) {
                                vp.print("Energy calculation required");
                            }
                            if (forcefield == null) {
                                if (vp != null) {
                                    vp.print("Construct force field");
                                }
                                OptimizerCalculation ffc = new OptimizerCalculation(1);
                                ffc.setCleanSettings(cleanSettings);
                                forcefield = new CxnMoleculeAdapter(ffc);
                            }
                            if (res == null) {
                                if (vp != null) {
                                    vp.print("Invoke energy calculation on input structure");
                                }
                                input.storeEnergy(((MultipleConformerResult)forcefield.invoke(input)).getEnergy(0));
                            } else {
                                if (vp != null) {
                                    vp.print("Invoke energy calculation on generated/optimized structure");
                                }
                                input.storeEnergy(((MultipleConformerResult)forcefield.invoke(res)).getEnergy(0));
                            }
                        } else {
                            if (vp != null) {
                                vp.print("Energy already calculated");
                            }
                            input.storeEnergy(res.getEnergy(0));
                        }
                    }
                    if (res != null) {
                        if (vp != null) {
                            vp.print("Store generated 3D coordinates");
                        }
                        input.storeConformer(res, cleanSettings.isOptionCAGiven());
                    }
                }
                catch (CalculationFailedException cfe) {
                    if (vp != null) {
                        vp.print("Clean failed.");
                    }
                    if (generalvp.isVerbosityLevelEnabled(1)) {
                        generalvp.print(1, "Calculation failed.");
                    }
                    cleanFailedOrAborted = true;
                    cleanFailed = true;
                    if (CleanArgs.getTracer() != null) {
                        CleanArgs.getTracer().reportException(cfe);
                    }
                }
                catch (CalculationAbortedException cae) {
                    if (vp != null) {
                        vp.print("Clean aborted.");
                    }
                    cleanFailedOrAborted = true;
                    cleanAborted = true;
                    if (CleanArgs.getTracer() != null) {
                        CleanArgs.getTracer().reportException(cae);
                    }
                    if (generalvp.isVerbosityLevelEnabled(1)) {
                        generalvp.print(1, "Calculation aborted.");
                    }
                    System.err.println("Timelimit exceeded. Try to increase timelimit with option [timelimit]");
                }
                catch (Exception e) {
                    cleanFailedOrAborted = true;
                    cleanFailed = true;
                    if (cleanSettings.getInst() != null) {
                        cleanSettings.getInst().addFlag(new Instrumentation.ExceptionReported(e));
                    }
                    System.err.print("Exception in Clean3D. Failed structure:");
                    try {
                        System.err.println(MolExporter.exportToFormat(orig, "smiles:-H"));
                    }
                    catch (IOException ioException) {
                        System.err.println(" structure can not be exported to smiles format.");
                        ioException.printStackTrace();
                    }
                    e.printStackTrace();
                    if (CleanArgs.getTracer() == null) break block118;
                    CleanArgs.getTracer().reportException(e);
                }
            }
            if (cleanFailed) {
                if (cleanSettings.isOptionEgiven()) {
                    input.storeEnergyFailed();
                }
                System.err.println("Clean failed.");
                if ("smiles" != null) {
                    try {
                        Molecule mp = orig_clone == null ? orig : orig_clone;
                        System.err.println(MolExporter.exportToFormat(mp, "smiles"));
                    }
                    catch (Exception e) {
                        if (cleanSettings.getInst() != null) {
                            cleanSettings.getInst().addFlag(new Instrumentation.ExceptionReported(e));
                        }
                        System.err.println("Structure print failed.");
                        if (e.getMessage() == null) break block119;
                        System.err.println("Exception: " + e.getMessage());
                        e.printStackTrace();
                    }
                }
            }
        }
        if (cleanAborted && cleanSettings.isOptionEgiven()) {
            input.storeEnergyAborted();
        }
        if (cleanFailedOrAborted && addedHCount > 0) {
            for (int i = 0; i < addedHCount; ++i) {
                orig.removeAtom(orig.getAtomCount() - 1);
            }
        }
        cleanSettings.storeProperties(cleanAborted ? 3 : (cleanFailed ? 2 : 1));
        cleanSettings.closeProgress();
        noCleanReinvoke = false;
        if (CleanArgs.cltracer != null) {
            CleanArgs.cltracer.close();
        }
        return cleanFailedOrAborted ? 1 : 0;
    }

    public void setCleanStrategy(int sn, myList pi, debugPrintout debug, CleanSettings settings) {
        if (debug != null) {
            debug.println("Set clean strategy to " + sn);
        }
        FuseBuilder.CleanParams lastParam = (FuseBuilder.CleanParams)pi.get(pi.size() - 1);
        switch (sn) {
            case 0: {
                if (debug == null) break;
                debug.println("0: No strategy.");
                break;
            }
            case 1: {
                if (debug != null) {
                    debug.println("1 (fast): default strategy");
                }
                settings.setCleanerToUse(0);
                for (int i = 1; i <= 243; i *= 3) {
                    lastParam.OPT_CP_FRAGMULTI_CHAIN = i;
                    lastParam.OPT_CP_FRAGMULTI_RING = i;
                    lastParam.OPT_CP_FRAGMULTI_RINGBEFORECLOSE = i;
                    lastParam.OPT_CP_FRAGMULTI_MAX = i;
                    lastParam.ACCEPT_STEREO_NOK = false;
                    if (i == 729) continue;
                    lastParam = (FuseBuilder.CleanParams)lastParam.clone();
                    pi.add(lastParam);
                }
                lastParam.ACCEPT_STEREO_NOK = true;
                break;
            }
            case 2: {
                if (debug != null) {
                    debug.println("2 (nofaulty): default strategy with no acceptance of faulty structures");
                }
                for (int i = 3; i <= 243; i *= 3) {
                    lastParam.OPT_CP_FRAGMULTI_CHAIN = i;
                    lastParam.OPT_CP_FRAGMULTI_RING = i;
                    lastParam.OPT_CP_FRAGMULTI_RINGBEFORECLOSE = i;
                    lastParam.OPT_CP_FRAGMULTI_MAX = i;
                    lastParam.ACCEPT_STEREO_NOK = false;
                    if (i == 243) continue;
                    lastParam = (FuseBuilder.CleanParams)lastParam.clone();
                    pi.add(lastParam);
                }
                break;
            }
            case 3: {
                if (debug != null) {
                    debug.println("3 (fine): fine search: ifnd low energy conformer");
                }
                for (int i = 27; i <= 243; i *= 3) {
                    lastParam.OPT_CP_FRAGMULTI_CHAIN = i;
                    lastParam.OPT_CP_FRAGMULTI_RING = i;
                    lastParam.OPT_CP_FRAGMULTI_RINGBEFORECLOSE = i;
                    lastParam.OPT_CP_FRAGMULTI_MAX = i;
                    lastParam.ACCEPT_STEREO_NOK = false;
                    if (i == 243) continue;
                    lastParam = (FuseBuilder.CleanParams)lastParam.clone();
                    pi.add(lastParam);
                }
                break;
            }
            case 4: {
                throw new UnsupportedOperationException();
            }
            case 5: {
                if (debug != null) {
                    debug.println("5: Fast only generation with no acceptance of faulty structures");
                }
                lastParam.OPT_CP_FRAGMULTI_CHAIN = 1;
                lastParam.OPT_CP_FRAGMULTI_RING = 1;
                lastParam.OPT_CP_FRAGMULTI_RINGBEFORECLOSE = 1;
                lastParam.OPT_CP_FRAGMULTI_MAX = 1;
                lastParam.ACCEPT_STEREO_NOK = false;
            }
        }
    }

    @Override
    public String getHelpMessage() {
        return CleanArgs.getDefaultHelpMessage();
    }

    public boolean checkStructure(Molecule m) {
        return ConformersDescriptor.checkConformersDescriptor(m, false);
    }

    @Override
    public boolean checkDescriptorPresence(Molecule m) {
        return ConformersDescriptor.checkDescriptorPresence(m, false);
    }

    public Molecule[] retrieveConformers(Molecule m) {
        return ConformersDescriptor.constructConformers(m);
    }

    public void skipLicenseCheck() {
        if (!skipOneLicenseCheckRequested) {
            skipOneLicenseCheckRequested = true;
            skipOneLicenseCheck = true;
        }
    }

    @Override
    public Molecule[] calcConformers(Molecule m) {
        return ConformersDescriptor.getConformers(m, false);
    }

    public static class FragmentOptimizer
    implements Opt3D.MolCT {
        FragmentStore frags = null;
        int step = 0;
        int[] fragAtoms = null;
        int[] atomToFragAtom = null;
        int[] anum = null;
        int[] borders = null;
        int[] batom1 = null;
        int[] batom2 = null;
        int[][] ctab = null;
        int[][] blist = null;
        int[][] bolist = null;
        double[] atomCoordinateScratch = null;
        double[][] atomLocalCoordinateScratch = null;
        int[] atomNumberScratch = null;
        double[][] localDerivateScratch;
        public static final int COORD_MULTIDIM = 1;
        int coordType = -1;
        multiDim coord = null;
        boolean faProjNeed = false;
        int dim = 0;

        public void printout(debugPrintout debug) {
            int i;
            debug.println("fragmentAtoms:");
            debug.printVector(this.fragAtoms);
            debug.println("AtomTFragment proj:");
            debug.printVector(this.atomToFragAtom);
            debug.print("<CENTER><B>Atoms</B></CENTER>");
            debug.print("Atoms: " + this.fragAtoms.length + "");
            debug.print("<TABLE BORDER=1><TR><TD></TD><TD><B>No</B></TD></TR>");
            for (i = 0; i < this.fragAtoms.length; ++i) {
                debug.print("<TR><TD><B>" + i + "</B></TD><TD>" + this.anum[i] + "</TD></TR>");
            }
            debug.print("</TABLE>");
            debug.print("<CENTER><B>BONDS</B></CENTER>");
            debug.print("Bonds: " + this.batom1.length + "");
            debug.print("<TABLE BORDER=1><TR><TD></TD><TD><B>A1</B></TD><TD><B>A2</B></TD><TD><B>Len</B></TD><TD><B>Type</B></TD><TD><B>Ring info</B></TD></TR>");
            for (i = 0; i < this.batom1.length; ++i) {
                debug.print("<TR><TD><B>" + i + "</B></TD><TD>" + this.batom1[i] + "</TD><TD>" + this.batom2[i] + "</TD><TD>" + this.borders[i] + "</TD></TR>");
            }
            debug.print("</TABLE>");
            debug.print("<CENTER><B>CTAB and BLIST</B></CENTER>");
            debug.print("<TABLE BORDER=1><TR><TD><B>Atom</B></TD><TD><B>Connected atoms</B></TD><TD><B>Connected bonds</B></TD><TD><B>Connected bond orders</B></TD></TR>");
            for (i = 0; i < this.ctab.length; ++i) {
                int j;
                debug.print("<TR><TD><B>" + i + "</B></TD><TD>");
                for (j = 0; j < this.ctab[i].length; ++j) {
                    debug.print(this.ctab[i][j] + (j < this.ctab[i].length - 1 ? ", " : ""));
                }
                debug.print("</TD><TD>");
                for (j = 0; j < this.blist[i].length; ++j) {
                    debug.print(this.blist[i][j] + (j < this.blist[i].length - 1 ? ", " : ""));
                }
                debug.print("</TD><TD>");
                for (j = 0; j < this.bolist[i].length; ++j) {
                    debug.print(this.bolist[i][j] + (j < this.blist[i].length - 1 ? ", " : ""));
                }
                debug.print("</TD></TR>");
            }
            debug.print("</TABLE>");
        }

        public void setStoreMultiDim(multiDim md, boolean proj, int d) {
            this.coord = md;
            this.faProjNeed = proj;
            this.dim = d;
            this.coordType = 1;
        }

        public FragmentOptimizer(FragmentStore f, int s, int[] fa, int[] af) {
            int i;
            this.frags = f;
            this.step = s;
            this.fragAtoms = fa != null ? fa : this.frags.seq.getAtomsForCommand(s);
            this.atomToFragAtom = af != null ? af : this.frags.seq.getAtomsToFragAtomsTable(this.fragAtoms);
            myMolecule m = this.frags.seq.mol;
            this.anum = new int[this.fragAtoms.length];
            for (int i2 = 0; i2 < this.anum.length; ++i2) {
                this.anum[i2] = m.anum[this.fragAtoms[i2]];
            }
            int fb = 0;
            for (int i3 = 0; i3 < m.b; ++i3) {
                if (this.atomToFragAtom[m.bat[0][i3]] == -1 || this.atomToFragAtom[m.bat[1][i3]] == -1) continue;
                ++fb;
            }
            this.borders = new int[fb];
            this.batom1 = new int[fb];
            this.batom2 = new int[fb];
            this.ctab = new int[this.fragAtoms.length][];
            this.blist = new int[this.fragAtoms.length][];
            this.bolist = new int[this.fragAtoms.length][];
            int fbp = 0;
            for (i = 0; i < m.b; ++i) {
                if (this.atomToFragAtom[m.bat[0][i]] == -1 || this.atomToFragAtom[m.bat[1][i]] == -1) continue;
                this.borders[fbp] = m.getBondOrder(i);
                this.batom1[fbp] = this.atomToFragAtom[m.bat[0][i]];
                this.batom2[fbp] = this.atomToFragAtom[m.bat[1][i]];
                ++fbp;
            }
            for (i = 0; i < this.fragAtoms.length; ++i) {
                int j;
                int ab = 0;
                for (j = 0; j < m.ctab[this.fragAtoms[i]].length; ++j) {
                    if (this.atomToFragAtom[m.ctab[this.fragAtoms[i]][j]] == -1) continue;
                    ++ab;
                }
                this.ctab[i] = new int[ab];
                this.blist[i] = new int[ab];
                this.bolist[i] = new int[ab];
                ab = 0;
                for (j = 0; j < m.ctab[this.fragAtoms[i]].length; ++j) {
                    if (this.atomToFragAtom[m.ctab[this.fragAtoms[i]][j]] == -1) continue;
                    this.ctab[i][ab] = this.atomToFragAtom[m.ctab[this.fragAtoms[i]][j]];
                    ++ab;
                }
            }
            for (i = 0; i < fb; ++i) {
                int j = 0;
                boolean ok = false;
                while (!ok) {
                    if (this.ctab[this.batom1[i]][j] == this.batom2[i]) {
                        this.blist[this.batom1[i]][j] = i;
                        this.bolist[this.batom1[i]][j] = this.borders[i];
                        ok = true;
                        continue;
                    }
                    if (++j < this.ctab[this.batom1[i]].length) continue;
                    ok = true;
                }
                ok = false;
                j = 0;
                while (!ok) {
                    if (this.ctab[this.batom2[i]][j] == this.batom1[i]) {
                        this.blist[this.batom2[i]][j] = i;
                        this.bolist[this.batom2[i]][j] = this.borders[i];
                        ok = true;
                        continue;
                    }
                    if (++j < this.ctab[this.batom2[i]].length) continue;
                    ok = true;
                }
            }
        }

        public double[] getMetric() {
            double[] ret = new double[this.dim];
            if (this.coordType == 1) {
                for (int i = 0; i < this.dim; ++i) {
                    ret[i] = this.coord.getM(i);
                }
            }
            return ret;
        }

        public void askCoordinates(int n, double[] c) {
            if (this.coordType == 1) {
                int i;
                if (this.faProjNeed) {
                    n = this.fragAtoms[n];
                }
                for (i = 0; i < this.dim; ++i) {
                    c[i] = this.coord.getV(n, i);
                }
                for (i = this.dim; i < c.length; ++i) {
                    c[i] = 0.0;
                }
            }
        }

        @Override
        public void setCoordinates(int n) {
            if (this.coordType == 1) {
                if (this.faProjNeed) {
                    n = this.fragAtoms[n];
                }
                for (int i = 0; i < this.dim; ++i) {
                    this.coord.putV(n, i, this.atomCoordinateScratch[i]);
                }
            }
        }

        @Override
        public void askCoordinates(int i) {
            this.askCoordinates(i, this.atomCoordinateScratch);
        }

        @Override
        public void askLocalCoordinates(int n) {
            block9: {
                int i;
                block8: {
                    if (this.dim > 3) break block8;
                    for (int i2 = 0; i2 < n; ++i2) {
                        this.askCoordinates(this.atomNumberScratch[i2], this.atomLocalCoordinateScratch[i2]);
                    }
                    break block9;
                }
                for (int i3 = 0; i3 < 3; ++i3) {
                    this.atomLocalCoordinateScratch[0][i3] = 0.0;
                }
                if (n <= 1) break block9;
                if (n > 4) {
                    n = 4;
                }
                double[] m = this.getMetric();
                double[][] c = new double[n][this.dim];
                for (int i4 = 0; i4 < n; ++i4) {
                    this.askCoordinates(this.atomNumberScratch[i4], c[i4]);
                }
                double[][] b = new double[n - 1][];
                for (i = 0; i < n - 1; ++i) {
                    b[i] = V.minus(c[i + 1], c[0]);
                    for (int j = 0; j < i; ++j) {
                        V.minusWriteBackToa(b[i], V.dot(V.dotUsingMetric(b[i], b[j], m), b[j]));
                    }
                    double l = V.dotUsingMetric(b[i], m);
                    if (!(Math.abs(l) > 1.0E-4)) continue;
                    V.normalize(b[i], Math.sqrt(Math.abs(l)));
                }
                for (i = 0; i < n - 1; ++i) {
                    for (int j = 0; j < 3; ++j) {
                        this.atomLocalCoordinateScratch[i + 1][j] = V.dotUsingMetric(V.minus(c[i + 1], c[0]), b[i], m);
                    }
                }
            }
        }

        @Override
        public void derivateUpdatedNotification() {
        }

        @Override
        public double[] getAtomCoordinateScratch() {
            if (this.atomCoordinateScratch == null) {
                this.atomCoordinateScratch = new double[this.dim];
            }
            return this.atomCoordinateScratch;
        }

        @Override
        public double[][] getAtomLocalCoordinateScratch() {
            if (this.atomLocalCoordinateScratch == null) {
                this.atomLocalCoordinateScratch = new double[4][3];
            }
            return this.atomLocalCoordinateScratch;
        }

        @Override
        public int[] getAtomNumberScratch() {
            if (this.atomNumberScratch == null) {
                this.atomNumberScratch = new int[4];
            }
            return this.atomNumberScratch;
        }

        @Override
        public int[] getAtomNumbers() {
            return this.anum;
        }

        @Override
        public int[] getBAtom1() {
            return this.batom1;
        }

        @Override
        public int[] getBAtom2() {
            return this.batom2;
        }

        @Override
        public int[][] getBOlist() {
            return this.bolist;
        }

        @Override
        public int getBond(int a1, int a2) {
            int ret = -1;
            for (int i = 0; i < this.ctab[a1].length && ret == -1; ++i) {
                if (this.ctab[a1][i] != a2) continue;
                ret = this.blist[a1][i];
            }
            return ret;
        }

        @Override
        public int[] getBondOrders() {
            return this.borders;
        }

        @Override
        public int[][] getCtab() {
            return this.ctab;
        }

        @Override
        public double[][] getLocalDerivateScratch() {
            if (this.localDerivateScratch == null) {
                this.localDerivateScratch = new double[4][3];
            }
            return this.localDerivateScratch;
        }

        @Override
        public int[][] getBList() {
            return this.blist;
        }
    }
}

