/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.calculations.hydrogenize;

import chemaxon.calculations.clean.Cleaner;
import chemaxon.core.calculations.AtomBranchCoords;
import chemaxon.core.calculations.LonePairCounter;
import chemaxon.struc.DPoint3;
import chemaxon.struc.MPropertyContainer;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import chemaxon.struc.MoleculeGraph;
import chemaxon.struc.RgMolecule;
import chemaxon.struc.RxnMolecule;
import chemaxon.struc.SelectionMolecule;
import chemaxon.struc.Sgroup;
import chemaxon.struc.StereoConstants;
import chemaxon.struc.prop.MHCoords3DProp;
import chemaxon.struc.sgroup.MultipleSgroup;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class Hydrogenize
implements StereoConstants {
    private static boolean saveStateAndExpand(MoleculeGraph m) {
        Molecule molc = Hydrogenize.getMolecule(m);
        boolean oldState = false;
        if (molc != null) {
            oldState = molc.isGUIContracted();
            molc.setGUIContracted(false);
        }
        return oldState;
    }

    private static void recoverState(MoleculeGraph m, boolean oldState) {
        Molecule molc = Hydrogenize.getMolecule(m);
        if (molc != null) {
            molc.setGUIContracted(oldState);
        }
    }

    public static boolean addHAtoms(MoleculeGraph m, MolAtom[] atoms) {
        return Hydrogenize.addHAtoms(m, atoms, 33);
    }

    public static boolean addHAtoms(MoleculeGraph m) {
        return Hydrogenize.addHAtoms(m, null, 33);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean addHAtoms(MoleculeGraph m, MolAtom[] atoms, int flags) {
        if (atoms != null && atoms.length == 0) {
            return false;
        }
        boolean oldState = Hydrogenize.saveStateAndExpand(m);
        try {
            boolean partialCleanNeed = true;
            if (m.getDim() == 2 && !Hydrogenize.updateDimension(m)) {
                if (flags == 1) {
                    partialCleanNeed = false;
                }
                boolean bl = Hydrogenize.addHTo(m, atoms, partialCleanNeed);
                return bl;
            }
            Hydrogenize.addTo(m, atoms, 1);
            boolean bl = true;
            return bl;
        }
        finally {
            Hydrogenize.recoverState(m, oldState);
        }
    }

    public static boolean removeHAtoms(MoleculeGraph m, int flags) {
        return Hydrogenize.removeHAtoms(m, null, flags, true);
    }

    public static boolean removeHAtoms(MoleculeGraph m) {
        return Hydrogenize.removeHAtoms(m, null, 33, true);
    }

    public static boolean removeHAtoms(MoleculeGraph m, MolAtom[] atoms, int flags) {
        return Hydrogenize.removeHAtoms(m, atoms, flags, true);
    }

    public static boolean removeHAtoms(MoleculeGraph m, MolAtom[] atoms, int flags, boolean check) {
        if (m instanceof RxnMolecule) {
            return Hydrogenize.removeHAtomsInRxnMolecule((RxnMolecule)m, atoms, flags, check);
        }
        if (m instanceof RgMolecule) {
            return Hydrogenize.removeHAtomsInRgMolecule((RgMolecule)m, atoms, flags, check);
        }
        if (m instanceof Molecule) {
            return Hydrogenize.removeHAtomsInMolecule((Molecule)m, atoms, flags, check);
        }
        return Hydrogenize.removeHAtomsInMoleculeGraph(m, atoms, flags, check);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean removeHAtomsInMoleculeGraph(MoleculeGraph m, MolAtom[] atoms, int flags, boolean check) {
        if (atoms != null && atoms.length == 0) {
            return false;
        }
        boolean oldState = Hydrogenize.saveStateAndExpand(m);
        try {
            boolean bl = Hydrogenize.implicitizeHydrogens(m, atoms, flags, check);
            return bl;
        }
        finally {
            Hydrogenize.recoverState(m, oldState);
        }
    }

    private static boolean removeHAtomsInMolecule(Molecule m, MolAtom[] atoms, int flags, boolean check) {
        LinkedList<MolAtom> changed = new LinkedList<MolAtom>();
        if ((flags & 0x100) == 0) {
            changed.addAll(Hydrogenize.convertPolymerEndHtoPseudo(m));
        }
        if ((flags & 0x200) == 0) {
            changed.addAll(Hydrogenize.convertAbrevHToPseudo(m));
        }
        changed.addAll(Hydrogenize.convertSgroupHToPseudo(m));
        boolean success = Hydrogenize.removeHAtomsInMoleculeGraph(m, atoms, flags, check);
        for (MolAtom ma : changed) {
            ma.setAtno(1);
        }
        return success;
    }

    private static boolean removeHAtomsInRxnMolecule(RxnMolecule m, MolAtom[] atoms, int flags, boolean check) {
        int i;
        boolean toReturn = true;
        for (i = 0; i < m.getReactantCount(); ++i) {
            toReturn = toReturn && Hydrogenize.removeHAtoms(m.getReactant(i), atoms, flags, check);
        }
        for (i = 0; i < m.getProductCount(); ++i) {
            toReturn = toReturn && Hydrogenize.removeHAtoms(m.getProduct(i), atoms, flags, check);
        }
        for (i = 0; i < m.getAgentCount(); ++i) {
            toReturn = toReturn && Hydrogenize.removeHAtoms(m.getAgent(i), atoms, flags, check);
        }
        return toReturn;
    }

    private static boolean removeHAtomsInRgMolecule(RgMolecule m, MolAtom[] atoms, int flags, boolean check) {
        boolean toReturn = true;
        if (atoms != null) {
            for (int i = 0; i < atoms.length; ++i) {
                if (m.indexOf(atoms[i]) != -1) continue;
                throw new RuntimeException("Atom " + i + " does not belong to molecule.");
            }
        }
        Hydrogenize.removeHAtoms(m.getRoot(), atoms, flags, false);
        int n = m.getRgroupCount();
        for (int i = 0; i < n; ++i) {
            int memberCount = m.getRgroupMemberCount(i);
            for (int j = 0; j < memberCount; ++j) {
                Hydrogenize.removeHAtoms(m.getRgroupMember(i, j), atoms, flags, false);
            }
        }
        return toReturn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean addLonePairs(MoleculeGraph m, MolAtom[] atoms) {
        if (atoms != null && atoms.length == 0) {
            return false;
        }
        boolean oldState = Hydrogenize.saveStateAndExpand(m);
        try {
            Hydrogenize.addTo(m, atoms, 130);
            boolean bl = true;
            return bl;
        }
        finally {
            Hydrogenize.recoverState(m, oldState);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean removeLonePairs(MoleculeGraph m) {
        boolean oldState = Hydrogenize.saveStateAndExpand(m);
        try {
            Hydrogenize.removeFrom(m, 130);
            boolean bl = true;
            return bl;
        }
        finally {
            Hydrogenize.recoverState(m, oldState);
        }
    }

    private static boolean updateDimension(MoleculeGraph molecule) {
        for (MolAtom atom : molecule.getAtomArray()) {
            if (atom.getLocation().z == 0.0) continue;
            molecule.setDim(3);
            return true;
        }
        return false;
    }

    private static int[] createAtomIndices(MoleculeGraph molg, MolAtom[] atoms) {
        if (atoms != null) {
            int[] indices = new int[atoms.length];
            MoleculeGraph umol = molg.getGraphUnion();
            for (int i = 0; i < atoms.length; ++i) {
                indices[i] = umol.indexOf(atoms[i]);
            }
            return indices;
        }
        return null;
    }

    private static boolean addHTo(MoleculeGraph mol, MolAtom[] atoms, boolean partialCleanNeed) {
        MoleculeGraph umol = mol.getGraphUnion();
        if (atoms == null) {
            atoms = umol.getAtomArray();
        }
        int umolAtomCount = umol.getAtomCount();
        int[] fixed = new int[umolAtomCount];
        int[] p = new int[umolAtomCount];
        for (int j = 0; j < umolAtomCount; ++j) {
            fixed[j] = j;
            p[j] = umol.getLocalParity(j);
        }
        ArrayList<MolAtom> hydrogens = Hydrogenize.addTo(umol, atoms, 1);
        int[] parities = new int[umol.getAtomCount()];
        System.arraycopy(p, 0, parities, 0, p.length);
        if (partialCleanNeed) {
            Cleaner.partialClean(umol, 2, fixed, "pf");
        }
        if (umol.getDim() < 3) {
            boolean success = true;
            success = mol.isOnlyFirstAtomInStereoCalculation() ? umol.setLocalParity(parities, true) : umol.setParity(parities, true);
            if (!success && umolAtomCount + hydrogens.size() == umol.getAtomCount()) {
                Molecule pmol = Hydrogenize.getMolecule(mol);
                for (int j = hydrogens.size() - 1; j >= 0; --j) {
                    MolAtom atom = hydrogens.get(j);
                    if (mol == null) continue;
                    Sgroup sg = pmol.findSmallestSgroupContaining(atom);
                    if (sg != null) {
                        if (sg.getType() == 1) {
                            ((MultipleSgroup)sg).removeRepeatingUnitAtom(atom);
                        }
                        for (Sgroup ps = sg; ps != null; ps = ps.getParentSgroup()) {
                            pmol.setSgroupParent(atom, ps, false);
                        }
                    }
                    umol.removeAtom(atom, 3);
                }
                return false;
            }
        }
        return true;
    }

    private static ArrayList<MolAtom> addTo(MoleculeGraph mol, MolAtom[] atoms, int hatno) {
        int[] atomIndices;
        MoleculeGraph umol = mol.getGraphUnion();
        ArrayList<MolAtom> list = new ArrayList<MolAtom>();
        if (atoms != null) {
            atomIndices = Hydrogenize.createAtomIndices(umol, atoms);
        } else {
            atoms = umol.getAtomArray();
            int n = umol.getAtomCount();
            atomIndices = new int[n];
            for (int i = 0; i < n; ++i) {
                atomIndices[i] = i;
            }
        }
        int[][] ctab = umol.getCtab();
        int dim = umol.getDim();
        int[] hcounts = new int[atoms.length];
        MHCoords3DProp h3coords = null;
        if (hatno == 1) {
            MPropertyContainer props;
            for (int i = 0; i < hcounts.length; ++i) {
                hcounts[i] = atoms[i].getImplicitHcount();
                if (hcounts[i] != 0) continue;
                hcounts[i] = atoms[i].getValenceProp() - atoms[i].twicesumbonds(true, false) / 2;
            }
            if (dim == 3 && (h3coords = (MHCoords3DProp)(props = mol.properties()).get("mrv_H_3d_coordinates")) != null && !props.isValid(h3coords)) {
                h3coords = null;
            }
        } else {
            hcounts = Hydrogenize.callLonePairCounter(umol);
        }
        Map<MolAtom, DPoint3[]> h3coordmap = h3coords != null ? h3coords.getMap(umol) : null;
        for (int i = 0; i < atoms.length; ++i) {
            MolAtom a = atoms[i];
            if (!Hydrogenize.isHAdditionPossible(a)) continue;
            int k = umol.indexOf(a);
            int atno = a.getAtno();
            if (atno == hatno) continue;
            list.addAll(Hydrogenize.addHToAtom(umol, ctab, k, hatno, hcounts[i], h3coordmap, dim));
        }
        return list;
    }

    private static ArrayList<MolAtom> addHToAtom(MoleculeGraph umol, int[][] ctab, int k, int hatno, int count, Map<MolAtom, DPoint3[]> h3coordmap, int dim) {
        ArrayList<MolAtom> list;
        block3: {
            MolAtom a;
            block6: {
                block4: {
                    DPoint3[] p;
                    double hblen;
                    block5: {
                        list = new ArrayList<MolAtom>();
                        a = umol.getAtom(k);
                        boolean two_or_three_dim = dim == 2 || dim == 3;
                        a.valenceCheck();
                        if ((hatno != 1 || count <= 0) && hatno != 130) break block3;
                        if (!two_or_three_dim) break block4;
                        hblen = umol.getDesiredLength(a.getAtno(), 1, 1);
                        if (dim != 2) break block5;
                        list.addAll(Hydrogenize.hydr2d(hatno, umol, a, count, hblen, ctab[k]));
                        break block6;
                    }
                    boolean restored = false;
                    if (h3coordmap != null && (p = h3coordmap.get(a)) != null && count <= p.length) {
                        list.addAll(Hydrogenize.hydr3d(umol, a, p, count));
                        restored = true;
                    }
                    if (restored) break block6;
                    list.addAll(Hydrogenize.hydr3d(hatno, umol, a, count, hblen));
                    break block6;
                }
                for (int j = 0; j < count; ++j) {
                    MolAtom H = new MolAtom(hatno);
                    Hydrogenize.addH(a, H, umol);
                    list.add(H);
                }
            }
            if (hatno == 1) {
                a.setImplicitHcount(0);
            }
            a.valenceCheck();
        }
        return list;
    }

    private static int[] callLonePairCounter(MoleculeGraph mol) {
        LonePairCounter mod = new LonePairCounter();
        int[] counts = mod.getLonePairCount(mol);
        return counts;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void addH(MolAtom a, MolAtom H, MoleculeGraph molg) {
        MoleculeGraph pmol;
        Sgroup sg;
        MoleculeGraph pmol2;
        Molecule mol = Hydrogenize.getMolecule(molg, a);
        if (!Hydrogenize.isHAdditionPossible(a)) {
            return;
        }
        molg.add(H);
        if (molg instanceof SelectionMolecule && (pmol2 = a.getParent()) != molg) {
            pmol2.add(H);
        }
        if (mol != null && (sg = mol.findSmallestSgroupContaining(a)) != null) {
            if (sg.getType() == 1) {
                MultipleSgroup msg = (MultipleSgroup)sg;
                if (!msg.isRepeatingUnitAtom(a)) return;
                for (Sgroup ps = msg.getParentSgroup(); ps != null; ps = ps.getParentSgroup()) {
                    mol.setSgroupParent(H, ps, true);
                }
                msg.addRepeatingUnitAtom(H);
            } else {
                for (Sgroup ps = sg; ps != null; ps = ps.getParentSgroup()) {
                    mol.setSgroupParent(H, ps, true);
                }
            }
        }
        MolBond b = new MolBond(a, H);
        if (molg instanceof SelectionMolecule && (pmol = a.getParent()) != molg) {
            pmol.add(b);
        }
        molg.add(b);
    }

    private static boolean isHAdditionPossible(MolAtom a) {
        Sgroup sg;
        Molecule mol = null;
        if (a.getParent() == null || !a.getParent().isMolecule()) {
            return false;
        }
        mol = (Molecule)a.getParent();
        MultipleSgroup msg = null;
        return mol == null || (sg = mol.findSmallestSgroupContaining(a)) == null || sg.getType() != 1 || (msg = (MultipleSgroup)sg).isRepeatingUnitAtom(a);
    }

    private static Molecule getMolecule(MoleculeGraph m) {
        if (m instanceof Molecule) {
            return (Molecule)m;
        }
        for (int i = 0; i < m.getAtomCount(); ++i) {
            MolAtom a = m.getAtom(i);
            if (!(a.getParent() instanceof Molecule)) continue;
            return (Molecule)a.getParent();
        }
        return null;
    }

    private static Molecule getMolecule(MoleculeGraph m, MolAtom a) {
        if (m instanceof Molecule) {
            return (Molecule)m;
        }
        if (a.getParent() instanceof Molecule) {
            return (Molecule)a.getParent();
        }
        return null;
    }

    private static boolean implicitizeHydrogens(MoleculeGraph mol, MolAtom[] atoms, int f, boolean check) {
        ArrayList<MolAtom> hcoords;
        MoleculeGraph umol = mol.getGraphUnion();
        MolAtom[] allatoms = umol.getAtomArray();
        MPropertyContainer molprops = mol.properties();
        Map<MolAtom, DPoint3[]> hcoord3dMap = null;
        MHCoords3DProp oldhcoord3dprop = (MHCoords3DProp)molprops.get("mrv_H_3d_coordinates");
        if (oldhcoord3dprop != null && molprops.isValid(oldhcoord3dprop)) {
            hcoord3dMap = oldhcoord3dprop.getMap(umol);
        }
        int[] parities = new int[allatoms.length];
        MolBond[] removedWedge = new MolBond[allatoms.length];
        MolAtom[] removedNode = new MolAtom[allatoms.length];
        for (int i = 0; i < allatoms.length; ++i) {
            parities[i] = umol.getLocalParity(i);
        }
        int removeFlags = -35;
        int removed = 0;
        int dim = mol.getDim();
        int[][] ctab = dim == 2 ? umol.getCtab() : (int[][])null;
        ArrayList<MolAtom> arrayList = hcoords = dim == 3 ? new ArrayList<MolAtom>() : null;
        if (atoms == null) {
            atoms = allatoms;
        }
        int[] atomIndices = Hydrogenize.createAtomIndices(umol, atoms);
        boolean[] isImplicitizableH = new boolean[atoms.length];
        for (int j = atoms.length - 1; j >= 0; --j) {
            isImplicitizableH[j] = atoms[j].isImplicitizableH(f);
        }
        BitSet removedHFrom_2D_TH = new BitSet(umol.getAtomCount());
        for (int j = atoms.length - 1; j >= 0; --j) {
            if (atomIndices[j] == -1) {
                if (!check) continue;
                throw new RuntimeException("Atom " + j + " in atom array " + "does not belong to molecule.");
            }
            MolAtom h = atoms[j];
            if (!isImplicitizableH[j]) continue;
            int i = atoms == allatoms ? j : umol.indexOf(h);
            removedNode[atomIndices[j]] = h;
            if (h.getBondCount() == 0) {
                Hydrogenize.removeAtom(umol, i, removeFlags);
            } else {
                MolBond b;
                int k;
                MolBond bond;
                MolAtom a2 = h.getLigand(0);
                if (dim == 2) {
                    if (Hydrogenize.isAllenicEndpoint(a2)) {
                        MolBond otherSingleBond;
                        MolBond hbond = h.getBond(0);
                        int bondFlag = hbond.getFlags();
                        if ((bondFlag & 0x30) != 0 && (otherSingleBond = Hydrogenize.getOtherSingleAllenicBond(a2, hbond)) != null && (otherSingleBond.getFlags() & 0x30) == 0) {
                            int flag = otherSingleBond.getFlags();
                            if ((bondFlag & 0x30) == 16) {
                                flag &= 0xFFFFFFCF;
                                flag |= 0x20;
                            } else if ((bondFlag & 0x30) == 32) {
                                flag &= 0xFFFFFFCF;
                                flag |= 0x10;
                            } else if ((bondFlag & 0x30) == 32) {
                                flag |= 0x30;
                            }
                            otherSingleBond.setFlags(flag);
                        }
                    } else {
                        removedHFrom_2D_TH.set(ctab[j][0]);
                    }
                }
                int valence = a2.getValence();
                removedWedge[i] = bond = h.getBond(0);
                MolAtom a1 = null;
                MolAtom a4 = null;
                MolBond otherBond = null;
                MolBond cisTransBond = null;
                int stereo2 = 0;
                if (dim == 0 && a2.getBondCount() == 3) {
                    for (k = 0; k < a2.getBondCount() && otherBond == null; ++k) {
                        b = a2.getBond(k);
                        if (b == bond) continue;
                        stereo2 = b.getFlags() & 0x1C0;
                        int x = stereo2 & 0xC0;
                        MolAtom a3 = b.getOtherAtom(a2);
                        if (x == 0 || a3.getBondCount() < 2) continue;
                        otherBond = b;
                        a1 = b.getCTAtom1();
                        a4 = b.getCTAtom4();
                        if (a1 != h && a4 != h) continue;
                        stereo2 ^= 0xC0;
                        cisTransBond = otherBond;
                    }
                }
                if ((bond.getFlags() & 0x30) == 48 && a2.getBondCount() == 3) {
                    for (k = 0; k < a2.getBondCount(); ++k) {
                        b = a2.getBond(k);
                        if (b == bond || b.getType() != 2) continue;
                        stereo2 = 192;
                        cisTransBond = b;
                        break;
                    }
                }
                if (hcoords != null) {
                    hcoords.add(a2);
                    hcoords.add(h);
                }
                int oldh = a2.getImplicitHcount();
                boolean oldvalerr = a2.hasValenceError();
                Hydrogenize.removeAtom(umol, i, removeFlags);
                a2.setImplicitHcount(oldh + 1);
                a2.setValenceError(oldvalerr);
                if (cisTransBond != null) {
                    cisTransBond.setStereo2Flags(cisTransBond.getCTAtom1(), cisTransBond.getCTAtom4(), stereo2);
                }
                if (!oldvalerr) {
                    a2.valenceCheck();
                    if (a2.getValence() != valence) {
                        a2.setValenceProp(valence);
                    }
                }
            }
            ++removed;
        }
        boolean ret = true;
        if (dim < 3) {
            boolean success = true;
            if (umol.isOnlyFirstAtomInStereoCalculation()) {
                int count = removedHFrom_2D_TH.cardinality();
                int[] p = new int[count];
                int[] idxes = new int[count];
                int n = 0;
                int c = 0;
                for (int i = 0; i < allatoms.length; ++i) {
                    if (removedNode[i] != null) continue;
                    if (removedHFrom_2D_TH.get(i)) {
                        MolAtom a;
                        idxes[n] = c;
                        if ((f & 2) != 0 && (a = umol.getAtom(c)).getBondCount() < 3) {
                            parities[i] = 0;
                        }
                        p[n] = parities[i];
                        ++n;
                    }
                    ++c;
                }
                success = umol.setLocalParity(idxes, p, true);
            } else {
                int i;
                int[] p = new int[allatoms.length - removed];
                int n = 0;
                for (i = 0; i < allatoms.length; ++i) {
                    if (removedNode[i] != null) continue;
                    p[n++] = parities[i];
                }
                if ((f & 2) != 0) {
                    for (i = umol.getAtomCount() - 1; i >= 0; --i) {
                        MolAtom a = umol.getAtom(i);
                        if (a.getBondCount() >= 3) continue;
                        p[i] = 0;
                    }
                }
                success = umol.setParity(p, true);
            }
            if (!success) {
                for (int i = 0; i < allatoms.length; ++i) {
                    MolBond b;
                    MolAtom a = removedNode[i];
                    if (a != null) {
                        umol.add(removedNode[i]);
                    }
                    if ((b = removedWedge[i]) == null) continue;
                    umol.add(b);
                }
                ret = false;
            }
        }
        if (hcoords != null && hcoords.size() != 0) {
            if (hcoord3dMap == null) {
                hcoord3dMap = new HashMap<MolAtom, DPoint3[]>();
            }
            for (int i = 0; i < hcoords.size(); i += 2) {
                DPoint3[] harr;
                MolAtom a = (MolAtom)hcoords.get(i);
                MolAtom h = (MolAtom)hcoords.get(i + 1);
                DPoint3[] o = hcoord3dMap.get(a);
                if (o == null) {
                    harr = new DPoint3[]{h.getLocation()};
                } else {
                    DPoint3[] harr0 = o;
                    harr = new DPoint3[harr0.length + 1];
                    System.arraycopy(harr0, 0, harr, 0, harr0.length);
                    harr[harr0.length] = h.getLocation();
                }
                hcoord3dMap.put(a, harr);
            }
            MHCoords3DProp hcoordsprop = new MHCoords3DProp(hcoord3dMap, umol);
            molprops.set("mrv_H_3d_coordinates", hcoordsprop);
        }
        return ret;
    }

    private static MolBond getOtherSingleAllenicBond(MolAtom a, MolBond bond) {
        MolBond otherBond = null;
        int doubleBondCount = 0;
        int singleBondCount = 0;
        int bondCount = a.getBondCount();
        for (int i = 0; i < bondCount; ++i) {
            MolBond b = a.getBond(i);
            int bondType = b.getType();
            if (bondType == 2) {
                ++doubleBondCount;
                continue;
            }
            if (bondType != 1) continue;
            ++singleBondCount;
            if (b == bond) continue;
            otherBond = b;
        }
        if (bondCount < 4 && doubleBondCount == 1 && (singleBondCount == 1 || singleBondCount == 2)) {
            return otherBond;
        }
        return null;
    }

    private static boolean isAllenicEndpoint(MolAtom a) {
        int doubleBondCount = 0;
        int singleBondCount = 0;
        int bondCount = a.getBondCount();
        for (int i = 0; i < bondCount; ++i) {
            MolBond b = a.getBond(i);
            int bondType = b.getType();
            if (bondType == 2) {
                ++doubleBondCount;
                continue;
            }
            if (bondType != 1) continue;
            ++singleBondCount;
        }
        return bondCount < 4 && doubleBondCount == 1 && (singleBondCount == 1 || singleBondCount == 2);
    }

    private static void removeAtom(MoleculeGraph mol, int i, int rmflags) {
        if (mol instanceof SelectionMolecule) {
            MolAtom a = mol.getAtom(i);
            MoleculeGraph pmol = a.getParent();
            for (int j = a.getBondCount() - 1; j >= 0; --j) {
                mol.removeBond(a.getBond(j));
            }
            pmol.removeAtom(a, rmflags);
        }
        mol.removeAtom(i, rmflags);
    }

    private static void removeFrom(MoleculeGraph mol, int hatno) {
        int i;
        MoleculeGraph umol = mol.getGraphUnion();
        MolAtom[] atoms = umol.getAtomArray();
        int[] parities = new int[atoms.length];
        MolBond[] removedWedge = new MolBond[atoms.length];
        MolAtom[] removedNode = new MolAtom[atoms.length];
        for (int i2 = 0; i2 < atoms.length; ++i2) {
            parities[i2] = umol.getParity(i2);
        }
        int removed = 0;
        Vector<MolAtom> tocheck = null;
        for (int i3 = atoms.length - 1; i3 >= 0; --i3) {
            MolAtom h = atoms[i3];
            if (h.getAtno() != hatno) continue;
            for (int j = 0; j < h.getBondCount(); ++j) {
                MolAtom a = h.getLigand(j);
                if (a.getAtno() == hatno) continue;
                if (tocheck == null) {
                    tocheck = new Vector<MolAtom>(h.getBondCount());
                }
                tocheck.add(a);
            }
            removedNode[i3] = h;
            if (h.getBondCount() > 0) {
                MolAtom a = h.getLigand(0);
                int oldh = a.getImplicitHcount();
                Hydrogenize.removeH(h, mol);
                if (hatno == 1) {
                    a.setImplicitHcount(oldh + 1);
                }
            } else {
                Hydrogenize.removeH(h, mol);
            }
            ++removed;
        }
        if (tocheck != null) {
            for (MolAtom a : tocheck) {
                a.valenceCheck();
            }
        }
        int[] p = new int[atoms.length - removed];
        int n = 0;
        for (i = 0; i < atoms.length; ++i) {
            if (removedNode[i] != null) continue;
            p[n++] = parities[i];
        }
        if (umol.getDim() < 3 && !umol.setParity(p)) {
            for (i = 0; i < atoms.length; ++i) {
                MolBond b;
                MolAtom a = removedNode[i];
                if (a != null) {
                    umol.add(removedNode[i]);
                }
                if ((b = removedWedge[i]) == null) continue;
                umol.add(b);
            }
        }
    }

    private static void removeH(MolAtom h, MoleculeGraph mol) {
        if (mol instanceof SelectionMolecule) {
            MoleculeGraph pmol = h.getParent();
            pmol.removeAtom(h);
        }
        mol.removeAtom(h);
    }

    private static ArrayList<MolAtom> hydr2d(int hatno, MoleculeGraph mol, MolAtom a, int hcount, double hblen, int[] ligands) {
        ArrayList<MolAtom> list = new ArrayList<MolAtom>();
        double[] angles = AtomBranchCoords.branchAngles2d(a, hcount);
        double phi0 = angles[0];
        double dphi = angles[1];
        MolBond b = null;
        MolBond hb = null;
        int s = 0;
        for (int k = 1; k <= hcount; ++k) {
            double phi = phi0 + (double)k * dphi;
            double x = a.getX() + hblen * Math.cos(phi);
            double y = a.getY() + hblen * Math.sin(phi);
            double z = a.getZ();
            if (k == 1 && (b = Hydrogenize.getDoubleBondTo(a)) != null && mol.indexOf(b) >= 0) {
                s = mol.getStereo2(b, b.getCTAtom1(), b.getCTAtom4());
            }
            MolAtom H = new MolAtom(hatno, x, y, z);
            Hydrogenize.addH(a, H, mol);
            list.add(H);
            if (k != 1) continue;
            hb = H.getBond(0);
        }
        if (b != null && s == 0 && mol.indexOf(b) >= 0 && mol.canBeCT(mol.indexOf(b.getAtom1()), mol.indexOf(b.getAtom2()))) {
            hb.setFlags(48, 48);
        }
        return list;
    }

    static ArrayList<MolAtom> hydr3d(int hatno, MoleculeGraph mol, MolAtom a, int hcount, double hblen) {
        ArrayList<MolAtom> list = new ArrayList<MolAtom>();
        int nb = a.getBondCount();
        if (nb + hcount > 4) {
            hcount = 4 - nb;
        }
        if (hcount < 1) {
            return list;
        }
        DPoint3[] X = AtomBranchCoords.branchCoords3d(a, nb == 1 && hcount == 1 ? 3 : hcount, hblen);
        for (int i = 0; i < hcount; ++i) {
            MolAtom H = new MolAtom(hatno, X[i].x, X[i].y, X[i].z);
            Hydrogenize.addH(a, H, mol);
            list.add(H);
        }
        return list;
    }

    private static ArrayList<MolAtom> hydr3d(MoleculeGraph mol, MolAtom a, DPoint3[] points, int hcount) {
        ArrayList<MolAtom> list = new ArrayList<MolAtom>();
        for (int i = 0; i < hcount; ++i) {
            DPoint3 p = points[i];
            MolAtom H = new MolAtom(1, p.x, p.y, p.z);
            Hydrogenize.addH(a, H, mol);
            list.add(H);
        }
        return list;
    }

    static MolBond getDoubleBondTo(MolAtom a) {
        int l = a.getBondCount();
        for (int i = 0; i < l; ++i) {
            MolBond b = a.getBond(i);
            if (b.getType() != 2) continue;
            return b;
        }
        return null;
    }

    private static List<MolAtom> convertAbrevHToPseudo(Molecule m) {
        LinkedList<MolAtom> changed = new LinkedList<MolAtom>();
        int sgroupCount = m.getSgroupCount();
        for (int i = 0; i < sgroupCount; ++i) {
            MolBond[] crossingBonds;
            Sgroup sg = m.getSgroup(i);
            if (sg.getType() != 0) continue;
            for (MolBond mb : crossingBonds = sg.findCrossingBonds()) {
                if (mb.getAtom1().getAtno() == 1) {
                    changed.add(mb.getAtom1());
                    mb.getAtom1().setAtno(136);
                    continue;
                }
                if (mb.getAtom2().getAtno() != 1) continue;
                changed.add(mb.getAtom2());
                mb.getAtom2().setAtno(136);
            }
        }
        return changed;
    }

    private static List<MolAtom> convertSgroupHToPseudo(Molecule m) {
        LinkedList<MolAtom> changed = new LinkedList<MolAtom>();
        int sgroupCount = m.getSgroupCount();
        for (int i = 0; i < sgroupCount; ++i) {
            MolAtom ma;
            Sgroup sg = m.getSgroup(i);
            if (sg.getAtomCount() != 1 || (ma = sg.getAtom(0)).getAtno() != 1) continue;
            ma.setAtno(136);
            changed.add(ma);
        }
        return changed;
    }

    private static List<MolAtom> convertPolymerEndHtoPseudo(Molecule m) {
        LinkedList<MolAtom> changed = new LinkedList<MolAtom>();
        int l = m.getSgroupCount();
        for (int i = 0; i < l; ++i) {
            Sgroup sg = m.getSgroup(i);
            if (sg.getType() == 0 || sg.getType() == 10) continue;
            for (int j = sg.getAtomCount() - 1; j >= 0; --j) {
                MolAtom a = sg.getAtom(j);
                for (int k = a.getBondCount() - 1; k >= 0; --k) {
                    MolAtom ligand = a.getLigand(k);
                    if (ligand.getAtno() != 1 || sg.indexOf(ligand) >= 0) continue;
                    ligand.setAtno(136);
                    changed.add(ligand);
                }
            }
        }
        return changed;
    }
}

