/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.calculations.nmr;

import chemaxon.calculations.nmr.NMRSpectrum;
import chemaxon.calculations.nmr.Shift;

public class MeasuredNMRSpectrum {
    private double frequency;
    private NMRSpectrum.Nucleus nucleus;
    private String title = "";
    private String owner = "";
    private NMRSpectrum.Unit unit;
    private double domainMin;
    private double domainMax;
    private double[] xValues = new double[0];
    private double[] yValues = new double[0];
    private int numberOfPoints = 0;
    private double[] localMaximumPlaces = new double[0];
    private double[] localMaximumValues = new double[0];
    private Shift[] shifts = new Shift[0];
    private String xLabel = "";
    private String yLabel = "";
    private double rangeMin;
    private double rangeMax;

    public MeasuredNMRSpectrum() {
        this.unit = NMRSpectrum.Unit.ppm;
    }

    public double[] getLocalMaximumPlaces() {
        return this.localMaximumPlaces;
    }

    public void setLocalMaximumPlaces(double[] localMaximumPlaces) {
        this.localMaximumPlaces = localMaximumPlaces;
    }

    public double[] getLocalMaximumValues() {
        return this.localMaximumValues;
    }

    public void setLocalMaximumValues(double[] localMaximumValues) {
        this.localMaximumValues = localMaximumValues;
    }

    public double getDomainMin() {
        return this.domainMin;
    }

    public void setDomainMin(double domainMin) {
        this.domainMin = domainMin;
    }

    public double getDomainMax() {
        return this.domainMax;
    }

    public void setDomainMax(double domainMax) {
        this.domainMax = domainMax;
    }

    public double getFrequency() {
        return this.frequency;
    }

    public void setFrequency(double frequency) {
        this.frequency = frequency;
    }

    public NMRSpectrum.Nucleus getNucleus() {
        return this.nucleus;
    }

    public void setNucleus(NMRSpectrum.Nucleus nucleus) {
        this.nucleus = nucleus;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public double[] getXValues() {
        return this.xValues;
    }

    public void setXValues(double[] xValues) {
        this.xValues = xValues;
    }

    public double[] getYValues() {
        return this.yValues;
    }

    public void setYValues(double[] yValues) {
        this.yValues = yValues;
    }

    public int getNumberOfPoints() {
        return this.numberOfPoints;
    }

    public NMRSpectrum.Unit getUnit() {
        return this.unit;
    }

    public void setUnit(NMRSpectrum.Unit unit) {
        if (this.unit.equals((Object)NMRSpectrum.Unit.ppm) && unit.equals((Object)NMRSpectrum.Unit.Hz)) {
            this.scale(this.getFrequency());
            this.xLabel = NMRSpectrum.Unit.Hz.toString();
        } else if (this.unit.equals((Object)NMRSpectrum.Unit.Hz) && unit.equals((Object)NMRSpectrum.Unit.ppm)) {
            this.scale(1.0 / this.getFrequency());
            this.xLabel = NMRSpectrum.Unit.ppm.toString();
        }
        this.unit = unit;
    }

    private void scale(double scalingFactor) {
        int i;
        if (this.xValues != null) {
            i = 0;
            while (i < this.xValues.length) {
                int n = i++;
                this.xValues[n] = this.xValues[n] * scalingFactor;
            }
        }
        this.domainMin *= scalingFactor;
        this.domainMax *= scalingFactor;
        if (this.localMaximumPlaces != null) {
            i = 0;
            while (i < this.localMaximumPlaces.length) {
                int n = i++;
                this.localMaximumPlaces[n] = this.localMaximumPlaces[n] * scalingFactor;
            }
        }
        if (this.shifts != null) {
            for (Shift shift : this.shifts) {
                shift.scaleShift(scalingFactor);
            }
        }
    }

    public Shift[] getShifts() {
        return this.shifts;
    }

    public void setShifts(Shift[] shifts) {
        this.shifts = shifts;
    }

    public String getXLabel() {
        return this.xLabel;
    }

    public void setXLabel(String xLabel) {
        this.xLabel = xLabel;
    }

    public String getYLabel() {
        return this.yLabel;
    }

    public void setYLabel(String yLabel) {
        this.yLabel = yLabel;
    }

    public double getRangeMin() {
        return this.rangeMin;
    }

    public void setRangeMin(double rangeMin) {
        this.rangeMin = rangeMin;
    }

    public double getRangeMax() {
        return this.rangeMax;
    }

    public void setRangeMax(double rangeMax) {
        this.rangeMax = rangeMax;
    }
}

