/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.calculations.nmr;

import chemaxon.calculations.nmr.MoleculeWithFocusAtom;
import chemaxon.calculations.nmr.NMRCoefficient;
import chemaxon.calculations.nmr.NMRShiftPredictionAlgorithm;
import chemaxon.calculations.nmr.NMRSpectrum;
import chemaxon.calculations.nmr.SphericalNMRTrainingModel;
import chemaxon.calculations.training.ParallelPredictor;

public class NMRShiftPredictor
extends ParallelPredictor<MoleculeWithFocusAtom, double[]> {
    private double shiftError;
    private NMRCoefficient.ErrorClassification classification;
    private NMRShiftPredictionAlgorithm algorithm;

    protected NMRShiftPredictor(NMRShiftPredictionAlgorithm algorithm, SphericalNMRTrainingModel[] models) {
        super(algorithm, models);
        this.algorithm = algorithm;
    }

    @Override
    public double predict(MoleculeWithFocusAtom molWithFocusAtom) {
        double shift = super.predict(molWithFocusAtom);
        this.shiftError = this.algorithm.getShiftError();
        this.classification = this.algorithm.getClassification();
        return shift;
    }

    public double getShiftError() {
        return this.shiftError;
    }

    public NMRCoefficient.ErrorClassification getClassification() {
        return this.classification;
    }

    public void setNucleus(NMRSpectrum.Nucleus nucleus) {
        this.algorithm.setNucleus(nucleus);
    }
}

