/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.calculations.nmr;

import chemaxon.calculations.nmr.NMRShiftTrainer;
import chemaxon.calculations.nmr.SphericalNMRTrainingModel;
import chemaxon.calculations.training.CachedMatrix;
import chemaxon.calculations.training.DescriptorMatrix;
import chemaxon.calculations.training.FittingAlgorithm;
import chemaxon.calculations.training.SVDFitting;
import chemaxon.calculations.training.SVDTrainingResult;

public class NMRShiftTrainerFactory {
    public static final NMRShiftTrainer createNMRShiftTrainer() {
        return NMRShiftTrainerFactory.createNMRShiftTrainer(Runtime.getRuntime().availableProcessors());
    }

    public static final NMRShiftTrainer createNMRShiftTrainer(int threadCount) {
        return NMRShiftTrainerFactory.createNMRShiftTrainer(new SVDFitting(), new CachedMatrix(), threadCount);
    }

    public static final NMRShiftTrainer createNMRShiftTrainer(FittingAlgorithm<SVDTrainingResult> algorithm, DescriptorMatrix descriptorMatrix) {
        return NMRShiftTrainerFactory.createNMRShiftTrainer(algorithm, descriptorMatrix, Runtime.getRuntime().availableProcessors());
    }

    public static final NMRShiftTrainer createNMRShiftTrainer(FittingAlgorithm<SVDTrainingResult> algorithm, DescriptorMatrix descriptorMatrix, int threadCount) {
        SphericalNMRTrainingModel[] models = new SphericalNMRTrainingModel[threadCount];
        for (int i = 0; i < models.length; ++i) {
            models[i] = new SphericalNMRTrainingModel();
        }
        return new NMRShiftTrainer(algorithm, descriptorMatrix, models);
    }
}

