/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.calculations.nmr;

import chemaxon.calculations.nmr.MoleculeWithFocusAtom;
import chemaxon.calculations.training.TrainingModel;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import java.util.LinkedList;
import java.util.Stack;

public class SphericalNMRTrainingModel
implements TrainingModel<MoleculeWithFocusAtom> {
    public static final int MAX_SPHERE_COUNT = 6;
    public static final int ATOM_TYPE_COUNT = 28;
    public static final int DESCRIPTOR_TYPE_COUNT = 30;
    public static final int DESCRIPTOR_COUNT = 420;
    private static final int HAtNo = 1;
    private static final int CAtNo = 6;
    private static final int NAtNo = 7;
    private static final int OAtNo = 8;
    private static final int FAtNo = 9;
    private static final int PAtNo = 15;
    private static final int SAtNo = 16;
    private static final int ClAtNo = 17;
    private static final int BrAtNo = 35;
    private static final int IAtNo = 53;

    @Override
    public double[] getDescriptors(MoleculeWithFocusAtom data, boolean forceData) {
        int i;
        Molecule mol = data.getMolecule().cloneMolecule();
        int focusAtomIndex = data.getAtomIndex();
        if (focusAtomIndex < 0 || focusAtomIndex >= mol.getAtomCount()) {
            if (forceData) {
                return new double[420];
            }
            return new double[0];
        }
        mol.aromatize(2);
        mol.calcHybridization();
        int atomCount = mol.getAtomCount();
        int[] spheresOfAtoms = this.bfs(mol, focusAtomIndex);
        boolean[] piSystem = this.findPiSystem(mol, focusAtomIndex);
        int[][] rings = mol.getCSSR();
        double[] descriptors = new double[420];
        MolAtom focusAtom = mol.getAtom(focusAtomIndex);
        descriptors[28] = focusAtom.getExplicitHcount() + focusAtom.getImplicitHcount();
        if (piSystem[focusAtomIndex]) {
            descriptors[58] = descriptors[28];
            piSystem[focusAtomIndex] = false;
        }
        for (i = 0; i < atomCount; ++i) {
            int index;
            MolAtom atom = mol.getAtom(i);
            if (atom.getAtno() <= 1 || i == focusAtomIndex) continue;
            int sphere = spheresOfAtoms[i];
            int type = this.getAtomType(atom);
            int hydrogenCount = atom.getExplicitHcount() + atom.getImplicitHcount();
            if (type < 0) {
                if (forceData) continue;
                return new double[0];
            }
            int n = index = 2 * (sphere - 1) * 30 + type;
            descriptors[n] = descriptors[n] + 1.0;
            index = sphere < 6 ? 2 * sphere * 30 + 28 : 388;
            int n2 = index;
            descriptors[n2] = descriptors[n2] + (double)hydrogenCount;
            if (!piSystem[i]) continue;
            int n3 = index = (2 * sphere - 1) * 30 + type;
            descriptors[n3] = descriptors[n3] + 1.0;
            index = sphere < 6 ? (2 * sphere + 1) * 30 + 28 : 418;
            int n4 = index;
            descriptors[n4] = descriptors[n4] + (double)hydrogenCount;
        }
        for (i = 0; i < rings.length; ++i) {
            int ringClosureSphere = 0;
            int ringClosureAtom = 0;
            for (int j = 0; j < rings[i].length; ++j) {
                int ind = rings[i][j];
                if (spheresOfAtoms[ind] <= ringClosureSphere) continue;
                ringClosureSphere = spheresOfAtoms[ind];
                ringClosureAtom = ind;
            }
            if (rings[i].length % 2 == 0) {
                int n = 60 * (ringClosureSphere - 1) + 28 + 1;
                descriptors[n] = descriptors[n] + 1.0;
                int n5 = 60 * (ringClosureSphere - 2) + 28 + 1;
                descriptors[n5] = descriptors[n5] + 1.0;
                if (!piSystem[ringClosureAtom]) continue;
                int n6 = 30 * (2 * ringClosureSphere - 1) + 28 + 1;
                descriptors[n6] = descriptors[n6] + 1.0;
                int n7 = 30 * (2 * ringClosureSphere - 3) + 28 + 1;
                descriptors[n7] = descriptors[n7] + 1.0;
                continue;
            }
            int n = 60 * (ringClosureSphere - 1) + 28 + 1;
            descriptors[n] = descriptors[n] + 2.0;
            if (!piSystem[ringClosureAtom]) continue;
            int n8 = 30 * (2 * ringClosureSphere - 1) + 28 + 1;
            descriptors[n8] = descriptors[n8] + 2.0;
        }
        return descriptors;
    }

    private int[] bfs(Molecule mol, int focusAtomIndex) {
        int molAtomCount = mol.getAtomCount();
        int[] spheresOfAtoms = new int[molAtomCount];
        int[][] cTab = mol.getCtab();
        boolean[] atomsExamined = new boolean[molAtomCount];
        LinkedList<Integer> neighbors = new LinkedList<Integer>();
        neighbors.add(new Integer(focusAtomIndex));
        atomsExamined[focusAtomIndex] = true;
        int count = 0;
        while (!neighbors.isEmpty()) {
            if (count <= 6) {
                ++count;
            }
            int atomCount = neighbors.size();
            for (int i = 0; i < atomCount; ++i) {
                int atomInd = (Integer)neighbors.poll();
                for (int j = 0; j < cTab[atomInd].length; ++j) {
                    int ind = cTab[atomInd][j];
                    if (atomsExamined[ind] || mol.getAtom(ind).getAtno() <= 1) continue;
                    atomsExamined[ind] = true;
                    spheresOfAtoms[ind] = count;
                    neighbors.add(new Integer(ind));
                }
            }
        }
        for (int i = 0; i < spheresOfAtoms.length; ++i) {
            if (spheresOfAtoms[i] != 0 || mol.getAtom(i).getAtno() <= 1 || i == focusAtomIndex) continue;
            spheresOfAtoms[i] = 7;
        }
        return spheresOfAtoms;
    }

    private boolean[] findPiSystem(Molecule mol, int focusAtomIndex) {
        int index;
        boolean[] piSystem = new boolean[mol.getAtomCount()];
        int[][] cTab = mol.getCtab();
        Stack<Integer> dfs = new Stack<Integer>();
        piSystem[focusAtomIndex] = true;
        dfs.add(new Integer(focusAtomIndex));
        while (!dfs.empty()) {
            int atom = (Integer)dfs.peek();
            boolean stepFurther = false;
            for (int i = 0; i < cTab[atom].length; ++i) {
                index = cTab[atom][i];
                if (piSystem[index] || !this.hasConjugatedBond(mol.getAtom(index))) continue;
                dfs.add(new Integer(index));
                piSystem[index] = true;
                stepFurther = true;
                break;
            }
            if (stepFurther) continue;
            ((Integer)dfs.pop()).intValue();
        }
        if (!this.hasConjugatedBond(mol.getAtom(focusAtomIndex))) {
            piSystem[focusAtomIndex] = false;
        }
        boolean[] extendedPiSystem = (boolean[])piSystem.clone();
        for (int i = 0; i < piSystem.length; ++i) {
            if (!piSystem[i]) continue;
            for (int j = 0; j < cTab[i].length; ++j) {
                index = cTab[i][j];
                if (mol.getAtom(index).getAtno() <= 1 && index != focusAtomIndex) continue;
                extendedPiSystem[index] = true;
            }
        }
        return extendedPiSystem;
    }

    private int getAtomType(MolAtom atom) {
        int atomicNumber = atom.getAtno();
        switch (atomicNumber) {
            case 6: {
                return this.getCType(atom);
            }
            case 7: {
                return this.getNType(atom);
            }
            case 8: {
                return this.getOType(atom);
            }
            case 15: {
                return this.getPType(atom);
            }
            case 16: {
                return this.getSType(atom);
            }
            case 9: {
                return this.getFType(atom);
            }
            case 17: {
                return this.getClType(atom);
            }
            case 35: {
                return this.getBrType(atom);
            }
            case 53: {
                return this.getIType(atom);
            }
        }
        return -1;
    }

    private int getCType(MolAtom atom) {
        if (atom.getAtno() != 6) {
            return -1;
        }
        int hybridization = atom.getHybridizationState();
        int hydrogenCount = atom.getImplicitHcount() + atom.getExplicitHcount();
        if (atom.hasAromaticBond()) {
            switch (hydrogenCount) {
                case 0: {
                    return 7;
                }
                case 1: {
                    return 8;
                }
            }
            return -1;
        }
        switch (hybridization) {
            case 4: {
                switch (hydrogenCount) {
                    case 0: {
                        return 0;
                    }
                    case 1: {
                        return 1;
                    }
                    case 2: {
                        return 2;
                    }
                    case 3: {
                        return 3;
                    }
                }
                return -1;
            }
            case 3: {
                switch (hydrogenCount) {
                    case 0: {
                        return 4;
                    }
                    case 1: {
                        return 5;
                    }
                    case 2: {
                        return 5;
                    }
                }
                return -1;
            }
            case 2: {
                return 6;
            }
        }
        return -1;
    }

    private int getNType(MolAtom atom) {
        if (atom.getAtno() != 7) {
            return -1;
        }
        int hybridization = atom.getHybridizationState();
        int hydrogenCount = atom.getImplicitHcount() + atom.getExplicitHcount();
        MolAtom[] ligands = atom.getLigands();
        if (atom.hasAromaticBond()) {
            return 15;
        }
        switch (hybridization) {
            case 4: {
                switch (hydrogenCount) {
                    case 0: {
                        return 9;
                    }
                    case 1: {
                        return 10;
                    }
                    case 2: {
                        return 11;
                    }
                }
                return -1;
            }
            case 3: {
                int oxygenCount = 0;
                for (MolAtom ligand : ligands) {
                    if (ligand.getAtno() != 8) continue;
                    ++oxygenCount;
                }
                if (oxygenCount == 2) {
                    return 14;
                }
                return 12;
            }
            case 2: {
                return 13;
            }
        }
        return -1;
    }

    private int getOType(MolAtom atom) {
        if (atom.getAtno() != 8) {
            return -1;
        }
        int hybridization = atom.getHybridizationState();
        int hydrogenCount = atom.getImplicitHcount() + atom.getExplicitHcount();
        switch (hybridization) {
            case 4: {
                if (hydrogenCount == 0) {
                    return 16;
                }
                return 17;
            }
            case 3: {
                return 18;
            }
        }
        return -1;
    }

    private int getPType(MolAtom atom) {
        if (atom.getAtno() != 15) {
            return -1;
        }
        int hybridization = atom.getHybridizationState();
        MolAtom[] ligands = atom.getLigands();
        switch (hybridization) {
            case 4: {
                return 19;
            }
            case 3: {
                int oxygenCount = 0;
                for (MolAtom ligand : ligands) {
                    int bondType = atom.getBondTo(ligand).getType();
                    if (ligand.getAtno() != 8 || bondType != 2) continue;
                    ++oxygenCount;
                }
                if (oxygenCount != true) break;
                return 20;
            }
        }
        return -1;
    }

    private int getSType(MolAtom atom) {
        if (atom.getAtno() != 16) {
            return -1;
        }
        int hybridization = atom.getHybridizationState();
        int bondCount = atom.getBondCount();
        MolAtom[] ligands = atom.getLigands();
        switch (hybridization) {
            case 4: {
                if (bondCount <= 2) {
                    return 21;
                }
                return -1;
            }
            case 3: {
                if (bondCount == 1) {
                    return 22;
                }
                return -1;
            }
            case 2: {
                int oxygenCount = 0;
                for (MolAtom ligand : ligands) {
                    int bondType = atom.getBondTo(ligand).getType();
                    if (ligand.getAtno() != 8 || bondType != 2) continue;
                    ++oxygenCount;
                }
                if (oxygenCount != 2) break;
                return 23;
            }
        }
        return -1;
    }

    private int getFType(MolAtom atom) {
        if (atom.getAtno() != 9) {
            return -1;
        }
        return 24;
    }

    private int getClType(MolAtom atom) {
        if (atom.getAtno() != 17) {
            return -1;
        }
        return 25;
    }

    private int getBrType(MolAtom atom) {
        if (atom.getAtno() != 35) {
            return -1;
        }
        return 26;
    }

    private int getIType(MolAtom atom) {
        if (atom.getAtno() != 53) {
            return -1;
        }
        return 27;
    }

    private boolean hasConjugatedBond(MolAtom atom) {
        for (int i = 0; i < atom.getBondCount(); ++i) {
            if (!this.isConjugatedBond(atom.getBond(i))) continue;
            return true;
        }
        return false;
    }

    private boolean isConjugatedBond(MolBond bond) {
        if (bond.getType() == 4) {
            return true;
        }
        if (bond.getType() == 2) {
            int i;
            MolAtom atom1 = bond.getAtom1();
            MolAtom atom2 = bond.getAtom2();
            int doubleBondCount1 = 0;
            int doubleBondCount2 = 0;
            for (i = 0; i < atom1.getBondCount(); ++i) {
                if (atom1.getBond(i).getType() != 2) continue;
                ++doubleBondCount1;
            }
            for (i = 0; i < atom2.getBondCount(); ++i) {
                if (atom2.getBond(i).getType() != 2) continue;
                ++doubleBondCount2;
            }
            return doubleBondCount1 == 1 && doubleBondCount2 == 1;
        }
        if (bond.getType() == 1) {
            int i;
            MolAtom atom1 = bond.getAtom1();
            MolAtom atom2 = bond.getAtom2();
            boolean doubleBond1 = false;
            boolean doubleBond2 = false;
            for (i = 0; i < atom1.getBondCount(); ++i) {
                if (atom1.getBond(i).getType() != 2) continue;
                doubleBond1 = true;
                break;
            }
            for (i = 0; i < atom2.getBondCount(); ++i) {
                if (atom2.getBond(i).getType() != 2) continue;
                doubleBond2 = true;
                break;
            }
            if (doubleBond1 && doubleBond2) {
                return true;
            }
            if (doubleBond1 && !doubleBond2) {
                return atom2.hasAromaticBond();
            }
            if (!doubleBond1 && doubleBond2) {
                return atom1.hasAromaticBond();
            }
            if (!doubleBond1 && !doubleBond2) {
                return atom1.hasAromaticBond() && atom2.hasAromaticBond();
            }
            return false;
        }
        return false;
    }
}

