/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.calculations.nmr.io;

import chemaxon.calculations.nmr.MeasuredNMRSpectrum;
import chemaxon.calculations.nmr.NMRSpectrum;
import chemaxon.calculations.nmr.Shift;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.StringTokenizer;
import org.jcamp.math.Range2D;
import org.jcamp.parser.JCAMPBlock;
import org.jcamp.parser.JCAMPException;
import org.jcamp.parser.JCAMPReader;
import org.jcamp.spectrum.Assignment;
import org.jcamp.spectrum.IDataArray1D;
import org.jcamp.spectrum.IOrderedDataArray1D;
import org.jcamp.spectrum.NMRSpectrum;
import org.jcamp.spectrum.Peak1D;
import org.jcamp.spectrum.Spectrum;

public class NMRImporter {
    private static final String SEPARATOR = ",";
    public static final String C13_NAME = "13C";
    public static final String H1_NAME = "1H";

    public static MeasuredNMRSpectrum importFromJcampDX(Reader input, double rangeMax) throws IOException {
        String line;
        MeasuredNMRSpectrum measuredNMRSpectrum = new MeasuredNMRSpectrum();
        StringBuffer spectrum = new StringBuffer();
        BufferedReader bufferedInput = new BufferedReader(input);
        while ((line = bufferedInput.readLine()) != null) {
            spectrum.append(line + '\n');
        }
        bufferedInput.close();
        try {
            JCAMPReader jcampReader = JCAMPReader.getInstance();
            Spectrum jcampSpectrum = jcampReader.createSpectrum(spectrum.toString());
            jcampSpectrum = jcampReader.createSpectrum(spectrum.toString());
            NMRSpectrum nmrSpectrum = (NMRSpectrum)jcampSpectrum;
            String nucleus = nmrSpectrum.getNucleus();
            if (nucleus.equals(C13_NAME)) {
                measuredNMRSpectrum.setNucleus(NMRSpectrum.Nucleus.C13);
            }
            if (nucleus.equals(H1_NAME)) {
                measuredNMRSpectrum.setNucleus(NMRSpectrum.Nucleus.H1);
            }
            if (nmrSpectrum.getXAxisLabel().equals("PPM") || nmrSpectrum.getXAxisLabel().equals("ppm")) {
                measuredNMRSpectrum.setUnit(NMRSpectrum.Unit.ppm);
            }
            if (nmrSpectrum.getXAxisLabel().equals("HZ") || nmrSpectrum.getXAxisLabel().equals("Hz")) {
                measuredNMRSpectrum.setUnit(NMRSpectrum.Unit.Hz);
            }
            measuredNMRSpectrum.setXLabel(nmrSpectrum.getXAxisLabel());
            measuredNMRSpectrum.setYLabel(nmrSpectrum.getYAxisLabel());
            double frequency = nmrSpectrum.getFrequency();
            measuredNMRSpectrum.setFrequency(frequency);
            measuredNMRSpectrum.setOwner(nmrSpectrum.getOwner());
            measuredNMRSpectrum.setTitle(nmrSpectrum.getTitle());
            Range2D.Double range = nmrSpectrum.getDataRange();
            double xMin = range.getXMin();
            double xMax = range.getXMax();
            measuredNMRSpectrum.setDomainMin(xMin);
            measuredNMRSpectrum.setDomainMax(xMax);
            JCAMPBlock rootBlock = jcampReader.getRootblock();
            if (rootBlock == null) {
                int i;
                IOrderedDataArray1D xVal = nmrSpectrum.getXData();
                IDataArray1D yVal = nmrSpectrum.getYData();
                int numberOfPoints = xVal.getLength();
                double[] xValues = new double[numberOfPoints];
                double[] yValues = new double[numberOfPoints];
                double rangeMin = yValues[0];
                double yMax = yValues[0];
                for (int i2 = 0; i2 < numberOfPoints; ++i2) {
                    xValues[i2] = xVal.pointAt(i2);
                    yValues[i2] = yVal.pointAt(i2);
                    if (yValues[i2] < rangeMin) {
                        rangeMin = yValues[i2];
                    }
                    if (!(yValues[i2] > yMax)) continue;
                    yMax = yValues[i2];
                }
                if (Math.abs(rangeMax - yMax) > Double.MIN_VALUE) {
                    double scale = rangeMax / yMax;
                    i = 0;
                    while (i < yValues.length) {
                        int n = i++;
                        yValues[n] = yValues[n] * scale;
                    }
                }
                measuredNMRSpectrum.setXValues(xValues);
                measuredNMRSpectrum.setYValues(yValues);
                measuredNMRSpectrum.setRangeMin(rangeMin);
                measuredNMRSpectrum.setRangeMax(rangeMax);
                if (nmrSpectrum.hasPeakTable()) {
                    Peak1D[] p = nmrSpectrum.getPeakTable();
                    int peakCount = p.length;
                    double[] localMaximumPlaces = new double[peakCount];
                    double[] localMaximumValues = new double[peakCount];
                    for (int i3 = 0; i3 < peakCount; ++i3) {
                        localMaximumPlaces[i3] = p[i3].getPosition()[0];
                        localMaximumValues[i3] = p[i3].getHeight();
                    }
                    measuredNMRSpectrum.setLocalMaximumPlaces(localMaximumPlaces);
                    measuredNMRSpectrum.setLocalMaximumValues(localMaximumValues);
                }
                if (nmrSpectrum.hasAssignments()) {
                    Assignment[] assignment = nmrSpectrum.getAssignments();
                    ArrayList<Shift> shifts = new ArrayList<Shift>();
                    for (i = 0; i < assignment.length; ++i) {
                        double[] position = assignment[i].getPosition();
                        StringBuffer label = new StringBuffer(assignment[i].getLabel());
                        label.deleteCharAt(0);
                        label.deleteCharAt(label.length() - 1);
                        StringTokenizer st = new StringTokenizer(label.toString(), SEPARATOR);
                        ArrayList<Integer> index = new ArrayList<Integer>();
                        while (st.hasMoreTokens()) {
                            index.add(new Integer(st.nextToken()));
                        }
                        for (int j = 0; j < index.size(); ++j) {
                            shifts.add(new Shift((Integer)index.get(j), position[0]));
                        }
                    }
                    Shift[] shiftArray = new Shift[shifts.size()];
                    for (int i4 = 0; i4 < shiftArray.length; ++i4) {
                        shiftArray[i4] = (Shift)shifts.get(i4);
                    }
                    measuredNMRSpectrum.setShifts(shiftArray);
                }
            } else {
                Enumeration blocks = rootBlock.getBlocks();
                while (blocks.hasMoreElements()) {
                    JCAMPBlock b = (JCAMPBlock)blocks.nextElement();
                    NMRSpectrum spectrumBlock = (NMRSpectrum)jcampReader.createSpectrum(rootBlock, b.getID());
                    if (b.getType().equals((Object)JCAMPBlock.Type.FULLSPECTRUM)) {
                        IOrderedDataArray1D xVal = spectrumBlock.getXData();
                        IDataArray1D yVal = spectrumBlock.getYData();
                        int numberOfPoints = xVal.getLength();
                        double[] xValues = new double[numberOfPoints];
                        double[] yValues = new double[numberOfPoints];
                        double rangeMin = yValues[0];
                        double yMax = yValues[0];
                        for (int i = 0; i < numberOfPoints; ++i) {
                            xValues[i] = xVal.pointAt(i);
                            yValues[i] = yVal.pointAt(i);
                            if (yValues[i] < rangeMin) {
                                rangeMin = yValues[i];
                            }
                            if (!(yValues[i] > yMax)) continue;
                            yMax = yValues[i];
                        }
                        if (Math.abs(rangeMax - yMax) > Double.MIN_VALUE) {
                            double scale = rangeMax / yMax;
                            int i = 0;
                            while (i < yValues.length) {
                                int n = i++;
                                yValues[n] = yValues[n] * scale;
                            }
                        }
                        measuredNMRSpectrum.setXValues(xValues);
                        measuredNMRSpectrum.setYValues(yValues);
                        measuredNMRSpectrum.setRangeMin(rangeMin);
                        measuredNMRSpectrum.setRangeMax(rangeMax);
                    }
                    if (b.getType().equals((Object)JCAMPBlock.Type.PEAKTABLE)) {
                        Peak1D[] p = spectrumBlock.getPeakTable();
                        int peakCount = p.length;
                        double[] localMaximumPlaces = new double[peakCount];
                        double[] localMaximumValues = new double[peakCount];
                        for (int i = 0; i < peakCount; ++i) {
                            localMaximumPlaces[i] = p[i].getPosition()[0];
                            localMaximumValues[i] = p[i].getHeight();
                        }
                        measuredNMRSpectrum.setLocalMaximumPlaces(localMaximumPlaces);
                        measuredNMRSpectrum.setLocalMaximumValues(localMaximumValues);
                    }
                    if (!b.getType().equals((Object)JCAMPBlock.Type.ASSIGNMENT)) continue;
                    Assignment[] assignment = spectrumBlock.getAssignments();
                    ArrayList<Shift> shifts = new ArrayList<Shift>();
                    for (int i = 0; i < assignment.length; ++i) {
                        double[] position = assignment[i].getPosition();
                        StringBuffer label = new StringBuffer(assignment[i].getLabel());
                        label.deleteCharAt(0);
                        label.deleteCharAt(label.length() - 1);
                        StringTokenizer st = new StringTokenizer(label.toString(), SEPARATOR);
                        ArrayList<Integer> index = new ArrayList<Integer>();
                        while (st.hasMoreTokens()) {
                            index.add(new Integer(st.nextToken()));
                        }
                        for (int j = 0; j < index.size(); ++j) {
                            shifts.add(new Shift((Integer)index.get(j), position[0]));
                        }
                    }
                    Shift[] shiftArray = new Shift[shifts.size()];
                    for (int i = 0; i < shiftArray.length; ++i) {
                        shiftArray[i] = (Shift)shifts.get(i);
                    }
                    measuredNMRSpectrum.setShifts(shiftArray);
                }
            }
        }
        catch (JCAMPException e) {
            throw new IOException(e.getMessage());
        }
        return measuredNMRSpectrum;
    }

    public static MeasuredNMRSpectrum importFromJcampDX(Reader input) throws IOException {
        return NMRImporter.importFromJcampDX(input, 100.0);
    }
}

