/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.calculations.pka;

import chemaxon.calculations.pka.IntrinsicIonization;
import chemaxon.calculations.pka.Ionizer;
import chemaxon.common.util.MProgressMonitor;
import chemaxon.struc.MolAtom;
import chemaxon.struc.Molecule;

public class PKaLargeModel {
    private static double CALCSTATUS_PKA_STEP = 3.3333333333333335;
    private static double CALCSTATUS_PI_STEP = 2.7777777777777777;
    private boolean pIcalc = false;
    private MProgressMonitor progressMonitor = null;
    private Ionizer ionizer;
    private IntrinsicIonization pkalc;
    private Molecule protein = null;
    private String pKaDirectoryPath = null;
    int MOLATOMS;
    private double BCUTOFF = -100.0;
    private double ACUTOFF = 200.0;
    double[] BpKa = null;
    double[] ApKa = null;
    int[] bInd = null;
    int[] aInd = null;
    int bCount = 0;
    int aCount = 0;
    final int GCOrigin = 8;
    int GC;
    double pH;
    int bCutIndex = -1;
    int aCutIndex = -1;
    int aGCount;
    int bGCount;
    double[] gpKa = null;
    int[] gAtoms = null;
    int[] ionType = null;
    public static final int ACIDIC = -1;
    public static final int BASIC = 1;
    public static final int UNKNOWN = -2;
    private int pKaPrefixType = 1;
    public static final int STATICpKaPREFIX = 1;
    public static final int DYNAMICpKaPREFIX = 2;
    int[][] gInfo = null;
    int[][] gAtomInfo = null;
    int[] iLInfo = null;
    int[] check = null;
    double[] gMicropka = null;
    int gCount;
    double[] gdist = null;
    int[] gOrd = null;
    double protonConc;
    boolean aExist;
    boolean bExist;
    double[] pHCharge = null;
    double pHLower = 0.0;
    double pHUpper = 14.0;
    double pHStepSize = 0.5;
    int pHStepCount;
    private double[] pHPoints = null;
    int[] micropKaType = null;
    double[] microK = null;
    double[] secondMicropKa = null;
    int[] secondMicropKaType = null;
    double temp = 298.0;
    int[] microSpec = null;
    int[][] microSpecInfo = null;
    int[] ionizableAtoms = null;
    double[] macropKa = null;
    int ionCount;
    double sumMolecule;
    boolean zwitterIon;
    boolean bMolecule;
    boolean aMolecule;
    boolean symmetric = false;
    double TOLERANCE = 0.001;
    double[] TO = null;
    int[] macropKaAtoms = null;
    double[] gAMacropKa = null;
    double[] gBMacropKa = null;
    int[] pKaType = null;
    int[] mAcidicGCIndex = null;
    int[] mBasicGCIndex = null;
    private boolean proteinStart;
    int acidpKaCount;
    int basepKaCount;
    double isoPoint;
    double calcStatuspKa;
    double calcStatuspI;
    double[][] X = null;
    int[] macroSpecCharge = null;
    int[] initNIndex = null;
    double[] initNpKa = null;
    int[] initNType = null;
    int exNHType = -2;
    boolean tautomerCalculation = false;
    double majpH = 7.4;
    Molecule molCopy;
    boolean majorMsCalc;
    boolean createCenterInfo = false;
    boolean correctionInfoAvailable = false;
    double[] gdistMan;
    int fpchg;

    public void setProgressMonitor(MProgressMonitor pmon) {
        this.progressMonitor = pmon;
    }

    public void setMolecule(Molecule m) {
        this.molCopy = m;
        this.protein = m.cloneMoleculeWithDocument();
        this.proteinStart = true;
        this.neutralize(this.protein);
    }

    public Molecule getMolecule() {
        return this.molCopy;
    }

    public void setpH(double pH) {
        this.pH = pH;
    }

    public void setpHL(double pHL) {
        this.pHLower = pHL;
    }

    public void setpHU(double pHU) {
        this.pHUpper = pHU;
    }

    public void setpHS(double pHS) {
        this.pHStepSize = pHS;
    }

    public void setBasicpKaLowerLimit(double bpka) {
        this.BCUTOFF = bpka;
    }

    public void setAcidicpKaUpperLimit(double apka) {
        this.ACUTOFF = apka;
    }

    public boolean getCriticalErrorFlag() {
        return this.pkalc.getCriticalErrorFlag();
    }

    public void setpKaPrefixType(int pKaPtype) {
        this.pKaPrefixType = pKaPtype;
    }

    public int getpKaPrefixType() {
        return this.pKaPrefixType;
    }

    public void setTautomerCalcFlag(boolean tauCalc) {
        this.tautomerCalculation = tauCalc;
    }

    public void setCorrectionLibraryAbsolutePath(String path) {
        this.pKaDirectoryPath = path;
        boolean bl = this.createCenterInfo = path != null;
        if (this.ionizer != null) {
            this.ionizer.setCorrectionLibraryAbsolutePath(path);
        }
    }

    private void initArrays(Molecule m) {
        this.BpKa = new double[this.bCount];
        this.ApKa = new double[this.aCount];
        this.bInd = new int[this.bCount];
        this.aInd = new int[this.aCount];
        this.gpKa = new double[this.GC];
        this.gAtoms = new int[this.GC];
        this.MOLATOMS = m.getAtomCount();
        this.ionType = new int[this.MOLATOMS];
    }

    private void setpHInfo() {
        this.pHStepCount = (int)Math.round((this.pHUpper - this.pHLower) / this.pHStepSize);
        this.pHPoints = new double[this.pHStepCount + 1];
        for (int i = 0; i <= this.pHStepCount; ++i) {
            this.pHPoints[i] = this.pHLower + (double)i * this.pHStepSize;
        }
        this.pHCharge = new double[this.pHStepCount + 1];
    }

    private void neutralize(Molecule m) {
        int atomCount = m.getAtomCount();
        this.fpchg = 0;
        for (int atom = 0; atom < atomCount; ++atom) {
            MolAtom a = m.getAtom(atom);
            int pCount = a.getAtno();
            int charge = a.getCharge();
            boolean single = false;
            if (this.isSingleAnion(a, charge)) {
                single = true;
            }
            if (pCount == 8 || pCount == 7 || pCount == 16 || pCount == 15 || single || pCount == 6 && charge == -1) {
                if (charge == 0) continue;
                int implicitHCount = a.getImplicitHcount();
                if (charge < 0) {
                    int absChg = -1 * charge;
                    a.setImplicitHcount(implicitHCount + absChg);
                    a.setCharge(0);
                    continue;
                }
                if (implicitHCount > 0) {
                    a.setImplicitHcount(implicitHCount - charge);
                    a.setCharge(0);
                    continue;
                }
                ++this.fpchg;
                continue;
            }
            if (charge <= 0) continue;
            ++this.fpchg;
        }
    }

    private boolean isSingleAnion(MolAtom a, int chg) {
        return chg < 0 && a.getImplicitHcount() == 0 && a.getBondCount() == 0;
    }

    public void calcProteinIonization(double ph) {
        this.calcMicropKa(this.protein);
        this.setpH(ph);
        this.GC = 8;
        this.exNHType = -2;
        this.calcInitAtomSet(this.protein);
        if (this.aGCount + this.bGCount < 8) {
            this.GC = this.aGCount + this.bGCount;
        }
        if (this.GC != 0) {
            int gIndex;
            this.initGAtomInfo();
            for (int j = 0; j < this.GC; ++j) {
                this.gMicropka[j] = this.gpKa[j];
            }
            for (gIndex = 0; gIndex < this.gCount; ++gIndex) {
                this.setGroupInfo(gIndex);
            }
            for (gIndex = 0; gIndex < this.gCount; ++gIndex) {
                if (this.gInfo[gIndex][this.GC] <= 1) continue;
                this.reCalcAtomSet(gIndex, this.isNewCalc(gIndex));
            }
            this.symmetric = this.isSymmetric();
            this.calcRatios();
            this.calcGroupDistribution();
        }
    }

    private void initGAtomInfo() {
        int i;
        this.gCount = (int)Math.pow(2.0, this.GC);
        this.calcProteinGroups();
        this.gAtomInfo = new int[this.gCount][this.GC];
        this.gMicropka = new double[this.gCount];
        this.gInfo = new int[this.gCount][this.GC + 4];
        this.iLInfo = new int[3];
        this.check = new int[this.GC];
        for (int gIndex = 0; gIndex < this.gCount; ++gIndex) {
            int i2;
            this.gMicropka[gIndex] = -2.0;
            for (i2 = 0; i2 < this.GC; ++i2) {
                this.gAtomInfo[gIndex][i2] = -2;
            }
            for (i2 = 0; i2 < this.GC + 4; ++i2) {
                this.gInfo[gIndex][i2] = -2;
            }
        }
        for (i = 0; i < 3; ++i) {
            this.iLInfo[i] = -2;
        }
        for (i = 0; i < this.GC; ++i) {
            this.check[i] = -2;
        }
    }

    private boolean isNewCalc(int gIndex) {
        int lbp = this.getLargestGroupPos(gIndex);
        for (int i = 0; i < lbp; ++i) {
            int j;
            if (this.gAtomInfo[gIndex][i] == this.check[i]) continue;
            for (j = 0; j < this.GC; ++j) {
                this.check[j] = -2;
            }
            for (j = 0; j < lbp; ++j) {
                this.check[j] = this.gAtomInfo[gIndex][j];
            }
            return true;
        }
        return false;
    }

    public void setGroupInfo(int gIndex) {
        int i = 1;
        int mSpecies = this.getProteinGroup(gIndex);
        int bitCount = 0;
        int ionDegree = 0;
        int ac = 0;
        int bc = 0;
        while (bitCount < this.GC) {
            if ((mSpecies & i) == i) {
                ++ionDegree;
                this.gInfo[gIndex][bitCount] = this.ionType[this.gAtoms[bitCount]];
                this.gAtomInfo[gIndex][bitCount] = this.gAtoms[bitCount];
                if (this.ionType[this.gAtoms[bitCount]] == -1) {
                    ++ac;
                } else {
                    ++bc;
                }
            }
            ++bitCount;
            i = 2 * i;
        }
        this.iLInfo = this.getProteinGroupInfo(ionDegree);
        this.gInfo[gIndex][this.GC] = this.iLInfo[0];
        this.gInfo[gIndex][this.GC + 1] = this.iLInfo[1];
        this.gInfo[gIndex][this.GC + 2] = this.iLInfo[2];
        this.gInfo[gIndex][this.GC + 3] = ac + (this.bGCount - bc);
        if (gIndex == 0) {
            this.gInfo[gIndex][this.GC + 3] = this.bGCount;
        }
    }

    private void reCalcAtomSet(int gIndex, boolean newC) {
        int lbp = this.getLargestGroupPos(gIndex);
        this.exNHType = this.gInfo[gIndex][lbp] == 1 ? -1 : 1;
        int oLbp = lbp;
        if (newC) {
            Molecule prot = this.getMicroGroupMolecule(gIndex);
            this.calcMicropKa(prot);
            this.calcInitAtomSet(prot);
        }
        lbp = this.correctLbp(gIndex, oLbp);
        lbp = -1;
        if (lbp >= 0) {
            this.gAtomInfo[gIndex][oLbp] = this.gAtoms[lbp];
            this.gMicropka[gIndex - 1] = this.gpKa[lbp];
            this.gInfo[gIndex][oLbp] = this.ionType[this.gAtoms[lbp]];
        } else if (this.gInfo[gIndex][oLbp] == 1) {
            int i = 0;
            try {
                while (this.bInd[i] != this.gAtomInfo[gIndex][oLbp]) {
                    ++i;
                }
                this.gMicropka[gIndex - 1] = this.BpKa[i];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                int aindx = this.gAtomInfo[gIndex][oLbp];
                this.gMicropka[gIndex - 1] = this.microK[aindx];
            }
        } else if (this.gInfo[gIndex][oLbp] == -1) {
            int i = 0;
            try {
                while (this.aInd[i] != this.gAtomInfo[gIndex][oLbp]) {
                    ++i;
                }
                this.gMicropka[gIndex - 1] = this.ApKa[i];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                int aindx = this.gAtomInfo[gIndex][oLbp];
                this.gMicropka[gIndex - 1] = this.microK[aindx];
            }
        }
    }

    private int correctLbp(int gInd, int lbp) {
        int ra = this.aCutIndex + 1;
        int rb = this.bCount - this.bCutIndex;
        if (this.bMolecule) {
            if (this.gInfo[gInd][lbp] == -1) {
                this.bMolecule = false;
                this.aMolecule = true;
                return -1;
            }
            if (rb < this.GC) {
                return -1;
            }
        } else if (this.aMolecule) {
            if (this.gInfo[gInd][lbp] == 1) {
                this.bMolecule = true;
                this.aMolecule = false;
                return -1;
            }
            if (ra < this.GC) {
                return -1;
            }
        } else if (this.zwitterIon) {
            if (this.gInfo[gInd][lbp] == 1) {
                if (rb < this.GC) {
                    return -1;
                }
                if (this.ionType[this.gAtoms[lbp]] != 1) {
                    return -1;
                }
            } else if (this.gInfo[gInd][lbp] == -1) {
                if (ra < this.GC) {
                    return -1;
                }
                if (this.ionType[this.gAtoms[lbp]] != -1) {
                    return -1;
                }
            }
        }
        return lbp;
    }

    private Molecule getMicroGroupMolecule(int gIndex) {
        Molecule mgroup = this.protein.cloneMoleculeWithDocument();
        this.setGroupIonizationState(gIndex, mgroup);
        return mgroup;
    }

    private void setGroupIonizationState(int gIndex, Molecule m) {
        int lbp = this.getLargestGroupPos(gIndex);
        for (int j = 0; j < lbp; ++j) {
            MolAtom a;
            if (this.gInfo[gIndex][j] == -1) {
                a = m.getAtom(this.gAtomInfo[gIndex][j]);
                this.removeHydrogen(a);
                continue;
            }
            if (this.gInfo[gIndex][j] != 1) continue;
            a = m.getAtom(this.gAtomInfo[gIndex][j]);
            this.addHydrogen(a);
        }
    }

    private void removeHydrogen(MolAtom a) {
        int actualHcount = a.getImplicitHcount();
        if (actualHcount != 0) {
            a.setImplicitHcount(actualHcount - 1);
        }
        a.setCharge(-1);
    }

    private void addHydrogen(MolAtom a) {
        if (a.getAtno() != 6) {
            int actualHcount = a.getImplicitHcount();
            a.setImplicitHcount(actualHcount + 1);
            a.setCharge(1);
        }
    }

    private void neutralizeCation(MolAtom a) {
        int actualHcount = a.getImplicitHcount();
        if (actualHcount != 0) {
            a.setImplicitHcount(actualHcount - 1);
        }
        a.setCharge(0);
    }

    private void neutralizeAnion(MolAtom a) {
        int actualHcount = a.getImplicitHcount();
        if (actualHcount != 0) {
            a.setImplicitHcount(actualHcount + 1);
        }
        a.setCharge(0);
    }

    private int getLargestGroupPos(int gIndex) {
        int maxPos = 0;
        for (int i = 0; i < this.GC; ++i) {
            if (this.gInfo[gIndex][i] == -2) continue;
            maxPos = i;
        }
        return maxPos;
    }

    private void calcMicropKa(Molecule prot) {
        this.calcProteinMicropKa(prot);
    }

    private void calcInitAtomSet(Molecule prot) {
        this.excludeNH();
        this.initArrays(prot);
        this.storesMpKa();
        this.sortMicropKa(this.BpKa, this.bInd, 0, this.BpKa.length);
        this.sortMicropKa(this.ApKa, this.aInd, 0, this.ApKa.length);
        this.getCuttingIndexes();
        this.getGroupCounts();
        if (this.bExist) {
            this.setMainBaseAtoms();
        }
        if (this.aExist) {
            this.setMainAcidAtoms();
        }
        int G_C = this.bGCount + this.aGCount;
        this.sortMicropKa(this.gpKa, this.gAtoms, 0, G_C);
    }

    private void excludeNH() {
        for (int i = 0; i < this.MOLATOMS; ++i) {
            double b;
            double a;
            if (Double.isNaN(this.secondMicropKa[i]) || Double.isNaN(this.microK[i])) continue;
            if (this.secondMicropKaType[i] == -1) {
                a = this.secondMicropKa[i];
                b = this.microK[i];
                if (!(a < this.pH + 3.0) || !(b > this.pH - 3.0)) continue;
                if (this.exNHType == 1) {
                    this.microK[i] = Double.NaN;
                    --this.bCount;
                    continue;
                }
                if (this.exNHType != -1 && this.exNHType != -2) continue;
                this.secondMicropKa[i] = Double.NaN;
                --this.aCount;
                continue;
            }
            a = this.microK[i];
            b = this.secondMicropKa[i];
            if (!(a < this.pH + 3.0) || !(b > this.pH - 3.0)) continue;
            if (this.exNHType == 1) {
                this.secondMicropKa[i] = Double.NaN;
                --this.bCount;
                continue;
            }
            if (this.exNHType != -1 && this.exNHType != -2) continue;
            this.microK[i] = Double.NaN;
            --this.aCount;
        }
    }

    private void storesMpKa() {
        int bj = 0;
        int aj = 0;
        for (int i = 0; i < this.MOLATOMS; ++i) {
            double apk;
            double bpk = this.getGroupMicropKa(i, 1);
            if (!Double.isNaN(bpk)) {
                this.BpKa[bj] = bpk;
                this.bInd[bj] = i;
                ++bj;
            }
            if (Double.isNaN(apk = this.getGroupMicropKa(i, -1))) continue;
            this.ApKa[aj] = apk;
            this.aInd[aj] = i;
            ++aj;
        }
    }

    private void sortMicropKa(double[] mpka, int[] index, int from, int to) {
        for (int i = from; i < to - 1; ++i) {
            int k = i;
            double p = mpka[i];
            int ind = index[i];
            for (int j = i + 1; j < to; ++j) {
                if (!(mpka[j] <= p)) continue;
                k = j;
                p = mpka[j];
                ind = index[j];
            }
            if (k == i) continue;
            mpka[k] = mpka[i];
            mpka[i] = p;
            index[k] = index[i];
            index[i] = ind;
        }
    }

    private void getCuttingIndexes() {
        int i;
        this.bCutIndex = -1;
        this.aExist = true;
        this.bExist = true;
        for (i = this.bCount - 1; this.bCutIndex == -1 && i >= 0; --i) {
            if (!(this.BpKa[i] < this.pH - 3.0)) continue;
            this.bCutIndex = i + 1;
            if (i != this.bCount - 1) continue;
            this.bExist = false;
            i = -1;
        }
        if (this.bCount == 0) {
            this.bExist = false;
            this.bCutIndex = 0;
        } else if (!this.bExist) {
            this.bCount = 0;
            this.bCutIndex = 0;
        } else if (this.bCutIndex == -1) {
            this.bCutIndex = 0;
        }
        this.aCutIndex = -1;
        for (i = 0; this.aCutIndex == -1 && i < this.aCount; ++i) {
            if (!(this.ApKa[i] > this.pH + 3.0)) continue;
            this.aCutIndex = i - 1;
            if (i != 0) continue;
            this.aExist = false;
            i = this.aCount;
        }
        if (this.aCount == 0) {
            this.aExist = false;
        } else if (!this.aExist) {
            this.aCount = 0;
        } else if (this.aCutIndex == -1) {
            this.aCutIndex = this.aCount - 1;
        }
    }

    private void getGroupCounts() {
        int a = 0;
        int b = 0;
        a = this.aCutIndex + 1;
        b = this.bCount - this.bCutIndex;
        if (!this.aExist) {
            a = 0;
            this.aGCount = 0;
        } else {
            this.aGCount = Math.round(0.5f + (float)(this.GC * a / (a + b)));
            if (this.aGCount > a) {
                this.aGCount = a;
            }
            if (!this.bExist && a > this.GC) {
                this.aGCount = this.GC;
            }
        }
        if (!this.bExist) {
            b = 0;
            this.bGCount = 0;
        } else {
            this.bGCount = Math.round(0.5f + (float)(this.GC * b / (a + b)));
            if (this.bGCount > b) {
                this.bGCount = b;
            }
            if (!this.aExist && b > this.GC) {
                this.bGCount = this.GC;
            }
        }
        int s = this.aGCount + this.bGCount;
        boolean full = false;
        if (this.aExist && this.bExist) {
            while (s != this.GC && !full) {
                if (s < this.GC) {
                    if (this.aGCount < this.bGCount) {
                        if (this.aGCount + 1 <= a) {
                            ++this.aGCount;
                        } else if (this.bGCount + 1 <= b) {
                            ++this.bGCount;
                        } else {
                            full = true;
                        }
                    } else if (this.bGCount + 1 <= b) {
                        ++this.bGCount;
                    } else if (this.aGCount + 1 <= a) {
                        ++this.aGCount;
                    } else {
                        full = true;
                    }
                    ++s;
                    continue;
                }
                if (s <= this.GC) continue;
                if (this.aGCount > this.bGCount) {
                    --this.aGCount;
                } else {
                    --this.bGCount;
                }
                --s;
            }
        }
        if (this.bGCount != 0 && this.aGCount != 0) {
            this.zwitterIon = true;
        } else if (this.bGCount != 0) {
            this.bMolecule = true;
        } else if (this.aGCount != 0) {
            this.aMolecule = true;
        }
    }

    private void setMainBaseAtoms() {
        block3: {
            block2: {
                if (this.bGCount + this.aGCount >= this.GC) break block2;
                for (int k = 0; k < this.bGCount; ++k) {
                    this.gpKa[k] = this.BpKa[this.bCutIndex + k];
                    this.gAtoms[k] = this.bInd[this.bCutIndex + k];
                    this.ionType[this.gAtoms[k]] = 1;
                }
                break block3;
            }
            if (this.bGCount + this.aGCount != this.GC) break block3;
            for (int k = 0; k < this.bGCount; ++k) {
                this.gpKa[k] = this.BpKa[this.bCount - 1 - k];
                this.gAtoms[k] = this.bInd[this.bCount - 1 - k];
                this.ionType[this.gAtoms[k]] = 1;
            }
        }
    }

    private void setMainAcidAtoms() {
        block3: {
            block2: {
                if (this.bGCount + this.aGCount >= this.GC) break block2;
                int r = 0;
                for (int k = this.bGCount; k < this.bGCount + this.aGCount; ++k) {
                    this.gpKa[k] = this.ApKa[this.aCutIndex - r];
                    this.gAtoms[k] = this.aInd[this.aCutIndex - r];
                    this.ionType[this.gAtoms[k]] = -1;
                    ++r;
                }
                break block3;
            }
            if (this.bGCount + this.aGCount != this.GC) break block3;
            int r = 0;
            for (int k = this.bGCount; k < this.bGCount + this.aGCount; ++k) {
                this.gpKa[k] = this.ApKa[this.aCutIndex - r];
                this.gAtoms[k] = this.aInd[this.aCutIndex - r];
                this.ionType[this.gAtoms[k]] = -1;
                ++r;
            }
        }
    }

    private void calcGroupDistribution() {
        double[] mr = new double[this.gCount];
        double ln10 = 2.302585092994046;
        int argD = this.gOrd[0] - 1 < 0 ? 0 : this.gOrd[0] - 1;
        for (int i = 1; i < this.gCount; ++i) {
            int argN;
            int n = argN = this.gOrd[i] - 1 < 0 ? 0 : this.gOrd[i] - 1;
            double ratio = this.gOrd[i] == 0 ? -this.gdistMan[argD] : (this.gOrd[0] - 1 < 0 ? this.gdistMan[argN] : this.gdistMan[argN] - this.gdistMan[argD]);
            mr[this.gOrd[i]] = ratio;
        }
        double sum = 0.0;
        for (int i = 0; i < this.gCount; ++i) {
            sum += Math.pow(10.0, -mr[i]);
        }
        double c = 100.0 / sum;
        c = Math.log(c) / ln10;
        for (int i = 0; i < this.gCount; ++i) {
            this.gdist[i] = 100.0 * Math.pow(10.0, -mr[i]) / sum;
            this.gdistMan[i] = c - mr[i];
        }
    }

    private int getBaseGroupCharge(int gIndex) {
        int gCharge = 0;
        for (int i = 0; i < this.GC; ++i) {
            if (this.gInfo[gIndex][i] != 1) continue;
            ++gCharge;
        }
        return gCharge;
    }

    private int getAcidicGroupCharge(int gIndex) {
        int gCharge = 0;
        for (int i = 0; i < this.GC; ++i) {
            if (this.gInfo[gIndex][i] != -1) continue;
            ++gCharge;
        }
        return gCharge;
    }

    private void calcRatios() {
        int gIndex;
        this.gdist = new double[this.gCount];
        this.gdistMan = new double[this.gCount];
        this.gOrd = new int[this.gCount];
        for (gIndex = 0; gIndex < this.gCount; ++gIndex) {
            this.gOrd[gIndex] = gIndex;
        }
        for (gIndex = 1; gIndex < this.gCount; ++gIndex) {
            this.gdist[gIndex - 1] = this.calcGroupRatios(gIndex);
        }
        this.sortGroupRatios();
    }

    private void sortGroupRatios() {
        double ratio;
        int i;
        for (i = 0; i < this.gCount - 1; ++i) {
            ratio = this.gdistMan[i];
            if (!(ratio < 0.0)) continue;
            this.changeGroupRatioOrder(0, i + 1);
        }
        for (i = 0; i < this.gCount - 1; ++i) {
            for (int j = i + 1; j < this.gCount - 1; ++j) {
                ratio = this.gdistMan[j] - this.gdistMan[i];
                if (!(ratio < 0.0)) continue;
                this.changeGroupRatioOrder(i + 1, j + 1);
            }
        }
    }

    private void changeGroupRatioOrder(int ratioIndex1, int ratioIndex2) {
        int indexOf1 = 0;
        while (this.gOrd[indexOf1] != ratioIndex1) {
            ++indexOf1;
        }
        int indexOf2 = 0;
        while (this.gOrd[indexOf2] != ratioIndex2) {
            ++indexOf2;
        }
        if (indexOf2 - indexOf1 > 1) {
            int a = this.gOrd[indexOf2];
            int i = 0;
            while (indexOf2 - i > indexOf1) {
                this.gOrd[indexOf2 - i] = this.gOrd[indexOf2 - i - 1];
                ++i;
            }
            this.gOrd[indexOf1] = a;
        } else if (indexOf2 > indexOf1) {
            int a = this.gOrd[indexOf1];
            this.gOrd[indexOf1] = this.gOrd[indexOf2];
            this.gOrd[indexOf2] = a;
        }
    }

    private double calcGroupRatios(int ChildgIndex) {
        int lbp = this.getLargestGroupPos(ChildgIndex);
        int pg = this.getParentGroup(ChildgIndex, lbp);
        double ratio = pg == 0 ? 1.0 : this.gdist[pg - 1];
        double pKa = this.gMicropka[ChildgIndex - 1];
        if (this.gInfo[ChildgIndex][lbp] == 1) {
            ratio *= Math.pow(10.0, this.pH - pKa);
            int n = ChildgIndex - 1;
            this.gdistMan[n] = this.gdistMan[n] + (this.pH - pKa);
        } else if (this.gInfo[ChildgIndex][lbp] == -1) {
            ratio *= Math.pow(10.0, pKa - this.pH);
            int n = ChildgIndex - 1;
            this.gdistMan[n] = this.gdistMan[n] + (pKa - this.pH);
        }
        if (pg == 0) {
            int n = ChildgIndex - 1;
            this.gdistMan[n] = this.gdistMan[n] + 0.0;
        } else {
            int n = ChildgIndex - 1;
            this.gdistMan[n] = this.gdistMan[n] + this.gdistMan[pg - 1];
        }
        return ratio;
    }

    private int getParentGroup(int ChildGindex, int lbp) {
        int parentiL = this.gInfo[ChildGindex][this.GC] - 1;
        int c = 0;
        for (int gIndex = 0; gIndex < this.gCount; ++gIndex) {
            if (this.gInfo[gIndex][this.GC] == parentiL) {
                c = 0;
                for (int i = 0; i < this.GC; ++i) {
                    if (i == lbp || this.gInfo[gIndex][i] != this.gInfo[ChildGindex][i]) continue;
                    ++c;
                }
            }
            if (c != this.GC - 1) continue;
            return gIndex;
        }
        return 0;
    }

    public void recalcGroupDistribution(double newpH) {
        int i;
        int i2;
        for (i2 = 0; i2 < this.gCount; ++i2) {
            this.gOrd[i2] = i2;
        }
        for (i2 = 0; i2 < this.gCount; ++i2) {
            this.gdist[i2] = 0.0;
            this.gdistMan[i2] = 0.0;
        }
        int ab = 0;
        for (i = 1; i < this.gCount; ++i) {
            int lbp = this.getLargestGroupPos(i);
            int pg = this.getParentGroup(i, lbp);
            double ratio = pg == 0 ? 1.0 : this.gdist[pg - 1];
            double k = this.gMicropka[i - 1];
            ab = this.isBaseorAcid(i, lbp);
            if (ab == 1) {
                ratio *= Math.pow(10.0, newpH - k);
                int n = i - 1;
                this.gdistMan[n] = this.gdistMan[n] + (newpH - k);
            } else if (ab == -1) {
                ratio *= Math.pow(10.0, k - newpH);
                int n = i - 1;
                this.gdistMan[n] = this.gdistMan[n] + (k - newpH);
            }
            this.gdist[i - 1] = ratio;
            if (pg == 0) {
                int n = i - 1;
                this.gdistMan[n] = this.gdistMan[n] + 0.0;
                continue;
            }
            int n = i - 1;
            this.gdistMan[n] = this.gdistMan[n] + this.gdistMan[pg - 1];
        }
        for (i = 0; i < this.gCount - 1; ++i) {
            double ratio = this.gdistMan[i];
            if (!(ratio < 0.0)) continue;
            this.changeGroupRatioOrder(0, i + 1);
        }
        for (i = 0; i < this.gCount - 1; ++i) {
            for (int j = i + 1; j < this.gCount - 1; ++j) {
                double ratio = this.gdistMan[j] - this.gdistMan[i];
                if (!(ratio < 0.0)) continue;
                this.changeGroupRatioOrder(i + 1, j + 1);
            }
        }
        this.calcGroupDistribution();
    }

    private int isBaseorAcid(int ChildgIndex, int lbp) {
        if (this.gInfo[ChildgIndex][lbp] == 1) {
            return 1;
        }
        if (this.gInfo[ChildgIndex][lbp] == -1) {
            return -1;
        }
        return 0;
    }

    private void calcProteinMicropKa(Molecule prot) {
        int i;
        if (this.proteinStart) {
            this.pkalc = new IntrinsicIonization(prot);
            this.pkalc.setpKaModelType(1);
            if (this.createCenterInfo && !this.pkalc.getCriticalErrorFlag()) {
                this.ionizer = new Ionizer();
                this.ionizer.setCorrectionLibraryAbsolutePath(this.pKaDirectoryPath);
                this.ionizer.setCorrectionParameters();
                this.ionizer.setCenters(prot);
                this.correctionInfoAvailable = this.ionizer.isCenterInfoAvailable();
            }
        } else {
            this.pkalc.setMolecule(prot);
        }
        this.MOLATOMS = prot.getAtomCount();
        this.micropKaType = new int[this.MOLATOMS];
        this.microK = new double[this.MOLATOMS];
        this.secondMicropKa = new double[this.MOLATOMS];
        this.secondMicropKaType = new int[this.MOLATOMS];
        for (i = 0; i < this.MOLATOMS; ++i) {
            this.micropKaType[i] = -2;
            this.secondMicropKa[i] = Double.NaN;
            this.secondMicropKaType[i] = -2;
        }
        if (this.pkalc.getCriticalErrorFlag()) {
            return;
        }
        if (this.proteinStart) {
            this.getProteinMicropka(prot);
            this.storeInitMicropKa();
            this.pkalc.initGeneralHBondTable(this.microK);
            this.pkalc.storepk0(this.microK);
            this.pkalc.setHBondTable();
            this.getProteinMicropka(prot);
            this.proteinStart = false;
        } else {
            if (this.createCenterInfo && this.correctionInfoAvailable) {
                this.ionizer.setCorrectionLibraryAbsolutePath(this.pKaDirectoryPath);
                this.ionizer.setCenters(prot);
                for (i = 0; i < prot.getAtomCount(); ++i) {
                    this.pkalc.cyanoInc[i] = 0.0;
                }
                this.pkalc.setHBondTable();
            }
            this.getProteinMicropka(prot);
            this.pkalc.storepk0(this.microK);
        }
        this.CorrectSecMacpKa();
    }

    private void CorrectSecMacpKa() {
        for (int i = 0; i < this.MOLATOMS; ++i) {
            int n = i;
            this.secondMicropKa[n] = this.secondMicropKa[n] + this.pkalc.cyanoInc[i];
        }
    }

    private void storeInitMicropKa() {
        int i;
        int k = 0;
        for (i = 0; i < this.MOLATOMS; ++i) {
            if (this.pkalc.pkaAcidType[i][5] == 2) {
                if (this.pkalc.pkaAcidType[i][0] == 0) {
                    ++k;
                    continue;
                }
                if (this.pkalc.pkaAcidType[i][0] == 5) {
                    ++k;
                    continue;
                }
                if (this.pkalc.pkaAcidType[i][0] != 29) continue;
                ++k;
                continue;
            }
            if (this.pkalc.pkaBasicType[i][0] == 200) {
                ++k;
                continue;
            }
            if (this.pkalc.pkaAcidType[i][5] == 1) {
                if (this.pkalc.pkaAcidType[i][7] != 10) continue;
                ++k;
                continue;
            }
            if (this.pkalc.pkaAcidType[i][5] != 3 || this.pkalc.pkaAcidType[i][7] != 10) continue;
            ++k;
        }
        if (k != 0) {
            this.initNIndex = new int[k];
            this.initNpKa = new double[k];
            this.initNType = new int[k];
            k = 0;
            for (i = 0; i < this.MOLATOMS; ++i) {
                if (this.pkalc.pkaAcidType[i][5] == 2) {
                    if (this.pkalc.pkaAcidType[i][0] == 0) {
                        this.initNIndex[k] = i;
                        this.initNpKa[k] = this.microK[i];
                        this.initNType[k] = -1;
                        ++k;
                        continue;
                    }
                    if (this.pkalc.pkaAcidType[i][0] == 5) {
                        this.initNIndex[k] = i;
                        if (this.micropKaType[i] == -1) {
                            this.initNpKa[k] = this.microK[i];
                            this.initNType[k] = -1;
                        } else {
                            this.initNpKa[k] = this.secondMicropKa[i];
                            this.initNType[k] = 1;
                        }
                        ++k;
                        continue;
                    }
                    if (this.pkalc.pkaAcidType[i][0] != 29) continue;
                    this.initNIndex[k] = i;
                    if (this.micropKaType[i] == -1) {
                        this.initNpKa[k] = this.microK[i];
                        this.initNType[k] = -1;
                    } else {
                        this.initNpKa[k] = this.secondMicropKa[i];
                        this.initNType[k] = 1;
                    }
                    ++k;
                    continue;
                }
                if (this.pkalc.pkaBasicType[i][0] == 200) {
                    this.initNIndex[k] = i;
                    this.initNpKa[k] = this.microK[i];
                    this.initNType[k] = -1;
                    ++k;
                    continue;
                }
                if (this.pkalc.pkaAcidType[i][5] == 1) {
                    if (this.pkalc.pkaAcidType[i][7] != 10) continue;
                    this.initNIndex[k] = i;
                    this.initNpKa[k] = this.microK[i];
                    this.initNType[k] = -1;
                    ++k;
                    continue;
                }
                if (this.pkalc.pkaAcidType[i][5] != 3 || this.pkalc.pkaAcidType[i][7] != 10) continue;
                this.initNIndex[k] = i;
                this.initNpKa[k] = this.microK[i];
                this.initNType[k] = -1;
                ++k;
            }
        }
    }

    private boolean isSymmetric() {
        for (int i = 1; i < this.gCount - 1; ++i) {
            for (int j = i + 1; j < this.gCount; ++j) {
                int a2;
                int a1;
                if (!(Math.abs(this.gMicropka[i - 1] - this.gMicropka[j - 1]) < 1.0E-8) || (a1 = this.gInfo[j][this.GC]) != (a2 = this.gInfo[i][this.GC])) continue;
                return true;
            }
        }
        return false;
    }

    private void getProteinMicropka(Molecule prot) {
        double charge = 0.0;
        this.aCount = 0;
        this.bCount = 0;
        double[] corr = new double[2];
        int jj = 0;
        for (int i = 0; i < this.MOLATOMS; ++i) {
            double apka = Double.NaN;
            double bpka = Double.NaN;
            MolAtom a = prot.getAtom(i);
            charge = a.getCharge();
            if (charge == 0.0) {
                if (this.createCenterInfo && this.correctionInfoAvailable) {
                    corr = this.ionizer.getCenterCorrection(i);
                }
                apka = this.pkalc.getAcidicpKa(i) + corr[1];
                bpka = this.pkalc.getBasicpKa(i) + corr[0];
            }
            boolean acid = false;
            boolean base = false;
            if (Double.isNaN(bpka) && Double.isNaN(apka)) continue;
            if (!Double.isNaN(bpka) && !Double.isNaN(apka)) {
                if (2.0 * this.majpH - (bpka + apka) > 0.0) {
                    if (apka < 1.0E8) {
                        acid = true;
                        ++this.aCount;
                        this.secondMicropKa[i] = bpka;
                        this.secondMicropKaType[i] = 1;
                        ++this.bCount;
                    } else if (bpka > -1.0E8) {
                        base = true;
                        ++this.bCount;
                        this.secondMicropKa[i] = apka;
                        this.secondMicropKaType[i] = -1;
                        ++this.aCount;
                    }
                } else if (bpka > -1.0E8) {
                    base = true;
                    ++this.bCount;
                    this.secondMicropKa[i] = apka;
                    this.secondMicropKaType[i] = -1;
                    ++this.aCount;
                } else if (apka < 1.0E8) {
                    acid = true;
                    ++this.aCount;
                    this.secondMicropKa[i] = bpka;
                    this.secondMicropKaType[i] = 1;
                    ++this.bCount;
                }
            } else if (bpka > -1.0E8) {
                base = true;
                ++this.bCount;
            } else if (apka < 1.0E8) {
                acid = true;
                ++this.aCount;
            } else if (!Double.isNaN(bpka)) {
                this.pkalc.pkaBasicType[i][0] = -1;
            } else if (!Double.isNaN(apka)) {
                this.pkalc.pkaAcidType[i][0] = -1;
            }
            if (acid) {
                this.microK[i] = apka;
                this.micropKaType[i] = -1;
            } else if (base) {
                this.microK[i] = bpka;
                this.micropKaType[i] = 1;
            }
            jj = this.pkalc.pkaAtomIndex[i];
            this.pkalc.pKaType[jj] = this.micropKaType[i];
            this.correctAraN(i);
        }
    }

    private void correctAraN(int atom) {
        if (this.pkalc.deprotonation) {
            this.microK[atom] = this.getInitMpKa(atom);
            this.pkalc.deprotonation = false;
        }
        if (this.pkalc.protonation) {
            if (this.micropKaType[atom] == -1) {
                this.microK[atom] = this.getInitMpKa(atom);
            } else {
                this.secondMicropKa[atom] = this.getInitMpKa(atom);
            }
            this.pkalc.protonation = false;
        }
    }

    private double getInitMpKa(int atom) {
        for (int i = 0; i < this.initNIndex.length; ++i) {
            if (this.initNIndex[i] != atom) continue;
            return this.initNpKa[i];
        }
        return Double.NaN;
    }

    public int getMacropKaType(int atomIndex) {
        double b = this.gBMacropKa[atomIndex];
        double a = this.gAMacropKa[atomIndex];
        if (!Double.isNaN(b) && !Double.isNaN(a)) {
            if (2.0 * this.majpH - (a + b) > 0.0) {
                return -1;
            }
            return 1;
        }
        if (!Double.isNaN(b)) {
            return 1;
        }
        if (!Double.isNaN(a)) {
            return -1;
        }
        return -2;
    }

    public double getMacropKa(int atomIndex) {
        double b = this.gBMacropKa[atomIndex];
        double a = this.gAMacropKa[atomIndex];
        if (!Double.isNaN(b) && !Double.isNaN(a)) {
            if (2.0 * this.majpH - (a + b) > 0.0) {
                return a;
            }
            return b;
        }
        if (!Double.isNaN(b)) {
            return b;
        }
        if (!Double.isNaN(a)) {
            return a;
        }
        return Double.NaN;
    }

    public double[] getpKaSet(int atomIndex, int type) {
        double[] result = null;
        double[] K = new double[]{0.0, 0.0};
        K[0] = Double.NaN;
        K[1] = Double.NaN;
        int s = 0;
        int chg = 0;
        double apKa = this.getMacropKa(atomIndex, -1);
        double bpKa = this.getMacropKa(atomIndex, 1);
        if (this.pKaPrefixType == 2) {
            if (!Double.isNaN(apKa) || !Double.isNaN(bpKa)) {
                Molecule m = this.getMolecule();
                MolAtom a = m.getAtom(atomIndex);
                chg = a.getCharge();
                if (type == -1) {
                    if (chg > 0) {
                        if (!Double.isNaN(apKa)) {
                            K[0] = apKa;
                            ++s;
                            this.addTempCorrection(atomIndex, K[0]);
                            if (!Double.isNaN(bpKa)) {
                                K[1] = bpKa;
                                ++s;
                                this.addTempCorrection(atomIndex, K[1]);
                            }
                        }
                    } else if (chg == 0 && !Double.isNaN(apKa)) {
                        if (Double.isNaN(K[0])) {
                            K[0] = apKa;
                            ++s;
                            this.addTempCorrection(atomIndex, K[0]);
                        } else if (Double.isNaN(K[1])) {
                            K[1] = apKa;
                            ++s;
                            this.addTempCorrection(atomIndex, K[1]);
                        }
                    }
                } else if (type == 1) {
                    if (chg < 0) {
                        if (!Double.isNaN(apKa)) {
                            K[0] = apKa;
                            ++s;
                            this.addTempCorrection(atomIndex, K[0]);
                            if (!Double.isNaN(bpKa)) {
                                K[1] = bpKa;
                                ++s;
                                this.addTempCorrection(atomIndex, K[1]);
                            }
                        }
                    } else if (chg == 0 && !Double.isNaN(bpKa)) {
                        if (Double.isNaN(K[0])) {
                            K[0] = bpKa;
                            ++s;
                            this.addTempCorrection(atomIndex, K[0]);
                        } else if (Double.isNaN(K[1])) {
                            K[1] = bpKa;
                            ++s;
                            this.addTempCorrection(atomIndex, K[1]);
                        }
                    }
                }
            }
        } else if (this.pKaPrefixType == 1) {
            double p = this.getMacropKa(atomIndex, type);
            if (!Double.isNaN(p)) {
                result = new double[]{p};
            }
            return result;
        }
        if (Double.isNaN(K[0])) {
            return null;
        }
        result = new double[s];
        if (s == 1) {
            result[0] = K[0];
        } else if (s == 2) {
            result[0] = K[0];
            result[1] = K[1];
            if (chg > 0) {
                if (result[0] > result[1]) {
                    double c = result[0];
                    result[0] = result[1];
                    result[1] = c;
                }
            } else if (chg < 0 && result[0] < result[1]) {
                double b = result[0];
                result[0] = result[1];
                result[1] = b;
            }
        }
        return result;
    }

    public double getMacropKa(int atomIndex, int type) {
        if (type == 1) {
            if (!Double.isNaN(this.gBMacropKa[atomIndex]) && this.gBMacropKa[atomIndex] > this.BCUTOFF) {
                return this.gBMacropKa[atomIndex];
            }
        } else if (type == -1 && !Double.isNaN(this.gAMacropKa[atomIndex]) && this.gAMacropKa[atomIndex] < this.ACUTOFF) {
            return this.gAMacropKa[atomIndex];
        }
        return Double.NaN;
    }

    public double getStrongestAcidicMacropKa() {
        int m = this.gAMacropKa.length;
        double minApKa = 1.0E100;
        boolean exist = false;
        for (int i = 0; i < m; ++i) {
            if (Double.isNaN(this.gAMacropKa[i]) || !(this.gAMacropKa[i] < this.ACUTOFF) || !(this.gAMacropKa[i] < minApKa)) continue;
            minApKa = this.gAMacropKa[i];
            exist = true;
        }
        if (!exist) {
            minApKa = Double.NaN;
        }
        return minApKa;
    }

    private double getGroupMicropKa(int atomIndex, int type) {
        int type1 = this.getGrouppKaType(atomIndex);
        double pKa = Double.NaN;
        if (type1 != -2) {
            if (type == type1) {
                pKa = this.microK[atomIndex];
            } else if (!Double.isNaN(this.secondMicropKa[atomIndex])) {
                pKa = this.secondMicropKa[atomIndex];
            }
        }
        return this.addTempCorrection(atomIndex, pKa);
    }

    private int getGrouppKaType(int atomIndex) {
        return this.micropKaType[atomIndex];
    }

    private double addTempCorrection(int atomIndex, double micropKa) {
        double newpKa = micropKa;
        if (this.getGrouppKaType(atomIndex) == 1) {
            newpKa = 298.0 / this.temp * (micropKa - 0.9) + 0.9;
        } else if (this.getGrouppKaType(atomIndex) == -1) {
            newpKa = 298.0 / this.temp * (micropKa - 4.3) + 4.3;
        }
        return newpKa;
    }

    private void calcProteinGroups() {
        int bitPos;
        this.microSpec = new int[this.gCount];
        this.microSpecInfo = new int[this.GC + 1][3];
        int N = this.GC;
        int ionizationLevel = 1;
        int startMsIndex = 1;
        int finalMsIndex = 1;
        int[] parentInfo = new int[]{0, 0, 0};
        for (bitPos = 0; bitPos < N; ++bitPos) {
            this.setMsBit(bitPos, finalMsIndex);
            ++finalMsIndex;
        }
        this.setMsInfo(ionizationLevel, startMsIndex, finalMsIndex - 1);
        for (ionizationLevel = 2; ionizationLevel < N; ++ionizationLevel) {
            parentInfo = this.getProteinGroupInfo(ionizationLevel - 1);
            int parentCount = parentInfo[2] - parentInfo[1] + 1;
            for (int parent = 0; parent < parentCount; ++parent) {
                int parentMsIndex = parent + parentInfo[1];
                bitPos = this.getLargestBitPos(parentMsIndex);
                for (int i = bitPos + 1; i < N; ++i) {
                    this.copyParent(parentMsIndex, finalMsIndex);
                    this.setMsBit(i, finalMsIndex);
                    ++finalMsIndex;
                }
            }
            startMsIndex = parentInfo[2] + 1;
            this.setMsInfo(ionizationLevel, startMsIndex, finalMsIndex - 1);
        }
        this.microSpec[this.gCount - 1] = this.gCount - 1;
        this.setMsInfo(this.GC, finalMsIndex, finalMsIndex);
        this.microSpec[0] = 0;
        this.setMsInfo(0, 0, 0);
    }

    public int getProteinGroup(int gIndex) {
        return this.microSpec[gIndex];
    }

    public int[] getProteinGroupInfo(int ionizationLevel) {
        return this.microSpecInfo[ionizationLevel];
    }

    private void setMsBit(int bitPos, int MsIndex) {
        bitPos = (int)Math.pow(2.0, bitPos);
        this.microSpec[MsIndex] = this.microSpec[MsIndex] | bitPos;
    }

    private int getLargestBitPos(int globalMsIndex) {
        int i = 1;
        int mSpecies = this.microSpec[globalMsIndex];
        int bitCount = 0;
        int maxBitPos = 0;
        while (bitCount < this.GC) {
            maxBitPos = (mSpecies & i) == i ? bitCount : maxBitPos;
            ++bitCount;
            i = 2 * i;
        }
        return maxBitPos;
    }

    private void setMsInfo(int ionizationLevel, int fistIndex, int lastIndex) {
        this.microSpecInfo[ionizationLevel][0] = ionizationLevel;
        this.microSpecInfo[ionizationLevel][1] = fistIndex;
        this.microSpecInfo[ionizationLevel][2] = lastIndex;
    }

    private void copyParent(int parent, int child) {
        this.microSpec[child] = this.microSpec[parent];
    }

    public void calcMacropKa() {
        int hph;
        if (!this.pIcalc) {
            this.calcStatuspKa = 0.0;
            this.initProgressMonitor();
        }
        int m = this.protein.getAtomCount();
        this.gAMacropKa = new double[m];
        this.gBMacropKa = new double[m];
        this.pKaType = new int[m];
        this.mAcidicGCIndex = new int[m];
        this.mBasicGCIndex = new int[m];
        for (int i = 0; i < m; ++i) {
            this.gAMacropKa[i] = Double.NaN;
            this.gBMacropKa[i] = Double.NaN;
            this.pKaType[i] = -2;
        }
        int lph = (int)this.BCUTOFF;
        if (lph < -10) {
            lph = -10;
        }
        if ((hph = (int)this.ACUTOFF) > 60) {
            hph = 60;
        }
        if (this.majorMsCalc) {
            lph = (int)(this.majpH - 6.0);
            if (lph < -2) {
                lph = -2;
            }
            if ((hph = (int)(this.majpH + 6.0)) > 18) {
                hph = 18;
            }
        }
        if (this.pIcalc) {
            lph = -2;
            hph = 18;
        }
        CALCSTATUS_PKA_STEP = 100.0 / (double)(hph - lph);
        CALCSTATUS_PI_STEP = 100.0 / ((double)(hph - lph) + 6.0);
        for (int pp = lph; pp <= hph; ++pp) {
            this.zwitterIon = false;
            this.bMolecule = false;
            this.aMolecule = false;
            this.calcProteinIonization(pp);
            this.setIonizableAtoms();
            double ln10 = 2.302585092994046;
            double H = Math.pow(10.0, -this.pH);
            this.macropKa = new double[this.GC];
            for (int pKaInd = 1; pKaInd <= this.GC; ++pKaInd) {
                double N = 0.0;
                double D = 0.0;
                int lostP = 0;
                double maxN = -1.0E10;
                double maxD = -1.0E10;
                for (int gIndex = 0; gIndex < this.gCount; ++gIndex) {
                    int c;
                    if (this.zwitterIon) {
                        lostP = this.gInfo[gIndex][this.GC + 3];
                        if (lostP == pKaInd) {
                            if (this.gdistMan[gIndex] > maxN) {
                                maxN = this.gdistMan[gIndex];
                            }
                            N += this.gdist[gIndex];
                            continue;
                        }
                        if (lostP != pKaInd - 1) continue;
                        if (this.gdistMan[gIndex] > maxD) {
                            maxD = this.gdistMan[gIndex];
                        }
                        D += this.gdist[gIndex];
                        continue;
                    }
                    if (this.bMolecule) {
                        c = this.getBaseGroupCharge(gIndex);
                        if (c == pKaInd) {
                            if (this.gdistMan[gIndex] > maxD) {
                                maxD = this.gdistMan[gIndex];
                            }
                            D += this.gdist[gIndex];
                            continue;
                        }
                        if (c != pKaInd - 1) continue;
                        if (this.gdistMan[gIndex] > maxN) {
                            maxN = this.gdistMan[gIndex];
                        }
                        N += this.gdist[gIndex];
                        continue;
                    }
                    if (!this.aMolecule) continue;
                    c = this.getAcidicGroupCharge(gIndex);
                    if (c == pKaInd) {
                        if (this.gdistMan[gIndex] > maxN) {
                            maxN = this.gdistMan[gIndex];
                        }
                        N += this.gdist[gIndex];
                        continue;
                    }
                    if (c != pKaInd - 1) continue;
                    if (this.gdistMan[gIndex] > maxD) {
                        maxD = this.gdistMan[gIndex];
                    }
                    D += this.gdist[gIndex];
                }
                if (N == 0.0) {
                    N = maxN;
                    D = D == 0.0 ? maxD : Math.log(D) / ln10;
                    double t = Math.pow(10.0, N - D);
                    this.macropKa[pKaInd - 1] = -Math.log(H * t) / ln10;
                    continue;
                }
                this.macropKa[pKaInd - 1] = -Math.log(H * N / D) / ln10;
            }
            this.assignGroup();
            this.setTemporarlyIonState(m);
            this.calcStatuspKa += CALCSTATUS_PKA_STEP;
            this.calcStatuspI += CALCSTATUS_PI_STEP;
            this.setProgressValue(this.pIcalc ? this.calcStatuspI : this.calcStatuspKa);
        }
        this.acidpKaCount = 0;
        this.basepKaCount = 0;
        for (int i = 0; i < m; ++i) {
            if (!Double.isNaN(this.gAMacropKa[i])) {
                ++this.acidpKaCount;
            }
            if (Double.isNaN(this.gBMacropKa[i])) continue;
            ++this.basepKaCount;
        }
        this.calcStatuspKa = 100.0;
        if (!this.pIcalc) {
            this.setProgressValue(this.calcStatuspKa);
        }
    }

    public double[] getAcidicpKa() {
        return this.gAMacropKa;
    }

    public double[] getBasicpKa() {
        return this.gBMacropKa;
    }

    private void setTemporarlyIonState(int molAtoms) {
        for (int atom = 0; atom < molAtoms; ++atom) {
            if (this.pKaType[atom] == -1) {
                this.IonizeAcidicAtoms(atom);
                continue;
            }
            if (this.pKaType[atom] != 1) continue;
            this.IonizeBasicAtoms(atom);
        }
    }

    private void setIonizableAtoms() {
        int i;
        this.ionCount = 0;
        int[] n = new int[this.MOLATOMS];
        for (int gIndex = 0; gIndex < this.gCount; ++gIndex) {
            for (i = 0; i < this.GC; ++i) {
                if (this.gAtomInfo[gIndex][i] == -2) continue;
                n[this.gAtomInfo[gIndex][i]] = 1;
                if (this.gInfo[gIndex][i] == 1) {
                    this.pKaType[this.gAtomInfo[gIndex][i]] = 1;
                    continue;
                }
                if (this.gInfo[gIndex][i] != -1) continue;
                this.pKaType[this.gAtomInfo[gIndex][i]] = -1;
            }
        }
        for (int i2 = 0; i2 < this.MOLATOMS; ++i2) {
            if (n[i2] != 1) continue;
            ++this.ionCount;
        }
        this.ionizableAtoms = new int[this.ionCount];
        int k = 0;
        for (i = 0; i < this.MOLATOMS; ++i) {
            if (n[i] != 1) continue;
            this.ionizableAtoms[k] = i;
            ++k;
        }
    }

    private void assignGroup() {
        int i;
        int m = this.protein.getAtomCount();
        int mpKaCount = 0;
        double[] msdistSum = new double[m];
        boolean[] alreadyIonized = new boolean[m];
        this.macropKaAtoms = new int[this.GC];
        for (int i2 = 0; i2 < m; ++i2) {
            alreadyIonized[i2] = false;
        }
        if (this.symmetric) {
            this.TO = new double[this.gCount];
        }
        for (i = 0; i < this.GC; ++i) {
            if (Double.isNaN(this.macropKa[i])) continue;
            if (this.symmetric) {
                this.setDegIndex();
            }
            this.recalcGroupDistribution(this.macropKa[i]);
            double min = 1.0E10;
            for (int j = 0; j < this.ionCount; ++j) {
                int atomIndex = this.ionizableAtoms[j];
                for (int gIndex = 0; gIndex < this.gCount; ++gIndex) {
                    for (int k = 0; k < this.GC; ++k) {
                        if (this.gAtomInfo[gIndex][k] != atomIndex) continue;
                        if (this.symmetric) {
                            int n = atomIndex;
                            msdistSum[n] = msdistSum[n] + this.TO[gIndex] * this.gdist[gIndex];
                            continue;
                        }
                        int n = atomIndex;
                        msdistSum[n] = msdistSum[n] + this.gdist[gIndex];
                    }
                }
                msdistSum[atomIndex] = 50.0 - msdistSum[atomIndex];
                double d = Math.abs(msdistSum[atomIndex]);
                if (d < min && !alreadyIonized[atomIndex]) {
                    min = d;
                    this.macropKaAtoms[mpKaCount] = atomIndex;
                }
                msdistSum[atomIndex] = 0.0;
            }
            alreadyIonized[this.macropKaAtoms[mpKaCount]] = true;
            ++mpKaCount;
        }
        for (i = 0; i < this.GC; ++i) {
            if (this.pKaType[this.macropKaAtoms[i]] == -1) {
                this.gAMacropKa[this.macropKaAtoms[i]] = this.macropKa[i];
                this.mAcidicGCIndex[this.macropKaAtoms[i]] = this.GC;
                continue;
            }
            if (this.pKaType[this.macropKaAtoms[i]] != 1) continue;
            this.gBMacropKa[this.macropKaAtoms[i]] = this.macropKa[i];
            this.mBasicGCIndex[this.macropKaAtoms[i]] = this.GC;
        }
    }

    private void setDegIndex() {
        for (int k = 1; k < this.gCount; ++k) {
            this.TO[k] = this.gdist[k];
        }
        int fi = 1;
        int ms = 1;
        for (int i = 1; i < this.GC; ++i) {
            fi = fi * (this.GC + 1 - i) / i;
            for (int k = 0; k < fi; ++k) {
                int ams = k + ms;
                int d = 1;
                for (int j = k + 1; j < fi; ++j) {
                    int tms = j + ms;
                    if (!(Math.abs(this.TO[ams] - this.TO[tms]) < this.TOLERANCE) || !(this.TO[ams] > 0.0) || !(this.TO[tms] > 0.0) || !(this.TO[ams] > this.TOLERANCE && this.TO[tms] > this.TOLERANCE) && !(Math.abs(1.0 - this.TO[ams] / this.TO[tms]) < this.TOLERANCE)) continue;
                    this.TO[tms] = -1.0;
                    ++d;
                }
                this.TO[ams] = this.TO[ams] != -1.0 ? (double)d : 0.0;
            }
            ms += fi;
        }
        this.TO[0] = 1.0;
        this.TO[this.gCount - 1] = 1.0;
    }

    private void IonizeAcidicAtoms(int atom) {
        double charge = 0.0;
        double phShift = 0.0;
        phShift = this.zwitterIon ? 3.0 : 3.0;
        if (!Double.isNaN(this.gAMacropKa[atom])) {
            MolAtom a = this.protein.getAtom(atom);
            charge = a.getCharge();
            if (this.gAMacropKa[atom] < this.pH - phShift) {
                a = this.protein.getAtom(atom);
                if (charge != -1.0) {
                    this.removeHydrogen(a);
                }
            } else {
                a = this.protein.getAtom(atom);
                if (charge == -1.0) {
                    this.neutralizeAnion(a);
                }
            }
        }
    }

    private void IonizeBasicAtoms(int atom) {
        double charge = 0.0;
        double phShift = 0.0;
        phShift = this.zwitterIon ? 3.0 : 3.0;
        if (!Double.isNaN(this.gBMacropKa[atom])) {
            MolAtom a = this.protein.getAtom(atom);
            charge = a.getCharge();
            if (this.gBMacropKa[atom] > this.pH + phShift) {
                a = this.protein.getAtom(atom);
                if (charge != 1.0) {
                    this.addHydrogen(a);
                }
            } else {
                a = this.protein.getAtom(atom);
                if (charge == 1.0) {
                    this.neutralizeCation(a);
                }
            }
        }
    }

    public int getMacroSpeciesCount() {
        return this.acidpKaCount + this.basepKaCount + 1;
    }

    public double[][] getMacroSpeciesDistribution() {
        return this.X;
    }

    public double[] getMacroSpeciesDistribution(int msIndex) {
        return this.X[msIndex];
    }

    private void setMacroSpeciesCharge() {
        int n = this.acidpKaCount + this.basepKaCount;
        this.macroSpecCharge = new int[n + 1];
        int q = 0;
        for (int i = n; i >= 0; --i) {
            this.macroSpecCharge[i] = this.basepKaCount - q;
            ++q;
        }
    }

    public int[] getMacroSpeciesCharge() {
        return this.macroSpecCharge;
    }

    public int getMacroSpeciesCharge(int msIndex) {
        return this.macroSpecCharge[msIndex];
    }

    public void calcMacroSpeciesDistribution() {
        int k;
        int i;
        this.setpHInfo();
        this.setMacroSpeciesCharge();
        int c = this.acidpKaCount + this.basepKaCount;
        double[] mpKa = new double[c];
        int[] mpKaInd = new int[c];
        int[] mpKaType = new int[c];
        int m = this.gAMacropKa.length;
        int z = 0;
        for (i = 0; i < m; ++i) {
            if (Double.isNaN(this.gAMacropKa[i])) continue;
            mpKa[z] = this.gAMacropKa[i];
            mpKaInd[z] = i;
            mpKaType[z] = -1;
            ++z;
        }
        for (i = 0; i < m; ++i) {
            if (Double.isNaN(this.gBMacropKa[i])) continue;
            mpKa[z] = this.gBMacropKa[i];
            mpKaInd[z] = i;
            mpKaType[z] = 1;
            ++z;
        }
        for (int i2 = 0; i2 < c - 1; ++i2) {
            k = i2;
            double p = mpKa[i2];
            int ind1 = mpKaInd[i2];
            int ind2 = mpKaType[i2];
            for (int j = i2 + 1; j < c; ++j) {
                if (!(mpKa[j] <= p)) continue;
                k = j;
                p = mpKa[j];
                ind1 = mpKaInd[j];
                ind2 = mpKaType[j];
            }
            if (k == i2) continue;
            mpKa[k] = mpKa[i2];
            mpKa[i2] = p;
            mpKaInd[k] = mpKaInd[i2];
            mpKaInd[i2] = ind1;
            mpKaType[k] = mpKaType[i2];
            mpKaType[i2] = ind2;
        }
        int n = c;
        this.X = new double[n + 1][this.pHStepCount + 1];
        double[][] Rx = new double[n + 1][this.pHStepCount + 1];
        for (int phStep = 0; phStep <= this.pHStepCount; ++phStep) {
            int i3;
            double logX0;
            this.X[0][phStep] = logX0 = 2.0;
            for (int i4 = 1; i4 <= n; ++i4) {
                double r;
                double sumpKa = 0.0;
                double sumpH = (double)i4 * this.pHPoints[phStep];
                for (int j = n - 1; j >= n - i4; --j) {
                    sumpKa += mpKa[j];
                }
                this.X[i4][phStep] = r = logX0 - sumpH + sumpKa;
            }
            double sum = 0.0;
            for (k = 0; k <= n; ++k) {
                sum = 0.0;
                for (i3 = 0; i3 <= n; ++i3) {
                    double y = this.X[k][phStep] - this.X[i3][phStep];
                    if (y > 80.0) {
                        sum += 0.0;
                        continue;
                    }
                    if (!(y > -80.0)) continue;
                    sum += Math.pow(10.0, -y);
                }
                Rx[k][phStep] = 100.0 / sum;
            }
            for (i3 = 0; i3 <= n; ++i3) {
                this.X[i3][phStep] = Rx[i3][phStep];
            }
        }
    }

    public void calcChargepHDist() {
        int i;
        this.calcMacropKa();
        this.setpHInfo();
        int c = this.acidpKaCount + this.basepKaCount;
        double[] mpKa = new double[c];
        int[] mpKaType = new int[c];
        int m = this.gAMacropKa.length;
        int z = 0;
        for (i = 0; i < m; ++i) {
            if (Double.isNaN(this.gAMacropKa[i])) continue;
            mpKa[z] = this.gAMacropKa[i];
            mpKaType[z] = -1;
            ++z;
        }
        for (i = 0; i < m; ++i) {
            if (Double.isNaN(this.gBMacropKa[i])) continue;
            mpKa[z] = this.gBMacropKa[i];
            mpKaType[z] = 1;
            ++z;
        }
        this.calcStatuspI = 90.0;
        this.setProgressValue(this.calcStatuspI);
        int n = c;
        for (int y = 0; y <= this.pHStepCount; ++y) {
            double chg = 0.0;
            double ph = Math.pow(10.0, -this.pHPoints[y]);
            for (int i2 = 0; i2 < n; ++i2) {
                double s;
                double pka;
                if (mpKaType[i2] == -1) {
                    pka = Math.pow(10.0, -mpKa[i2]);
                    s = pka / ph;
                    chg += -s / (1.0 + s);
                    continue;
                }
                if (mpKaType[i2] != 1) continue;
                pka = Math.pow(10.0, -mpKa[i2]);
                s = ph / pka;
                chg += s / (1.0 + s);
            }
            this.pHCharge[y] = chg + (double)this.fpchg;
        }
        this.calcStatuspI = 97.0;
        this.setProgressValue(this.calcStatuspI);
    }

    public Molecule getMajorMicroSpecies(double pH, Molecule mol) {
        int i;
        this.majpH = pH;
        Molecule mainMSp = mol.cloneMoleculeWithDocument();
        this.majorMsCalc = true;
        this.neutralize(mainMSp);
        this.setMolecule(mainMSp);
        this.pHLower = this.pHUpper = pH;
        this.pHStepSize = 1.0;
        this.calcChargepHDist();
        int m = this.gAMacropKa.length;
        int[] ionAtoms = new int[m];
        for (i = 0; i < m; ++i) {
            if (Double.isNaN(this.gAMacropKa[i]) || !(pH > this.gAMacropKa[i])) continue;
            ionAtoms[i] = -1;
        }
        for (i = 0; i < m; ++i) {
            if (Double.isNaN(this.gBMacropKa[i]) || !(pH < this.gBMacropKa[i] + 0.3)) continue;
            ionAtoms[i] = 1;
        }
        for (int i2 = 0; i2 < m; ++i2) {
            if (ionAtoms[i2] == 1) {
                MolAtom a = mainMSp.getAtom(i2);
                this.addHydrogen(a);
                continue;
            }
            if (ionAtoms[i2] != -1) continue;
            MolAtom a = mainMSp.getAtom(i2);
            this.removeHydrogen(a);
        }
        this.majorMsCalc = false;
        return mainMSp;
    }

    public double[] getChargepHDistribution() {
        return this.pHCharge;
    }

    public double[] getpHPoints() {
        return this.pHPoints;
    }

    public void calcIsoelectricPoint() {
        this.pIcalc = true;
        this.calcStatuspI = 0.0;
        this.initProgressMonitor();
        this.calcChargepHDist();
        double pI = Double.NaN;
        if (this.pkalc.getCriticalErrorFlag()) {
            return;
        }
        for (int phStep = 0; phStep < this.pHStepCount; ++phStep) {
            double b;
            double m;
            if (this.pHCharge[phStep] > 0.0 && this.pHCharge[phStep + 1] < 0.0) {
                m = (this.pHCharge[phStep] - this.pHCharge[phStep + 1]) / (this.pHPoints[phStep] - this.pHPoints[phStep + 1]);
                b = this.pHCharge[phStep] - m * this.pHPoints[phStep];
                pI = -b / m;
                continue;
            }
            if (!(this.pHCharge[phStep] < 0.0) || !(this.pHCharge[phStep + 1] > 0.0)) continue;
            m = (this.pHCharge[phStep] - this.pHCharge[phStep + 1]) / (this.pHPoints[phStep] - this.pHPoints[phStep + 1]);
            b = this.pHCharge[phStep] - m * this.pHPoints[phStep];
            pI = -b / m;
        }
        this.setpI(pI);
        this.calcStatuspI = 100.0;
        this.setProgressValue(this.calcStatuspI);
        this.pIcalc = false;
    }

    private void setpI(double pi) {
        this.isoPoint = pi;
    }

    public double getpI() {
        return this.isoPoint;
    }

    public double getCalcStatuspKa() {
        return this.calcStatuspKa;
    }

    public double getCalcStatuspI() {
        return this.calcStatuspI;
    }

    private void initProgressMonitor() {
        if (this.progressMonitor != null) {
            this.progressMonitor = this.progressMonitor.newInstance();
            this.progressMonitor.initProgressMonitor("calculation in progress ...", 0, 100);
        }
        this.setProgressValue(0.0);
    }

    private void setProgressValue(double value) {
        if (this.progressMonitor != null) {
            this.progressMonitor.setProgressValue((int)value);
        }
    }
}

