/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.calculations.pka;

import chemaxon.calculations.pka.IntrinsicIonization;
import chemaxon.struc.MolAtom;
import chemaxon.struc.Molecule;

class pKaCentrumType {
    static final String[] PKACENTERS_OH_ACID = new String[]{"OH-ACID,ROH", "OH-ACID,PHENOL,HETERO RING", "OH-ACID,PHENOL", "OH-ACID,BENZOIC ACID,HETERO RING", "OH-ACID,BENZOIC ACID", "OH-ACID,AR-S(=O)(OH)", "OH-ACID,AR-P(=O)(OH)", "OH-ACID,AR-C(=S)(OH)", "OH-ACID,Ar_S(=O)(=O)OH", "OH-ACID,PHENYL-VINIL ALCOHOL", "OH-ACID,ALIPHATIC CARBOXYLIC ACID", "OH-ACID,ALIPHATIC SULPHINIC AICD , R_S(=O)OH", "OH-ACID,ALIPHATIC DIPHOSPHONIC AICD ESTER", "OH-ACID,ALIPHATIC PHOSPHINIC AICD , R_P(=O)OH", "OH-ACID,ALIPHATIC THIOCARBOXILIC AICD , R_C(=S)OH", "OH-ACID,ALIPHATIC SULPHONIC AICD , R_S(=O)(=O)OH", "OH-ACID,ALIPHATI VINIL ALCOHOL, in-DELOCABLE RING", "OH-ACID,ALIPHATIC VINIL ALCOHOL, in-RING", "OH-ACID,ALIPHATIC VINIL ALCOHOL", "OH-ACID,AROMATIC PEROXIDE, AR-OOH", "OH-ACID,ALIPHATIC PEROXIDE, R-OOH", "OH-ACID,a-VINIL CARBOXYLIC ACID, X=Y-COOH", "OH-ACID,AROMATIC di-ARSENIC ACID, Ar_As(=O)(OH)2", "OH-ACID,ALIPHATIC di-ARSENIC ACID, R_As(=O)(OH)2", "OH-ACID,AROMATIC ARSENIC ACID, Ar(R)As(=O)(OH)", "OH-ACID,ALIPHATIC ARSENIC ACID, (R2)As(=O)(OH)", "OH-ACID,NITRONIC ACID,HNO3", "OH-ACID,NITRONIC ACID,HNO2", "OH-ACID,ALIPHATIC HYDROXAMIC ACID,RCONHOH", "OH-ACID,AROMATIC HYDROXAMIC ACID,AR_NH(OH)COR", "OH-ACID,GLYOXIM,R=N-OH", "OH-ACID,WATER,H2O", "OH-ACID,CARBON ACID,H2CO3", "OH-ACID,AROMATIC BORIC ACID,ArB(OH)2", "OH-ACID, BORIC ACID,H2BO3", "OH-ACID, AROMATIC SULPHONIC ACID,Ar-S(=X)(=O)-OH", "OH-ACID, AROMATIC HALO ACID,Ar_Hal(=O)OH", "OH-ACID, ALIPHATIC HALO ACID,R_Hal(=O)OH", "OH-ACID, PROTONATED AROMATIC NITROACID (I),Ar_N(+)(=S)(OH)", "OH-ACID, PROTONATED AROMATIC NITROACID (II) ,Ar_N(+)(=O)(OH)", "OH-ACID, PROTONATED ALIPHATIC NITROACID,R-N(+)(=O)(OH)", "OH-ACID,  NITRONIC ACID ,R=N(=O)OH ", "OH-ACID,OXIM,Ar-=N-OH"};
    static final String[] PKACENTERS_O_BASIC = new String[]{"O-BASIC,PYRIDINE N-OXIDE", "O-BASIC,H2O", "O-BASIC,ROH", "O-BASIC,PHENYL-OH", "O-BASIC,R1-O-R2", "O-BASIC,PHENYL-O-PHENYL", "O-BASIC,ESTER", "O-BASIC,R-N=O", "O-BASIC,PHENYL-N-N=O", "O-BASIC,PHENYL-N=O", "O-BASIC,R-NO2", "O-BASIC,PHENYL-NO2", "O-BASIC,R-C=O(+H),alpha deloc.", "O-BASIC,R-C=O(+H)", "O-BASIC,R-COOH", "O-BASIC,H-bonded keto", "O-BASIC,R-NHC=O(+H)NH", "O-BASIC,Ph-NHC=O(+H)NH", "O-BASIC,Ph-NHC=O(+H)", "O-BASIC,R-NHC=O(+H)", "O-BASIC,R-NHC=O(+H) in semi aromatic ring"};
    static final String[] PKACENTERS_N_BASIC = new String[]{"N-BASIC,IMIDAZOLE", "N-BASIC,PYRROLE", "N-BASIC,COVALENT-HYDRATION TYPE PYRIDINE", "N-BASIC,QUINOLINE TYPE PYRIDINE", "N-BASIC,PYRIDINE", "N-BASIC,ACCRIDINE TYPE PYRIDINE", "N-BASIC,ANILINE,ARNH2", "N-BASIC,ANILINE,ARNHR", "N-BASIC,ANILINE,ARNR2", "N-BASIC, ArNCOR", "N-BASIC,RCONHR", "N-BASIC,Guanidine", "N-BASIC,Ar-Guanidine", "N-BASIC,hetero-Ar-Guanidine", "N-BASIC,Amidine", "N-BASIC,Ar-amidine, Ar-N=CNR", "N-BASIC,Ar-amidine, Ar-N=CNR,N is in deloc. ring", "N-BASIC,Ar-amidine,hetero_Ar-N=-NR", "N-BASIC,amidine,RN=-NHCOR", "N-BASIC,PRIMER ALIPHATIC AMINE", "N-BASIC,SECUNDER ALIPHATIC AMINE", "N-BASIC,TERTIER ALIPHATIC AMINE", "N-BASIC,R=NH", "N-BASIC,PRIMER ALIPHATIC,AMIDINE TYPE", "N-BASIC,SECUNDER ALIPHATIC,AMIDINE TYPE", "N-BASIC,TERTIER ALIPHATIC,AMIDINE TYPE", "N-BASIC,R=N-X", "N-BASIC, Ar-N=-=R", "N-BASIC, Ar-N=-R", "N-BASIC,amidine,R-N=-NH-C(=O)", "N-BASIC,amidine in deloc.ring,R-N=-NH-C(=O)"};
    static final String[] PKACENTERS_NH_ACID = new String[]{"NH-ACID,RNH", "NH-ACID,Pyrrole NH", "NH-ACID,hetero(Ar)NHR ", "NH-ACID,ArNHR", "NH-ACID,RCONHR", "NH-ACID,ArNHCOR", "NH-ACID, ArNH in pyridone ring", "NH-ACID, NH in semi aromatic ring", "NH-ACID, ArNH in aliphatic keto ring", "NH-ACID, R=NH", "NH-ACID, R=NH", "NH-ACID, R=x-NH", "NH-ACID, R=x-NH-x=R", "NH-ACID, R-NH", "NH-ACID, ARSO2NHCO_R", "NH-ACID, ARSO2NHSO2R", "NH-ACID, ARSO2NHCO_R, in deloc.ring", "NH-ACID, ARSO2NHCO_R, in hetro deloc.ring", "NH-ACID, ARSO2NHCO_R, in deloc.ring", "NH-ACID, Barbita like", "NH-ACID, ARSO2NH-R", "NH-ACID, Ar-NH-Ar", "NH-ACID,Ar-C(=O)NH-R, in pol.ring", "NH-ACID,Ar-C(=O)NH-R, in semi ara ring", "NH-ACID,Ar-C(=O)NH-R", "NH-ACID,(hetero)Ar-NHSO2-R", "NH-ACID,Ar-NHSO2-R", "NH-ACID,Ar-X-C(=O)NH-R, X=0,N,S", "NH-ACID, R-C(=O)NH-C(=O)-R,in no.pol.ring", "NH-ACID, R-C(=O)NH-C(=O)-R,in deloc, ring", "NH-ACID, R-C(=O)NH-C(=O)-R,hydantoin like", "NH-ACID,R-C(=O)NHC=N-R,in deloc.ring", "NH-ACID,R-C(=O)NH-C(=O)-R", "NH-ACID, Ar-C(=O)-NH-C(=O)-R,(6 mem.semi-Ara)-Ara", "NH-ACID, Ar-C(=O)-NH-C(=O)-R,(5 mem.semi-Ara)-Ara", "NH-ACID, Ar-C(=O)-NH-C(=O)-R", "NH-ACID,R-C(=O)-NH-C=C-R  in pol.ring", "NH-ACID,R=N-NH-C(=S)  in semiaromatic ring", "NH-ACID,R-C(=O)-NH-C=C-R  in cond.deloc.ring", "NH-ACID,R-C(=O)-NH-C=C-R  in semiaromatic ring", "NH-ACID,R-C(=S)-NH-X=  open chine", "NH-ACID,RCONH-C=CR, RCSNH-C=CR", "NH-ACID,RCONHOR", "NH-ACID,R-SO2NH-R"};
    static final String[] PKACENTERS_CH_ACID = new String[]{"CH-ACID, RCHN(+)=O", "CH-ACID, RCH(NO2)", "CH-ACID, RCHN", "CH-ACID, ArCHN", "CH-ACID, RCH(NO2)x", "CH-ACID, aromatic CYCLOPENTADIENIL-anion type", "CH-ACID, antiaromatic CYCLOALKENE type", "CH-ACID, ArCHCOR", "CH-ACID, RCOCHR in semi aromatic ring", "CH-ACID, RCOCHR in delocable ring", "CH-ACID, RCOCHR", "CH-ACID, ArCOCHR", "CH-ACID, RCOOR", "CH-ACID, RCOCH2COR", "CH-ACID, Ar-CH-C=N", "CH-ACID, Ar-CH-C=O", "CH-ACID, GAMMA KETO CH-C=C-C=O", "CH-ACID, RNHCO-CH-R, in semi ara ring", "CH-ACID, RNHCO-CH-R, in delocable ring", "CH-ACID, RCH-N(+)N, DIAZONIUM CATION", "CH-ACID, R-CH2-R", "CH-ACID, Ar-CH2-Ar", "CH-ACID, X-CH2-R", "CH-ACID, Ar-CH2-R", "CH-ACID, RCH=S, Aldehyde CH in aromatic ring", "CH-ACID, RCH=S", "CH-ACID, RCH=S, Aldehyde CH in deloc.ring", "CH-ACID, RCHC=O", "CH-ACID, RCHC=O, Aldehyde CH in aromatic ring", "CH-ACID, RCHC=O, Aldehyde CH in deloc.ring", "CH-ACID, RCH-C=N", "CH-ACID, D-CH-CN", "CH-ACID, D2-CH-CN", "CH-ACID, XD-CH-CN", "CH-ACID, R-CH", "CH-ACID, R-CH=CH2", "CH-ACID, PYR(+) YLIDE", "CH-ACID, N(+)R4 YLIDE", "CH-ACID, =O(+)-R YLIDE", "CH-ACID, SR3(+) YLIDE", "CH-ACID, O=SR3(+) YLIDE", "CH-ACID, PR4(+)-C(-) YLIDE", "CH-ACID, AsR4(+)-C(-) YLIDE", "CH-ACID, Ph-NCO-CH-NCO-Ph, in semi ara ring", "CH-ACID, Ph-NCO-CH-NCO-Ph, in delocable ring", "CH-ACID, Ph-NCO-CH-NCO-R, in delocable ring", "CH-ACID, Ph-NCO-CH-NCO-Ph, in semi ara ring", "CH-ACID, RNHCO-CH-CONHR, in delocable ring", "CH-ACID, RNHCO-CH-CONHR, in semi ara ring", "CH-ACID, RNHCO-CH-CONHR", "CH-ACID, ArCHCOOR", "CH-ACID, ArCHCOOR in semi aromatic ring", "CH-ACID, ArCHCOOR in delocable ring"};
    static final String[] PKACENTERS_P_BASIC = new String[]{"P-BASIC,PH3", "P-BASIC,RPH2", "P-BASIC,PR3", "P-BASIC,PHENYL-PHOSPHINE"};
    static final String[] PKACENTERS_S_BASIC = new String[]{"S-BASIC,PYRIDINE N-THIOXIDE", "S-BASIC,H2S", "S-BASIC,RSH", "S-BASIC,PHENYL-SH", "S-BASIC,R1-S-R2", "S-BASIC,PHENYL-S-PHENYL", "S-BASIC,ESTER", "S-BASIC,R-N=S", "S-BASIC,PHENYL-N-N=S", "S-BASIC,PHENYL-N=S", "S-BASIC,R-NS2", "S-BASIC,PHENYL-NS2", "S-BASIC,R-C=SH", "S-BASIC,R-CSOH", "S-BASIC,R-NHC=S(+H)NH", "S-BASIC,Ph-NHC=S(+H)NH", "S-BASIC,Ph-NHC=S(+H)", "S-BASIC,R-NHC=S(+H)", "S-BASIC,R-NHC=S(+H) in semi aromatic ring"};
    static final String[] PKACENTERS_C_BASIC = new String[]{"C-BASIC,Pyrrolle ring"};
    static final String[] PKACENTERS_SH_ACID = new String[]{"SH-ACID,RSH", "SH-ACID,THIOPHENOL, in HETERO AROMATIC RING", "SH-ACID,THIOPHENOL", "SH-ACID,THIOBENZOIC ACID,AR_C(=O)SH,in HETERO RING", "SH-ACID,THIOBENZOIC ACID,AR_C(=O)SH", "SH-ACID,di-THIOBENZOIC ACID,AR_C(=S)SH,in HETERO RING", "SH-ACID,di-THIOBENZOIC ACID,AR_C(=S)SH", "SH-ACID,ALIPHATIC THIOCARBOXYLIC ACID,R_C(=O)SH", "SH-ACID,ALIPHATIC di-THIOCARBOXYLIC ACID,R_C(=S)SH", "SH-ACID,ALIPHATIC THIO ACID ,R_X(=O)SH", "SH-ACID, THIO ACID ,X(=O)SH", "SH-ACID,ALIPHATIC VINIL THIOALCOHOL, in-DELOCABLE RING", "SH-ACID,ALIPHATIC VINIL THIOALCOHOL, in-RING", "SH-ACID,ALIPHATIC VINIL THIOALCOHOL", "SH-ACID, H2S", "SH-ACID, H2SO3"};
    static final String[] PKACENTERS_XH_ACID = new String[]{"XH-ACID, HF", "XH-ACID, HCl", "XH-ACID, HBr", "XH-ACID, HI"};
    protected IntrinsicIonization pkalc;
    protected Molecule mol = null;
    protected Molecule molCopy = null;
    protected String[] centerType;
    protected int[] centerIndex;
    protected int atomCount;
    private int centerCount;

    pKaCentrumType() {
    }

    protected int getCenterCount() {
        return this.centerCount;
    }

    protected void calcpKaCenters() {
        this.pkalc = new IntrinsicIonization(this.mol, false);
        this.pkalc.setBasicAtoms();
        this.pkalc.setAcidTypes();
        this.atomCount = this.mol.getAtomCount();
        int cc = 0;
        this.centerCount = this.countCenterTypes();
        this.centerType = new String[this.centerCount];
        this.centerIndex = new int[this.centerCount];
        for (int i = 0; i < this.atomCount; ++i) {
            int aType;
            int baseType = this.pkalc.pkaBasicType[i][0];
            if (baseType >= 0) {
                MolAtom a = this.mol.getAtom(i);
                this.centerIndex[cc] = i;
                int pc = a.getAtno();
                if (pc == 7) {
                    this.setAminBasicCenter(i, cc);
                    ++cc;
                } else if (pc == 15) {
                    this.setPhosporBasicCenter(i, cc);
                    ++cc;
                } else if (pc == 8) {
                    this.setOxigenBasicCenter(i, cc);
                    ++cc;
                } else if (pc == 16) {
                    this.setSulfurBasicCenter(i, cc);
                    ++cc;
                } else if (pc == 6) {
                    this.setCarbonBasicCenter(i, cc);
                    ++cc;
                }
            }
            if ((aType = this.pkalc.pkaAcidType[i][5]) == -1) continue;
            this.centerIndex[cc] = i;
            if (aType == 2) {
                this.setAminAcidicCenter(i, cc);
                ++cc;
                continue;
            }
            if (aType == 1) {
                this.setOxigenAcidicCenter(i, cc);
                ++cc;
                continue;
            }
            if (aType == 3) {
                this.setSulfurAcidicCenter(i, cc);
                ++cc;
                continue;
            }
            if (aType == 4) {
                this.setCarbonAcidicCenter(i, cc);
                ++cc;
                continue;
            }
            if (aType != 5) continue;
            this.setHaloAcidicCenter(i, cc);
            ++cc;
        }
    }

    private int countCenterTypes() {
        int centerCount = 0;
        for (int i = 0; i < this.atomCount; ++i) {
            if (this.pkalc.pkaBasicType[i][0] >= 0) {
                ++centerCount;
            }
            if (this.pkalc.pkaAcidType[i][5] == -1) continue;
            ++centerCount;
        }
        return centerCount;
    }

    private void setAminBasicCenter(int a, int idx) {
        int type = this.pkalc.pkaBasicType[a][0];
        int stype = this.pkalc.pkaBasicType[a][1];
        int aminOrder = this.pkalc.pkaBasicType[a][3];
        int agDel = this.pkalc.pkaBasicType[a][10];
        this.centerType[idx] = "NOT AVAILABLE";
        if (type == 200) {
            this.centerType[idx] = "N-BASIC,IMIDAZOLE";
        } else if (type == 250) {
            this.centerType[idx] = "N-BASIC,PYRROLE";
        } else if (type == 500) {
            this.centerType[idx] = stype == 125 ? "N-BASIC,COVALENT-HYDRATION TYPE PYRIDINE" : (stype == 122 ? "N-BASIC,QUINOLINE TYPE PYRIDINE" : "N-BASIC,PYRIDINE");
        } else if (type == 600) {
            this.centerType[idx] = "N-BASIC,ACCRIDINE TYPE PYRIDINE";
        } else if (type == 1) {
            if (aminOrder == 1) {
                this.centerType[idx] = "N-BASIC,ANILINE,ARNH2";
            } else if (aminOrder == 2) {
                this.centerType[idx] = "N-BASIC,ANILINE,ARNHR";
            } else if (aminOrder == 3) {
                this.centerType[idx] = "N-BASIC,ANILINE,ARNR2";
            } else if (aminOrder == 4) {
                if (stype == 902) {
                    this.centerType[idx] = "N-BASIC, Ar-N=-=R";
                } else if (stype == 903) {
                    this.centerType[idx] = "N-BASIC, Ar-N=-R";
                }
            }
        } else if (type == 0) {
            this.centerType[idx] = "N-BASIC, ArNCOR";
        } else if (type == 2) {
            this.centerType[idx] = "N-BASIC,RCONHR";
        } else if (type == 3) {
            if (stype == 1) {
                this.centerType[idx] = "N-BASIC,Guanidine";
            } else if (stype == 12) {
                this.centerType[idx] = "N-BASIC,Ar-Guanidine";
            } else if (stype == 14) {
                this.centerType[idx] = "N-BASIC,hetero-Ar-Guanidine";
            } else if (stype == 2) {
                this.centerType[idx] = "N-BASIC,Amidine";
            } else if (stype == 120) {
                this.centerType[idx] = "N-BASIC,Ar-amidine, Ar-N=CNR";
            } else if (stype == 121) {
                this.centerType[idx] = "N-BASIC,Ar-amidine, Ar-N=CNR,N is in deloc. ring";
            } else if (stype == 122) {
                this.centerType[idx] = "N-BASIC,Ar-amidine,hetero_Ar-N=-NR";
            } else if (stype == 22) {
                this.centerType[idx] = "N-BASIC,amidine,RN=-NHCOR";
            } else if (stype == 51) {
                this.centerType[idx] = "N-BASIC,amidine,R-N=-NH-C(=O)";
            } else if (stype == 75) {
                this.centerType[idx] = "N-BASIC,amidine in deloc.ring,R-N=-NH-C(=O)";
            }
        } else if (type == 1000) {
            boolean s = false;
            if (agDel == 31 || agDel == 32) {
                s = true;
            }
            if (aminOrder == 1) {
                this.centerType[idx] = s ? "N-BASIC,PRIMER ALIPHATIC,AMIDINE TYPE" : "N-BASIC,PRIMER ALIPHATIC AMINE";
            } else if (aminOrder == 2) {
                if (s) {
                    this.centerType[idx] = "N-BASIC,SECUNDER ALIPHATIC,AMIDINE TYPE";
                }
                this.centerType[idx] = "N-BASIC,SECUNDER ALIPHATIC AMINE";
            } else if (aminOrder == 3) {
                if (s) {
                    this.centerType[idx] = "N-BASIC,TERTIER ALIPHATIC,AMIDINE TYPE";
                }
                this.centerType[idx] = "N-BASIC,TERTIER ALIPHATIC AMINE";
            }
        } else if (type == 5) {
            this.centerType[idx] = stype == 111 ? "N-BASIC,R=N-X" : "N-BASIC,R=NH";
        }
    }

    private void setPhosporBasicCenter(int a, int idx) {
        int type = this.pkalc.pkaBasicType[a][0];
        int stype = this.pkalc.pkaBasicType[a][1];
        int order = this.pkalc.pkaBasicType[a][3];
        this.centerType[idx] = "NOT AVAILABLE";
        if (type == 2000) {
            if (order == 1) {
                this.centerType[idx] = "P-BASIC,PH3";
            } else if (order == 2) {
                this.centerType[idx] = "P-BASIC,RPH2";
            } else if (order == 3) {
                this.centerType[idx] = "P-BASIC,PR3";
            }
        } else if (type == 1 && stype < 900) {
            this.centerType[idx] = "P-BASIC,PHENYL-PHOSPHINE";
        }
    }

    private void setOxigenBasicCenter(int a, int idx) {
        int type = this.pkalc.pkaBasicType[a][0];
        int stype = this.pkalc.pkaBasicType[a][1];
        this.centerType[idx] = "NOT AVAILABLE";
        if (type == 2000) {
            this.centerType[idx] = "O-BASIC,PYRIDINE N-OXIDE";
        } else if (type == 2500) {
            this.centerType[idx] = stype == 100 ? "O-BASIC,H2O" : "O-BASIC,ROH";
        } else if (type == 2600) {
            this.centerType[idx] = "O-BASIC,PHENYL-OH";
        } else if (type == 2700) {
            this.centerType[idx] = "O-BASIC,R1-O-R2";
        } else if (type == 2800) {
            this.centerType[idx] = "O-BASIC,PHENYL-O-PHENYL";
        } else if (type == 2900) {
            this.centerType[idx] = "O-BASIC,ESTER";
        } else if (type == 3000) {
            this.centerType[idx] = "O-BASIC,R-N=O";
        } else if (type == 4000) {
            this.centerType[idx] = stype == 100 ? "O-BASIC,PHENYL-N-N=O" : "O-BASIC,PHENYL-N=O";
        } else if (type == 4100) {
            this.centerType[idx] = "O-BASIC,R-NO2";
        } else if (type == 4200) {
            this.centerType[idx] = "O-BASIC,PHENYL-NO2";
        } else if (type == 4300) {
            this.centerType[idx] = stype == 300 ? "O-BASIC,R-C=O(+H),alpha deloc." : (stype == 415 ? "O-BASIC,H-bonded keto" : "O-BASIC,R-C=O(+H)");
        } else if (type == 4350) {
            if (stype == 100) {
                this.centerType[idx] = "O-BASIC,R-NHC=O(+H)NH";
            } else if (stype == 150) {
                this.centerType[idx] = "O-BASIC,Ph-NHC=O(+H)NH";
            } else if (stype == 175) {
                this.centerType[idx] = "O-BASIC,Ph-NHC=O(+H)";
            } else if (stype == 200) {
                this.centerType[idx] = "O-BASIC,R-NHC=O(+H)";
            } else if (stype == 220) {
                this.centerType[idx] = "O-BASIC,R-NHC=O(+H) in semi aromatic ring";
            }
        } else if (type == 4400) {
            this.centerType[idx] = "O-BASIC,R-COOH";
        }
    }

    private void setSulfurBasicCenter(int a, int idx) {
        int type = this.pkalc.pkaBasicType[a][0];
        int stype = this.pkalc.pkaBasicType[a][1];
        this.centerType[idx] = "NOT AVAILABLE";
        if (type == 2000) {
            this.centerType[idx] = "S-BASIC,PYRIDINE N-THIOXIDE";
        } else if (type == 2500) {
            this.centerType[idx] = stype == 100 ? "S-BASIC,H2S" : "S-BASIC,RSH";
        } else if (type == 2600) {
            this.centerType[idx] = "S-BASIC,PHENYL-SH";
        } else if (type == 2700) {
            this.centerType[idx] = "S-BASIC,R1-S-R2";
        } else if (type == 2800) {
            this.centerType[idx] = "S-BASIC,PHENYL-S-PHENYL";
        } else if (type == 2900) {
            this.centerType[idx] = "S-BASIC,ESTER";
        } else if (type == 3000) {
            this.centerType[idx] = "S-BASIC,R-N=S";
        } else if (type == 4000) {
            this.centerType[idx] = stype == 100 ? "S-BASIC,PHENYL-N-N=S" : "S-BASIC,PHENYL-N=S";
        } else if (type == 4100) {
            this.centerType[idx] = "S-BASIC,R-NS2";
        } else if (type == 4200) {
            this.centerType[idx] = "S-BASIC,PHENYL-NS2";
        } else if (type == 4300) {
            this.centerType[idx] = "S-BASIC,R-C=SH";
        } else if (type == 4400) {
            this.centerType[idx] = "S-BASIC,R-CSOH";
        } else if (type == 4350) {
            if (stype == 100) {
                this.centerType[idx] = "S-BASIC,R-NHC=S(+H)NH";
            } else if (stype == 150) {
                this.centerType[idx] = "S-BASIC,Ph-NHC=S(+H)NH";
            } else if (stype == 175) {
                this.centerType[idx] = "S-BASIC,Ph-NHC=S(+H)";
            } else if (stype == 200) {
                this.centerType[idx] = "S-BASIC,R-NHC=S(+H)";
            } else if (stype == 220) {
                this.centerType[idx] = "S-BASIC,R-NHC=S(+H) in semi aromatic ring";
            }
        }
    }

    private void setCarbonBasicCenter(int a, int idx) {
        int type = this.pkalc.pkaAcidType[a][0];
        this.centerType[idx] = "NOT AVAILABLE";
        if (type == 250) {
            this.centerType[idx] = "C-BASIC,Pyrrolle ring";
        }
    }

    private void setAminAcidicCenter(int a, int idx) {
        int type = this.pkalc.pkaAcidType[a][0];
        int stype = this.pkalc.pkaAcidType[a][7];
        this.centerType[idx] = "NOT AVAILABLE";
        if (type < 0) {
            if (type != -1 && type == -2) {
                this.centerType[idx] = "NH-ACID,RNH";
            }
        } else if (type == 0) {
            this.centerType[idx] = "NH-ACID,Pyrrole NH";
        } else if (type == 2) {
            this.centerType[idx] = stype == 10 ? "NH-ACID,(hetero)Ar-NHSO2-R" : "NH-ACID,Ar-NHSO2-R";
        } else if (type == 4) {
            this.centerType[idx] = "NH-ACID,ArNHCOR";
        } else if (type == 5) {
            this.centerType[idx] = "NH-ACID, Ar-NH-Ar";
        } else if (type == 6) {
            this.centerType[idx] = stype == 10 ? "NH-ACID,hetero(Ar)NHR " : "NH-ACID,ArNHR";
        } else if (type == 7) {
            this.centerType[idx] = stype == 100 ? "NH-ACID, ARSO2NHCO_R, in deloc.ring" : (stype == 20 ? "NH-ACID, ARSO2NHCO_R, in hetro deloc.ring" : (stype == 10 ? "NH-ACID, ARSO2NHCO_R, in deloc.ring" : "NH-ACID, ARSO2NHCO_R"));
        } else if (type == 8) {
            this.centerType[idx] = "NH-ACID, ARSO2NHSO2R";
        } else if (type == 9) {
            this.centerType[idx] = "NH-ACID, ARSO2NH-R";
        } else if (type == 11) {
            this.centerType[idx] = stype == 80 ? "NH-ACID, Ar-C(=O)-NH-C(=O)-R,(6 mem.semi-Ara)-Ara" : (stype == 70 ? "NH-ACID, Ar-C(=O)-NH-C(=O)-R,(5 mem.semi-Ara)-Ara" : "NH-ACID, Ar-C(=O)-NH-C(=O)-R");
        } else if (type == 12) {
            this.centerType[idx] = stype == 100 ? "NH-ACID,Ar-C(=O)NH-R, in pol.ring" : (stype == 200 ? "NH-ACID,Ar-C(=O)NH-R, in semi ara ring" : "NH-ACID,Ar-C(=O)NH-R");
        } else if (type == 15) {
            this.centerType[idx] = "NH-ACID,R-SO2NH-R";
        } else if (type == 16) {
            this.centerType[idx] = stype == 200 ? "NH-ACID, Barbita like" : (stype == 600 ? "NH-ACID, R-C(=O)NH-C(=O)-R,in no.pol.ring" : (stype == 100 ? "NH-ACID, R-C(=O)NH-C(=O)-R,in deloc, ring" : (stype == 300 ? "NH-ACID, R-C(=O)NH-C(=O)-R,hydantoin like" : (stype == 500 ? "NH-ACID,R-C(=O)NHC=N-R,in deloc.ring" : "NH-ACID,R-C(=O)NH-C(=O)-R"))));
        } else if (type == 17) {
            this.centerType[idx] = "NH-ACID,RCONHR";
        } else if (type == 21) {
            this.centerType[idx] = "NH-ACID,RCONHOR";
        } else if (type == 24) {
            this.centerType[idx] = "NH-ACID,Ar-X-C(=O)NH-R, X=0,N,S";
        } else if (type == 26) {
            this.centerType[idx] = stype == 100 ? "NH-ACID,R-C(=O)-NH-C=C-R  in pol.ring" : (stype == 125 ? "NH-ACID,R=N-NH-C(=S)  in semiaromatic ring" : (stype == 200 ? "NH-ACID,R-C(=O)-NH-C=C-R  in cond.deloc.ring" : (stype == 120 ? "NH-ACID,R-C(=O)-NH-C=C-R  in semiaromatic ring" : (stype == 300 ? "NH-ACID,R-C(=S)-NH-X=  open chine" : "NH-ACID,RCONH-C=CR, RCSNH-C=CR"))));
        } else if (type == 28) {
            this.centerType[idx] = "NH-ACID, ArNH in pyridone ring";
        } else if (type == 29) {
            this.centerType[idx] = "NH-ACID, NH in semi aromatic ring";
        } else if (type == 280) {
            this.centerType[idx] = "NH-ACID, ArNH in aliphatic keto ring";
        } else if (type == 33) {
            this.centerType[idx] = stype == 1 ? "NH-ACID, R=NH" : "NH-ACID, R=NH";
        } else if (type == 30 || type == 31 || type == 32) {
            this.centerType[idx] = stype == 20 ? "NH-ACID, R=x-NH" : (stype == 25 ? "NH-ACID, R=x-NH-x=R" : "NH-ACID, R-NH");
        }
    }

    private void setOxigenAcidicCenter(int a, int idx) {
        int type = this.pkalc.pkaAcidType[a][0];
        int stype = this.pkalc.pkaAcidType[a][7];
        this.centerType[idx] = "NOT AVAILABLE";
        if (type < 0) {
            if (type != -1 && type == -2) {
                this.centerType[idx] = "OH-ACID,ROH";
            }
        } else if (type == 0) {
            this.centerType[idx] = stype == 10 ? "OH-ACID,PHENOL,HETERO RING" : "OH-ACID,PHENOL";
        } else if (type == 1) {
            this.centerType[idx] = stype == 10 || stype == 20 || stype == 30 ? "OH-ACID,BENZOIC ACID,HETERO RING" : "OH-ACID,BENZOIC ACID";
        } else if (type == 2) {
            this.centerType[idx] = "OH-ACID,AR-S(=O)(OH)";
        } else if (type == 3) {
            this.centerType[idx] = "OH-ACID,AR-P(=O)(OH)";
        } else if (type == 4) {
            this.centerType[idx] = "OH-ACID,AR-C(=S)(OH)";
        } else if (type == 5) {
            this.centerType[idx] = "OH-ACID,Ar_S(=O)(=O)OH";
        } else if (type == 6) {
            this.centerType[idx] = "OH-ACID,PHENYL-VINIL ALCOHOL";
        } else if (type == 8) {
            this.centerType[idx] = "OH-ACID,ALIPHATIC CARBOXYLIC ACID";
        } else if (type == 9) {
            this.centerType[idx] = "OH-ACID,ALIPHATIC SULPHINIC AICD , R_S(=O)OH";
        } else if (type == 10) {
            this.centerType[idx] = stype == 11 ? "OH-ACID,ALIPHATIC DIPHOSPHONIC AICD ESTER" : "OH-ACID,ALIPHATIC PHOSPHINIC AICD , R_P(=O)OH";
        } else if (type == 11) {
            this.centerType[idx] = "OH-ACID,ALIPHATIC THIOCARBOXILIC AICD , R_C(=S)OH";
        } else if (type == 12) {
            this.centerType[idx] = "OH-ACID,ALIPHATIC SULPHONIC AICD , R_S(=O)(=O)OH";
        } else if (type == 13) {
            this.centerType[idx] = stype == 1 ? "OH-ACID,ALIPHATI VINIL ALCOHOL, in-DELOCABLE RING" : (stype == 2 ? "OH-ACID,ALIPHATIC VINIL ALCOHOL, in-RING" : "OH-ACID,ALIPHATIC VINIL ALCOHOL");
        } else if (type == 14) {
            this.centerType[idx] = "OH-ACID,AROMATIC PEROXIDE, AR-OOH";
        } else if (type == 7) {
            this.centerType[idx] = "OH-ACID,ALIPHATIC PEROXIDE, R-OOH";
        } else if (type == 15) {
            this.centerType[idx] = "OH-ACID,a-VINIL CARBOXYLIC ACID, X=Y-COOH";
        } else if (type == 16) {
            this.centerType[idx] = "OH-ACID,AROMATIC di-ARSENIC ACID, Ar_As(=O)(OH)2";
        } else if (type == 17) {
            this.centerType[idx] = "OH-ACID,ALIPHATIC di-ARSENIC ACID, R_As(=O)(OH)2";
        } else if (type == 18) {
            this.centerType[idx] = "OH-ACID,AROMATIC ARSENIC ACID, Ar(R)As(=O)(OH)";
        } else if (type == 19) {
            this.centerType[idx] = "OH-ACID,ALIPHATIC ARSENIC ACID, (R2)As(=O)(OH)";
        } else if (type == 20) {
            this.centerType[idx] = "OH-ACID,NITRONIC ACID,HNO3";
        } else if (type == 21) {
            this.centerType[idx] = "OH-ACID,NITRONIC ACID,HNO2";
        } else if (type == 22) {
            this.centerType[idx] = "OH-ACID,ALIPHATIC HYDROXAMIC ACID,RCONHOH";
        } else if (type == 23) {
            this.centerType[idx] = "OH-ACID,AROMATIC HYDROXAMIC ACID,AR_NH(OH)COR";
        } else if (type == 24) {
            this.centerType[idx] = "OH-ACID,GLYOXIM,R=N-OH";
        } else if (type == 25) {
            this.centerType[idx] = "OH-ACID,WATER,H2O";
        } else if (type == 26) {
            this.centerType[idx] = "OH-ACID,CARBON ACID,H2CO3";
        } else if (type == 27) {
            this.centerType[idx] = "OH-ACID,AROMATIC BORIC ACID,ArB(OH)2";
        } else if (type == 28) {
            this.centerType[idx] = "OH-ACID, BORIC ACID,H2BO3";
        } else if (type == 29) {
            this.centerType[idx] = "OH-ACID, AROMATIC SULPHONIC ACID,Ar-S(=X)(=O)-OH";
        } else if (type == 30) {
            this.centerType[idx] = "OH-ACID, AROMATIC HALO ACID,Ar_Hal(=O)OH";
        } else if (type == 31) {
            this.centerType[idx] = "OH-ACID, ALIPHATIC HALO ACID,R_Hal(=O)OH";
        } else if (type == 32) {
            this.centerType[idx] = "OH-ACID, PROTONATED AROMATIC NITROACID (I),Ar_N(+)(=S)(OH)";
        } else if (type == 33) {
            this.centerType[idx] = "OH-ACID, PROTONATED AROMATIC NITROACID (II) ,Ar_N(+)(=O)(OH)";
        } else if (type == 34) {
            this.centerType[idx] = "OH-ACID, PROTONATED ALIPHATIC NITROACID,R-N(+)(=O)(OH)";
        } else if (type == 35) {
            this.centerType[idx] = "OH-ACID,  NITRONIC ACID ,R=N(=O)OH ";
        } else if (type == 39) {
            this.centerType[idx] = "OH-ACID,OXIM,Ar-=N-OH";
        }
    }

    private void setSulfurAcidicCenter(int a, int idx) {
        int type = this.pkalc.pkaAcidType[a][0];
        int stype = this.pkalc.pkaAcidType[a][7];
        this.centerType[idx] = "NOT AVAILABLE";
        if (type < 0) {
            if (type != -1 && type == -2) {
                this.centerType[idx] = "SH-ACID,RSH";
            }
        } else if (type == 0) {
            this.centerType[idx] = stype == 10 ? "SH-ACID,THIOPHENOL, in HETERO AROMATIC RING" : "SH-ACID,THIOPHENOL";
        } else if (type == 1) {
            this.centerType[idx] = stype == 10 ? "SH-ACID,THIOBENZOIC ACID,AR_C(=O)SH,in HETERO RING" : "SH-ACID,THIOBENZOIC ACID,AR_C(=O)SH";
        } else if (type == 4) {
            this.centerType[idx] = stype == 10 ? "SH-ACID,di-THIOBENZOIC ACID,AR_C(=S)SH,in HETERO RING" : "SH-ACID,di-THIOBENZOIC ACID,AR_C(=S)SH";
        } else if (type == 8) {
            this.centerType[idx] = "SH-ACID,ALIPHATIC THIOCARBOXYLIC ACID,R_C(=O)SH";
        } else if (type == 11) {
            this.centerType[idx] = "SH-ACID,ALIPHATIC di-THIOCARBOXYLIC ACID,R_C(=S)SH";
        } else if (type == 10 || type == 9) {
            this.centerType[idx] = "SH-ACID,ALIPHATIC THIO ACID ,R_X(=O)SH";
        } else if (type == 21) {
            this.centerType[idx] = "SH-ACID, THIO ACID ,X(=O)SH";
        } else if (type == 13) {
            this.centerType[idx] = stype == 1 ? "SH-ACID,ALIPHATIC VINIL THIOALCOHOL, in-DELOCABLE RING" : (stype == 2 ? "SH-ACID,ALIPHATIC VINIL THIOALCOHOL, in-RING" : "SH-ACID,ALIPHATIC VINIL THIOALCOHOL");
        } else if (type == 25) {
            this.centerType[idx] = "SH-ACID, H2S";
        } else if (type == 26) {
            this.centerType[idx] = "SH-ACID, H2SO3";
        }
    }

    private void setCarbonAcidicCenter(int a, int idx) {
        int type = this.pkalc.pkaAcidType[a][0];
        int stype = this.pkalc.pkaAcidType[a][7];
        int ketoType = this.pkalc.pkaAcidType[a][9];
        this.centerType[idx] = "NOT AVAILABLE";
        if (type == 1) {
            this.centerType[idx] = stype == 10 ? "CH-ACID, RCHN(+)=O" : "CH-ACID, RCH(NO2)";
        } else if (type == 3) {
            this.centerType[idx] = stype == 1 || stype == 4 ? "CH-ACID, D-CH-CN" : (stype == 2 || stype == 3 ? "CH-ACID, D2-CH-CN" : (stype == 5 ? "CH-ACID, XD-CH-CN" : "CH-ACID, RCHN"));
        } else if (type == 4) {
            this.centerType[idx] = "CH-ACID, ArCHN";
        } else if (type == 11) {
            this.centerType[idx] = "CH-ACID, RCH(NO2)x";
        } else if (type == 120) {
            this.centerType[idx] = stype == 1 || stype == 2 || stype == 3 ? "CH-ACID, aromatic CYCLOPENTADIENIL-anion type" : "CH-ACID, antiaromatic CYCLOALKENE type";
        } else if (type == 65) {
            if (stype == 80) {
                this.centerType[idx] = "CH-ACID, ArCHCOR";
            }
        } else if (type == 67) {
            this.centerType[idx] = stype == 16 ? "CH-ACID, RCOCHR in semi aromatic ring" : (stype == 15 ? "CH-ACID, RCOCHR in delocable ring" : "CH-ACID, RCOCHR");
        } else if (type == 650) {
            this.centerType[idx] = "CH-ACID, ArCOCHR";
        } else if (type == 68) {
            this.centerType[idx] = stype == 16 ? "CH-ACID, ArCHCOOR in semi aromatic ring" : (stype == 15 ? "CH-ACID, ArCHCOOR in delocable ring" : "CH-ACID, ArCHCOOR");
        } else if (type == 69) {
            this.centerType[idx] = "CH-ACID, RCOOR";
        } else if (type == 100) {
            this.centerType[idx] = "CH-ACID, RCOCH2COR";
        } else if (type == 71) {
            this.centerType[idx] = ketoType == 5 ? "CH-ACID, Ar-CH-C=N" : "CH-ACID, Ar-CH-C=O";
        } else if (type == 70) {
            String s = "";
            if (stype == 15) {
                s = ", Aldehyde CH in deloc.ring";
            } else if (stype == 16) {
                s = ", Aldehyde CH in aromatic ring";
            }
            if (ketoType == 1) {
                this.centerType[idx] = "CH-ACID, RCH=S" + s;
            } else if (ketoType == 2) {
                this.centerType[idx] = "CH-ACID, RCH=Se" + s;
            } else if (ketoType == 3) {
                this.centerType[idx] = "CH-ACID, RCS=O" + s;
            } else if (ketoType == 4) {
                this.centerType[idx] = "CH-ACID, RCHX=O" + s;
            }
            this.centerType[idx] = ketoType == 5 ? "CH-ACID, RCH-C=N" + s : "CH-ACID, RCHC=O" + s;
        } else if (type == 705) {
            this.centerType[idx] = "CH-ACID, GAMMA KETO CH-C=C-C=O";
        } else if (type == 101) {
            if (stype == 16) {
                this.centerType[idx] = "CH-ACID, RNHCO-CH-R, in semi ara ring";
            } else if (stype == 15) {
                this.centerType[idx] = "CH-ACID, RNHCO-CH-R, in delocable ring";
            } else if (stype == 222) {
                this.centerType[idx] = "CH-ACID, Ph-NCO-CH-NCO-Ph, in semi ara ring";
            } else if (stype == 22) {
                this.centerType[idx] = "CH-ACID, Ph-NCO-CH-NCO-Ph, in delocable ring";
            } else if (stype == 21) {
                this.centerType[idx] = "CH-ACID, Ph-NCO-CH-NCO-R, in delocable ring";
            } else if (stype == 211) {
                this.centerType[idx] = "CH-ACID, Ph-NCO-CH-NCO-Ph, in semi ara ring";
            } else if (stype == 23) {
                this.centerType[idx] = "CH-ACID, RNHCO-CH-CONHR, in delocable ring";
            } else if (stype == 233) {
                this.centerType[idx] = "CH-ACID, RNHCO-CH-CONHR, in semi ara ring";
            } else if (stype == 20) {
                this.centerType[idx] = "CH-ACID, RNHCO-CH-CONHR";
            }
        } else if (type == 510) {
            this.centerType[idx] = "CH-ACID, RCH-N(+)N, DIAZONIUM CATION";
        } else if (type == 520) {
            if (stype == 30) {
                this.centerType[idx] = "CH-ACID, R-CH2-R";
            } else if (stype == 5) {
                this.centerType[idx] = "CH-ACID, Ar-CH2-Ar";
            } else if (stype == 20) {
                int L = this.pkalc.cHtab[a].length;
                this.centerType[idx] = L == 2 ? "CH-ACID, R-CH" : (L == 3 ? "CH-ACID, R-CH=CH2" : "CH-ACID, X-CH2-R");
            } else if (stype == 10) {
                this.centerType[idx] = "CH-ACID, Ar-CH2-R";
            }
        } else if (type == 522) {
            int ylide = this.pkalc.pkaAcidType[a][3];
            if (ylide == 15) {
                this.centerType[idx] = "CH-ACID, PYR(+) YLIDE";
            } else if (ylide == 10) {
                this.centerType[idx] = "CH-ACID, N(+)R4 YLIDE";
            } else if (ylide == 25) {
                this.centerType[idx] = "CH-ACID, =O(+)-R YLIDE";
            } else if (ylide == 30) {
                this.centerType[idx] = "CH-ACID, SR3(+) YLIDE";
            } else if (ylide == 35) {
                this.centerType[idx] = "CH-ACID, O=SR3(+) YLIDE";
            } else if (ylide == 40) {
                this.centerType[idx] = "CH-ACID, PR4(+)-C(-) YLIDE";
            } else if (ylide == 45) {
                this.centerType[idx] = "CH-ACID, AsR4(+)-C(-) YLIDE";
            }
        }
    }

    private void setHaloAcidicCenter(int a, int idx) {
        int type = this.pkalc.pkaAcidType[a][0];
        this.centerType[idx] = "NOT AVAILABLE";
        if (type == 1) {
            this.centerType[idx] = "XH-ACID, HF";
        } else if (type == 2) {
            this.centerType[idx] = "XH-ACID, HCl";
        } else if (type == 3) {
            this.centerType[idx] = "XH-ACID, HBr";
        } else if (type == 4) {
            this.centerType[idx] = "XH-ACID, HI";
        }
    }
}

