/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.calculations.pka;

import chemaxon.calculations.pka.pKaCentrumType;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;

class pKaParameters
extends pKaCentrumType {
    String[][] pType;
    int[] pTypeCount;
    int cc;
    private int[] centSaraIdx;
    private int[] centLaraIdx;
    private int[] centGroupDist;
    private int[] sAraRingIndx;
    private int[] lAraRingIndx;
    private boolean Sres;
    private boolean Lres;
    private boolean araSub;
    private int centGCorr;
    private int subLi;
    private int gAtom;
    private String actChargeState;
    private String resPathState;
    private int[][] di;
    private boolean theSameRing;
    private int ionizableAtomCount = 0;
    private int[] ioAtoms;
    private int[] alkylC;

    pKaParameters(Molecule m) {
        this.mol = m;
        this.molCopy = m.cloneMoleculeWithDocument();
    }

    void setIonizableAtoms(int ioc, int[] io) {
        this.ionizableAtomCount = ioc;
        this.ioAtoms = io;
    }

    void createpKaParamters() {
        int i;
        this.calcpKaCenters();
        this.cc = this.getCenterCount();
        this.pType = new String[this.cc][40];
        this.pTypeCount = new int[this.cc];
        this.sAraRingIndx = new int[this.atomCount];
        this.lAraRingIndx = new int[this.atomCount];
        for (i = 0; i < this.atomCount; ++i) {
            this.lAraRingIndx[i] = -1;
            this.sAraRingIndx[i] = -1;
            if (!this.pkalc.isArA(i)) continue;
            this.sAraRingIndx[i] = this.pkalc.charge.getRings().findSmallestAraRing(i);
            this.lAraRingIndx[i] = this.pkalc.charge.getRings().getLargestAraRingIndex(i);
        }
        this.alkylC = new int[this.atomCount];
        this.setAlkylCarbon();
        if (this.ionizableAtomCount != 0) {
            for (i = 0; i < this.cc; ++i) {
                int ai = this.centerIndex[i];
                if (!this.isIonizableAtom(ai)) continue;
                this.setFGroupParameters(ai, i);
            }
        } else {
            for (i = 0; i < this.cc; ++i) {
                int ai = this.centerIndex[i];
                this.setFGroupParameters(ai, i);
            }
        }
    }

    private boolean isIonizableAtom(int ai) {
        for (int i = 0; i < this.ionizableAtomCount; ++i) {
            if (this.ioAtoms[i] != ai) continue;
            return true;
        }
        return false;
    }

    private void printpKaParameters() {
        for (int i = 0; i < this.cc; ++i) {
            System.err.println("================================CENTRUM==================================== ");
            System.err.println("/ ");
            System.err.println("/ " + this.centerIndex[i] + "   " + this.centerType[i]);
            System.err.println("/ ");
            System.err.println("=========================================================================== ");
            System.err.println("CENTRUM PARAMETERS ");
            int j = 0;
            while (!this.pType[i][j].equals("END")) {
                System.err.println(this.pType[i][j]);
                ++j;
            }
        }
    }

    private boolean isCommonAliRing(int ridx, int ai) {
        if (ridx == -1) {
            return false;
        }
        return this.pkalc.isTheSameRing(ridx, ai);
    }

    private boolean isCommonAraRing(int centRi, int sub) {
        if (centRi == -1) {
            return false;
        }
        if (!this.pkalc.isArA(sub)) {
            return false;
        }
        return this.pkalc.isTheSameAraRing(centRi, sub);
    }

    private void setFGroupParameters(int ai, int cIdx) {
        boolean minArADist3 = false;
        boolean minArADist4 = false;
        boolean minArADist2 = false;
        int sarc = this.pkalc.charge.getSemiAromaticRingCount();
        int arc = this.pkalc.charge.getARingNum();
        boolean[] usedGroup = new boolean[this.pkalc.getPolarGroups().getGCount()];
        int[] usedAring = new int[sarc + arc];
        int ri = -1;
        for (int i = 0; i < this.pkalc.getPolarGroups().getGCount(); ++i) {
            usedGroup[i] = false;
        }
        int gai = this.pkalc.getPolarGroups().getGroupIndex()[ai];
        if (gai != -1) {
            usedGroup[gai] = true;
        }
        if (this.pkalc.isInRing[ai]) {
            ri = this.pkalc.charge.getRings().getSmallestRingIndex(ai);
        }
        int z = 0;
        int k = 0;
        int[] v = new int[50];
        for (int i = 0; i < 50; ++i) {
            v[i] = -1;
        }
        boolean araCent = this.pkalc.isArA(ai);
        this.araSub = false;
        this.pkalc.getAtomDistances(ai, 5);
        this.setCenterNbAraRing(ai);
        this.calcDelocPath(ai, 0, 0);
        for (int i = 0; i < this.pkalc.sphereSize && z < 30; ++i) {
            String w;
            String x;
            int a = this.pkalc.sphere[i];
            int chg = this.pkalc.getMolecule().getAtom(a).getCharge();
            this.actChargeState = "";
            if (chg < 0) {
                this.actChargeState = "CHARGE-,";
            } else if (chg > 0) {
                this.actChargeState = "CHARGE+,";
            }
            this.isParentRingExist(ai, a);
            int d = this.pkalc.dist[a] - this.centGCorr;
            this.resPathState = "";
            if (this.di[a][0] == 1) {
                this.resPathState = ",A";
            }
            if (this.pkalc.getPolarGroups().getCarboxy()[a] == 400) {
                if (this.pkalc.getAtno(a) != 6 && chg <= 0) continue;
                x = ",D" + String.valueOf(d) + this.resPathState;
                if (this.Lres) {
                    x = ",R" + String.valueOf(d);
                } else if (this.Sres) {
                    x = "," + this.getOMPPrefix(d, araCent);
                }
                this.pType[cIdx][z] = chg > 0 ? "CHARGE+,CYANO" + x : "CYANO" + x;
                ++z;
                continue;
            }
            if (this.pkalc.getPolarGroups().getCarboxy()[a] == 2 || this.pkalc.getPolarGroups().getCarboxy()[a] == 1830 || this.pkalc.getPolarGroups().getCarboxy()[a] == 600 || this.pkalc.getPolarGroups().getCarboxy()[a] == 700) {
                if (usedGroup[this.pkalc.getPolarGroups().getGroupIndex()[a]]) continue;
                int gDist = this.getTheClosestGroupDist(a) - this.centGCorr;
                x = "";
                if (this.pkalc.getPolarGroups().getCarboxy()[a] == 2) {
                    x = "ESTER";
                } else if (this.pkalc.getPolarGroups().getCarboxy()[a] == 1830) {
                    x = "OXYM_ESTER";
                } else if (this.pkalc.getPolarGroups().getCarboxy()[a] == 600) {
                    x = "CARBAMOYL";
                } else if (this.pkalc.getPolarGroups().getCarboxy()[a] == 700) {
                    x = "PhCARBAMOYL";
                }
                if (this.pkalc.sAra[a] == 1) {
                    x = "ara" + x;
                }
                w = ",D" + String.valueOf(gDist) + this.resPathState;
                if (this.Sres) {
                    w = "," + this.getOMPPrefix(gDist, araCent);
                } else if (this.Lres) {
                    w = ",R" + String.valueOf(gDist);
                }
                String symb = "," + this.pkalc.getMolecule().getAtom(this.gAtom).getSymbol();
                usedGroup[this.pkalc.getPolarGroups().getGroupIndex()[a]] = true;
                this.pType[cIdx][z] = this.isCommonAliRing(ri, this.gAtom) ? this.actChargeState + x + w + ",in common ring" + symb : this.actChargeState + x + w + symb;
                ++z;
                continue;
            }
            if (this.pkalc.getPolarGroups().getCarboxy()[a] == 200 || this.pkalc.getPolarGroups().getCarboxy()[a] == 500 || this.pkalc.getPolarGroups().getCarboxy()[a] == 800) {
                if (usedGroup[this.pkalc.getPolarGroups().getGroupIndex()[a]]) continue;
                int gDist = this.getTheClosestGroupDist(a) - this.centGCorr;
                x = "";
                if (this.pkalc.getPolarGroups().getGroupProperty()[a] == 410) {
                    x = "RCONHCOR";
                } else if (this.pkalc.getPolarGroups().getGroupProperty()[a] == 420) {
                    x = "SEMIARACARBAZID";
                } else if (this.pkalc.getPolarGroups().getGroupProperty()[a] == 409) {
                    x = "RCONHR";
                } else if (this.pkalc.getPolarGroups().getCarboxy()[a] == 200) {
                    x = "CONH2";
                } else if (this.pkalc.getPolarGroups().getCarboxy()[a] == 500) {
                    x = "PhCONH2";
                } else if (this.pkalc.getPolarGroups().getCarboxy()[a] == 800) {
                    x = "RNHSO2";
                }
                w = ",D" + String.valueOf(gDist) + this.resPathState;
                if (this.Sres) {
                    w = "," + this.getOMPPrefix(gDist, araCent);
                } else if (this.Lres) {
                    w = ",R" + String.valueOf(gDist);
                }
                String symb = "," + this.pkalc.getMolecule().getAtom(this.gAtom).getSymbol();
                usedGroup[this.pkalc.getPolarGroups().getGroupIndex()[a]] = true;
                this.pType[cIdx][z] = this.isCommonAliRing(ri, this.gAtom) ? this.actChargeState + x + w + ",in common ring" + symb : this.actChargeState + x + w + symb;
                ++z;
                continue;
            }
            if (this.pkalc.getPolarGroups().getCarboxy()[a] == 300) {
                if (usedGroup[this.pkalc.getPolarGroups().getGroupIndex()[a]]) continue;
                usedGroup[this.pkalc.getPolarGroups().getGroupIndex()[a]] = true;
                int gDist = this.getTheClosestGroupDist(a) - this.centGCorr;
                w = ",D" + String.valueOf(gDist) + this.resPathState;
                if (this.Sres) {
                    w = "," + this.getOMPPrefix(gDist, araCent);
                }
                if (this.Lres) {
                    w = ",R" + String.valueOf(gDist);
                }
                this.pType[cIdx][z] = this.actChargeState + "CARBOXYL" + w;
                ++z;
                continue;
            }
            if (this.pkalc.getPolarGroups().getCarboxy()[a] == 100 || this.pkalc.getPolarGroups().getCarboxy()[a] == 1300) {
                if (usedGroup[this.pkalc.getPolarGroups().getGroupIndex()[a]]) continue;
                usedGroup[this.pkalc.getPolarGroups().getGroupIndex()[a]] = true;
                int gDist = this.getTheClosestGroupDist(a) - this.centGCorr;
                x = this.pkalc.isAraNB(this.gAtom) ? "ARNO2" : "NO2";
                w = ",D" + String.valueOf(gDist) + this.resPathState;
                if (this.Sres) {
                    w = "," + this.getOMPPrefix(gDist, araCent);
                } else if (this.Lres) {
                    w = ",R" + String.valueOf(gDist);
                }
                this.pType[cIdx][z] = this.actChargeState + x + w;
                ++z;
                continue;
            }
            if (this.pkalc.getPolarGroups().getCarboxy()[a] == 1500 || this.pkalc.getPolarGroups().getCarboxy()[a] == 1600) {
                if (usedGroup[this.pkalc.getPolarGroups().getGroupIndex()[a]]) continue;
                int gDist = this.getTheClosestGroupDist(a) - this.centGCorr;
                x = "";
                if (this.pkalc.getPolarGroups().getCarboxy()[a] == 1500) {
                    x = "AMIDINE";
                } else if (this.pkalc.getPolarGroups().getCarboxy()[a] == 1600) {
                    x = "GUANIDINE";
                }
                w = ",D" + String.valueOf(gDist) + this.resPathState;
                if (this.Sres) {
                    w = "," + this.getOMPPrefix(gDist, araCent);
                } else if (this.Lres) {
                    w = ",R" + String.valueOf(gDist);
                }
                String symb = "," + this.pkalc.getMolecule().getAtom(this.gAtom).getSymbol();
                usedGroup[this.pkalc.getPolarGroups().getGroupIndex()[a]] = true;
                this.pType[cIdx][z] = this.isCommonAliRing(ri, this.gAtom) ? this.actChargeState + x + w + ",in common ring" + symb : this.actChargeState + x + w + symb;
                ++z;
                continue;
            }
            if (this.pkalc.getPolarGroups().getCarboxy()[a] == 1800) {
                if (gai == this.pkalc.getPolarGroups().getGroupIndex()[a]) {
                    usedGroup[this.pkalc.getPolarGroups().getGroupIndex()[a]] = true;
                }
                if (usedGroup[this.pkalc.getPolarGroups().getGroupIndex()[a]]) continue;
                int gDist = this.getTheClosestGroupDist(a) - this.centGCorr;
                x = "OXYM";
                w = ",D" + String.valueOf(gDist) + this.resPathState;
                if (this.Sres) {
                    w = "," + this.getOMPPrefix(gDist, araCent);
                } else if (this.Lres) {
                    w = ",R" + String.valueOf(gDist);
                }
                String symb = "," + this.pkalc.getMolecule().getAtom(this.gAtom).getSymbol();
                usedGroup[this.pkalc.getPolarGroups().getGroupIndex()[a]] = true;
                this.pType[cIdx][z] = this.actChargeState + x + w + symb;
                ++z;
                continue;
            }
            if (this.pkalc.getPolarGroups().getCarboxy()[a] == 900) {
                x = this.pkalc.isAraNB(a) ? "AROH" : "OH";
                w = ",D" + String.valueOf(d) + this.resPathState;
                if (this.Lres) {
                    w = ",R" + String.valueOf(d);
                } else if (this.Sres) {
                    w = "," + this.getOMPPrefix(d, araCent);
                }
                String symb = "," + this.pkalc.getMolecule().getAtom(a).getSymbol();
                this.pType[cIdx][z] = this.actChargeState + x + w + symb;
                ++z;
                continue;
            }
            if (this.pkalc.getPolarGroups().getCarboxy()[a] == 1000) {
                x = "";
                w = "";
                x = this.pkalc.getPolarGroups().getGroupType(a) == 23 ? (this.pkalc.sAra[a] == 1 ? "araO" : "AROR") : "ROR";
                w = ",D" + String.valueOf(d) + this.resPathState;
                if (this.Lres) {
                    w = ",R" + String.valueOf(d);
                } else if (this.Sres) {
                    w = "," + this.getOMPPrefix(d, araCent);
                }
                String symb = "," + this.pkalc.getMolecule().getAtom(a).getSymbol();
                this.pType[cIdx][z] = this.actChargeState + x + w + symb;
                ++z;
                continue;
            }
            if (this.pkalc.getPolarGroups().getCarboxy()[a] == 1) {
                x = "";
                w = "";
                if (usedGroup[this.pkalc.getPolarGroups().getGroupIndex()[a]]) continue;
                usedGroup[this.pkalc.getPolarGroups().getGroupIndex()[a]] = true;
                int gDist = this.getTheClosestGroupDist(a) - this.centGCorr;
                x = "KETO";
                w = ",D" + String.valueOf(gDist) + this.resPathState;
                String symb = "," + this.getKetoSymbol(a);
                if (this.Lres) {
                    w = ",R" + String.valueOf(gDist);
                } else if (this.Sres) {
                    w = "," + this.getOMPPrefix(gDist, araCent);
                }
                if (this.isCommonAliRing(ri, this.gAtom)) {
                    this.pType[cIdx][z] = this.actChargeState + x + w + ",in common ring" + symb;
                    ++z;
                    continue;
                }
                if (this.pkalc.isInRing[a]) {
                    int rInd = this.pkalc.charge.getRings().getSmallestRingIndex(a);
                    int size = this.pkalc.nonAring[rInd].length;
                    if (size <= 6) {
                        this.pType[cIdx][z] = this.actChargeState + x + w + symb + ",IN RING6";
                        ++z;
                        continue;
                    }
                    if (size <= 6) continue;
                    this.pType[cIdx][z] = this.actChargeState + x + w + symb + ",IN RING LARGE";
                    ++z;
                    continue;
                }
                this.pType[cIdx][z] = this.actChargeState + x + w + symb;
                ++z;
                continue;
            }
            if (this.pkalc.getPolarGroups().getCarboxy()[a] == 1400) {
                x = "";
                w = "";
                x = this.pkalc.isArAConnectHalogen(a) ? "AR-HALOGEN" : "ALKYL-HALOGEN";
                w = ",D" + String.valueOf(d) + this.resPathState;
                if (this.Lres) {
                    w = ",R" + String.valueOf(d);
                } else if (this.Sres) {
                    w = "," + this.getOMPPrefix(d, araCent);
                }
                String symb = "," + this.pkalc.getMolecule().getAtom(a).getSymbol();
                this.pType[cIdx][z] = this.actChargeState + x + w + symb;
                ++z;
                continue;
            }
            if (this.pkalc.isArA(a) || this.pkalc.sAra[a] == 1) {
                x = "";
                w = "";
                int protonCount = this.pkalc.charge.atomArray[a].getAtno();
                switch (protonCount) {
                    case 7: {
                        if (this.pkalc.isPyrroleLike(a)) {
                            x = ",Pyr-N";
                            break;
                        }
                        if (chg > 0) {
                            if (!this.isProtonated(a)) {
                                x = ",AR(N+)R";
                                break;
                            }
                            x = ",ARN";
                            break;
                        }
                        if (this.isSemiAraPyrrole(a)) {
                            x = ",Pyr-N";
                            break;
                        }
                        x = ",ARN";
                        break;
                    }
                    case 8: {
                        x = ",ARO";
                        break;
                    }
                    case 16: {
                        x = ",ARS";
                        break;
                    }
                    case 34: {
                        x = ",ARSe";
                        break;
                    }
                    case 52: {
                        x = ",ARTe";
                        break;
                    }
                    case 6: {
                        boolean chargedRing = false;
                        if (this.pkalc.isArA(a) && usedAring[this.lAraRingIndx[a]] == 1) {
                            chargedRing = true;
                        }
                        if (chg != 0) {
                            if (chg < 0) {
                                x = ",ARC(-)";
                                break;
                            }
                            if (chg <= 0) break;
                            x = ",ARC(+)";
                            break;
                        }
                        if (this.isHeteroOrChargedRing(a) || chargedRing) break;
                        if (this.Sres && !this.araSub) {
                            w = "," + this.getOMPPrefix(d, araCent);
                            x = "PHENYL GROUP";
                            this.pType[cIdx][z] = this.actChargeState + x + w;
                            ++z;
                            v[k] = this.subLi;
                            ++k;
                            break;
                        }
                        if (this.isResAra(v, a) || this.theSameRing) break;
                        if (d == 3) {
                            minArADist3 = true;
                            break;
                        }
                        if (d == 4) {
                            minArADist4 = true;
                            break;
                        }
                        if (d != 2) break;
                        minArADist2 = true;
                    }
                }
                if (protonCount == 6 && chg == 0) continue;
                w = ",D" + String.valueOf(d) + this.resPathState;
                if (this.Lres) {
                    w = ",R" + String.valueOf(d);
                } else if (this.Sres) {
                    if (araCent && this.araSub) {
                        ++d;
                    }
                    w = "," + this.getOMPPrefix(d, araCent);
                }
                if (this.pkalc.isArA(a)) {
                    x = "HETERO" + x;
                } else if (this.pkalc.sAra[a] == 1) {
                    x = "SEMI-HETERO" + x;
                }
                if (chg != 0 && protonCount == 6) {
                    int ridx;
                    if (!this.pkalc.isArA(a) || usedAring[ridx = this.lAraRingIndx[a]] == 1) continue;
                    x = "AROMATIC RING";
                    this.pType[cIdx][z] = this.actChargeState + x + w;
                    ++z;
                    usedAring[ridx] = 1;
                    continue;
                }
                this.pType[cIdx][z] = this.actChargeState + x + w;
                ++z;
                continue;
            }
            if (this.pkalc.charge.hconj[a] == 1) {
                boolean hypeAllowed = true;
                if (this.Lres) {
                    x = ",R" + String.valueOf(d);
                } else if (this.Sres) {
                    x = "," + this.getOMPPrefix(d, araCent);
                } else {
                    x = ",D" + String.valueOf(d) + this.resPathState;
                    hypeAllowed = false;
                }
                if (!hypeAllowed || this.isHeteroAraNbExist(a) || this.centGCorr > 1) continue;
                if (this.isImpH3(a)) {
                    this.pType[cIdx][z] = this.actChargeState + "HYPERCONJUGATION" + x;
                    ++z;
                    continue;
                }
                this.pType[cIdx][z] = this.actChargeState + "ArR" + x;
                ++z;
                continue;
            }
            if (this.pkalc.getPolarGroups().getCarboxy()[a] == 1840) {
                if (usedGroup[this.pkalc.getPolarGroups().getGroupIndex()[a]]) continue;
                w = "";
                usedGroup[this.pkalc.getPolarGroups().getGroupIndex()[a]] = true;
                w = ",D" + String.valueOf(d) + this.resPathState;
                if (this.Lres) {
                    w = ",R" + String.valueOf(d);
                } else if (this.Sres) {
                    w = "," + this.getOMPPrefix(d, araCent);
                }
                this.pType[cIdx][z] = this.actChargeState + "ETIN" + w;
                ++z;
                continue;
            }
            if (this.pkalc.getPolarGroups().getCarboxy()[a] == 1700) {
                if (usedGroup[this.pkalc.getPolarGroups().getGroupIndex()[a]]) continue;
                usedGroup[this.pkalc.getPolarGroups().getGroupIndex()[a]] = true;
                x = ",D" + String.valueOf(d) + this.resPathState;
                if (this.Lres) {
                    x = ",R" + String.valueOf(d);
                } else if (this.Sres) {
                    x = "," + this.getOMPPrefix(d, araCent);
                }
                this.pType[cIdx][z] = this.actChargeState + "IMIDLIKE" + x;
                ++z;
                continue;
            }
            if (this.pkalc.pkaBasicType[a][0] == 1) {
                x = ",D" + String.valueOf(d) + this.resPathState;
                if (this.Lres) {
                    x = ",R" + String.valueOf(d);
                } else if (this.Sres) {
                    x = "," + this.getOMPPrefix(d, araCent);
                }
                this.pType[cIdx][z] = this.actChargeState + "ANILINE" + x;
                ++z;
                continue;
            }
            if (d >= 4) {
                x = ",D" + String.valueOf(d) + this.resPathState;
                if (this.pkalc.pkaBasicType[a][0] == 1000) {
                    this.pType[cIdx][z] = this.actChargeState + "ALIPHATIC-N" + x;
                    ++z;
                    continue;
                }
                if (this.pkalc.pkaBasicType[a][0] == 5) {
                    this.pType[cIdx][z] = this.actChargeState + "IMIDE" + x;
                    ++z;
                    continue;
                }
                if (this.pkalc.pkaBasicType[a][0] == 2000) {
                    this.pType[cIdx][z] = this.actChargeState + "P-BASE" + x;
                    ++z;
                    continue;
                }
                if (chg > 0) {
                    String symb = "," + this.pkalc.getMolecule().getAtom(a).getSymbol();
                    this.pType[cIdx][z] = "CHARGE+" + x + symb;
                    ++z;
                    continue;
                }
                if (chg >= 0) continue;
                String symb = "," + this.pkalc.getMolecule().getAtom(a).getSymbol();
                this.pType[cIdx][z] = "CHARGE-" + x + symb;
                ++z;
                continue;
            }
            if (d == 3) {
                w = ",D" + String.valueOf(d) + this.resPathState;
                x = "";
                String symb = "," + this.pkalc.getMolecule().getAtom(a).getSymbol();
                if (this.pkalc.pkaBasicType[a][0] == 1000 || this.pkalc.pkaBasicType[a][0] == 2000) {
                    if (this.pkalc.pkaBasicType[a][0] == 1000) {
                        x = "ALIPHATIC-N";
                    } else if (this.pkalc.pkaBasicType[a][0] == 2000) {
                        x = "P-BASE";
                    }
                    this.pType[cIdx][z] = this.isCommonAliRing(ri, a) ? this.actChargeState + x + w + ",in common ring" : this.actChargeState + x + w;
                    ++z;
                    continue;
                }
                if (this.pkalc.charge.getSigmaAtomType()[a] == 2) {
                    if (!this.pkalc.isRingEten(a, ri)) continue;
                    this.pType[cIdx][z] = this.actChargeState + "EXOCYCLIC-DOUBLE-BOND" + w;
                    ++z;
                    continue;
                }
                if (chg > 0) {
                    this.pType[cIdx][z] = "CHARGE+" + w + symb;
                    ++z;
                    continue;
                }
                if (chg < 0) {
                    this.pType[cIdx][z] = "CHARGE-" + w + symb;
                    ++z;
                    continue;
                }
                if (!this.isAllowedAlkylGroup(a)) continue;
                if (this.alkylC[a] == 1) {
                    this.pType[cIdx][z] = this.actChargeState + "ALKYL GROUP" + w;
                    ++z;
                    continue;
                }
                if (this.alkylC[a] != 2) continue;
                this.pType[cIdx][z] = this.actChargeState + "ALKYL X GROUP" + w;
                ++z;
                continue;
            }
            if (d != 2) continue;
            w = ",D" + String.valueOf(d) + this.resPathState;
            String symb = "," + this.pkalc.getMolecule().getAtom(a).getSymbol();
            if (this.pkalc.isTertButylGroup(a)) {
                this.pType[cIdx][z] = "TERT-BUTYL GROUP" + w;
                ++z;
                continue;
            }
            if (this.pkalc.pkaBasicType[a][0] == 1000) {
                x = "ALIPHATIC-N";
                this.pType[cIdx][z] = this.actChargeState + x + w;
                ++z;
                continue;
            }
            if (chg > 0) {
                this.pType[cIdx][z] = "CHARGE+" + w + symb;
                ++z;
                continue;
            }
            if (chg < 0) {
                this.pType[cIdx][z] = "CHARGE-" + w + symb;
                ++z;
                continue;
            }
            if (this.alkylC[a] == 1) {
                this.pType[cIdx][z] = this.actChargeState + "ALKYL GROUP" + w;
                ++z;
                continue;
            }
            if (this.alkylC[a] != 2) continue;
            this.pType[cIdx][z] = this.actChargeState + "ALKYL X GROUP" + w;
            ++z;
        }
        if (this.pkalc.pkaBasicType[ai][0] == 1000 || this.pkalc.pkaBasicType[ai][0] == 2000) {
            if (this.setStericHidrance(ai)) {
                this.pType[cIdx][z] = this.actChargeState + "AMINE in strained ring";
                ++z;
            }
            if (this.pkalc.pkaBasicType[ai][3] == 2 && this.pkalc.isInRing[ai] && this.pkalc.charge.getSpecNonARingIncrement(ai) != 0.0) {
                this.pType[cIdx][z] = this.actChargeState + "AMINE in pyrrolidine ring";
                ++z;
            }
        }
        if (minArADist2) {
            this.pType[cIdx][z] = this.actChargeState + "AROMATIC GROUP,D2";
            ++z;
        } else if (minArADist3) {
            this.pType[cIdx][z] = this.actChargeState + "AROMATIC GROUP,D3";
            ++z;
        } else if (minArADist4) {
            this.pType[cIdx][z] = this.actChargeState + "AROMATIC GROUP,D4";
            ++z;
        }
        if (z == 0) {
            this.pType[cIdx][z] = "CONSTANT";
            ++z;
        }
        this.pType[cIdx][z] = "END";
        this.pTypeCount[cIdx] = z;
    }

    private boolean isAllowedAlkylGroup(int ai) {
        int type3 = this.alkylC[ai];
        if (this.alkylC[ai] == 0 || this.pkalc.isArA(ai)) {
            return false;
        }
        for (int i = 0; i < this.pkalc.cHtab[ai].length; ++i) {
            int type2;
            int d2;
            int nb = this.pkalc.cHtab[ai][i];
            if (nb >= this.atomCount || (d2 = this.pkalc.dist[nb]) != 2 || (type2 = this.alkylC[nb]) == 0 || type3 < type2) continue;
            return false;
        }
        return true;
    }

    private boolean isImpH3(int ai) {
        int c = 0;
        for (int i = 0; i < this.pkalc.cHtab[ai].length; ++i) {
            int nb = this.pkalc.cHtab[ai][i];
            if (nb < this.atomCount) continue;
            ++c;
        }
        return c == 3;
    }

    private void setAlkylCarbon() {
        for (int i = 0; i < this.atomCount; ++i) {
            int pc = this.pkalc.getAtno(i);
            int impH = 0;
            int carbon = 0;
            if (pc == 6 && this.pkalc.charge.hconj[i] != 1 && this.pkalc.cHtab[i].length == 4) {
                for (int j = 0; j < this.pkalc.cHtab[i].length; ++j) {
                    int nb = this.pkalc.cHtab[i][j];
                    if (nb < this.atomCount) {
                        pc = this.pkalc.getAtno(nb);
                        if (pc != 6) continue;
                        ++carbon;
                        continue;
                    }
                    ++impH;
                }
            }
            if (impH + carbon == 4) {
                this.alkylC[i] = 1;
                continue;
            }
            if (impH + carbon != 3) continue;
            this.alkylC[i] = 2;
        }
    }

    private boolean isHeteroAraNbExist(int ha) {
        for (int i = 0; i < this.pkalc.cHtab[ha].length; ++i) {
            int nb = this.pkalc.cHtab[ha][i];
            if (nb >= this.atomCount || !this.pkalc.isArA(nb) || this.pkalc.getAtno(nb) == 6) continue;
            return true;
        }
        return false;
    }

    private boolean isHeteroOrChargedRing(int carbon) {
        int rIndx = this.lAraRingIndx[carbon];
        if (rIndx == -1) {
            return false;
        }
        if (this.isChargedRing(carbon)) {
            return true;
        }
        for (int i = 0; i < this.pkalc.aAtoms[rIndx].length; ++i) {
            int ri = this.pkalc.aAtoms[rIndx][i];
            if (this.pkalc.getAtno(ri) == 6) continue;
            return true;
        }
        return false;
    }

    private boolean isProtonated(int ai) {
        for (int i = 0; i < this.pkalc.cHtab[ai].length; ++i) {
            int nb = this.pkalc.cHtab[ai][i];
            if (nb < this.atomCount) continue;
            return true;
        }
        return false;
    }

    private boolean isResAra(int[] v, int a) {
        if (this.Sres || this.Lres) {
            return true;
        }
        int k = 0;
        while (v[k] != -1) {
            if (this.pkalc.isTheSameAraRing(v[k], a)) {
                return true;
            }
            ++k;
        }
        return false;
    }

    private String getOMPPrefix(int d, boolean araCent) {
        String x = "";
        x = d == 2 ? "ortho" : (d == 3 ? (araCent || this.araSub ? "meta" : "ortho") : (d == 4 ? (araCent || this.araSub ? "para" : "meta") : (d == 5 ? "para" : "R" + String.valueOf(d))));
        return x;
    }

    private boolean isParentRingExist(int c, int s) {
        this.Sres = false;
        this.Lres = false;
        this.araSub = false;
        boolean rs = this.isRightSubstituent(c, s);
        if (!rs) {
            return false;
        }
        int gInd = this.pkalc.getPolarGroups().getGroupIndex()[s];
        this.centGCorr = 0;
        this.subLi = -1;
        if (this.centSaraIdx != null) {
            for (int i = 0; i < this.centSaraIdx.length; ++i) {
                int nb;
                int j;
                int Si = this.centSaraIdx[i];
                int Li = this.centLaraIdx[i];
                if (gInd != -1) {
                    for (j = 0; j < this.pkalc.getPolarGroups().getGroups()[gInd].length; ++j) {
                        int a = this.pkalc.getPolarGroups().getGroups()[gInd][j];
                        for (int k = 0; k < this.pkalc.cHtab[a].length; ++k) {
                            nb = this.pkalc.cHtab[a][k];
                            if (!this.pkalc.isArA(nb)) continue;
                            if (this.pkalc.isTheSameAraRing(Si, nb)) {
                                this.Sres = true;
                                this.centGCorr = this.centGroupDist[i];
                                if (Li != Si) continue;
                                this.araSub = this.isCommonAraRing(Si, s);
                                if (this.pkalc.isArA(a)) {
                                    this.subLi = this.lAraRingIndx[a];
                                }
                                return true;
                            }
                            if (Li == Si || !this.pkalc.isTheSameAraRing(Li, nb)) continue;
                            this.Lres = true;
                            this.Sres = false;
                            this.centGCorr = this.centGroupDist[i];
                            this.araSub = this.isCommonAraRing(Li, s);
                            if (this.pkalc.isArA(a)) {
                                this.subLi = this.lAraRingIndx[a];
                            }
                            return true;
                        }
                    }
                    continue;
                }
                if (gInd != -1) continue;
                for (j = 0; j < this.pkalc.cHtab[s].length; ++j) {
                    nb = this.pkalc.cHtab[s][j];
                    if (!this.pkalc.isArA(nb)) continue;
                    if (this.pkalc.isTheSameAraRing(Si, nb)) {
                        this.Sres = true;
                        this.centGCorr = this.centGroupDist[i];
                        if (Li == Si) {
                            this.araSub = this.isCommonAraRing(Si, s);
                            if (this.pkalc.isArA(s)) {
                                this.subLi = this.lAraRingIndx[s];
                            }
                            return true;
                        }
                        if (!this.pkalc.isArA(s)) continue;
                        this.centGCorr = this.centGroupDist[i];
                        if (this.sAraRingIndx[s] != Si) continue;
                        this.araSub = true;
                        this.subLi = this.lAraRingIndx[s];
                        continue;
                    }
                    if (Li == Si || !this.pkalc.isTheSameAraRing(Li, nb)) continue;
                    this.Lres = true;
                    this.Sres = false;
                    this.centGCorr = this.centGroupDist[i];
                    this.araSub = this.isCommonAraRing(Li, s);
                    if (this.pkalc.isArA(s)) {
                        this.subLi = this.lAraRingIndx[s];
                    }
                    return true;
                }
            }
        }
        return false;
    }

    private boolean isRightSubstituent(int c, int s) {
        if (!this.pkalc.isArA(s)) {
            return true;
        }
        this.theSameRing = this.istheSameCentSubLrindx(c, s);
        int protonCount = this.pkalc.getAtno(s);
        int chg = this.pkalc.getMolecule().getAtom(s).getCharge();
        if (chg != 0) {
            return true;
        }
        if (protonCount != 6) {
            return true;
        }
        return !this.theSameRing;
    }

    private boolean istheSameCentSubLrindx(int c, int s) {
        if (this.centSaraIdx != null) {
            for (int i = 0; i < this.centSaraIdx.length; ++i) {
                int cLi = this.centLaraIdx[i];
                if (this.lAraRingIndx[s] != cLi) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isChargedRing(int ai) {
        int ri = this.lAraRingIndx[ai];
        if (ri != -1) {
            for (int i = 0; i < this.pkalc.aAtoms[ri].length; ++i) {
                int ra = this.pkalc.aAtoms[ri][i];
                int chg = this.pkalc.getMolecule().getAtom(ra).getCharge();
                if (chg == 0) continue;
                return true;
            }
        }
        return false;
    }

    private boolean setStericHidrance(int atom) {
        int rInd = this.pkalc.charge.getRings().getSmallestRingIndex(atom);
        int rc = 0;
        if (rInd != -1 && this.pkalc.nonAring.length < 18) {
            if (this.pkalc.nonAring.length > 3) {
                for (int j = 0; j < this.pkalc.nonAring[rInd].length; ++j) {
                    int rAtom = this.pkalc.nonAring[rInd][j];
                    rc += this.pkalc.charge.getAllNonAringIndex(rAtom);
                }
            }
            if (rc > 16) {
                return true;
            }
            rInd = this.pkalc.charge.getLargestRingIndex(atom);
            if (this.pkalc.nonAring[rInd].length > 10 && (rc = this.pkalc.getACount(rInd)) >= 8) {
                return true;
            }
        } else if (this.pkalc.nonAring.length > 18) {
            int a;
            int i;
            int ringCounter = 0;
            int[] keyAtoms = new int[10];
            for (i = 0; i < this.pkalc.sphereSize; ++i) {
                a = this.pkalc.sphere[i];
                if (this.pkalc.dist[a] != 3) continue;
                int k = 0;
                for (int j = 0; j < this.pkalc.cHtab[a].length; ++j) {
                    int nb = this.pkalc.cHtab[a][j];
                    if (nb >= this.pkalc.getMolecule().getAtomCount() || this.pkalc.dist[nb] != 2) continue;
                    ++k;
                    if (ringCounter != 0) continue;
                    keyAtoms[k] = nb;
                }
                if (k == 2) {
                    if (ringCounter == 0) {
                        keyAtoms[0] = a;
                    }
                    ++ringCounter;
                }
                if (k != 3) continue;
                ringCounter = 2;
            }
            if (ringCounter == 1) {
                for (i = 0; i < this.pkalc.sphereSize; ++i) {
                    a = this.pkalc.sphere[i];
                    if (this.pkalc.dist[a] != 3 || a == keyAtoms[0] || !this.pkalc.isRingHidrance(a, keyAtoms)) continue;
                    return true;
                }
            } else if (ringCounter != 0) {
                return true;
            }
        }
        return false;
    }

    private void setCenterNbAraRing(int ai) {
        int nb;
        int dist;
        int i;
        int a;
        int gInd = this.pkalc.getPolarGroups().getGroupIndex()[ai];
        this.centSaraIdx = null;
        this.centLaraIdx = null;
        this.centGroupDist = null;
        if (this.pkalc.isArA(ai) && !this.pkalc.isCrossArA(ai)) {
            this.centSaraIdx = new int[1];
            this.centLaraIdx = new int[1];
            this.centGroupDist = new int[1];
            this.centSaraIdx[0] = this.sAraRingIndx[ai];
            this.centLaraIdx[0] = this.lAraRingIndx[ai];
            this.centGroupDist[0] = 0;
            return;
        }
        int j = 0;
        int size = 0;
        if (gInd != -1) {
            for (int i2 = 0; i2 < this.pkalc.getPolarGroups().getGroups()[gInd].length; ++i2) {
                a = this.pkalc.getPolarGroups().getGroups()[gInd][i2];
                size += this.pkalc.cHtab[a].length;
            }
        } else {
            size = this.pkalc.cHtab[ai].length;
        }
        int[] r = new int[size];
        int[] rr = new int[size];
        int[] d = new int[size];
        if (gInd != -1) {
            for (i = 0; i < this.pkalc.getPolarGroups().getGroups()[gInd].length; ++i) {
                a = this.pkalc.getPolarGroups().getGroups()[gInd][i];
                dist = this.pkalc.dist[a];
                for (int k = 0; k < this.pkalc.cHtab[a].length; ++k) {
                    nb = this.pkalc.cHtab[a][k];
                    if (!this.pkalc.isArA(nb)) continue;
                    r[j] = this.sAraRingIndx[nb];
                    rr[j] = this.lAraRingIndx[nb];
                    d[j] = dist;
                    ++j;
                }
            }
        } else if (gInd == -1) {
            for (i = 0; i < size; ++i) {
                nb = this.pkalc.cHtab[ai][i];
                dist = this.pkalc.dist[ai];
                if (!this.pkalc.isArA(nb)) continue;
                r[j] = this.sAraRingIndx[nb];
                rr[j] = this.lAraRingIndx[nb];
                d[j] = dist;
                ++j;
            }
        }
        if (j != 0) {
            this.centSaraIdx = new int[j];
            this.centLaraIdx = new int[j];
            this.centGroupDist = new int[j];
            for (i = 0; i < j; ++i) {
                this.centSaraIdx[i] = r[i];
                this.centLaraIdx[i] = rr[i];
                this.centGroupDist[i] = d[i];
            }
        }
    }

    private int getTheClosestGroupDist(int ai) {
        int gInd = this.pkalc.getPolarGroups().getGroupIndex()[ai];
        int d0 = 100;
        this.gAtom = ai;
        this.actChargeState = "";
        for (int i = 0; i < this.pkalc.getPolarGroups().getGroups()[gInd].length; ++i) {
            int a = this.pkalc.getPolarGroups().getGroups()[gInd][i];
            int dist = this.pkalc.dist[a];
            if (dist < d0 && dist != 0) {
                d0 = dist;
                this.gAtom = a;
            }
            if (this.pkalc.getPolarGroups().getChargeState()[a] == 1000) {
                this.actChargeState = "CHARGE-,";
                continue;
            }
            if (this.pkalc.getPolarGroups().getChargeState()[a] != 900) continue;
            this.actChargeState = "CHARGE+,";
        }
        return d0;
    }

    private String getKetoSymbol(int ai) {
        for (int i = 0; i < this.pkalc.cHtab[ai].length; ++i) {
            int nb = this.pkalc.cHtab[ai][i];
            if (nb >= this.pkalc.getMolecule().getAtomCount() || this.pkalc.cHtab[nb].length != 1 || !this.isDBbonded(ai, nb)) continue;
            return this.pkalc.getMolecule().getAtom(nb).getSymbol();
        }
        return "O";
    }

    private boolean isDBbonded(int a1, int a2) {
        MolBond bond = this.mol.getAtom(a1).getBondTo(this.mol.getAtom(a2));
        return bond != null && bond.getType() > 1;
    }

    private boolean isSemiAraPyrrole(int ai) {
        if (this.pkalc.isArA(ai)) {
            return false;
        }
        return this.pkalc.cHtab[ai].length == 3;
    }

    private void calcDelocPath(int acc, int resA, int resB) {
        boolean restrict = false;
        int actAtom = acc;
        int diSphereSize = 0;
        this.di = new int[this.atomCount][3];
        int[] diAtom = new int[this.atomCount];
        for (int i = 0; i < this.atomCount; ++i) {
            diAtom[i] = -1;
        }
        int distance = 1;
        boolean sChange = true;
        boolean jump = false;
        int i = 0;
        int y = this.atomCount + 1;
        while (distance < y & sChange) {
            sChange = false;
            int length = this.pkalc.cHtab[actAtom].length;
            for (int j = 0; j < length; ++j) {
                int pa = this.pkalc.cHtab[actAtom][j];
                if (restrict) {
                    jump = false;
                    if (actAtom == resB && pa == resA) {
                        jump = true;
                    }
                }
                if (pa >= this.atomCount || jump || this.di[pa][0] == 1 || pa == acc || this.pkalc.delocAble[pa] != 1) continue;
                this.di[pa][0] = 1;
                this.di[pa][1] = distance;
                this.di[pa][2] = actAtom;
                diAtom[diSphereSize] = pa;
                ++diSphereSize;
            }
            if (diAtom[i] != -1) {
                actAtom = diAtom[i];
                distance = this.di[actAtom][1] + 1;
                sChange = true;
            } else {
                sChange = false;
            }
            if (++i != this.atomCount) continue;
            sChange = false;
        }
        if (diSphereSize != 0) {
            this.di[acc][0] = 1;
            this.di[acc][1] = 0;
        }
    }
}

