/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.calculations.stereo;

import chemaxon.core.util.BondTable;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.MoleculeGraph;
import java.util.Arrays;
import java.util.BitSet;

public class StereoCorrector {
    public static boolean removeInvalidWedges(MoleculeGraph m) {
        if (m.getDim() != 2) {
            return false;
        }
        long[] rb = m.getSSSRBondSetInLong();
        int[] parity = StereoCorrector.getAtomParities(m);
        BitSet bondsWithRemovableWedge = new BitSet();
        boolean oneSide = m.isOnlyFirstAtomInStereoCalculation();
        int bc = m.getBondCount();
        for (int i = 0; i < bc; ++i) {
            boolean wavyBond;
            MolBond b = m.getBond(i);
            int f = b.getFlags() & 0x30;
            if (f == 0) continue;
            MolAtom a1 = b.getAtom1();
            boolean bl = wavyBond = f == 48;
            if (wavyBond && StereoCorrector.hasDoublebond(a1)) continue;
            int a1idx = m.indexOf(a1);
            int a2idx = m.indexOf(b.getAtom2());
            int p1 = parity[a1idx];
            boolean isSymmetrical = StereoCorrector.isSymmetricalNode(m, a1idx, a2idx, rb, parity);
            if (p1 != 0 && !isSymmetrical && (p1 != 3 || wavyBond)) continue;
            if (oneSide) {
                bondsWithRemovableWedge.set(i);
                continue;
            }
            int p2 = parity[a2idx];
            if (p2 != 0) continue;
            bondsWithRemovableWedge.set(i);
        }
        boolean modified = StereoCorrector.removeWedges(m, bondsWithRemovableWedge);
        return modified;
    }

    private static boolean removeWedges(MoleculeGraph m, BitSet bondsWR) {
        boolean modified = false;
        int i = bondsWR.nextSetBit(0);
        while (i >= 0) {
            modified = true;
            MolBond b = m.getBond(i);
            b.setFlags(0, 48);
            i = bondsWR.nextSetBit(i + 1);
        }
        return modified;
    }

    private static boolean isSymmetricalNode(MoleculeGraph m, int idx, int idxFrom, long[] rb, int[] parity) {
        int[] grinv = new int[m.getAtomCount()];
        m.getGrinv(grinv, 3);
        int[][] ctab = m.getCtab();
        int[] an = ctab[idx];
        int[] g = StereoCorrector.getGrinv(an, grinv);
        if (!StereoCorrector.hasCommonValues(g)) {
            return false;
        }
        BitSet used = new BitSet(m.getAtomCount());
        BitSet fn = StereoCorrector.locateFacingNodes(idx, idxFrom, used, m, ctab, rb);
        int i = fn.nextSetBit(0);
        while (i >= 0) {
            if (parity[i] == 1 || parity[i] == 2) {
                return false;
            }
            i = fn.nextSetBit(i + 1);
        }
        return true;
    }

    private static BitSet locateFacingNodes(int idx, int idxFrom, BitSet used, MoleculeGraph m, int[][] ctab, long[] rb) {
        int l = ctab.length;
        BitSet start = new BitSet(l);
        boolean facingnode = false;
        int[] nArr = new int[l];
        BondTable btab = m.getBondTable();
        used.set(idx);
        start.set(idx);
        used.set(idxFrom);
        while (!(facingnode = StereoCorrector.stepBranch(start, used, nArr, ctab, btab, rb)) && start.cardinality() > 0) {
        }
        BitSet fn = new BitSet();
        for (int i = 0; i < nArr.length; ++i) {
            int j = nArr[i];
            if (j <= 1) continue;
            fn.set(i);
        }
        return fn;
    }

    private static boolean stepBranch(BitSet start, BitSet used, int[] nArr, int[][] ctab, BondTable btab, long[] rb) {
        Arrays.fill(nArr, 0);
        boolean hasChiralFacingNode = false;
        int i = start.nextSetBit(0);
        while (i >= 0) {
            for (int idx : ctab[i]) {
                int bidx;
                if (used.get(idx) || !StereoCorrector.get(bidx = btab.getBondIndex(i, idx), rb)) continue;
                int n = idx;
                nArr[n] = nArr[n] + 1;
            }
            i = start.nextSetBit(i + 1);
        }
        start.clear();
        int l = nArr.length;
        for (int i2 = 0; i2 < l; ++i2) {
            int pathCount = nArr[i2];
            if (pathCount <= 0) continue;
            if (pathCount > 1) {
                hasChiralFacingNode = true;
            }
            used.set(i2);
            start.set(i2);
        }
        return hasChiralFacingNode;
    }

    private static int[] getAtomParities(MoleculeGraph m) {
        int[] p = new int[m.getAtomCount()];
        for (int i = 0; i < p.length; ++i) {
            p[i] = m.getParity(i);
        }
        return p;
    }

    private static int[] getGrinv(int[] an, int[] grinv) {
        int[] g = new int[an.length];
        for (int i = 0; i < an.length; ++i) {
            int idx = an[i];
            g[i] = grinv[idx];
        }
        return g;
    }

    private static boolean hasCommonValues(int[] g) {
        int l = g.length;
        for (int i = 0; i < l; ++i) {
            int v1 = g[i];
            for (int j = i + 1; j < l; ++j) {
                if (v1 != g[j]) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean hasDoublebond(MolAtom a1) {
        for (int j = 0; j < a1.getBondCount(); ++j) {
            MolBond bl = a1.getBond(j);
            if (bl.getType() != 2) continue;
            return true;
        }
        return false;
    }

    public static boolean removeInvalidEnhancedStereo(MoleculeGraph m) {
        if (m.getDim() != 2) {
            return false;
        }
        boolean modified = false;
        int ac = m.getAtomCount();
        for (int i = 0; i < ac; ++i) {
            MolAtom a = m.getAtom(i);
            if (a.getStereoGroupType() == 0 || StereoCorrector.hasWedge(a)) continue;
            a.setStereoGroupType(0);
            modified = true;
        }
        return modified;
    }

    private static boolean hasWedge(MolAtom a) {
        int bc = a.getBondCount();
        for (int i = 0; i < bc; ++i) {
            MolBond b = a.getBond(i);
            if ((b.getFlags() & 0x30) == 0) continue;
            return true;
        }
        return false;
    }

    private static boolean get(int n, long[] r) {
        return (r[n / 64] & 1L << 63 - n % 64) != 0L;
    }
}

