/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.calculations.stereo;

import chemaxon.core.util.BondTable;
import chemaxon.struc.DPoint3;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.MoleculeGraph;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;

public final class StereoRecognizer {
    private MoleculeGraph mol = null;
    private BitSet activeAtomSet = null;
    private ArrayList<int[]> stereoGroup = null;
    public static final int TH = 1;
    public static final int CT = 2;
    public static final int AXIAL = 3;
    public static final int ODD = 1;
    public static final int EVEN = 2;
    private static final int ODDEVEN = 3;
    private static final int ONE_DB_BOND = 1;
    private static final int TWO_DB_BOND = 2;
    private static final int MORE_DB_BOND = 4;
    private static final int ONE_AROM_BOND = 8;
    private static final int TWO_AROM_BOND = 16;
    private static final int MORE_AROM_BOND = 32;
    private static final int HASWEDGE = 64;
    private static final int GRINV_COMMON_RINGBOND_2 = 64;
    private static final int GRINV_COMMON_RINGBOND_3 = 128;
    private static final int GRINV_MORE_COMMON_IN_RING = 256;
    private static final int FOUR_DIFF_GRINV = 512;
    private static final int THREE_DIFF_GRINV = 1024;
    private static final int RIGID = 2048;
    private static final int RINGATOM = 4096;
    private static final double DET2_THRESHOLD = 1.0E-16;

    public boolean calculateStereoAtoms(MoleculeGraph m) {
        int ac = m.getAtomCount();
        this.activeAtomSet = null;
        this.stereoGroup = new ArrayList();
        if (m.getDim() < 2) {
            return false;
        }
        this.initialize(m);
        int[] grinv = new int[ac];
        int[] atomFlags = new int[ac];
        BitSet possActiveAtomSet = StereoRecognizer.getActiveAtoms(this.mol, grinv, atomFlags);
        this.generateDescriptorPairs(possActiveAtomSet, grinv, atomFlags);
        this.activeAtomSet = StereoRecognizer.keepUsedAtoms(possActiveAtomSet, this.stereoGroup);
        return true;
    }

    private void initialize(MoleculeGraph m) {
        this.mol = (MoleculeGraph)m.clone();
        this.mol.aromatize();
    }

    public int[][] getStereoDefinitions() {
        return this.stereoGroup == null ? new int[0][0] : (int[][])this.stereoGroup.toArray((T[])new int[this.stereoGroup.size()][]);
    }

    public BitSet getActiveAtoms() {
        return this.activeAtomSet == null ? new BitSet(0) : this.activeAtomSet;
    }

    private static BitSet keepUsedAtoms(BitSet aas, ArrayList<int[]> sg) {
        aas.clear();
        block4: for (int[] is : sg) {
            switch (is[0]) {
                case 1: {
                    aas.set(is[2]);
                    continue block4;
                }
                case 2: 
                case 3: {
                    aas.set(is[2]);
                    aas.set(is[3]);
                    continue block4;
                }
            }
            System.err.println("no such stereo element");
        }
        return aas;
    }

    private static BitSet getActiveAtoms(MoleculeGraph m, int[] grinv, int[] atomFlags) {
        int ac = m.getAtomCount();
        BitSet aSet = new BitSet(ac);
        int[][] ctab = m.getCtab();
        int[] g = new int[4];
        m.getGrinv(grinv, 3);
        block5: for (int i = 0; i < ac; ++i) {
            MolAtom a = m.getAtom(i);
            int l = a.getBondCount();
            if (l < 2 || l > 4) continue;
            for (int j = l; j < 4; ++j) {
                g[j] = -1;
            }
            int[] an = ctab[i];
            int dbbc = 0;
            int sabc = 0;
            int abc = 0;
            boolean nonStereo = false;
            for (int j = 0; j < l; ++j) {
                int t;
                MolBond b = a.getBond(j);
                if ((b.getFlags() & 0x30) != 0) {
                    int n = i;
                    atomFlags[n] = atomFlags[n] | 0x40;
                }
                if ((t = b.getType()) == 2) {
                    ++dbbc;
                    continue;
                }
                if (t == 1) {
                    g[sabc++] = grinv[an[j]];
                    continue;
                }
                if (t == 4) {
                    ++abc;
                    g[sabc++] = grinv[an[j]];
                    continue;
                }
                nonStereo = true;
                break;
            }
            if (nonStereo) continue;
            if (dbbc == 0) {
                if (sabc == 3 && g[0] != -1 && g[1] != -1 && g[2] != -1) {
                    if (StereoRecognizer.threeDifferent(g)) {
                        aSet.set(i);
                    }
                } else if (sabc == 4 && StereoRecognizer.threeDifferent(g)) {
                    aSet.set(i);
                }
            } else if (dbbc == 1) {
                int n = i;
                atomFlags[n] = atomFlags[n] | 0x801;
                if (sabc == 1 && g[0] != -1) {
                    aSet.set(i);
                } else if (sabc == 2 && g[0] != g[1]) {
                    aSet.set(i);
                }
            } else if (dbbc == 2) {
                int n = i;
                atomFlags[n] = atomFlags[n] | 0x802;
            } else if (dbbc > 2) {
                int n = i;
                atomFlags[n] = atomFlags[n] | 0x804;
            }
            switch (abc) {
                case 0: {
                    continue block5;
                }
                case 1: {
                    int n = i;
                    atomFlags[n] = atomFlags[n] | 8;
                    continue block5;
                }
                case 2: {
                    int n = i;
                    atomFlags[n] = atomFlags[n] | 0x10;
                    continue block5;
                }
                default: {
                    int n = i;
                    atomFlags[n] = atomFlags[n] | 0x20;
                }
            }
        }
        return aSet;
    }

    private void generateDescriptorPairs(BitSet activeAtomSet, int[] grinv, int[] atomFlags) {
        MoleculeGraph m = this.mol;
        int ac = m.getAtomCount();
        int[][] ctab = this.mol.getCtab();
        BitSet aas = (BitSet)activeAtomSet.clone();
        long[] rb = m.getSSSRBondSetInLong();
        this.setRingAtoms(rb, atomFlags, m);
        this.simpleDoubleBondStereo(m, ctab, aas);
        ArrayList<int[]> biphAtrop = StereoRecognizer.biphenilNonTH(m, activeAtomSet, grinv, rb, atomFlags);
        this.stereoGroup.addAll(biphAtrop);
        BondTable btab = m.getBondTable();
        int i = aas.nextSetBit(0);
        while (i >= 0) {
            int n = i;
            atomFlags[n] = atomFlags[n] | StereoRecognizer.calcGrinvDiffs(i, atomFlags[i], ctab[i], grinv, rb, btab);
            i = aas.nextSetBit(i + 1);
        }
        i = aas.nextSetBit(0);
        while (i >= 0) {
            int f = atomFlags[i];
            if ((f & 0x200) != 0) {
                if (StereoRecognizer.isTHStereo(i, m)) {
                    StereoRecognizer.addTetrahedralST(i, m, ctab[i], this.stereoGroup);
                    aas.clear(i);
                }
            } else if ((f & 1) != 0) {
                BitSet used = new BitSet(ac);
                used.set(i);
                StereoRecognizer.locateRigidStrDB(i, m, ctab, atomFlags, this.stereoGroup, 0, aas, rb, used);
            } else if ((f & 0x40) != 0) {
                // empty if block
            }
            i = aas.nextSetBit(i + 1);
        }
    }

    private void setRingAtoms(long[] rb, int[] atomFlags, MoleculeGraph m) {
        int bc = m.getBondCount();
        for (int i = 0; i < bc; ++i) {
            if (!StereoRecognizer.get(i, rb)) continue;
            MolBond b = m.getBond(i);
            int i1 = m.indexOf(b.getAtom1());
            int i2 = m.indexOf(b.getAtom2());
            int n = i1;
            atomFlags[n] = atomFlags[n] | 0x1000;
            int n2 = i2;
            atomFlags[n2] = atomFlags[n2] | 0x1000;
        }
    }

    private static void locateRigidStrDB(int idx, MoleculeGraph m, int[][] ctab, int[] atomFlags, ArrayList<int[]> sg, int rcount, BitSet aas, long[] rb, BitSet used) {
        int[] an = ctab[idx];
        MolAtom a = m.getAtom(idx);
        for (int j = 0; j < an.length; ++j) {
            int a2Idx = an[j];
            MolBond b = a.getBond(j);
            if (b.getType() != 2 || (atomFlags[a2Idx] & 0x800) == 0) continue;
            used.set(a2Idx);
            StereoRecognizer.locateRigidStrThoughDB(a2Idx, idx, m, ctab, atomFlags, sg, rcount + 1, idx, aas, rb, used);
            used.clear(a2Idx);
        }
    }

    private static void locateRigidStrThoughDB(int idx, int idxFrom, MoleculeGraph m, int[][] ctab, int[] atomFlags, ArrayList<int[]> sg, int rcount, int pillar1, BitSet aas, long[] rb, BitSet used) {
        block4: {
            int f;
            int[] an;
            MolAtom a;
            block2: {
                block3: {
                    a = m.getAtom(idx);
                    an = ctab[idx];
                    f = atomFlags[idx];
                    if ((f & 1) == 0) break block2;
                    if ((f & 0x1000) != 0 || !aas.get(idx)) break block3;
                    int pillar2 = idx;
                    used.set(pillar2);
                    StereoRecognizer.addTwoPillarStereoGroup(m, ctab, sg, rcount, aas, pillar1, pillar2, used);
                    break block4;
                }
                if ((f & 0x1000) == 0) break block4;
                StereoRecognizer.locateRigidStrThroughRR(idx, idxFrom, m, ctab, atomFlags, sg, rcount + 1, pillar1, aas, rb, used);
                break block4;
            }
            if ((f & 2) != 0) {
                for (int j = 0; j < an.length; ++j) {
                    int a2Idx = an[j];
                    MolBond b = a.getBond(j);
                    if (a2Idx == idxFrom || b.getType() != 2 || (atomFlags[a2Idx] & 0x800) == 0) continue;
                    used.set(a2Idx);
                    StereoRecognizer.locateRigidStrThoughDB(a2Idx, idx, m, ctab, atomFlags, sg, rcount + 1, pillar1, aas, rb, used);
                    used.clear(a2Idx);
                }
            }
        }
    }

    private static void addTwoPillarStereoGroup(MoleculeGraph m, int[][] ctab, ArrayList<int[]> sg, int rcount, BitSet aas, int pillar1, int pillar2, BitSet used) {
        if (rcount % 2 == 1) {
            StereoRecognizer.addStereoGroupCT(pillar1, pillar2, m, ctab, sg, aas, used);
        } else {
            StereoRecognizer.addStereoGroupAxial(pillar1, pillar2, m, ctab, sg, aas, used);
        }
    }

    private static void locateRigidStrThroughRR(int idx, int idxFrom, MoleculeGraph m, int[][] ctab, int[] atomFlags, ArrayList<int[]> sg, int rcount, int pillar1, BitSet aas, long[] rb, BitSet used) {
        int[] an = ctab[idx];
        if (an.length < 3) {
            return;
        }
        BitSet rFN = StereoRecognizer.locateFacingNodes(idx, idxFrom, used, m, ctab, rb);
        int i = rFN.nextSetBit(0);
        while (i >= 0) {
            if (aas.get(i)) {
                StereoRecognizer.addTwoPillarStereoGroup(m, ctab, sg, rcount, aas, pillar1, i, used);
            }
            i = rFN.nextSetBit(i + 1);
        }
    }

    private static BitSet locateFacingNodes(int idx, int idxFrom, BitSet used, MoleculeGraph m, int[][] ctab, long[] rb) {
        int l = ctab.length;
        BitSet start = new BitSet(l);
        boolean facingnode = false;
        int[] nArr = new int[l];
        BondTable btab = m.getBondTable();
        used.set(idx);
        start.set(idx);
        used.set(idxFrom);
        while (!(facingnode = StereoRecognizer.stepBranch(start, used, nArr, ctab, btab, rb)) && start.cardinality() > 0) {
        }
        BitSet fn = new BitSet();
        for (int i = 0; i < nArr.length; ++i) {
            int j = nArr[i];
            if (j <= 1) continue;
            fn.set(i);
        }
        return fn;
    }

    private static boolean stepBranch(BitSet start, BitSet used, int[] nArr, int[][] ctab, BondTable btab, long[] rb) {
        boolean hasChiralFacingNode = false;
        int i = start.nextSetBit(0);
        while (i >= 0) {
            for (int idx : ctab[i]) {
                int bidx;
                if (used.get(idx) || !StereoRecognizer.get(bidx = btab.getBondIndex(i, idx), rb)) continue;
                int n = idx;
                nArr[n] = nArr[n] + 1;
            }
            i = start.nextSetBit(i + 1);
        }
        start.clear();
        int l = nArr.length;
        for (int i2 = 0; i2 < l; ++i2) {
            int pathCount = nArr[i2];
            if (pathCount <= 0) continue;
            if (pathCount > 1) {
                hasChiralFacingNode = true;
            }
            used.set(i2);
            start.set(i2);
        }
        Arrays.fill(nArr, 0);
        return hasChiralFacingNode;
    }

    private static void addStereoGroupAxial(int pillar1, int pillar2, MoleculeGraph m, int[][] ctab, ArrayList<int[]> sg, BitSet aas, BitSet used) {
        int dim = m.getDim();
        switch (dim) {
            case 2: {
                StereoRecognizer.addStereoGroupAxial2D(pillar1, pillar2, m, ctab, sg, aas, used);
                break;
            }
            case 3: {
                StereoRecognizer.addStereoGroupAxial3D(pillar1, pillar2, m, ctab, sg, aas, used);
                break;
            }
            default: {
                System.err.println("Not supported Molecule dimension.");
            }
        }
    }

    private static void addStereoGroupAxial2D(int pillar1, int pillar2, MoleculeGraph m, int[][] ctab, ArrayList<int[]> sg, BitSet aas, BitSet used) {
        MolBond b3;
        int[] an = ctab[pillar1];
        MolAtom a2 = m.getAtom(pillar1);
        int[] anIdx = StereoRecognizer.getFirstOrWedgeLigandIdx(a2, an, used);
        int firstIdx = anIdx[0];
        int a1Idx = an[firstIdx];
        int a1OIdx = anIdx[1] == -1 ? -1 : an[anIdx[1]];
        MolAtom a1 = a2.getLigand(firstIdx);
        MolBond b1 = a2.getBond(firstIdx);
        an = ctab[pillar2];
        MolAtom a3 = m.getAtom(pillar2);
        anIdx = StereoRecognizer.getFirstOrWedgeLigandIdx(a3, an, used);
        firstIdx = anIdx[0];
        int a4Idx = an[firstIdx];
        int a4OIdx = anIdx[1] == -1 ? -1 : an[anIdx[1]];
        MolAtom a4 = a3.getLigand(firstIdx);
        int p = StereoRecognizer.axialParity(a1, a2, a3, a4, b1, b3 = a3.getBond(firstIdx));
        if (p == 0) {
            return;
        }
        int[] grp = new int[]{3, p, pillar1, pillar2, a1Idx, a4Idx, a1OIdx, a4OIdx};
        sg.add(grp);
        aas.clear(pillar1);
        aas.clear(pillar2);
    }

    private static void addStereoGroupAxial3D(int pillar1, int pillar2, MoleculeGraph m, int[][] ctab, ArrayList<int[]> sg, BitSet aas, BitSet used) {
        MolBond b3;
        int[] an = ctab[pillar1];
        MolAtom a2 = m.getAtom(pillar1);
        int[] anIdx = StereoRecognizer.getFirstLigandIdx(an, used);
        int firstIdx = anIdx[0];
        int a1Idx = an[firstIdx];
        int a1OIdx = anIdx[1] == -1 ? -1 : an[anIdx[1]];
        MolAtom a1 = a2.getLigand(firstIdx);
        MolBond b1 = a2.getBond(firstIdx);
        an = ctab[pillar2];
        MolAtom a3 = m.getAtom(pillar2);
        anIdx = StereoRecognizer.getFirstLigandIdx(an, used);
        firstIdx = anIdx[0];
        int a4Idx = an[firstIdx];
        int a4OIdx = anIdx[1] == -1 ? -1 : an[anIdx[1]];
        MolAtom a4 = a3.getLigand(firstIdx);
        int p = StereoRecognizer.axialParity(a1, a2, a3, a4, b1, b3 = a3.getBond(firstIdx));
        if (p == 0) {
            return;
        }
        int[] grp = new int[]{3, p, pillar1, pillar2, a1Idx, a4Idx, a1OIdx, a4OIdx};
        sg.add(grp);
        aas.clear(pillar1);
        aas.clear(pillar2);
    }

    private static void addStereoGroupCTDB(int pillar1, int pillar2, MoleculeGraph m, int[][] ctab, ArrayList<int[]> sg, BitSet aas) {
        int[] an = ctab[pillar1];
        MolAtom a2 = m.getAtom(pillar1);
        int[] anIdx = StereoRecognizer.getDBFirstLigandIdx(a2);
        int firstIdx = anIdx[0];
        int a1Idx = an[firstIdx];
        int a1OIdx = anIdx[1] == -1 ? -1 : an[anIdx[1]];
        MolAtom a1 = a2.getLigand(firstIdx);
        an = ctab[pillar2];
        MolAtom a3 = m.getAtom(pillar2);
        anIdx = StereoRecognizer.getDBFirstLigandIdx(a3);
        firstIdx = anIdx[0];
        int a4Idx = an[firstIdx];
        int a4Oidx = anIdx[1] == -1 ? -1 : an[anIdx[1]];
        MolAtom a4 = a3.getLigand(firstIdx);
        int[] grp = new int[8];
        grp[0] = 2;
        grp[2] = pillar1;
        grp[3] = pillar2;
        grp[4] = a1Idx;
        grp[5] = a4Idx;
        grp[6] = a1OIdx;
        grp[7] = a4Oidx;
        grp[1] = MolBond.calcStereo2(a1, a2, a3, a4);
        sg.add(grp);
        aas.clear(pillar1);
        aas.clear(pillar2);
    }

    private static void addStereoGroupCT(int pillar1, int pillar2, MoleculeGraph m, int[][] ctab, ArrayList<int[]> sg, BitSet aas, BitSet used) {
        int[] an = ctab[pillar1];
        MolAtom a2 = m.getAtom(pillar1);
        int[] anIdx = StereoRecognizer.getFirstLigandIdx(an, used);
        int firstIdx = anIdx[0];
        int a1Idx = an[firstIdx];
        int a1OIdx = anIdx[1] == -1 ? -1 : an[anIdx[1]];
        MolAtom a1 = a2.getLigand(firstIdx);
        an = ctab[pillar2];
        MolAtom a3 = m.getAtom(pillar2);
        anIdx = StereoRecognizer.getFirstLigandIdx(an, used);
        firstIdx = anIdx[0];
        int a4Idx = an[firstIdx];
        int a4Oidx = anIdx[1] == -1 ? -1 : an[anIdx[1]];
        MolAtom a4 = a3.getLigand(firstIdx);
        int[] grp = new int[8];
        grp[0] = 2;
        grp[2] = pillar1;
        grp[3] = pillar2;
        grp[4] = a1Idx;
        grp[5] = a4Idx;
        grp[6] = a1OIdx;
        grp[7] = a4Oidx;
        grp[1] = MolBond.calcStereo2(a1, a2, a3, a4);
        sg.add(grp);
        aas.clear(pillar1);
        aas.clear(pillar2);
    }

    private static int[] getFirstLigandIdx(int[] an, BitSet used) {
        int[] idxes = new int[2];
        Arrays.fill(idxes, -1);
        int bc = an.length;
        int n = 0;
        for (int i = 0; i < bc; ++i) {
            int idx = an[i];
            if (used.get(idx)) continue;
            idxes[n++] = i;
        }
        return idxes;
    }

    private static int[] getFirstOrWedgeLigandIdx(MolAtom a, int[] an, BitSet used) {
        int[] idxes = new int[2];
        Arrays.fill(idxes, -1);
        int bc = an.length;
        int n = 0;
        for (int i = 0; i < bc; ++i) {
            MolBond b = a.getBond(i);
            int idx = an[i];
            if (used.get(idx)) continue;
            int f = b.getFlags();
            if ((f & 0x30) != 0) {
                if (n == 0) {
                    ++n;
                } else {
                    StereoRecognizer.swap(idxes);
                }
                idxes[0] = i;
                continue;
            }
            idxes[n++] = i;
        }
        return idxes;
    }

    private static int[] getDBFirstLigandIdx(MolAtom a) {
        int[] idxes = new int[2];
        Arrays.fill(idxes, -1);
        int bc = a.getBondCount();
        int n = 0;
        for (int i = 0; i < bc; ++i) {
            MolBond b = a.getBond(i);
            if (b.getType() == 2) continue;
            idxes[n++] = i;
        }
        return idxes;
    }

    private static void swap(int[] x) {
        int v = x[1];
        x[1] = x[0];
        x[0] = v;
    }

    private static ArrayList<int[]> biphenilNonTH(MoleculeGraph m, BitSet aas, int[] grinv, long[] rb, int[] atomFlags) {
        ArrayList<int[]> biphAtrop = new ArrayList<int[]>();
        int[][] ctab = m.getCtab();
        int bc = m.getBondCount();
        for (int i = 0; i < bc; ++i) {
            int p;
            MolBond b3;
            MolBond b1;
            if (StereoRecognizer.get(i, rb)) continue;
            MolBond b = m.getBond(i);
            MolAtom a2 = b.getAtom1();
            int a2idx = m.indexOf(a2);
            MolAtom a3 = b.getAtom2();
            int a3idx = m.indexOf(a3);
            if (b.getType() != 1 || (atomFlags[a2idx] & 0x1000) == 0 || (atomFlags[a3idx] & 0x1000) == 0 || a2.getBondCount() != 3 || a3.getBondCount() != 3) continue;
            int[] values = new int[]{0, -1, -1, 0, 0, 0, -1};
            StereoRecognizer.checkAtropAtomLigand(a2, b, ctab[a2idx], values);
            int n = values[0];
            int ligand1 = values[1];
            int ligandO1 = values[2];
            int ups = values[3];
            int downs = values[4];
            int wiggly = values[5];
            int b1Idx = values[6];
            MolBond molBond = b1 = b1Idx == -1 ? null : a2.getBond(b1Idx);
            if (n <= 1 || ligand1 < 0 || ligandO1 < 0 || grinv[ligand1] == grinv[ligandO1]) continue;
            values[1] = -1;
            values[2] = -1;
            values[6] = -1;
            n = 0;
            StereoRecognizer.checkAtropAtomLigand(a3, b, ctab[a3idx], values);
            n = values[0];
            int ligand4 = values[1];
            int ligandO4 = values[2];
            ups = values[3];
            downs = values[4];
            wiggly = values[5];
            int b3Idx = values[6];
            MolBond molBond2 = b3 = b3Idx == -1 ? null : a3.getBond(b3Idx);
            if (n <= 1 || ligand4 < 0 || ligandO4 < 0 || grinv[ligand4] == grinv[ligandO4]) continue;
            int ortho1 = 0;
            for (int j = 0; j < a2.getBondCount(); ++j) {
                MolAtom o;
                MolBond bl = a2.getBond(j);
                if (bl.getType() != 4 || (o = bl.getOtherAtom(a2)).getBondCount() <= 2) continue;
                ++ortho1;
            }
            if (ortho1 == 0) break;
            int ortho2 = 0;
            for (int j = 0; j < a3.getBondCount(); ++j) {
                MolAtom o;
                MolBond bl = a3.getBond(j);
                if (bl.getType() != 4 || (o = bl.getOtherAtom(a3)).getBondCount() <= 2) continue;
                ++ortho2;
            }
            if (ortho2 == 0) break;
            if (ortho1 <= 1 && ortho2 <= true) continue;
            MolAtom a1 = m.getAtom(ligand1);
            MolAtom a4 = m.getAtom(ligand4);
            int updown = ups + downs;
            int dim = m.getDim();
            int n2 = dim == 2 && (updown > 1 || updown == 0) ? 0 : (p = wiggly > 0 ? 3 : StereoRecognizer.axialParity(a1, a2, a3, a4, b1, b3));
            if (p == 0) continue;
            int[] grp = new int[]{3, p, a2idx, a3idx, ligand1, ligand4, ligandO1, ligandO4};
            biphAtrop.add(grp);
        }
        return biphAtrop;
    }

    private static void checkAtropAtomLigand(MolAtom a1, MolBond b, int[] an, int[] values) {
        int n = 1;
        for (int j = 0; j < a1.getBondCount(); ++j) {
            int f;
            MolBond bl = a1.getBond(j);
            if (b == bl || bl.getType() != 4) continue;
            int lidx = an[j];
            values[n++] = lidx;
            if (values[6] == -1) {
                values[6] = j;
            }
            if ((f = StereoRecognizer.getBondFlag(bl, a1, true)) != 0) {
                if (f == 16) {
                    values[3] = values[3] + 1;
                } else if (f == 32) {
                    values[4] = values[4] + 1;
                } else {
                    values[5] = values[5] + 1;
                }
                values[6] = j;
                if (n > 2) {
                    int v = values[2];
                    values[2] = values[1];
                    values[1] = v;
                }
            }
            values[0] = values[0] + 1;
            if (n <= 3) continue;
            System.err.println("We should not arrive here");
            break;
        }
    }

    private static int axialParity(MolAtom a1, MolAtom a2, MolAtom a3, MolAtom a4, MolBond b1, MolBond b3) {
        int p;
        DPoint3 v1 = new DPoint3(a2.getX() - a1.getX(), a2.getY() - a1.getY(), a2.getZ() - a1.getZ());
        DPoint3 v2 = new DPoint3(a2.getX() - a3.getX(), a2.getY() - a3.getY(), a2.getZ() - a3.getZ());
        DPoint3 v3 = new DPoint3(a3.getX() - a4.getX(), a3.getY() - a4.getY(), a3.getZ() - a4.getZ());
        int dim = v1.z == 0.0 && v2.z == 0.0 && v3.z == 0.0 ? 2 : 3;
        int f = StereoRecognizer.getBondFlag(b1, a2, true);
        if (f != 0 && v1.z == 0.0) {
            if (f == 16) {
                v1.z = 1.0;
            } else if (f == 32) {
                v1.z = -1.0;
            } else {
                return 3;
            }
        }
        if ((f = StereoRecognizer.getBondFlag(b3, a3, true)) != 0 && v3.z == 0.0) {
            if (f == 16) {
                v3.z = 1.0;
            } else if (f == 32) {
                v3.z = -1.0;
            } else {
                return 3;
            }
        }
        p = (p = StereoRecognizer.determinantToParity(v1.x, v1.y, v1.z, v2.x, v2.y, v2.z, v3.x, v3.y, v3.z, dim)) == 3 ? 0 : p;
        return p;
    }

    private static boolean isTHStereo(int idx, MoleculeGraph m) {
        MolAtom a = m.getAtom(idx);
        int atno = a.getAtno();
        boolean centerS = atno == 16 || atno == 15 || atno == 7;
        int l = a.getBondCount();
        int dbbc = 0;
        for (int i = 0; i < l; ++i) {
            MolBond b = a.getBond(i);
            int t = b.getType();
            if (t == 2) {
                ++dbbc;
                if (centerS) {
                    MolAtom n = a.getLigand(i);
                    if (dbbc <= 2 && (n.getBondCount() == 1 || n.getCharge() != 0)) continue;
                    return false;
                }
                return false;
            }
            if (t <= 2) continue;
            return false;
        }
        return true;
    }

    private static void addTetrahedralST(int idx, MoleculeGraph m, int[] an, ArrayList<int[]> strg) {
        MolAtom a = m.getAtom(idx);
        int bc = a.getBondCount();
        int p = m.getLocalParity(idx);
        if (p == 0) {
            return;
        }
        int[] g = new int[bc + 3];
        g[0] = 1;
        g[1] = p;
        g[2] = idx;
        for (int i = 0; i < an.length; ++i) {
            g[3 + i] = an[i];
        }
        strg.add(g);
    }

    private void simpleDoubleBondStereo(MoleculeGraph m, int[][] ctab, BitSet aas) {
        int bc = m.getBondCount();
        for (int i = 0; i < bc; ++i) {
            MolBond b = m.getBond(i);
            int t = b.getType();
            if (t != 2) continue;
            MolAtom a2 = b.getAtom1();
            int a2idx = m.indexOf(a2);
            MolAtom a3 = b.getAtom2();
            int a3idx = m.indexOf(a3);
            if (!aas.get(a2idx) || !aas.get(a3idx)) continue;
            StereoRecognizer.addStereoGroupCTDB(a2idx, a3idx, m, ctab, this.stereoGroup, aas);
        }
    }

    private static int calcGrinvDiffs(int idx, int atomFlag, int[] an, int[] grinv, long[] rb, BondTable btab) {
        int MORE_COMMON_GRINV = -5;
        int f = 0;
        int n = (atomFlag & 1) != 0 ? 3 : 4;
        int commonRB = 0;
        int commonGrinv = -1;
        boolean ra = false;
        int l = an.length;
        for (int i = 0; i < l; ++i) {
            int v1 = grinv[an[i]];
            int bidx = btab.getBondIndex(idx, an[i]);
            boolean rb1 = StereoRecognizer.get(bidx, rb);
            ra |= rb1;
            if (v1 == -1 && l < 4) {
                return 0;
            }
            for (int j = i + 1; j < l; ++j) {
                int v2 = grinv[an[j]];
                bidx = btab.getBondIndex(idx, an[i]);
                boolean rb2 = StereoRecognizer.get(bidx, rb);
                ra |= rb2;
                if (v1 != v2) continue;
                --n;
                if (rb1 && rb2) {
                    ++commonRB;
                }
                if (commonGrinv == -1) {
                    commonGrinv = v1;
                    continue;
                }
                if (commonGrinv == v1) continue;
                commonGrinv = MORE_COMMON_GRINV;
            }
        }
        f |= ra ? 6144 : 0;
        block0 : switch (commonRB) {
            case 1: {
                f |= 0x40;
                break;
            }
            case 2: {
                if (commonGrinv == MORE_COMMON_GRINV) {
                    f |= 0x100;
                    break;
                }
                System.err.println("We should not have COMMON_RINGBOND_3");
                f |= 0x80;
                break;
            }
            default: {
                switch (n) {
                    case 4: {
                        f |= 0x200;
                        break block0;
                    }
                    case 3: {
                        f |= 0x400;
                    }
                }
            }
        }
        return f;
    }

    private static boolean threeDifferent(int[] g) {
        int l = g.length;
        int n = 1;
        for (int i = 0; i < l; ++i) {
            int v1 = g[i];
            for (int j = i + 1; j < l; ++j) {
                if (v1 == g[j]) {
                    ++n;
                }
                if (n <= 2) continue;
                return false;
            }
        }
        return true;
    }

    private static int getBondFlag(MolBond b, MolAtom c, boolean useOnlyFirstAtom) {
        int f = b.getStereo1(c);
        if (useOnlyFirstAtom && b.getAtom1() != c) {
            f = 0;
        }
        return f;
    }

    private static boolean get(int n, long[] r) {
        return (r[n / 64] & 1L << 63 - n % 64) != 0L;
    }

    static int determinantToParity(double ax, double ay, double az, double bx, double by, double bz, double cx, double cy, double cz, int dim) {
        double rot;
        double ab_x = ay * bz - az * by;
        double ab_y = az * bx - ax * bz;
        double ab_z = ax * by - ay * bx;
        double ac_x = ay * cz - az * cy;
        double ac_y = az * cx - ax * cz;
        double ac_z = ax * cy - ay * cx;
        double a_sq = ax * ax + ay * ay + az * az;
        double b_sq = bx * bx + by * by + bz * bz;
        double c_sq = cx * cx + cy * cy + cz * cz;
        if (dim > 2) {
            double dz;
            double dy;
            double ac_l;
            double ab_sq = ab_x * ab_x + ab_y * ab_y + ab_z * ab_z;
            double ac_sq = ac_x * ac_x + ac_y * ac_y + ac_z * ac_z;
            double ab_l = Math.sqrt(ab_sq);
            double dx = ab_x / ab_l - ac_x / (ac_l = Math.sqrt(ac_sq));
            double distance = Math.sqrt(dx * dx + (dy = ab_y / ab_l - ac_y / ac_l) * dy + (dz = ab_z / ab_l - ac_z / ac_l) * dz);
            double d = distance = distance < Math.abs(distance - 2.0) ? distance : Math.abs(distance - 2.0);
            if (distance < 0.1) {
                return 3;
            }
        }
        if ((rot = ab_x * cx + ab_y * cy + ab_z * cz) * rot < 1.0E-16 * a_sq * b_sq * c_sq) {
            return 3;
        }
        return rot > 0.0 ? 2 : 1;
    }

    private static String toString(int[] v) {
        int CIS = 128;
        int TRANS = 64;
        StringBuffer sb = new StringBuffer();
        int g = v[0];
        sb.append(g == 1 ? "TH " : (g == 2 ? "CT " : "?? "));
        g = v[1];
        sb.append(g == CIS ? "CIS " : (g == TRANS ? "TRANS " : (g == 1 ? "ODD " : (g == 2 ? "EVEN " : "?? "))));
        for (int i = 2; i < v.length; ++i) {
            sb.append(v[i] + " ");
        }
        return sb.toString();
    }

    private static String toStringFlag(int f) {
        StringBuffer sb = new StringBuffer();
        sb.append((f & 1) != 0 ? " ONE_DB_BOND" : "");
        sb.append((f & 2) != 0 ? " TWO_DB_BOND" : "");
        sb.append((f & 4) != 0 ? " MORE_DB_BOND" : "");
        sb.append((f & 8) != 0 ? " ONE_AROM_BOND" : "");
        sb.append((f & 0x10) != 0 ? " TWO_AROM_BOND" : "");
        sb.append((f & 0x20) != 0 ? " MORE_AROM_BOND" : "");
        sb.append((f & 0x40) != 0 ? " HASWEDGE" : "");
        sb.append((f & 0x40) != 0 ? " GRINV_COMMON_RINGBON_2" : "");
        sb.append((f & 0x80) != 0 ? " GRINV_COMMON_RINGBON_3" : "");
        sb.append((f & 0x100) != 0 ? " GRINV_MORE_COMMON_IN_RING" : "");
        sb.append((f & 0x200) != 0 ? " FOUR_DIFF_GRINV" : "");
        sb.append((f & 0x400) != 0 ? " THREE_DIFF_GRINV" : "");
        sb.append((f & 0x800) != 0 ? " RIGID" : "");
        sb.append((f & 0x1000) != 0 ? " RINGATOM" : "");
        return sb.toString();
    }
}

