/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.calculations.training;

import chemaxon.calculations.training.AtomicContributionBasedPreProcessor;
import chemaxon.calculations.training.DescriptorMatrix;
import chemaxon.calculations.training.FittingAlgorithm;
import chemaxon.calculations.training.ParallelTrainer;
import chemaxon.calculations.training.SVDTrainingResult;
import chemaxon.calculations.training.TrainerUtils;
import chemaxon.calculations.training.TrainingModel;
import chemaxon.marvin.io.MPropHandler;
import chemaxon.struc.Molecule;
import java.io.IOException;

public class AtomicContributionBasedTrainer
extends ParallelTrainer<Molecule, SVDTrainingResult> {
    public AtomicContributionBasedTrainer(FittingAlgorithm<SVDTrainingResult> algorithm, DescriptorMatrix descriptorMatrix, TrainingModel<Molecule> ... models) {
        super(algorithm, descriptorMatrix, models);
        this.setPreprocessor(new AtomicContributionBasedPreProcessor());
    }

    public AtomicContributionBasedTrainer(FittingAlgorithm<SVDTrainingResult> algorithm, DescriptorMatrix descriptorMatrix, TrainingModel<Molecule> model) {
        super(algorithm, descriptorMatrix, model);
        this.setPreprocessor(new AtomicContributionBasedPreProcessor());
    }

    public void add(Molecule molecule, String propertyName) {
        try {
            this.add(molecule, Double.parseDouble(MPropHandler.convertToString(molecule.properties(), propertyName)));
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Invalid molecular property value.");
        }
    }

    public void saveResults(String trainingType, String trainingName) throws IOException {
        TrainerUtils.saveParameters(trainingType, trainingName, this);
    }
}

